// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import co.elastic.clients.elasticsearch._types.SortOrder;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlasGlossaryType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a glossary in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class Glossary extends Asset implements IGlossary, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Glossary.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossary";
    /**
     * Fixed typeName for Glossarys.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    Map<String, String> additionalAttributes;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryCategory> categories;
    /**
     * TBC
     */
    @Attribute
    AtlasGlossaryType glossaryType;
    /**
     * TBC
     */
    @Attribute
    String language;
    /**
     * TBC
     */
    @Attribute
    String longDescription;
    /**
     * TBC
     */
    @Attribute
    String shortDescription;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> terms;
    /**
     * TBC
     */
    @Attribute
    String usage;

    /**
     * Builds the minimal object necessary to create a relationship to a Glossary, from a potentially
     * more-complete Glossary object.
     *
     * @return the minimal object necessary to relate to the Glossary
     * @throws InvalidRequestException if any of the minimal set of required properties for a Glossary relationship are not found in the initial object
     */
    @Override
    public Glossary trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Glossary assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Glossary assets will be included.
     *
     * @return a fluent search that includes all Glossary assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Glossary assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Glossary assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Glossary assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Glossary assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Glossarys will be included
     * @return a fluent search that includes all Glossary assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Glossary assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Glossarys will be included
     * @return a fluent search that includes all Glossary assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Glossary by GUID. Use this to create a relationship to this Glossary,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Glossary to reference
     * @return reference to a Glossary that can be used for defining a relationship to a Glossary
     */
    public static Glossary refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Glossary by GUID. Use this to create a relationship to this Glossary,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Glossary to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Glossary that can be used for defining a relationship to a Glossary
     */
    public static Glossary refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Glossary._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Glossary by qualifiedName. Use this to create a relationship to this Glossary,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Glossary to reference
     * @return reference to a Glossary that can be used for defining a relationship to a Glossary
     */
    public static Glossary refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Glossary by qualifiedName. Use this to create a relationship to this Glossary,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Glossary to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Glossary that can be used for defining a relationship to a Glossary
     */
    public static Glossary refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Glossary._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Glossary by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Glossary to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Glossary, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Glossary does not exist or the provided GUID is not a Glossary
     */
    @JsonIgnore
    public static Glossary get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Glossary by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Glossary to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Glossary, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Glossary does not exist or the provided GUID is not a Glossary
     */
    @JsonIgnore
    public static Glossary get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Glossary by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Glossary to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Glossary, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Glossary does not exist or the provided GUID is not a Glossary
     */
    @JsonIgnore
    public static Glossary get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Glossary) {
                return (Glossary) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Glossary) {
                return (Glossary) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Glossary to active.
     *
     * @param qualifiedName for the Glossary
     * @return true if the Glossary is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Glossary to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Glossary
     * @return true if the Glossary is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary for creating a Glossary.
     *
     * @param name of the Glossary
     * @return the minimal object necessary to create the Glossary, as a builder
     */
    public static GlossaryBuilder<?, ?> creator(String name) {
        return Glossary._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(name).name(name);
    }

    /**
     * Builds the minimal object necessary to update a Glossary.
     *
     * @param guid unique identifier of the Glossary
     * @param name of the Glossary
     * @return the minimal object necessary to update the Glossary, as a builder
     */
    public static GlossaryBuilder<?, ?> updater(String guid, String name) {
        return Glossary._internal().guid(guid).qualifiedName(name).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Glossary, from a potentially
     * more-complete Glossary object.
     *
     * @return the minimal object necessary to update the Glossary, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Glossary are not found in the initial object
     */
    @Override
    public GlossaryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("guid", this.getGuid(), "name", this.getName()));
        return updater(this.getGuid(), this.getName());
    }

    /**
     * Find a Glossary by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the glossary, if found.
     *
     * @param name of the Glossary
     * @return the Glossary, if found
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public static Glossary findByName(String name) throws AtlanException {
        return findByName(name, (List<AtlanField>) null);
    }

    /**
     * Find a Glossary by its human-readable name.
     *
     * @param name of the Glossary
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the Glossary
     * @return the Glossary, if found
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public static Glossary findByName(String name, Collection<String> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, attributes);
    }

    /**
     * Find a Glossary by its human-readable name.
     *
     * @param name of the Glossary
     * @param attributes an optional collection of attributes (checked) to retrieve for the Glossary
     * @return the Glossary, if found
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public static Glossary findByName(String name, List<AtlanField> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, attributes);
    }

    /**
     * Find a Glossary by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the glossary, if found.
     *
     * @param client connectivity to the Atlan tenant on which to search for the Glossary
     * @param name of the Glossary
     * @return the Glossary, if found
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public static Glossary findByName(AtlanClient client, String name) throws AtlanException {
        return findByName(client, name, (List<AtlanField>) null);
    }

    /**
     * Find a Glossary by its human-readable name.
     *
     * @param client connectivity to the Atlan tenant on which to search for the Glossary
     * @param name of the Glossary
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the Glossary
     * @return the Glossary, if found
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public static Glossary findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        List<Glossary> results = new ArrayList<>();
        Glossary.select(client).where(Glossary.NAME.eq(name))._includesOnResults(attributes == null ? Collections.emptyList() : attributes).includeOnRelations(Asset.NAME).pageSize(2).stream().limit(2).filter(a -> a instanceof Glossary).forEach(g -> results.add((Glossary) g));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        } else if (results.size() > 1) {
            log.warn("Multiple glossaries found with the name \'{}\', returning only the first.", name);
        }
        return results.get(0);
    }

    /**
     * Find a Glossary by its human-readable name.
     *
     * @param client connectivity to the Atlan tenant on which to search for the Glossary
     * @param name of the Glossary
     * @param attributes an optional collection of attributes (checked) to retrieve for the Glossary
     * @return the Glossary, if found
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public static Glossary findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        List<Glossary> results = new ArrayList<>();
        Glossary.select(client).where(Glossary.NAME.eq(name)).includesOnResults(attributes == null ? Collections.emptyList() : attributes).includeOnRelations(Asset.NAME).pageSize(2).stream().limit(2).filter(a -> a instanceof Glossary).forEach(g -> results.add((Glossary) g));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        } else if (results.size() > 1) {
            log.warn("Multiple glossaries found with the name \'{}\', returning only the first.", name);
        }
        return results.get(0);
    }

    /**
     * Retrieve the qualifiedNames of all glossaries that exist in Atlan.
     *
     * @return list of all glossary qualifiedNames
     * @throws AtlanException on any API problems
     */
    public static List<String> getAllQualifiedNames() throws AtlanException {
        return getAllQualifiedNames(Atlan.getDefaultClient());
    }

    /**
     * Retrieve the qualifiedNames of all glossaries that exist in Atlan.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the qualifiedNames
     * @return list of all glossary qualifiedNames
     * @throws AtlanException on any API problems
     */
    public static List<String> getAllQualifiedNames(AtlanClient client) throws AtlanException {
        return Glossary.select(client).includeOnResults(Glossary.QUALIFIED_NAME).pageSize(50).stream().map(Asset::getQualifiedName).collect(Collectors.toList());
    }

    /**
     * Retrieve category hierarchy in this Glossary, in a traversable form. You can traverse in either
     * depth-first ({@link CategoryHierarchy#depthFirst()}) or breadth-first ({@link CategoryHierarchy#breadthFirst()})
     * order. Both return an ordered list of {@link GlossaryCategory} objects.
     *
     * @return a traversable category hierarchy
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public CategoryHierarchy getHierarchy() throws AtlanException {
        return getHierarchy(Atlan.getDefaultClient());
    }

    /**
     * Retrieve category hierarchy in this Glossary, in a traversable form. You can traverse in either
     * depth-first ({@link CategoryHierarchy#depthFirst()}) or breadth-first ({@link CategoryHierarchy#breadthFirst()})
     * order. Both return an ordered list of {@link GlossaryCategory} objects.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the hierarchy
     * @return a traversable category hierarchy
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public CategoryHierarchy getHierarchy(AtlanClient client) throws AtlanException {
        return getHierarchy(client, (List<AtlanField>) null);
    }

    /**
     * Retrieve category hierarchy in this Glossary, in a traversable form. You can traverse in either
     * depth-first ({@link CategoryHierarchy#depthFirst()}) or breadth-first ({@link CategoryHierarchy#breadthFirst()})
     * order. Both return an ordered list of {@link GlossaryCategory} objects.
     * Note: by default, each category will have a minimal set of information (name, GUID, qualifiedName). If you
     * want additional details about each category, specify the attributes you want in the {@code attributes} parameter
     * to this method.
     *
     * @param attributes (unchecked) to retrieve for each category in the hierarchy
     * @return a traversable category hierarchy
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public CategoryHierarchy getHierarchy(Collection<String> attributes) throws AtlanException {
        return getHierarchy(Atlan.getDefaultClient(), attributes);
    }

    /**
     * Retrieve category hierarchy in this Glossary, in a traversable form. You can traverse in either
     * depth-first ({@link CategoryHierarchy#depthFirst()}) or breadth-first ({@link CategoryHierarchy#breadthFirst()})
     * order. Both return an ordered list of {@link GlossaryCategory} objects.
     * Note: by default, each category will have a minimal set of information (name, GUID, qualifiedName). If you
     * want additional details about each category, specify the attributes you want in the {@code attributes} parameter
     * to this method.
     *
     * @param attributes (checked) to retrieve for each category in the hierarchy
     * @return a traversable category hierarchy
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public CategoryHierarchy getHierarchy(List<AtlanField> attributes) throws AtlanException {
        return getHierarchy(Atlan.getDefaultClient(), attributes);
    }

    /**
     * Retrieve category hierarchy in this Glossary, in a traversable form. You can traverse in either
     * depth-first ({@link CategoryHierarchy#depthFirst()}) or breadth-first ({@link CategoryHierarchy#breadthFirst()})
     * order. Both return an ordered list of {@link GlossaryCategory} objects.
     * Note: by default, each category will have a minimal set of information (name, GUID, qualifiedName). If you
     * want additional details about each category, specify the attributes you want in the {@code attributes} parameter
     * to this method.
     *
     * @param attributes (checked) to retrieve for each category in the hierarchy
     * @param relatedAttributes (checked) to retrieve for each relationship attribute retrieved for each category in the hierarchy
     * @return a traversable category hierarchy
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public CategoryHierarchy getHierarchy(List<AtlanField> attributes, List<AtlanField> relatedAttributes) throws AtlanException {
        return getHierarchy(Atlan.getDefaultClient(), attributes, relatedAttributes);
    }

    /**
     * Retrieve category hierarchy in this Glossary, in a traversable form. You can traverse in either
     * depth-first ({@link CategoryHierarchy#depthFirst()}) or breadth-first ({@link CategoryHierarchy#breadthFirst()})
     * order. Both return an ordered list of {@link GlossaryCategory} objects.
     * Note: by default, each category will have a minimal set of information (name, GUID, qualifiedName). If you
     * want additional details about each category, specify the attributes you want in the {@code attributes} parameter
     * to this method.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the hierarchy
     * @param attributes (unchecked) to retrieve for each category in the hierarchy
     * @return a traversable category hierarchy
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public CategoryHierarchy getHierarchy(AtlanClient client, Collection<String> attributes) throws AtlanException {
        if (qualifiedName == null) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_QUERY_PARAM, Glossary.TYPE_NAME, "qualifiedName");
        }
        Set<String> topCategories = new LinkedHashSet<>();
        Map<String, GlossaryCategory> categoryMap = new HashMap<>();
        GlossaryCategory.select(client).where(GlossaryCategory.ANCHOR.eq(getQualifiedName())).includeOnResults(GlossaryCategory.PARENT_CATEGORY)._includesOnResults(attributes == null ? Collections.emptyList() : attributes).sort(GlossaryCategory.NAME.order(SortOrder.Asc)).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> {
            GlossaryCategory category = (GlossaryCategory) c;
            categoryMap.put(category.getGuid(), category);
            if (category.getParentCategory() == null) {
                topCategories.add(category.getGuid());
            }
        });
        if (topCategories.isEmpty()) {
            throw new NotFoundException(ErrorCode.NO_CATEGORIES, getGuid(), getQualifiedName());
        }
        return new CategoryHierarchy(topCategories, categoryMap);
    }

    /**
     * Retrieve category hierarchy in this Glossary, in a traversable form. You can traverse in either
     * depth-first ({@link CategoryHierarchy#depthFirst()}) or breadth-first ({@link CategoryHierarchy#breadthFirst()})
     * order. Both return an ordered list of {@link GlossaryCategory} objects.
     * Note: by default, each category will have a minimal set of information (name, GUID, qualifiedName). If you
     * want additional details about each category, specify the attributes you want in the {@code attributes} parameter
     * to this method.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the hierarchy
     * @param attributes (checked) to retrieve for each category in the hierarchy
     * @return a traversable category hierarchy
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public CategoryHierarchy getHierarchy(AtlanClient client, List<AtlanField> attributes) throws AtlanException {
        return getHierarchy(client, attributes, null);
    }

    /**
     * Retrieve category hierarchy in this Glossary, in a traversable form. You can traverse in either
     * depth-first ({@link CategoryHierarchy#depthFirst()}) or breadth-first ({@link CategoryHierarchy#breadthFirst()})
     * order. Both return an ordered list of {@link GlossaryCategory} objects.
     * Note: by default, each category will have a minimal set of information (name, GUID, qualifiedName). If you
     * want additional details about each category, specify the attributes you want in the {@code attributes} parameter
     * to this method.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the hierarchy
     * @param attributes (checked) to retrieve for each category in the hierarchy
     * @param relatedAttributes (checked) to retrieve for each relationship attribute retrieved for each category in the hierarchy
     * @return a traversable category hierarchy
     * @throws AtlanException on any API problems, or if the Glossary does not exist
     */
    public CategoryHierarchy getHierarchy(AtlanClient client, List<AtlanField> attributes, List<AtlanField> relatedAttributes) throws AtlanException {
        if (qualifiedName == null) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_QUERY_PARAM, Glossary.TYPE_NAME, "qualifiedName");
        }
        Set<String> topCategories = new LinkedHashSet<>();
        Map<String, GlossaryCategory> categoryMap = new HashMap<>();
        GlossaryCategory.select(client).where(GlossaryCategory.ANCHOR.eq(getQualifiedName())).includeOnResults(GlossaryCategory.PARENT_CATEGORY).includesOnResults(attributes == null ? Collections.emptyList() : attributes).includesOnRelations(relatedAttributes == null ? Collections.emptyList() : relatedAttributes).sort(GlossaryCategory.NAME.order(SortOrder.Asc)).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> {
            GlossaryCategory category = (GlossaryCategory) c;
            categoryMap.put(category.getGuid(), category);
            if (category.getParentCategory() == null) {
                topCategories.add(category.getGuid());
            }
        });
        if (topCategories.isEmpty()) {
            throw new NotFoundException(ErrorCode.NO_CATEGORIES, getGuid(), getQualifiedName());
        }
        return new CategoryHierarchy(topCategories, categoryMap);
    }


    /**
     * Utility class for traversing the category hierarchy in a Glossary.
     */
    public static class CategoryHierarchy {
        private final Set<String> topLevel;
        private final List<GlossaryCategory> rootCategories;
        private final Map<String, GlossaryCategory> map;

        private CategoryHierarchy(Set<String> topLevel, Map<String, GlossaryCategory> stubMap) {
            this.topLevel = topLevel;
            this.rootCategories = new ArrayList<>();
            this.map = new LinkedHashMap<>();
            buildMaps(stubMap);
        }

        private void buildMaps(Map<String, GlossaryCategory> stubMap) {
            for (Map.Entry<String, GlossaryCategory> entry : stubMap.entrySet()) {
                GlossaryCategory category = entry.getValue();
                IGlossaryCategory parent = category.getParentCategory();
                if (parent != null) {
                    String parentGuid = parent.getGuid();
                    GlossaryCategory fullParent = map.getOrDefault(parentGuid, stubMap.get(parentGuid));
                    SortedSet<IGlossaryCategory> children = new TreeSet<>(fullParent.getChildrenCategories());
                    children.add(category);
                    fullParent.setChildrenCategories(children);
                    map.put(parent.getGuid(), fullParent);
                }
                map.put(category.getGuid(), category);
            }
        }

        /**
         * Retrieve a specific category from anywhere in the hierarchy by its unique identifier (GUID).
         *
         * @param guid of the category to retrieve
         * @return the requested category
         */
        public GlossaryCategory getCategory(String guid) {
            return map.get(guid);
        }

        /**
         * Retrieve only the root-level categories (those with no parents).
         *
         * @return the root-level categories of the Glossary
         */
        public List<IGlossaryCategory> getRootCategories() {
            if (rootCategories.isEmpty()) {
                for (String top : topLevel) {
                    rootCategories.add(map.get(top));
                }
            }
            return Collections.unmodifiableList(rootCategories);
        }

        /**
         * Retrieve all the categories in the hierarchy in breadth-first traversal order.
         *
         * @return all categories in breadth-first order
         */
        public List<IGlossaryCategory> breadthFirst() {
            List<IGlossaryCategory> top = getRootCategories();
            List<IGlossaryCategory> all = new ArrayList<>(top);
            bfs(all, top);
            return Collections.unmodifiableList(all);
        }

        /**
         * Retrieve all the categories in the hierarchy in depth-first traversal order.
         *
         * @return all categories in depth-first order
         */
        public List<IGlossaryCategory> depthFirst() {
            List<IGlossaryCategory> all = new ArrayList<>();
            dfs(all, getRootCategories());
            return Collections.unmodifiableList(all);
        }

        private void bfs(List<IGlossaryCategory> list, Collection<IGlossaryCategory> toAdd) {
            for (IGlossaryCategory node : toAdd) {
                list.addAll(node.getChildrenCategories());
            }
            for (IGlossaryCategory node : toAdd) {
                bfs(list, node.getChildrenCategories());
            }
        }

        private void dfs(List<IGlossaryCategory> list, Collection<IGlossaryCategory> toAdd) {
            for (IGlossaryCategory node : toAdd) {
                list.add(node);
                dfs(list, node.getChildrenCategories());
            }
        }
    }

    /**
     * Remove the system description from a Glossary.
     *
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Glossary.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Glossary's description
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary) Asset.removeDescription(client, _internal().qualifiedName(qualifiedName).name(name));
    }

    /**
     * Remove the user's description from a Glossary.
     *
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Glossary.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Glossary's description
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary) Asset.removeUserDescription(client, _internal().qualifiedName(qualifiedName).name(name));
    }

    /**
     * Remove the owners from a Glossary.
     *
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a Glossary.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Glossary's owners
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary) Asset.removeOwners(client, _internal().qualifiedName(qualifiedName).name(name));
    }

    /**
     * Update the certificate on a Glossary.
     *
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Glossary, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Glossary updateCertificate(String qualifiedName, String name, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, name, certificate, message);
    }

    /**
     * Update the certificate on a Glossary.
     *
     * @param client connectivity to the Atlan client on which to update the Glossary's certificate
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Glossary, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Glossary updateCertificate(AtlanClient client, String qualifiedName, String name, CertificateStatus certificate, String message) throws AtlanException {
        return (Glossary) Asset.updateCertificate(client, _internal().name(name), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a Glossary.
     *
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a Glossary.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Glossary's certificate
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary) Asset.removeCertificate(client, _internal().qualifiedName(qualifiedName).name(name));
    }

    /**
     * Update the announcement on a Glossary.
     *
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Glossary updateAnnouncement(String qualifiedName, String name, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, type, title, message);
    }

    /**
     * Update the announcement on a Glossary.
     *
     * @param client connectivity to the Atlan tenant on which to update the Glossary's announcement
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Glossary updateAnnouncement(AtlanClient client, String qualifiedName, String name, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Glossary) Asset.updateAnnouncement(client, _internal().name(name), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a Glossary.
     *
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a Glossary.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Glossary's announcement
     * @param qualifiedName of the Glossary
     * @param name of the Glossary
     * @return the updated Glossary, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Glossary removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Glossary) Asset.removeAnnouncement(client, _internal().qualifiedName(qualifiedName).name(name));
    }

    /**
     * Add Atlan tags to a Glossary, without replacing existing Atlan tags linked to the Glossary.
     * Note: this operation must make two API calls — one to retrieve the Glossary's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Glossary
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Glossary
     */
    public static Glossary appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Glossary, without replacing existing Atlan tags linked to the Glossary.
     * Note: this operation must make two API calls — one to retrieve the Glossary's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Glossary
     * @param qualifiedName of the Glossary
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Glossary
     */
    public static Glossary appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Glossary) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Glossary, without replacing existing Atlan tags linked to the Glossary.
     * Note: this operation must make two API calls — one to retrieve the Glossary's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Glossary
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Glossary
     */
    public static Glossary appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Glossary, without replacing existing Atlan tags linked to the Glossary.
     * Note: this operation must make two API calls — one to retrieve the Glossary's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Glossary
     * @param qualifiedName of the Glossary
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Glossary
     */
    public static Glossary appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Glossary) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Glossary.
     *
     * @param qualifiedName of the Glossary
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Glossary
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Glossary.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Glossary
     * @param qualifiedName of the Glossary
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Glossary
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class GlossaryBuilder<C extends Glossary, B extends Glossary.GlossaryBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> additionalAttributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> additionalAttributes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryCategory> categories;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlasGlossaryType glossaryType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String language;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String longDescription;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String shortDescription;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> terms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String usage;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Glossary.GlossaryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Glossary instance, final Glossary.GlossaryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalAttributes(instance.additionalAttributes == null ? java.util.Collections.<String, String>emptyMap() : instance.additionalAttributes);
            b.categories(instance.categories == null ? java.util.Collections.<IGlossaryCategory>emptySortedSet() : instance.categories);
            b.glossaryType(instance.glossaryType);
            b.language(instance.language);
            b.longDescription(instance.longDescription);
            b.shortDescription(instance.shortDescription);
            b.terms(instance.terms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.terms);
            b.usage(instance.usage);
        }

        /**
         * Fixed typeName for Glossarys.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalAttribute(final String additionalAttributeKey, final String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new java.util.ArrayList<String>();
                this.additionalAttributes$value = new java.util.ArrayList<String>();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalAttributes(final java.util.Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new java.lang.NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new java.util.ArrayList<String>();
                this.additionalAttributes$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B category(final IGlossaryCategory category) {
            if (this.categories == null) this.categories = new java.util.ArrayList<IGlossaryCategory>();
            this.categories.add(category);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B categories(final java.util.Collection<? extends IGlossaryCategory> categories) {
            if (categories == null) {
                throw new java.lang.NullPointerException("categories cannot be null");
            }
            if (this.categories == null) this.categories = new java.util.ArrayList<IGlossaryCategory>();
            this.categories.addAll(categories);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCategories() {
            if (this.categories != null) this.categories.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B glossaryType(final AtlasGlossaryType glossaryType) {
            this.glossaryType = glossaryType;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B language(final String language) {
            this.language = language;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B longDescription(final String longDescription) {
            this.longDescription = longDescription;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B shortDescription(final String shortDescription) {
            this.shortDescription = shortDescription;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B term(final IGlossaryTerm term) {
            if (this.terms == null) this.terms = new java.util.ArrayList<IGlossaryTerm>();
            this.terms.add(term);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B terms(final java.util.Collection<? extends IGlossaryTerm> terms) {
            if (terms == null) {
                throw new java.lang.NullPointerException("terms cannot be null");
            }
            if (this.terms == null) this.terms = new java.util.ArrayList<IGlossaryTerm>();
            this.terms.addAll(terms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTerms() {
            if (this.terms != null) this.terms.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B usage(final String usage) {
            this.usage = usage;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Glossary.GlossaryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalAttributes$key=" + this.additionalAttributes$key + ", additionalAttributes$value=" + this.additionalAttributes$value + ", categories=" + this.categories + ", glossaryType=" + this.glossaryType + ", language=" + this.language + ", longDescription=" + this.longDescription + ", shortDescription=" + this.shortDescription + ", terms=" + this.terms + ", usage=" + this.usage + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class GlossaryBuilderImpl extends Glossary.GlossaryBuilder<Glossary, Glossary.GlossaryBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private GlossaryBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Glossary.GlossaryBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Glossary build() {
            return new Glossary(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Glossary(final Glossary.GlossaryBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Glossary.$default$typeName();
        java.util.Map<String, String> additionalAttributes;
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
        case 0: 
            additionalAttributes = java.util.Collections.emptyMap();
            break;
        case 1: 
            additionalAttributes = java.util.Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
            break;
        default: 
            additionalAttributes = new java.util.LinkedHashMap<String, String>(b.additionalAttributes$key.size() < 1073741824 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.additionalAttributes$key.size(); $i++) additionalAttributes.put(b.additionalAttributes$key.get($i), (String) b.additionalAttributes$value.get($i));
            additionalAttributes = java.util.Collections.unmodifiableMap(additionalAttributes);
        }
        this.additionalAttributes = additionalAttributes;
        java.util.SortedSet<IGlossaryCategory> categories = new java.util.TreeSet<IGlossaryCategory>();
        if (b.categories != null) categories.addAll(b.categories);
        categories = java.util.Collections.unmodifiableSortedSet(categories);
        this.categories = categories;
        this.glossaryType = b.glossaryType;
        this.language = b.language;
        this.longDescription = b.longDescription;
        this.shortDescription = b.shortDescription;
        java.util.SortedSet<IGlossaryTerm> terms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.terms != null) terms.addAll(b.terms);
        terms = java.util.Collections.unmodifiableSortedSet(terms);
        this.terms = terms;
        this.usage = b.usage;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Glossary.GlossaryBuilder<?, ?> _internal() {
        return new Glossary.GlossaryBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Glossary.GlossaryBuilder<?, ?> toBuilder() {
        return new Glossary.GlossaryBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryCategory> getCategories() {
        return this.categories;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlasGlossaryType getGlossaryType() {
        return this.glossaryType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLanguage() {
        return this.language;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getTerms() {
        return this.terms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsage() {
        return this.usage;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Glossary)) return false;
        final Glossary other = (Glossary) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$additionalAttributes = this.getAdditionalAttributes();
        final java.lang.Object other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !this$additionalAttributes.equals(other$additionalAttributes)) return false;
        final java.lang.Object this$categories = this.getCategories();
        final java.lang.Object other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !this$categories.equals(other$categories)) return false;
        final java.lang.Object this$glossaryType = this.getGlossaryType();
        final java.lang.Object other$glossaryType = other.getGlossaryType();
        if (this$glossaryType == null ? other$glossaryType != null : !this$glossaryType.equals(other$glossaryType)) return false;
        final java.lang.Object this$language = this.getLanguage();
        final java.lang.Object other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) return false;
        final java.lang.Object this$longDescription = this.getLongDescription();
        final java.lang.Object other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) return false;
        final java.lang.Object this$shortDescription = this.getShortDescription();
        final java.lang.Object other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) return false;
        final java.lang.Object this$terms = this.getTerms();
        final java.lang.Object other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !this$terms.equals(other$terms)) return false;
        final java.lang.Object this$usage = this.getUsage();
        final java.lang.Object other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Glossary;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $additionalAttributes = this.getAdditionalAttributes();
        result = result * PRIME + ($additionalAttributes == null ? 43 : $additionalAttributes.hashCode());
        final java.lang.Object $categories = this.getCategories();
        result = result * PRIME + ($categories == null ? 43 : $categories.hashCode());
        final java.lang.Object $glossaryType = this.getGlossaryType();
        result = result * PRIME + ($glossaryType == null ? 43 : $glossaryType.hashCode());
        final java.lang.Object $language = this.getLanguage();
        result = result * PRIME + ($language == null ? 43 : $language.hashCode());
        final java.lang.Object $longDescription = this.getLongDescription();
        result = result * PRIME + ($longDescription == null ? 43 : $longDescription.hashCode());
        final java.lang.Object $shortDescription = this.getShortDescription();
        result = result * PRIME + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        final java.lang.Object $terms = this.getTerms();
        result = result * PRIME + ($terms == null ? 43 : $terms.hashCode());
        final java.lang.Object $usage = this.getUsage();
        result = result * PRIME + ($usage == null ? 43 : $usage.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Glossary(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalAttributes=" + this.getAdditionalAttributes() + ", categories=" + this.getCategories() + ", glossaryType=" + this.getGlossaryType() + ", language=" + this.getLanguage() + ", longDescription=" + this.getLongDescription() + ", shortDescription=" + this.getShortDescription() + ", terms=" + this.getTerms() + ", usage=" + this.getUsage() + ")";
    }

    /**
     * Fixed typeName for Glossarys.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
