// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlasGlossaryCategoryType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a category in Atlan, an organizational construct for glossary terms.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class GlossaryCategory extends Asset implements IGlossaryCategory, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(GlossaryCategory.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossaryCategory";
    /**
     * Fixed typeName for GlossaryCategorys.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    Map<String, String> additionalAttributes;
    /**
     * TBC
     */
    @Attribute
    IGlossary anchor;
    /**
     * TBC
     */
    @Attribute
    AtlasGlossaryCategoryType categoryType;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryCategory> childrenCategories;
    /**
     * TBC
     */
    @Attribute
    String longDescription;
    /**
     * TBC
     */
    @Attribute
    IGlossaryCategory parentCategory;
    /**
     * TBC
     */
    @Attribute
    String shortDescription;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> terms;

    /**
     * Builds the minimal object necessary to create a relationship to a GlossaryCategory, from a potentially
     * more-complete GlossaryCategory object.
     *
     * @return the minimal object necessary to relate to the GlossaryCategory
     * @throws InvalidRequestException if any of the minimal set of required properties for a GlossaryCategory relationship are not found in the initial object
     */
    @Override
    public GlossaryCategory trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all GlossaryCategory assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) GlossaryCategory assets will be included.
     *
     * @return a fluent search that includes all GlossaryCategory assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all GlossaryCategory assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) GlossaryCategory assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all GlossaryCategory assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all GlossaryCategory assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) GlossaryCategorys will be included
     * @return a fluent search that includes all GlossaryCategory assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all GlossaryCategory assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) GlossaryCategorys will be included
     * @return a fluent search that includes all GlossaryCategory assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a GlossaryCategory by GUID. Use this to create a relationship to this GlossaryCategory,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the GlossaryCategory to reference
     * @return reference to a GlossaryCategory that can be used for defining a relationship to a GlossaryCategory
     */
    public static GlossaryCategory refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a GlossaryCategory by GUID. Use this to create a relationship to this GlossaryCategory,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the GlossaryCategory to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a GlossaryCategory that can be used for defining a relationship to a GlossaryCategory
     */
    public static GlossaryCategory refByGuid(String guid, Reference.SaveSemantic semantic) {
        return GlossaryCategory._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a GlossaryCategory by qualifiedName. Use this to create a relationship to this GlossaryCategory,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the GlossaryCategory to reference
     * @return reference to a GlossaryCategory that can be used for defining a relationship to a GlossaryCategory
     */
    public static GlossaryCategory refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a GlossaryCategory by qualifiedName. Use this to create a relationship to this GlossaryCategory,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the GlossaryCategory to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a GlossaryCategory that can be used for defining a relationship to a GlossaryCategory
     */
    public static GlossaryCategory refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return GlossaryCategory._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a GlossaryCategory by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the GlossaryCategory to retrieve, either its GUID or its full qualifiedName
     * @return the requested full GlossaryCategory, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GlossaryCategory does not exist or the provided GUID is not a GlossaryCategory
     */
    @JsonIgnore
    public static GlossaryCategory get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a GlossaryCategory by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the GlossaryCategory to retrieve, either its GUID or its full qualifiedName
     * @return the requested full GlossaryCategory, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GlossaryCategory does not exist or the provided GUID is not a GlossaryCategory
     */
    @JsonIgnore
    public static GlossaryCategory get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a GlossaryCategory by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the GlossaryCategory to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full GlossaryCategory, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GlossaryCategory does not exist or the provided GUID is not a GlossaryCategory
     */
    @JsonIgnore
    public static GlossaryCategory get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof GlossaryCategory) {
                return (GlossaryCategory) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof GlossaryCategory) {
                return (GlossaryCategory) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Builds the minimal object necessary for creating a category.
     *
     * @param name of the category
     * @param glossary in which the category should be created
     * @return the minimal request necessary to create the category, as a builder
     * @throws InvalidRequestException if the glossary provided is without a GUID or qualifiedName
     */
    public static GlossaryCategoryBuilder<?, ?> creator(String name, Glossary glossary) throws InvalidRequestException {
        return creator(name, (String) null).anchor(glossary.trimToReference());
    }

    /**
     * Builds the minimal object necessary for creating a category.
     *
     * @param name of the category
     * @param glossaryId unique identifier of the category's glossary, either is real GUID or qualifiedName
     * @return the minimal request necessary to create the category, as a builder
     */
    public static GlossaryCategoryBuilder<?, ?> creator(String name, String glossaryId) {
        Glossary anchor = StringUtils.isUUID(glossaryId) ? Glossary.refByGuid(glossaryId) : Glossary.refByQualifiedName(glossaryId);
        return GlossaryCategory._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(name).name(name).anchor(anchor);
    }

    /**
     * Builds the minimal object necessary to update a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique identifier of the GlossaryCategory's glossary
     * @return the minimal request necessary to update the GlossaryCategory, as a builder
     */
    public static GlossaryCategoryBuilder<?, ?> updater(String qualifiedName, String name, String glossaryGuid) {
        // Turns out that updating a category requires the glossary GUID, and will not work
        // with the qualifiedName of the glossary
        return GlossaryCategory._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name).anchor(Glossary.refByGuid(glossaryGuid));
    }

    /**
     * Builds the minimal object necessary to apply an update to a GlossaryCategory, from a potentially
     * more-complete GlossaryCategory object.
     *
     * @return the minimal object necessary to update the GlossaryCategory, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for GlossaryCategory are not found in the initial object
     */
    @Override
    public GlossaryCategoryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        if (this.getAnchor() == null || !this.getAnchor().isValidReferenceByGuid()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, "anchor.guid");
        }
        return updater(this.getQualifiedName(), this.getName(), this.getAnchor().getGuid());
    }

    /**
     * Find a GlossaryCategory by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the category, if found. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param name of the GlossaryCategory
     * @param glossaryName name of the Glossary in which the category exists
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByName(String name, String glossaryName) throws AtlanException {
        return findByName(name, glossaryName, (List<AtlanField>) null);
    }

    /**
     * Find a GlossaryCategory by its human-readable name. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param name of the GlossaryCategory
     * @param glossaryName name of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the GlossaryCategory
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByName(String name, String glossaryName, Collection<String> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, glossaryName, attributes);
    }

    /**
     * Find a GlossaryCategory by its human-readable name. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param name of the GlossaryCategory
     * @param glossaryName name of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (checked) to retrieve for the GlossaryCategory
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByName(String name, String glossaryName, List<AtlanField> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, glossaryName, attributes);
    }

    /**
     * Find a GlossaryCategory by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the category, if found. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     *
     * @param client connectivity to the Atlan tenant on which to search for the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryName name of the Glossary in which the category exists
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByName(AtlanClient client, String name, String glossaryName) throws AtlanException {
        return findByName(client, name, glossaryName, (List<AtlanField>) null);
    }

    /**
     * Find a GlossaryCategory by its human-readable name. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param client connectivity to the Atlan tenant on which to search for the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryName name of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the GlossaryCategory
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByName(AtlanClient client, String name, String glossaryName, Collection<String> attributes) throws AtlanException {
        Glossary glossary = Glossary.findByName(client, glossaryName);
        return findByNameFast(client, name, glossary.getQualifiedName(), attributes);
    }

    /**
     * Find a GlossaryCategory by its human-readable name. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param client connectivity to the Atlan tenant on which to search for the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryName name of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (checked) to retrieve for the GlossaryCategory
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByName(AtlanClient client, String name, String glossaryName, List<AtlanField> attributes) throws AtlanException {
        Glossary glossary = Glossary.findByName(client, glossaryName);
        return findByNameFast(client, name, glossary.getQualifiedName(), attributes);
    }

    /**
     * Find a GlossaryCategory by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the category, if found.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param name of the GlossaryCategory
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByNameFast(String name, String glossaryQualifiedName) throws AtlanException {
        return findByNameFast(name, glossaryQualifiedName, (List<AtlanField>) null);
    }

    /**
     * Find a GlossaryCategory by its human-readable name.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param name of the GlossaryCategory
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the GlossaryCategory
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByNameFast(String name, String glossaryQualifiedName, Collection<String> attributes) throws AtlanException {
        return findByNameFast(Atlan.getDefaultClient(), name, glossaryQualifiedName, attributes);
    }

    /**
     * Find a GlossaryCategory by its human-readable name.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param name of the GlossaryCategory
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (checked) to retrieve for the GlossaryCategory
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByNameFast(String name, String glossaryQualifiedName, List<AtlanField> attributes) throws AtlanException {
        return findByNameFast(Atlan.getDefaultClient(), name, glossaryQualifiedName, attributes);
    }

    /**
     * Find a GlossaryCategory by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the category, if found.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param client connectivity to the Atlan tenant on which to search for the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByNameFast(AtlanClient client, String name, String glossaryQualifiedName) throws AtlanException {
        return findByNameFast(client, name, glossaryQualifiedName, (List<AtlanField>) null);
    }

    /**
     * Find a GlossaryCategory by its human-readable name.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param client connectivity to the Atlan tenant on which to search for the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the GlossaryCategory
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByNameFast(AtlanClient client, String name, String glossaryQualifiedName, Collection<String> attributes) throws AtlanException {
        List<GlossaryCategory> results = new ArrayList<>();
        GlossaryCategory.select(client).where(GlossaryCategory.NAME.eq(name)).where(GlossaryCategory.ANCHOR.eq(glossaryQualifiedName)).includeOnResults(GlossaryCategory.ANCHOR)._includesOnResults(attributes == null ? Collections.emptyList() : attributes).includeOnRelations(Asset.NAME).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> results.add((GlossaryCategory) c));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    /**
     * Find a GlossaryCategory by its human-readable name.
     * Note that categories are not unique by name, so there may be multiple results.
     *
     * @param client connectivity to the Atlan tenant on which to search for the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (checked) to retrieve for the GlossaryCategory
     * @return the GlossaryCategory, if found
     * @throws AtlanException on any API problems, or if the GlossaryCategory does not exist
     */
    public static List<GlossaryCategory> findByNameFast(AtlanClient client, String name, String glossaryQualifiedName, List<AtlanField> attributes) throws AtlanException {
        List<GlossaryCategory> results = new ArrayList<>();
        GlossaryCategory.select(client).where(GlossaryCategory.NAME.eq(name)).where(GlossaryCategory.ANCHOR.eq(glossaryQualifiedName)).includeOnResults(GlossaryCategory.ANCHOR).includesOnResults(attributes == null ? Collections.emptyList() : attributes).includeOnRelations(Asset.NAME).stream().filter(a -> a instanceof GlossaryCategory).forEach(c -> results.add((GlossaryCategory) c));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    /**
     * Remove the system description from a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the system description from a GlossaryCategory.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryCategory's description
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeDescription(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory) Asset.removeDescription(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Remove the user's description from a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeUserDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the user's description from a GlossaryCategory.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryCategory's description
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeUserDescription(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory) Asset.removeUserDescription(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Remove the owners from a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeOwners(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the owners from a GlossaryCategory.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryCategory's owners
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeOwners(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory) Asset.removeOwners(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Update the certificate on a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated GlossaryCategory, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory updateCertificate(String qualifiedName, String name, String glossaryGuid, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid, certificate, message);
    }

    /**
     * Update the certificate on a GlossaryCategory.
     *
     * @param client connectivity to the Atlan tenant on which to update the GlossaryCategory's certificate
     * @param qualifiedName of the GlossaryCategory
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated GlossaryCategory, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory updateCertificate(AtlanClient client, String qualifiedName, String name, String glossaryGuid, CertificateStatus certificate, String message) throws AtlanException {
        return (GlossaryCategory) Asset.updateCertificate(client, updater(qualifiedName, name, glossaryGuid), certificate, message);
    }

    /**
     * Remove the certificate from a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeCertificate(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the certificate from a GlossaryCategory.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryCategory's certificate
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeCertificate(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory) Asset.removeCertificate(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Update the announcement on a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the updated GlossaryCategory, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory updateAnnouncement(String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid, type, title, message);
    }

    /**
     * Update the announcement on a GlossaryCategory.
     *
     * @param client connectivity to the Atlan tenant on which to update the GlossaryCategory's announcement
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the updated GlossaryCategory, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory updateAnnouncement(AtlanClient client, String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GlossaryCategory) Asset.updateAnnouncement(client, updater(qualifiedName, name, glossaryGuid), type, title, message);
    }

    /**
     * Remove the announcement from a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeAnnouncement(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the announcement from a GlossaryCategory.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryCategory's announcement
     * @param qualifiedName of the GlossaryCategory
     * @param name of the GlossaryCategory
     * @param glossaryGuid unique ID (GUID) of the GlossaryCategory's glossary
     * @return the updated GlossaryCategory, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryCategory removeAnnouncement(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory) Asset.removeAnnouncement(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Add Atlan tags to a GlossaryCategory, without replacing existing Atlan tags linked to the GlossaryCategory.
     * Note: this operation must make two API calls — one to retrieve the GlossaryCategory's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated GlossaryCategory
     */
    public static GlossaryCategory appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a GlossaryCategory, without replacing existing Atlan tags linked to the GlossaryCategory.
     * Note: this operation must make two API calls — one to retrieve the GlossaryCategory's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the GlossaryCategory
     * @param qualifiedName of the GlossaryCategory
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated GlossaryCategory
     */
    public static GlossaryCategory appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (GlossaryCategory) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a GlossaryCategory, without replacing existing Atlan tags linked to the GlossaryCategory.
     * Note: this operation must make two API calls — one to retrieve the GlossaryCategory's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated GlossaryCategory
     */
    public static GlossaryCategory appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a GlossaryCategory, without replacing existing Atlan tags linked to the GlossaryCategory.
     * Note: this operation must make two API calls — one to retrieve the GlossaryCategory's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the GlossaryCategory
     * @param qualifiedName of the GlossaryCategory
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated GlossaryCategory
     */
    public static GlossaryCategory appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (GlossaryCategory) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a GlossaryCategory.
     *
     * @param qualifiedName of the GlossaryCategory
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the GlossaryCategory
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a GlossaryCategory.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a GlossaryCategory
     * @param qualifiedName of the GlossaryCategory
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the GlossaryCategory
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class GlossaryCategoryBuilder<C extends GlossaryCategory, B extends GlossaryCategory.GlossaryCategoryBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> additionalAttributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> additionalAttributes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IGlossary anchor;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlasGlossaryCategoryType categoryType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryCategory> childrenCategories;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String longDescription;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IGlossaryCategory parentCategory;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String shortDescription;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> terms;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            GlossaryCategory.GlossaryCategoryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final GlossaryCategory instance, final GlossaryCategory.GlossaryCategoryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalAttributes(instance.additionalAttributes == null ? java.util.Collections.<String, String>emptyMap() : instance.additionalAttributes);
            b.anchor(instance.anchor);
            b.categoryType(instance.categoryType);
            b.childrenCategories(instance.childrenCategories == null ? java.util.Collections.<IGlossaryCategory>emptySortedSet() : instance.childrenCategories);
            b.longDescription(instance.longDescription);
            b.parentCategory(instance.parentCategory);
            b.shortDescription(instance.shortDescription);
            b.terms(instance.terms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.terms);
        }

        /**
         * Fixed typeName for GlossaryCategorys.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalAttribute(final String additionalAttributeKey, final String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new java.util.ArrayList<String>();
                this.additionalAttributes$value = new java.util.ArrayList<String>();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalAttributes(final java.util.Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new java.lang.NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new java.util.ArrayList<String>();
                this.additionalAttributes$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anchor(final IGlossary anchor) {
            this.anchor = anchor;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B categoryType(final AtlasGlossaryCategoryType categoryType) {
            this.categoryType = categoryType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B childCategory(final IGlossaryCategory childCategory) {
            if (this.childrenCategories == null) this.childrenCategories = new java.util.ArrayList<IGlossaryCategory>();
            this.childrenCategories.add(childCategory);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B childrenCategories(final java.util.Collection<? extends IGlossaryCategory> childrenCategories) {
            if (childrenCategories == null) {
                throw new java.lang.NullPointerException("childrenCategories cannot be null");
            }
            if (this.childrenCategories == null) this.childrenCategories = new java.util.ArrayList<IGlossaryCategory>();
            this.childrenCategories.addAll(childrenCategories);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearChildrenCategories() {
            if (this.childrenCategories != null) this.childrenCategories.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B longDescription(final String longDescription) {
            this.longDescription = longDescription;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B parentCategory(final IGlossaryCategory parentCategory) {
            this.parentCategory = parentCategory;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B shortDescription(final String shortDescription) {
            this.shortDescription = shortDescription;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B term(final IGlossaryTerm term) {
            if (this.terms == null) this.terms = new java.util.ArrayList<IGlossaryTerm>();
            this.terms.add(term);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B terms(final java.util.Collection<? extends IGlossaryTerm> terms) {
            if (terms == null) {
                throw new java.lang.NullPointerException("terms cannot be null");
            }
            if (this.terms == null) this.terms = new java.util.ArrayList<IGlossaryTerm>();
            this.terms.addAll(terms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTerms() {
            if (this.terms != null) this.terms.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "GlossaryCategory.GlossaryCategoryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalAttributes$key=" + this.additionalAttributes$key + ", additionalAttributes$value=" + this.additionalAttributes$value + ", anchor=" + this.anchor + ", categoryType=" + this.categoryType + ", childrenCategories=" + this.childrenCategories + ", longDescription=" + this.longDescription + ", parentCategory=" + this.parentCategory + ", shortDescription=" + this.shortDescription + ", terms=" + this.terms + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class GlossaryCategoryBuilderImpl extends GlossaryCategory.GlossaryCategoryBuilder<GlossaryCategory, GlossaryCategory.GlossaryCategoryBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private GlossaryCategoryBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected GlossaryCategory.GlossaryCategoryBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GlossaryCategory build() {
            return new GlossaryCategory(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected GlossaryCategory(final GlossaryCategory.GlossaryCategoryBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = GlossaryCategory.$default$typeName();
        java.util.Map<String, String> additionalAttributes;
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
        case 0: 
            additionalAttributes = java.util.Collections.emptyMap();
            break;
        case 1: 
            additionalAttributes = java.util.Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
            break;
        default: 
            additionalAttributes = new java.util.LinkedHashMap<String, String>(b.additionalAttributes$key.size() < 1073741824 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.additionalAttributes$key.size(); $i++) additionalAttributes.put(b.additionalAttributes$key.get($i), (String) b.additionalAttributes$value.get($i));
            additionalAttributes = java.util.Collections.unmodifiableMap(additionalAttributes);
        }
        this.additionalAttributes = additionalAttributes;
        this.anchor = b.anchor;
        this.categoryType = b.categoryType;
        java.util.SortedSet<IGlossaryCategory> childrenCategories = new java.util.TreeSet<IGlossaryCategory>();
        if (b.childrenCategories != null) childrenCategories.addAll(b.childrenCategories);
        childrenCategories = java.util.Collections.unmodifiableSortedSet(childrenCategories);
        this.childrenCategories = childrenCategories;
        this.longDescription = b.longDescription;
        this.parentCategory = b.parentCategory;
        this.shortDescription = b.shortDescription;
        java.util.SortedSet<IGlossaryTerm> terms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.terms != null) terms.addAll(b.terms);
        terms = java.util.Collections.unmodifiableSortedSet(terms);
        this.terms = terms;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static GlossaryCategory.GlossaryCategoryBuilder<?, ?> _internal() {
        return new GlossaryCategory.GlossaryCategoryBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public GlossaryCategory.GlossaryCategoryBuilder<?, ?> toBuilder() {
        return new GlossaryCategory.GlossaryCategoryBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IGlossary getAnchor() {
        return this.anchor;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlasGlossaryCategoryType getCategoryType() {
        return this.categoryType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryCategory> getChildrenCategories() {
        return this.childrenCategories;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IGlossaryCategory getParentCategory() {
        return this.parentCategory;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getTerms() {
        return this.terms;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GlossaryCategory)) return false;
        final GlossaryCategory other = (GlossaryCategory) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$additionalAttributes = this.getAdditionalAttributes();
        final java.lang.Object other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !this$additionalAttributes.equals(other$additionalAttributes)) return false;
        final java.lang.Object this$anchor = this.getAnchor();
        final java.lang.Object other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) return false;
        final java.lang.Object this$categoryType = this.getCategoryType();
        final java.lang.Object other$categoryType = other.getCategoryType();
        if (this$categoryType == null ? other$categoryType != null : !this$categoryType.equals(other$categoryType)) return false;
        final java.lang.Object this$childrenCategories = this.getChildrenCategories();
        final java.lang.Object other$childrenCategories = other.getChildrenCategories();
        if (this$childrenCategories == null ? other$childrenCategories != null : !this$childrenCategories.equals(other$childrenCategories)) return false;
        final java.lang.Object this$longDescription = this.getLongDescription();
        final java.lang.Object other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) return false;
        final java.lang.Object this$parentCategory = this.getParentCategory();
        final java.lang.Object other$parentCategory = other.getParentCategory();
        if (this$parentCategory == null ? other$parentCategory != null : !this$parentCategory.equals(other$parentCategory)) return false;
        final java.lang.Object this$shortDescription = this.getShortDescription();
        final java.lang.Object other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) return false;
        final java.lang.Object this$terms = this.getTerms();
        final java.lang.Object other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !this$terms.equals(other$terms)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof GlossaryCategory;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $additionalAttributes = this.getAdditionalAttributes();
        result = result * PRIME + ($additionalAttributes == null ? 43 : $additionalAttributes.hashCode());
        final java.lang.Object $anchor = this.getAnchor();
        result = result * PRIME + ($anchor == null ? 43 : $anchor.hashCode());
        final java.lang.Object $categoryType = this.getCategoryType();
        result = result * PRIME + ($categoryType == null ? 43 : $categoryType.hashCode());
        final java.lang.Object $childrenCategories = this.getChildrenCategories();
        result = result * PRIME + ($childrenCategories == null ? 43 : $childrenCategories.hashCode());
        final java.lang.Object $longDescription = this.getLongDescription();
        result = result * PRIME + ($longDescription == null ? 43 : $longDescription.hashCode());
        final java.lang.Object $parentCategory = this.getParentCategory();
        result = result * PRIME + ($parentCategory == null ? 43 : $parentCategory.hashCode());
        final java.lang.Object $shortDescription = this.getShortDescription();
        result = result * PRIME + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        final java.lang.Object $terms = this.getTerms();
        result = result * PRIME + ($terms == null ? 43 : $terms.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "GlossaryCategory(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalAttributes=" + this.getAdditionalAttributes() + ", anchor=" + this.getAnchor() + ", categoryType=" + this.getCategoryType() + ", childrenCategories=" + this.getChildrenCategories() + ", longDescription=" + this.getLongDescription() + ", parentCategory=" + this.getParentCategory() + ", shortDescription=" + this.getShortDescription() + ", terms=" + this.getTerms() + ")";
    }

    /**
     * Fixed typeName for GlossaryCategorys.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    void setChildrenCategories(final SortedSet<IGlossaryCategory> childrenCategories) {
        this.childrenCategories = childrenCategories;
    }
}
