// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlasGlossaryTermType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a term in Atlan. Terms define concepts in natural language that can be associated with other assets to provide meaning.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class GlossaryTerm extends Asset implements IGlossaryTerm, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(GlossaryTerm.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossaryTerm";
    /**
     * Fixed typeName for GlossaryTerms.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    String abbreviation;
    /**
     * TBC
     */
    @Attribute
    Map<String, String> additionalAttributes;
    /**
     * TBC
     */
    @Attribute
    IGlossary anchor;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> antonyms;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAsset> assignedEntities;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryCategory> categories;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> classifies;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> examples;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> isA;
    /**
     * TBC
     */
    @Attribute
    String longDescription;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> preferredTerms;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> preferredToTerms;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> replacedBy;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> replacementTerms;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> seeAlso;
    /**
     * TBC
     */
    @Attribute
    String shortDescription;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> synonyms;
    /**
     * TBC
     */
    @Attribute
    AtlasGlossaryTermType termType;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> translatedTerms;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> translationTerms;
    /**
     * TBC
     */
    @Attribute
    String usage;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> validValues;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IGlossaryTerm> validValuesFor;

    /**
     * Builds the minimal object necessary to create a relationship to a GlossaryTerm, from a potentially
     * more-complete GlossaryTerm object.
     *
     * @return the minimal object necessary to relate to the GlossaryTerm
     * @throws InvalidRequestException if any of the minimal set of required properties for a GlossaryTerm relationship are not found in the initial object
     */
    @Override
    public GlossaryTerm trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all GlossaryTerm assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) GlossaryTerm assets will be included.
     *
     * @return a fluent search that includes all GlossaryTerm assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all GlossaryTerm assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) GlossaryTerm assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all GlossaryTerm assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all GlossaryTerm assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) GlossaryTerms will be included
     * @return a fluent search that includes all GlossaryTerm assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all GlossaryTerm assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) GlossaryTerms will be included
     * @return a fluent search that includes all GlossaryTerm assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a GlossaryTerm by GUID. Use this to create a relationship to this GlossaryTerm,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the GlossaryTerm to reference
     * @return reference to a GlossaryTerm that can be used for defining a relationship to a GlossaryTerm
     */
    public static GlossaryTerm refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a GlossaryTerm by GUID. Use this to create a relationship to this GlossaryTerm,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the GlossaryTerm to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a GlossaryTerm that can be used for defining a relationship to a GlossaryTerm
     */
    public static GlossaryTerm refByGuid(String guid, Reference.SaveSemantic semantic) {
        return GlossaryTerm._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a GlossaryTerm by qualifiedName. Use this to create a relationship to this GlossaryTerm,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the GlossaryTerm to reference
     * @return reference to a GlossaryTerm that can be used for defining a relationship to a GlossaryTerm
     */
    public static GlossaryTerm refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a GlossaryTerm by qualifiedName. Use this to create a relationship to this GlossaryTerm,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the GlossaryTerm to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a GlossaryTerm that can be used for defining a relationship to a GlossaryTerm
     */
    public static GlossaryTerm refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return GlossaryTerm._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a GlossaryTerm by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the GlossaryTerm to retrieve, either its GUID or its full qualifiedName
     * @return the requested full GlossaryTerm, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GlossaryTerm does not exist or the provided GUID is not a GlossaryTerm
     */
    @JsonIgnore
    public static GlossaryTerm get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a GlossaryTerm by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the GlossaryTerm to retrieve, either its GUID or its full qualifiedName
     * @return the requested full GlossaryTerm, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GlossaryTerm does not exist or the provided GUID is not a GlossaryTerm
     */
    @JsonIgnore
    public static GlossaryTerm get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a GlossaryTerm by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the GlossaryTerm to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full GlossaryTerm, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the GlossaryTerm does not exist or the provided GUID is not a GlossaryTerm
     */
    @JsonIgnore
    public static GlossaryTerm get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof GlossaryTerm) {
                return (GlossaryTerm) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof GlossaryTerm) {
                return (GlossaryTerm) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) GlossaryTerm to active.
     *
     * @param qualifiedName for the GlossaryTerm
     * @return true if the GlossaryTerm is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) GlossaryTerm to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the GlossaryTerm
     * @return true if the GlossaryTerm is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary for creating a term.
     *
     * @param name of the term
     * @param glossary in which the term should be created
     * @return the minimal request necessary to create the term, as a builder
     * @throws InvalidRequestException if the glossary provided is without a GUID or qualifiedName
     */
    public static GlossaryTermBuilder<?, ?> creator(String name, Glossary glossary) throws InvalidRequestException {
        return creator(name, (String) null).anchor(glossary.trimToReference());
    }

    /**
     * Builds the minimal object necessary for creating a term.
     *
     * @param name of the term
     * @param glossaryId unique identifier of the term's glossary, either is real GUID or qualifiedName
     * @return the minimal request necessary to create the term, as a builder
     */
    public static GlossaryTermBuilder<?, ?> creator(String name, String glossaryId) {
        Glossary anchor = StringUtils.isUUID(glossaryId) ? Glossary.refByGuid(glossaryId) : Glossary.refByQualifiedName(glossaryId);
        return GlossaryTerm._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(name).name(name).anchor(anchor);
    }

    /**
     * Builds the minimal object necessary to update a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique identifier of the GlossaryTerm's glossary
     * @return the minimal request necessary to update the GlossaryTerm, as a builder
     */
    public static GlossaryTermBuilder<?, ?> updater(String qualifiedName, String name, String glossaryGuid) {
        // Turns out that updating a term requires the glossary GUID, and will not work
        // with the qualifiedName of the glossary
        return GlossaryTerm._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name).anchor(Glossary.refByGuid(glossaryGuid));
    }

    /**
     * Builds the minimal object necessary to apply an update to a GlossaryTerm, from a potentially
     * more-complete GlossaryTerm object.
     *
     * @return the minimal object necessary to update the GlossaryTerm, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for GlossaryTerm are not found in the initial object
     */
    @Override
    public GlossaryTermBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        if (this.getAnchor() == null || !this.getAnchor().isValidReferenceByGuid()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, "anchor.guid");
        }
        return updater(this.getQualifiedName(), this.getName(), this.getAnchor().getGuid());
    }

    /**
     * Find a GlossaryTerm by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the term, if found. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     *
     * @param name of the GlossaryTerm
     * @param glossaryName human-readable name of the Glossary in which the category exists
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByName(String name, String glossaryName) throws AtlanException {
        return findByName(name, glossaryName, (List<AtlanField>) null);
    }

    /**
     * Find a GlossaryTerm by its human-readable name. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     *
     * @param name of the GlossaryTerm
     * @param glossaryName human-readable name of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the GlossaryTerm
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByName(String name, String glossaryName, Collection<String> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, glossaryName, attributes);
    }

    /**
     * Find a GlossaryTerm by its human-readable name. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     *
     * @param name of the GlossaryTerm
     * @param glossaryName human-readable name of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (checked) to retrieve for the GlossaryTerm
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByName(String name, String glossaryName, List<AtlanField> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, glossaryName, attributes);
    }

    /**
     * Find a GlossaryTerm by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the term, if found. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     *
     * @param client connectivity to the Atlan tenant in which to search for the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryName human-readable name of the Glossary in which the category exists
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByName(AtlanClient client, String name, String glossaryName) throws AtlanException {
        return findByName(client, name, glossaryName, (List<AtlanField>) null);
    }

    /**
     * Find a GlossaryTerm by its human-readable name. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     *
     * @param client connectivity to the Atlan tenant in which to search for the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryName human-readable name of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the GlossaryTerm
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByName(AtlanClient client, String name, String glossaryName, Collection<String> attributes) throws AtlanException {
        Glossary glossary = Glossary.findByName(client, glossaryName);
        return findByNameFast(client, name, glossary.getQualifiedName(), attributes);
    }

    /**
     * Find a GlossaryTerm by its human-readable name. Note that this operation must run two
     * separate queries to first resolve the qualifiedName of the glossary, so will be somewhat slower.
     * If you already have the qualifiedName of the glossary, use findByNameFast instead.
     *
     * @param client connectivity to the Atlan tenant in which to search for the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryName human-readable name of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (checked) to retrieve for the GlossaryTerm
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByName(AtlanClient client, String name, String glossaryName, List<AtlanField> attributes) throws AtlanException {
        Glossary glossary = Glossary.findByName(client, glossaryName);
        return findByNameFast(client, name, glossary.getQualifiedName(), attributes);
    }

    /**
     * Find a GlossaryTerm by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the term, if found.
     *
     * @param name of the GlossaryTerm
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByNameFast(String name, String glossaryQualifiedName) throws AtlanException {
        return findByNameFast(name, glossaryQualifiedName, (List<AtlanField>) null);
    }

    /**
     * Find a GlossaryTerm by its human-readable name.
     *
     * @param name of the GlossaryTerm
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the GlossaryTerm
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByNameFast(String name, String glossaryQualifiedName, Collection<String> attributes) throws AtlanException {
        return findByNameFast(Atlan.getDefaultClient(), name, glossaryQualifiedName, attributes);
    }

    /**
     * Find a GlossaryTerm by its human-readable name.
     *
     * @param name of the GlossaryTerm
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (checked) to retrieve for the GlossaryTerm
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByNameFast(String name, String glossaryQualifiedName, List<AtlanField> attributes) throws AtlanException {
        return findByNameFast(Atlan.getDefaultClient(), name, glossaryQualifiedName, attributes);
    }

    /**
     * Find a GlossaryTerm by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the term, if found.
     *
     * @param client connectivity to the Atlan tenant in which to search for the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByNameFast(AtlanClient client, String name, String glossaryQualifiedName) throws AtlanException {
        return findByNameFast(client, name, glossaryQualifiedName, (List<AtlanField>) null);
    }

    /**
     * Find a GlossaryTerm by its human-readable name.
     *
     * @param client connectivity to the Atlan tenant in which to search for the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the GlossaryTerm
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByNameFast(AtlanClient client, String name, String glossaryQualifiedName, Collection<String> attributes) throws AtlanException {
        List<GlossaryTerm> results = new ArrayList<>();
        GlossaryTerm.select(client).where(GlossaryTerm.NAME.eq(name)).where(GlossaryTerm.ANCHOR.eq(glossaryQualifiedName)).includeOnResults(GlossaryTerm.ANCHOR)._includesOnResults(attributes == null ? Collections.emptyList() : attributes).includeOnRelations(Asset.NAME).pageSize(2).stream().limit(2).filter(a -> a instanceof GlossaryTerm).forEach(t -> results.add((GlossaryTerm) t));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        } else if (results.size() > 1) {
            log.warn("Multiple terms found with the name \'{}\' in glossary \'{}\', returning only the first.", name, glossaryQualifiedName);
        }
        return results.get(0);
    }

    /**
     * Find a GlossaryTerm by its human-readable name.
     *
     * @param client connectivity to the Atlan tenant in which to search for the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryQualifiedName qualifiedName of the Glossary in which the category exists
     * @param attributes an optional collection of attributes (checked) to retrieve for the GlossaryTerm
     * @return the GlossaryTerm, if found
     * @throws AtlanException on any API problems, or if the GlossaryTerm does not exist
     */
    public static GlossaryTerm findByNameFast(AtlanClient client, String name, String glossaryQualifiedName, List<AtlanField> attributes) throws AtlanException {
        List<GlossaryTerm> results = new ArrayList<>();
        GlossaryTerm.select(client).where(GlossaryTerm.NAME.eq(name)).where(GlossaryTerm.ANCHOR.eq(glossaryQualifiedName)).includeOnResults(GlossaryTerm.ANCHOR).includesOnResults(attributes == null ? Collections.emptyList() : attributes).includeOnRelations(Asset.NAME).pageSize(2).stream().limit(2).filter(a -> a instanceof GlossaryTerm).forEach(t -> results.add((GlossaryTerm) t));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        } else if (results.size() > 1) {
            log.warn("Multiple terms found with the name \'{}\' in glossary \'{}\', returning only the first.", name, glossaryQualifiedName);
        }
        return results.get(0);
    }

    /**
     * Remove the system description from a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the system description from a GlossaryTerm.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryTerm's description
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeDescription(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm) Asset.removeDescription(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Remove the user's description from a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeUserDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the user's description from a GlossaryTerm.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryTerm's description
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeUserDescription(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm) Asset.removeUserDescription(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Remove the owners from a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeOwners(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the owners from a GlossaryTerm.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryTerm's owners
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeOwners(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm) Asset.removeOwners(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Update the certificate on a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated GlossaryTerm, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm updateCertificate(String qualifiedName, String name, String glossaryGuid, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid, certificate, message);
    }

    /**
     * Update the certificate on a GlossaryTerm.
     *
     * @param client connectivity to the Atlan tenant on which to update the GlossaryTerm's certificate
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated GlossaryTerm, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm updateCertificate(AtlanClient client, String qualifiedName, String name, String glossaryGuid, CertificateStatus certificate, String message) throws AtlanException {
        return (GlossaryTerm) Asset.updateCertificate(client, updater(qualifiedName, name, glossaryGuid), certificate, message);
    }

    /**
     * Remove the certificate from a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeCertificate(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the certificate from a GlossaryTerm.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryTerm's certificate
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeCertificate(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm) Asset.removeCertificate(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Update the announcement on a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the updated GlossaryTerm, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm updateAnnouncement(String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid, type, title, message);
    }

    /**
     * Update the announcement on a GlossaryTerm.
     *
     * @param client connectivity to the Atlan tenant on which to update the GlossaryTerm's announcement
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the updated GlossaryTerm, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm updateAnnouncement(AtlanClient client, String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GlossaryTerm) Asset.updateAnnouncement(client, updater(qualifiedName, name, glossaryGuid), type, title, message);
    }

    /**
     * Remove the announcement from a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeAnnouncement(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name, glossaryGuid);
    }

    /**
     * Remove the announcement from a GlossaryTerm.
     *
     * @param client connectivity to the Atlan tenant from which to remove the GlossaryTerm's announcement
     * @param qualifiedName of the GlossaryTerm
     * @param name of the GlossaryTerm
     * @param glossaryGuid unique ID (GUID) of the GlossaryTerm's glossary
     * @return the updated GlossaryTerm, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static GlossaryTerm removeAnnouncement(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm) Asset.removeAnnouncement(client, updater(qualifiedName, name, glossaryGuid));
    }

    /**
     * Add Atlan tags to a GlossaryTerm, without replacing existing Atlan tags linked to the GlossaryTerm.
     * Note: this operation must make two API calls — one to retrieve the GlossaryTerm's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated GlossaryTerm
     */
    public static GlossaryTerm appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a GlossaryTerm, without replacing existing Atlan tags linked to the GlossaryTerm.
     * Note: this operation must make two API calls — one to retrieve the GlossaryTerm's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the GlossaryTerm
     * @param qualifiedName of the GlossaryTerm
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated GlossaryTerm
     */
    public static GlossaryTerm appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (GlossaryTerm) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a GlossaryTerm, without replacing existing Atlan tags linked to the GlossaryTerm.
     * Note: this operation must make two API calls — one to retrieve the GlossaryTerm's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated GlossaryTerm
     */
    public static GlossaryTerm appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a GlossaryTerm, without replacing existing Atlan tags linked to the GlossaryTerm.
     * Note: this operation must make two API calls — one to retrieve the GlossaryTerm's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the GlossaryTerm
     * @param qualifiedName of the GlossaryTerm
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated GlossaryTerm
     */
    public static GlossaryTerm appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (GlossaryTerm) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a GlossaryTerm.
     *
     * @param qualifiedName of the GlossaryTerm
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the GlossaryTerm
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a GlossaryTerm.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a GlossaryTerm
     * @param qualifiedName of the GlossaryTerm
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the GlossaryTerm
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class GlossaryTermBuilder<C extends GlossaryTerm, B extends GlossaryTerm.GlossaryTermBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String abbreviation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> additionalAttributes$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> additionalAttributes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IGlossary anchor;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> antonyms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> assignedEntities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryCategory> categories;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> classifies;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> examples;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> isA;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String longDescription;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> preferredTerms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> preferredToTerms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> replacedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> replacementTerms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> seeAlso;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String shortDescription;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> synonyms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlasGlossaryTermType termType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> translatedTerms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> translationTerms;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String usage;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> validValues;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IGlossaryTerm> validValuesFor;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            GlossaryTerm.GlossaryTermBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final GlossaryTerm instance, final GlossaryTerm.GlossaryTermBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.abbreviation(instance.abbreviation);
            b.additionalAttributes(instance.additionalAttributes == null ? java.util.Collections.<String, String>emptyMap() : instance.additionalAttributes);
            b.anchor(instance.anchor);
            b.antonyms(instance.antonyms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.antonyms);
            b.assignedEntities(instance.assignedEntities == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.assignedEntities);
            b.categories(instance.categories == null ? java.util.Collections.<IGlossaryCategory>emptySortedSet() : instance.categories);
            b.classifies(instance.classifies == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.classifies);
            b.examples(instance.examples == null ? java.util.Collections.<String>emptySortedSet() : instance.examples);
            b.isA(instance.isA == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.isA);
            b.longDescription(instance.longDescription);
            b.preferredTerms(instance.preferredTerms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.preferredTerms);
            b.preferredToTerms(instance.preferredToTerms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.preferredToTerms);
            b.replacedBy(instance.replacedBy == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.replacedBy);
            b.replacementTerms(instance.replacementTerms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.replacementTerms);
            b.seeAlso(instance.seeAlso == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.seeAlso);
            b.shortDescription(instance.shortDescription);
            b.synonyms(instance.synonyms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.synonyms);
            b.termType(instance.termType);
            b.translatedTerms(instance.translatedTerms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.translatedTerms);
            b.translationTerms(instance.translationTerms == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.translationTerms);
            b.usage(instance.usage);
            b.validValues(instance.validValues == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.validValues);
            b.validValuesFor(instance.validValuesFor == null ? java.util.Collections.<IGlossaryTerm>emptySortedSet() : instance.validValuesFor);
        }

        /**
         * Fixed typeName for GlossaryTerms.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B abbreviation(final String abbreviation) {
            this.abbreviation = abbreviation;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalAttribute(final String additionalAttributeKey, final String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new java.util.ArrayList<String>();
                this.additionalAttributes$value = new java.util.ArrayList<String>();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalAttributes(final java.util.Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new java.lang.NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new java.util.ArrayList<String>();
                this.additionalAttributes$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B anchor(final IGlossary anchor) {
            this.anchor = anchor;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B antonym(final IGlossaryTerm antonym) {
            if (this.antonyms == null) this.antonyms = new java.util.ArrayList<IGlossaryTerm>();
            this.antonyms.add(antonym);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B antonyms(final java.util.Collection<? extends IGlossaryTerm> antonyms) {
            if (antonyms == null) {
                throw new java.lang.NullPointerException("antonyms cannot be null");
            }
            if (this.antonyms == null) this.antonyms = new java.util.ArrayList<IGlossaryTerm>();
            this.antonyms.addAll(antonyms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAntonyms() {
            if (this.antonyms != null) this.antonyms.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assignedEntity(final IAsset assignedEntity) {
            if (this.assignedEntities == null) this.assignedEntities = new java.util.ArrayList<IAsset>();
            this.assignedEntities.add(assignedEntity);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assignedEntities(final java.util.Collection<? extends IAsset> assignedEntities) {
            if (assignedEntities == null) {
                throw new java.lang.NullPointerException("assignedEntities cannot be null");
            }
            if (this.assignedEntities == null) this.assignedEntities = new java.util.ArrayList<IAsset>();
            this.assignedEntities.addAll(assignedEntities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssignedEntities() {
            if (this.assignedEntities != null) this.assignedEntities.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B category(final IGlossaryCategory category) {
            if (this.categories == null) this.categories = new java.util.ArrayList<IGlossaryCategory>();
            this.categories.add(category);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B categories(final java.util.Collection<? extends IGlossaryCategory> categories) {
            if (categories == null) {
                throw new java.lang.NullPointerException("categories cannot be null");
            }
            if (this.categories == null) this.categories = new java.util.ArrayList<IGlossaryCategory>();
            this.categories.addAll(categories);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCategories() {
            if (this.categories != null) this.categories.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B classify(final IGlossaryTerm classify) {
            if (this.classifies == null) this.classifies = new java.util.ArrayList<IGlossaryTerm>();
            this.classifies.add(classify);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B classifies(final java.util.Collection<? extends IGlossaryTerm> classifies) {
            if (classifies == null) {
                throw new java.lang.NullPointerException("classifies cannot be null");
            }
            if (this.classifies == null) this.classifies = new java.util.ArrayList<IGlossaryTerm>();
            this.classifies.addAll(classifies);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearClassifies() {
            if (this.classifies != null) this.classifies.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B example(final String example) {
            if (this.examples == null) this.examples = new java.util.ArrayList<String>();
            this.examples.add(example);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B examples(final java.util.Collection<? extends String> examples) {
            if (examples == null) {
                throw new java.lang.NullPointerException("examples cannot be null");
            }
            if (this.examples == null) this.examples = new java.util.ArrayList<String>();
            this.examples.addAll(examples);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearExamples() {
            if (this.examples != null) this.examples.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isATerm(final IGlossaryTerm isATerm) {
            if (this.isA == null) this.isA = new java.util.ArrayList<IGlossaryTerm>();
            this.isA.add(isATerm);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isA(final java.util.Collection<? extends IGlossaryTerm> isA) {
            if (isA == null) {
                throw new java.lang.NullPointerException("isA cannot be null");
            }
            if (this.isA == null) this.isA = new java.util.ArrayList<IGlossaryTerm>();
            this.isA.addAll(isA);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearIsA() {
            if (this.isA != null) this.isA.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B longDescription(final String longDescription) {
            this.longDescription = longDescription;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B preferredTerm(final IGlossaryTerm preferredTerm) {
            if (this.preferredTerms == null) this.preferredTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.preferredTerms.add(preferredTerm);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B preferredTerms(final java.util.Collection<? extends IGlossaryTerm> preferredTerms) {
            if (preferredTerms == null) {
                throw new java.lang.NullPointerException("preferredTerms cannot be null");
            }
            if (this.preferredTerms == null) this.preferredTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.preferredTerms.addAll(preferredTerms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPreferredTerms() {
            if (this.preferredTerms != null) this.preferredTerms.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B preferredToTerm(final IGlossaryTerm preferredToTerm) {
            if (this.preferredToTerms == null) this.preferredToTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.preferredToTerms.add(preferredToTerm);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B preferredToTerms(final java.util.Collection<? extends IGlossaryTerm> preferredToTerms) {
            if (preferredToTerms == null) {
                throw new java.lang.NullPointerException("preferredToTerms cannot be null");
            }
            if (this.preferredToTerms == null) this.preferredToTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.preferredToTerms.addAll(preferredToTerms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPreferredToTerms() {
            if (this.preferredToTerms != null) this.preferredToTerms.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B replacedByTerm(final IGlossaryTerm replacedByTerm) {
            if (this.replacedBy == null) this.replacedBy = new java.util.ArrayList<IGlossaryTerm>();
            this.replacedBy.add(replacedByTerm);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B replacedBy(final java.util.Collection<? extends IGlossaryTerm> replacedBy) {
            if (replacedBy == null) {
                throw new java.lang.NullPointerException("replacedBy cannot be null");
            }
            if (this.replacedBy == null) this.replacedBy = new java.util.ArrayList<IGlossaryTerm>();
            this.replacedBy.addAll(replacedBy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearReplacedBy() {
            if (this.replacedBy != null) this.replacedBy.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B replacementTerm(final IGlossaryTerm replacementTerm) {
            if (this.replacementTerms == null) this.replacementTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.replacementTerms.add(replacementTerm);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B replacementTerms(final java.util.Collection<? extends IGlossaryTerm> replacementTerms) {
            if (replacementTerms == null) {
                throw new java.lang.NullPointerException("replacementTerms cannot be null");
            }
            if (this.replacementTerms == null) this.replacementTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.replacementTerms.addAll(replacementTerms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearReplacementTerms() {
            if (this.replacementTerms != null) this.replacementTerms.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B seeAlsoOne(final IGlossaryTerm seeAlsoOne) {
            if (this.seeAlso == null) this.seeAlso = new java.util.ArrayList<IGlossaryTerm>();
            this.seeAlso.add(seeAlsoOne);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B seeAlso(final java.util.Collection<? extends IGlossaryTerm> seeAlso) {
            if (seeAlso == null) {
                throw new java.lang.NullPointerException("seeAlso cannot be null");
            }
            if (this.seeAlso == null) this.seeAlso = new java.util.ArrayList<IGlossaryTerm>();
            this.seeAlso.addAll(seeAlso);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSeeAlso() {
            if (this.seeAlso != null) this.seeAlso.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B shortDescription(final String shortDescription) {
            this.shortDescription = shortDescription;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B synonym(final IGlossaryTerm synonym) {
            if (this.synonyms == null) this.synonyms = new java.util.ArrayList<IGlossaryTerm>();
            this.synonyms.add(synonym);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B synonyms(final java.util.Collection<? extends IGlossaryTerm> synonyms) {
            if (synonyms == null) {
                throw new java.lang.NullPointerException("synonyms cannot be null");
            }
            if (this.synonyms == null) this.synonyms = new java.util.ArrayList<IGlossaryTerm>();
            this.synonyms.addAll(synonyms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSynonyms() {
            if (this.synonyms != null) this.synonyms.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B termType(final AtlasGlossaryTermType termType) {
            this.termType = termType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B translatedTerm(final IGlossaryTerm translatedTerm) {
            if (this.translatedTerms == null) this.translatedTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.translatedTerms.add(translatedTerm);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B translatedTerms(final java.util.Collection<? extends IGlossaryTerm> translatedTerms) {
            if (translatedTerms == null) {
                throw new java.lang.NullPointerException("translatedTerms cannot be null");
            }
            if (this.translatedTerms == null) this.translatedTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.translatedTerms.addAll(translatedTerms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTranslatedTerms() {
            if (this.translatedTerms != null) this.translatedTerms.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B translationTerm(final IGlossaryTerm translationTerm) {
            if (this.translationTerms == null) this.translationTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.translationTerms.add(translationTerm);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B translationTerms(final java.util.Collection<? extends IGlossaryTerm> translationTerms) {
            if (translationTerms == null) {
                throw new java.lang.NullPointerException("translationTerms cannot be null");
            }
            if (this.translationTerms == null) this.translationTerms = new java.util.ArrayList<IGlossaryTerm>();
            this.translationTerms.addAll(translationTerms);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTranslationTerms() {
            if (this.translationTerms != null) this.translationTerms.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B usage(final String usage) {
            this.usage = usage;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B validValue(final IGlossaryTerm validValue) {
            if (this.validValues == null) this.validValues = new java.util.ArrayList<IGlossaryTerm>();
            this.validValues.add(validValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B validValues(final java.util.Collection<? extends IGlossaryTerm> validValues) {
            if (validValues == null) {
                throw new java.lang.NullPointerException("validValues cannot be null");
            }
            if (this.validValues == null) this.validValues = new java.util.ArrayList<IGlossaryTerm>();
            this.validValues.addAll(validValues);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearValidValues() {
            if (this.validValues != null) this.validValues.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B validValueFor(final IGlossaryTerm validValueFor) {
            if (this.validValuesFor == null) this.validValuesFor = new java.util.ArrayList<IGlossaryTerm>();
            this.validValuesFor.add(validValueFor);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B validValuesFor(final java.util.Collection<? extends IGlossaryTerm> validValuesFor) {
            if (validValuesFor == null) {
                throw new java.lang.NullPointerException("validValuesFor cannot be null");
            }
            if (this.validValuesFor == null) this.validValuesFor = new java.util.ArrayList<IGlossaryTerm>();
            this.validValuesFor.addAll(validValuesFor);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearValidValuesFor() {
            if (this.validValuesFor != null) this.validValuesFor.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "GlossaryTerm.GlossaryTermBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", abbreviation=" + this.abbreviation + ", additionalAttributes$key=" + this.additionalAttributes$key + ", additionalAttributes$value=" + this.additionalAttributes$value + ", anchor=" + this.anchor + ", antonyms=" + this.antonyms + ", assignedEntities=" + this.assignedEntities + ", categories=" + this.categories + ", classifies=" + this.classifies + ", examples=" + this.examples + ", isA=" + this.isA + ", longDescription=" + this.longDescription + ", preferredTerms=" + this.preferredTerms + ", preferredToTerms=" + this.preferredToTerms + ", replacedBy=" + this.replacedBy + ", replacementTerms=" + this.replacementTerms + ", seeAlso=" + this.seeAlso + ", shortDescription=" + this.shortDescription + ", synonyms=" + this.synonyms + ", termType=" + this.termType + ", translatedTerms=" + this.translatedTerms + ", translationTerms=" + this.translationTerms + ", usage=" + this.usage + ", validValues=" + this.validValues + ", validValuesFor=" + this.validValuesFor + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class GlossaryTermBuilderImpl extends GlossaryTerm.GlossaryTermBuilder<GlossaryTerm, GlossaryTerm.GlossaryTermBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private GlossaryTermBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected GlossaryTerm.GlossaryTermBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public GlossaryTerm build() {
            return new GlossaryTerm(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected GlossaryTerm(final GlossaryTerm.GlossaryTermBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = GlossaryTerm.$default$typeName();
        this.abbreviation = b.abbreviation;
        java.util.Map<String, String> additionalAttributes;
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
        case 0: 
            additionalAttributes = java.util.Collections.emptyMap();
            break;
        case 1: 
            additionalAttributes = java.util.Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
            break;
        default: 
            additionalAttributes = new java.util.LinkedHashMap<String, String>(b.additionalAttributes$key.size() < 1073741824 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.additionalAttributes$key.size(); $i++) additionalAttributes.put(b.additionalAttributes$key.get($i), (String) b.additionalAttributes$value.get($i));
            additionalAttributes = java.util.Collections.unmodifiableMap(additionalAttributes);
        }
        this.additionalAttributes = additionalAttributes;
        this.anchor = b.anchor;
        java.util.SortedSet<IGlossaryTerm> antonyms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.antonyms != null) antonyms.addAll(b.antonyms);
        antonyms = java.util.Collections.unmodifiableSortedSet(antonyms);
        this.antonyms = antonyms;
        java.util.SortedSet<IAsset> assignedEntities = new java.util.TreeSet<IAsset>();
        if (b.assignedEntities != null) assignedEntities.addAll(b.assignedEntities);
        assignedEntities = java.util.Collections.unmodifiableSortedSet(assignedEntities);
        this.assignedEntities = assignedEntities;
        java.util.SortedSet<IGlossaryCategory> categories = new java.util.TreeSet<IGlossaryCategory>();
        if (b.categories != null) categories.addAll(b.categories);
        categories = java.util.Collections.unmodifiableSortedSet(categories);
        this.categories = categories;
        java.util.SortedSet<IGlossaryTerm> classifies = new java.util.TreeSet<IGlossaryTerm>();
        if (b.classifies != null) classifies.addAll(b.classifies);
        classifies = java.util.Collections.unmodifiableSortedSet(classifies);
        this.classifies = classifies;
        java.util.SortedSet<String> examples = new java.util.TreeSet<String>();
        if (b.examples != null) examples.addAll(b.examples);
        examples = java.util.Collections.unmodifiableSortedSet(examples);
        this.examples = examples;
        java.util.SortedSet<IGlossaryTerm> isA = new java.util.TreeSet<IGlossaryTerm>();
        if (b.isA != null) isA.addAll(b.isA);
        isA = java.util.Collections.unmodifiableSortedSet(isA);
        this.isA = isA;
        this.longDescription = b.longDescription;
        java.util.SortedSet<IGlossaryTerm> preferredTerms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.preferredTerms != null) preferredTerms.addAll(b.preferredTerms);
        preferredTerms = java.util.Collections.unmodifiableSortedSet(preferredTerms);
        this.preferredTerms = preferredTerms;
        java.util.SortedSet<IGlossaryTerm> preferredToTerms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.preferredToTerms != null) preferredToTerms.addAll(b.preferredToTerms);
        preferredToTerms = java.util.Collections.unmodifiableSortedSet(preferredToTerms);
        this.preferredToTerms = preferredToTerms;
        java.util.SortedSet<IGlossaryTerm> replacedBy = new java.util.TreeSet<IGlossaryTerm>();
        if (b.replacedBy != null) replacedBy.addAll(b.replacedBy);
        replacedBy = java.util.Collections.unmodifiableSortedSet(replacedBy);
        this.replacedBy = replacedBy;
        java.util.SortedSet<IGlossaryTerm> replacementTerms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.replacementTerms != null) replacementTerms.addAll(b.replacementTerms);
        replacementTerms = java.util.Collections.unmodifiableSortedSet(replacementTerms);
        this.replacementTerms = replacementTerms;
        java.util.SortedSet<IGlossaryTerm> seeAlso = new java.util.TreeSet<IGlossaryTerm>();
        if (b.seeAlso != null) seeAlso.addAll(b.seeAlso);
        seeAlso = java.util.Collections.unmodifiableSortedSet(seeAlso);
        this.seeAlso = seeAlso;
        this.shortDescription = b.shortDescription;
        java.util.SortedSet<IGlossaryTerm> synonyms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.synonyms != null) synonyms.addAll(b.synonyms);
        synonyms = java.util.Collections.unmodifiableSortedSet(synonyms);
        this.synonyms = synonyms;
        this.termType = b.termType;
        java.util.SortedSet<IGlossaryTerm> translatedTerms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.translatedTerms != null) translatedTerms.addAll(b.translatedTerms);
        translatedTerms = java.util.Collections.unmodifiableSortedSet(translatedTerms);
        this.translatedTerms = translatedTerms;
        java.util.SortedSet<IGlossaryTerm> translationTerms = new java.util.TreeSet<IGlossaryTerm>();
        if (b.translationTerms != null) translationTerms.addAll(b.translationTerms);
        translationTerms = java.util.Collections.unmodifiableSortedSet(translationTerms);
        this.translationTerms = translationTerms;
        this.usage = b.usage;
        java.util.SortedSet<IGlossaryTerm> validValues = new java.util.TreeSet<IGlossaryTerm>();
        if (b.validValues != null) validValues.addAll(b.validValues);
        validValues = java.util.Collections.unmodifiableSortedSet(validValues);
        this.validValues = validValues;
        java.util.SortedSet<IGlossaryTerm> validValuesFor = new java.util.TreeSet<IGlossaryTerm>();
        if (b.validValuesFor != null) validValuesFor.addAll(b.validValuesFor);
        validValuesFor = java.util.Collections.unmodifiableSortedSet(validValuesFor);
        this.validValuesFor = validValuesFor;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static GlossaryTerm.GlossaryTermBuilder<?, ?> _internal() {
        return new GlossaryTerm.GlossaryTermBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public GlossaryTerm.GlossaryTermBuilder<?, ?> toBuilder() {
        return new GlossaryTerm.GlossaryTermBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAbbreviation() {
        return this.abbreviation;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IGlossary getAnchor() {
        return this.anchor;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getAntonyms() {
        return this.antonyms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getAssignedEntities() {
        return this.assignedEntities;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryCategory> getCategories() {
        return this.categories;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getClassifies() {
        return this.classifies;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getExamples() {
        return this.examples;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getIsA() {
        return this.isA;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getPreferredTerms() {
        return this.preferredTerms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getPreferredToTerms() {
        return this.preferredToTerms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getReplacedBy() {
        return this.replacedBy;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getReplacementTerms() {
        return this.replacementTerms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getSeeAlso() {
        return this.seeAlso;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getSynonyms() {
        return this.synonyms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlasGlossaryTermType getTermType() {
        return this.termType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getTranslatedTerms() {
        return this.translatedTerms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getTranslationTerms() {
        return this.translationTerms;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUsage() {
        return this.usage;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getValidValues() {
        return this.validValues;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IGlossaryTerm> getValidValuesFor() {
        return this.validValuesFor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GlossaryTerm)) return false;
        final GlossaryTerm other = (GlossaryTerm) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$abbreviation = this.getAbbreviation();
        final java.lang.Object other$abbreviation = other.getAbbreviation();
        if (this$abbreviation == null ? other$abbreviation != null : !this$abbreviation.equals(other$abbreviation)) return false;
        final java.lang.Object this$additionalAttributes = this.getAdditionalAttributes();
        final java.lang.Object other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !this$additionalAttributes.equals(other$additionalAttributes)) return false;
        final java.lang.Object this$anchor = this.getAnchor();
        final java.lang.Object other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) return false;
        final java.lang.Object this$antonyms = this.getAntonyms();
        final java.lang.Object other$antonyms = other.getAntonyms();
        if (this$antonyms == null ? other$antonyms != null : !this$antonyms.equals(other$antonyms)) return false;
        final java.lang.Object this$assignedEntities = this.getAssignedEntities();
        final java.lang.Object other$assignedEntities = other.getAssignedEntities();
        if (this$assignedEntities == null ? other$assignedEntities != null : !this$assignedEntities.equals(other$assignedEntities)) return false;
        final java.lang.Object this$categories = this.getCategories();
        final java.lang.Object other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !this$categories.equals(other$categories)) return false;
        final java.lang.Object this$classifies = this.getClassifies();
        final java.lang.Object other$classifies = other.getClassifies();
        if (this$classifies == null ? other$classifies != null : !this$classifies.equals(other$classifies)) return false;
        final java.lang.Object this$examples = this.getExamples();
        final java.lang.Object other$examples = other.getExamples();
        if (this$examples == null ? other$examples != null : !this$examples.equals(other$examples)) return false;
        final java.lang.Object this$isA = this.getIsA();
        final java.lang.Object other$isA = other.getIsA();
        if (this$isA == null ? other$isA != null : !this$isA.equals(other$isA)) return false;
        final java.lang.Object this$longDescription = this.getLongDescription();
        final java.lang.Object other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) return false;
        final java.lang.Object this$preferredTerms = this.getPreferredTerms();
        final java.lang.Object other$preferredTerms = other.getPreferredTerms();
        if (this$preferredTerms == null ? other$preferredTerms != null : !this$preferredTerms.equals(other$preferredTerms)) return false;
        final java.lang.Object this$preferredToTerms = this.getPreferredToTerms();
        final java.lang.Object other$preferredToTerms = other.getPreferredToTerms();
        if (this$preferredToTerms == null ? other$preferredToTerms != null : !this$preferredToTerms.equals(other$preferredToTerms)) return false;
        final java.lang.Object this$replacedBy = this.getReplacedBy();
        final java.lang.Object other$replacedBy = other.getReplacedBy();
        if (this$replacedBy == null ? other$replacedBy != null : !this$replacedBy.equals(other$replacedBy)) return false;
        final java.lang.Object this$replacementTerms = this.getReplacementTerms();
        final java.lang.Object other$replacementTerms = other.getReplacementTerms();
        if (this$replacementTerms == null ? other$replacementTerms != null : !this$replacementTerms.equals(other$replacementTerms)) return false;
        final java.lang.Object this$seeAlso = this.getSeeAlso();
        final java.lang.Object other$seeAlso = other.getSeeAlso();
        if (this$seeAlso == null ? other$seeAlso != null : !this$seeAlso.equals(other$seeAlso)) return false;
        final java.lang.Object this$shortDescription = this.getShortDescription();
        final java.lang.Object other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) return false;
        final java.lang.Object this$synonyms = this.getSynonyms();
        final java.lang.Object other$synonyms = other.getSynonyms();
        if (this$synonyms == null ? other$synonyms != null : !this$synonyms.equals(other$synonyms)) return false;
        final java.lang.Object this$termType = this.getTermType();
        final java.lang.Object other$termType = other.getTermType();
        if (this$termType == null ? other$termType != null : !this$termType.equals(other$termType)) return false;
        final java.lang.Object this$translatedTerms = this.getTranslatedTerms();
        final java.lang.Object other$translatedTerms = other.getTranslatedTerms();
        if (this$translatedTerms == null ? other$translatedTerms != null : !this$translatedTerms.equals(other$translatedTerms)) return false;
        final java.lang.Object this$translationTerms = this.getTranslationTerms();
        final java.lang.Object other$translationTerms = other.getTranslationTerms();
        if (this$translationTerms == null ? other$translationTerms != null : !this$translationTerms.equals(other$translationTerms)) return false;
        final java.lang.Object this$usage = this.getUsage();
        final java.lang.Object other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) return false;
        final java.lang.Object this$validValues = this.getValidValues();
        final java.lang.Object other$validValues = other.getValidValues();
        if (this$validValues == null ? other$validValues != null : !this$validValues.equals(other$validValues)) return false;
        final java.lang.Object this$validValuesFor = this.getValidValuesFor();
        final java.lang.Object other$validValuesFor = other.getValidValuesFor();
        if (this$validValuesFor == null ? other$validValuesFor != null : !this$validValuesFor.equals(other$validValuesFor)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof GlossaryTerm;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $abbreviation = this.getAbbreviation();
        result = result * PRIME + ($abbreviation == null ? 43 : $abbreviation.hashCode());
        final java.lang.Object $additionalAttributes = this.getAdditionalAttributes();
        result = result * PRIME + ($additionalAttributes == null ? 43 : $additionalAttributes.hashCode());
        final java.lang.Object $anchor = this.getAnchor();
        result = result * PRIME + ($anchor == null ? 43 : $anchor.hashCode());
        final java.lang.Object $antonyms = this.getAntonyms();
        result = result * PRIME + ($antonyms == null ? 43 : $antonyms.hashCode());
        final java.lang.Object $assignedEntities = this.getAssignedEntities();
        result = result * PRIME + ($assignedEntities == null ? 43 : $assignedEntities.hashCode());
        final java.lang.Object $categories = this.getCategories();
        result = result * PRIME + ($categories == null ? 43 : $categories.hashCode());
        final java.lang.Object $classifies = this.getClassifies();
        result = result * PRIME + ($classifies == null ? 43 : $classifies.hashCode());
        final java.lang.Object $examples = this.getExamples();
        result = result * PRIME + ($examples == null ? 43 : $examples.hashCode());
        final java.lang.Object $isA = this.getIsA();
        result = result * PRIME + ($isA == null ? 43 : $isA.hashCode());
        final java.lang.Object $longDescription = this.getLongDescription();
        result = result * PRIME + ($longDescription == null ? 43 : $longDescription.hashCode());
        final java.lang.Object $preferredTerms = this.getPreferredTerms();
        result = result * PRIME + ($preferredTerms == null ? 43 : $preferredTerms.hashCode());
        final java.lang.Object $preferredToTerms = this.getPreferredToTerms();
        result = result * PRIME + ($preferredToTerms == null ? 43 : $preferredToTerms.hashCode());
        final java.lang.Object $replacedBy = this.getReplacedBy();
        result = result * PRIME + ($replacedBy == null ? 43 : $replacedBy.hashCode());
        final java.lang.Object $replacementTerms = this.getReplacementTerms();
        result = result * PRIME + ($replacementTerms == null ? 43 : $replacementTerms.hashCode());
        final java.lang.Object $seeAlso = this.getSeeAlso();
        result = result * PRIME + ($seeAlso == null ? 43 : $seeAlso.hashCode());
        final java.lang.Object $shortDescription = this.getShortDescription();
        result = result * PRIME + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        final java.lang.Object $synonyms = this.getSynonyms();
        result = result * PRIME + ($synonyms == null ? 43 : $synonyms.hashCode());
        final java.lang.Object $termType = this.getTermType();
        result = result * PRIME + ($termType == null ? 43 : $termType.hashCode());
        final java.lang.Object $translatedTerms = this.getTranslatedTerms();
        result = result * PRIME + ($translatedTerms == null ? 43 : $translatedTerms.hashCode());
        final java.lang.Object $translationTerms = this.getTranslationTerms();
        result = result * PRIME + ($translationTerms == null ? 43 : $translationTerms.hashCode());
        final java.lang.Object $usage = this.getUsage();
        result = result * PRIME + ($usage == null ? 43 : $usage.hashCode());
        final java.lang.Object $validValues = this.getValidValues();
        result = result * PRIME + ($validValues == null ? 43 : $validValues.hashCode());
        final java.lang.Object $validValuesFor = this.getValidValuesFor();
        result = result * PRIME + ($validValuesFor == null ? 43 : $validValuesFor.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "GlossaryTerm(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", abbreviation=" + this.getAbbreviation() + ", additionalAttributes=" + this.getAdditionalAttributes() + ", anchor=" + this.getAnchor() + ", antonyms=" + this.getAntonyms() + ", assignedEntities=" + this.getAssignedEntities() + ", categories=" + this.getCategories() + ", classifies=" + this.getClassifies() + ", examples=" + this.getExamples() + ", isA=" + this.getIsA() + ", longDescription=" + this.getLongDescription() + ", preferredTerms=" + this.getPreferredTerms() + ", preferredToTerms=" + this.getPreferredToTerms() + ", replacedBy=" + this.getReplacedBy() + ", replacementTerms=" + this.getReplacementTerms() + ", seeAlso=" + this.getSeeAlso() + ", shortDescription=" + this.getShortDescription() + ", synonyms=" + this.getSynonyms() + ", termType=" + this.getTermType() + ", translatedTerms=" + this.getTranslatedTerms() + ", translationTerms=" + this.getTranslationTerms() + ", usage=" + this.getUsage() + ", validValues=" + this.getValidValues() + ", validValuesFor=" + this.getValidValuesFor() + ")";
    }

    /**
     * Fixed typeName for GlossaryTerms.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
