// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.List;

/**
 * Instance of an asset where we cannot determine (have not yet modeled) its detailed information.
 * In the meanwhile, this provides a catch-all case where at least the basic asset information is
 * available.
 */
public class IndistinctAsset extends Asset {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Asset";
    /**
     * Create a non-transient typeName to ensure it is included in serde.
     */
    String typeName;

    /**
     * Reference to an asset that is not yet strongly typed by GUID.
     *
     * @param guid the GUID of the asset that is not yet strongly typed to reference
     * @return reference to an asset that is not yet strongly typed that can be used for defining a relationship
     */
    public static IndistinctAsset refByGuid(String guid) {
        return IndistinctAsset._internal().guid(guid).build();
    }

    /**
     * Reference to an asset that is not yet strongly typed by qualifiedName.
     *
     * @param qualifiedName the qualifiedName of the asset that is not yet strongly typed to reference
     * @return reference to an asset that is not yet strongly typed that can be used for defining a relationship
     */
    public static IndistinctAsset refByQualifiedName(String qualifiedName) {
        return IndistinctAsset._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).build();
    }

    /**
     * Builds the minimal object necessary to update an asset that is not yet strongly typed.
     *
     * @param qualifiedName of the asset
     * @param name of the asset
     * @return the minimal request necessary to update the asset, as a builder
     */
    public static IndistinctAssetBuilder<?, ?> updater(String qualifiedName, String name) {
        return IndistinctAsset._internal().qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to an asset that is not yet strongly typed,
     * from a potentially more-complete asset object.
     *
     * @return the minimal object necessary to update the asset, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties are not found in the initial object
     */
    @Override
    public IndistinctAssetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        List<String> missing = new ArrayList<>();
        if (this.getQualifiedName() == null || this.getQualifiedName().isEmpty()) {
            missing.add("qualifiedName");
        }
        if (this.getName() == null || this.getName().isEmpty()) {
            missing.add("name");
        }
        if (!missing.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, "Asset", String.join(",", missing));
        }
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Builds the minimal object necessary to apply an update to an asset that is not yet strongly typed,
     * from a potentially more-complete asset object.
     *
     * @return the minimal object necessary to update the asset, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties are not found in the initial object
     */
    @Override
    public IndistinctAsset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, "Asset", "guid, qualifiedName");
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class IndistinctAssetBuilder<C extends IndistinctAsset, B extends IndistinctAsset.IndistinctAssetBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            IndistinctAsset.IndistinctAssetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final IndistinctAsset instance, final IndistinctAsset.IndistinctAssetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
        }

        /**
         * Create a non-transient typeName to ensure it is included in serde.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "IndistinctAsset.IndistinctAssetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class IndistinctAssetBuilderImpl extends IndistinctAsset.IndistinctAssetBuilder<IndistinctAsset, IndistinctAsset.IndistinctAssetBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IndistinctAssetBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected IndistinctAsset.IndistinctAssetBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public IndistinctAsset build() {
            return new IndistinctAsset(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected IndistinctAsset(final IndistinctAsset.IndistinctAssetBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = IndistinctAsset.$default$typeName();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static IndistinctAsset.IndistinctAssetBuilder<?, ?> _internal() {
        return new IndistinctAsset.IndistinctAssetBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IndistinctAsset.IndistinctAssetBuilder<?, ?> toBuilder() {
        return new IndistinctAsset.IndistinctAssetBuilderImpl().$fillValuesFrom(this);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof IndistinctAsset)) return false;
        final IndistinctAsset other = (IndistinctAsset) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof IndistinctAsset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "IndistinctAsset(super=" + super.toString() + ", typeName=" + this.getTypeName() + ")";
    }

    /**
     * Create a non-transient typeName to ensure it is included in serde.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
