// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a lineage process in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class LineageProcess extends Asset implements ILineageProcess, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LineageProcess.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Process";
    /**
     * Fixed typeName for LineageProcesss.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    String additionalEtlContext;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    /**
     * TBC
     */
    @Attribute
    String ast;
    /**
     * TBC
     */
    @Attribute
    String code;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IColumnProcess> columnProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ICatalog> inputs;
    /**
     * TBC
     */
    @Attribute
    IMatillionComponent matillionComponent;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ICatalog> outputs;
    /**
     * TBC
     */
    @Attribute
    IPowerBIDataflow powerBIDataflow;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> sparkJobs;
    /**
     * TBC
     */
    @Attribute
    String sql;

    /**
     * Builds the minimal object necessary to create a relationship to a LineageProcess, from a potentially
     * more-complete LineageProcess object.
     *
     * @return the minimal object necessary to relate to the LineageProcess
     * @throws InvalidRequestException if any of the minimal set of required properties for a LineageProcess relationship are not found in the initial object
     */
    @Override
    public LineageProcess trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all LineageProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LineageProcess assets will be included.
     *
     * @return a fluent search that includes all LineageProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all LineageProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LineageProcess assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all LineageProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all LineageProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) LineageProcesss will be included
     * @return a fluent search that includes all LineageProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all LineageProcess assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) LineageProcesss will be included
     * @return a fluent search that includes all LineageProcess assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a LineageProcess by GUID. Use this to create a relationship to this LineageProcess,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the LineageProcess to reference
     * @return reference to a LineageProcess that can be used for defining a relationship to a LineageProcess
     */
    public static LineageProcess refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LineageProcess by GUID. Use this to create a relationship to this LineageProcess,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the LineageProcess to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LineageProcess that can be used for defining a relationship to a LineageProcess
     */
    public static LineageProcess refByGuid(String guid, Reference.SaveSemantic semantic) {
        return LineageProcess._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a LineageProcess by qualifiedName. Use this to create a relationship to this LineageProcess,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the LineageProcess to reference
     * @return reference to a LineageProcess that can be used for defining a relationship to a LineageProcess
     */
    public static LineageProcess refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LineageProcess by qualifiedName. Use this to create a relationship to this LineageProcess,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the LineageProcess to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LineageProcess that can be used for defining a relationship to a LineageProcess
     */
    public static LineageProcess refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return LineageProcess._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a LineageProcess by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the LineageProcess to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LineageProcess, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LineageProcess does not exist or the provided GUID is not a LineageProcess
     */
    @JsonIgnore
    public static LineageProcess get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a LineageProcess by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LineageProcess to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LineageProcess, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LineageProcess does not exist or the provided GUID is not a LineageProcess
     */
    @JsonIgnore
    public static LineageProcess get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a LineageProcess by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LineageProcess to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full LineageProcess, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LineageProcess does not exist or the provided GUID is not a LineageProcess
     */
    @JsonIgnore
    public static LineageProcess get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof LineageProcess) {
                return (LineageProcess) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof LineageProcess) {
                return (LineageProcess) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) LineageProcess to active.
     *
     * @param qualifiedName for the LineageProcess
     * @return true if the LineageProcess is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) LineageProcess to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the LineageProcess
     * @return true if the LineageProcess is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a process.
     *
     * @param name of the process to use for display purposes
     * @param connectionQualifiedName unique name of the specific instance of that software / system that ran the process
     * @param id (optional) unique ID of this process within the software / system that ran it (if not provided, it will be generated)
     * @param inputs sources of data the process reads from
     * @param outputs targets of data the process writes to
     * @param parent (optional) parent process in which this sub-process ran
     * @return the minimal object necessary to create the process, as a builder
     */
    public static LineageProcessBuilder<?, ?> creator(String name, String connectionQualifiedName, String id, List<ICatalog> inputs, List<ICatalog> outputs, LineageProcess parent) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return LineageProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(name, connectionQualifiedName, id, inputs, outputs, parent)).name(name).connectorType(connectorType).connectionQualifiedName(connectionQualifiedName).inputs(inputs).outputs(outputs);
    }

    /**
     * Builds the minimal object necessary to update a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the minimal request necessary to update the LineageProcess, as a builder
     */
    public static LineageProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return LineageProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a LineageProcess, from a potentially
     * more-complete LineageProcess object.
     *
     * @return the minimal object necessary to update the LineageProcess, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for LineageProcess are not found in the initial object
     */
    @Override
    public LineageProcessBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Generate a unique qualifiedName for a process.
     *
     * @param name of the process
     * @param connectionQualifiedName unique name of the specific instance of the software / system that ran the process
     * @param id (optional) unique ID of this process within the software / system that ran it (if not provided, it will be generated)
     * @param inputs sources of data the process reads from
     * @param outputs targets of data the process writes to
     * @param parent (optional) parent process in which this sub-process ran
     * @return unique name for the process
     */
    public static String generateQualifiedName(String name, String connectionQualifiedName, String id, List<ICatalog> inputs, List<ICatalog> outputs, LineageProcess parent) {
        // If an ID was provided, use that as the unique name for the process
        if (id != null && id.length() > 0) {
            return connectionQualifiedName + "/" + id;
        } else {
            // Otherwise, hash all the relationships to arrive at a consistent
            // generated qualifiedName
            StringBuilder sb = new StringBuilder();
            sb.append(name).append(connectionQualifiedName);
            if (parent != null) {
                appendRelationship(sb, parent);
            }
            appendRelationships(sb, inputs);
            appendRelationships(sb, outputs);
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(sb.toString().getBytes(StandardCharsets.UTF_8));
                String hashed = String.format("%032x", new BigInteger(1, md.digest()));
                return connectionQualifiedName + "/" + hashed;
            } catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Unable to generate the qualifiedName for the process: MD5 algorithm does not exist on your platform!");
            }
        }
    }

    /**
     * Append all the relationships into the provided string builder.
     * @param sb into which to append
     * @param relationships to append
     */
    private static void appendRelationships(StringBuilder sb, List<ICatalog> relationships) {
        for (ICatalog relationship : relationships) {
            appendRelationship(sb, (IAsset) relationship);
        }
    }

    /**
     * Append a single relationship into the provided string builder.
     * @param sb into which to append
     * @param relationship to append
     */
    private static void appendRelationship(StringBuilder sb, IAsset relationship) {
        // TODO: if two calls are made for the same process, but one uses GUIDs for
        //  its references and the other uses qualifiedName, we'll end up with different
        //  hashes (duplicate processes)
        if (relationship.getGuid() != null) {
            sb.append(relationship.getGuid());
        } else if (relationship.getUniqueAttributes() != null && relationship.getUniqueAttributes().getQualifiedName() != null) {
            sb.append(relationship.getUniqueAttributes().getQualifiedName());
        }
    }

    /**
     * Remove the system description from a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a LineageProcess.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a LineageProcess.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a LineageProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LineageProcess's owners
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LineageProcess, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a LineageProcess.
     *
     * @param client connectivity to the Atlan tenant on which to update the LineageProcess's certificate
     * @param qualifiedName of the LineageProcess
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LineageProcess, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LineageProcess) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a LineageProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LineageProcess's certificate
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a LineageProcess.
     *
     * @param client connectivity to the Atlan tenant on which to update the LineageProcess's announcement
     * @param qualifiedName of the LineageProcess
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LineageProcess) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a LineageProcess.
     *
     * @param client connectivity to the Atlan client from which to remove the LineageProcess's announcement
     * @param qualifiedName of the LineageProcess
     * @param name of the LineageProcess
     * @return the updated LineageProcess, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the LineageProcess.
     *
     * @param qualifiedName for the LineageProcess
     * @param name human-readable name of the LineageProcess
     * @param terms the list of terms to replace on the LineageProcess, or null to remove all terms from the LineageProcess
     * @return the LineageProcess that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LineageProcess replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the LineageProcess.
     *
     * @param client connectivity to the Atlan tenant on which to replace the LineageProcess's assigned terms
     * @param qualifiedName for the LineageProcess
     * @param name human-readable name of the LineageProcess
     * @param terms the list of terms to replace on the LineageProcess, or null to remove all terms from the LineageProcess
     * @return the LineageProcess that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LineageProcess replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LineageProcess) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the LineageProcess, without replacing existing terms linked to the LineageProcess.
     * Note: this operation must make two API calls — one to retrieve the LineageProcess's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the LineageProcess
     * @param terms the list of terms to append to the LineageProcess
     * @return the LineageProcess that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LineageProcess appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the LineageProcess, without replacing existing terms linked to the LineageProcess.
     * Note: this operation must make two API calls — one to retrieve the LineageProcess's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the LineageProcess
     * @param qualifiedName for the LineageProcess
     * @param terms the list of terms to append to the LineageProcess
     * @return the LineageProcess that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LineageProcess appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LineageProcess) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a LineageProcess, without replacing all existing terms linked to the LineageProcess.
     * Note: this operation must make two API calls — one to retrieve the LineageProcess's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the LineageProcess
     * @param terms the list of terms to remove from the LineageProcess, which must be referenced by GUID
     * @return the LineageProcess that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a LineageProcess, without replacing all existing terms linked to the LineageProcess.
     * Note: this operation must make two API calls — one to retrieve the LineageProcess's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the LineageProcess
     * @param qualifiedName for the LineageProcess
     * @param terms the list of terms to remove from the LineageProcess, which must be referenced by GUID
     * @return the LineageProcess that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LineageProcess removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LineageProcess) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a LineageProcess, without replacing existing Atlan tags linked to the LineageProcess.
     * Note: this operation must make two API calls — one to retrieve the LineageProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LineageProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LineageProcess
     */
    public static LineageProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LineageProcess, without replacing existing Atlan tags linked to the LineageProcess.
     * Note: this operation must make two API calls — one to retrieve the LineageProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LineageProcess
     * @param qualifiedName of the LineageProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LineageProcess
     */
    public static LineageProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LineageProcess) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LineageProcess, without replacing existing Atlan tags linked to the LineageProcess.
     * Note: this operation must make two API calls — one to retrieve the LineageProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LineageProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LineageProcess
     */
    public static LineageProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a LineageProcess, without replacing existing Atlan tags linked to the LineageProcess.
     * Note: this operation must make two API calls — one to retrieve the LineageProcess's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LineageProcess
     * @param qualifiedName of the LineageProcess
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LineageProcess
     */
    public static LineageProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LineageProcess) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a LineageProcess.
     *
     * @param qualifiedName of the LineageProcess
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LineageProcess
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a LineageProcess.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a LineageProcess
     * @param qualifiedName of the LineageProcess
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LineageProcess
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LineageProcessBuilder<C extends LineageProcess, B extends LineageProcess.LineageProcessBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String additionalEtlContext;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> airflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String ast;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String code;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumnProcess> columnProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICatalog> inputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMatillionComponent matillionComponent;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICatalog> outputs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IPowerBIDataflow powerBIDataflow;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> sparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sql;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LineageProcess.LineageProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LineageProcess instance, final LineageProcess.LineageProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalEtlContext(instance.additionalEtlContext);
            b.airflowTasks(instance.airflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.airflowTasks);
            b.ast(instance.ast);
            b.code(instance.code);
            b.columnProcesses(instance.columnProcesses == null ? java.util.Collections.<IColumnProcess>emptySortedSet() : instance.columnProcesses);
            b.inputs(instance.inputs == null ? java.util.Collections.<ICatalog>emptySortedSet() : instance.inputs);
            b.matillionComponent(instance.matillionComponent);
            b.outputs(instance.outputs == null ? java.util.Collections.<ICatalog>emptySortedSet() : instance.outputs);
            b.powerBIDataflow(instance.powerBIDataflow);
            b.sparkJobs(instance.sparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.sparkJobs);
            b.sql(instance.sql);
        }

        /**
         * Fixed typeName for LineageProcesss.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B additionalEtlContext(final String additionalEtlContext) {
            this.additionalEtlContext = additionalEtlContext;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTask(final IAirflowTask airflowTask) {
            if (this.airflowTasks == null) this.airflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.airflowTasks.add(airflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B airflowTasks(final java.util.Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new java.lang.NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) this.airflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.airflowTasks.addAll(airflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) this.airflowTasks.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B ast(final String ast) {
            this.ast = ast;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B code(final String code) {
            this.code = code;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnProcess(final IColumnProcess columnProcess) {
            if (this.columnProcesses == null) this.columnProcesses = new java.util.ArrayList<IColumnProcess>();
            this.columnProcesses.add(columnProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columnProcesses(final java.util.Collection<? extends IColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new java.lang.NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) this.columnProcesses = new java.util.ArrayList<IColumnProcess>();
            this.columnProcesses.addAll(columnProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) this.columnProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B input(final ICatalog input) {
            if (this.inputs == null) this.inputs = new java.util.ArrayList<ICatalog>();
            this.inputs.add(input);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputs(final java.util.Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new java.lang.NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) this.inputs = new java.util.ArrayList<ICatalog>();
            this.inputs.addAll(inputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputs() {
            if (this.inputs != null) this.inputs.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponent(final IMatillionComponent matillionComponent) {
            this.matillionComponent = matillionComponent;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B output(final ICatalog output) {
            if (this.outputs == null) this.outputs = new java.util.ArrayList<ICatalog>();
            this.outputs.add(output);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputs(final java.util.Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new java.lang.NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) this.outputs = new java.util.ArrayList<ICatalog>();
            this.outputs.addAll(outputs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputs() {
            if (this.outputs != null) this.outputs.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflow(final IPowerBIDataflow powerBIDataflow) {
            this.powerBIDataflow = powerBIDataflow;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sparkJob(final ISparkJob sparkJob) {
            if (this.sparkJobs == null) this.sparkJobs = new java.util.ArrayList<ISparkJob>();
            this.sparkJobs.add(sparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sparkJobs(final java.util.Collection<? extends ISparkJob> sparkJobs) {
            if (sparkJobs == null) {
                throw new java.lang.NullPointerException("sparkJobs cannot be null");
            }
            if (this.sparkJobs == null) this.sparkJobs = new java.util.ArrayList<ISparkJob>();
            this.sparkJobs.addAll(sparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSparkJobs() {
            if (this.sparkJobs != null) this.sparkJobs.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sql(final String sql) {
            this.sql = sql;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LineageProcess.LineageProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalEtlContext=" + this.additionalEtlContext + ", airflowTasks=" + this.airflowTasks + ", ast=" + this.ast + ", code=" + this.code + ", columnProcesses=" + this.columnProcesses + ", inputs=" + this.inputs + ", matillionComponent=" + this.matillionComponent + ", outputs=" + this.outputs + ", powerBIDataflow=" + this.powerBIDataflow + ", sparkJobs=" + this.sparkJobs + ", sql=" + this.sql + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class LineageProcessBuilderImpl extends LineageProcess.LineageProcessBuilder<LineageProcess, LineageProcess.LineageProcessBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LineageProcessBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LineageProcess.LineageProcessBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LineageProcess build() {
            return new LineageProcess(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LineageProcess(final LineageProcess.LineageProcessBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = LineageProcess.$default$typeName();
        this.additionalEtlContext = b.additionalEtlContext;
        java.util.SortedSet<IAirflowTask> airflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) airflowTasks.addAll(b.airflowTasks);
        airflowTasks = java.util.Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        this.ast = b.ast;
        this.code = b.code;
        java.util.SortedSet<IColumnProcess> columnProcesses = new java.util.TreeSet<IColumnProcess>();
        if (b.columnProcesses != null) columnProcesses.addAll(b.columnProcesses);
        columnProcesses = java.util.Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
        java.util.SortedSet<ICatalog> inputs = new java.util.TreeSet<ICatalog>();
        if (b.inputs != null) inputs.addAll(b.inputs);
        inputs = java.util.Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        this.matillionComponent = b.matillionComponent;
        java.util.SortedSet<ICatalog> outputs = new java.util.TreeSet<ICatalog>();
        if (b.outputs != null) outputs.addAll(b.outputs);
        outputs = java.util.Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.powerBIDataflow = b.powerBIDataflow;
        java.util.SortedSet<ISparkJob> sparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.sparkJobs != null) sparkJobs.addAll(b.sparkJobs);
        sparkJobs = java.util.Collections.unmodifiableSortedSet(sparkJobs);
        this.sparkJobs = sparkJobs;
        this.sql = b.sql;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LineageProcess.LineageProcessBuilder<?, ?> _internal() {
        return new LineageProcess.LineageProcessBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LineageProcess.LineageProcessBuilder<?, ?> toBuilder() {
        return new LineageProcess.LineageProcessBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAdditionalEtlContext() {
        return this.additionalEtlContext;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAst() {
        return this.ast;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCode() {
        return this.code;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMatillionComponent getMatillionComponent() {
        return this.matillionComponent;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IPowerBIDataflow getPowerBIDataflow() {
        return this.powerBIDataflow;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getSparkJobs() {
        return this.sparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSql() {
        return this.sql;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LineageProcess)) return false;
        final LineageProcess other = (LineageProcess) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$additionalEtlContext = this.getAdditionalEtlContext();
        final java.lang.Object other$additionalEtlContext = other.getAdditionalEtlContext();
        if (this$additionalEtlContext == null ? other$additionalEtlContext != null : !this$additionalEtlContext.equals(other$additionalEtlContext)) return false;
        final java.lang.Object this$airflowTasks = this.getAirflowTasks();
        final java.lang.Object other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) return false;
        final java.lang.Object this$ast = this.getAst();
        final java.lang.Object other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) return false;
        final java.lang.Object this$code = this.getCode();
        final java.lang.Object other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
        final java.lang.Object this$columnProcesses = this.getColumnProcesses();
        final java.lang.Object other$columnProcesses = other.getColumnProcesses();
        if (this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses)) return false;
        final java.lang.Object this$inputs = this.getInputs();
        final java.lang.Object other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) return false;
        final java.lang.Object this$matillionComponent = this.getMatillionComponent();
        final java.lang.Object other$matillionComponent = other.getMatillionComponent();
        if (this$matillionComponent == null ? other$matillionComponent != null : !this$matillionComponent.equals(other$matillionComponent)) return false;
        final java.lang.Object this$outputs = this.getOutputs();
        final java.lang.Object other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) return false;
        final java.lang.Object this$powerBIDataflow = this.getPowerBIDataflow();
        final java.lang.Object other$powerBIDataflow = other.getPowerBIDataflow();
        if (this$powerBIDataflow == null ? other$powerBIDataflow != null : !this$powerBIDataflow.equals(other$powerBIDataflow)) return false;
        final java.lang.Object this$sparkJobs = this.getSparkJobs();
        final java.lang.Object other$sparkJobs = other.getSparkJobs();
        if (this$sparkJobs == null ? other$sparkJobs != null : !this$sparkJobs.equals(other$sparkJobs)) return false;
        final java.lang.Object this$sql = this.getSql();
        final java.lang.Object other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LineageProcess;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $additionalEtlContext = this.getAdditionalEtlContext();
        result = result * PRIME + ($additionalEtlContext == null ? 43 : $additionalEtlContext.hashCode());
        final java.lang.Object $airflowTasks = this.getAirflowTasks();
        result = result * PRIME + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        final java.lang.Object $ast = this.getAst();
        result = result * PRIME + ($ast == null ? 43 : $ast.hashCode());
        final java.lang.Object $code = this.getCode();
        result = result * PRIME + ($code == null ? 43 : $code.hashCode());
        final java.lang.Object $columnProcesses = this.getColumnProcesses();
        result = result * PRIME + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        final java.lang.Object $inputs = this.getInputs();
        result = result * PRIME + ($inputs == null ? 43 : $inputs.hashCode());
        final java.lang.Object $matillionComponent = this.getMatillionComponent();
        result = result * PRIME + ($matillionComponent == null ? 43 : $matillionComponent.hashCode());
        final java.lang.Object $outputs = this.getOutputs();
        result = result * PRIME + ($outputs == null ? 43 : $outputs.hashCode());
        final java.lang.Object $powerBIDataflow = this.getPowerBIDataflow();
        result = result * PRIME + ($powerBIDataflow == null ? 43 : $powerBIDataflow.hashCode());
        final java.lang.Object $sparkJobs = this.getSparkJobs();
        result = result * PRIME + ($sparkJobs == null ? 43 : $sparkJobs.hashCode());
        final java.lang.Object $sql = this.getSql();
        result = result * PRIME + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LineageProcess(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalEtlContext=" + this.getAdditionalEtlContext() + ", airflowTasks=" + this.getAirflowTasks() + ", ast=" + this.getAst() + ", code=" + this.getCode() + ", columnProcesses=" + this.getColumnProcesses() + ", inputs=" + this.getInputs() + ", matillionComponent=" + this.getMatillionComponent() + ", outputs=" + this.getOutputs() + ", powerBIDataflow=" + this.getPowerBIDataflow() + ", sparkJobs=" + this.getSparkJobs() + ", sql=" + this.getSql() + ")";
    }

    /**
     * Fixed typeName for LineageProcesss.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
