// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Looker Explore in Atlan. Explores are views that users can query in Looker.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class LookerExplore extends Asset implements ILookerExplore, ILooker, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LookerExplore.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerExplore";
    /**
     * Fixed typeName for LookerExplores.
     */
    String typeName;
    /**
     * Fields that exist within this Explore.
     */
    @Attribute
    SortedSet<ILookerField> fields;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Model in which this explore exists.
     */
    @Attribute
    ILookerModel model;
    /**
     * Name of the parent model of this Explore.
     */
    @Attribute
    String modelName;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Project in which this explore exists.
     */
    @Attribute
    ILookerProject project;
    /**
     * Name of the parent project of this Explore.
     */
    @Attribute
    String projectName;
    /**
     * Connection name for the Explore, from Looker.
     */
    @Attribute
    String sourceConnectionName;
    /**
     * Name of the SQL table used to declare the Explore.
     */
    @Attribute
    String sqlTableName;
    /**
     * Name of the view for the Explore.
     */
    @Attribute
    String viewName;

    /**
     * Builds the minimal object necessary to create a relationship to a LookerExplore, from a potentially
     * more-complete LookerExplore object.
     *
     * @return the minimal object necessary to relate to the LookerExplore
     * @throws InvalidRequestException if any of the minimal set of required properties for a LookerExplore relationship are not found in the initial object
     */
    @Override
    public LookerExplore trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all LookerExplore assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerExplore assets will be included.
     *
     * @return a fluent search that includes all LookerExplore assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all LookerExplore assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerExplore assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all LookerExplore assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all LookerExplore assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) LookerExplores will be included
     * @return a fluent search that includes all LookerExplore assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all LookerExplore assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) LookerExplores will be included
     * @return a fluent search that includes all LookerExplore assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a LookerExplore by GUID. Use this to create a relationship to this LookerExplore,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the LookerExplore to reference
     * @return reference to a LookerExplore that can be used for defining a relationship to a LookerExplore
     */
    public static LookerExplore refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerExplore by GUID. Use this to create a relationship to this LookerExplore,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the LookerExplore to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerExplore that can be used for defining a relationship to a LookerExplore
     */
    public static LookerExplore refByGuid(String guid, Reference.SaveSemantic semantic) {
        return LookerExplore._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a LookerExplore by qualifiedName. Use this to create a relationship to this LookerExplore,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the LookerExplore to reference
     * @return reference to a LookerExplore that can be used for defining a relationship to a LookerExplore
     */
    public static LookerExplore refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerExplore by qualifiedName. Use this to create a relationship to this LookerExplore,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the LookerExplore to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerExplore that can be used for defining a relationship to a LookerExplore
     */
    public static LookerExplore refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return LookerExplore._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a LookerExplore by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the LookerExplore to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerExplore, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerExplore does not exist or the provided GUID is not a LookerExplore
     */
    @JsonIgnore
    public static LookerExplore get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a LookerExplore by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerExplore to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerExplore, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerExplore does not exist or the provided GUID is not a LookerExplore
     */
    @JsonIgnore
    public static LookerExplore get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a LookerExplore by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerExplore to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full LookerExplore, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerExplore does not exist or the provided GUID is not a LookerExplore
     */
    @JsonIgnore
    public static LookerExplore get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof LookerExplore) {
                return (LookerExplore) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof LookerExplore) {
                return (LookerExplore) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) LookerExplore to active.
     *
     * @param qualifiedName for the LookerExplore
     * @return true if the LookerExplore is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) LookerExplore to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the LookerExplore
     * @return true if the LookerExplore is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the minimal request necessary to update the LookerExplore, as a builder
     */
    public static LookerExploreBuilder<?, ?> updater(String qualifiedName, String name) {
        return LookerExplore._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a LookerExplore, from a potentially
     * more-complete LookerExplore object.
     *
     * @return the minimal object necessary to update the LookerExplore, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for LookerExplore are not found in the initial object
     */
    @Override
    public LookerExploreBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a LookerExplore.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a LookerExplore.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a LookerExplore.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerExplore's owners
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerExplore, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a LookerExplore.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerExplore's certificate
     * @param qualifiedName of the LookerExplore
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerExplore, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerExplore) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a LookerExplore.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerExplore's certificate
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a LookerExplore.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerExplore's announcement
     * @param qualifiedName of the LookerExplore
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerExplore) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a LookerExplore.
     *
     * @param client connectivity to the Atlan client from which to remove the LookerExplore's announcement
     * @param qualifiedName of the LookerExplore
     * @param name of the LookerExplore
     * @return the updated LookerExplore, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerExplore) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the LookerExplore.
     *
     * @param qualifiedName for the LookerExplore
     * @param name human-readable name of the LookerExplore
     * @param terms the list of terms to replace on the LookerExplore, or null to remove all terms from the LookerExplore
     * @return the LookerExplore that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerExplore replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the LookerExplore.
     *
     * @param client connectivity to the Atlan tenant on which to replace the LookerExplore's assigned terms
     * @param qualifiedName for the LookerExplore
     * @param name human-readable name of the LookerExplore
     * @param terms the list of terms to replace on the LookerExplore, or null to remove all terms from the LookerExplore
     * @return the LookerExplore that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerExplore replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerExplore) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the LookerExplore, without replacing existing terms linked to the LookerExplore.
     * Note: this operation must make two API calls — one to retrieve the LookerExplore's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the LookerExplore
     * @param terms the list of terms to append to the LookerExplore
     * @return the LookerExplore that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerExplore appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the LookerExplore, without replacing existing terms linked to the LookerExplore.
     * Note: this operation must make two API calls — one to retrieve the LookerExplore's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the LookerExplore
     * @param qualifiedName for the LookerExplore
     * @param terms the list of terms to append to the LookerExplore
     * @return the LookerExplore that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerExplore appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerExplore) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerExplore, without replacing all existing terms linked to the LookerExplore.
     * Note: this operation must make two API calls — one to retrieve the LookerExplore's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the LookerExplore
     * @param terms the list of terms to remove from the LookerExplore, which must be referenced by GUID
     * @return the LookerExplore that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerExplore, without replacing all existing terms linked to the LookerExplore.
     * Note: this operation must make two API calls — one to retrieve the LookerExplore's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the LookerExplore
     * @param qualifiedName for the LookerExplore
     * @param terms the list of terms to remove from the LookerExplore, which must be referenced by GUID
     * @return the LookerExplore that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerExplore removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerExplore) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a LookerExplore, without replacing existing Atlan tags linked to the LookerExplore.
     * Note: this operation must make two API calls — one to retrieve the LookerExplore's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerExplore
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerExplore
     */
    public static LookerExplore appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerExplore, without replacing existing Atlan tags linked to the LookerExplore.
     * Note: this operation must make two API calls — one to retrieve the LookerExplore's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerExplore
     * @param qualifiedName of the LookerExplore
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerExplore
     */
    public static LookerExplore appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerExplore) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerExplore, without replacing existing Atlan tags linked to the LookerExplore.
     * Note: this operation must make two API calls — one to retrieve the LookerExplore's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerExplore
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerExplore
     */
    public static LookerExplore appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a LookerExplore, without replacing existing Atlan tags linked to the LookerExplore.
     * Note: this operation must make two API calls — one to retrieve the LookerExplore's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerExplore
     * @param qualifiedName of the LookerExplore
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerExplore
     */
    public static LookerExplore appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerExplore) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a LookerExplore.
     *
     * @param qualifiedName of the LookerExplore
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerExplore
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a LookerExplore.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a LookerExplore
     * @param qualifiedName of the LookerExplore
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerExplore
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LookerExploreBuilder<C extends LookerExplore, B extends LookerExplore.LookerExploreBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerField> fields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerModel model;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerProject project;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String projectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceConnectionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sqlTableName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LookerExplore.LookerExploreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LookerExplore instance, final LookerExplore.LookerExploreBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.fields(instance.fields == null ? java.util.Collections.<ILookerField>emptySortedSet() : instance.fields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.model(instance.model);
            b.modelName(instance.modelName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.project(instance.project);
            b.projectName(instance.projectName);
            b.sourceConnectionName(instance.sourceConnectionName);
            b.sqlTableName(instance.sqlTableName);
            b.viewName(instance.viewName);
        }

        /**
         * Fixed typeName for LookerExplores.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B field(final ILookerField field) {
            if (this.fields == null) this.fields = new java.util.ArrayList<ILookerField>();
            this.fields.add(field);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B fields(final java.util.Collection<? extends ILookerField> fields) {
            if (fields == null) {
                throw new java.lang.NullPointerException("fields cannot be null");
            }
            if (this.fields == null) this.fields = new java.util.ArrayList<ILookerField>();
            this.fields.addAll(fields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearFields() {
            if (this.fields != null) this.fields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Model in which this explore exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B model(final ILookerModel model) {
            this.model = model;
            return self();
        }

        /**
         * Name of the parent model of this Explore.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelName(final String modelName) {
            this.modelName = modelName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Project in which this explore exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B project(final ILookerProject project) {
            this.project = project;
            return self();
        }

        /**
         * Name of the parent project of this Explore.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectName(final String projectName) {
            this.projectName = projectName;
            return self();
        }

        /**
         * Connection name for the Explore, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceConnectionName(final String sourceConnectionName) {
            this.sourceConnectionName = sourceConnectionName;
            return self();
        }

        /**
         * Name of the SQL table used to declare the Explore.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlTableName(final String sqlTableName) {
            this.sqlTableName = sqlTableName;
            return self();
        }

        /**
         * Name of the view for the Explore.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewName(final String viewName) {
            this.viewName = viewName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LookerExplore.LookerExploreBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", fields=" + this.fields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", model=" + this.model + ", modelName=" + this.modelName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", project=" + this.project + ", projectName=" + this.projectName + ", sourceConnectionName=" + this.sourceConnectionName + ", sqlTableName=" + this.sqlTableName + ", viewName=" + this.viewName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class LookerExploreBuilderImpl extends LookerExplore.LookerExploreBuilder<LookerExplore, LookerExplore.LookerExploreBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LookerExploreBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LookerExplore.LookerExploreBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LookerExplore build() {
            return new LookerExplore(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LookerExplore(final LookerExplore.LookerExploreBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = LookerExplore.$default$typeName();
        java.util.SortedSet<ILookerField> fields = new java.util.TreeSet<ILookerField>();
        if (b.fields != null) fields.addAll(b.fields);
        fields = java.util.Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.model = b.model;
        this.modelName = b.modelName;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.project = b.project;
        this.projectName = b.projectName;
        this.sourceConnectionName = b.sourceConnectionName;
        this.sqlTableName = b.sqlTableName;
        this.viewName = b.viewName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LookerExplore.LookerExploreBuilder<?, ?> _internal() {
        return new LookerExplore.LookerExploreBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LookerExplore.LookerExploreBuilder<?, ?> toBuilder() {
        return new LookerExplore.LookerExploreBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Fields that exist within this Explore.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerField> getFields() {
        return this.fields;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Model in which this explore exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerModel getModel() {
        return this.model;
    }

    /**
     * Name of the parent model of this Explore.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelName() {
        return this.modelName;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Project in which this explore exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerProject getProject() {
        return this.project;
    }

    /**
     * Name of the parent project of this Explore.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * Connection name for the Explore, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceConnectionName() {
        return this.sourceConnectionName;
    }

    /**
     * Name of the SQL table used to declare the Explore.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSqlTableName() {
        return this.sqlTableName;
    }

    /**
     * Name of the view for the Explore.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewName() {
        return this.viewName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LookerExplore)) return false;
        final LookerExplore other = (LookerExplore) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$fields = this.getFields();
        final java.lang.Object other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$model = this.getModel();
        final java.lang.Object other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) return false;
        final java.lang.Object this$modelName = this.getModelName();
        final java.lang.Object other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$project = this.getProject();
        final java.lang.Object other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) return false;
        final java.lang.Object this$projectName = this.getProjectName();
        final java.lang.Object other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) return false;
        final java.lang.Object this$sourceConnectionName = this.getSourceConnectionName();
        final java.lang.Object other$sourceConnectionName = other.getSourceConnectionName();
        if (this$sourceConnectionName == null ? other$sourceConnectionName != null : !this$sourceConnectionName.equals(other$sourceConnectionName)) return false;
        final java.lang.Object this$sqlTableName = this.getSqlTableName();
        final java.lang.Object other$sqlTableName = other.getSqlTableName();
        if (this$sqlTableName == null ? other$sqlTableName != null : !this$sqlTableName.equals(other$sqlTableName)) return false;
        final java.lang.Object this$viewName = this.getViewName();
        final java.lang.Object other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LookerExplore;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $fields = this.getFields();
        result = result * PRIME + ($fields == null ? 43 : $fields.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $model = this.getModel();
        result = result * PRIME + ($model == null ? 43 : $model.hashCode());
        final java.lang.Object $modelName = this.getModelName();
        result = result * PRIME + ($modelName == null ? 43 : $modelName.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $project = this.getProject();
        result = result * PRIME + ($project == null ? 43 : $project.hashCode());
        final java.lang.Object $projectName = this.getProjectName();
        result = result * PRIME + ($projectName == null ? 43 : $projectName.hashCode());
        final java.lang.Object $sourceConnectionName = this.getSourceConnectionName();
        result = result * PRIME + ($sourceConnectionName == null ? 43 : $sourceConnectionName.hashCode());
        final java.lang.Object $sqlTableName = this.getSqlTableName();
        result = result * PRIME + ($sqlTableName == null ? 43 : $sqlTableName.hashCode());
        final java.lang.Object $viewName = this.getViewName();
        result = result * PRIME + ($viewName == null ? 43 : $viewName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LookerExplore(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", fields=" + this.getFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", model=" + this.getModel() + ", modelName=" + this.getModelName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", project=" + this.getProject() + ", projectName=" + this.getProjectName() + ", sourceConnectionName=" + this.getSourceConnectionName() + ", sqlTableName=" + this.getSqlTableName() + ", viewName=" + this.getViewName() + ")";
    }

    /**
     * Fixed typeName for LookerExplores.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
