// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Looker field in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class LookerField extends Asset implements ILookerField, ILooker, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LookerField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerField";
    /**
     * Fixed typeName for LookerFields.
     */
    String typeName;
    /**
     * Dashboard in which this field is used.
     */
    @Attribute
    ILookerDashboard dashboard;
    /**
     * Explore in which this field exists.
     */
    @Attribute
    ILookerExplore explore;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Look in which this field is used.
     */
    @Attribute
    ILookerLook look;
    /**
     * Unique name of the dashboard in which this field is used.
     */
    @Attribute
    String lookerDashboardQualifiedName;
    /**
     * Unique name of the Explore in which this field exists.
     */
    @Attribute
    String lookerExploreQualifiedName;
    /**
     * Deprecated.
     */
    @Attribute
    String lookerFieldDataType;
    /**
     * Unique name of the look in which this field is used.
     */
    @Attribute
    String lookerLookQualifiedName;
    /**
     * Unique name of the tile in which this field is used.
     */
    @Attribute
    String lookerTileQualifiedName;
    /**
     * Deprecated.
     */
    @Attribute
    Integer lookerTimesUsed;
    /**
     * Unique name of the view in which this field exists.
     */
    @Attribute
    String lookerViewQualifiedName;
    /**
     * Model in which this field exists.
     */
    @Attribute
    ILookerModel model;
    /**
     * Name of the model in which this field exists.
     */
    @Attribute
    String modelName;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Project in which this field exists.
     */
    @Attribute
    ILookerProject project;
    /**
     * Name of the project in which this field exists.
     */
    @Attribute
    String projectName;
    /**
     * Deprecated.
     */
    @Attribute
    String sourceDefinition;
    /**
     * Tile in which this field is used.
     */
    @Attribute
    ILookerTile tile;
    /**
     * View in which this field exists.
     */
    @Attribute
    ILookerView view;

    /**
     * Builds the minimal object necessary to create a relationship to a LookerField, from a potentially
     * more-complete LookerField object.
     *
     * @return the minimal object necessary to relate to the LookerField
     * @throws InvalidRequestException if any of the minimal set of required properties for a LookerField relationship are not found in the initial object
     */
    @Override
    public LookerField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all LookerField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerField assets will be included.
     *
     * @return a fluent search that includes all LookerField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all LookerField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerField assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all LookerField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all LookerField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) LookerFields will be included
     * @return a fluent search that includes all LookerField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all LookerField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) LookerFields will be included
     * @return a fluent search that includes all LookerField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a LookerField by GUID. Use this to create a relationship to this LookerField,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the LookerField to reference
     * @return reference to a LookerField that can be used for defining a relationship to a LookerField
     */
    public static LookerField refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerField by GUID. Use this to create a relationship to this LookerField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the LookerField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerField that can be used for defining a relationship to a LookerField
     */
    public static LookerField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return LookerField._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a LookerField by qualifiedName. Use this to create a relationship to this LookerField,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the LookerField to reference
     * @return reference to a LookerField that can be used for defining a relationship to a LookerField
     */
    public static LookerField refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerField by qualifiedName. Use this to create a relationship to this LookerField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the LookerField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerField that can be used for defining a relationship to a LookerField
     */
    public static LookerField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return LookerField._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a LookerField by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the LookerField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerField does not exist or the provided GUID is not a LookerField
     */
    @JsonIgnore
    public static LookerField get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a LookerField by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerField does not exist or the provided GUID is not a LookerField
     */
    @JsonIgnore
    public static LookerField get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a LookerField by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerField to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full LookerField, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerField does not exist or the provided GUID is not a LookerField
     */
    @JsonIgnore
    public static LookerField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof LookerField) {
                return (LookerField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof LookerField) {
                return (LookerField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) LookerField to active.
     *
     * @param qualifiedName for the LookerField
     * @return true if the LookerField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) LookerField to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the LookerField
     * @return true if the LookerField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the minimal request necessary to update the LookerField, as a builder
     */
    public static LookerFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return LookerField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a LookerField, from a potentially
     * more-complete LookerField object.
     *
     * @return the minimal object necessary to update the LookerField, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for LookerField are not found in the initial object
     */
    @Override
    public LookerFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a LookerField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a LookerField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a LookerField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerField's owners
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a LookerField.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerField's certificate
     * @param qualifiedName of the LookerField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerField) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a LookerField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerField's certificate
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a LookerField.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerField's announcement
     * @param qualifiedName of the LookerField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerField) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a LookerField.
     *
     * @param client connectivity to the Atlan client from which to remove the LookerField's announcement
     * @param qualifiedName of the LookerField
     * @param name of the LookerField
     * @return the updated LookerField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerField) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the LookerField.
     *
     * @param qualifiedName for the LookerField
     * @param name human-readable name of the LookerField
     * @param terms the list of terms to replace on the LookerField, or null to remove all terms from the LookerField
     * @return the LookerField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the LookerField.
     *
     * @param client connectivity to the Atlan tenant on which to replace the LookerField's assigned terms
     * @param qualifiedName for the LookerField
     * @param name human-readable name of the LookerField
     * @param terms the list of terms to replace on the LookerField, or null to remove all terms from the LookerField
     * @return the LookerField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the LookerField, without replacing existing terms linked to the LookerField.
     * Note: this operation must make two API calls — one to retrieve the LookerField's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the LookerField
     * @param terms the list of terms to append to the LookerField
     * @return the LookerField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the LookerField, without replacing existing terms linked to the LookerField.
     * Note: this operation must make two API calls — one to retrieve the LookerField's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the LookerField
     * @param qualifiedName for the LookerField
     * @param terms the list of terms to append to the LookerField
     * @return the LookerField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerField, without replacing all existing terms linked to the LookerField.
     * Note: this operation must make two API calls — one to retrieve the LookerField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the LookerField
     * @param terms the list of terms to remove from the LookerField, which must be referenced by GUID
     * @return the LookerField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerField, without replacing all existing terms linked to the LookerField.
     * Note: this operation must make two API calls — one to retrieve the LookerField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the LookerField
     * @param qualifiedName for the LookerField
     * @param terms the list of terms to remove from the LookerField, which must be referenced by GUID
     * @return the LookerField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerField) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a LookerField, without replacing existing Atlan tags linked to the LookerField.
     * Note: this operation must make two API calls — one to retrieve the LookerField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerField
     */
    public static LookerField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerField, without replacing existing Atlan tags linked to the LookerField.
     * Note: this operation must make two API calls — one to retrieve the LookerField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerField
     * @param qualifiedName of the LookerField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerField
     */
    public static LookerField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerField, without replacing existing Atlan tags linked to the LookerField.
     * Note: this operation must make two API calls — one to retrieve the LookerField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerField
     */
    public static LookerField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a LookerField, without replacing existing Atlan tags linked to the LookerField.
     * Note: this operation must make two API calls — one to retrieve the LookerField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerField
     * @param qualifiedName of the LookerField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerField
     */
    public static LookerField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a LookerField.
     *
     * @param qualifiedName of the LookerField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerField
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a LookerField.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a LookerField
     * @param qualifiedName of the LookerField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerField
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LookerFieldBuilder<C extends LookerField, B extends LookerField.LookerFieldBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerDashboard dashboard;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerExplore explore;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerLook look;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lookerDashboardQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lookerExploreQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lookerFieldDataType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lookerLookQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lookerTileQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer lookerTimesUsed;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lookerViewQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerModel model;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerProject project;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String projectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceDefinition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerTile tile;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerView view;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LookerField.LookerFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LookerField instance, final LookerField.LookerFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboard(instance.dashboard);
            b.explore(instance.explore);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.look(instance.look);
            b.lookerDashboardQualifiedName(instance.lookerDashboardQualifiedName);
            b.lookerExploreQualifiedName(instance.lookerExploreQualifiedName);
            b.lookerFieldDataType(instance.lookerFieldDataType);
            b.lookerLookQualifiedName(instance.lookerLookQualifiedName);
            b.lookerTileQualifiedName(instance.lookerTileQualifiedName);
            b.lookerTimesUsed(instance.lookerTimesUsed);
            b.lookerViewQualifiedName(instance.lookerViewQualifiedName);
            b.model(instance.model);
            b.modelName(instance.modelName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.project(instance.project);
            b.projectName(instance.projectName);
            b.sourceDefinition(instance.sourceDefinition);
            b.tile(instance.tile);
            b.view(instance.view);
        }

        /**
         * Fixed typeName for LookerFields.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Dashboard in which this field is used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dashboard(final ILookerDashboard dashboard) {
            this.dashboard = dashboard;
            return self();
        }

        /**
         * Explore in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B explore(final ILookerExplore explore) {
            this.explore = explore;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Look in which this field is used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B look(final ILookerLook look) {
            this.look = look;
            return self();
        }

        /**
         * Unique name of the dashboard in which this field is used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerDashboardQualifiedName(final String lookerDashboardQualifiedName) {
            this.lookerDashboardQualifiedName = lookerDashboardQualifiedName;
            return self();
        }

        /**
         * Unique name of the Explore in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerExploreQualifiedName(final String lookerExploreQualifiedName) {
            this.lookerExploreQualifiedName = lookerExploreQualifiedName;
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerFieldDataType(final String lookerFieldDataType) {
            this.lookerFieldDataType = lookerFieldDataType;
            return self();
        }

        /**
         * Unique name of the look in which this field is used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerLookQualifiedName(final String lookerLookQualifiedName) {
            this.lookerLookQualifiedName = lookerLookQualifiedName;
            return self();
        }

        /**
         * Unique name of the tile in which this field is used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerTileQualifiedName(final String lookerTileQualifiedName) {
            this.lookerTileQualifiedName = lookerTileQualifiedName;
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerTimesUsed(final Integer lookerTimesUsed) {
            this.lookerTimesUsed = lookerTimesUsed;
            return self();
        }

        /**
         * Unique name of the view in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerViewQualifiedName(final String lookerViewQualifiedName) {
            this.lookerViewQualifiedName = lookerViewQualifiedName;
            return self();
        }

        /**
         * Model in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B model(final ILookerModel model) {
            this.model = model;
            return self();
        }

        /**
         * Name of the model in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelName(final String modelName) {
            this.modelName = modelName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Project in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B project(final ILookerProject project) {
            this.project = project;
            return self();
        }

        /**
         * Name of the project in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B projectName(final String projectName) {
            this.projectName = projectName;
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceDefinition(final String sourceDefinition) {
            this.sourceDefinition = sourceDefinition;
            return self();
        }

        /**
         * Tile in which this field is used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tile(final ILookerTile tile) {
            this.tile = tile;
            return self();
        }

        /**
         * View in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B view(final ILookerView view) {
            this.view = view;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LookerField.LookerFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboard=" + this.dashboard + ", explore=" + this.explore + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", look=" + this.look + ", lookerDashboardQualifiedName=" + this.lookerDashboardQualifiedName + ", lookerExploreQualifiedName=" + this.lookerExploreQualifiedName + ", lookerFieldDataType=" + this.lookerFieldDataType + ", lookerLookQualifiedName=" + this.lookerLookQualifiedName + ", lookerTileQualifiedName=" + this.lookerTileQualifiedName + ", lookerTimesUsed=" + this.lookerTimesUsed + ", lookerViewQualifiedName=" + this.lookerViewQualifiedName + ", model=" + this.model + ", modelName=" + this.modelName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", project=" + this.project + ", projectName=" + this.projectName + ", sourceDefinition=" + this.sourceDefinition + ", tile=" + this.tile + ", view=" + this.view + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class LookerFieldBuilderImpl extends LookerField.LookerFieldBuilder<LookerField, LookerField.LookerFieldBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LookerFieldBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LookerField.LookerFieldBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LookerField build() {
            return new LookerField(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LookerField(final LookerField.LookerFieldBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = LookerField.$default$typeName();
        this.dashboard = b.dashboard;
        this.explore = b.explore;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.look = b.look;
        this.lookerDashboardQualifiedName = b.lookerDashboardQualifiedName;
        this.lookerExploreQualifiedName = b.lookerExploreQualifiedName;
        this.lookerFieldDataType = b.lookerFieldDataType;
        this.lookerLookQualifiedName = b.lookerLookQualifiedName;
        this.lookerTileQualifiedName = b.lookerTileQualifiedName;
        this.lookerTimesUsed = b.lookerTimesUsed;
        this.lookerViewQualifiedName = b.lookerViewQualifiedName;
        this.model = b.model;
        this.modelName = b.modelName;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.project = b.project;
        this.projectName = b.projectName;
        this.sourceDefinition = b.sourceDefinition;
        this.tile = b.tile;
        this.view = b.view;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LookerField.LookerFieldBuilder<?, ?> _internal() {
        return new LookerField.LookerFieldBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LookerField.LookerFieldBuilder<?, ?> toBuilder() {
        return new LookerField.LookerFieldBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Dashboard in which this field is used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerDashboard getDashboard() {
        return this.dashboard;
    }

    /**
     * Explore in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerExplore getExplore() {
        return this.explore;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Look in which this field is used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerLook getLook() {
        return this.look;
    }

    /**
     * Unique name of the dashboard in which this field is used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLookerDashboardQualifiedName() {
        return this.lookerDashboardQualifiedName;
    }

    /**
     * Unique name of the Explore in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLookerExploreQualifiedName() {
        return this.lookerExploreQualifiedName;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLookerFieldDataType() {
        return this.lookerFieldDataType;
    }

    /**
     * Unique name of the look in which this field is used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLookerLookQualifiedName() {
        return this.lookerLookQualifiedName;
    }

    /**
     * Unique name of the tile in which this field is used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLookerTileQualifiedName() {
        return this.lookerTileQualifiedName;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getLookerTimesUsed() {
        return this.lookerTimesUsed;
    }

    /**
     * Unique name of the view in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLookerViewQualifiedName() {
        return this.lookerViewQualifiedName;
    }

    /**
     * Model in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerModel getModel() {
        return this.model;
    }

    /**
     * Name of the model in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelName() {
        return this.modelName;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Project in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerProject getProject() {
        return this.project;
    }

    /**
     * Name of the project in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceDefinition() {
        return this.sourceDefinition;
    }

    /**
     * Tile in which this field is used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerTile getTile() {
        return this.tile;
    }

    /**
     * View in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerView getView() {
        return this.view;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LookerField)) return false;
        final LookerField other = (LookerField) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$lookerTimesUsed = this.getLookerTimesUsed();
        final java.lang.Object other$lookerTimesUsed = other.getLookerTimesUsed();
        if (this$lookerTimesUsed == null ? other$lookerTimesUsed != null : !this$lookerTimesUsed.equals(other$lookerTimesUsed)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dashboard = this.getDashboard();
        final java.lang.Object other$dashboard = other.getDashboard();
        if (this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard)) return false;
        final java.lang.Object this$explore = this.getExplore();
        final java.lang.Object other$explore = other.getExplore();
        if (this$explore == null ? other$explore != null : !this$explore.equals(other$explore)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$look = this.getLook();
        final java.lang.Object other$look = other.getLook();
        if (this$look == null ? other$look != null : !this$look.equals(other$look)) return false;
        final java.lang.Object this$lookerDashboardQualifiedName = this.getLookerDashboardQualifiedName();
        final java.lang.Object other$lookerDashboardQualifiedName = other.getLookerDashboardQualifiedName();
        if (this$lookerDashboardQualifiedName == null ? other$lookerDashboardQualifiedName != null : !this$lookerDashboardQualifiedName.equals(other$lookerDashboardQualifiedName)) return false;
        final java.lang.Object this$lookerExploreQualifiedName = this.getLookerExploreQualifiedName();
        final java.lang.Object other$lookerExploreQualifiedName = other.getLookerExploreQualifiedName();
        if (this$lookerExploreQualifiedName == null ? other$lookerExploreQualifiedName != null : !this$lookerExploreQualifiedName.equals(other$lookerExploreQualifiedName)) return false;
        final java.lang.Object this$lookerFieldDataType = this.getLookerFieldDataType();
        final java.lang.Object other$lookerFieldDataType = other.getLookerFieldDataType();
        if (this$lookerFieldDataType == null ? other$lookerFieldDataType != null : !this$lookerFieldDataType.equals(other$lookerFieldDataType)) return false;
        final java.lang.Object this$lookerLookQualifiedName = this.getLookerLookQualifiedName();
        final java.lang.Object other$lookerLookQualifiedName = other.getLookerLookQualifiedName();
        if (this$lookerLookQualifiedName == null ? other$lookerLookQualifiedName != null : !this$lookerLookQualifiedName.equals(other$lookerLookQualifiedName)) return false;
        final java.lang.Object this$lookerTileQualifiedName = this.getLookerTileQualifiedName();
        final java.lang.Object other$lookerTileQualifiedName = other.getLookerTileQualifiedName();
        if (this$lookerTileQualifiedName == null ? other$lookerTileQualifiedName != null : !this$lookerTileQualifiedName.equals(other$lookerTileQualifiedName)) return false;
        final java.lang.Object this$lookerViewQualifiedName = this.getLookerViewQualifiedName();
        final java.lang.Object other$lookerViewQualifiedName = other.getLookerViewQualifiedName();
        if (this$lookerViewQualifiedName == null ? other$lookerViewQualifiedName != null : !this$lookerViewQualifiedName.equals(other$lookerViewQualifiedName)) return false;
        final java.lang.Object this$model = this.getModel();
        final java.lang.Object other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) return false;
        final java.lang.Object this$modelName = this.getModelName();
        final java.lang.Object other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$project = this.getProject();
        final java.lang.Object other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) return false;
        final java.lang.Object this$projectName = this.getProjectName();
        final java.lang.Object other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) return false;
        final java.lang.Object this$sourceDefinition = this.getSourceDefinition();
        final java.lang.Object other$sourceDefinition = other.getSourceDefinition();
        if (this$sourceDefinition == null ? other$sourceDefinition != null : !this$sourceDefinition.equals(other$sourceDefinition)) return false;
        final java.lang.Object this$tile = this.getTile();
        final java.lang.Object other$tile = other.getTile();
        if (this$tile == null ? other$tile != null : !this$tile.equals(other$tile)) return false;
        final java.lang.Object this$view = this.getView();
        final java.lang.Object other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LookerField;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $lookerTimesUsed = this.getLookerTimesUsed();
        result = result * PRIME + ($lookerTimesUsed == null ? 43 : $lookerTimesUsed.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dashboard = this.getDashboard();
        result = result * PRIME + ($dashboard == null ? 43 : $dashboard.hashCode());
        final java.lang.Object $explore = this.getExplore();
        result = result * PRIME + ($explore == null ? 43 : $explore.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $look = this.getLook();
        result = result * PRIME + ($look == null ? 43 : $look.hashCode());
        final java.lang.Object $lookerDashboardQualifiedName = this.getLookerDashboardQualifiedName();
        result = result * PRIME + ($lookerDashboardQualifiedName == null ? 43 : $lookerDashboardQualifiedName.hashCode());
        final java.lang.Object $lookerExploreQualifiedName = this.getLookerExploreQualifiedName();
        result = result * PRIME + ($lookerExploreQualifiedName == null ? 43 : $lookerExploreQualifiedName.hashCode());
        final java.lang.Object $lookerFieldDataType = this.getLookerFieldDataType();
        result = result * PRIME + ($lookerFieldDataType == null ? 43 : $lookerFieldDataType.hashCode());
        final java.lang.Object $lookerLookQualifiedName = this.getLookerLookQualifiedName();
        result = result * PRIME + ($lookerLookQualifiedName == null ? 43 : $lookerLookQualifiedName.hashCode());
        final java.lang.Object $lookerTileQualifiedName = this.getLookerTileQualifiedName();
        result = result * PRIME + ($lookerTileQualifiedName == null ? 43 : $lookerTileQualifiedName.hashCode());
        final java.lang.Object $lookerViewQualifiedName = this.getLookerViewQualifiedName();
        result = result * PRIME + ($lookerViewQualifiedName == null ? 43 : $lookerViewQualifiedName.hashCode());
        final java.lang.Object $model = this.getModel();
        result = result * PRIME + ($model == null ? 43 : $model.hashCode());
        final java.lang.Object $modelName = this.getModelName();
        result = result * PRIME + ($modelName == null ? 43 : $modelName.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $project = this.getProject();
        result = result * PRIME + ($project == null ? 43 : $project.hashCode());
        final java.lang.Object $projectName = this.getProjectName();
        result = result * PRIME + ($projectName == null ? 43 : $projectName.hashCode());
        final java.lang.Object $sourceDefinition = this.getSourceDefinition();
        result = result * PRIME + ($sourceDefinition == null ? 43 : $sourceDefinition.hashCode());
        final java.lang.Object $tile = this.getTile();
        result = result * PRIME + ($tile == null ? 43 : $tile.hashCode());
        final java.lang.Object $view = this.getView();
        result = result * PRIME + ($view == null ? 43 : $view.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LookerField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboard=" + this.getDashboard() + ", explore=" + this.getExplore() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", look=" + this.getLook() + ", lookerDashboardQualifiedName=" + this.getLookerDashboardQualifiedName() + ", lookerExploreQualifiedName=" + this.getLookerExploreQualifiedName() + ", lookerFieldDataType=" + this.getLookerFieldDataType() + ", lookerLookQualifiedName=" + this.getLookerLookQualifiedName() + ", lookerTileQualifiedName=" + this.getLookerTileQualifiedName() + ", lookerTimesUsed=" + this.getLookerTimesUsed() + ", lookerViewQualifiedName=" + this.getLookerViewQualifiedName() + ", model=" + this.getModel() + ", modelName=" + this.getModelName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", project=" + this.getProject() + ", projectName=" + this.getProjectName() + ", sourceDefinition=" + this.getSourceDefinition() + ", tile=" + this.getTile() + ", view=" + this.getView() + ")";
    }

    /**
     * Fixed typeName for LookerFields.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
