// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Looker folder in Atlan. Folders in Looker are used to organize content in a hierarchical structure and granting access.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class LookerFolder extends Asset implements ILookerFolder, ILooker, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LookerFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerFolder";
    /**
     * Fixed typeName for LookerFolders.
     */
    String typeName;
    /**
     * Dashboards that exist within this folder.
     */
    @Attribute
    SortedSet<ILookerDashboard> dashboards;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Folder in which this subfolder exists.
     */
    @Attribute
    ILookerFolder lookerParentFolder;
    /**
     * Subfolders that exist within this folder.
     */
    @Attribute
    SortedSet<ILookerFolder> lookerSubFolders;
    /**
     * Looks that exist within this folder.
     */
    @Attribute
    SortedSet<ILookerLook> looks;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Number of subfolders in this folder.
     */
    @Attribute
    Integer sourceChildCount;
    /**
     * Identifier for the folder's content metadata in Looker.
     */
    @Attribute
    Integer sourceContentMetadataId;
    /**
     * Identifier of the user who created the folder, from Looker.
     */
    @Attribute
    Integer sourceCreatorId;
    /**
     * Identifier of the parent folder of this folder, from Looker.
     */
    @Attribute
    Integer sourceParentID;

    /**
     * Builds the minimal object necessary to create a relationship to a LookerFolder, from a potentially
     * more-complete LookerFolder object.
     *
     * @return the minimal object necessary to relate to the LookerFolder
     * @throws InvalidRequestException if any of the minimal set of required properties for a LookerFolder relationship are not found in the initial object
     */
    @Override
    public LookerFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all LookerFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerFolder assets will be included.
     *
     * @return a fluent search that includes all LookerFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all LookerFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerFolder assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all LookerFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all LookerFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) LookerFolders will be included
     * @return a fluent search that includes all LookerFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all LookerFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) LookerFolders will be included
     * @return a fluent search that includes all LookerFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a LookerFolder by GUID. Use this to create a relationship to this LookerFolder,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the LookerFolder to reference
     * @return reference to a LookerFolder that can be used for defining a relationship to a LookerFolder
     */
    public static LookerFolder refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerFolder by GUID. Use this to create a relationship to this LookerFolder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the LookerFolder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerFolder that can be used for defining a relationship to a LookerFolder
     */
    public static LookerFolder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return LookerFolder._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a LookerFolder by qualifiedName. Use this to create a relationship to this LookerFolder,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the LookerFolder to reference
     * @return reference to a LookerFolder that can be used for defining a relationship to a LookerFolder
     */
    public static LookerFolder refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerFolder by qualifiedName. Use this to create a relationship to this LookerFolder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the LookerFolder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerFolder that can be used for defining a relationship to a LookerFolder
     */
    public static LookerFolder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return LookerFolder._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a LookerFolder by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the LookerFolder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerFolder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerFolder does not exist or the provided GUID is not a LookerFolder
     */
    @JsonIgnore
    public static LookerFolder get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a LookerFolder by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerFolder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerFolder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerFolder does not exist or the provided GUID is not a LookerFolder
     */
    @JsonIgnore
    public static LookerFolder get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a LookerFolder by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerFolder to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full LookerFolder, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerFolder does not exist or the provided GUID is not a LookerFolder
     */
    @JsonIgnore
    public static LookerFolder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof LookerFolder) {
                return (LookerFolder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof LookerFolder) {
                return (LookerFolder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) LookerFolder to active.
     *
     * @param qualifiedName for the LookerFolder
     * @return true if the LookerFolder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) LookerFolder to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the LookerFolder
     * @return true if the LookerFolder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the minimal request necessary to update the LookerFolder, as a builder
     */
    public static LookerFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return LookerFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a LookerFolder, from a potentially
     * more-complete LookerFolder object.
     *
     * @return the minimal object necessary to update the LookerFolder, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for LookerFolder are not found in the initial object
     */
    @Override
    public LookerFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a LookerFolder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a LookerFolder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a LookerFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerFolder's owners
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerFolder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a LookerFolder.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerFolder's certificate
     * @param qualifiedName of the LookerFolder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerFolder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerFolder) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a LookerFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerFolder's certificate
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a LookerFolder.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerFolder's announcement
     * @param qualifiedName of the LookerFolder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerFolder) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a LookerFolder.
     *
     * @param client connectivity to the Atlan client from which to remove the LookerFolder's announcement
     * @param qualifiedName of the LookerFolder
     * @param name of the LookerFolder
     * @return the updated LookerFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerFolder) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the LookerFolder.
     *
     * @param qualifiedName for the LookerFolder
     * @param name human-readable name of the LookerFolder
     * @param terms the list of terms to replace on the LookerFolder, or null to remove all terms from the LookerFolder
     * @return the LookerFolder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerFolder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the LookerFolder.
     *
     * @param client connectivity to the Atlan tenant on which to replace the LookerFolder's assigned terms
     * @param qualifiedName for the LookerFolder
     * @param name human-readable name of the LookerFolder
     * @param terms the list of terms to replace on the LookerFolder, or null to remove all terms from the LookerFolder
     * @return the LookerFolder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the LookerFolder, without replacing existing terms linked to the LookerFolder.
     * Note: this operation must make two API calls — one to retrieve the LookerFolder's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the LookerFolder
     * @param terms the list of terms to append to the LookerFolder
     * @return the LookerFolder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerFolder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the LookerFolder, without replacing existing terms linked to the LookerFolder.
     * Note: this operation must make two API calls — one to retrieve the LookerFolder's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the LookerFolder
     * @param qualifiedName for the LookerFolder
     * @param terms the list of terms to append to the LookerFolder
     * @return the LookerFolder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerFolder, without replacing all existing terms linked to the LookerFolder.
     * Note: this operation must make two API calls — one to retrieve the LookerFolder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the LookerFolder
     * @param terms the list of terms to remove from the LookerFolder, which must be referenced by GUID
     * @return the LookerFolder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerFolder, without replacing all existing terms linked to the LookerFolder.
     * Note: this operation must make two API calls — one to retrieve the LookerFolder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the LookerFolder
     * @param qualifiedName for the LookerFolder
     * @param terms the list of terms to remove from the LookerFolder, which must be referenced by GUID
     * @return the LookerFolder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerFolder) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a LookerFolder, without replacing existing Atlan tags linked to the LookerFolder.
     * Note: this operation must make two API calls — one to retrieve the LookerFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerFolder
     */
    public static LookerFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerFolder, without replacing existing Atlan tags linked to the LookerFolder.
     * Note: this operation must make two API calls — one to retrieve the LookerFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerFolder
     * @param qualifiedName of the LookerFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerFolder
     */
    public static LookerFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerFolder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerFolder, without replacing existing Atlan tags linked to the LookerFolder.
     * Note: this operation must make two API calls — one to retrieve the LookerFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerFolder
     */
    public static LookerFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a LookerFolder, without replacing existing Atlan tags linked to the LookerFolder.
     * Note: this operation must make two API calls — one to retrieve the LookerFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerFolder
     * @param qualifiedName of the LookerFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerFolder
     */
    public static LookerFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerFolder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a LookerFolder.
     *
     * @param qualifiedName of the LookerFolder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerFolder
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a LookerFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a LookerFolder
     * @param qualifiedName of the LookerFolder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerFolder
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LookerFolderBuilder<C extends LookerFolder, B extends LookerFolder.LookerFolderBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerDashboard> dashboards;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerFolder lookerParentFolder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerFolder> lookerSubFolders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerLook> looks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourceChildCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourceContentMetadataId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourceCreatorId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourceParentID;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LookerFolder.LookerFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LookerFolder instance, final LookerFolder.LookerFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboards(instance.dashboards == null ? java.util.Collections.<ILookerDashboard>emptySortedSet() : instance.dashboards);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.lookerParentFolder(instance.lookerParentFolder);
            b.lookerSubFolders(instance.lookerSubFolders == null ? java.util.Collections.<ILookerFolder>emptySortedSet() : instance.lookerSubFolders);
            b.looks(instance.looks == null ? java.util.Collections.<ILookerLook>emptySortedSet() : instance.looks);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.sourceChildCount(instance.sourceChildCount);
            b.sourceContentMetadataId(instance.sourceContentMetadataId);
            b.sourceCreatorId(instance.sourceCreatorId);
            b.sourceParentID(instance.sourceParentID);
        }

        /**
         * Fixed typeName for LookerFolders.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dashboard(final ILookerDashboard dashboard) {
            if (this.dashboards == null) this.dashboards = new java.util.ArrayList<ILookerDashboard>();
            this.dashboards.add(dashboard);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dashboards(final java.util.Collection<? extends ILookerDashboard> dashboards) {
            if (dashboards == null) {
                throw new java.lang.NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) this.dashboards = new java.util.ArrayList<ILookerDashboard>();
            this.dashboards.addAll(dashboards);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDashboards() {
            if (this.dashboards != null) this.dashboards.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Folder in which this subfolder exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerParentFolder(final ILookerFolder lookerParentFolder) {
            this.lookerParentFolder = lookerParentFolder;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerSubFolder(final ILookerFolder lookerSubFolder) {
            if (this.lookerSubFolders == null) this.lookerSubFolders = new java.util.ArrayList<ILookerFolder>();
            this.lookerSubFolders.add(lookerSubFolder);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerSubFolders(final java.util.Collection<? extends ILookerFolder> lookerSubFolders) {
            if (lookerSubFolders == null) {
                throw new java.lang.NullPointerException("lookerSubFolders cannot be null");
            }
            if (this.lookerSubFolders == null) this.lookerSubFolders = new java.util.ArrayList<ILookerFolder>();
            this.lookerSubFolders.addAll(lookerSubFolders);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLookerSubFolders() {
            if (this.lookerSubFolders != null) this.lookerSubFolders.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B look(final ILookerLook look) {
            if (this.looks == null) this.looks = new java.util.ArrayList<ILookerLook>();
            this.looks.add(look);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B looks(final java.util.Collection<? extends ILookerLook> looks) {
            if (looks == null) {
                throw new java.lang.NullPointerException("looks cannot be null");
            }
            if (this.looks == null) this.looks = new java.util.ArrayList<ILookerLook>();
            this.looks.addAll(looks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLooks() {
            if (this.looks != null) this.looks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Number of subfolders in this folder.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceChildCount(final Integer sourceChildCount) {
            this.sourceChildCount = sourceChildCount;
            return self();
        }

        /**
         * Identifier for the folder's content metadata in Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceContentMetadataId(final Integer sourceContentMetadataId) {
            this.sourceContentMetadataId = sourceContentMetadataId;
            return self();
        }

        /**
         * Identifier of the user who created the folder, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceCreatorId(final Integer sourceCreatorId) {
            this.sourceCreatorId = sourceCreatorId;
            return self();
        }

        /**
         * Identifier of the parent folder of this folder, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceParentID(final Integer sourceParentID) {
            this.sourceParentID = sourceParentID;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LookerFolder.LookerFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboards=" + this.dashboards + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", lookerParentFolder=" + this.lookerParentFolder + ", lookerSubFolders=" + this.lookerSubFolders + ", looks=" + this.looks + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sourceChildCount=" + this.sourceChildCount + ", sourceContentMetadataId=" + this.sourceContentMetadataId + ", sourceCreatorId=" + this.sourceCreatorId + ", sourceParentID=" + this.sourceParentID + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class LookerFolderBuilderImpl extends LookerFolder.LookerFolderBuilder<LookerFolder, LookerFolder.LookerFolderBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LookerFolderBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LookerFolder.LookerFolderBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LookerFolder build() {
            return new LookerFolder(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LookerFolder(final LookerFolder.LookerFolderBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = LookerFolder.$default$typeName();
        java.util.SortedSet<ILookerDashboard> dashboards = new java.util.TreeSet<ILookerDashboard>();
        if (b.dashboards != null) dashboards.addAll(b.dashboards);
        dashboards = java.util.Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.lookerParentFolder = b.lookerParentFolder;
        java.util.SortedSet<ILookerFolder> lookerSubFolders = new java.util.TreeSet<ILookerFolder>();
        if (b.lookerSubFolders != null) lookerSubFolders.addAll(b.lookerSubFolders);
        lookerSubFolders = java.util.Collections.unmodifiableSortedSet(lookerSubFolders);
        this.lookerSubFolders = lookerSubFolders;
        java.util.SortedSet<ILookerLook> looks = new java.util.TreeSet<ILookerLook>();
        if (b.looks != null) looks.addAll(b.looks);
        looks = java.util.Collections.unmodifiableSortedSet(looks);
        this.looks = looks;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sourceChildCount = b.sourceChildCount;
        this.sourceContentMetadataId = b.sourceContentMetadataId;
        this.sourceCreatorId = b.sourceCreatorId;
        this.sourceParentID = b.sourceParentID;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LookerFolder.LookerFolderBuilder<?, ?> _internal() {
        return new LookerFolder.LookerFolderBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LookerFolder.LookerFolderBuilder<?, ?> toBuilder() {
        return new LookerFolder.LookerFolderBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Dashboards that exist within this folder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerDashboard> getDashboards() {
        return this.dashboards;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Folder in which this subfolder exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerFolder getLookerParentFolder() {
        return this.lookerParentFolder;
    }

    /**
     * Subfolders that exist within this folder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerFolder> getLookerSubFolders() {
        return this.lookerSubFolders;
    }

    /**
     * Looks that exist within this folder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerLook> getLooks() {
        return this.looks;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Number of subfolders in this folder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourceChildCount() {
        return this.sourceChildCount;
    }

    /**
     * Identifier for the folder's content metadata in Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourceContentMetadataId() {
        return this.sourceContentMetadataId;
    }

    /**
     * Identifier of the user who created the folder, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourceCreatorId() {
        return this.sourceCreatorId;
    }

    /**
     * Identifier of the parent folder of this folder, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourceParentID() {
        return this.sourceParentID;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LookerFolder)) return false;
        final LookerFolder other = (LookerFolder) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$sourceChildCount = this.getSourceChildCount();
        final java.lang.Object other$sourceChildCount = other.getSourceChildCount();
        if (this$sourceChildCount == null ? other$sourceChildCount != null : !this$sourceChildCount.equals(other$sourceChildCount)) return false;
        final java.lang.Object this$sourceContentMetadataId = this.getSourceContentMetadataId();
        final java.lang.Object other$sourceContentMetadataId = other.getSourceContentMetadataId();
        if (this$sourceContentMetadataId == null ? other$sourceContentMetadataId != null : !this$sourceContentMetadataId.equals(other$sourceContentMetadataId)) return false;
        final java.lang.Object this$sourceCreatorId = this.getSourceCreatorId();
        final java.lang.Object other$sourceCreatorId = other.getSourceCreatorId();
        if (this$sourceCreatorId == null ? other$sourceCreatorId != null : !this$sourceCreatorId.equals(other$sourceCreatorId)) return false;
        final java.lang.Object this$sourceParentID = this.getSourceParentID();
        final java.lang.Object other$sourceParentID = other.getSourceParentID();
        if (this$sourceParentID == null ? other$sourceParentID != null : !this$sourceParentID.equals(other$sourceParentID)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dashboards = this.getDashboards();
        final java.lang.Object other$dashboards = other.getDashboards();
        if (this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$lookerParentFolder = this.getLookerParentFolder();
        final java.lang.Object other$lookerParentFolder = other.getLookerParentFolder();
        if (this$lookerParentFolder == null ? other$lookerParentFolder != null : !this$lookerParentFolder.equals(other$lookerParentFolder)) return false;
        final java.lang.Object this$lookerSubFolders = this.getLookerSubFolders();
        final java.lang.Object other$lookerSubFolders = other.getLookerSubFolders();
        if (this$lookerSubFolders == null ? other$lookerSubFolders != null : !this$lookerSubFolders.equals(other$lookerSubFolders)) return false;
        final java.lang.Object this$looks = this.getLooks();
        final java.lang.Object other$looks = other.getLooks();
        if (this$looks == null ? other$looks != null : !this$looks.equals(other$looks)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LookerFolder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $sourceChildCount = this.getSourceChildCount();
        result = result * PRIME + ($sourceChildCount == null ? 43 : $sourceChildCount.hashCode());
        final java.lang.Object $sourceContentMetadataId = this.getSourceContentMetadataId();
        result = result * PRIME + ($sourceContentMetadataId == null ? 43 : $sourceContentMetadataId.hashCode());
        final java.lang.Object $sourceCreatorId = this.getSourceCreatorId();
        result = result * PRIME + ($sourceCreatorId == null ? 43 : $sourceCreatorId.hashCode());
        final java.lang.Object $sourceParentID = this.getSourceParentID();
        result = result * PRIME + ($sourceParentID == null ? 43 : $sourceParentID.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dashboards = this.getDashboards();
        result = result * PRIME + ($dashboards == null ? 43 : $dashboards.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $lookerParentFolder = this.getLookerParentFolder();
        result = result * PRIME + ($lookerParentFolder == null ? 43 : $lookerParentFolder.hashCode());
        final java.lang.Object $lookerSubFolders = this.getLookerSubFolders();
        result = result * PRIME + ($lookerSubFolders == null ? 43 : $lookerSubFolders.hashCode());
        final java.lang.Object $looks = this.getLooks();
        result = result * PRIME + ($looks == null ? 43 : $looks.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LookerFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboards=" + this.getDashboards() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", lookerParentFolder=" + this.getLookerParentFolder() + ", lookerSubFolders=" + this.getLookerSubFolders() + ", looks=" + this.getLooks() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sourceChildCount=" + this.getSourceChildCount() + ", sourceContentMetadataId=" + this.getSourceContentMetadataId() + ", sourceCreatorId=" + this.getSourceCreatorId() + ", sourceParentID=" + this.getSourceParentID() + ")";
    }

    /**
     * Fixed typeName for LookerFolders.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
