// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Looker Look in Atlan. Looks are saved visualizations used to understand and analyze data. They can be shared and reused in multiple dashboards.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class LookerLook extends Asset implements ILookerLook, ILooker, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LookerLook.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerLook";
    /**
     * Fixed typeName for LookerLooks.
     */
    String typeName;
    /**
     * Dashboard in which this Look is used.
     */
    @Attribute
    ILookerDashboard dashboard;
    /**
     * Fields that are used in this look.
     */
    @Attribute
    SortedSet<ILookerField> fields;
    /**
     * Folder in which this Look exists.
     */
    @Attribute
    ILookerFolder folder;
    /**
     * Name of the folder in which the Look is organized.
     */
    @Attribute
    String folderName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Model in which this Look exists.
     */
    @Attribute
    ILookerModel model;
    /**
     * Name of the model in which this Look exists.
     */
    @Attribute
    String modelName;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Deprecated.
     */
    @Attribute
    ILookerQuery query;
    /**
     * Identifier of the Look's content metadata, from Looker.
     */
    @Attribute
    Integer sourceContentMetadataId;
    /**
     * Time (epoch) when the Look was last accessed by a user, in milliseconds.
     */
    @Attribute
    @Date
    Long sourceLastAccessedAt;
    /**
     * Time (epoch) when the Look was last viewed by a user, in milliseconds.
     */
    @Attribute
    @Date
    Long sourceLastViewedAt;
    /**
     * Identifier of the query for the Look, from Looker.
     */
    @Attribute
    Integer sourceQueryId;
    /**
     * Identifier of the user who created the Look, from Looker.
     */
    @Attribute
    Integer sourceUserId;
    /**
     * Number of times the look has been viewed in the Looker web UI.
     */
    @Attribute
    Integer sourceViewCount;
    /**
     * Identifier of the user that last updated the Look, from Looker.
     */
    @Attribute
    Integer sourcelastUpdaterId;
    /**
     * Tiles that exist within this Look.
     */
    @Attribute
    ILookerTile tile;

    /**
     * Builds the minimal object necessary to create a relationship to a LookerLook, from a potentially
     * more-complete LookerLook object.
     *
     * @return the minimal object necessary to relate to the LookerLook
     * @throws InvalidRequestException if any of the minimal set of required properties for a LookerLook relationship are not found in the initial object
     */
    @Override
    public LookerLook trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all LookerLook assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerLook assets will be included.
     *
     * @return a fluent search that includes all LookerLook assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all LookerLook assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerLook assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all LookerLook assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all LookerLook assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) LookerLooks will be included
     * @return a fluent search that includes all LookerLook assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all LookerLook assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) LookerLooks will be included
     * @return a fluent search that includes all LookerLook assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a LookerLook by GUID. Use this to create a relationship to this LookerLook,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the LookerLook to reference
     * @return reference to a LookerLook that can be used for defining a relationship to a LookerLook
     */
    public static LookerLook refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerLook by GUID. Use this to create a relationship to this LookerLook,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the LookerLook to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerLook that can be used for defining a relationship to a LookerLook
     */
    public static LookerLook refByGuid(String guid, Reference.SaveSemantic semantic) {
        return LookerLook._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a LookerLook by qualifiedName. Use this to create a relationship to this LookerLook,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the LookerLook to reference
     * @return reference to a LookerLook that can be used for defining a relationship to a LookerLook
     */
    public static LookerLook refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerLook by qualifiedName. Use this to create a relationship to this LookerLook,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the LookerLook to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerLook that can be used for defining a relationship to a LookerLook
     */
    public static LookerLook refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return LookerLook._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a LookerLook by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the LookerLook to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerLook, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerLook does not exist or the provided GUID is not a LookerLook
     */
    @JsonIgnore
    public static LookerLook get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a LookerLook by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerLook to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerLook, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerLook does not exist or the provided GUID is not a LookerLook
     */
    @JsonIgnore
    public static LookerLook get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a LookerLook by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerLook to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full LookerLook, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerLook does not exist or the provided GUID is not a LookerLook
     */
    @JsonIgnore
    public static LookerLook get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof LookerLook) {
                return (LookerLook) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof LookerLook) {
                return (LookerLook) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) LookerLook to active.
     *
     * @param qualifiedName for the LookerLook
     * @return true if the LookerLook is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) LookerLook to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the LookerLook
     * @return true if the LookerLook is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the minimal request necessary to update the LookerLook, as a builder
     */
    public static LookerLookBuilder<?, ?> updater(String qualifiedName, String name) {
        return LookerLook._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a LookerLook, from a potentially
     * more-complete LookerLook object.
     *
     * @return the minimal object necessary to update the LookerLook, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for LookerLook are not found in the initial object
     */
    @Override
    public LookerLookBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a LookerLook.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a LookerLook.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a LookerLook.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerLook's owners
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerLook, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a LookerLook.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerLook's certificate
     * @param qualifiedName of the LookerLook
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerLook, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerLook) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a LookerLook.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerLook's certificate
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a LookerLook.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerLook's announcement
     * @param qualifiedName of the LookerLook
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerLook) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a LookerLook.
     *
     * @param client connectivity to the Atlan client from which to remove the LookerLook's announcement
     * @param qualifiedName of the LookerLook
     * @param name of the LookerLook
     * @return the updated LookerLook, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the LookerLook.
     *
     * @param qualifiedName for the LookerLook
     * @param name human-readable name of the LookerLook
     * @param terms the list of terms to replace on the LookerLook, or null to remove all terms from the LookerLook
     * @return the LookerLook that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerLook replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the LookerLook.
     *
     * @param client connectivity to the Atlan tenant on which to replace the LookerLook's assigned terms
     * @param qualifiedName for the LookerLook
     * @param name human-readable name of the LookerLook
     * @param terms the list of terms to replace on the LookerLook, or null to remove all terms from the LookerLook
     * @return the LookerLook that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerLook replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerLook) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the LookerLook, without replacing existing terms linked to the LookerLook.
     * Note: this operation must make two API calls — one to retrieve the LookerLook's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the LookerLook
     * @param terms the list of terms to append to the LookerLook
     * @return the LookerLook that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerLook appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the LookerLook, without replacing existing terms linked to the LookerLook.
     * Note: this operation must make two API calls — one to retrieve the LookerLook's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the LookerLook
     * @param qualifiedName for the LookerLook
     * @param terms the list of terms to append to the LookerLook
     * @return the LookerLook that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerLook appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerLook) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerLook, without replacing all existing terms linked to the LookerLook.
     * Note: this operation must make two API calls — one to retrieve the LookerLook's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the LookerLook
     * @param terms the list of terms to remove from the LookerLook, which must be referenced by GUID
     * @return the LookerLook that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerLook, without replacing all existing terms linked to the LookerLook.
     * Note: this operation must make two API calls — one to retrieve the LookerLook's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the LookerLook
     * @param qualifiedName for the LookerLook
     * @param terms the list of terms to remove from the LookerLook, which must be referenced by GUID
     * @return the LookerLook that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerLook removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerLook) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a LookerLook, without replacing existing Atlan tags linked to the LookerLook.
     * Note: this operation must make two API calls — one to retrieve the LookerLook's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerLook
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerLook
     */
    public static LookerLook appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerLook, without replacing existing Atlan tags linked to the LookerLook.
     * Note: this operation must make two API calls — one to retrieve the LookerLook's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerLook
     * @param qualifiedName of the LookerLook
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerLook
     */
    public static LookerLook appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerLook) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerLook, without replacing existing Atlan tags linked to the LookerLook.
     * Note: this operation must make two API calls — one to retrieve the LookerLook's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerLook
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerLook
     */
    public static LookerLook appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a LookerLook, without replacing existing Atlan tags linked to the LookerLook.
     * Note: this operation must make two API calls — one to retrieve the LookerLook's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerLook
     * @param qualifiedName of the LookerLook
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerLook
     */
    public static LookerLook appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerLook) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a LookerLook.
     *
     * @param qualifiedName of the LookerLook
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerLook
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a LookerLook.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a LookerLook
     * @param qualifiedName of the LookerLook
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerLook
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LookerLookBuilder<C extends LookerLook, B extends LookerLook.LookerLookBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerDashboard dashboard;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerField> fields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerFolder folder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String folderName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerModel model;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerQuery query;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourceContentMetadataId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sourceLastAccessedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sourceLastViewedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourceQueryId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourceUserId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourceViewCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer sourcelastUpdaterId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerTile tile;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LookerLook.LookerLookBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LookerLook instance, final LookerLook.LookerLookBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboard(instance.dashboard);
            b.fields(instance.fields == null ? java.util.Collections.<ILookerField>emptySortedSet() : instance.fields);
            b.folder(instance.folder);
            b.folderName(instance.folderName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.model(instance.model);
            b.modelName(instance.modelName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.query(instance.query);
            b.sourceContentMetadataId(instance.sourceContentMetadataId);
            b.sourceLastAccessedAt(instance.sourceLastAccessedAt);
            b.sourceLastViewedAt(instance.sourceLastViewedAt);
            b.sourceQueryId(instance.sourceQueryId);
            b.sourceUserId(instance.sourceUserId);
            b.sourceViewCount(instance.sourceViewCount);
            b.sourcelastUpdaterId(instance.sourcelastUpdaterId);
            b.tile(instance.tile);
        }

        /**
         * Fixed typeName for LookerLooks.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Dashboard in which this Look is used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dashboard(final ILookerDashboard dashboard) {
            this.dashboard = dashboard;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B field(final ILookerField field) {
            if (this.fields == null) this.fields = new java.util.ArrayList<ILookerField>();
            this.fields.add(field);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B fields(final java.util.Collection<? extends ILookerField> fields) {
            if (fields == null) {
                throw new java.lang.NullPointerException("fields cannot be null");
            }
            if (this.fields == null) this.fields = new java.util.ArrayList<ILookerField>();
            this.fields.addAll(fields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearFields() {
            if (this.fields != null) this.fields.clear();
            return self();
        }

        /**
         * Folder in which this Look exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B folder(final ILookerFolder folder) {
            this.folder = folder;
            return self();
        }

        /**
         * Name of the folder in which the Look is organized.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B folderName(final String folderName) {
            this.folderName = folderName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Model in which this Look exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B model(final ILookerModel model) {
            this.model = model;
            return self();
        }

        /**
         * Name of the model in which this Look exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelName(final String modelName) {
            this.modelName = modelName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B query(final ILookerQuery query) {
            this.query = query;
            return self();
        }

        /**
         * Identifier of the Look's content metadata, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceContentMetadataId(final Integer sourceContentMetadataId) {
            this.sourceContentMetadataId = sourceContentMetadataId;
            return self();
        }

        /**
         * Time (epoch) when the Look was last accessed by a user, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceLastAccessedAt(final Long sourceLastAccessedAt) {
            this.sourceLastAccessedAt = sourceLastAccessedAt;
            return self();
        }

        /**
         * Time (epoch) when the Look was last viewed by a user, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceLastViewedAt(final Long sourceLastViewedAt) {
            this.sourceLastViewedAt = sourceLastViewedAt;
            return self();
        }

        /**
         * Identifier of the query for the Look, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceQueryId(final Integer sourceQueryId) {
            this.sourceQueryId = sourceQueryId;
            return self();
        }

        /**
         * Identifier of the user who created the Look, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceUserId(final Integer sourceUserId) {
            this.sourceUserId = sourceUserId;
            return self();
        }

        /**
         * Number of times the look has been viewed in the Looker web UI.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceViewCount(final Integer sourceViewCount) {
            this.sourceViewCount = sourceViewCount;
            return self();
        }

        /**
         * Identifier of the user that last updated the Look, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourcelastUpdaterId(final Integer sourcelastUpdaterId) {
            this.sourcelastUpdaterId = sourcelastUpdaterId;
            return self();
        }

        /**
         * Tiles that exist within this Look.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tile(final ILookerTile tile) {
            this.tile = tile;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LookerLook.LookerLookBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboard=" + this.dashboard + ", fields=" + this.fields + ", folder=" + this.folder + ", folderName=" + this.folderName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", model=" + this.model + ", modelName=" + this.modelName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", query=" + this.query + ", sourceContentMetadataId=" + this.sourceContentMetadataId + ", sourceLastAccessedAt=" + this.sourceLastAccessedAt + ", sourceLastViewedAt=" + this.sourceLastViewedAt + ", sourceQueryId=" + this.sourceQueryId + ", sourceUserId=" + this.sourceUserId + ", sourceViewCount=" + this.sourceViewCount + ", sourcelastUpdaterId=" + this.sourcelastUpdaterId + ", tile=" + this.tile + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class LookerLookBuilderImpl extends LookerLook.LookerLookBuilder<LookerLook, LookerLook.LookerLookBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LookerLookBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LookerLook.LookerLookBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LookerLook build() {
            return new LookerLook(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LookerLook(final LookerLook.LookerLookBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = LookerLook.$default$typeName();
        this.dashboard = b.dashboard;
        java.util.SortedSet<ILookerField> fields = new java.util.TreeSet<ILookerField>();
        if (b.fields != null) fields.addAll(b.fields);
        fields = java.util.Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        this.folder = b.folder;
        this.folderName = b.folderName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.model = b.model;
        this.modelName = b.modelName;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.query = b.query;
        this.sourceContentMetadataId = b.sourceContentMetadataId;
        this.sourceLastAccessedAt = b.sourceLastAccessedAt;
        this.sourceLastViewedAt = b.sourceLastViewedAt;
        this.sourceQueryId = b.sourceQueryId;
        this.sourceUserId = b.sourceUserId;
        this.sourceViewCount = b.sourceViewCount;
        this.sourcelastUpdaterId = b.sourcelastUpdaterId;
        this.tile = b.tile;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LookerLook.LookerLookBuilder<?, ?> _internal() {
        return new LookerLook.LookerLookBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LookerLook.LookerLookBuilder<?, ?> toBuilder() {
        return new LookerLook.LookerLookBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Dashboard in which this Look is used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerDashboard getDashboard() {
        return this.dashboard;
    }

    /**
     * Fields that are used in this look.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerField> getFields() {
        return this.fields;
    }

    /**
     * Folder in which this Look exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerFolder getFolder() {
        return this.folder;
    }

    /**
     * Name of the folder in which the Look is organized.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFolderName() {
        return this.folderName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Model in which this Look exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerModel getModel() {
        return this.model;
    }

    /**
     * Name of the model in which this Look exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelName() {
        return this.modelName;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerQuery getQuery() {
        return this.query;
    }

    /**
     * Identifier of the Look's content metadata, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourceContentMetadataId() {
        return this.sourceContentMetadataId;
    }

    /**
     * Time (epoch) when the Look was last accessed by a user, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSourceLastAccessedAt() {
        return this.sourceLastAccessedAt;
    }

    /**
     * Time (epoch) when the Look was last viewed by a user, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSourceLastViewedAt() {
        return this.sourceLastViewedAt;
    }

    /**
     * Identifier of the query for the Look, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourceQueryId() {
        return this.sourceQueryId;
    }

    /**
     * Identifier of the user who created the Look, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourceUserId() {
        return this.sourceUserId;
    }

    /**
     * Number of times the look has been viewed in the Looker web UI.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourceViewCount() {
        return this.sourceViewCount;
    }

    /**
     * Identifier of the user that last updated the Look, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getSourcelastUpdaterId() {
        return this.sourcelastUpdaterId;
    }

    /**
     * Tiles that exist within this Look.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerTile getTile() {
        return this.tile;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LookerLook)) return false;
        final LookerLook other = (LookerLook) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$sourceContentMetadataId = this.getSourceContentMetadataId();
        final java.lang.Object other$sourceContentMetadataId = other.getSourceContentMetadataId();
        if (this$sourceContentMetadataId == null ? other$sourceContentMetadataId != null : !this$sourceContentMetadataId.equals(other$sourceContentMetadataId)) return false;
        final java.lang.Object this$sourceLastAccessedAt = this.getSourceLastAccessedAt();
        final java.lang.Object other$sourceLastAccessedAt = other.getSourceLastAccessedAt();
        if (this$sourceLastAccessedAt == null ? other$sourceLastAccessedAt != null : !this$sourceLastAccessedAt.equals(other$sourceLastAccessedAt)) return false;
        final java.lang.Object this$sourceLastViewedAt = this.getSourceLastViewedAt();
        final java.lang.Object other$sourceLastViewedAt = other.getSourceLastViewedAt();
        if (this$sourceLastViewedAt == null ? other$sourceLastViewedAt != null : !this$sourceLastViewedAt.equals(other$sourceLastViewedAt)) return false;
        final java.lang.Object this$sourceQueryId = this.getSourceQueryId();
        final java.lang.Object other$sourceQueryId = other.getSourceQueryId();
        if (this$sourceQueryId == null ? other$sourceQueryId != null : !this$sourceQueryId.equals(other$sourceQueryId)) return false;
        final java.lang.Object this$sourceUserId = this.getSourceUserId();
        final java.lang.Object other$sourceUserId = other.getSourceUserId();
        if (this$sourceUserId == null ? other$sourceUserId != null : !this$sourceUserId.equals(other$sourceUserId)) return false;
        final java.lang.Object this$sourceViewCount = this.getSourceViewCount();
        final java.lang.Object other$sourceViewCount = other.getSourceViewCount();
        if (this$sourceViewCount == null ? other$sourceViewCount != null : !this$sourceViewCount.equals(other$sourceViewCount)) return false;
        final java.lang.Object this$sourcelastUpdaterId = this.getSourcelastUpdaterId();
        final java.lang.Object other$sourcelastUpdaterId = other.getSourcelastUpdaterId();
        if (this$sourcelastUpdaterId == null ? other$sourcelastUpdaterId != null : !this$sourcelastUpdaterId.equals(other$sourcelastUpdaterId)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dashboard = this.getDashboard();
        final java.lang.Object other$dashboard = other.getDashboard();
        if (this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard)) return false;
        final java.lang.Object this$fields = this.getFields();
        final java.lang.Object other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) return false;
        final java.lang.Object this$folder = this.getFolder();
        final java.lang.Object other$folder = other.getFolder();
        if (this$folder == null ? other$folder != null : !this$folder.equals(other$folder)) return false;
        final java.lang.Object this$folderName = this.getFolderName();
        final java.lang.Object other$folderName = other.getFolderName();
        if (this$folderName == null ? other$folderName != null : !this$folderName.equals(other$folderName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$model = this.getModel();
        final java.lang.Object other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) return false;
        final java.lang.Object this$modelName = this.getModelName();
        final java.lang.Object other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$query = this.getQuery();
        final java.lang.Object other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) return false;
        final java.lang.Object this$tile = this.getTile();
        final java.lang.Object other$tile = other.getTile();
        if (this$tile == null ? other$tile != null : !this$tile.equals(other$tile)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LookerLook;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $sourceContentMetadataId = this.getSourceContentMetadataId();
        result = result * PRIME + ($sourceContentMetadataId == null ? 43 : $sourceContentMetadataId.hashCode());
        final java.lang.Object $sourceLastAccessedAt = this.getSourceLastAccessedAt();
        result = result * PRIME + ($sourceLastAccessedAt == null ? 43 : $sourceLastAccessedAt.hashCode());
        final java.lang.Object $sourceLastViewedAt = this.getSourceLastViewedAt();
        result = result * PRIME + ($sourceLastViewedAt == null ? 43 : $sourceLastViewedAt.hashCode());
        final java.lang.Object $sourceQueryId = this.getSourceQueryId();
        result = result * PRIME + ($sourceQueryId == null ? 43 : $sourceQueryId.hashCode());
        final java.lang.Object $sourceUserId = this.getSourceUserId();
        result = result * PRIME + ($sourceUserId == null ? 43 : $sourceUserId.hashCode());
        final java.lang.Object $sourceViewCount = this.getSourceViewCount();
        result = result * PRIME + ($sourceViewCount == null ? 43 : $sourceViewCount.hashCode());
        final java.lang.Object $sourcelastUpdaterId = this.getSourcelastUpdaterId();
        result = result * PRIME + ($sourcelastUpdaterId == null ? 43 : $sourcelastUpdaterId.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dashboard = this.getDashboard();
        result = result * PRIME + ($dashboard == null ? 43 : $dashboard.hashCode());
        final java.lang.Object $fields = this.getFields();
        result = result * PRIME + ($fields == null ? 43 : $fields.hashCode());
        final java.lang.Object $folder = this.getFolder();
        result = result * PRIME + ($folder == null ? 43 : $folder.hashCode());
        final java.lang.Object $folderName = this.getFolderName();
        result = result * PRIME + ($folderName == null ? 43 : $folderName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $model = this.getModel();
        result = result * PRIME + ($model == null ? 43 : $model.hashCode());
        final java.lang.Object $modelName = this.getModelName();
        result = result * PRIME + ($modelName == null ? 43 : $modelName.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $query = this.getQuery();
        result = result * PRIME + ($query == null ? 43 : $query.hashCode());
        final java.lang.Object $tile = this.getTile();
        result = result * PRIME + ($tile == null ? 43 : $tile.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LookerLook(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboard=" + this.getDashboard() + ", fields=" + this.getFields() + ", folder=" + this.getFolder() + ", folderName=" + this.getFolderName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", model=" + this.getModel() + ", modelName=" + this.getModelName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", query=" + this.getQuery() + ", sourceContentMetadataId=" + this.getSourceContentMetadataId() + ", sourceLastAccessedAt=" + this.getSourceLastAccessedAt() + ", sourceLastViewedAt=" + this.getSourceLastViewedAt() + ", sourceQueryId=" + this.getSourceQueryId() + ", sourceUserId=" + this.getSourceUserId() + ", sourceViewCount=" + this.getSourceViewCount() + ", sourcelastUpdaterId=" + this.getSourcelastUpdaterId() + ", tile=" + this.getTile() + ")";
    }

    /**
     * Fixed typeName for LookerLooks.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
