// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Looker project in Atlan. Projects are a collection of files that describe the objects, connections and user interface elements in Looker.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class LookerProject extends Asset implements ILookerProject, ILooker, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LookerProject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerProject";
    /**
     * Fixed typeName for LookerProjects.
     */
    String typeName;
    /**
     * Explores that exist within this project.
     */
    @Attribute
    SortedSet<ILookerExplore> explores;
    /**
     * Fields that exist within this project.
     */
    @Attribute
    SortedSet<ILookerField> fields;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ILookerProject> lookerChildProjects;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ILookerProject> lookerParentProjects;
    /**
     * Models that exist within this project.
     */
    @Attribute
    SortedSet<ILookerModel> models;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Views that exist within this project.
     */
    @Attribute
    SortedSet<ILookerView> views;

    /**
     * Builds the minimal object necessary to create a relationship to a LookerProject, from a potentially
     * more-complete LookerProject object.
     *
     * @return the minimal object necessary to relate to the LookerProject
     * @throws InvalidRequestException if any of the minimal set of required properties for a LookerProject relationship are not found in the initial object
     */
    @Override
    public LookerProject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all LookerProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerProject assets will be included.
     *
     * @return a fluent search that includes all LookerProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all LookerProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerProject assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all LookerProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all LookerProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) LookerProjects will be included
     * @return a fluent search that includes all LookerProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all LookerProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) LookerProjects will be included
     * @return a fluent search that includes all LookerProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a LookerProject by GUID. Use this to create a relationship to this LookerProject,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the LookerProject to reference
     * @return reference to a LookerProject that can be used for defining a relationship to a LookerProject
     */
    public static LookerProject refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerProject by GUID. Use this to create a relationship to this LookerProject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the LookerProject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerProject that can be used for defining a relationship to a LookerProject
     */
    public static LookerProject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return LookerProject._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a LookerProject by qualifiedName. Use this to create a relationship to this LookerProject,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the LookerProject to reference
     * @return reference to a LookerProject that can be used for defining a relationship to a LookerProject
     */
    public static LookerProject refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerProject by qualifiedName. Use this to create a relationship to this LookerProject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the LookerProject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerProject that can be used for defining a relationship to a LookerProject
     */
    public static LookerProject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return LookerProject._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a LookerProject by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the LookerProject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerProject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerProject does not exist or the provided GUID is not a LookerProject
     */
    @JsonIgnore
    public static LookerProject get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a LookerProject by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerProject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerProject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerProject does not exist or the provided GUID is not a LookerProject
     */
    @JsonIgnore
    public static LookerProject get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a LookerProject by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerProject to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full LookerProject, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerProject does not exist or the provided GUID is not a LookerProject
     */
    @JsonIgnore
    public static LookerProject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof LookerProject) {
                return (LookerProject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof LookerProject) {
                return (LookerProject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) LookerProject to active.
     *
     * @param qualifiedName for the LookerProject
     * @return true if the LookerProject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) LookerProject to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the LookerProject
     * @return true if the LookerProject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the minimal request necessary to update the LookerProject, as a builder
     */
    public static LookerProjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return LookerProject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a LookerProject, from a potentially
     * more-complete LookerProject object.
     *
     * @return the minimal object necessary to update the LookerProject, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for LookerProject are not found in the initial object
     */
    @Override
    public LookerProjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a LookerProject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a LookerProject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a LookerProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerProject's owners
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerProject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a LookerProject.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerProject's certificate
     * @param qualifiedName of the LookerProject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerProject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerProject) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a LookerProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerProject's certificate
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a LookerProject.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerProject's announcement
     * @param qualifiedName of the LookerProject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerProject) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a LookerProject.
     *
     * @param client connectivity to the Atlan client from which to remove the LookerProject's announcement
     * @param qualifiedName of the LookerProject
     * @param name of the LookerProject
     * @return the updated LookerProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerProject) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the LookerProject.
     *
     * @param qualifiedName for the LookerProject
     * @param name human-readable name of the LookerProject
     * @param terms the list of terms to replace on the LookerProject, or null to remove all terms from the LookerProject
     * @return the LookerProject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerProject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the LookerProject.
     *
     * @param client connectivity to the Atlan tenant on which to replace the LookerProject's assigned terms
     * @param qualifiedName for the LookerProject
     * @param name human-readable name of the LookerProject
     * @param terms the list of terms to replace on the LookerProject, or null to remove all terms from the LookerProject
     * @return the LookerProject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerProject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerProject) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the LookerProject, without replacing existing terms linked to the LookerProject.
     * Note: this operation must make two API calls — one to retrieve the LookerProject's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the LookerProject
     * @param terms the list of terms to append to the LookerProject
     * @return the LookerProject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerProject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the LookerProject, without replacing existing terms linked to the LookerProject.
     * Note: this operation must make two API calls — one to retrieve the LookerProject's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the LookerProject
     * @param qualifiedName for the LookerProject
     * @param terms the list of terms to append to the LookerProject
     * @return the LookerProject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerProject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerProject) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerProject, without replacing all existing terms linked to the LookerProject.
     * Note: this operation must make two API calls — one to retrieve the LookerProject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the LookerProject
     * @param terms the list of terms to remove from the LookerProject, which must be referenced by GUID
     * @return the LookerProject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerProject, without replacing all existing terms linked to the LookerProject.
     * Note: this operation must make two API calls — one to retrieve the LookerProject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the LookerProject
     * @param qualifiedName for the LookerProject
     * @param terms the list of terms to remove from the LookerProject, which must be referenced by GUID
     * @return the LookerProject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerProject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerProject) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a LookerProject, without replacing existing Atlan tags linked to the LookerProject.
     * Note: this operation must make two API calls — one to retrieve the LookerProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerProject
     */
    public static LookerProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerProject, without replacing existing Atlan tags linked to the LookerProject.
     * Note: this operation must make two API calls — one to retrieve the LookerProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerProject
     * @param qualifiedName of the LookerProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerProject
     */
    public static LookerProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerProject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerProject, without replacing existing Atlan tags linked to the LookerProject.
     * Note: this operation must make two API calls — one to retrieve the LookerProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerProject
     */
    public static LookerProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a LookerProject, without replacing existing Atlan tags linked to the LookerProject.
     * Note: this operation must make two API calls — one to retrieve the LookerProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerProject
     * @param qualifiedName of the LookerProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerProject
     */
    public static LookerProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerProject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a LookerProject.
     *
     * @param qualifiedName of the LookerProject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerProject
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a LookerProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a LookerProject
     * @param qualifiedName of the LookerProject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerProject
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LookerProjectBuilder<C extends LookerProject, B extends LookerProject.LookerProjectBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerExplore> explores;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerField> fields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerProject> lookerChildProjects;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerProject> lookerParentProjects;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerModel> models;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerView> views;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LookerProject.LookerProjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LookerProject instance, final LookerProject.LookerProjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.explores(instance.explores == null ? java.util.Collections.<ILookerExplore>emptySortedSet() : instance.explores);
            b.fields(instance.fields == null ? java.util.Collections.<ILookerField>emptySortedSet() : instance.fields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.lookerChildProjects(instance.lookerChildProjects == null ? java.util.Collections.<ILookerProject>emptySortedSet() : instance.lookerChildProjects);
            b.lookerParentProjects(instance.lookerParentProjects == null ? java.util.Collections.<ILookerProject>emptySortedSet() : instance.lookerParentProjects);
            b.models(instance.models == null ? java.util.Collections.<ILookerModel>emptySortedSet() : instance.models);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.views(instance.views == null ? java.util.Collections.<ILookerView>emptySortedSet() : instance.views);
        }

        /**
         * Fixed typeName for LookerProjects.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B explore(final ILookerExplore explore) {
            if (this.explores == null) this.explores = new java.util.ArrayList<ILookerExplore>();
            this.explores.add(explore);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B explores(final java.util.Collection<? extends ILookerExplore> explores) {
            if (explores == null) {
                throw new java.lang.NullPointerException("explores cannot be null");
            }
            if (this.explores == null) this.explores = new java.util.ArrayList<ILookerExplore>();
            this.explores.addAll(explores);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearExplores() {
            if (this.explores != null) this.explores.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B field(final ILookerField field) {
            if (this.fields == null) this.fields = new java.util.ArrayList<ILookerField>();
            this.fields.add(field);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B fields(final java.util.Collection<? extends ILookerField> fields) {
            if (fields == null) {
                throw new java.lang.NullPointerException("fields cannot be null");
            }
            if (this.fields == null) this.fields = new java.util.ArrayList<ILookerField>();
            this.fields.addAll(fields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearFields() {
            if (this.fields != null) this.fields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerChildProject(final ILookerProject lookerChildProject) {
            if (this.lookerChildProjects == null) this.lookerChildProjects = new java.util.ArrayList<ILookerProject>();
            this.lookerChildProjects.add(lookerChildProject);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerChildProjects(final java.util.Collection<? extends ILookerProject> lookerChildProjects) {
            if (lookerChildProjects == null) {
                throw new java.lang.NullPointerException("lookerChildProjects cannot be null");
            }
            if (this.lookerChildProjects == null) this.lookerChildProjects = new java.util.ArrayList<ILookerProject>();
            this.lookerChildProjects.addAll(lookerChildProjects);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLookerChildProjects() {
            if (this.lookerChildProjects != null) this.lookerChildProjects.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerParentProject(final ILookerProject lookerParentProject) {
            if (this.lookerParentProjects == null) this.lookerParentProjects = new java.util.ArrayList<ILookerProject>();
            this.lookerParentProjects.add(lookerParentProject);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookerParentProjects(final java.util.Collection<? extends ILookerProject> lookerParentProjects) {
            if (lookerParentProjects == null) {
                throw new java.lang.NullPointerException("lookerParentProjects cannot be null");
            }
            if (this.lookerParentProjects == null) this.lookerParentProjects = new java.util.ArrayList<ILookerProject>();
            this.lookerParentProjects.addAll(lookerParentProjects);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLookerParentProjects() {
            if (this.lookerParentProjects != null) this.lookerParentProjects.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B model(final ILookerModel model) {
            if (this.models == null) this.models = new java.util.ArrayList<ILookerModel>();
            this.models.add(model);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B models(final java.util.Collection<? extends ILookerModel> models) {
            if (models == null) {
                throw new java.lang.NullPointerException("models cannot be null");
            }
            if (this.models == null) this.models = new java.util.ArrayList<ILookerModel>();
            this.models.addAll(models);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModels() {
            if (this.models != null) this.models.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B view(final ILookerView view) {
            if (this.views == null) this.views = new java.util.ArrayList<ILookerView>();
            this.views.add(view);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B views(final java.util.Collection<? extends ILookerView> views) {
            if (views == null) {
                throw new java.lang.NullPointerException("views cannot be null");
            }
            if (this.views == null) this.views = new java.util.ArrayList<ILookerView>();
            this.views.addAll(views);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearViews() {
            if (this.views != null) this.views.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LookerProject.LookerProjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", explores=" + this.explores + ", fields=" + this.fields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", lookerChildProjects=" + this.lookerChildProjects + ", lookerParentProjects=" + this.lookerParentProjects + ", models=" + this.models + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", views=" + this.views + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class LookerProjectBuilderImpl extends LookerProject.LookerProjectBuilder<LookerProject, LookerProject.LookerProjectBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LookerProjectBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LookerProject.LookerProjectBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LookerProject build() {
            return new LookerProject(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LookerProject(final LookerProject.LookerProjectBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = LookerProject.$default$typeName();
        java.util.SortedSet<ILookerExplore> explores = new java.util.TreeSet<ILookerExplore>();
        if (b.explores != null) explores.addAll(b.explores);
        explores = java.util.Collections.unmodifiableSortedSet(explores);
        this.explores = explores;
        java.util.SortedSet<ILookerField> fields = new java.util.TreeSet<ILookerField>();
        if (b.fields != null) fields.addAll(b.fields);
        fields = java.util.Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<ILookerProject> lookerChildProjects = new java.util.TreeSet<ILookerProject>();
        if (b.lookerChildProjects != null) lookerChildProjects.addAll(b.lookerChildProjects);
        lookerChildProjects = java.util.Collections.unmodifiableSortedSet(lookerChildProjects);
        this.lookerChildProjects = lookerChildProjects;
        java.util.SortedSet<ILookerProject> lookerParentProjects = new java.util.TreeSet<ILookerProject>();
        if (b.lookerParentProjects != null) lookerParentProjects.addAll(b.lookerParentProjects);
        lookerParentProjects = java.util.Collections.unmodifiableSortedSet(lookerParentProjects);
        this.lookerParentProjects = lookerParentProjects;
        java.util.SortedSet<ILookerModel> models = new java.util.TreeSet<ILookerModel>();
        if (b.models != null) models.addAll(b.models);
        models = java.util.Collections.unmodifiableSortedSet(models);
        this.models = models;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<ILookerView> views = new java.util.TreeSet<ILookerView>();
        if (b.views != null) views.addAll(b.views);
        views = java.util.Collections.unmodifiableSortedSet(views);
        this.views = views;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LookerProject.LookerProjectBuilder<?, ?> _internal() {
        return new LookerProject.LookerProjectBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LookerProject.LookerProjectBuilder<?, ?> toBuilder() {
        return new LookerProject.LookerProjectBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Explores that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerExplore> getExplores() {
        return this.explores;
    }

    /**
     * Fields that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerField> getFields() {
        return this.fields;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerProject> getLookerChildProjects() {
        return this.lookerChildProjects;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerProject> getLookerParentProjects() {
        return this.lookerParentProjects;
    }

    /**
     * Models that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerModel> getModels() {
        return this.models;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Views that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerView> getViews() {
        return this.views;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LookerProject)) return false;
        final LookerProject other = (LookerProject) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$explores = this.getExplores();
        final java.lang.Object other$explores = other.getExplores();
        if (this$explores == null ? other$explores != null : !this$explores.equals(other$explores)) return false;
        final java.lang.Object this$fields = this.getFields();
        final java.lang.Object other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$lookerChildProjects = this.getLookerChildProjects();
        final java.lang.Object other$lookerChildProjects = other.getLookerChildProjects();
        if (this$lookerChildProjects == null ? other$lookerChildProjects != null : !this$lookerChildProjects.equals(other$lookerChildProjects)) return false;
        final java.lang.Object this$lookerParentProjects = this.getLookerParentProjects();
        final java.lang.Object other$lookerParentProjects = other.getLookerParentProjects();
        if (this$lookerParentProjects == null ? other$lookerParentProjects != null : !this$lookerParentProjects.equals(other$lookerParentProjects)) return false;
        final java.lang.Object this$models = this.getModels();
        final java.lang.Object other$models = other.getModels();
        if (this$models == null ? other$models != null : !this$models.equals(other$models)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$views = this.getViews();
        final java.lang.Object other$views = other.getViews();
        if (this$views == null ? other$views != null : !this$views.equals(other$views)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LookerProject;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $explores = this.getExplores();
        result = result * PRIME + ($explores == null ? 43 : $explores.hashCode());
        final java.lang.Object $fields = this.getFields();
        result = result * PRIME + ($fields == null ? 43 : $fields.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $lookerChildProjects = this.getLookerChildProjects();
        result = result * PRIME + ($lookerChildProjects == null ? 43 : $lookerChildProjects.hashCode());
        final java.lang.Object $lookerParentProjects = this.getLookerParentProjects();
        result = result * PRIME + ($lookerParentProjects == null ? 43 : $lookerParentProjects.hashCode());
        final java.lang.Object $models = this.getModels();
        result = result * PRIME + ($models == null ? 43 : $models.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $views = this.getViews();
        result = result * PRIME + ($views == null ? 43 : $views.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LookerProject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", explores=" + this.getExplores() + ", fields=" + this.getFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", lookerChildProjects=" + this.getLookerChildProjects() + ", lookerParentProjects=" + this.getLookerParentProjects() + ", models=" + this.getModels() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", views=" + this.getViews() + ")";
    }

    /**
     * Fixed typeName for LookerProjects.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
