// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Deprecated.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class LookerQuery extends Asset implements ILookerQuery, ILooker, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LookerQuery.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerQuery";
    /**
     * Fixed typeName for LookerQuerys.
     */
    String typeName;
    /**
     * Deprecated.
     */
    @Attribute
    SortedSet<String> fields;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Deprecated.
     */
    @Attribute
    SortedSet<ILookerLook> looks;
    /**
     * Deprecated.
     */
    @Attribute
    ILookerModel model;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Deprecated.
     */
    @Attribute
    String sourceDefinition;
    /**
     * Deprecated.
     */
    @Attribute
    String sourceDefinitionDatabase;
    /**
     * Deprecated.
     */
    @Attribute
    String sourceDefinitionSchema;
    /**
     * Deprecated.
     */
    @Attribute
    SortedSet<ILookerTile> tiles;

    /**
     * Builds the minimal object necessary to create a relationship to a LookerQuery, from a potentially
     * more-complete LookerQuery object.
     *
     * @return the minimal object necessary to relate to the LookerQuery
     * @throws InvalidRequestException if any of the minimal set of required properties for a LookerQuery relationship are not found in the initial object
     */
    @Override
    public LookerQuery trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all LookerQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerQuery assets will be included.
     *
     * @return a fluent search that includes all LookerQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all LookerQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerQuery assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all LookerQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all LookerQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) LookerQuerys will be included
     * @return a fluent search that includes all LookerQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all LookerQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) LookerQuerys will be included
     * @return a fluent search that includes all LookerQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a LookerQuery by GUID. Use this to create a relationship to this LookerQuery,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the LookerQuery to reference
     * @return reference to a LookerQuery that can be used for defining a relationship to a LookerQuery
     */
    public static LookerQuery refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerQuery by GUID. Use this to create a relationship to this LookerQuery,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the LookerQuery to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerQuery that can be used for defining a relationship to a LookerQuery
     */
    public static LookerQuery refByGuid(String guid, Reference.SaveSemantic semantic) {
        return LookerQuery._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a LookerQuery by qualifiedName. Use this to create a relationship to this LookerQuery,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the LookerQuery to reference
     * @return reference to a LookerQuery that can be used for defining a relationship to a LookerQuery
     */
    public static LookerQuery refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerQuery by qualifiedName. Use this to create a relationship to this LookerQuery,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the LookerQuery to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerQuery that can be used for defining a relationship to a LookerQuery
     */
    public static LookerQuery refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return LookerQuery._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a LookerQuery by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the LookerQuery to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerQuery, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerQuery does not exist or the provided GUID is not a LookerQuery
     */
    @JsonIgnore
    public static LookerQuery get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a LookerQuery by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerQuery to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerQuery, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerQuery does not exist or the provided GUID is not a LookerQuery
     */
    @JsonIgnore
    public static LookerQuery get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a LookerQuery by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerQuery to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full LookerQuery, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerQuery does not exist or the provided GUID is not a LookerQuery
     */
    @JsonIgnore
    public static LookerQuery get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof LookerQuery) {
                return (LookerQuery) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof LookerQuery) {
                return (LookerQuery) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) LookerQuery to active.
     *
     * @param qualifiedName for the LookerQuery
     * @return true if the LookerQuery is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) LookerQuery to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the LookerQuery
     * @return true if the LookerQuery is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the minimal request necessary to update the LookerQuery, as a builder
     */
    public static LookerQueryBuilder<?, ?> updater(String qualifiedName, String name) {
        return LookerQuery._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a LookerQuery, from a potentially
     * more-complete LookerQuery object.
     *
     * @return the minimal object necessary to update the LookerQuery, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for LookerQuery are not found in the initial object
     */
    @Override
    public LookerQueryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a LookerQuery.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerQuery) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a LookerQuery.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerQuery) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a LookerQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerQuery's owners
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerQuery) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerQuery, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a LookerQuery.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerQuery's certificate
     * @param qualifiedName of the LookerQuery
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerQuery, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerQuery) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a LookerQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerQuery's certificate
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerQuery) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a LookerQuery.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerQuery's announcement
     * @param qualifiedName of the LookerQuery
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerQuery) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a LookerQuery.
     *
     * @param client connectivity to the Atlan client from which to remove the LookerQuery's announcement
     * @param qualifiedName of the LookerQuery
     * @param name of the LookerQuery
     * @return the updated LookerQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerQuery) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the LookerQuery.
     *
     * @param qualifiedName for the LookerQuery
     * @param name human-readable name of the LookerQuery
     * @param terms the list of terms to replace on the LookerQuery, or null to remove all terms from the LookerQuery
     * @return the LookerQuery that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerQuery replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the LookerQuery.
     *
     * @param client connectivity to the Atlan tenant on which to replace the LookerQuery's assigned terms
     * @param qualifiedName for the LookerQuery
     * @param name human-readable name of the LookerQuery
     * @param terms the list of terms to replace on the LookerQuery, or null to remove all terms from the LookerQuery
     * @return the LookerQuery that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerQuery replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerQuery) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the LookerQuery, without replacing existing terms linked to the LookerQuery.
     * Note: this operation must make two API calls — one to retrieve the LookerQuery's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the LookerQuery
     * @param terms the list of terms to append to the LookerQuery
     * @return the LookerQuery that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerQuery appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the LookerQuery, without replacing existing terms linked to the LookerQuery.
     * Note: this operation must make two API calls — one to retrieve the LookerQuery's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the LookerQuery
     * @param qualifiedName for the LookerQuery
     * @param terms the list of terms to append to the LookerQuery
     * @return the LookerQuery that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerQuery appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerQuery) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerQuery, without replacing all existing terms linked to the LookerQuery.
     * Note: this operation must make two API calls — one to retrieve the LookerQuery's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the LookerQuery
     * @param terms the list of terms to remove from the LookerQuery, which must be referenced by GUID
     * @return the LookerQuery that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerQuery, without replacing all existing terms linked to the LookerQuery.
     * Note: this operation must make two API calls — one to retrieve the LookerQuery's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the LookerQuery
     * @param qualifiedName for the LookerQuery
     * @param terms the list of terms to remove from the LookerQuery, which must be referenced by GUID
     * @return the LookerQuery that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerQuery removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerQuery) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a LookerQuery, without replacing existing Atlan tags linked to the LookerQuery.
     * Note: this operation must make two API calls — one to retrieve the LookerQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerQuery
     */
    public static LookerQuery appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerQuery, without replacing existing Atlan tags linked to the LookerQuery.
     * Note: this operation must make two API calls — one to retrieve the LookerQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerQuery
     * @param qualifiedName of the LookerQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerQuery
     */
    public static LookerQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerQuery) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerQuery, without replacing existing Atlan tags linked to the LookerQuery.
     * Note: this operation must make two API calls — one to retrieve the LookerQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerQuery
     */
    public static LookerQuery appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a LookerQuery, without replacing existing Atlan tags linked to the LookerQuery.
     * Note: this operation must make two API calls — one to retrieve the LookerQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerQuery
     * @param qualifiedName of the LookerQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerQuery
     */
    public static LookerQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerQuery) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a LookerQuery.
     *
     * @param qualifiedName of the LookerQuery
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerQuery
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a LookerQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a LookerQuery
     * @param qualifiedName of the LookerQuery
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerQuery
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LookerQueryBuilder<C extends LookerQuery, B extends LookerQuery.LookerQueryBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> fields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerLook> looks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerModel model;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceDefinition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceDefinitionDatabase;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sourceDefinitionSchema;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerTile> tiles;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LookerQuery.LookerQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LookerQuery instance, final LookerQuery.LookerQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.fields(instance.fields == null ? java.util.Collections.<String>emptySortedSet() : instance.fields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.looks(instance.looks == null ? java.util.Collections.<ILookerLook>emptySortedSet() : instance.looks);
            b.model(instance.model);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.sourceDefinition(instance.sourceDefinition);
            b.sourceDefinitionDatabase(instance.sourceDefinitionDatabase);
            b.sourceDefinitionSchema(instance.sourceDefinitionSchema);
            b.tiles(instance.tiles == null ? java.util.Collections.<ILookerTile>emptySortedSet() : instance.tiles);
        }

        /**
         * Fixed typeName for LookerQuerys.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B field(final String field) {
            if (this.fields == null) this.fields = new java.util.ArrayList<String>();
            this.fields.add(field);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B fields(final java.util.Collection<? extends String> fields) {
            if (fields == null) {
                throw new java.lang.NullPointerException("fields cannot be null");
            }
            if (this.fields == null) this.fields = new java.util.ArrayList<String>();
            this.fields.addAll(fields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearFields() {
            if (this.fields != null) this.fields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B look(final ILookerLook look) {
            if (this.looks == null) this.looks = new java.util.ArrayList<ILookerLook>();
            this.looks.add(look);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B looks(final java.util.Collection<? extends ILookerLook> looks) {
            if (looks == null) {
                throw new java.lang.NullPointerException("looks cannot be null");
            }
            if (this.looks == null) this.looks = new java.util.ArrayList<ILookerLook>();
            this.looks.addAll(looks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLooks() {
            if (this.looks != null) this.looks.clear();
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B model(final ILookerModel model) {
            this.model = model;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceDefinition(final String sourceDefinition) {
            this.sourceDefinition = sourceDefinition;
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceDefinitionDatabase(final String sourceDefinitionDatabase) {
            this.sourceDefinitionDatabase = sourceDefinitionDatabase;
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sourceDefinitionSchema(final String sourceDefinitionSchema) {
            this.sourceDefinitionSchema = sourceDefinitionSchema;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tile(final ILookerTile tile) {
            if (this.tiles == null) this.tiles = new java.util.ArrayList<ILookerTile>();
            this.tiles.add(tile);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tiles(final java.util.Collection<? extends ILookerTile> tiles) {
            if (tiles == null) {
                throw new java.lang.NullPointerException("tiles cannot be null");
            }
            if (this.tiles == null) this.tiles = new java.util.ArrayList<ILookerTile>();
            this.tiles.addAll(tiles);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTiles() {
            if (this.tiles != null) this.tiles.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LookerQuery.LookerQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", fields=" + this.fields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", looks=" + this.looks + ", model=" + this.model + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sourceDefinition=" + this.sourceDefinition + ", sourceDefinitionDatabase=" + this.sourceDefinitionDatabase + ", sourceDefinitionSchema=" + this.sourceDefinitionSchema + ", tiles=" + this.tiles + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class LookerQueryBuilderImpl extends LookerQuery.LookerQueryBuilder<LookerQuery, LookerQuery.LookerQueryBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LookerQueryBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LookerQuery.LookerQueryBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LookerQuery build() {
            return new LookerQuery(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LookerQuery(final LookerQuery.LookerQueryBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = LookerQuery.$default$typeName();
        java.util.SortedSet<String> fields = new java.util.TreeSet<String>();
        if (b.fields != null) fields.addAll(b.fields);
        fields = java.util.Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<ILookerLook> looks = new java.util.TreeSet<ILookerLook>();
        if (b.looks != null) looks.addAll(b.looks);
        looks = java.util.Collections.unmodifiableSortedSet(looks);
        this.looks = looks;
        this.model = b.model;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sourceDefinition = b.sourceDefinition;
        this.sourceDefinitionDatabase = b.sourceDefinitionDatabase;
        this.sourceDefinitionSchema = b.sourceDefinitionSchema;
        java.util.SortedSet<ILookerTile> tiles = new java.util.TreeSet<ILookerTile>();
        if (b.tiles != null) tiles.addAll(b.tiles);
        tiles = java.util.Collections.unmodifiableSortedSet(tiles);
        this.tiles = tiles;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LookerQuery.LookerQueryBuilder<?, ?> _internal() {
        return new LookerQuery.LookerQueryBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LookerQuery.LookerQueryBuilder<?, ?> toBuilder() {
        return new LookerQuery.LookerQueryBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getFields() {
        return this.fields;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerLook> getLooks() {
        return this.looks;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerModel getModel() {
        return this.model;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceDefinition() {
        return this.sourceDefinition;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceDefinitionDatabase() {
        return this.sourceDefinitionDatabase;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSourceDefinitionSchema() {
        return this.sourceDefinitionSchema;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerTile> getTiles() {
        return this.tiles;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LookerQuery)) return false;
        final LookerQuery other = (LookerQuery) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$fields = this.getFields();
        final java.lang.Object other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$looks = this.getLooks();
        final java.lang.Object other$looks = other.getLooks();
        if (this$looks == null ? other$looks != null : !this$looks.equals(other$looks)) return false;
        final java.lang.Object this$model = this.getModel();
        final java.lang.Object other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$sourceDefinition = this.getSourceDefinition();
        final java.lang.Object other$sourceDefinition = other.getSourceDefinition();
        if (this$sourceDefinition == null ? other$sourceDefinition != null : !this$sourceDefinition.equals(other$sourceDefinition)) return false;
        final java.lang.Object this$sourceDefinitionDatabase = this.getSourceDefinitionDatabase();
        final java.lang.Object other$sourceDefinitionDatabase = other.getSourceDefinitionDatabase();
        if (this$sourceDefinitionDatabase == null ? other$sourceDefinitionDatabase != null : !this$sourceDefinitionDatabase.equals(other$sourceDefinitionDatabase)) return false;
        final java.lang.Object this$sourceDefinitionSchema = this.getSourceDefinitionSchema();
        final java.lang.Object other$sourceDefinitionSchema = other.getSourceDefinitionSchema();
        if (this$sourceDefinitionSchema == null ? other$sourceDefinitionSchema != null : !this$sourceDefinitionSchema.equals(other$sourceDefinitionSchema)) return false;
        final java.lang.Object this$tiles = this.getTiles();
        final java.lang.Object other$tiles = other.getTiles();
        if (this$tiles == null ? other$tiles != null : !this$tiles.equals(other$tiles)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LookerQuery;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $fields = this.getFields();
        result = result * PRIME + ($fields == null ? 43 : $fields.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $looks = this.getLooks();
        result = result * PRIME + ($looks == null ? 43 : $looks.hashCode());
        final java.lang.Object $model = this.getModel();
        result = result * PRIME + ($model == null ? 43 : $model.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $sourceDefinition = this.getSourceDefinition();
        result = result * PRIME + ($sourceDefinition == null ? 43 : $sourceDefinition.hashCode());
        final java.lang.Object $sourceDefinitionDatabase = this.getSourceDefinitionDatabase();
        result = result * PRIME + ($sourceDefinitionDatabase == null ? 43 : $sourceDefinitionDatabase.hashCode());
        final java.lang.Object $sourceDefinitionSchema = this.getSourceDefinitionSchema();
        result = result * PRIME + ($sourceDefinitionSchema == null ? 43 : $sourceDefinitionSchema.hashCode());
        final java.lang.Object $tiles = this.getTiles();
        result = result * PRIME + ($tiles == null ? 43 : $tiles.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LookerQuery(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", fields=" + this.getFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", looks=" + this.getLooks() + ", model=" + this.getModel() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sourceDefinition=" + this.getSourceDefinition() + ", sourceDefinitionDatabase=" + this.getSourceDefinitionDatabase() + ", sourceDefinitionSchema=" + this.getSourceDefinitionSchema() + ", tiles=" + this.getTiles() + ")";
    }

    /**
     * Fixed typeName for LookerQuerys.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
