// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Looker tile in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class LookerTile extends Asset implements ILookerTile, ILooker, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LookerTile.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerTile";
    /**
     * Fixed typeName for LookerTiles.
     */
    String typeName;
    /**
     * Dashboard in which this tile exists.
     */
    @Attribute
    ILookerDashboard dashboard;
    /**
     * Fields that are used in the tile.
     */
    @Attribute
    SortedSet<ILookerField> fields;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Look in which this tile exists.
     */
    @Attribute
    ILookerLook look;
    /**
     * Identifier of the Look used to create this tile, from Looker.
     */
    @Attribute
    Integer lookId;
    /**
     * Identifier for the LoomML link.
     */
    @Attribute
    String lookmlLinkId;
    /**
     * Identifier for the merge result.
     */
    @Attribute
    String mergeResultId;
    /**
     * Text of notes added to the tile.
     */
    @Attribute
    String noteText;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Deprecated.
     */
    @Attribute
    ILookerQuery query;
    /**
     * Identifier for the query used to build this tile, from Looker.
     */
    @Attribute
    Integer queryID;
    /**
     * Identifier of the ResultMarkerLookup entry, from Looker.
     */
    @Attribute
    Integer resultMakerID;
    /**
     * Text for the subtitle for text tiles.
     */
    @Attribute
    String subtitleText;

    /**
     * Builds the minimal object necessary to create a relationship to a LookerTile, from a potentially
     * more-complete LookerTile object.
     *
     * @return the minimal object necessary to relate to the LookerTile
     * @throws InvalidRequestException if any of the minimal set of required properties for a LookerTile relationship are not found in the initial object
     */
    @Override
    public LookerTile trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all LookerTile assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerTile assets will be included.
     *
     * @return a fluent search that includes all LookerTile assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all LookerTile assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) LookerTile assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all LookerTile assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all LookerTile assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) LookerTiles will be included
     * @return a fluent search that includes all LookerTile assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all LookerTile assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) LookerTiles will be included
     * @return a fluent search that includes all LookerTile assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a LookerTile by GUID. Use this to create a relationship to this LookerTile,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the LookerTile to reference
     * @return reference to a LookerTile that can be used for defining a relationship to a LookerTile
     */
    public static LookerTile refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerTile by GUID. Use this to create a relationship to this LookerTile,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the LookerTile to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerTile that can be used for defining a relationship to a LookerTile
     */
    public static LookerTile refByGuid(String guid, Reference.SaveSemantic semantic) {
        return LookerTile._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a LookerTile by qualifiedName. Use this to create a relationship to this LookerTile,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the LookerTile to reference
     * @return reference to a LookerTile that can be used for defining a relationship to a LookerTile
     */
    public static LookerTile refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a LookerTile by qualifiedName. Use this to create a relationship to this LookerTile,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the LookerTile to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a LookerTile that can be used for defining a relationship to a LookerTile
     */
    public static LookerTile refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return LookerTile._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a LookerTile by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the LookerTile to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerTile, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerTile does not exist or the provided GUID is not a LookerTile
     */
    @JsonIgnore
    public static LookerTile get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a LookerTile by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerTile to retrieve, either its GUID or its full qualifiedName
     * @return the requested full LookerTile, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerTile does not exist or the provided GUID is not a LookerTile
     */
    @JsonIgnore
    public static LookerTile get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a LookerTile by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the LookerTile to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full LookerTile, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the LookerTile does not exist or the provided GUID is not a LookerTile
     */
    @JsonIgnore
    public static LookerTile get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof LookerTile) {
                return (LookerTile) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof LookerTile) {
                return (LookerTile) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) LookerTile to active.
     *
     * @param qualifiedName for the LookerTile
     * @return true if the LookerTile is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) LookerTile to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the LookerTile
     * @return true if the LookerTile is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the minimal request necessary to update the LookerTile, as a builder
     */
    public static LookerTileBuilder<?, ?> updater(String qualifiedName, String name) {
        return LookerTile._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a LookerTile, from a potentially
     * more-complete LookerTile object.
     *
     * @return the minimal object necessary to update the LookerTile, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for LookerTile are not found in the initial object
     */
    @Override
    public LookerTileBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a LookerTile.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerTile) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a LookerTile.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerTile) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a LookerTile.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerTile's owners
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerTile) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerTile, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a LookerTile.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerTile's certificate
     * @param qualifiedName of the LookerTile
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated LookerTile, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerTile) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a LookerTile.
     *
     * @param client connectivity to the Atlan tenant from which to remove the LookerTile's certificate
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerTile) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a LookerTile.
     *
     * @param client connectivity to the Atlan tenant on which to update the LookerTile's announcement
     * @param qualifiedName of the LookerTile
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerTile) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a LookerTile.
     *
     * @param client connectivity to the Atlan client from which to remove the LookerTile's announcement
     * @param qualifiedName of the LookerTile
     * @param name of the LookerTile
     * @return the updated LookerTile, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerTile) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the LookerTile.
     *
     * @param qualifiedName for the LookerTile
     * @param name human-readable name of the LookerTile
     * @param terms the list of terms to replace on the LookerTile, or null to remove all terms from the LookerTile
     * @return the LookerTile that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerTile replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the LookerTile.
     *
     * @param client connectivity to the Atlan tenant on which to replace the LookerTile's assigned terms
     * @param qualifiedName for the LookerTile
     * @param name human-readable name of the LookerTile
     * @param terms the list of terms to replace on the LookerTile, or null to remove all terms from the LookerTile
     * @return the LookerTile that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static LookerTile replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerTile) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the LookerTile, without replacing existing terms linked to the LookerTile.
     * Note: this operation must make two API calls — one to retrieve the LookerTile's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the LookerTile
     * @param terms the list of terms to append to the LookerTile
     * @return the LookerTile that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerTile appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the LookerTile, without replacing existing terms linked to the LookerTile.
     * Note: this operation must make two API calls — one to retrieve the LookerTile's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the LookerTile
     * @param qualifiedName for the LookerTile
     * @param terms the list of terms to append to the LookerTile
     * @return the LookerTile that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static LookerTile appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerTile) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerTile, without replacing all existing terms linked to the LookerTile.
     * Note: this operation must make two API calls — one to retrieve the LookerTile's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the LookerTile
     * @param terms the list of terms to remove from the LookerTile, which must be referenced by GUID
     * @return the LookerTile that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a LookerTile, without replacing all existing terms linked to the LookerTile.
     * Note: this operation must make two API calls — one to retrieve the LookerTile's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the LookerTile
     * @param qualifiedName for the LookerTile
     * @param terms the list of terms to remove from the LookerTile, which must be referenced by GUID
     * @return the LookerTile that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static LookerTile removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerTile) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a LookerTile, without replacing existing Atlan tags linked to the LookerTile.
     * Note: this operation must make two API calls — one to retrieve the LookerTile's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerTile
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerTile
     */
    public static LookerTile appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerTile, without replacing existing Atlan tags linked to the LookerTile.
     * Note: this operation must make two API calls — one to retrieve the LookerTile's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerTile
     * @param qualifiedName of the LookerTile
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated LookerTile
     */
    public static LookerTile appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerTile) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a LookerTile, without replacing existing Atlan tags linked to the LookerTile.
     * Note: this operation must make two API calls — one to retrieve the LookerTile's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the LookerTile
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerTile
     */
    public static LookerTile appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a LookerTile, without replacing existing Atlan tags linked to the LookerTile.
     * Note: this operation must make two API calls — one to retrieve the LookerTile's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the LookerTile
     * @param qualifiedName of the LookerTile
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated LookerTile
     */
    public static LookerTile appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerTile) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a LookerTile.
     *
     * @param qualifiedName of the LookerTile
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerTile
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a LookerTile.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a LookerTile
     * @param qualifiedName of the LookerTile
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the LookerTile
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class LookerTileBuilder<C extends LookerTile, B extends LookerTile.LookerTileBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerDashboard dashboard;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILookerField> fields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerLook look;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer lookId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String lookmlLinkId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mergeResultId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String noteText;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILookerQuery query;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer queryID;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer resultMakerID;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String subtitleText;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            LookerTile.LookerTileBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final LookerTile instance, final LookerTile.LookerTileBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboard(instance.dashboard);
            b.fields(instance.fields == null ? java.util.Collections.<ILookerField>emptySortedSet() : instance.fields);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.look(instance.look);
            b.lookId(instance.lookId);
            b.lookmlLinkId(instance.lookmlLinkId);
            b.mergeResultId(instance.mergeResultId);
            b.noteText(instance.noteText);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.query(instance.query);
            b.queryID(instance.queryID);
            b.resultMakerID(instance.resultMakerID);
            b.subtitleText(instance.subtitleText);
        }

        /**
         * Fixed typeName for LookerTiles.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Dashboard in which this tile exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dashboard(final ILookerDashboard dashboard) {
            this.dashboard = dashboard;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B field(final ILookerField field) {
            if (this.fields == null) this.fields = new java.util.ArrayList<ILookerField>();
            this.fields.add(field);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B fields(final java.util.Collection<? extends ILookerField> fields) {
            if (fields == null) {
                throw new java.lang.NullPointerException("fields cannot be null");
            }
            if (this.fields == null) this.fields = new java.util.ArrayList<ILookerField>();
            this.fields.addAll(fields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearFields() {
            if (this.fields != null) this.fields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Look in which this tile exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B look(final ILookerLook look) {
            this.look = look;
            return self();
        }

        /**
         * Identifier of the Look used to create this tile, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookId(final Integer lookId) {
            this.lookId = lookId;
            return self();
        }

        /**
         * Identifier for the LoomML link.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookmlLinkId(final String lookmlLinkId) {
            this.lookmlLinkId = lookmlLinkId;
            return self();
        }

        /**
         * Identifier for the merge result.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mergeResultId(final String mergeResultId) {
            this.mergeResultId = mergeResultId;
            return self();
        }

        /**
         * Text of notes added to the tile.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B noteText(final String noteText) {
            this.noteText = noteText;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B query(final ILookerQuery query) {
            this.query = query;
            return self();
        }

        /**
         * Identifier for the query used to build this tile, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryID(final Integer queryID) {
            this.queryID = queryID;
            return self();
        }

        /**
         * Identifier of the ResultMarkerLookup entry, from Looker.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B resultMakerID(final Integer resultMakerID) {
            this.resultMakerID = resultMakerID;
            return self();
        }

        /**
         * Text for the subtitle for text tiles.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B subtitleText(final String subtitleText) {
            this.subtitleText = subtitleText;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "LookerTile.LookerTileBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboard=" + this.dashboard + ", fields=" + this.fields + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", look=" + this.look + ", lookId=" + this.lookId + ", lookmlLinkId=" + this.lookmlLinkId + ", mergeResultId=" + this.mergeResultId + ", noteText=" + this.noteText + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", query=" + this.query + ", queryID=" + this.queryID + ", resultMakerID=" + this.resultMakerID + ", subtitleText=" + this.subtitleText + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class LookerTileBuilderImpl extends LookerTile.LookerTileBuilder<LookerTile, LookerTile.LookerTileBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LookerTileBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected LookerTile.LookerTileBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public LookerTile build() {
            return new LookerTile(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected LookerTile(final LookerTile.LookerTileBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = LookerTile.$default$typeName();
        this.dashboard = b.dashboard;
        java.util.SortedSet<ILookerField> fields = new java.util.TreeSet<ILookerField>();
        if (b.fields != null) fields.addAll(b.fields);
        fields = java.util.Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.look = b.look;
        this.lookId = b.lookId;
        this.lookmlLinkId = b.lookmlLinkId;
        this.mergeResultId = b.mergeResultId;
        this.noteText = b.noteText;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.query = b.query;
        this.queryID = b.queryID;
        this.resultMakerID = b.resultMakerID;
        this.subtitleText = b.subtitleText;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static LookerTile.LookerTileBuilder<?, ?> _internal() {
        return new LookerTile.LookerTileBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LookerTile.LookerTileBuilder<?, ?> toBuilder() {
        return new LookerTile.LookerTileBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Dashboard in which this tile exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerDashboard getDashboard() {
        return this.dashboard;
    }

    /**
     * Fields that are used in the tile.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILookerField> getFields() {
        return this.fields;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Look in which this tile exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerLook getLook() {
        return this.look;
    }

    /**
     * Identifier of the Look used to create this tile, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getLookId() {
        return this.lookId;
    }

    /**
     * Identifier for the LoomML link.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLookmlLinkId() {
        return this.lookmlLinkId;
    }

    /**
     * Identifier for the merge result.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMergeResultId() {
        return this.mergeResultId;
    }

    /**
     * Text of notes added to the tile.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNoteText() {
        return this.noteText;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILookerQuery getQuery() {
        return this.query;
    }

    /**
     * Identifier for the query used to build this tile, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getQueryID() {
        return this.queryID;
    }

    /**
     * Identifier of the ResultMarkerLookup entry, from Looker.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getResultMakerID() {
        return this.resultMakerID;
    }

    /**
     * Text for the subtitle for text tiles.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSubtitleText() {
        return this.subtitleText;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LookerTile)) return false;
        final LookerTile other = (LookerTile) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$lookId = this.getLookId();
        final java.lang.Object other$lookId = other.getLookId();
        if (this$lookId == null ? other$lookId != null : !this$lookId.equals(other$lookId)) return false;
        final java.lang.Object this$queryID = this.getQueryID();
        final java.lang.Object other$queryID = other.getQueryID();
        if (this$queryID == null ? other$queryID != null : !this$queryID.equals(other$queryID)) return false;
        final java.lang.Object this$resultMakerID = this.getResultMakerID();
        final java.lang.Object other$resultMakerID = other.getResultMakerID();
        if (this$resultMakerID == null ? other$resultMakerID != null : !this$resultMakerID.equals(other$resultMakerID)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dashboard = this.getDashboard();
        final java.lang.Object other$dashboard = other.getDashboard();
        if (this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard)) return false;
        final java.lang.Object this$fields = this.getFields();
        final java.lang.Object other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$look = this.getLook();
        final java.lang.Object other$look = other.getLook();
        if (this$look == null ? other$look != null : !this$look.equals(other$look)) return false;
        final java.lang.Object this$lookmlLinkId = this.getLookmlLinkId();
        final java.lang.Object other$lookmlLinkId = other.getLookmlLinkId();
        if (this$lookmlLinkId == null ? other$lookmlLinkId != null : !this$lookmlLinkId.equals(other$lookmlLinkId)) return false;
        final java.lang.Object this$mergeResultId = this.getMergeResultId();
        final java.lang.Object other$mergeResultId = other.getMergeResultId();
        if (this$mergeResultId == null ? other$mergeResultId != null : !this$mergeResultId.equals(other$mergeResultId)) return false;
        final java.lang.Object this$noteText = this.getNoteText();
        final java.lang.Object other$noteText = other.getNoteText();
        if (this$noteText == null ? other$noteText != null : !this$noteText.equals(other$noteText)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$query = this.getQuery();
        final java.lang.Object other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) return false;
        final java.lang.Object this$subtitleText = this.getSubtitleText();
        final java.lang.Object other$subtitleText = other.getSubtitleText();
        if (this$subtitleText == null ? other$subtitleText != null : !this$subtitleText.equals(other$subtitleText)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LookerTile;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $lookId = this.getLookId();
        result = result * PRIME + ($lookId == null ? 43 : $lookId.hashCode());
        final java.lang.Object $queryID = this.getQueryID();
        result = result * PRIME + ($queryID == null ? 43 : $queryID.hashCode());
        final java.lang.Object $resultMakerID = this.getResultMakerID();
        result = result * PRIME + ($resultMakerID == null ? 43 : $resultMakerID.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dashboard = this.getDashboard();
        result = result * PRIME + ($dashboard == null ? 43 : $dashboard.hashCode());
        final java.lang.Object $fields = this.getFields();
        result = result * PRIME + ($fields == null ? 43 : $fields.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $look = this.getLook();
        result = result * PRIME + ($look == null ? 43 : $look.hashCode());
        final java.lang.Object $lookmlLinkId = this.getLookmlLinkId();
        result = result * PRIME + ($lookmlLinkId == null ? 43 : $lookmlLinkId.hashCode());
        final java.lang.Object $mergeResultId = this.getMergeResultId();
        result = result * PRIME + ($mergeResultId == null ? 43 : $mergeResultId.hashCode());
        final java.lang.Object $noteText = this.getNoteText();
        result = result * PRIME + ($noteText == null ? 43 : $noteText.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $query = this.getQuery();
        result = result * PRIME + ($query == null ? 43 : $query.hashCode());
        final java.lang.Object $subtitleText = this.getSubtitleText();
        result = result * PRIME + ($subtitleText == null ? 43 : $subtitleText.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LookerTile(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboard=" + this.getDashboard() + ", fields=" + this.getFields() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", look=" + this.getLook() + ", lookId=" + this.getLookId() + ", lookmlLinkId=" + this.getLookmlLinkId() + ", mergeResultId=" + this.getMergeResultId() + ", noteText=" + this.getNoteText() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", query=" + this.getQuery() + ", queryID=" + this.getQueryID() + ", resultMakerID=" + this.getResultMakerID() + ", subtitleText=" + this.getSubtitleText() + ")";
    }

    /**
     * Fixed typeName for LookerTiles.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
