// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Monte Carlo incident in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class MCIncident extends Asset implements IMCIncident, IMonteCarlo, IDataQuality, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MCIncident.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MCIncident";
    /**
     * Fixed typeName for MCIncidents.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * List of unique names of assets that are part of this Monte Carlo asset.
     */
    @Attribute
    SortedSet<String> mcAssetQualifiedNames;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAsset> mcIncidentAssets;
    /**
     * Identifier of this incident, from Monte Carlo.
     */
    @Attribute
    String mcIncidentId;
    /**
     * Priority of this incident inherited from monitor.
     */
    @Attribute
    String mcIncidentPriority;
    /**
     * Severity of this incident.
     */
    @Attribute
    String mcIncidentSeverity;
    /**
     * State of this incident.
     */
    @Attribute
    String mcIncidentState;
    /**
     * Subtypes of this incident.
     */
    @Attribute
    SortedSet<String> mcIncidentSubTypes;
    /**
     * Type of this incident.
     */
    @Attribute
    String mcIncidentType;
    /**
     * Name of this incident's warehouse.
     */
    @Attribute
    String mcIncidentWarehouse;
    /**
     * List of labels for this Monte Carlo asset.
     */
    @Attribute
    SortedSet<String> mcLabels;
    /**
     * Monitor in which this incident exists.
     */
    @Attribute
    IMCMonitor mcMonitor;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a MCIncident, from a potentially
     * more-complete MCIncident object.
     *
     * @return the minimal object necessary to relate to the MCIncident
     * @throws InvalidRequestException if any of the minimal set of required properties for a MCIncident relationship are not found in the initial object
     */
    @Override
    public MCIncident trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all MCIncident assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MCIncident assets will be included.
     *
     * @return a fluent search that includes all MCIncident assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all MCIncident assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MCIncident assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all MCIncident assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all MCIncident assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) MCIncidents will be included
     * @return a fluent search that includes all MCIncident assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all MCIncident assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) MCIncidents will be included
     * @return a fluent search that includes all MCIncident assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a MCIncident by GUID. Use this to create a relationship to this MCIncident,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the MCIncident to reference
     * @return reference to a MCIncident that can be used for defining a relationship to a MCIncident
     */
    public static MCIncident refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MCIncident by GUID. Use this to create a relationship to this MCIncident,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the MCIncident to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MCIncident that can be used for defining a relationship to a MCIncident
     */
    public static MCIncident refByGuid(String guid, Reference.SaveSemantic semantic) {
        return MCIncident._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a MCIncident by qualifiedName. Use this to create a relationship to this MCIncident,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the MCIncident to reference
     * @return reference to a MCIncident that can be used for defining a relationship to a MCIncident
     */
    public static MCIncident refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MCIncident by qualifiedName. Use this to create a relationship to this MCIncident,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the MCIncident to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MCIncident that can be used for defining a relationship to a MCIncident
     */
    public static MCIncident refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return MCIncident._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a MCIncident by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the MCIncident to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MCIncident, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MCIncident does not exist or the provided GUID is not a MCIncident
     */
    @JsonIgnore
    public static MCIncident get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a MCIncident by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MCIncident to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MCIncident, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MCIncident does not exist or the provided GUID is not a MCIncident
     */
    @JsonIgnore
    public static MCIncident get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a MCIncident by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MCIncident to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full MCIncident, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MCIncident does not exist or the provided GUID is not a MCIncident
     */
    @JsonIgnore
    public static MCIncident get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof MCIncident) {
                return (MCIncident) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof MCIncident) {
                return (MCIncident) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) MCIncident to active.
     *
     * @param qualifiedName for the MCIncident
     * @return true if the MCIncident is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) MCIncident to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the MCIncident
     * @return true if the MCIncident is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the minimal request necessary to update the MCIncident, as a builder
     */
    public static MCIncidentBuilder<?, ?> updater(String qualifiedName, String name) {
        return MCIncident._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a MCIncident, from a potentially
     * more-complete MCIncident object.
     *
     * @return the minimal object necessary to update the MCIncident, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for MCIncident are not found in the initial object
     */
    @Override
    public MCIncidentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a MCIncident.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a MCIncident.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a MCIncident.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MCIncident's owners
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MCIncident, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a MCIncident.
     *
     * @param client connectivity to the Atlan tenant on which to update the MCIncident's certificate
     * @param qualifiedName of the MCIncident
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MCIncident, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MCIncident) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a MCIncident.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MCIncident's certificate
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a MCIncident.
     *
     * @param client connectivity to the Atlan tenant on which to update the MCIncident's announcement
     * @param qualifiedName of the MCIncident
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MCIncident) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a MCIncident.
     *
     * @param client connectivity to the Atlan client from which to remove the MCIncident's announcement
     * @param qualifiedName of the MCIncident
     * @param name of the MCIncident
     * @return the updated MCIncident, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCIncident) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the MCIncident.
     *
     * @param qualifiedName for the MCIncident
     * @param name human-readable name of the MCIncident
     * @param terms the list of terms to replace on the MCIncident, or null to remove all terms from the MCIncident
     * @return the MCIncident that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MCIncident replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the MCIncident.
     *
     * @param client connectivity to the Atlan tenant on which to replace the MCIncident's assigned terms
     * @param qualifiedName for the MCIncident
     * @param name human-readable name of the MCIncident
     * @param terms the list of terms to replace on the MCIncident, or null to remove all terms from the MCIncident
     * @return the MCIncident that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MCIncident replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCIncident) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the MCIncident, without replacing existing terms linked to the MCIncident.
     * Note: this operation must make two API calls — one to retrieve the MCIncident's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the MCIncident
     * @param terms the list of terms to append to the MCIncident
     * @return the MCIncident that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MCIncident appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the MCIncident, without replacing existing terms linked to the MCIncident.
     * Note: this operation must make two API calls — one to retrieve the MCIncident's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the MCIncident
     * @param qualifiedName for the MCIncident
     * @param terms the list of terms to append to the MCIncident
     * @return the MCIncident that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MCIncident appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCIncident) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a MCIncident, without replacing all existing terms linked to the MCIncident.
     * Note: this operation must make two API calls — one to retrieve the MCIncident's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the MCIncident
     * @param terms the list of terms to remove from the MCIncident, which must be referenced by GUID
     * @return the MCIncident that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a MCIncident, without replacing all existing terms linked to the MCIncident.
     * Note: this operation must make two API calls — one to retrieve the MCIncident's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the MCIncident
     * @param qualifiedName for the MCIncident
     * @param terms the list of terms to remove from the MCIncident, which must be referenced by GUID
     * @return the MCIncident that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MCIncident removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCIncident) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a MCIncident, without replacing existing Atlan tags linked to the MCIncident.
     * Note: this operation must make two API calls — one to retrieve the MCIncident's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MCIncident
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MCIncident
     */
    public static MCIncident appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MCIncident, without replacing existing Atlan tags linked to the MCIncident.
     * Note: this operation must make two API calls — one to retrieve the MCIncident's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MCIncident
     * @param qualifiedName of the MCIncident
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MCIncident
     */
    public static MCIncident appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MCIncident) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MCIncident, without replacing existing Atlan tags linked to the MCIncident.
     * Note: this operation must make two API calls — one to retrieve the MCIncident's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MCIncident
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MCIncident
     */
    public static MCIncident appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a MCIncident, without replacing existing Atlan tags linked to the MCIncident.
     * Note: this operation must make two API calls — one to retrieve the MCIncident's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MCIncident
     * @param qualifiedName of the MCIncident
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MCIncident
     */
    public static MCIncident appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MCIncident) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a MCIncident.
     *
     * @param qualifiedName of the MCIncident
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MCIncident
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a MCIncident.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a MCIncident
     * @param qualifiedName of the MCIncident
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MCIncident
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MCIncidentBuilder<C extends MCIncident, B extends MCIncident.MCIncidentBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> mcAssetQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> mcIncidentAssets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcIncidentId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcIncidentPriority;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcIncidentSeverity;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcIncidentState;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> mcIncidentSubTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcIncidentType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcIncidentWarehouse;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> mcLabels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMCMonitor mcMonitor;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MCIncident.MCIncidentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final MCIncident instance, final MCIncident.MCIncidentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.mcAssetQualifiedNames(instance.mcAssetQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.mcAssetQualifiedNames);
            b.mcIncidentAssets(instance.mcIncidentAssets == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.mcIncidentAssets);
            b.mcIncidentId(instance.mcIncidentId);
            b.mcIncidentPriority(instance.mcIncidentPriority);
            b.mcIncidentSeverity(instance.mcIncidentSeverity);
            b.mcIncidentState(instance.mcIncidentState);
            b.mcIncidentSubTypes(instance.mcIncidentSubTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.mcIncidentSubTypes);
            b.mcIncidentType(instance.mcIncidentType);
            b.mcIncidentWarehouse(instance.mcIncidentWarehouse);
            b.mcLabels(instance.mcLabels == null ? java.util.Collections.<String>emptySortedSet() : instance.mcLabels);
            b.mcMonitor(instance.mcMonitor);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for MCIncidents.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcAssetQualifiedName(final String mcAssetQualifiedName) {
            if (this.mcAssetQualifiedNames == null) this.mcAssetQualifiedNames = new java.util.ArrayList<String>();
            this.mcAssetQualifiedNames.add(mcAssetQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcAssetQualifiedNames(final java.util.Collection<? extends String> mcAssetQualifiedNames) {
            if (mcAssetQualifiedNames == null) {
                throw new java.lang.NullPointerException("mcAssetQualifiedNames cannot be null");
            }
            if (this.mcAssetQualifiedNames == null) this.mcAssetQualifiedNames = new java.util.ArrayList<String>();
            this.mcAssetQualifiedNames.addAll(mcAssetQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcAssetQualifiedNames() {
            if (this.mcAssetQualifiedNames != null) this.mcAssetQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentAsset(final IAsset mcIncidentAsset) {
            if (this.mcIncidentAssets == null) this.mcIncidentAssets = new java.util.ArrayList<IAsset>();
            this.mcIncidentAssets.add(mcIncidentAsset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentAssets(final java.util.Collection<? extends IAsset> mcIncidentAssets) {
            if (mcIncidentAssets == null) {
                throw new java.lang.NullPointerException("mcIncidentAssets cannot be null");
            }
            if (this.mcIncidentAssets == null) this.mcIncidentAssets = new java.util.ArrayList<IAsset>();
            this.mcIncidentAssets.addAll(mcIncidentAssets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcIncidentAssets() {
            if (this.mcIncidentAssets != null) this.mcIncidentAssets.clear();
            return self();
        }

        /**
         * Identifier of this incident, from Monte Carlo.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentId(final String mcIncidentId) {
            this.mcIncidentId = mcIncidentId;
            return self();
        }

        /**
         * Priority of this incident inherited from monitor.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentPriority(final String mcIncidentPriority) {
            this.mcIncidentPriority = mcIncidentPriority;
            return self();
        }

        /**
         * Severity of this incident.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentSeverity(final String mcIncidentSeverity) {
            this.mcIncidentSeverity = mcIncidentSeverity;
            return self();
        }

        /**
         * State of this incident.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentState(final String mcIncidentState) {
            this.mcIncidentState = mcIncidentState;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentSubType(final String mcIncidentSubType) {
            if (this.mcIncidentSubTypes == null) this.mcIncidentSubTypes = new java.util.ArrayList<String>();
            this.mcIncidentSubTypes.add(mcIncidentSubType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentSubTypes(final java.util.Collection<? extends String> mcIncidentSubTypes) {
            if (mcIncidentSubTypes == null) {
                throw new java.lang.NullPointerException("mcIncidentSubTypes cannot be null");
            }
            if (this.mcIncidentSubTypes == null) this.mcIncidentSubTypes = new java.util.ArrayList<String>();
            this.mcIncidentSubTypes.addAll(mcIncidentSubTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcIncidentSubTypes() {
            if (this.mcIncidentSubTypes != null) this.mcIncidentSubTypes.clear();
            return self();
        }

        /**
         * Type of this incident.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentType(final String mcIncidentType) {
            this.mcIncidentType = mcIncidentType;
            return self();
        }

        /**
         * Name of this incident's warehouse.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcIncidentWarehouse(final String mcIncidentWarehouse) {
            this.mcIncidentWarehouse = mcIncidentWarehouse;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcLabel(final String mcLabel) {
            if (this.mcLabels == null) this.mcLabels = new java.util.ArrayList<String>();
            this.mcLabels.add(mcLabel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcLabels(final java.util.Collection<? extends String> mcLabels) {
            if (mcLabels == null) {
                throw new java.lang.NullPointerException("mcLabels cannot be null");
            }
            if (this.mcLabels == null) this.mcLabels = new java.util.ArrayList<String>();
            this.mcLabels.addAll(mcLabels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcLabels() {
            if (this.mcLabels != null) this.mcLabels.clear();
            return self();
        }

        /**
         * Monitor in which this incident exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitor(final IMCMonitor mcMonitor) {
            this.mcMonitor = mcMonitor;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "MCIncident.MCIncidentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", mcAssetQualifiedNames=" + this.mcAssetQualifiedNames + ", mcIncidentAssets=" + this.mcIncidentAssets + ", mcIncidentId=" + this.mcIncidentId + ", mcIncidentPriority=" + this.mcIncidentPriority + ", mcIncidentSeverity=" + this.mcIncidentSeverity + ", mcIncidentState=" + this.mcIncidentState + ", mcIncidentSubTypes=" + this.mcIncidentSubTypes + ", mcIncidentType=" + this.mcIncidentType + ", mcIncidentWarehouse=" + this.mcIncidentWarehouse + ", mcLabels=" + this.mcLabels + ", mcMonitor=" + this.mcMonitor + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class MCIncidentBuilderImpl extends MCIncident.MCIncidentBuilder<MCIncident, MCIncident.MCIncidentBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MCIncidentBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected MCIncident.MCIncidentBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public MCIncident build() {
            return new MCIncident(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected MCIncident(final MCIncident.MCIncidentBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = MCIncident.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<String> mcAssetQualifiedNames = new java.util.TreeSet<String>();
        if (b.mcAssetQualifiedNames != null) mcAssetQualifiedNames.addAll(b.mcAssetQualifiedNames);
        mcAssetQualifiedNames = java.util.Collections.unmodifiableSortedSet(mcAssetQualifiedNames);
        this.mcAssetQualifiedNames = mcAssetQualifiedNames;
        java.util.SortedSet<IAsset> mcIncidentAssets = new java.util.TreeSet<IAsset>();
        if (b.mcIncidentAssets != null) mcIncidentAssets.addAll(b.mcIncidentAssets);
        mcIncidentAssets = java.util.Collections.unmodifiableSortedSet(mcIncidentAssets);
        this.mcIncidentAssets = mcIncidentAssets;
        this.mcIncidentId = b.mcIncidentId;
        this.mcIncidentPriority = b.mcIncidentPriority;
        this.mcIncidentSeverity = b.mcIncidentSeverity;
        this.mcIncidentState = b.mcIncidentState;
        java.util.SortedSet<String> mcIncidentSubTypes = new java.util.TreeSet<String>();
        if (b.mcIncidentSubTypes != null) mcIncidentSubTypes.addAll(b.mcIncidentSubTypes);
        mcIncidentSubTypes = java.util.Collections.unmodifiableSortedSet(mcIncidentSubTypes);
        this.mcIncidentSubTypes = mcIncidentSubTypes;
        this.mcIncidentType = b.mcIncidentType;
        this.mcIncidentWarehouse = b.mcIncidentWarehouse;
        java.util.SortedSet<String> mcLabels = new java.util.TreeSet<String>();
        if (b.mcLabels != null) mcLabels.addAll(b.mcLabels);
        mcLabels = java.util.Collections.unmodifiableSortedSet(mcLabels);
        this.mcLabels = mcLabels;
        this.mcMonitor = b.mcMonitor;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static MCIncident.MCIncidentBuilder<?, ?> _internal() {
        return new MCIncident.MCIncidentBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MCIncident.MCIncidentBuilder<?, ?> toBuilder() {
        return new MCIncident.MCIncidentBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * List of unique names of assets that are part of this Monte Carlo asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMcAssetQualifiedNames() {
        return this.mcAssetQualifiedNames;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getMcIncidentAssets() {
        return this.mcIncidentAssets;
    }

    /**
     * Identifier of this incident, from Monte Carlo.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcIncidentId() {
        return this.mcIncidentId;
    }

    /**
     * Priority of this incident inherited from monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcIncidentPriority() {
        return this.mcIncidentPriority;
    }

    /**
     * Severity of this incident.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcIncidentSeverity() {
        return this.mcIncidentSeverity;
    }

    /**
     * State of this incident.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcIncidentState() {
        return this.mcIncidentState;
    }

    /**
     * Subtypes of this incident.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMcIncidentSubTypes() {
        return this.mcIncidentSubTypes;
    }

    /**
     * Type of this incident.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcIncidentType() {
        return this.mcIncidentType;
    }

    /**
     * Name of this incident's warehouse.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcIncidentWarehouse() {
        return this.mcIncidentWarehouse;
    }

    /**
     * List of labels for this Monte Carlo asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMcLabels() {
        return this.mcLabels;
    }

    /**
     * Monitor in which this incident exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMCMonitor getMcMonitor() {
        return this.mcMonitor;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MCIncident)) return false;
        final MCIncident other = (MCIncident) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$mcAssetQualifiedNames = this.getMcAssetQualifiedNames();
        final java.lang.Object other$mcAssetQualifiedNames = other.getMcAssetQualifiedNames();
        if (this$mcAssetQualifiedNames == null ? other$mcAssetQualifiedNames != null : !this$mcAssetQualifiedNames.equals(other$mcAssetQualifiedNames)) return false;
        final java.lang.Object this$mcIncidentAssets = this.getMcIncidentAssets();
        final java.lang.Object other$mcIncidentAssets = other.getMcIncidentAssets();
        if (this$mcIncidentAssets == null ? other$mcIncidentAssets != null : !this$mcIncidentAssets.equals(other$mcIncidentAssets)) return false;
        final java.lang.Object this$mcIncidentId = this.getMcIncidentId();
        final java.lang.Object other$mcIncidentId = other.getMcIncidentId();
        if (this$mcIncidentId == null ? other$mcIncidentId != null : !this$mcIncidentId.equals(other$mcIncidentId)) return false;
        final java.lang.Object this$mcIncidentPriority = this.getMcIncidentPriority();
        final java.lang.Object other$mcIncidentPriority = other.getMcIncidentPriority();
        if (this$mcIncidentPriority == null ? other$mcIncidentPriority != null : !this$mcIncidentPriority.equals(other$mcIncidentPriority)) return false;
        final java.lang.Object this$mcIncidentSeverity = this.getMcIncidentSeverity();
        final java.lang.Object other$mcIncidentSeverity = other.getMcIncidentSeverity();
        if (this$mcIncidentSeverity == null ? other$mcIncidentSeverity != null : !this$mcIncidentSeverity.equals(other$mcIncidentSeverity)) return false;
        final java.lang.Object this$mcIncidentState = this.getMcIncidentState();
        final java.lang.Object other$mcIncidentState = other.getMcIncidentState();
        if (this$mcIncidentState == null ? other$mcIncidentState != null : !this$mcIncidentState.equals(other$mcIncidentState)) return false;
        final java.lang.Object this$mcIncidentSubTypes = this.getMcIncidentSubTypes();
        final java.lang.Object other$mcIncidentSubTypes = other.getMcIncidentSubTypes();
        if (this$mcIncidentSubTypes == null ? other$mcIncidentSubTypes != null : !this$mcIncidentSubTypes.equals(other$mcIncidentSubTypes)) return false;
        final java.lang.Object this$mcIncidentType = this.getMcIncidentType();
        final java.lang.Object other$mcIncidentType = other.getMcIncidentType();
        if (this$mcIncidentType == null ? other$mcIncidentType != null : !this$mcIncidentType.equals(other$mcIncidentType)) return false;
        final java.lang.Object this$mcIncidentWarehouse = this.getMcIncidentWarehouse();
        final java.lang.Object other$mcIncidentWarehouse = other.getMcIncidentWarehouse();
        if (this$mcIncidentWarehouse == null ? other$mcIncidentWarehouse != null : !this$mcIncidentWarehouse.equals(other$mcIncidentWarehouse)) return false;
        final java.lang.Object this$mcLabels = this.getMcLabels();
        final java.lang.Object other$mcLabels = other.getMcLabels();
        if (this$mcLabels == null ? other$mcLabels != null : !this$mcLabels.equals(other$mcLabels)) return false;
        final java.lang.Object this$mcMonitor = this.getMcMonitor();
        final java.lang.Object other$mcMonitor = other.getMcMonitor();
        if (this$mcMonitor == null ? other$mcMonitor != null : !this$mcMonitor.equals(other$mcMonitor)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MCIncident;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $mcAssetQualifiedNames = this.getMcAssetQualifiedNames();
        result = result * PRIME + ($mcAssetQualifiedNames == null ? 43 : $mcAssetQualifiedNames.hashCode());
        final java.lang.Object $mcIncidentAssets = this.getMcIncidentAssets();
        result = result * PRIME + ($mcIncidentAssets == null ? 43 : $mcIncidentAssets.hashCode());
        final java.lang.Object $mcIncidentId = this.getMcIncidentId();
        result = result * PRIME + ($mcIncidentId == null ? 43 : $mcIncidentId.hashCode());
        final java.lang.Object $mcIncidentPriority = this.getMcIncidentPriority();
        result = result * PRIME + ($mcIncidentPriority == null ? 43 : $mcIncidentPriority.hashCode());
        final java.lang.Object $mcIncidentSeverity = this.getMcIncidentSeverity();
        result = result * PRIME + ($mcIncidentSeverity == null ? 43 : $mcIncidentSeverity.hashCode());
        final java.lang.Object $mcIncidentState = this.getMcIncidentState();
        result = result * PRIME + ($mcIncidentState == null ? 43 : $mcIncidentState.hashCode());
        final java.lang.Object $mcIncidentSubTypes = this.getMcIncidentSubTypes();
        result = result * PRIME + ($mcIncidentSubTypes == null ? 43 : $mcIncidentSubTypes.hashCode());
        final java.lang.Object $mcIncidentType = this.getMcIncidentType();
        result = result * PRIME + ($mcIncidentType == null ? 43 : $mcIncidentType.hashCode());
        final java.lang.Object $mcIncidentWarehouse = this.getMcIncidentWarehouse();
        result = result * PRIME + ($mcIncidentWarehouse == null ? 43 : $mcIncidentWarehouse.hashCode());
        final java.lang.Object $mcLabels = this.getMcLabels();
        result = result * PRIME + ($mcLabels == null ? 43 : $mcLabels.hashCode());
        final java.lang.Object $mcMonitor = this.getMcMonitor();
        result = result * PRIME + ($mcMonitor == null ? 43 : $mcMonitor.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MCIncident(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", mcAssetQualifiedNames=" + this.getMcAssetQualifiedNames() + ", mcIncidentAssets=" + this.getMcIncidentAssets() + ", mcIncidentId=" + this.getMcIncidentId() + ", mcIncidentPriority=" + this.getMcIncidentPriority() + ", mcIncidentSeverity=" + this.getMcIncidentSeverity() + ", mcIncidentState=" + this.getMcIncidentState() + ", mcIncidentSubTypes=" + this.getMcIncidentSubTypes() + ", mcIncidentType=" + this.getMcIncidentType() + ", mcIncidentWarehouse=" + this.getMcIncidentWarehouse() + ", mcLabels=" + this.getMcLabels() + ", mcMonitor=" + this.getMcMonitor() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for MCIncidents.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
