// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.MCRuleComparison;
import com.atlan.model.structs.MCRuleSchedule;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Monte Carlo monitor in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class MCMonitor extends Asset implements IMCMonitor, IMonteCarlo, IDataQuality, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MCMonitor.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MCMonitor";
    /**
     * Fixed typeName for MCMonitors.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * List of unique names of assets that are part of this Monte Carlo asset.
     */
    @Attribute
    SortedSet<String> mcAssetQualifiedNames;
    /**
     * List of labels for this Monte Carlo asset.
     */
    @Attribute
    SortedSet<String> mcLabels;
    /**
     * Condition on which the monitor produces an alert.
     */
    @Attribute
    String mcMonitorAlertCondition;
    /**
     * Number of alerts associated with this monitor.
     */
    @Attribute
    Long mcMonitorAlertCount;
    /**
     * Assets impacted by this monitor.
     */
    @Attribute
    SortedSet<IAsset> mcMonitorAssets;
    /**
     * Rate at which this monitor is breached.
     */
    @Attribute
    Double mcMonitorBreachRate;
    /**
     * Unique identifier for this monitor, from Monte Carlo.
     */
    @Attribute
    String mcMonitorId;
    /**
     * Number of incidents associated with this monitor.
     */
    @Attribute
    Long mcMonitorIncidentCount;
    /**
     * Namespace of this monitor.
     */
    @Attribute
    String mcMonitorNamespace;
    /**
     * Priority of this monitor.
     */
    @Attribute
    String mcMonitorPriority;
    /**
     * Comparison logic used for the rule.
     */
    @Attribute
    List<MCRuleComparison> mcMonitorRuleComparisons;
    /**
     * SQL code for custom SQL rules.
     */
    @Attribute
    String mcMonitorRuleCustomSql;
    /**
     * Whether the rule is currently snoozed (true) or not (false).
     */
    @Attribute
    Boolean mcMonitorRuleIsSnoozed;
    /**
     * Time at which the next execution of the rule should occur.
     */
    @Attribute
    @Date
    Long mcMonitorRuleNextExecutionTime;
    /**
     * Time at which the previous execution of the rule occurred.
     */
    @Attribute
    @Date
    Long mcMonitorRulePreviousExecutionTime;
    /**
     * Schedule details for the rule.
     */
    @Attribute
    MCRuleSchedule mcMonitorRuleScheduleConfig;
    /**
     * Readable description of the schedule for the rule.
     */
    @Attribute
    String mcMonitorRuleScheduleConfigHumanized;
    /**
     * Type of rule for this monitor.
     */
    @Attribute
    String mcMonitorRuleType;
    /**
     * Type of schedule for this monitor, for example: fixed or dynamic.
     */
    @Attribute
    String mcMonitorScheduleType;
    /**
     * Status of this monitor.
     */
    @Attribute
    String mcMonitorStatus;
    /**
     * Type of this monitor, for example: field health (stats) or dimension tracking (categories).
     */
    @Attribute
    String mcMonitorType;
    /**
     * Name of the warehouse for this monitor.
     */
    @Attribute
    String mcMonitorWarehouse;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a MCMonitor, from a potentially
     * more-complete MCMonitor object.
     *
     * @return the minimal object necessary to relate to the MCMonitor
     * @throws InvalidRequestException if any of the minimal set of required properties for a MCMonitor relationship are not found in the initial object
     */
    @Override
    public MCMonitor trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all MCMonitor assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MCMonitor assets will be included.
     *
     * @return a fluent search that includes all MCMonitor assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all MCMonitor assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MCMonitor assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all MCMonitor assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all MCMonitor assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) MCMonitors will be included
     * @return a fluent search that includes all MCMonitor assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all MCMonitor assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) MCMonitors will be included
     * @return a fluent search that includes all MCMonitor assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a MCMonitor by GUID. Use this to create a relationship to this MCMonitor,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the MCMonitor to reference
     * @return reference to a MCMonitor that can be used for defining a relationship to a MCMonitor
     */
    public static MCMonitor refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MCMonitor by GUID. Use this to create a relationship to this MCMonitor,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the MCMonitor to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MCMonitor that can be used for defining a relationship to a MCMonitor
     */
    public static MCMonitor refByGuid(String guid, Reference.SaveSemantic semantic) {
        return MCMonitor._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a MCMonitor by qualifiedName. Use this to create a relationship to this MCMonitor,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the MCMonitor to reference
     * @return reference to a MCMonitor that can be used for defining a relationship to a MCMonitor
     */
    public static MCMonitor refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MCMonitor by qualifiedName. Use this to create a relationship to this MCMonitor,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the MCMonitor to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MCMonitor that can be used for defining a relationship to a MCMonitor
     */
    public static MCMonitor refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return MCMonitor._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a MCMonitor by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the MCMonitor to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MCMonitor, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MCMonitor does not exist or the provided GUID is not a MCMonitor
     */
    @JsonIgnore
    public static MCMonitor get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a MCMonitor by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MCMonitor to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MCMonitor, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MCMonitor does not exist or the provided GUID is not a MCMonitor
     */
    @JsonIgnore
    public static MCMonitor get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a MCMonitor by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MCMonitor to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full MCMonitor, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MCMonitor does not exist or the provided GUID is not a MCMonitor
     */
    @JsonIgnore
    public static MCMonitor get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof MCMonitor) {
                return (MCMonitor) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof MCMonitor) {
                return (MCMonitor) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) MCMonitor to active.
     *
     * @param qualifiedName for the MCMonitor
     * @return true if the MCMonitor is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) MCMonitor to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the MCMonitor
     * @return true if the MCMonitor is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the minimal request necessary to update the MCMonitor, as a builder
     */
    public static MCMonitorBuilder<?, ?> updater(String qualifiedName, String name) {
        return MCMonitor._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a MCMonitor, from a potentially
     * more-complete MCMonitor object.
     *
     * @return the minimal object necessary to update the MCMonitor, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for MCMonitor are not found in the initial object
     */
    @Override
    public MCMonitorBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a MCMonitor.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a MCMonitor.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a MCMonitor.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MCMonitor's owners
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MCMonitor, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a MCMonitor.
     *
     * @param client connectivity to the Atlan tenant on which to update the MCMonitor's certificate
     * @param qualifiedName of the MCMonitor
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MCMonitor, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MCMonitor) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a MCMonitor.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MCMonitor's certificate
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a MCMonitor.
     *
     * @param client connectivity to the Atlan tenant on which to update the MCMonitor's announcement
     * @param qualifiedName of the MCMonitor
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MCMonitor) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a MCMonitor.
     *
     * @param client connectivity to the Atlan client from which to remove the MCMonitor's announcement
     * @param qualifiedName of the MCMonitor
     * @param name of the MCMonitor
     * @return the updated MCMonitor, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MCMonitor) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the MCMonitor.
     *
     * @param qualifiedName for the MCMonitor
     * @param name human-readable name of the MCMonitor
     * @param terms the list of terms to replace on the MCMonitor, or null to remove all terms from the MCMonitor
     * @return the MCMonitor that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MCMonitor replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the MCMonitor.
     *
     * @param client connectivity to the Atlan tenant on which to replace the MCMonitor's assigned terms
     * @param qualifiedName for the MCMonitor
     * @param name human-readable name of the MCMonitor
     * @param terms the list of terms to replace on the MCMonitor, or null to remove all terms from the MCMonitor
     * @return the MCMonitor that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MCMonitor replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCMonitor) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the MCMonitor, without replacing existing terms linked to the MCMonitor.
     * Note: this operation must make two API calls — one to retrieve the MCMonitor's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the MCMonitor
     * @param terms the list of terms to append to the MCMonitor
     * @return the MCMonitor that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MCMonitor appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the MCMonitor, without replacing existing terms linked to the MCMonitor.
     * Note: this operation must make two API calls — one to retrieve the MCMonitor's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the MCMonitor
     * @param qualifiedName for the MCMonitor
     * @param terms the list of terms to append to the MCMonitor
     * @return the MCMonitor that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MCMonitor appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCMonitor) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a MCMonitor, without replacing all existing terms linked to the MCMonitor.
     * Note: this operation must make two API calls — one to retrieve the MCMonitor's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the MCMonitor
     * @param terms the list of terms to remove from the MCMonitor, which must be referenced by GUID
     * @return the MCMonitor that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a MCMonitor, without replacing all existing terms linked to the MCMonitor.
     * Note: this operation must make two API calls — one to retrieve the MCMonitor's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the MCMonitor
     * @param qualifiedName for the MCMonitor
     * @param terms the list of terms to remove from the MCMonitor, which must be referenced by GUID
     * @return the MCMonitor that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MCMonitor removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MCMonitor) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a MCMonitor, without replacing existing Atlan tags linked to the MCMonitor.
     * Note: this operation must make two API calls — one to retrieve the MCMonitor's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MCMonitor
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MCMonitor
     */
    public static MCMonitor appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MCMonitor, without replacing existing Atlan tags linked to the MCMonitor.
     * Note: this operation must make two API calls — one to retrieve the MCMonitor's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MCMonitor
     * @param qualifiedName of the MCMonitor
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MCMonitor
     */
    public static MCMonitor appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MCMonitor) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MCMonitor, without replacing existing Atlan tags linked to the MCMonitor.
     * Note: this operation must make two API calls — one to retrieve the MCMonitor's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MCMonitor
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MCMonitor
     */
    public static MCMonitor appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a MCMonitor, without replacing existing Atlan tags linked to the MCMonitor.
     * Note: this operation must make two API calls — one to retrieve the MCMonitor's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MCMonitor
     * @param qualifiedName of the MCMonitor
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MCMonitor
     */
    public static MCMonitor appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MCMonitor) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a MCMonitor.
     *
     * @param qualifiedName of the MCMonitor
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MCMonitor
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a MCMonitor.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a MCMonitor
     * @param qualifiedName of the MCMonitor
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MCMonitor
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MCMonitorBuilder<C extends MCMonitor, B extends MCMonitor.MCMonitorBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> mcAssetQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> mcLabels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorAlertCondition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long mcMonitorAlertCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> mcMonitorAssets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double mcMonitorBreachRate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long mcMonitorIncidentCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorNamespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorPriority;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<MCRuleComparison> mcMonitorRuleComparisons;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorRuleCustomSql;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean mcMonitorRuleIsSnoozed;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long mcMonitorRuleNextExecutionTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long mcMonitorRulePreviousExecutionTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MCRuleSchedule mcMonitorRuleScheduleConfig;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorRuleScheduleConfigHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorRuleType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorScheduleType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String mcMonitorWarehouse;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MCMonitor.MCMonitorBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final MCMonitor instance, final MCMonitor.MCMonitorBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.mcAssetQualifiedNames(instance.mcAssetQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.mcAssetQualifiedNames);
            b.mcLabels(instance.mcLabels == null ? java.util.Collections.<String>emptySortedSet() : instance.mcLabels);
            b.mcMonitorAlertCondition(instance.mcMonitorAlertCondition);
            b.mcMonitorAlertCount(instance.mcMonitorAlertCount);
            b.mcMonitorAssets(instance.mcMonitorAssets == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.mcMonitorAssets);
            b.mcMonitorBreachRate(instance.mcMonitorBreachRate);
            b.mcMonitorId(instance.mcMonitorId);
            b.mcMonitorIncidentCount(instance.mcMonitorIncidentCount);
            b.mcMonitorNamespace(instance.mcMonitorNamespace);
            b.mcMonitorPriority(instance.mcMonitorPriority);
            b.mcMonitorRuleComparisons(instance.mcMonitorRuleComparisons == null ? java.util.Collections.<MCRuleComparison>emptyList() : instance.mcMonitorRuleComparisons);
            b.mcMonitorRuleCustomSql(instance.mcMonitorRuleCustomSql);
            b.mcMonitorRuleIsSnoozed(instance.mcMonitorRuleIsSnoozed);
            b.mcMonitorRuleNextExecutionTime(instance.mcMonitorRuleNextExecutionTime);
            b.mcMonitorRulePreviousExecutionTime(instance.mcMonitorRulePreviousExecutionTime);
            b.mcMonitorRuleScheduleConfig(instance.mcMonitorRuleScheduleConfig);
            b.mcMonitorRuleScheduleConfigHumanized(instance.mcMonitorRuleScheduleConfigHumanized);
            b.mcMonitorRuleType(instance.mcMonitorRuleType);
            b.mcMonitorScheduleType(instance.mcMonitorScheduleType);
            b.mcMonitorStatus(instance.mcMonitorStatus);
            b.mcMonitorType(instance.mcMonitorType);
            b.mcMonitorWarehouse(instance.mcMonitorWarehouse);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for MCMonitors.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcAssetQualifiedName(final String mcAssetQualifiedName) {
            if (this.mcAssetQualifiedNames == null) this.mcAssetQualifiedNames = new java.util.ArrayList<String>();
            this.mcAssetQualifiedNames.add(mcAssetQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcAssetQualifiedNames(final java.util.Collection<? extends String> mcAssetQualifiedNames) {
            if (mcAssetQualifiedNames == null) {
                throw new java.lang.NullPointerException("mcAssetQualifiedNames cannot be null");
            }
            if (this.mcAssetQualifiedNames == null) this.mcAssetQualifiedNames = new java.util.ArrayList<String>();
            this.mcAssetQualifiedNames.addAll(mcAssetQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcAssetQualifiedNames() {
            if (this.mcAssetQualifiedNames != null) this.mcAssetQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcLabel(final String mcLabel) {
            if (this.mcLabels == null) this.mcLabels = new java.util.ArrayList<String>();
            this.mcLabels.add(mcLabel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcLabels(final java.util.Collection<? extends String> mcLabels) {
            if (mcLabels == null) {
                throw new java.lang.NullPointerException("mcLabels cannot be null");
            }
            if (this.mcLabels == null) this.mcLabels = new java.util.ArrayList<String>();
            this.mcLabels.addAll(mcLabels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcLabels() {
            if (this.mcLabels != null) this.mcLabels.clear();
            return self();
        }

        /**
         * Condition on which the monitor produces an alert.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorAlertCondition(final String mcMonitorAlertCondition) {
            this.mcMonitorAlertCondition = mcMonitorAlertCondition;
            return self();
        }

        /**
         * Number of alerts associated with this monitor.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorAlertCount(final Long mcMonitorAlertCount) {
            this.mcMonitorAlertCount = mcMonitorAlertCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorAsset(final IAsset mcMonitorAsset) {
            if (this.mcMonitorAssets == null) this.mcMonitorAssets = new java.util.ArrayList<IAsset>();
            this.mcMonitorAssets.add(mcMonitorAsset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorAssets(final java.util.Collection<? extends IAsset> mcMonitorAssets) {
            if (mcMonitorAssets == null) {
                throw new java.lang.NullPointerException("mcMonitorAssets cannot be null");
            }
            if (this.mcMonitorAssets == null) this.mcMonitorAssets = new java.util.ArrayList<IAsset>();
            this.mcMonitorAssets.addAll(mcMonitorAssets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcMonitorAssets() {
            if (this.mcMonitorAssets != null) this.mcMonitorAssets.clear();
            return self();
        }

        /**
         * Rate at which this monitor is breached.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorBreachRate(final Double mcMonitorBreachRate) {
            this.mcMonitorBreachRate = mcMonitorBreachRate;
            return self();
        }

        /**
         * Unique identifier for this monitor, from Monte Carlo.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorId(final String mcMonitorId) {
            this.mcMonitorId = mcMonitorId;
            return self();
        }

        /**
         * Number of incidents associated with this monitor.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorIncidentCount(final Long mcMonitorIncidentCount) {
            this.mcMonitorIncidentCount = mcMonitorIncidentCount;
            return self();
        }

        /**
         * Namespace of this monitor.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorNamespace(final String mcMonitorNamespace) {
            this.mcMonitorNamespace = mcMonitorNamespace;
            return self();
        }

        /**
         * Priority of this monitor.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorPriority(final String mcMonitorPriority) {
            this.mcMonitorPriority = mcMonitorPriority;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRuleComparison(final MCRuleComparison mcMonitorRuleComparison) {
            if (this.mcMonitorRuleComparisons == null) this.mcMonitorRuleComparisons = new java.util.ArrayList<MCRuleComparison>();
            this.mcMonitorRuleComparisons.add(mcMonitorRuleComparison);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRuleComparisons(final java.util.Collection<? extends MCRuleComparison> mcMonitorRuleComparisons) {
            if (mcMonitorRuleComparisons == null) {
                throw new java.lang.NullPointerException("mcMonitorRuleComparisons cannot be null");
            }
            if (this.mcMonitorRuleComparisons == null) this.mcMonitorRuleComparisons = new java.util.ArrayList<MCRuleComparison>();
            this.mcMonitorRuleComparisons.addAll(mcMonitorRuleComparisons);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMcMonitorRuleComparisons() {
            if (this.mcMonitorRuleComparisons != null) this.mcMonitorRuleComparisons.clear();
            return self();
        }

        /**
         * SQL code for custom SQL rules.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRuleCustomSql(final String mcMonitorRuleCustomSql) {
            this.mcMonitorRuleCustomSql = mcMonitorRuleCustomSql;
            return self();
        }

        /**
         * Whether the rule is currently snoozed (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRuleIsSnoozed(final Boolean mcMonitorRuleIsSnoozed) {
            this.mcMonitorRuleIsSnoozed = mcMonitorRuleIsSnoozed;
            return self();
        }

        /**
         * Time at which the next execution of the rule should occur.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRuleNextExecutionTime(final Long mcMonitorRuleNextExecutionTime) {
            this.mcMonitorRuleNextExecutionTime = mcMonitorRuleNextExecutionTime;
            return self();
        }

        /**
         * Time at which the previous execution of the rule occurred.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRulePreviousExecutionTime(final Long mcMonitorRulePreviousExecutionTime) {
            this.mcMonitorRulePreviousExecutionTime = mcMonitorRulePreviousExecutionTime;
            return self();
        }

        /**
         * Schedule details for the rule.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRuleScheduleConfig(final MCRuleSchedule mcMonitorRuleScheduleConfig) {
            this.mcMonitorRuleScheduleConfig = mcMonitorRuleScheduleConfig;
            return self();
        }

        /**
         * Readable description of the schedule for the rule.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRuleScheduleConfigHumanized(final String mcMonitorRuleScheduleConfigHumanized) {
            this.mcMonitorRuleScheduleConfigHumanized = mcMonitorRuleScheduleConfigHumanized;
            return self();
        }

        /**
         * Type of rule for this monitor.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorRuleType(final String mcMonitorRuleType) {
            this.mcMonitorRuleType = mcMonitorRuleType;
            return self();
        }

        /**
         * Type of schedule for this monitor, for example: fixed or dynamic.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorScheduleType(final String mcMonitorScheduleType) {
            this.mcMonitorScheduleType = mcMonitorScheduleType;
            return self();
        }

        /**
         * Status of this monitor.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorStatus(final String mcMonitorStatus) {
            this.mcMonitorStatus = mcMonitorStatus;
            return self();
        }

        /**
         * Type of this monitor, for example: field health (stats) or dimension tracking (categories).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorType(final String mcMonitorType) {
            this.mcMonitorType = mcMonitorType;
            return self();
        }

        /**
         * Name of the warehouse for this monitor.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B mcMonitorWarehouse(final String mcMonitorWarehouse) {
            this.mcMonitorWarehouse = mcMonitorWarehouse;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "MCMonitor.MCMonitorBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", mcAssetQualifiedNames=" + this.mcAssetQualifiedNames + ", mcLabels=" + this.mcLabels + ", mcMonitorAlertCondition=" + this.mcMonitorAlertCondition + ", mcMonitorAlertCount=" + this.mcMonitorAlertCount + ", mcMonitorAssets=" + this.mcMonitorAssets + ", mcMonitorBreachRate=" + this.mcMonitorBreachRate + ", mcMonitorId=" + this.mcMonitorId + ", mcMonitorIncidentCount=" + this.mcMonitorIncidentCount + ", mcMonitorNamespace=" + this.mcMonitorNamespace + ", mcMonitorPriority=" + this.mcMonitorPriority + ", mcMonitorRuleComparisons=" + this.mcMonitorRuleComparisons + ", mcMonitorRuleCustomSql=" + this.mcMonitorRuleCustomSql + ", mcMonitorRuleIsSnoozed=" + this.mcMonitorRuleIsSnoozed + ", mcMonitorRuleNextExecutionTime=" + this.mcMonitorRuleNextExecutionTime + ", mcMonitorRulePreviousExecutionTime=" + this.mcMonitorRulePreviousExecutionTime + ", mcMonitorRuleScheduleConfig=" + this.mcMonitorRuleScheduleConfig + ", mcMonitorRuleScheduleConfigHumanized=" + this.mcMonitorRuleScheduleConfigHumanized + ", mcMonitorRuleType=" + this.mcMonitorRuleType + ", mcMonitorScheduleType=" + this.mcMonitorScheduleType + ", mcMonitorStatus=" + this.mcMonitorStatus + ", mcMonitorType=" + this.mcMonitorType + ", mcMonitorWarehouse=" + this.mcMonitorWarehouse + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class MCMonitorBuilderImpl extends MCMonitor.MCMonitorBuilder<MCMonitor, MCMonitor.MCMonitorBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MCMonitorBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected MCMonitor.MCMonitorBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public MCMonitor build() {
            return new MCMonitor(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected MCMonitor(final MCMonitor.MCMonitorBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = MCMonitor.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<String> mcAssetQualifiedNames = new java.util.TreeSet<String>();
        if (b.mcAssetQualifiedNames != null) mcAssetQualifiedNames.addAll(b.mcAssetQualifiedNames);
        mcAssetQualifiedNames = java.util.Collections.unmodifiableSortedSet(mcAssetQualifiedNames);
        this.mcAssetQualifiedNames = mcAssetQualifiedNames;
        java.util.SortedSet<String> mcLabels = new java.util.TreeSet<String>();
        if (b.mcLabels != null) mcLabels.addAll(b.mcLabels);
        mcLabels = java.util.Collections.unmodifiableSortedSet(mcLabels);
        this.mcLabels = mcLabels;
        this.mcMonitorAlertCondition = b.mcMonitorAlertCondition;
        this.mcMonitorAlertCount = b.mcMonitorAlertCount;
        java.util.SortedSet<IAsset> mcMonitorAssets = new java.util.TreeSet<IAsset>();
        if (b.mcMonitorAssets != null) mcMonitorAssets.addAll(b.mcMonitorAssets);
        mcMonitorAssets = java.util.Collections.unmodifiableSortedSet(mcMonitorAssets);
        this.mcMonitorAssets = mcMonitorAssets;
        this.mcMonitorBreachRate = b.mcMonitorBreachRate;
        this.mcMonitorId = b.mcMonitorId;
        this.mcMonitorIncidentCount = b.mcMonitorIncidentCount;
        this.mcMonitorNamespace = b.mcMonitorNamespace;
        this.mcMonitorPriority = b.mcMonitorPriority;
        java.util.List<MCRuleComparison> mcMonitorRuleComparisons;
        switch (b.mcMonitorRuleComparisons == null ? 0 : b.mcMonitorRuleComparisons.size()) {
        case 0: 
            mcMonitorRuleComparisons = java.util.Collections.emptyList();
            break;
        case 1: 
            mcMonitorRuleComparisons = java.util.Collections.singletonList(b.mcMonitorRuleComparisons.get(0));
            break;
        default: 
            mcMonitorRuleComparisons = java.util.Collections.unmodifiableList(new java.util.ArrayList<MCRuleComparison>(b.mcMonitorRuleComparisons));
        }
        this.mcMonitorRuleComparisons = mcMonitorRuleComparisons;
        this.mcMonitorRuleCustomSql = b.mcMonitorRuleCustomSql;
        this.mcMonitorRuleIsSnoozed = b.mcMonitorRuleIsSnoozed;
        this.mcMonitorRuleNextExecutionTime = b.mcMonitorRuleNextExecutionTime;
        this.mcMonitorRulePreviousExecutionTime = b.mcMonitorRulePreviousExecutionTime;
        this.mcMonitorRuleScheduleConfig = b.mcMonitorRuleScheduleConfig;
        this.mcMonitorRuleScheduleConfigHumanized = b.mcMonitorRuleScheduleConfigHumanized;
        this.mcMonitorRuleType = b.mcMonitorRuleType;
        this.mcMonitorScheduleType = b.mcMonitorScheduleType;
        this.mcMonitorStatus = b.mcMonitorStatus;
        this.mcMonitorType = b.mcMonitorType;
        this.mcMonitorWarehouse = b.mcMonitorWarehouse;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static MCMonitor.MCMonitorBuilder<?, ?> _internal() {
        return new MCMonitor.MCMonitorBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MCMonitor.MCMonitorBuilder<?, ?> toBuilder() {
        return new MCMonitor.MCMonitorBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * List of unique names of assets that are part of this Monte Carlo asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMcAssetQualifiedNames() {
        return this.mcAssetQualifiedNames;
    }

    /**
     * List of labels for this Monte Carlo asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMcLabels() {
        return this.mcLabels;
    }

    /**
     * Condition on which the monitor produces an alert.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorAlertCondition() {
        return this.mcMonitorAlertCondition;
    }

    /**
     * Number of alerts associated with this monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMcMonitorAlertCount() {
        return this.mcMonitorAlertCount;
    }

    /**
     * Assets impacted by this monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getMcMonitorAssets() {
        return this.mcMonitorAssets;
    }

    /**
     * Rate at which this monitor is breached.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getMcMonitorBreachRate() {
        return this.mcMonitorBreachRate;
    }

    /**
     * Unique identifier for this monitor, from Monte Carlo.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorId() {
        return this.mcMonitorId;
    }

    /**
     * Number of incidents associated with this monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMcMonitorIncidentCount() {
        return this.mcMonitorIncidentCount;
    }

    /**
     * Namespace of this monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorNamespace() {
        return this.mcMonitorNamespace;
    }

    /**
     * Priority of this monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorPriority() {
        return this.mcMonitorPriority;
    }

    /**
     * Comparison logic used for the rule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<MCRuleComparison> getMcMonitorRuleComparisons() {
        return this.mcMonitorRuleComparisons;
    }

    /**
     * SQL code for custom SQL rules.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorRuleCustomSql() {
        return this.mcMonitorRuleCustomSql;
    }

    /**
     * Whether the rule is currently snoozed (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getMcMonitorRuleIsSnoozed() {
        return this.mcMonitorRuleIsSnoozed;
    }

    /**
     * Time at which the next execution of the rule should occur.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMcMonitorRuleNextExecutionTime() {
        return this.mcMonitorRuleNextExecutionTime;
    }

    /**
     * Time at which the previous execution of the rule occurred.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMcMonitorRulePreviousExecutionTime() {
        return this.mcMonitorRulePreviousExecutionTime;
    }

    /**
     * Schedule details for the rule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MCRuleSchedule getMcMonitorRuleScheduleConfig() {
        return this.mcMonitorRuleScheduleConfig;
    }

    /**
     * Readable description of the schedule for the rule.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorRuleScheduleConfigHumanized() {
        return this.mcMonitorRuleScheduleConfigHumanized;
    }

    /**
     * Type of rule for this monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorRuleType() {
        return this.mcMonitorRuleType;
    }

    /**
     * Type of schedule for this monitor, for example: fixed or dynamic.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorScheduleType() {
        return this.mcMonitorScheduleType;
    }

    /**
     * Status of this monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorStatus() {
        return this.mcMonitorStatus;
    }

    /**
     * Type of this monitor, for example: field health (stats) or dimension tracking (categories).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorType() {
        return this.mcMonitorType;
    }

    /**
     * Name of the warehouse for this monitor.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMcMonitorWarehouse() {
        return this.mcMonitorWarehouse;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MCMonitor)) return false;
        final MCMonitor other = (MCMonitor) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$mcMonitorAlertCount = this.getMcMonitorAlertCount();
        final java.lang.Object other$mcMonitorAlertCount = other.getMcMonitorAlertCount();
        if (this$mcMonitorAlertCount == null ? other$mcMonitorAlertCount != null : !this$mcMonitorAlertCount.equals(other$mcMonitorAlertCount)) return false;
        final java.lang.Object this$mcMonitorBreachRate = this.getMcMonitorBreachRate();
        final java.lang.Object other$mcMonitorBreachRate = other.getMcMonitorBreachRate();
        if (this$mcMonitorBreachRate == null ? other$mcMonitorBreachRate != null : !this$mcMonitorBreachRate.equals(other$mcMonitorBreachRate)) return false;
        final java.lang.Object this$mcMonitorIncidentCount = this.getMcMonitorIncidentCount();
        final java.lang.Object other$mcMonitorIncidentCount = other.getMcMonitorIncidentCount();
        if (this$mcMonitorIncidentCount == null ? other$mcMonitorIncidentCount != null : !this$mcMonitorIncidentCount.equals(other$mcMonitorIncidentCount)) return false;
        final java.lang.Object this$mcMonitorRuleIsSnoozed = this.getMcMonitorRuleIsSnoozed();
        final java.lang.Object other$mcMonitorRuleIsSnoozed = other.getMcMonitorRuleIsSnoozed();
        if (this$mcMonitorRuleIsSnoozed == null ? other$mcMonitorRuleIsSnoozed != null : !this$mcMonitorRuleIsSnoozed.equals(other$mcMonitorRuleIsSnoozed)) return false;
        final java.lang.Object this$mcMonitorRuleNextExecutionTime = this.getMcMonitorRuleNextExecutionTime();
        final java.lang.Object other$mcMonitorRuleNextExecutionTime = other.getMcMonitorRuleNextExecutionTime();
        if (this$mcMonitorRuleNextExecutionTime == null ? other$mcMonitorRuleNextExecutionTime != null : !this$mcMonitorRuleNextExecutionTime.equals(other$mcMonitorRuleNextExecutionTime)) return false;
        final java.lang.Object this$mcMonitorRulePreviousExecutionTime = this.getMcMonitorRulePreviousExecutionTime();
        final java.lang.Object other$mcMonitorRulePreviousExecutionTime = other.getMcMonitorRulePreviousExecutionTime();
        if (this$mcMonitorRulePreviousExecutionTime == null ? other$mcMonitorRulePreviousExecutionTime != null : !this$mcMonitorRulePreviousExecutionTime.equals(other$mcMonitorRulePreviousExecutionTime)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$mcAssetQualifiedNames = this.getMcAssetQualifiedNames();
        final java.lang.Object other$mcAssetQualifiedNames = other.getMcAssetQualifiedNames();
        if (this$mcAssetQualifiedNames == null ? other$mcAssetQualifiedNames != null : !this$mcAssetQualifiedNames.equals(other$mcAssetQualifiedNames)) return false;
        final java.lang.Object this$mcLabels = this.getMcLabels();
        final java.lang.Object other$mcLabels = other.getMcLabels();
        if (this$mcLabels == null ? other$mcLabels != null : !this$mcLabels.equals(other$mcLabels)) return false;
        final java.lang.Object this$mcMonitorAlertCondition = this.getMcMonitorAlertCondition();
        final java.lang.Object other$mcMonitorAlertCondition = other.getMcMonitorAlertCondition();
        if (this$mcMonitorAlertCondition == null ? other$mcMonitorAlertCondition != null : !this$mcMonitorAlertCondition.equals(other$mcMonitorAlertCondition)) return false;
        final java.lang.Object this$mcMonitorAssets = this.getMcMonitorAssets();
        final java.lang.Object other$mcMonitorAssets = other.getMcMonitorAssets();
        if (this$mcMonitorAssets == null ? other$mcMonitorAssets != null : !this$mcMonitorAssets.equals(other$mcMonitorAssets)) return false;
        final java.lang.Object this$mcMonitorId = this.getMcMonitorId();
        final java.lang.Object other$mcMonitorId = other.getMcMonitorId();
        if (this$mcMonitorId == null ? other$mcMonitorId != null : !this$mcMonitorId.equals(other$mcMonitorId)) return false;
        final java.lang.Object this$mcMonitorNamespace = this.getMcMonitorNamespace();
        final java.lang.Object other$mcMonitorNamespace = other.getMcMonitorNamespace();
        if (this$mcMonitorNamespace == null ? other$mcMonitorNamespace != null : !this$mcMonitorNamespace.equals(other$mcMonitorNamespace)) return false;
        final java.lang.Object this$mcMonitorPriority = this.getMcMonitorPriority();
        final java.lang.Object other$mcMonitorPriority = other.getMcMonitorPriority();
        if (this$mcMonitorPriority == null ? other$mcMonitorPriority != null : !this$mcMonitorPriority.equals(other$mcMonitorPriority)) return false;
        final java.lang.Object this$mcMonitorRuleComparisons = this.getMcMonitorRuleComparisons();
        final java.lang.Object other$mcMonitorRuleComparisons = other.getMcMonitorRuleComparisons();
        if (this$mcMonitorRuleComparisons == null ? other$mcMonitorRuleComparisons != null : !this$mcMonitorRuleComparisons.equals(other$mcMonitorRuleComparisons)) return false;
        final java.lang.Object this$mcMonitorRuleCustomSql = this.getMcMonitorRuleCustomSql();
        final java.lang.Object other$mcMonitorRuleCustomSql = other.getMcMonitorRuleCustomSql();
        if (this$mcMonitorRuleCustomSql == null ? other$mcMonitorRuleCustomSql != null : !this$mcMonitorRuleCustomSql.equals(other$mcMonitorRuleCustomSql)) return false;
        final java.lang.Object this$mcMonitorRuleScheduleConfig = this.getMcMonitorRuleScheduleConfig();
        final java.lang.Object other$mcMonitorRuleScheduleConfig = other.getMcMonitorRuleScheduleConfig();
        if (this$mcMonitorRuleScheduleConfig == null ? other$mcMonitorRuleScheduleConfig != null : !this$mcMonitorRuleScheduleConfig.equals(other$mcMonitorRuleScheduleConfig)) return false;
        final java.lang.Object this$mcMonitorRuleScheduleConfigHumanized = this.getMcMonitorRuleScheduleConfigHumanized();
        final java.lang.Object other$mcMonitorRuleScheduleConfigHumanized = other.getMcMonitorRuleScheduleConfigHumanized();
        if (this$mcMonitorRuleScheduleConfigHumanized == null ? other$mcMonitorRuleScheduleConfigHumanized != null : !this$mcMonitorRuleScheduleConfigHumanized.equals(other$mcMonitorRuleScheduleConfigHumanized)) return false;
        final java.lang.Object this$mcMonitorRuleType = this.getMcMonitorRuleType();
        final java.lang.Object other$mcMonitorRuleType = other.getMcMonitorRuleType();
        if (this$mcMonitorRuleType == null ? other$mcMonitorRuleType != null : !this$mcMonitorRuleType.equals(other$mcMonitorRuleType)) return false;
        final java.lang.Object this$mcMonitorScheduleType = this.getMcMonitorScheduleType();
        final java.lang.Object other$mcMonitorScheduleType = other.getMcMonitorScheduleType();
        if (this$mcMonitorScheduleType == null ? other$mcMonitorScheduleType != null : !this$mcMonitorScheduleType.equals(other$mcMonitorScheduleType)) return false;
        final java.lang.Object this$mcMonitorStatus = this.getMcMonitorStatus();
        final java.lang.Object other$mcMonitorStatus = other.getMcMonitorStatus();
        if (this$mcMonitorStatus == null ? other$mcMonitorStatus != null : !this$mcMonitorStatus.equals(other$mcMonitorStatus)) return false;
        final java.lang.Object this$mcMonitorType = this.getMcMonitorType();
        final java.lang.Object other$mcMonitorType = other.getMcMonitorType();
        if (this$mcMonitorType == null ? other$mcMonitorType != null : !this$mcMonitorType.equals(other$mcMonitorType)) return false;
        final java.lang.Object this$mcMonitorWarehouse = this.getMcMonitorWarehouse();
        final java.lang.Object other$mcMonitorWarehouse = other.getMcMonitorWarehouse();
        if (this$mcMonitorWarehouse == null ? other$mcMonitorWarehouse != null : !this$mcMonitorWarehouse.equals(other$mcMonitorWarehouse)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MCMonitor;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $mcMonitorAlertCount = this.getMcMonitorAlertCount();
        result = result * PRIME + ($mcMonitorAlertCount == null ? 43 : $mcMonitorAlertCount.hashCode());
        final java.lang.Object $mcMonitorBreachRate = this.getMcMonitorBreachRate();
        result = result * PRIME + ($mcMonitorBreachRate == null ? 43 : $mcMonitorBreachRate.hashCode());
        final java.lang.Object $mcMonitorIncidentCount = this.getMcMonitorIncidentCount();
        result = result * PRIME + ($mcMonitorIncidentCount == null ? 43 : $mcMonitorIncidentCount.hashCode());
        final java.lang.Object $mcMonitorRuleIsSnoozed = this.getMcMonitorRuleIsSnoozed();
        result = result * PRIME + ($mcMonitorRuleIsSnoozed == null ? 43 : $mcMonitorRuleIsSnoozed.hashCode());
        final java.lang.Object $mcMonitorRuleNextExecutionTime = this.getMcMonitorRuleNextExecutionTime();
        result = result * PRIME + ($mcMonitorRuleNextExecutionTime == null ? 43 : $mcMonitorRuleNextExecutionTime.hashCode());
        final java.lang.Object $mcMonitorRulePreviousExecutionTime = this.getMcMonitorRulePreviousExecutionTime();
        result = result * PRIME + ($mcMonitorRulePreviousExecutionTime == null ? 43 : $mcMonitorRulePreviousExecutionTime.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $mcAssetQualifiedNames = this.getMcAssetQualifiedNames();
        result = result * PRIME + ($mcAssetQualifiedNames == null ? 43 : $mcAssetQualifiedNames.hashCode());
        final java.lang.Object $mcLabels = this.getMcLabels();
        result = result * PRIME + ($mcLabels == null ? 43 : $mcLabels.hashCode());
        final java.lang.Object $mcMonitorAlertCondition = this.getMcMonitorAlertCondition();
        result = result * PRIME + ($mcMonitorAlertCondition == null ? 43 : $mcMonitorAlertCondition.hashCode());
        final java.lang.Object $mcMonitorAssets = this.getMcMonitorAssets();
        result = result * PRIME + ($mcMonitorAssets == null ? 43 : $mcMonitorAssets.hashCode());
        final java.lang.Object $mcMonitorId = this.getMcMonitorId();
        result = result * PRIME + ($mcMonitorId == null ? 43 : $mcMonitorId.hashCode());
        final java.lang.Object $mcMonitorNamespace = this.getMcMonitorNamespace();
        result = result * PRIME + ($mcMonitorNamespace == null ? 43 : $mcMonitorNamespace.hashCode());
        final java.lang.Object $mcMonitorPriority = this.getMcMonitorPriority();
        result = result * PRIME + ($mcMonitorPriority == null ? 43 : $mcMonitorPriority.hashCode());
        final java.lang.Object $mcMonitorRuleComparisons = this.getMcMonitorRuleComparisons();
        result = result * PRIME + ($mcMonitorRuleComparisons == null ? 43 : $mcMonitorRuleComparisons.hashCode());
        final java.lang.Object $mcMonitorRuleCustomSql = this.getMcMonitorRuleCustomSql();
        result = result * PRIME + ($mcMonitorRuleCustomSql == null ? 43 : $mcMonitorRuleCustomSql.hashCode());
        final java.lang.Object $mcMonitorRuleScheduleConfig = this.getMcMonitorRuleScheduleConfig();
        result = result * PRIME + ($mcMonitorRuleScheduleConfig == null ? 43 : $mcMonitorRuleScheduleConfig.hashCode());
        final java.lang.Object $mcMonitorRuleScheduleConfigHumanized = this.getMcMonitorRuleScheduleConfigHumanized();
        result = result * PRIME + ($mcMonitorRuleScheduleConfigHumanized == null ? 43 : $mcMonitorRuleScheduleConfigHumanized.hashCode());
        final java.lang.Object $mcMonitorRuleType = this.getMcMonitorRuleType();
        result = result * PRIME + ($mcMonitorRuleType == null ? 43 : $mcMonitorRuleType.hashCode());
        final java.lang.Object $mcMonitorScheduleType = this.getMcMonitorScheduleType();
        result = result * PRIME + ($mcMonitorScheduleType == null ? 43 : $mcMonitorScheduleType.hashCode());
        final java.lang.Object $mcMonitorStatus = this.getMcMonitorStatus();
        result = result * PRIME + ($mcMonitorStatus == null ? 43 : $mcMonitorStatus.hashCode());
        final java.lang.Object $mcMonitorType = this.getMcMonitorType();
        result = result * PRIME + ($mcMonitorType == null ? 43 : $mcMonitorType.hashCode());
        final java.lang.Object $mcMonitorWarehouse = this.getMcMonitorWarehouse();
        result = result * PRIME + ($mcMonitorWarehouse == null ? 43 : $mcMonitorWarehouse.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MCMonitor(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", mcAssetQualifiedNames=" + this.getMcAssetQualifiedNames() + ", mcLabels=" + this.getMcLabels() + ", mcMonitorAlertCondition=" + this.getMcMonitorAlertCondition() + ", mcMonitorAlertCount=" + this.getMcMonitorAlertCount() + ", mcMonitorAssets=" + this.getMcMonitorAssets() + ", mcMonitorBreachRate=" + this.getMcMonitorBreachRate() + ", mcMonitorId=" + this.getMcMonitorId() + ", mcMonitorIncidentCount=" + this.getMcMonitorIncidentCount() + ", mcMonitorNamespace=" + this.getMcMonitorNamespace() + ", mcMonitorPriority=" + this.getMcMonitorPriority() + ", mcMonitorRuleComparisons=" + this.getMcMonitorRuleComparisons() + ", mcMonitorRuleCustomSql=" + this.getMcMonitorRuleCustomSql() + ", mcMonitorRuleIsSnoozed=" + this.getMcMonitorRuleIsSnoozed() + ", mcMonitorRuleNextExecutionTime=" + this.getMcMonitorRuleNextExecutionTime() + ", mcMonitorRulePreviousExecutionTime=" + this.getMcMonitorRulePreviousExecutionTime() + ", mcMonitorRuleScheduleConfig=" + this.getMcMonitorRuleScheduleConfig() + ", mcMonitorRuleScheduleConfigHumanized=" + this.getMcMonitorRuleScheduleConfigHumanized() + ", mcMonitorRuleType=" + this.getMcMonitorRuleType() + ", mcMonitorScheduleType=" + this.getMcMonitorScheduleType() + ", mcMonitorStatus=" + this.getMcMonitorStatus() + ", mcMonitorType=" + this.getMcMonitorType() + ", mcMonitorWarehouse=" + this.getMcMonitorWarehouse() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for MCMonitors.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
