// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Matillion component in Atlan. Components in Matillion are a part of a job, where each component is responsible for accomplishing a task based on the type of component used.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class MatillionComponent extends Asset implements IMatillionComponent, IMatillion, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MatillionComponent.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MatillionComponent";
    /**
     * Fixed typeName for MatillionComponents.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Unique identifier of the component in Matillion.
     */
    @Attribute
    String matillionComponentId;
    /**
     * Unique identifier for the type of the component in Matillion.
     */
    @Attribute
    String matillionComponentImplementationId;
    /**
     * Last five run statuses of the component within a job.
     */
    @Attribute
    String matillionComponentLastFiveRunStatus;
    /**
     * Latest run status of the component within a job.
     */
    @Attribute
    String matillionComponentLastRunStatus;
    /**
     * Job details of the job to which the component internally links.
     */
    @Attribute
    Map<String, String> matillionComponentLinkedJob;
    /**
     * SQL queries used by the component.
     */
    @Attribute
    SortedSet<String> matillionComponentSqls;
    /**
     * Job in which this component exists.
     */
    @Attribute
    IMatillionJob matillionJob;
    /**
     * Simple name of the job to which the component belongs.
     */
    @Attribute
    String matillionJobName;
    /**
     * Unique name of the job to which the component belongs.
     */
    @Attribute
    String matillionJobQualifiedName;
    /**
     * Lineage process that represents this Matillion component.
     */
    @Attribute
    ILineageProcess matillionProcess;
    /**
     * Current point in time state of a project.
     */
    @Attribute
    String matillionVersion;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a MatillionComponent, from a potentially
     * more-complete MatillionComponent object.
     *
     * @return the minimal object necessary to relate to the MatillionComponent
     * @throws InvalidRequestException if any of the minimal set of required properties for a MatillionComponent relationship are not found in the initial object
     */
    @Override
    public MatillionComponent trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all MatillionComponent assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MatillionComponent assets will be included.
     *
     * @return a fluent search that includes all MatillionComponent assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all MatillionComponent assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MatillionComponent assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all MatillionComponent assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all MatillionComponent assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) MatillionComponents will be included
     * @return a fluent search that includes all MatillionComponent assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all MatillionComponent assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) MatillionComponents will be included
     * @return a fluent search that includes all MatillionComponent assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a MatillionComponent by GUID. Use this to create a relationship to this MatillionComponent,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the MatillionComponent to reference
     * @return reference to a MatillionComponent that can be used for defining a relationship to a MatillionComponent
     */
    public static MatillionComponent refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MatillionComponent by GUID. Use this to create a relationship to this MatillionComponent,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the MatillionComponent to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MatillionComponent that can be used for defining a relationship to a MatillionComponent
     */
    public static MatillionComponent refByGuid(String guid, Reference.SaveSemantic semantic) {
        return MatillionComponent._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a MatillionComponent by qualifiedName. Use this to create a relationship to this MatillionComponent,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the MatillionComponent to reference
     * @return reference to a MatillionComponent that can be used for defining a relationship to a MatillionComponent
     */
    public static MatillionComponent refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MatillionComponent by qualifiedName. Use this to create a relationship to this MatillionComponent,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the MatillionComponent to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MatillionComponent that can be used for defining a relationship to a MatillionComponent
     */
    public static MatillionComponent refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return MatillionComponent._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a MatillionComponent by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the MatillionComponent to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MatillionComponent, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MatillionComponent does not exist or the provided GUID is not a MatillionComponent
     */
    @JsonIgnore
    public static MatillionComponent get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a MatillionComponent by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MatillionComponent to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MatillionComponent, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MatillionComponent does not exist or the provided GUID is not a MatillionComponent
     */
    @JsonIgnore
    public static MatillionComponent get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a MatillionComponent by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MatillionComponent to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full MatillionComponent, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MatillionComponent does not exist or the provided GUID is not a MatillionComponent
     */
    @JsonIgnore
    public static MatillionComponent get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof MatillionComponent) {
                return (MatillionComponent) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof MatillionComponent) {
                return (MatillionComponent) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) MatillionComponent to active.
     *
     * @param qualifiedName for the MatillionComponent
     * @return true if the MatillionComponent is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) MatillionComponent to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the MatillionComponent
     * @return true if the MatillionComponent is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the minimal request necessary to update the MatillionComponent, as a builder
     */
    public static MatillionComponentBuilder<?, ?> updater(String qualifiedName, String name) {
        return MatillionComponent._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a MatillionComponent, from a potentially
     * more-complete MatillionComponent object.
     *
     * @return the minimal object necessary to update the MatillionComponent, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for MatillionComponent are not found in the initial object
     */
    @Override
    public MatillionComponentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a MatillionComponent.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a MatillionComponent.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a MatillionComponent.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MatillionComponent's owners
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MatillionComponent, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a MatillionComponent.
     *
     * @param client connectivity to the Atlan tenant on which to update the MatillionComponent's certificate
     * @param qualifiedName of the MatillionComponent
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MatillionComponent, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MatillionComponent) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a MatillionComponent.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MatillionComponent's certificate
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a MatillionComponent.
     *
     * @param client connectivity to the Atlan tenant on which to update the MatillionComponent's announcement
     * @param qualifiedName of the MatillionComponent
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MatillionComponent) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a MatillionComponent.
     *
     * @param client connectivity to the Atlan client from which to remove the MatillionComponent's announcement
     * @param qualifiedName of the MatillionComponent
     * @param name of the MatillionComponent
     * @return the updated MatillionComponent, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionComponent) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the MatillionComponent.
     *
     * @param qualifiedName for the MatillionComponent
     * @param name human-readable name of the MatillionComponent
     * @param terms the list of terms to replace on the MatillionComponent, or null to remove all terms from the MatillionComponent
     * @return the MatillionComponent that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the MatillionComponent.
     *
     * @param client connectivity to the Atlan tenant on which to replace the MatillionComponent's assigned terms
     * @param qualifiedName for the MatillionComponent
     * @param name human-readable name of the MatillionComponent
     * @param terms the list of terms to replace on the MatillionComponent, or null to remove all terms from the MatillionComponent
     * @return the MatillionComponent that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionComponent) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the MatillionComponent, without replacing existing terms linked to the MatillionComponent.
     * Note: this operation must make two API calls — one to retrieve the MatillionComponent's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the MatillionComponent
     * @param terms the list of terms to append to the MatillionComponent
     * @return the MatillionComponent that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the MatillionComponent, without replacing existing terms linked to the MatillionComponent.
     * Note: this operation must make two API calls — one to retrieve the MatillionComponent's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the MatillionComponent
     * @param qualifiedName for the MatillionComponent
     * @param terms the list of terms to append to the MatillionComponent
     * @return the MatillionComponent that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionComponent) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a MatillionComponent, without replacing all existing terms linked to the MatillionComponent.
     * Note: this operation must make two API calls — one to retrieve the MatillionComponent's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the MatillionComponent
     * @param terms the list of terms to remove from the MatillionComponent, which must be referenced by GUID
     * @return the MatillionComponent that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a MatillionComponent, without replacing all existing terms linked to the MatillionComponent.
     * Note: this operation must make two API calls — one to retrieve the MatillionComponent's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the MatillionComponent
     * @param qualifiedName for the MatillionComponent
     * @param terms the list of terms to remove from the MatillionComponent, which must be referenced by GUID
     * @return the MatillionComponent that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionComponent removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionComponent) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a MatillionComponent, without replacing existing Atlan tags linked to the MatillionComponent.
     * Note: this operation must make two API calls — one to retrieve the MatillionComponent's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MatillionComponent
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MatillionComponent
     */
    public static MatillionComponent appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MatillionComponent, without replacing existing Atlan tags linked to the MatillionComponent.
     * Note: this operation must make two API calls — one to retrieve the MatillionComponent's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MatillionComponent
     * @param qualifiedName of the MatillionComponent
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MatillionComponent
     */
    public static MatillionComponent appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MatillionComponent) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MatillionComponent, without replacing existing Atlan tags linked to the MatillionComponent.
     * Note: this operation must make two API calls — one to retrieve the MatillionComponent's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MatillionComponent
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MatillionComponent
     */
    public static MatillionComponent appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a MatillionComponent, without replacing existing Atlan tags linked to the MatillionComponent.
     * Note: this operation must make two API calls — one to retrieve the MatillionComponent's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MatillionComponent
     * @param qualifiedName of the MatillionComponent
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MatillionComponent
     */
    public static MatillionComponent appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MatillionComponent) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a MatillionComponent.
     *
     * @param qualifiedName of the MatillionComponent
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MatillionComponent
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a MatillionComponent.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a MatillionComponent
     * @param qualifiedName of the MatillionComponent
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MatillionComponent
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MatillionComponentBuilder<C extends MatillionComponent, B extends MatillionComponent.MatillionComponentBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionComponentId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionComponentImplementationId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionComponentLastFiveRunStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionComponentLastRunStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> matillionComponentLinkedJob$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> matillionComponentLinkedJob$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> matillionComponentSqls;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMatillionJob matillionJob;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionJobName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionJobQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ILineageProcess matillionProcess;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MatillionComponent.MatillionComponentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final MatillionComponent instance, final MatillionComponent.MatillionComponentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.matillionComponentId(instance.matillionComponentId);
            b.matillionComponentImplementationId(instance.matillionComponentImplementationId);
            b.matillionComponentLastFiveRunStatus(instance.matillionComponentLastFiveRunStatus);
            b.matillionComponentLastRunStatus(instance.matillionComponentLastRunStatus);
            b.matillionComponentLinkedJob(instance.matillionComponentLinkedJob == null ? java.util.Collections.<String, String>emptyMap() : instance.matillionComponentLinkedJob);
            b.matillionComponentSqls(instance.matillionComponentSqls == null ? java.util.Collections.<String>emptySortedSet() : instance.matillionComponentSqls);
            b.matillionJob(instance.matillionJob);
            b.matillionJobName(instance.matillionJobName);
            b.matillionJobQualifiedName(instance.matillionJobQualifiedName);
            b.matillionProcess(instance.matillionProcess);
            b.matillionVersion(instance.matillionVersion);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for MatillionComponents.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Unique identifier of the component in Matillion.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponentId(final String matillionComponentId) {
            this.matillionComponentId = matillionComponentId;
            return self();
        }

        /**
         * Unique identifier for the type of the component in Matillion.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponentImplementationId(final String matillionComponentImplementationId) {
            this.matillionComponentImplementationId = matillionComponentImplementationId;
            return self();
        }

        /**
         * Last five run statuses of the component within a job.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponentLastFiveRunStatus(final String matillionComponentLastFiveRunStatus) {
            this.matillionComponentLastFiveRunStatus = matillionComponentLastFiveRunStatus;
            return self();
        }

        /**
         * Latest run status of the component within a job.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponentLastRunStatus(final String matillionComponentLastRunStatus) {
            this.matillionComponentLastRunStatus = matillionComponentLastRunStatus;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putMatillionComponentLinkedJob(final String putMatillionComponentLinkedJobKey, final String putMatillionComponentLinkedJobValue) {
            if (this.matillionComponentLinkedJob$key == null) {
                this.matillionComponentLinkedJob$key = new java.util.ArrayList<String>();
                this.matillionComponentLinkedJob$value = new java.util.ArrayList<String>();
            }
            this.matillionComponentLinkedJob$key.add(putMatillionComponentLinkedJobKey);
            this.matillionComponentLinkedJob$value.add(putMatillionComponentLinkedJobValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponentLinkedJob(final java.util.Map<? extends String, ? extends String> matillionComponentLinkedJob) {
            if (matillionComponentLinkedJob == null) {
                throw new java.lang.NullPointerException("matillionComponentLinkedJob cannot be null");
            }
            if (this.matillionComponentLinkedJob$key == null) {
                this.matillionComponentLinkedJob$key = new java.util.ArrayList<String>();
                this.matillionComponentLinkedJob$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : matillionComponentLinkedJob.entrySet()) {
                this.matillionComponentLinkedJob$key.add($lombokEntry.getKey());
                this.matillionComponentLinkedJob$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMatillionComponentLinkedJob() {
            if (this.matillionComponentLinkedJob$key != null) {
                this.matillionComponentLinkedJob$key.clear();
                this.matillionComponentLinkedJob$value.clear();
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponentSql(final String matillionComponentSql) {
            if (this.matillionComponentSqls == null) this.matillionComponentSqls = new java.util.ArrayList<String>();
            this.matillionComponentSqls.add(matillionComponentSql);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionComponentSqls(final java.util.Collection<? extends String> matillionComponentSqls) {
            if (matillionComponentSqls == null) {
                throw new java.lang.NullPointerException("matillionComponentSqls cannot be null");
            }
            if (this.matillionComponentSqls == null) this.matillionComponentSqls = new java.util.ArrayList<String>();
            this.matillionComponentSqls.addAll(matillionComponentSqls);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMatillionComponentSqls() {
            if (this.matillionComponentSqls != null) this.matillionComponentSqls.clear();
            return self();
        }

        /**
         * Job in which this component exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionJob(final IMatillionJob matillionJob) {
            this.matillionJob = matillionJob;
            return self();
        }

        /**
         * Simple name of the job to which the component belongs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionJobName(final String matillionJobName) {
            this.matillionJobName = matillionJobName;
            return self();
        }

        /**
         * Unique name of the job to which the component belongs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionJobQualifiedName(final String matillionJobQualifiedName) {
            this.matillionJobQualifiedName = matillionJobQualifiedName;
            return self();
        }

        /**
         * Lineage process that represents this Matillion component.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionProcess(final ILineageProcess matillionProcess) {
            this.matillionProcess = matillionProcess;
            return self();
        }

        /**
         * Current point in time state of a project.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionVersion(final String matillionVersion) {
            this.matillionVersion = matillionVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "MatillionComponent.MatillionComponentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", matillionComponentId=" + this.matillionComponentId + ", matillionComponentImplementationId=" + this.matillionComponentImplementationId + ", matillionComponentLastFiveRunStatus=" + this.matillionComponentLastFiveRunStatus + ", matillionComponentLastRunStatus=" + this.matillionComponentLastRunStatus + ", matillionComponentLinkedJob$key=" + this.matillionComponentLinkedJob$key + ", matillionComponentLinkedJob$value=" + this.matillionComponentLinkedJob$value + ", matillionComponentSqls=" + this.matillionComponentSqls + ", matillionJob=" + this.matillionJob + ", matillionJobName=" + this.matillionJobName + ", matillionJobQualifiedName=" + this.matillionJobQualifiedName + ", matillionProcess=" + this.matillionProcess + ", matillionVersion=" + this.matillionVersion + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class MatillionComponentBuilderImpl extends MatillionComponent.MatillionComponentBuilder<MatillionComponent, MatillionComponent.MatillionComponentBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MatillionComponentBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected MatillionComponent.MatillionComponentBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public MatillionComponent build() {
            return new MatillionComponent(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected MatillionComponent(final MatillionComponent.MatillionComponentBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = MatillionComponent.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.matillionComponentId = b.matillionComponentId;
        this.matillionComponentImplementationId = b.matillionComponentImplementationId;
        this.matillionComponentLastFiveRunStatus = b.matillionComponentLastFiveRunStatus;
        this.matillionComponentLastRunStatus = b.matillionComponentLastRunStatus;
        java.util.Map<String, String> matillionComponentLinkedJob;
        switch (b.matillionComponentLinkedJob$key == null ? 0 : b.matillionComponentLinkedJob$key.size()) {
        case 0: 
            matillionComponentLinkedJob = java.util.Collections.emptyMap();
            break;
        case 1: 
            matillionComponentLinkedJob = java.util.Collections.singletonMap(b.matillionComponentLinkedJob$key.get(0), b.matillionComponentLinkedJob$value.get(0));
            break;
        default: 
            matillionComponentLinkedJob = new java.util.LinkedHashMap<String, String>(b.matillionComponentLinkedJob$key.size() < 1073741824 ? 1 + b.matillionComponentLinkedJob$key.size() + (b.matillionComponentLinkedJob$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.matillionComponentLinkedJob$key.size(); $i++) matillionComponentLinkedJob.put(b.matillionComponentLinkedJob$key.get($i), (String) b.matillionComponentLinkedJob$value.get($i));
            matillionComponentLinkedJob = java.util.Collections.unmodifiableMap(matillionComponentLinkedJob);
        }
        this.matillionComponentLinkedJob = matillionComponentLinkedJob;
        java.util.SortedSet<String> matillionComponentSqls = new java.util.TreeSet<String>();
        if (b.matillionComponentSqls != null) matillionComponentSqls.addAll(b.matillionComponentSqls);
        matillionComponentSqls = java.util.Collections.unmodifiableSortedSet(matillionComponentSqls);
        this.matillionComponentSqls = matillionComponentSqls;
        this.matillionJob = b.matillionJob;
        this.matillionJobName = b.matillionJobName;
        this.matillionJobQualifiedName = b.matillionJobQualifiedName;
        this.matillionProcess = b.matillionProcess;
        this.matillionVersion = b.matillionVersion;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static MatillionComponent.MatillionComponentBuilder<?, ?> _internal() {
        return new MatillionComponent.MatillionComponentBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatillionComponent.MatillionComponentBuilder<?, ?> toBuilder() {
        return new MatillionComponent.MatillionComponentBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Unique identifier of the component in Matillion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionComponentId() {
        return this.matillionComponentId;
    }

    /**
     * Unique identifier for the type of the component in Matillion.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionComponentImplementationId() {
        return this.matillionComponentImplementationId;
    }

    /**
     * Last five run statuses of the component within a job.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionComponentLastFiveRunStatus() {
        return this.matillionComponentLastFiveRunStatus;
    }

    /**
     * Latest run status of the component within a job.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionComponentLastRunStatus() {
        return this.matillionComponentLastRunStatus;
    }

    /**
     * Job details of the job to which the component internally links.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getMatillionComponentLinkedJob() {
        return this.matillionComponentLinkedJob;
    }

    /**
     * SQL queries used by the component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMatillionComponentSqls() {
        return this.matillionComponentSqls;
    }

    /**
     * Job in which this component exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMatillionJob getMatillionJob() {
        return this.matillionJob;
    }

    /**
     * Simple name of the job to which the component belongs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionJobName() {
        return this.matillionJobName;
    }

    /**
     * Unique name of the job to which the component belongs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionJobQualifiedName() {
        return this.matillionJobQualifiedName;
    }

    /**
     * Lineage process that represents this Matillion component.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ILineageProcess getMatillionProcess() {
        return this.matillionProcess;
    }

    /**
     * Current point in time state of a project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionVersion() {
        return this.matillionVersion;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MatillionComponent)) return false;
        final MatillionComponent other = (MatillionComponent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$matillionComponentId = this.getMatillionComponentId();
        final java.lang.Object other$matillionComponentId = other.getMatillionComponentId();
        if (this$matillionComponentId == null ? other$matillionComponentId != null : !this$matillionComponentId.equals(other$matillionComponentId)) return false;
        final java.lang.Object this$matillionComponentImplementationId = this.getMatillionComponentImplementationId();
        final java.lang.Object other$matillionComponentImplementationId = other.getMatillionComponentImplementationId();
        if (this$matillionComponentImplementationId == null ? other$matillionComponentImplementationId != null : !this$matillionComponentImplementationId.equals(other$matillionComponentImplementationId)) return false;
        final java.lang.Object this$matillionComponentLastFiveRunStatus = this.getMatillionComponentLastFiveRunStatus();
        final java.lang.Object other$matillionComponentLastFiveRunStatus = other.getMatillionComponentLastFiveRunStatus();
        if (this$matillionComponentLastFiveRunStatus == null ? other$matillionComponentLastFiveRunStatus != null : !this$matillionComponentLastFiveRunStatus.equals(other$matillionComponentLastFiveRunStatus)) return false;
        final java.lang.Object this$matillionComponentLastRunStatus = this.getMatillionComponentLastRunStatus();
        final java.lang.Object other$matillionComponentLastRunStatus = other.getMatillionComponentLastRunStatus();
        if (this$matillionComponentLastRunStatus == null ? other$matillionComponentLastRunStatus != null : !this$matillionComponentLastRunStatus.equals(other$matillionComponentLastRunStatus)) return false;
        final java.lang.Object this$matillionComponentLinkedJob = this.getMatillionComponentLinkedJob();
        final java.lang.Object other$matillionComponentLinkedJob = other.getMatillionComponentLinkedJob();
        if (this$matillionComponentLinkedJob == null ? other$matillionComponentLinkedJob != null : !this$matillionComponentLinkedJob.equals(other$matillionComponentLinkedJob)) return false;
        final java.lang.Object this$matillionComponentSqls = this.getMatillionComponentSqls();
        final java.lang.Object other$matillionComponentSqls = other.getMatillionComponentSqls();
        if (this$matillionComponentSqls == null ? other$matillionComponentSqls != null : !this$matillionComponentSqls.equals(other$matillionComponentSqls)) return false;
        final java.lang.Object this$matillionJob = this.getMatillionJob();
        final java.lang.Object other$matillionJob = other.getMatillionJob();
        if (this$matillionJob == null ? other$matillionJob != null : !this$matillionJob.equals(other$matillionJob)) return false;
        final java.lang.Object this$matillionJobName = this.getMatillionJobName();
        final java.lang.Object other$matillionJobName = other.getMatillionJobName();
        if (this$matillionJobName == null ? other$matillionJobName != null : !this$matillionJobName.equals(other$matillionJobName)) return false;
        final java.lang.Object this$matillionJobQualifiedName = this.getMatillionJobQualifiedName();
        final java.lang.Object other$matillionJobQualifiedName = other.getMatillionJobQualifiedName();
        if (this$matillionJobQualifiedName == null ? other$matillionJobQualifiedName != null : !this$matillionJobQualifiedName.equals(other$matillionJobQualifiedName)) return false;
        final java.lang.Object this$matillionProcess = this.getMatillionProcess();
        final java.lang.Object other$matillionProcess = other.getMatillionProcess();
        if (this$matillionProcess == null ? other$matillionProcess != null : !this$matillionProcess.equals(other$matillionProcess)) return false;
        final java.lang.Object this$matillionVersion = this.getMatillionVersion();
        final java.lang.Object other$matillionVersion = other.getMatillionVersion();
        if (this$matillionVersion == null ? other$matillionVersion != null : !this$matillionVersion.equals(other$matillionVersion)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MatillionComponent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $matillionComponentId = this.getMatillionComponentId();
        result = result * PRIME + ($matillionComponentId == null ? 43 : $matillionComponentId.hashCode());
        final java.lang.Object $matillionComponentImplementationId = this.getMatillionComponentImplementationId();
        result = result * PRIME + ($matillionComponentImplementationId == null ? 43 : $matillionComponentImplementationId.hashCode());
        final java.lang.Object $matillionComponentLastFiveRunStatus = this.getMatillionComponentLastFiveRunStatus();
        result = result * PRIME + ($matillionComponentLastFiveRunStatus == null ? 43 : $matillionComponentLastFiveRunStatus.hashCode());
        final java.lang.Object $matillionComponentLastRunStatus = this.getMatillionComponentLastRunStatus();
        result = result * PRIME + ($matillionComponentLastRunStatus == null ? 43 : $matillionComponentLastRunStatus.hashCode());
        final java.lang.Object $matillionComponentLinkedJob = this.getMatillionComponentLinkedJob();
        result = result * PRIME + ($matillionComponentLinkedJob == null ? 43 : $matillionComponentLinkedJob.hashCode());
        final java.lang.Object $matillionComponentSqls = this.getMatillionComponentSqls();
        result = result * PRIME + ($matillionComponentSqls == null ? 43 : $matillionComponentSqls.hashCode());
        final java.lang.Object $matillionJob = this.getMatillionJob();
        result = result * PRIME + ($matillionJob == null ? 43 : $matillionJob.hashCode());
        final java.lang.Object $matillionJobName = this.getMatillionJobName();
        result = result * PRIME + ($matillionJobName == null ? 43 : $matillionJobName.hashCode());
        final java.lang.Object $matillionJobQualifiedName = this.getMatillionJobQualifiedName();
        result = result * PRIME + ($matillionJobQualifiedName == null ? 43 : $matillionJobQualifiedName.hashCode());
        final java.lang.Object $matillionProcess = this.getMatillionProcess();
        result = result * PRIME + ($matillionProcess == null ? 43 : $matillionProcess.hashCode());
        final java.lang.Object $matillionVersion = this.getMatillionVersion();
        result = result * PRIME + ($matillionVersion == null ? 43 : $matillionVersion.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MatillionComponent(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", matillionComponentId=" + this.getMatillionComponentId() + ", matillionComponentImplementationId=" + this.getMatillionComponentImplementationId() + ", matillionComponentLastFiveRunStatus=" + this.getMatillionComponentLastFiveRunStatus() + ", matillionComponentLastRunStatus=" + this.getMatillionComponentLastRunStatus() + ", matillionComponentLinkedJob=" + this.getMatillionComponentLinkedJob() + ", matillionComponentSqls=" + this.getMatillionComponentSqls() + ", matillionJob=" + this.getMatillionJob() + ", matillionJobName=" + this.getMatillionJobName() + ", matillionJobQualifiedName=" + this.getMatillionJobQualifiedName() + ", matillionProcess=" + this.getMatillionProcess() + ", matillionVersion=" + this.getMatillionVersion() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for MatillionComponents.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
