// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Matillion project in Atlan. A project in Matillion is a logical grouping of configuration settings and jobs which are responsible for data processing and transformation.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class MatillionProject extends Asset implements IMatillionProject, IMatillion, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MatillionProject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MatillionProject";
    /**
     * Fixed typeName for MatillionProjects.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * List of environments in the project.
     */
    @Attribute
    SortedSet<String> matillionEnvironments;
    /**
     * Matillion group in which the project exists.
     */
    @Attribute
    IMatillionGroup matillionGroup;
    /**
     * Simple name of the Matillion group to which the project belongs.
     */
    @Attribute
    String matillionGroupName;
    /**
     * Unique name of the Matillion group to which the project belongs.
     */
    @Attribute
    String matillionGroupQualifiedName;
    /**
     * Jobs that exist within this project.
     */
    @Attribute
    SortedSet<IMatillionJob> matillionJobs;
    /**
     * Number of jobs in the project.
     */
    @Attribute
    Long matillionProjectJobCount;
    /**
     * Current point in time state of a project.
     */
    @Attribute
    String matillionVersion;
    /**
     * List of versions in the project.
     */
    @Attribute
    SortedSet<String> matillionVersions;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a MatillionProject, from a potentially
     * more-complete MatillionProject object.
     *
     * @return the minimal object necessary to relate to the MatillionProject
     * @throws InvalidRequestException if any of the minimal set of required properties for a MatillionProject relationship are not found in the initial object
     */
    @Override
    public MatillionProject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all MatillionProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MatillionProject assets will be included.
     *
     * @return a fluent search that includes all MatillionProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all MatillionProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MatillionProject assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all MatillionProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all MatillionProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) MatillionProjects will be included
     * @return a fluent search that includes all MatillionProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all MatillionProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) MatillionProjects will be included
     * @return a fluent search that includes all MatillionProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a MatillionProject by GUID. Use this to create a relationship to this MatillionProject,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the MatillionProject to reference
     * @return reference to a MatillionProject that can be used for defining a relationship to a MatillionProject
     */
    public static MatillionProject refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MatillionProject by GUID. Use this to create a relationship to this MatillionProject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the MatillionProject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MatillionProject that can be used for defining a relationship to a MatillionProject
     */
    public static MatillionProject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return MatillionProject._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a MatillionProject by qualifiedName. Use this to create a relationship to this MatillionProject,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the MatillionProject to reference
     * @return reference to a MatillionProject that can be used for defining a relationship to a MatillionProject
     */
    public static MatillionProject refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MatillionProject by qualifiedName. Use this to create a relationship to this MatillionProject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the MatillionProject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MatillionProject that can be used for defining a relationship to a MatillionProject
     */
    public static MatillionProject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return MatillionProject._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a MatillionProject by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the MatillionProject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MatillionProject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MatillionProject does not exist or the provided GUID is not a MatillionProject
     */
    @JsonIgnore
    public static MatillionProject get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a MatillionProject by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MatillionProject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MatillionProject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MatillionProject does not exist or the provided GUID is not a MatillionProject
     */
    @JsonIgnore
    public static MatillionProject get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a MatillionProject by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MatillionProject to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full MatillionProject, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MatillionProject does not exist or the provided GUID is not a MatillionProject
     */
    @JsonIgnore
    public static MatillionProject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof MatillionProject) {
                return (MatillionProject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof MatillionProject) {
                return (MatillionProject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) MatillionProject to active.
     *
     * @param qualifiedName for the MatillionProject
     * @return true if the MatillionProject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) MatillionProject to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the MatillionProject
     * @return true if the MatillionProject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the minimal request necessary to update the MatillionProject, as a builder
     */
    public static MatillionProjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return MatillionProject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a MatillionProject, from a potentially
     * more-complete MatillionProject object.
     *
     * @return the minimal object necessary to update the MatillionProject, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for MatillionProject are not found in the initial object
     */
    @Override
    public MatillionProjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a MatillionProject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionProject) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a MatillionProject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionProject) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a MatillionProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MatillionProject's owners
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionProject) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MatillionProject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a MatillionProject.
     *
     * @param client connectivity to the Atlan tenant on which to update the MatillionProject's certificate
     * @param qualifiedName of the MatillionProject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MatillionProject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MatillionProject) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a MatillionProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MatillionProject's certificate
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionProject) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a MatillionProject.
     *
     * @param client connectivity to the Atlan tenant on which to update the MatillionProject's announcement
     * @param qualifiedName of the MatillionProject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MatillionProject) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a MatillionProject.
     *
     * @param client connectivity to the Atlan client from which to remove the MatillionProject's announcement
     * @param qualifiedName of the MatillionProject
     * @param name of the MatillionProject
     * @return the updated MatillionProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MatillionProject) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the MatillionProject.
     *
     * @param qualifiedName for the MatillionProject
     * @param name human-readable name of the MatillionProject
     * @param terms the list of terms to replace on the MatillionProject, or null to remove all terms from the MatillionProject
     * @return the MatillionProject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionProject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the MatillionProject.
     *
     * @param client connectivity to the Atlan tenant on which to replace the MatillionProject's assigned terms
     * @param qualifiedName for the MatillionProject
     * @param name human-readable name of the MatillionProject
     * @param terms the list of terms to replace on the MatillionProject, or null to remove all terms from the MatillionProject
     * @return the MatillionProject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionProject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionProject) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the MatillionProject, without replacing existing terms linked to the MatillionProject.
     * Note: this operation must make two API calls — one to retrieve the MatillionProject's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the MatillionProject
     * @param terms the list of terms to append to the MatillionProject
     * @return the MatillionProject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionProject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the MatillionProject, without replacing existing terms linked to the MatillionProject.
     * Note: this operation must make two API calls — one to retrieve the MatillionProject's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the MatillionProject
     * @param qualifiedName for the MatillionProject
     * @param terms the list of terms to append to the MatillionProject
     * @return the MatillionProject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionProject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionProject) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a MatillionProject, without replacing all existing terms linked to the MatillionProject.
     * Note: this operation must make two API calls — one to retrieve the MatillionProject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the MatillionProject
     * @param terms the list of terms to remove from the MatillionProject, which must be referenced by GUID
     * @return the MatillionProject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a MatillionProject, without replacing all existing terms linked to the MatillionProject.
     * Note: this operation must make two API calls — one to retrieve the MatillionProject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the MatillionProject
     * @param qualifiedName for the MatillionProject
     * @param terms the list of terms to remove from the MatillionProject, which must be referenced by GUID
     * @return the MatillionProject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MatillionProject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MatillionProject) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a MatillionProject, without replacing existing Atlan tags linked to the MatillionProject.
     * Note: this operation must make two API calls — one to retrieve the MatillionProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MatillionProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MatillionProject
     */
    public static MatillionProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MatillionProject, without replacing existing Atlan tags linked to the MatillionProject.
     * Note: this operation must make two API calls — one to retrieve the MatillionProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MatillionProject
     * @param qualifiedName of the MatillionProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MatillionProject
     */
    public static MatillionProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MatillionProject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MatillionProject, without replacing existing Atlan tags linked to the MatillionProject.
     * Note: this operation must make two API calls — one to retrieve the MatillionProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MatillionProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MatillionProject
     */
    public static MatillionProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a MatillionProject, without replacing existing Atlan tags linked to the MatillionProject.
     * Note: this operation must make two API calls — one to retrieve the MatillionProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MatillionProject
     * @param qualifiedName of the MatillionProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MatillionProject
     */
    public static MatillionProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MatillionProject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a MatillionProject.
     *
     * @param qualifiedName of the MatillionProject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MatillionProject
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a MatillionProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a MatillionProject
     * @param qualifiedName of the MatillionProject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MatillionProject
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MatillionProjectBuilder<C extends MatillionProject, B extends MatillionProject.MatillionProjectBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> matillionEnvironments;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMatillionGroup matillionGroup;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionGroupName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionGroupQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMatillionJob> matillionJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long matillionProjectJobCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String matillionVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> matillionVersions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MatillionProject.MatillionProjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final MatillionProject instance, final MatillionProject.MatillionProjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.matillionEnvironments(instance.matillionEnvironments == null ? java.util.Collections.<String>emptySortedSet() : instance.matillionEnvironments);
            b.matillionGroup(instance.matillionGroup);
            b.matillionGroupName(instance.matillionGroupName);
            b.matillionGroupQualifiedName(instance.matillionGroupQualifiedName);
            b.matillionJobs(instance.matillionJobs == null ? java.util.Collections.<IMatillionJob>emptySortedSet() : instance.matillionJobs);
            b.matillionProjectJobCount(instance.matillionProjectJobCount);
            b.matillionVersion(instance.matillionVersion);
            b.matillionVersions(instance.matillionVersions == null ? java.util.Collections.<String>emptySortedSet() : instance.matillionVersions);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for MatillionProjects.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionEnvironment(final String matillionEnvironment) {
            if (this.matillionEnvironments == null) this.matillionEnvironments = new java.util.ArrayList<String>();
            this.matillionEnvironments.add(matillionEnvironment);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionEnvironments(final java.util.Collection<? extends String> matillionEnvironments) {
            if (matillionEnvironments == null) {
                throw new java.lang.NullPointerException("matillionEnvironments cannot be null");
            }
            if (this.matillionEnvironments == null) this.matillionEnvironments = new java.util.ArrayList<String>();
            this.matillionEnvironments.addAll(matillionEnvironments);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMatillionEnvironments() {
            if (this.matillionEnvironments != null) this.matillionEnvironments.clear();
            return self();
        }

        /**
         * Matillion group in which the project exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionGroup(final IMatillionGroup matillionGroup) {
            this.matillionGroup = matillionGroup;
            return self();
        }

        /**
         * Simple name of the Matillion group to which the project belongs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionGroupName(final String matillionGroupName) {
            this.matillionGroupName = matillionGroupName;
            return self();
        }

        /**
         * Unique name of the Matillion group to which the project belongs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionGroupQualifiedName(final String matillionGroupQualifiedName) {
            this.matillionGroupQualifiedName = matillionGroupQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionJob(final IMatillionJob matillionJob) {
            if (this.matillionJobs == null) this.matillionJobs = new java.util.ArrayList<IMatillionJob>();
            this.matillionJobs.add(matillionJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionJobs(final java.util.Collection<? extends IMatillionJob> matillionJobs) {
            if (matillionJobs == null) {
                throw new java.lang.NullPointerException("matillionJobs cannot be null");
            }
            if (this.matillionJobs == null) this.matillionJobs = new java.util.ArrayList<IMatillionJob>();
            this.matillionJobs.addAll(matillionJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMatillionJobs() {
            if (this.matillionJobs != null) this.matillionJobs.clear();
            return self();
        }

        /**
         * Number of jobs in the project.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionProjectJobCount(final Long matillionProjectJobCount) {
            this.matillionProjectJobCount = matillionProjectJobCount;
            return self();
        }

        /**
         * Current point in time state of a project.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionVersion(final String matillionVersion) {
            this.matillionVersion = matillionVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addMatillionVersion(final String addMatillionVersion) {
            if (this.matillionVersions == null) this.matillionVersions = new java.util.ArrayList<String>();
            this.matillionVersions.add(addMatillionVersion);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B matillionVersions(final java.util.Collection<? extends String> matillionVersions) {
            if (matillionVersions == null) {
                throw new java.lang.NullPointerException("matillionVersions cannot be null");
            }
            if (this.matillionVersions == null) this.matillionVersions = new java.util.ArrayList<String>();
            this.matillionVersions.addAll(matillionVersions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMatillionVersions() {
            if (this.matillionVersions != null) this.matillionVersions.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "MatillionProject.MatillionProjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", matillionEnvironments=" + this.matillionEnvironments + ", matillionGroup=" + this.matillionGroup + ", matillionGroupName=" + this.matillionGroupName + ", matillionGroupQualifiedName=" + this.matillionGroupQualifiedName + ", matillionJobs=" + this.matillionJobs + ", matillionProjectJobCount=" + this.matillionProjectJobCount + ", matillionVersion=" + this.matillionVersion + ", matillionVersions=" + this.matillionVersions + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class MatillionProjectBuilderImpl extends MatillionProject.MatillionProjectBuilder<MatillionProject, MatillionProject.MatillionProjectBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MatillionProjectBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected MatillionProject.MatillionProjectBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public MatillionProject build() {
            return new MatillionProject(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected MatillionProject(final MatillionProject.MatillionProjectBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = MatillionProject.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<String> matillionEnvironments = new java.util.TreeSet<String>();
        if (b.matillionEnvironments != null) matillionEnvironments.addAll(b.matillionEnvironments);
        matillionEnvironments = java.util.Collections.unmodifiableSortedSet(matillionEnvironments);
        this.matillionEnvironments = matillionEnvironments;
        this.matillionGroup = b.matillionGroup;
        this.matillionGroupName = b.matillionGroupName;
        this.matillionGroupQualifiedName = b.matillionGroupQualifiedName;
        java.util.SortedSet<IMatillionJob> matillionJobs = new java.util.TreeSet<IMatillionJob>();
        if (b.matillionJobs != null) matillionJobs.addAll(b.matillionJobs);
        matillionJobs = java.util.Collections.unmodifiableSortedSet(matillionJobs);
        this.matillionJobs = matillionJobs;
        this.matillionProjectJobCount = b.matillionProjectJobCount;
        this.matillionVersion = b.matillionVersion;
        java.util.SortedSet<String> matillionVersions = new java.util.TreeSet<String>();
        if (b.matillionVersions != null) matillionVersions.addAll(b.matillionVersions);
        matillionVersions = java.util.Collections.unmodifiableSortedSet(matillionVersions);
        this.matillionVersions = matillionVersions;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static MatillionProject.MatillionProjectBuilder<?, ?> _internal() {
        return new MatillionProject.MatillionProjectBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MatillionProject.MatillionProjectBuilder<?, ?> toBuilder() {
        return new MatillionProject.MatillionProjectBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * List of environments in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMatillionEnvironments() {
        return this.matillionEnvironments;
    }

    /**
     * Matillion group in which the project exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMatillionGroup getMatillionGroup() {
        return this.matillionGroup;
    }

    /**
     * Simple name of the Matillion group to which the project belongs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionGroupName() {
        return this.matillionGroupName;
    }

    /**
     * Unique name of the Matillion group to which the project belongs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionGroupQualifiedName() {
        return this.matillionGroupQualifiedName;
    }

    /**
     * Jobs that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMatillionJob> getMatillionJobs() {
        return this.matillionJobs;
    }

    /**
     * Number of jobs in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMatillionProjectJobCount() {
        return this.matillionProjectJobCount;
    }

    /**
     * Current point in time state of a project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMatillionVersion() {
        return this.matillionVersion;
    }

    /**
     * List of versions in the project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMatillionVersions() {
        return this.matillionVersions;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MatillionProject)) return false;
        final MatillionProject other = (MatillionProject) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$matillionProjectJobCount = this.getMatillionProjectJobCount();
        final java.lang.Object other$matillionProjectJobCount = other.getMatillionProjectJobCount();
        if (this$matillionProjectJobCount == null ? other$matillionProjectJobCount != null : !this$matillionProjectJobCount.equals(other$matillionProjectJobCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$matillionEnvironments = this.getMatillionEnvironments();
        final java.lang.Object other$matillionEnvironments = other.getMatillionEnvironments();
        if (this$matillionEnvironments == null ? other$matillionEnvironments != null : !this$matillionEnvironments.equals(other$matillionEnvironments)) return false;
        final java.lang.Object this$matillionGroup = this.getMatillionGroup();
        final java.lang.Object other$matillionGroup = other.getMatillionGroup();
        if (this$matillionGroup == null ? other$matillionGroup != null : !this$matillionGroup.equals(other$matillionGroup)) return false;
        final java.lang.Object this$matillionGroupName = this.getMatillionGroupName();
        final java.lang.Object other$matillionGroupName = other.getMatillionGroupName();
        if (this$matillionGroupName == null ? other$matillionGroupName != null : !this$matillionGroupName.equals(other$matillionGroupName)) return false;
        final java.lang.Object this$matillionGroupQualifiedName = this.getMatillionGroupQualifiedName();
        final java.lang.Object other$matillionGroupQualifiedName = other.getMatillionGroupQualifiedName();
        if (this$matillionGroupQualifiedName == null ? other$matillionGroupQualifiedName != null : !this$matillionGroupQualifiedName.equals(other$matillionGroupQualifiedName)) return false;
        final java.lang.Object this$matillionJobs = this.getMatillionJobs();
        final java.lang.Object other$matillionJobs = other.getMatillionJobs();
        if (this$matillionJobs == null ? other$matillionJobs != null : !this$matillionJobs.equals(other$matillionJobs)) return false;
        final java.lang.Object this$matillionVersion = this.getMatillionVersion();
        final java.lang.Object other$matillionVersion = other.getMatillionVersion();
        if (this$matillionVersion == null ? other$matillionVersion != null : !this$matillionVersion.equals(other$matillionVersion)) return false;
        final java.lang.Object this$matillionVersions = this.getMatillionVersions();
        final java.lang.Object other$matillionVersions = other.getMatillionVersions();
        if (this$matillionVersions == null ? other$matillionVersions != null : !this$matillionVersions.equals(other$matillionVersions)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MatillionProject;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $matillionProjectJobCount = this.getMatillionProjectJobCount();
        result = result * PRIME + ($matillionProjectJobCount == null ? 43 : $matillionProjectJobCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $matillionEnvironments = this.getMatillionEnvironments();
        result = result * PRIME + ($matillionEnvironments == null ? 43 : $matillionEnvironments.hashCode());
        final java.lang.Object $matillionGroup = this.getMatillionGroup();
        result = result * PRIME + ($matillionGroup == null ? 43 : $matillionGroup.hashCode());
        final java.lang.Object $matillionGroupName = this.getMatillionGroupName();
        result = result * PRIME + ($matillionGroupName == null ? 43 : $matillionGroupName.hashCode());
        final java.lang.Object $matillionGroupQualifiedName = this.getMatillionGroupQualifiedName();
        result = result * PRIME + ($matillionGroupQualifiedName == null ? 43 : $matillionGroupQualifiedName.hashCode());
        final java.lang.Object $matillionJobs = this.getMatillionJobs();
        result = result * PRIME + ($matillionJobs == null ? 43 : $matillionJobs.hashCode());
        final java.lang.Object $matillionVersion = this.getMatillionVersion();
        result = result * PRIME + ($matillionVersion == null ? 43 : $matillionVersion.hashCode());
        final java.lang.Object $matillionVersions = this.getMatillionVersions();
        result = result * PRIME + ($matillionVersions == null ? 43 : $matillionVersions.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MatillionProject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", matillionEnvironments=" + this.getMatillionEnvironments() + ", matillionGroup=" + this.getMatillionGroup() + ", matillionGroupName=" + this.getMatillionGroupName() + ", matillionGroupQualifiedName=" + this.getMatillionGroupQualifiedName() + ", matillionJobs=" + this.getMatillionJobs() + ", matillionProjectJobCount=" + this.getMatillionProjectJobCount() + ", matillionVersion=" + this.getMatillionVersion() + ", matillionVersions=" + this.getMatillionVersions() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for MatillionProjects.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
