// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.model.core.AtlanObject;
import java.util.Comparator;
import lombok.*;

/**
 * Detailed information about a term related to an asset.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = Meaning.MeaningBuilderImpl.class)
public class Meaning extends AtlanObject implements Comparable<Meaning> {
    private static final long serialVersionUID = 2L;
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<Meaning> meaningComparator = Comparator.comparing(Meaning::getTermGuid, stringComparator).thenComparing(Meaning::getRelationGuid, stringComparator);
    /**
     * Unique identifier (GUID) of the related term.
     */
    String termGuid;
    /**
     * Unique identifier (GUID) of the relationship itself.
     */
    String relationGuid;
    /**
     * Human-readable display name of the related term.
     */
    String displayText;
    /**
     * Unused.
     */
    Integer confidence;

    /**
     * {@inheritDoc}
     */
    @Override
    public int compareTo(Meaning o) {
        return meaningComparator.compare(this, o);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MeaningBuilder<C extends Meaning, B extends Meaning.MeaningBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String termGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String relationGuid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String displayText;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer confidence;

        /**
         * Unique identifier (GUID) of the related term.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B termGuid(final String termGuid) {
            this.termGuid = termGuid;
            return self();
        }

        /**
         * Unique identifier (GUID) of the relationship itself.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationGuid(final String relationGuid) {
            this.relationGuid = relationGuid;
            return self();
        }

        /**
         * Human-readable display name of the related term.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayText(final String displayText) {
            this.displayText = displayText;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B confidence(final Integer confidence) {
            this.confidence = confidence;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Meaning.MeaningBuilder(super=" + super.toString() + ", termGuid=" + this.termGuid + ", relationGuid=" + this.relationGuid + ", displayText=" + this.displayText + ", confidence=" + this.confidence + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class MeaningBuilderImpl extends Meaning.MeaningBuilder<Meaning, Meaning.MeaningBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MeaningBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Meaning.MeaningBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Meaning build() {
            return new Meaning(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Meaning(final Meaning.MeaningBuilder<?, ?> b) {
        super(b);
        this.termGuid = b.termGuid;
        this.relationGuid = b.relationGuid;
        this.displayText = b.displayText;
        this.confidence = b.confidence;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Meaning.MeaningBuilder<?, ?> builder() {
        return new Meaning.MeaningBuilderImpl();
    }

    /**
     * Unique identifier (GUID) of the related term.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTermGuid() {
        return this.termGuid;
    }

    /**
     * Unique identifier (GUID) of the relationship itself.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRelationGuid() {
        return this.relationGuid;
    }

    /**
     * Human-readable display name of the related term.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayText() {
        return this.displayText;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getConfidence() {
        return this.confidence;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Meaning)) return false;
        final Meaning other = (Meaning) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$confidence = this.getConfidence();
        final java.lang.Object other$confidence = other.getConfidence();
        if (this$confidence == null ? other$confidence != null : !this$confidence.equals(other$confidence)) return false;
        final java.lang.Object this$termGuid = this.getTermGuid();
        final java.lang.Object other$termGuid = other.getTermGuid();
        if (this$termGuid == null ? other$termGuid != null : !this$termGuid.equals(other$termGuid)) return false;
        final java.lang.Object this$relationGuid = this.getRelationGuid();
        final java.lang.Object other$relationGuid = other.getRelationGuid();
        if (this$relationGuid == null ? other$relationGuid != null : !this$relationGuid.equals(other$relationGuid)) return false;
        final java.lang.Object this$displayText = this.getDisplayText();
        final java.lang.Object other$displayText = other.getDisplayText();
        if (this$displayText == null ? other$displayText != null : !this$displayText.equals(other$displayText)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Meaning;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $confidence = this.getConfidence();
        result = result * PRIME + ($confidence == null ? 43 : $confidence.hashCode());
        final java.lang.Object $termGuid = this.getTermGuid();
        result = result * PRIME + ($termGuid == null ? 43 : $termGuid.hashCode());
        final java.lang.Object $relationGuid = this.getRelationGuid();
        result = result * PRIME + ($relationGuid == null ? 43 : $relationGuid.hashCode());
        final java.lang.Object $displayText = this.getDisplayText();
        result = result * PRIME + ($displayText == null ? 43 : $displayText.hashCode());
        return result;
    }
}
