// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Metabase collection in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class MetabaseCollection extends Asset implements IMetabaseCollection, IMetabase, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MetabaseCollection.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MetabaseCollection";
    /**
     * Fixed typeName for MetabaseCollections.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Simple name of the Metabase collection in which this asset exists.
     */
    @Attribute
    String metabaseCollectionName;
    /**
     * Unique name of the Metabase collection in which this asset exists.
     */
    @Attribute
    String metabaseCollectionQualifiedName;
    /**
     * TBC
     */
    @Attribute
    String metabaseColor;
    /**
     * Dashboards that exist within this collection.
     */
    @Attribute
    SortedSet<IMetabaseDashboard> metabaseDashboards;
    /**
     * TBC
     */
    @Attribute
    Boolean metabaseIsPersonalCollection;
    /**
     * TBC
     */
    @Attribute
    String metabaseNamespace;
    /**
     * Questions that exist within this collection.
     */
    @Attribute
    SortedSet<IMetabaseQuestion> metabaseQuestions;
    /**
     * TBC
     */
    @Attribute
    String metabaseSlug;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a MetabaseCollection, from a potentially
     * more-complete MetabaseCollection object.
     *
     * @return the minimal object necessary to relate to the MetabaseCollection
     * @throws InvalidRequestException if any of the minimal set of required properties for a MetabaseCollection relationship are not found in the initial object
     */
    @Override
    public MetabaseCollection trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all MetabaseCollection assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MetabaseCollection assets will be included.
     *
     * @return a fluent search that includes all MetabaseCollection assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all MetabaseCollection assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MetabaseCollection assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all MetabaseCollection assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all MetabaseCollection assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) MetabaseCollections will be included
     * @return a fluent search that includes all MetabaseCollection assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all MetabaseCollection assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) MetabaseCollections will be included
     * @return a fluent search that includes all MetabaseCollection assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a MetabaseCollection by GUID. Use this to create a relationship to this MetabaseCollection,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the MetabaseCollection to reference
     * @return reference to a MetabaseCollection that can be used for defining a relationship to a MetabaseCollection
     */
    public static MetabaseCollection refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MetabaseCollection by GUID. Use this to create a relationship to this MetabaseCollection,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the MetabaseCollection to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MetabaseCollection that can be used for defining a relationship to a MetabaseCollection
     */
    public static MetabaseCollection refByGuid(String guid, Reference.SaveSemantic semantic) {
        return MetabaseCollection._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a MetabaseCollection by qualifiedName. Use this to create a relationship to this MetabaseCollection,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the MetabaseCollection to reference
     * @return reference to a MetabaseCollection that can be used for defining a relationship to a MetabaseCollection
     */
    public static MetabaseCollection refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MetabaseCollection by qualifiedName. Use this to create a relationship to this MetabaseCollection,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the MetabaseCollection to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MetabaseCollection that can be used for defining a relationship to a MetabaseCollection
     */
    public static MetabaseCollection refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return MetabaseCollection._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a MetabaseCollection by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the MetabaseCollection to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MetabaseCollection, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MetabaseCollection does not exist or the provided GUID is not a MetabaseCollection
     */
    @JsonIgnore
    public static MetabaseCollection get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a MetabaseCollection by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MetabaseCollection to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MetabaseCollection, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MetabaseCollection does not exist or the provided GUID is not a MetabaseCollection
     */
    @JsonIgnore
    public static MetabaseCollection get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a MetabaseCollection by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MetabaseCollection to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full MetabaseCollection, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MetabaseCollection does not exist or the provided GUID is not a MetabaseCollection
     */
    @JsonIgnore
    public static MetabaseCollection get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof MetabaseCollection) {
                return (MetabaseCollection) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof MetabaseCollection) {
                return (MetabaseCollection) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) MetabaseCollection to active.
     *
     * @param qualifiedName for the MetabaseCollection
     * @return true if the MetabaseCollection is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) MetabaseCollection to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the MetabaseCollection
     * @return true if the MetabaseCollection is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the minimal request necessary to update the MetabaseCollection, as a builder
     */
    public static MetabaseCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return MetabaseCollection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a MetabaseCollection, from a potentially
     * more-complete MetabaseCollection object.
     *
     * @return the minimal object necessary to update the MetabaseCollection, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for MetabaseCollection are not found in the initial object
     */
    @Override
    public MetabaseCollectionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a MetabaseCollection.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a MetabaseCollection.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a MetabaseCollection.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MetabaseCollection's owners
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MetabaseCollection, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a MetabaseCollection.
     *
     * @param client connectivity to the Atlan tenant on which to update the MetabaseCollection's certificate
     * @param qualifiedName of the MetabaseCollection
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MetabaseCollection, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MetabaseCollection) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a MetabaseCollection.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MetabaseCollection's certificate
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a MetabaseCollection.
     *
     * @param client connectivity to the Atlan tenant on which to update the MetabaseCollection's announcement
     * @param qualifiedName of the MetabaseCollection
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MetabaseCollection) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a MetabaseCollection.
     *
     * @param client connectivity to the Atlan client from which to remove the MetabaseCollection's announcement
     * @param qualifiedName of the MetabaseCollection
     * @param name of the MetabaseCollection
     * @return the updated MetabaseCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the MetabaseCollection.
     *
     * @param qualifiedName for the MetabaseCollection
     * @param name human-readable name of the MetabaseCollection
     * @param terms the list of terms to replace on the MetabaseCollection, or null to remove all terms from the MetabaseCollection
     * @return the MetabaseCollection that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the MetabaseCollection.
     *
     * @param client connectivity to the Atlan tenant on which to replace the MetabaseCollection's assigned terms
     * @param qualifiedName for the MetabaseCollection
     * @param name human-readable name of the MetabaseCollection
     * @param terms the list of terms to replace on the MetabaseCollection, or null to remove all terms from the MetabaseCollection
     * @return the MetabaseCollection that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the MetabaseCollection, without replacing existing terms linked to the MetabaseCollection.
     * Note: this operation must make two API calls — one to retrieve the MetabaseCollection's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the MetabaseCollection
     * @param terms the list of terms to append to the MetabaseCollection
     * @return the MetabaseCollection that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the MetabaseCollection, without replacing existing terms linked to the MetabaseCollection.
     * Note: this operation must make two API calls — one to retrieve the MetabaseCollection's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the MetabaseCollection
     * @param qualifiedName for the MetabaseCollection
     * @param terms the list of terms to append to the MetabaseCollection
     * @return the MetabaseCollection that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a MetabaseCollection, without replacing all existing terms linked to the MetabaseCollection.
     * Note: this operation must make two API calls — one to retrieve the MetabaseCollection's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the MetabaseCollection
     * @param terms the list of terms to remove from the MetabaseCollection, which must be referenced by GUID
     * @return the MetabaseCollection that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a MetabaseCollection, without replacing all existing terms linked to the MetabaseCollection.
     * Note: this operation must make two API calls — one to retrieve the MetabaseCollection's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the MetabaseCollection
     * @param qualifiedName for the MetabaseCollection
     * @param terms the list of terms to remove from the MetabaseCollection, which must be referenced by GUID
     * @return the MetabaseCollection that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MetabaseCollection removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a MetabaseCollection, without replacing existing Atlan tags linked to the MetabaseCollection.
     * Note: this operation must make two API calls — one to retrieve the MetabaseCollection's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MetabaseCollection
     */
    public static MetabaseCollection appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MetabaseCollection, without replacing existing Atlan tags linked to the MetabaseCollection.
     * Note: this operation must make two API calls — one to retrieve the MetabaseCollection's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MetabaseCollection
     * @param qualifiedName of the MetabaseCollection
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MetabaseCollection
     */
    public static MetabaseCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MetabaseCollection) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MetabaseCollection, without replacing existing Atlan tags linked to the MetabaseCollection.
     * Note: this operation must make two API calls — one to retrieve the MetabaseCollection's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MetabaseCollection
     */
    public static MetabaseCollection appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a MetabaseCollection, without replacing existing Atlan tags linked to the MetabaseCollection.
     * Note: this operation must make two API calls — one to retrieve the MetabaseCollection's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MetabaseCollection
     * @param qualifiedName of the MetabaseCollection
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MetabaseCollection
     */
    public static MetabaseCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MetabaseCollection) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a MetabaseCollection.
     *
     * @param qualifiedName of the MetabaseCollection
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MetabaseCollection
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a MetabaseCollection.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a MetabaseCollection
     * @param qualifiedName of the MetabaseCollection
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MetabaseCollection
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MetabaseCollectionBuilder<C extends MetabaseCollection, B extends MetabaseCollection.MetabaseCollectionBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String metabaseCollectionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String metabaseCollectionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String metabaseColor;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMetabaseDashboard> metabaseDashboards;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean metabaseIsPersonalCollection;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String metabaseNamespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMetabaseQuestion> metabaseQuestions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String metabaseSlug;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MetabaseCollection.MetabaseCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final MetabaseCollection instance, final MetabaseCollection.MetabaseCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.metabaseCollectionName(instance.metabaseCollectionName);
            b.metabaseCollectionQualifiedName(instance.metabaseCollectionQualifiedName);
            b.metabaseColor(instance.metabaseColor);
            b.metabaseDashboards(instance.metabaseDashboards == null ? java.util.Collections.<IMetabaseDashboard>emptySortedSet() : instance.metabaseDashboards);
            b.metabaseIsPersonalCollection(instance.metabaseIsPersonalCollection);
            b.metabaseNamespace(instance.metabaseNamespace);
            b.metabaseQuestions(instance.metabaseQuestions == null ? java.util.Collections.<IMetabaseQuestion>emptySortedSet() : instance.metabaseQuestions);
            b.metabaseSlug(instance.metabaseSlug);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for MetabaseCollections.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Simple name of the Metabase collection in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseCollectionName(final String metabaseCollectionName) {
            this.metabaseCollectionName = metabaseCollectionName;
            return self();
        }

        /**
         * Unique name of the Metabase collection in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseCollectionQualifiedName(final String metabaseCollectionQualifiedName) {
            this.metabaseCollectionQualifiedName = metabaseCollectionQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseColor(final String metabaseColor) {
            this.metabaseColor = metabaseColor;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseDashboard(final IMetabaseDashboard metabaseDashboard) {
            if (this.metabaseDashboards == null) this.metabaseDashboards = new java.util.ArrayList<IMetabaseDashboard>();
            this.metabaseDashboards.add(metabaseDashboard);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseDashboards(final java.util.Collection<? extends IMetabaseDashboard> metabaseDashboards) {
            if (metabaseDashboards == null) {
                throw new java.lang.NullPointerException("metabaseDashboards cannot be null");
            }
            if (this.metabaseDashboards == null) this.metabaseDashboards = new java.util.ArrayList<IMetabaseDashboard>();
            this.metabaseDashboards.addAll(metabaseDashboards);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMetabaseDashboards() {
            if (this.metabaseDashboards != null) this.metabaseDashboards.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseIsPersonalCollection(final Boolean metabaseIsPersonalCollection) {
            this.metabaseIsPersonalCollection = metabaseIsPersonalCollection;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseNamespace(final String metabaseNamespace) {
            this.metabaseNamespace = metabaseNamespace;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseQuestion(final IMetabaseQuestion metabaseQuestion) {
            if (this.metabaseQuestions == null) this.metabaseQuestions = new java.util.ArrayList<IMetabaseQuestion>();
            this.metabaseQuestions.add(metabaseQuestion);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseQuestions(final java.util.Collection<? extends IMetabaseQuestion> metabaseQuestions) {
            if (metabaseQuestions == null) {
                throw new java.lang.NullPointerException("metabaseQuestions cannot be null");
            }
            if (this.metabaseQuestions == null) this.metabaseQuestions = new java.util.ArrayList<IMetabaseQuestion>();
            this.metabaseQuestions.addAll(metabaseQuestions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMetabaseQuestions() {
            if (this.metabaseQuestions != null) this.metabaseQuestions.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metabaseSlug(final String metabaseSlug) {
            this.metabaseSlug = metabaseSlug;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "MetabaseCollection.MetabaseCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", metabaseCollectionName=" + this.metabaseCollectionName + ", metabaseCollectionQualifiedName=" + this.metabaseCollectionQualifiedName + ", metabaseColor=" + this.metabaseColor + ", metabaseDashboards=" + this.metabaseDashboards + ", metabaseIsPersonalCollection=" + this.metabaseIsPersonalCollection + ", metabaseNamespace=" + this.metabaseNamespace + ", metabaseQuestions=" + this.metabaseQuestions + ", metabaseSlug=" + this.metabaseSlug + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class MetabaseCollectionBuilderImpl extends MetabaseCollection.MetabaseCollectionBuilder<MetabaseCollection, MetabaseCollection.MetabaseCollectionBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MetabaseCollectionBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected MetabaseCollection.MetabaseCollectionBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public MetabaseCollection build() {
            return new MetabaseCollection(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected MetabaseCollection(final MetabaseCollection.MetabaseCollectionBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = MetabaseCollection.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.metabaseCollectionName = b.metabaseCollectionName;
        this.metabaseCollectionQualifiedName = b.metabaseCollectionQualifiedName;
        this.metabaseColor = b.metabaseColor;
        java.util.SortedSet<IMetabaseDashboard> metabaseDashboards = new java.util.TreeSet<IMetabaseDashboard>();
        if (b.metabaseDashboards != null) metabaseDashboards.addAll(b.metabaseDashboards);
        metabaseDashboards = java.util.Collections.unmodifiableSortedSet(metabaseDashboards);
        this.metabaseDashboards = metabaseDashboards;
        this.metabaseIsPersonalCollection = b.metabaseIsPersonalCollection;
        this.metabaseNamespace = b.metabaseNamespace;
        java.util.SortedSet<IMetabaseQuestion> metabaseQuestions = new java.util.TreeSet<IMetabaseQuestion>();
        if (b.metabaseQuestions != null) metabaseQuestions.addAll(b.metabaseQuestions);
        metabaseQuestions = java.util.Collections.unmodifiableSortedSet(metabaseQuestions);
        this.metabaseQuestions = metabaseQuestions;
        this.metabaseSlug = b.metabaseSlug;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static MetabaseCollection.MetabaseCollectionBuilder<?, ?> _internal() {
        return new MetabaseCollection.MetabaseCollectionBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MetabaseCollection.MetabaseCollectionBuilder<?, ?> toBuilder() {
        return new MetabaseCollection.MetabaseCollectionBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Simple name of the Metabase collection in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMetabaseCollectionName() {
        return this.metabaseCollectionName;
    }

    /**
     * Unique name of the Metabase collection in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMetabaseCollectionQualifiedName() {
        return this.metabaseCollectionQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMetabaseColor() {
        return this.metabaseColor;
    }

    /**
     * Dashboards that exist within this collection.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMetabaseDashboard> getMetabaseDashboards() {
        return this.metabaseDashboards;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getMetabaseIsPersonalCollection() {
        return this.metabaseIsPersonalCollection;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMetabaseNamespace() {
        return this.metabaseNamespace;
    }

    /**
     * Questions that exist within this collection.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMetabaseQuestion> getMetabaseQuestions() {
        return this.metabaseQuestions;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMetabaseSlug() {
        return this.metabaseSlug;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MetabaseCollection)) return false;
        final MetabaseCollection other = (MetabaseCollection) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$metabaseIsPersonalCollection = this.getMetabaseIsPersonalCollection();
        final java.lang.Object other$metabaseIsPersonalCollection = other.getMetabaseIsPersonalCollection();
        if (this$metabaseIsPersonalCollection == null ? other$metabaseIsPersonalCollection != null : !this$metabaseIsPersonalCollection.equals(other$metabaseIsPersonalCollection)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$metabaseCollectionName = this.getMetabaseCollectionName();
        final java.lang.Object other$metabaseCollectionName = other.getMetabaseCollectionName();
        if (this$metabaseCollectionName == null ? other$metabaseCollectionName != null : !this$metabaseCollectionName.equals(other$metabaseCollectionName)) return false;
        final java.lang.Object this$metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        final java.lang.Object other$metabaseCollectionQualifiedName = other.getMetabaseCollectionQualifiedName();
        if (this$metabaseCollectionQualifiedName == null ? other$metabaseCollectionQualifiedName != null : !this$metabaseCollectionQualifiedName.equals(other$metabaseCollectionQualifiedName)) return false;
        final java.lang.Object this$metabaseColor = this.getMetabaseColor();
        final java.lang.Object other$metabaseColor = other.getMetabaseColor();
        if (this$metabaseColor == null ? other$metabaseColor != null : !this$metabaseColor.equals(other$metabaseColor)) return false;
        final java.lang.Object this$metabaseDashboards = this.getMetabaseDashboards();
        final java.lang.Object other$metabaseDashboards = other.getMetabaseDashboards();
        if (this$metabaseDashboards == null ? other$metabaseDashboards != null : !this$metabaseDashboards.equals(other$metabaseDashboards)) return false;
        final java.lang.Object this$metabaseNamespace = this.getMetabaseNamespace();
        final java.lang.Object other$metabaseNamespace = other.getMetabaseNamespace();
        if (this$metabaseNamespace == null ? other$metabaseNamespace != null : !this$metabaseNamespace.equals(other$metabaseNamespace)) return false;
        final java.lang.Object this$metabaseQuestions = this.getMetabaseQuestions();
        final java.lang.Object other$metabaseQuestions = other.getMetabaseQuestions();
        if (this$metabaseQuestions == null ? other$metabaseQuestions != null : !this$metabaseQuestions.equals(other$metabaseQuestions)) return false;
        final java.lang.Object this$metabaseSlug = this.getMetabaseSlug();
        final java.lang.Object other$metabaseSlug = other.getMetabaseSlug();
        if (this$metabaseSlug == null ? other$metabaseSlug != null : !this$metabaseSlug.equals(other$metabaseSlug)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MetabaseCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $metabaseIsPersonalCollection = this.getMetabaseIsPersonalCollection();
        result = result * PRIME + ($metabaseIsPersonalCollection == null ? 43 : $metabaseIsPersonalCollection.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $metabaseCollectionName = this.getMetabaseCollectionName();
        result = result * PRIME + ($metabaseCollectionName == null ? 43 : $metabaseCollectionName.hashCode());
        final java.lang.Object $metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        result = result * PRIME + ($metabaseCollectionQualifiedName == null ? 43 : $metabaseCollectionQualifiedName.hashCode());
        final java.lang.Object $metabaseColor = this.getMetabaseColor();
        result = result * PRIME + ($metabaseColor == null ? 43 : $metabaseColor.hashCode());
        final java.lang.Object $metabaseDashboards = this.getMetabaseDashboards();
        result = result * PRIME + ($metabaseDashboards == null ? 43 : $metabaseDashboards.hashCode());
        final java.lang.Object $metabaseNamespace = this.getMetabaseNamespace();
        result = result * PRIME + ($metabaseNamespace == null ? 43 : $metabaseNamespace.hashCode());
        final java.lang.Object $metabaseQuestions = this.getMetabaseQuestions();
        result = result * PRIME + ($metabaseQuestions == null ? 43 : $metabaseQuestions.hashCode());
        final java.lang.Object $metabaseSlug = this.getMetabaseSlug();
        result = result * PRIME + ($metabaseSlug == null ? 43 : $metabaseSlug.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MetabaseCollection(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", metabaseCollectionName=" + this.getMetabaseCollectionName() + ", metabaseCollectionQualifiedName=" + this.getMetabaseCollectionQualifiedName() + ", metabaseColor=" + this.getMetabaseColor() + ", metabaseDashboards=" + this.getMetabaseDashboards() + ", metabaseIsPersonalCollection=" + this.getMetabaseIsPersonalCollection() + ", metabaseNamespace=" + this.getMetabaseNamespace() + ", metabaseQuestions=" + this.getMetabaseQuestions() + ", metabaseSlug=" + this.getMetabaseSlug() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for MetabaseCollections.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
