// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a MicroStrategy document in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class MicroStrategyDocument extends Asset implements IMicroStrategyDocument, IMicroStrategy, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MicroStrategyDocument.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MicroStrategyDocument";
    /**
     * Fixed typeName for MicroStrategyDocuments.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
     */
    @Attribute
    @Date
    Long microStrategyCertifiedAt;
    /**
     * User who certified this asset, in MicroStrategy.
     */
    @Attribute
    String microStrategyCertifiedBy;
    /**
     * Simple names of the cubes related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyCubeNames;
    /**
     * Unique names of the cubes related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyCubeQualifiedNames;
    /**
     * Whether the asset is certified in MicroStrategy (true) or not (false).
     */
    @Attribute
    Boolean microStrategyIsCertified;
    /**
     * Location of this asset in MicroStrategy.
     */
    @Attribute
    List<Map<String, String>> microStrategyLocation;
    /**
     * Project in which this document exists.
     */
    @Attribute
    IMicroStrategyProject microStrategyProject;
    /**
     * Simple name of the project in which this asset exists.
     */
    @Attribute
    String microStrategyProjectName;
    /**
     * Unique name of the project in which this asset exists.
     */
    @Attribute
    String microStrategyProjectQualifiedName;
    /**
     * Simple names of the reports related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyReportNames;
    /**
     * Unique names of the reports related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyReportQualifiedNames;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a MicroStrategyDocument, from a potentially
     * more-complete MicroStrategyDocument object.
     *
     * @return the minimal object necessary to relate to the MicroStrategyDocument
     * @throws InvalidRequestException if any of the minimal set of required properties for a MicroStrategyDocument relationship are not found in the initial object
     */
    @Override
    public MicroStrategyDocument trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all MicroStrategyDocument assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MicroStrategyDocument assets will be included.
     *
     * @return a fluent search that includes all MicroStrategyDocument assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all MicroStrategyDocument assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MicroStrategyDocument assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all MicroStrategyDocument assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all MicroStrategyDocument assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) MicroStrategyDocuments will be included
     * @return a fluent search that includes all MicroStrategyDocument assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all MicroStrategyDocument assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) MicroStrategyDocuments will be included
     * @return a fluent search that includes all MicroStrategyDocument assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a MicroStrategyDocument by GUID. Use this to create a relationship to this MicroStrategyDocument,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the MicroStrategyDocument to reference
     * @return reference to a MicroStrategyDocument that can be used for defining a relationship to a MicroStrategyDocument
     */
    public static MicroStrategyDocument refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MicroStrategyDocument by GUID. Use this to create a relationship to this MicroStrategyDocument,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the MicroStrategyDocument to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MicroStrategyDocument that can be used for defining a relationship to a MicroStrategyDocument
     */
    public static MicroStrategyDocument refByGuid(String guid, Reference.SaveSemantic semantic) {
        return MicroStrategyDocument._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a MicroStrategyDocument by qualifiedName. Use this to create a relationship to this MicroStrategyDocument,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the MicroStrategyDocument to reference
     * @return reference to a MicroStrategyDocument that can be used for defining a relationship to a MicroStrategyDocument
     */
    public static MicroStrategyDocument refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MicroStrategyDocument by qualifiedName. Use this to create a relationship to this MicroStrategyDocument,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the MicroStrategyDocument to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MicroStrategyDocument that can be used for defining a relationship to a MicroStrategyDocument
     */
    public static MicroStrategyDocument refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return MicroStrategyDocument._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a MicroStrategyDocument by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the MicroStrategyDocument to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MicroStrategyDocument, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyDocument does not exist or the provided GUID is not a MicroStrategyDocument
     */
    @JsonIgnore
    public static MicroStrategyDocument get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a MicroStrategyDocument by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MicroStrategyDocument to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MicroStrategyDocument, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyDocument does not exist or the provided GUID is not a MicroStrategyDocument
     */
    @JsonIgnore
    public static MicroStrategyDocument get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a MicroStrategyDocument by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MicroStrategyDocument to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full MicroStrategyDocument, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyDocument does not exist or the provided GUID is not a MicroStrategyDocument
     */
    @JsonIgnore
    public static MicroStrategyDocument get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof MicroStrategyDocument) {
                return (MicroStrategyDocument) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof MicroStrategyDocument) {
                return (MicroStrategyDocument) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) MicroStrategyDocument to active.
     *
     * @param qualifiedName for the MicroStrategyDocument
     * @return true if the MicroStrategyDocument is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) MicroStrategyDocument to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the MicroStrategyDocument
     * @return true if the MicroStrategyDocument is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the minimal request necessary to update the MicroStrategyDocument, as a builder
     */
    public static MicroStrategyDocumentBuilder<?, ?> updater(String qualifiedName, String name) {
        return MicroStrategyDocument._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a MicroStrategyDocument, from a potentially
     * more-complete MicroStrategyDocument object.
     *
     * @return the minimal object necessary to update the MicroStrategyDocument, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for MicroStrategyDocument are not found in the initial object
     */
    @Override
    public MicroStrategyDocumentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyDocument) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyDocument) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MicroStrategyDocument's owners
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyDocument) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MicroStrategyDocument, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan tenant on which to update the MicroStrategyDocument's certificate
     * @param qualifiedName of the MicroStrategyDocument
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MicroStrategyDocument, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MicroStrategyDocument) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MicroStrategyDocument's certificate
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyDocument) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan tenant on which to update the MicroStrategyDocument's announcement
     * @param qualifiedName of the MicroStrategyDocument
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MicroStrategyDocument) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan client from which to remove the MicroStrategyDocument's announcement
     * @param qualifiedName of the MicroStrategyDocument
     * @param name of the MicroStrategyDocument
     * @return the updated MicroStrategyDocument, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyDocument) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the MicroStrategyDocument.
     *
     * @param qualifiedName for the MicroStrategyDocument
     * @param name human-readable name of the MicroStrategyDocument
     * @param terms the list of terms to replace on the MicroStrategyDocument, or null to remove all terms from the MicroStrategyDocument
     * @return the MicroStrategyDocument that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan tenant on which to replace the MicroStrategyDocument's assigned terms
     * @param qualifiedName for the MicroStrategyDocument
     * @param name human-readable name of the MicroStrategyDocument
     * @param terms the list of terms to replace on the MicroStrategyDocument, or null to remove all terms from the MicroStrategyDocument
     * @return the MicroStrategyDocument that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyDocument) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the MicroStrategyDocument, without replacing existing terms linked to the MicroStrategyDocument.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyDocument's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the MicroStrategyDocument
     * @param terms the list of terms to append to the MicroStrategyDocument
     * @return the MicroStrategyDocument that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the MicroStrategyDocument, without replacing existing terms linked to the MicroStrategyDocument.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyDocument's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the MicroStrategyDocument
     * @param qualifiedName for the MicroStrategyDocument
     * @param terms the list of terms to append to the MicroStrategyDocument
     * @return the MicroStrategyDocument that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyDocument) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a MicroStrategyDocument, without replacing all existing terms linked to the MicroStrategyDocument.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyDocument's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the MicroStrategyDocument
     * @param terms the list of terms to remove from the MicroStrategyDocument, which must be referenced by GUID
     * @return the MicroStrategyDocument that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a MicroStrategyDocument, without replacing all existing terms linked to the MicroStrategyDocument.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyDocument's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the MicroStrategyDocument
     * @param qualifiedName for the MicroStrategyDocument
     * @param terms the list of terms to remove from the MicroStrategyDocument, which must be referenced by GUID
     * @return the MicroStrategyDocument that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyDocument removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyDocument) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a MicroStrategyDocument, without replacing existing Atlan tags linked to the MicroStrategyDocument.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyDocument's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyDocument
     */
    public static MicroStrategyDocument appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MicroStrategyDocument, without replacing existing Atlan tags linked to the MicroStrategyDocument.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyDocument's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MicroStrategyDocument
     * @param qualifiedName of the MicroStrategyDocument
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyDocument
     */
    public static MicroStrategyDocument appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MicroStrategyDocument) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MicroStrategyDocument, without replacing existing Atlan tags linked to the MicroStrategyDocument.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyDocument's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyDocument
     */
    public static MicroStrategyDocument appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a MicroStrategyDocument, without replacing existing Atlan tags linked to the MicroStrategyDocument.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyDocument's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MicroStrategyDocument
     * @param qualifiedName of the MicroStrategyDocument
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyDocument
     */
    public static MicroStrategyDocument appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MicroStrategyDocument) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a MicroStrategyDocument.
     *
     * @param qualifiedName of the MicroStrategyDocument
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MicroStrategyDocument
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a MicroStrategyDocument.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a MicroStrategyDocument
     * @param qualifiedName of the MicroStrategyDocument
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MicroStrategyDocument
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MicroStrategyDocumentBuilder<C extends MicroStrategyDocument, B extends MicroStrategyDocument.MicroStrategyDocumentBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long microStrategyCertifiedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyCertifiedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyCubeNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyCubeQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean microStrategyIsCertified;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> microStrategyLocation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMicroStrategyProject microStrategyProject;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyProjectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyProjectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyReportNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyReportQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MicroStrategyDocument.MicroStrategyDocumentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final MicroStrategyDocument instance, final MicroStrategyDocument.MicroStrategyDocumentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.microStrategyCertifiedAt(instance.microStrategyCertifiedAt);
            b.microStrategyCertifiedBy(instance.microStrategyCertifiedBy);
            b.microStrategyCubeNames(instance.microStrategyCubeNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyCubeNames);
            b.microStrategyCubeQualifiedNames(instance.microStrategyCubeQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyCubeQualifiedNames);
            b.microStrategyIsCertified(instance.microStrategyIsCertified);
            b.microStrategyLocation(instance.microStrategyLocation == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.microStrategyLocation);
            b.microStrategyProject(instance.microStrategyProject);
            b.microStrategyProjectName(instance.microStrategyProjectName);
            b.microStrategyProjectQualifiedName(instance.microStrategyProjectQualifiedName);
            b.microStrategyReportNames(instance.microStrategyReportNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyReportNames);
            b.microStrategyReportQualifiedNames(instance.microStrategyReportQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyReportQualifiedNames);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for MicroStrategyDocuments.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCertifiedAt(final Long microStrategyCertifiedAt) {
            this.microStrategyCertifiedAt = microStrategyCertifiedAt;
            return self();
        }

        /**
         * User who certified this asset, in MicroStrategy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCertifiedBy(final String microStrategyCertifiedBy) {
            this.microStrategyCertifiedBy = microStrategyCertifiedBy;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeName(final String microStrategyCubeName) {
            if (this.microStrategyCubeNames == null) this.microStrategyCubeNames = new java.util.ArrayList<String>();
            this.microStrategyCubeNames.add(microStrategyCubeName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeNames(final java.util.Collection<? extends String> microStrategyCubeNames) {
            if (microStrategyCubeNames == null) {
                throw new java.lang.NullPointerException("microStrategyCubeNames cannot be null");
            }
            if (this.microStrategyCubeNames == null) this.microStrategyCubeNames = new java.util.ArrayList<String>();
            this.microStrategyCubeNames.addAll(microStrategyCubeNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyCubeNames() {
            if (this.microStrategyCubeNames != null) this.microStrategyCubeNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeQualifiedName(final String microStrategyCubeQualifiedName) {
            if (this.microStrategyCubeQualifiedNames == null) this.microStrategyCubeQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyCubeQualifiedNames.add(microStrategyCubeQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeQualifiedNames(final java.util.Collection<? extends String> microStrategyCubeQualifiedNames) {
            if (microStrategyCubeQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyCubeQualifiedNames cannot be null");
            }
            if (this.microStrategyCubeQualifiedNames == null) this.microStrategyCubeQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyCubeQualifiedNames.addAll(microStrategyCubeQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyCubeQualifiedNames() {
            if (this.microStrategyCubeQualifiedNames != null) this.microStrategyCubeQualifiedNames.clear();
            return self();
        }

        /**
         * Whether the asset is certified in MicroStrategy (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyIsCertified(final Boolean microStrategyIsCertified) {
            this.microStrategyIsCertified = microStrategyIsCertified;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putMicroStrategyLocation(final Map<String, String> putMicroStrategyLocation) {
            if (this.microStrategyLocation == null) this.microStrategyLocation = new java.util.ArrayList<Map<String, String>>();
            this.microStrategyLocation.add(putMicroStrategyLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyLocation(final java.util.Collection<? extends Map<String, String>> microStrategyLocation) {
            if (microStrategyLocation == null) {
                throw new java.lang.NullPointerException("microStrategyLocation cannot be null");
            }
            if (this.microStrategyLocation == null) this.microStrategyLocation = new java.util.ArrayList<Map<String, String>>();
            this.microStrategyLocation.addAll(microStrategyLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyLocation() {
            if (this.microStrategyLocation != null) this.microStrategyLocation.clear();
            return self();
        }

        /**
         * Project in which this document exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyProject(final IMicroStrategyProject microStrategyProject) {
            this.microStrategyProject = microStrategyProject;
            return self();
        }

        /**
         * Simple name of the project in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyProjectName(final String microStrategyProjectName) {
            this.microStrategyProjectName = microStrategyProjectName;
            return self();
        }

        /**
         * Unique name of the project in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyProjectQualifiedName(final String microStrategyProjectQualifiedName) {
            this.microStrategyProjectQualifiedName = microStrategyProjectQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportName(final String microStrategyReportName) {
            if (this.microStrategyReportNames == null) this.microStrategyReportNames = new java.util.ArrayList<String>();
            this.microStrategyReportNames.add(microStrategyReportName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportNames(final java.util.Collection<? extends String> microStrategyReportNames) {
            if (microStrategyReportNames == null) {
                throw new java.lang.NullPointerException("microStrategyReportNames cannot be null");
            }
            if (this.microStrategyReportNames == null) this.microStrategyReportNames = new java.util.ArrayList<String>();
            this.microStrategyReportNames.addAll(microStrategyReportNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyReportNames() {
            if (this.microStrategyReportNames != null) this.microStrategyReportNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportQualifiedName(final String microStrategyReportQualifiedName) {
            if (this.microStrategyReportQualifiedNames == null) this.microStrategyReportQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyReportQualifiedNames.add(microStrategyReportQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportQualifiedNames(final java.util.Collection<? extends String> microStrategyReportQualifiedNames) {
            if (microStrategyReportQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyReportQualifiedNames cannot be null");
            }
            if (this.microStrategyReportQualifiedNames == null) this.microStrategyReportQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyReportQualifiedNames.addAll(microStrategyReportQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyReportQualifiedNames() {
            if (this.microStrategyReportQualifiedNames != null) this.microStrategyReportQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "MicroStrategyDocument.MicroStrategyDocumentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", microStrategyCertifiedAt=" + this.microStrategyCertifiedAt + ", microStrategyCertifiedBy=" + this.microStrategyCertifiedBy + ", microStrategyCubeNames=" + this.microStrategyCubeNames + ", microStrategyCubeQualifiedNames=" + this.microStrategyCubeQualifiedNames + ", microStrategyIsCertified=" + this.microStrategyIsCertified + ", microStrategyLocation=" + this.microStrategyLocation + ", microStrategyProject=" + this.microStrategyProject + ", microStrategyProjectName=" + this.microStrategyProjectName + ", microStrategyProjectQualifiedName=" + this.microStrategyProjectQualifiedName + ", microStrategyReportNames=" + this.microStrategyReportNames + ", microStrategyReportQualifiedNames=" + this.microStrategyReportQualifiedNames + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class MicroStrategyDocumentBuilderImpl extends MicroStrategyDocument.MicroStrategyDocumentBuilder<MicroStrategyDocument, MicroStrategyDocument.MicroStrategyDocumentBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MicroStrategyDocumentBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected MicroStrategyDocument.MicroStrategyDocumentBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public MicroStrategyDocument build() {
            return new MicroStrategyDocument(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected MicroStrategyDocument(final MicroStrategyDocument.MicroStrategyDocumentBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = MicroStrategyDocument.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.microStrategyCertifiedAt = b.microStrategyCertifiedAt;
        this.microStrategyCertifiedBy = b.microStrategyCertifiedBy;
        java.util.SortedSet<String> microStrategyCubeNames = new java.util.TreeSet<String>();
        if (b.microStrategyCubeNames != null) microStrategyCubeNames.addAll(b.microStrategyCubeNames);
        microStrategyCubeNames = java.util.Collections.unmodifiableSortedSet(microStrategyCubeNames);
        this.microStrategyCubeNames = microStrategyCubeNames;
        java.util.SortedSet<String> microStrategyCubeQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyCubeQualifiedNames != null) microStrategyCubeQualifiedNames.addAll(b.microStrategyCubeQualifiedNames);
        microStrategyCubeQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyCubeQualifiedNames);
        this.microStrategyCubeQualifiedNames = microStrategyCubeQualifiedNames;
        this.microStrategyIsCertified = b.microStrategyIsCertified;
        java.util.List<Map<String, String>> microStrategyLocation;
        switch (b.microStrategyLocation == null ? 0 : b.microStrategyLocation.size()) {
        case 0: 
            microStrategyLocation = java.util.Collections.emptyList();
            break;
        case 1: 
            microStrategyLocation = java.util.Collections.singletonList(b.microStrategyLocation.get(0));
            break;
        default: 
            microStrategyLocation = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.microStrategyLocation));
        }
        this.microStrategyLocation = microStrategyLocation;
        this.microStrategyProject = b.microStrategyProject;
        this.microStrategyProjectName = b.microStrategyProjectName;
        this.microStrategyProjectQualifiedName = b.microStrategyProjectQualifiedName;
        java.util.SortedSet<String> microStrategyReportNames = new java.util.TreeSet<String>();
        if (b.microStrategyReportNames != null) microStrategyReportNames.addAll(b.microStrategyReportNames);
        microStrategyReportNames = java.util.Collections.unmodifiableSortedSet(microStrategyReportNames);
        this.microStrategyReportNames = microStrategyReportNames;
        java.util.SortedSet<String> microStrategyReportQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyReportQualifiedNames != null) microStrategyReportQualifiedNames.addAll(b.microStrategyReportQualifiedNames);
        microStrategyReportQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyReportQualifiedNames);
        this.microStrategyReportQualifiedNames = microStrategyReportQualifiedNames;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static MicroStrategyDocument.MicroStrategyDocumentBuilder<?, ?> _internal() {
        return new MicroStrategyDocument.MicroStrategyDocumentBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MicroStrategyDocument.MicroStrategyDocumentBuilder<?, ?> toBuilder() {
        return new MicroStrategyDocument.MicroStrategyDocumentBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMicroStrategyCertifiedAt() {
        return this.microStrategyCertifiedAt;
    }

    /**
     * User who certified this asset, in MicroStrategy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyCertifiedBy() {
        return this.microStrategyCertifiedBy;
    }

    /**
     * Simple names of the cubes related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyCubeNames() {
        return this.microStrategyCubeNames;
    }

    /**
     * Unique names of the cubes related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyCubeQualifiedNames() {
        return this.microStrategyCubeQualifiedNames;
    }

    /**
     * Whether the asset is certified in MicroStrategy (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getMicroStrategyIsCertified() {
        return this.microStrategyIsCertified;
    }

    /**
     * Location of this asset in MicroStrategy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getMicroStrategyLocation() {
        return this.microStrategyLocation;
    }

    /**
     * Project in which this document exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMicroStrategyProject getMicroStrategyProject() {
        return this.microStrategyProject;
    }

    /**
     * Simple name of the project in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyProjectName() {
        return this.microStrategyProjectName;
    }

    /**
     * Unique name of the project in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyProjectQualifiedName() {
        return this.microStrategyProjectQualifiedName;
    }

    /**
     * Simple names of the reports related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyReportNames() {
        return this.microStrategyReportNames;
    }

    /**
     * Unique names of the reports related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyReportQualifiedNames() {
        return this.microStrategyReportQualifiedNames;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MicroStrategyDocument)) return false;
        final MicroStrategyDocument other = (MicroStrategyDocument) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$microStrategyCertifiedAt = this.getMicroStrategyCertifiedAt();
        final java.lang.Object other$microStrategyCertifiedAt = other.getMicroStrategyCertifiedAt();
        if (this$microStrategyCertifiedAt == null ? other$microStrategyCertifiedAt != null : !this$microStrategyCertifiedAt.equals(other$microStrategyCertifiedAt)) return false;
        final java.lang.Object this$microStrategyIsCertified = this.getMicroStrategyIsCertified();
        final java.lang.Object other$microStrategyIsCertified = other.getMicroStrategyIsCertified();
        if (this$microStrategyIsCertified == null ? other$microStrategyIsCertified != null : !this$microStrategyIsCertified.equals(other$microStrategyIsCertified)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$microStrategyCertifiedBy = this.getMicroStrategyCertifiedBy();
        final java.lang.Object other$microStrategyCertifiedBy = other.getMicroStrategyCertifiedBy();
        if (this$microStrategyCertifiedBy == null ? other$microStrategyCertifiedBy != null : !this$microStrategyCertifiedBy.equals(other$microStrategyCertifiedBy)) return false;
        final java.lang.Object this$microStrategyCubeNames = this.getMicroStrategyCubeNames();
        final java.lang.Object other$microStrategyCubeNames = other.getMicroStrategyCubeNames();
        if (this$microStrategyCubeNames == null ? other$microStrategyCubeNames != null : !this$microStrategyCubeNames.equals(other$microStrategyCubeNames)) return false;
        final java.lang.Object this$microStrategyCubeQualifiedNames = this.getMicroStrategyCubeQualifiedNames();
        final java.lang.Object other$microStrategyCubeQualifiedNames = other.getMicroStrategyCubeQualifiedNames();
        if (this$microStrategyCubeQualifiedNames == null ? other$microStrategyCubeQualifiedNames != null : !this$microStrategyCubeQualifiedNames.equals(other$microStrategyCubeQualifiedNames)) return false;
        final java.lang.Object this$microStrategyLocation = this.getMicroStrategyLocation();
        final java.lang.Object other$microStrategyLocation = other.getMicroStrategyLocation();
        if (this$microStrategyLocation == null ? other$microStrategyLocation != null : !this$microStrategyLocation.equals(other$microStrategyLocation)) return false;
        final java.lang.Object this$microStrategyProject = this.getMicroStrategyProject();
        final java.lang.Object other$microStrategyProject = other.getMicroStrategyProject();
        if (this$microStrategyProject == null ? other$microStrategyProject != null : !this$microStrategyProject.equals(other$microStrategyProject)) return false;
        final java.lang.Object this$microStrategyProjectName = this.getMicroStrategyProjectName();
        final java.lang.Object other$microStrategyProjectName = other.getMicroStrategyProjectName();
        if (this$microStrategyProjectName == null ? other$microStrategyProjectName != null : !this$microStrategyProjectName.equals(other$microStrategyProjectName)) return false;
        final java.lang.Object this$microStrategyProjectQualifiedName = this.getMicroStrategyProjectQualifiedName();
        final java.lang.Object other$microStrategyProjectQualifiedName = other.getMicroStrategyProjectQualifiedName();
        if (this$microStrategyProjectQualifiedName == null ? other$microStrategyProjectQualifiedName != null : !this$microStrategyProjectQualifiedName.equals(other$microStrategyProjectQualifiedName)) return false;
        final java.lang.Object this$microStrategyReportNames = this.getMicroStrategyReportNames();
        final java.lang.Object other$microStrategyReportNames = other.getMicroStrategyReportNames();
        if (this$microStrategyReportNames == null ? other$microStrategyReportNames != null : !this$microStrategyReportNames.equals(other$microStrategyReportNames)) return false;
        final java.lang.Object this$microStrategyReportQualifiedNames = this.getMicroStrategyReportQualifiedNames();
        final java.lang.Object other$microStrategyReportQualifiedNames = other.getMicroStrategyReportQualifiedNames();
        if (this$microStrategyReportQualifiedNames == null ? other$microStrategyReportQualifiedNames != null : !this$microStrategyReportQualifiedNames.equals(other$microStrategyReportQualifiedNames)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MicroStrategyDocument;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $microStrategyCertifiedAt = this.getMicroStrategyCertifiedAt();
        result = result * PRIME + ($microStrategyCertifiedAt == null ? 43 : $microStrategyCertifiedAt.hashCode());
        final java.lang.Object $microStrategyIsCertified = this.getMicroStrategyIsCertified();
        result = result * PRIME + ($microStrategyIsCertified == null ? 43 : $microStrategyIsCertified.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $microStrategyCertifiedBy = this.getMicroStrategyCertifiedBy();
        result = result * PRIME + ($microStrategyCertifiedBy == null ? 43 : $microStrategyCertifiedBy.hashCode());
        final java.lang.Object $microStrategyCubeNames = this.getMicroStrategyCubeNames();
        result = result * PRIME + ($microStrategyCubeNames == null ? 43 : $microStrategyCubeNames.hashCode());
        final java.lang.Object $microStrategyCubeQualifiedNames = this.getMicroStrategyCubeQualifiedNames();
        result = result * PRIME + ($microStrategyCubeQualifiedNames == null ? 43 : $microStrategyCubeQualifiedNames.hashCode());
        final java.lang.Object $microStrategyLocation = this.getMicroStrategyLocation();
        result = result * PRIME + ($microStrategyLocation == null ? 43 : $microStrategyLocation.hashCode());
        final java.lang.Object $microStrategyProject = this.getMicroStrategyProject();
        result = result * PRIME + ($microStrategyProject == null ? 43 : $microStrategyProject.hashCode());
        final java.lang.Object $microStrategyProjectName = this.getMicroStrategyProjectName();
        result = result * PRIME + ($microStrategyProjectName == null ? 43 : $microStrategyProjectName.hashCode());
        final java.lang.Object $microStrategyProjectQualifiedName = this.getMicroStrategyProjectQualifiedName();
        result = result * PRIME + ($microStrategyProjectQualifiedName == null ? 43 : $microStrategyProjectQualifiedName.hashCode());
        final java.lang.Object $microStrategyReportNames = this.getMicroStrategyReportNames();
        result = result * PRIME + ($microStrategyReportNames == null ? 43 : $microStrategyReportNames.hashCode());
        final java.lang.Object $microStrategyReportQualifiedNames = this.getMicroStrategyReportQualifiedNames();
        result = result * PRIME + ($microStrategyReportQualifiedNames == null ? 43 : $microStrategyReportQualifiedNames.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MicroStrategyDocument(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", microStrategyCertifiedAt=" + this.getMicroStrategyCertifiedAt() + ", microStrategyCertifiedBy=" + this.getMicroStrategyCertifiedBy() + ", microStrategyCubeNames=" + this.getMicroStrategyCubeNames() + ", microStrategyCubeQualifiedNames=" + this.getMicroStrategyCubeQualifiedNames() + ", microStrategyIsCertified=" + this.getMicroStrategyIsCertified() + ", microStrategyLocation=" + this.getMicroStrategyLocation() + ", microStrategyProject=" + this.getMicroStrategyProject() + ", microStrategyProjectName=" + this.getMicroStrategyProjectName() + ", microStrategyProjectQualifiedName=" + this.getMicroStrategyProjectQualifiedName() + ", microStrategyReportNames=" + this.getMicroStrategyReportNames() + ", microStrategyReportQualifiedNames=" + this.getMicroStrategyReportQualifiedNames() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for MicroStrategyDocuments.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
