// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a MicroStrategy metric in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class MicroStrategyMetric extends Asset implements IMicroStrategyMetric, IMicroStrategy, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MicroStrategyMetric.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MicroStrategyMetric";
    /**
     * Fixed typeName for MicroStrategyMetrics.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * List of simple names of attributes related to this metric.
     */
    @Attribute
    SortedSet<String> microStrategyAttributeNames;
    /**
     * List of unique names of attributes related to this metric.
     */
    @Attribute
    SortedSet<String> microStrategyAttributeQualifiedNames;
    /**
     * Attributes this metric uses.
     */
    @Attribute
    SortedSet<IMicroStrategyAttribute> microStrategyAttributes;
    /**
     * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
     */
    @Attribute
    @Date
    Long microStrategyCertifiedAt;
    /**
     * User who certified this asset, in MicroStrategy.
     */
    @Attribute
    String microStrategyCertifiedBy;
    /**
     * Simple names of the cubes related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyCubeNames;
    /**
     * Unique names of the cubes related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyCubeQualifiedNames;
    /**
     * Cubes this metric uses.
     */
    @Attribute
    SortedSet<IMicroStrategyCube> microStrategyCubes;
    /**
     * List of simple names of facts related to this metric.
     */
    @Attribute
    SortedSet<String> microStrategyFactNames;
    /**
     * List of unique names of facts related to this metric.
     */
    @Attribute
    SortedSet<String> microStrategyFactQualifiedNames;
    /**
     * Facts this metric uses.
     */
    @Attribute
    SortedSet<IMicroStrategyFact> microStrategyFacts;
    /**
     * Whether the asset is certified in MicroStrategy (true) or not (false).
     */
    @Attribute
    Boolean microStrategyIsCertified;
    /**
     * Location of this asset in MicroStrategy.
     */
    @Attribute
    List<Map<String, String>> microStrategyLocation;
    /**
     * Child metrics of this metric.
     */
    @Attribute
    SortedSet<IMicroStrategyMetric> microStrategyMetricChildren;
    /**
     * Text specifiying this metric's expression.
     */
    @Attribute
    String microStrategyMetricExpression;
    /**
     * List of simple names of parent metrics of this metric.
     */
    @Attribute
    SortedSet<String> microStrategyMetricParentNames;
    /**
     * List of unique names of parent metrics of this metric.
     */
    @Attribute
    SortedSet<String> microStrategyMetricParentQualifiedNames;
    /**
     * Parent metrics to this metric.
     */
    @Attribute
    SortedSet<IMicroStrategyMetric> microStrategyMetricParents;
    /**
     * Project in which this metric exists.
     */
    @Attribute
    IMicroStrategyProject microStrategyProject;
    /**
     * Simple name of the project in which this asset exists.
     */
    @Attribute
    String microStrategyProjectName;
    /**
     * Unique name of the project in which this asset exists.
     */
    @Attribute
    String microStrategyProjectQualifiedName;
    /**
     * Simple names of the reports related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyReportNames;
    /**
     * Unique names of the reports related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyReportQualifiedNames;
    /**
     * Reports in which this metric is used.
     */
    @Attribute
    SortedSet<IMicroStrategyReport> microStrategyReports;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a MicroStrategyMetric, from a potentially
     * more-complete MicroStrategyMetric object.
     *
     * @return the minimal object necessary to relate to the MicroStrategyMetric
     * @throws InvalidRequestException if any of the minimal set of required properties for a MicroStrategyMetric relationship are not found in the initial object
     */
    @Override
    public MicroStrategyMetric trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all MicroStrategyMetric assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MicroStrategyMetric assets will be included.
     *
     * @return a fluent search that includes all MicroStrategyMetric assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all MicroStrategyMetric assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MicroStrategyMetric assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all MicroStrategyMetric assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all MicroStrategyMetric assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) MicroStrategyMetrics will be included
     * @return a fluent search that includes all MicroStrategyMetric assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all MicroStrategyMetric assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) MicroStrategyMetrics will be included
     * @return a fluent search that includes all MicroStrategyMetric assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a MicroStrategyMetric by GUID. Use this to create a relationship to this MicroStrategyMetric,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the MicroStrategyMetric to reference
     * @return reference to a MicroStrategyMetric that can be used for defining a relationship to a MicroStrategyMetric
     */
    public static MicroStrategyMetric refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MicroStrategyMetric by GUID. Use this to create a relationship to this MicroStrategyMetric,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the MicroStrategyMetric to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MicroStrategyMetric that can be used for defining a relationship to a MicroStrategyMetric
     */
    public static MicroStrategyMetric refByGuid(String guid, Reference.SaveSemantic semantic) {
        return MicroStrategyMetric._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a MicroStrategyMetric by qualifiedName. Use this to create a relationship to this MicroStrategyMetric,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the MicroStrategyMetric to reference
     * @return reference to a MicroStrategyMetric that can be used for defining a relationship to a MicroStrategyMetric
     */
    public static MicroStrategyMetric refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MicroStrategyMetric by qualifiedName. Use this to create a relationship to this MicroStrategyMetric,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the MicroStrategyMetric to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MicroStrategyMetric that can be used for defining a relationship to a MicroStrategyMetric
     */
    public static MicroStrategyMetric refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return MicroStrategyMetric._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a MicroStrategyMetric by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the MicroStrategyMetric to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MicroStrategyMetric, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyMetric does not exist or the provided GUID is not a MicroStrategyMetric
     */
    @JsonIgnore
    public static MicroStrategyMetric get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a MicroStrategyMetric by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MicroStrategyMetric to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MicroStrategyMetric, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyMetric does not exist or the provided GUID is not a MicroStrategyMetric
     */
    @JsonIgnore
    public static MicroStrategyMetric get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a MicroStrategyMetric by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MicroStrategyMetric to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full MicroStrategyMetric, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyMetric does not exist or the provided GUID is not a MicroStrategyMetric
     */
    @JsonIgnore
    public static MicroStrategyMetric get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof MicroStrategyMetric) {
                return (MicroStrategyMetric) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof MicroStrategyMetric) {
                return (MicroStrategyMetric) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) MicroStrategyMetric to active.
     *
     * @param qualifiedName for the MicroStrategyMetric
     * @return true if the MicroStrategyMetric is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) MicroStrategyMetric to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the MicroStrategyMetric
     * @return true if the MicroStrategyMetric is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the minimal request necessary to update the MicroStrategyMetric, as a builder
     */
    public static MicroStrategyMetricBuilder<?, ?> updater(String qualifiedName, String name) {
        return MicroStrategyMetric._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a MicroStrategyMetric, from a potentially
     * more-complete MicroStrategyMetric object.
     *
     * @return the minimal object necessary to update the MicroStrategyMetric, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for MicroStrategyMetric are not found in the initial object
     */
    @Override
    public MicroStrategyMetricBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyMetric) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyMetric) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MicroStrategyMetric's owners
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyMetric) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MicroStrategyMetric, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan tenant on which to update the MicroStrategyMetric's certificate
     * @param qualifiedName of the MicroStrategyMetric
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MicroStrategyMetric, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MicroStrategyMetric) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MicroStrategyMetric's certificate
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyMetric) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan tenant on which to update the MicroStrategyMetric's announcement
     * @param qualifiedName of the MicroStrategyMetric
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MicroStrategyMetric) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan client from which to remove the MicroStrategyMetric's announcement
     * @param qualifiedName of the MicroStrategyMetric
     * @param name of the MicroStrategyMetric
     * @return the updated MicroStrategyMetric, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyMetric) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the MicroStrategyMetric.
     *
     * @param qualifiedName for the MicroStrategyMetric
     * @param name human-readable name of the MicroStrategyMetric
     * @param terms the list of terms to replace on the MicroStrategyMetric, or null to remove all terms from the MicroStrategyMetric
     * @return the MicroStrategyMetric that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan tenant on which to replace the MicroStrategyMetric's assigned terms
     * @param qualifiedName for the MicroStrategyMetric
     * @param name human-readable name of the MicroStrategyMetric
     * @param terms the list of terms to replace on the MicroStrategyMetric, or null to remove all terms from the MicroStrategyMetric
     * @return the MicroStrategyMetric that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyMetric) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the MicroStrategyMetric, without replacing existing terms linked to the MicroStrategyMetric.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyMetric's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the MicroStrategyMetric
     * @param terms the list of terms to append to the MicroStrategyMetric
     * @return the MicroStrategyMetric that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the MicroStrategyMetric, without replacing existing terms linked to the MicroStrategyMetric.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyMetric's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the MicroStrategyMetric
     * @param qualifiedName for the MicroStrategyMetric
     * @param terms the list of terms to append to the MicroStrategyMetric
     * @return the MicroStrategyMetric that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyMetric) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a MicroStrategyMetric, without replacing all existing terms linked to the MicroStrategyMetric.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyMetric's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the MicroStrategyMetric
     * @param terms the list of terms to remove from the MicroStrategyMetric, which must be referenced by GUID
     * @return the MicroStrategyMetric that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a MicroStrategyMetric, without replacing all existing terms linked to the MicroStrategyMetric.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyMetric's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the MicroStrategyMetric
     * @param qualifiedName for the MicroStrategyMetric
     * @param terms the list of terms to remove from the MicroStrategyMetric, which must be referenced by GUID
     * @return the MicroStrategyMetric that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyMetric removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyMetric) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a MicroStrategyMetric, without replacing existing Atlan tags linked to the MicroStrategyMetric.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyMetric's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyMetric
     */
    public static MicroStrategyMetric appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MicroStrategyMetric, without replacing existing Atlan tags linked to the MicroStrategyMetric.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyMetric's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MicroStrategyMetric
     * @param qualifiedName of the MicroStrategyMetric
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyMetric
     */
    public static MicroStrategyMetric appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MicroStrategyMetric) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MicroStrategyMetric, without replacing existing Atlan tags linked to the MicroStrategyMetric.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyMetric's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyMetric
     */
    public static MicroStrategyMetric appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a MicroStrategyMetric, without replacing existing Atlan tags linked to the MicroStrategyMetric.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyMetric's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MicroStrategyMetric
     * @param qualifiedName of the MicroStrategyMetric
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyMetric
     */
    public static MicroStrategyMetric appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MicroStrategyMetric) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a MicroStrategyMetric.
     *
     * @param qualifiedName of the MicroStrategyMetric
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MicroStrategyMetric
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a MicroStrategyMetric.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a MicroStrategyMetric
     * @param qualifiedName of the MicroStrategyMetric
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MicroStrategyMetric
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MicroStrategyMetricBuilder<C extends MicroStrategyMetric, B extends MicroStrategyMetric.MicroStrategyMetricBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyAttributeNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyAttributeQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyAttribute> microStrategyAttributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long microStrategyCertifiedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyCertifiedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyCubeNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyCubeQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyCube> microStrategyCubes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyFactNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyFactQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyFact> microStrategyFacts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean microStrategyIsCertified;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> microStrategyLocation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyMetric> microStrategyMetricChildren;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyMetricExpression;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyMetricParentNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyMetricParentQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyMetric> microStrategyMetricParents;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IMicroStrategyProject microStrategyProject;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyProjectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyProjectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyReportNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyReportQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyReport> microStrategyReports;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MicroStrategyMetric.MicroStrategyMetricBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final MicroStrategyMetric instance, final MicroStrategyMetric.MicroStrategyMetricBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.microStrategyAttributeNames(instance.microStrategyAttributeNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyAttributeNames);
            b.microStrategyAttributeQualifiedNames(instance.microStrategyAttributeQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyAttributeQualifiedNames);
            b.microStrategyAttributes(instance.microStrategyAttributes == null ? java.util.Collections.<IMicroStrategyAttribute>emptySortedSet() : instance.microStrategyAttributes);
            b.microStrategyCertifiedAt(instance.microStrategyCertifiedAt);
            b.microStrategyCertifiedBy(instance.microStrategyCertifiedBy);
            b.microStrategyCubeNames(instance.microStrategyCubeNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyCubeNames);
            b.microStrategyCubeQualifiedNames(instance.microStrategyCubeQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyCubeQualifiedNames);
            b.microStrategyCubes(instance.microStrategyCubes == null ? java.util.Collections.<IMicroStrategyCube>emptySortedSet() : instance.microStrategyCubes);
            b.microStrategyFactNames(instance.microStrategyFactNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyFactNames);
            b.microStrategyFactQualifiedNames(instance.microStrategyFactQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyFactQualifiedNames);
            b.microStrategyFacts(instance.microStrategyFacts == null ? java.util.Collections.<IMicroStrategyFact>emptySortedSet() : instance.microStrategyFacts);
            b.microStrategyIsCertified(instance.microStrategyIsCertified);
            b.microStrategyLocation(instance.microStrategyLocation == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.microStrategyLocation);
            b.microStrategyMetricChildren(instance.microStrategyMetricChildren == null ? java.util.Collections.<IMicroStrategyMetric>emptySortedSet() : instance.microStrategyMetricChildren);
            b.microStrategyMetricExpression(instance.microStrategyMetricExpression);
            b.microStrategyMetricParentNames(instance.microStrategyMetricParentNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyMetricParentNames);
            b.microStrategyMetricParentQualifiedNames(instance.microStrategyMetricParentQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyMetricParentQualifiedNames);
            b.microStrategyMetricParents(instance.microStrategyMetricParents == null ? java.util.Collections.<IMicroStrategyMetric>emptySortedSet() : instance.microStrategyMetricParents);
            b.microStrategyProject(instance.microStrategyProject);
            b.microStrategyProjectName(instance.microStrategyProjectName);
            b.microStrategyProjectQualifiedName(instance.microStrategyProjectQualifiedName);
            b.microStrategyReportNames(instance.microStrategyReportNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyReportNames);
            b.microStrategyReportQualifiedNames(instance.microStrategyReportQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyReportQualifiedNames);
            b.microStrategyReports(instance.microStrategyReports == null ? java.util.Collections.<IMicroStrategyReport>emptySortedSet() : instance.microStrategyReports);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for MicroStrategyMetrics.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyAttributeName(final String microStrategyAttributeName) {
            if (this.microStrategyAttributeNames == null) this.microStrategyAttributeNames = new java.util.ArrayList<String>();
            this.microStrategyAttributeNames.add(microStrategyAttributeName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyAttributeNames(final java.util.Collection<? extends String> microStrategyAttributeNames) {
            if (microStrategyAttributeNames == null) {
                throw new java.lang.NullPointerException("microStrategyAttributeNames cannot be null");
            }
            if (this.microStrategyAttributeNames == null) this.microStrategyAttributeNames = new java.util.ArrayList<String>();
            this.microStrategyAttributeNames.addAll(microStrategyAttributeNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyAttributeNames() {
            if (this.microStrategyAttributeNames != null) this.microStrategyAttributeNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyAttributeQualifiedName(final String microStrategyAttributeQualifiedName) {
            if (this.microStrategyAttributeQualifiedNames == null) this.microStrategyAttributeQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyAttributeQualifiedNames.add(microStrategyAttributeQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyAttributeQualifiedNames(final java.util.Collection<? extends String> microStrategyAttributeQualifiedNames) {
            if (microStrategyAttributeQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyAttributeQualifiedNames cannot be null");
            }
            if (this.microStrategyAttributeQualifiedNames == null) this.microStrategyAttributeQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyAttributeQualifiedNames.addAll(microStrategyAttributeQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyAttributeQualifiedNames() {
            if (this.microStrategyAttributeQualifiedNames != null) this.microStrategyAttributeQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyAttribute(final IMicroStrategyAttribute microStrategyAttribute) {
            if (this.microStrategyAttributes == null) this.microStrategyAttributes = new java.util.ArrayList<IMicroStrategyAttribute>();
            this.microStrategyAttributes.add(microStrategyAttribute);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyAttributes(final java.util.Collection<? extends IMicroStrategyAttribute> microStrategyAttributes) {
            if (microStrategyAttributes == null) {
                throw new java.lang.NullPointerException("microStrategyAttributes cannot be null");
            }
            if (this.microStrategyAttributes == null) this.microStrategyAttributes = new java.util.ArrayList<IMicroStrategyAttribute>();
            this.microStrategyAttributes.addAll(microStrategyAttributes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyAttributes() {
            if (this.microStrategyAttributes != null) this.microStrategyAttributes.clear();
            return self();
        }

        /**
         * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCertifiedAt(final Long microStrategyCertifiedAt) {
            this.microStrategyCertifiedAt = microStrategyCertifiedAt;
            return self();
        }

        /**
         * User who certified this asset, in MicroStrategy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCertifiedBy(final String microStrategyCertifiedBy) {
            this.microStrategyCertifiedBy = microStrategyCertifiedBy;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeName(final String microStrategyCubeName) {
            if (this.microStrategyCubeNames == null) this.microStrategyCubeNames = new java.util.ArrayList<String>();
            this.microStrategyCubeNames.add(microStrategyCubeName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeNames(final java.util.Collection<? extends String> microStrategyCubeNames) {
            if (microStrategyCubeNames == null) {
                throw new java.lang.NullPointerException("microStrategyCubeNames cannot be null");
            }
            if (this.microStrategyCubeNames == null) this.microStrategyCubeNames = new java.util.ArrayList<String>();
            this.microStrategyCubeNames.addAll(microStrategyCubeNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyCubeNames() {
            if (this.microStrategyCubeNames != null) this.microStrategyCubeNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeQualifiedName(final String microStrategyCubeQualifiedName) {
            if (this.microStrategyCubeQualifiedNames == null) this.microStrategyCubeQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyCubeQualifiedNames.add(microStrategyCubeQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeQualifiedNames(final java.util.Collection<? extends String> microStrategyCubeQualifiedNames) {
            if (microStrategyCubeQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyCubeQualifiedNames cannot be null");
            }
            if (this.microStrategyCubeQualifiedNames == null) this.microStrategyCubeQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyCubeQualifiedNames.addAll(microStrategyCubeQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyCubeQualifiedNames() {
            if (this.microStrategyCubeQualifiedNames != null) this.microStrategyCubeQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCube(final IMicroStrategyCube microStrategyCube) {
            if (this.microStrategyCubes == null) this.microStrategyCubes = new java.util.ArrayList<IMicroStrategyCube>();
            this.microStrategyCubes.add(microStrategyCube);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubes(final java.util.Collection<? extends IMicroStrategyCube> microStrategyCubes) {
            if (microStrategyCubes == null) {
                throw new java.lang.NullPointerException("microStrategyCubes cannot be null");
            }
            if (this.microStrategyCubes == null) this.microStrategyCubes = new java.util.ArrayList<IMicroStrategyCube>();
            this.microStrategyCubes.addAll(microStrategyCubes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyCubes() {
            if (this.microStrategyCubes != null) this.microStrategyCubes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyFactName(final String microStrategyFactName) {
            if (this.microStrategyFactNames == null) this.microStrategyFactNames = new java.util.ArrayList<String>();
            this.microStrategyFactNames.add(microStrategyFactName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyFactNames(final java.util.Collection<? extends String> microStrategyFactNames) {
            if (microStrategyFactNames == null) {
                throw new java.lang.NullPointerException("microStrategyFactNames cannot be null");
            }
            if (this.microStrategyFactNames == null) this.microStrategyFactNames = new java.util.ArrayList<String>();
            this.microStrategyFactNames.addAll(microStrategyFactNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyFactNames() {
            if (this.microStrategyFactNames != null) this.microStrategyFactNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyFactQualifiedName(final String microStrategyFactQualifiedName) {
            if (this.microStrategyFactQualifiedNames == null) this.microStrategyFactQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyFactQualifiedNames.add(microStrategyFactQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyFactQualifiedNames(final java.util.Collection<? extends String> microStrategyFactQualifiedNames) {
            if (microStrategyFactQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyFactQualifiedNames cannot be null");
            }
            if (this.microStrategyFactQualifiedNames == null) this.microStrategyFactQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyFactQualifiedNames.addAll(microStrategyFactQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyFactQualifiedNames() {
            if (this.microStrategyFactQualifiedNames != null) this.microStrategyFactQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyFact(final IMicroStrategyFact microStrategyFact) {
            if (this.microStrategyFacts == null) this.microStrategyFacts = new java.util.ArrayList<IMicroStrategyFact>();
            this.microStrategyFacts.add(microStrategyFact);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyFacts(final java.util.Collection<? extends IMicroStrategyFact> microStrategyFacts) {
            if (microStrategyFacts == null) {
                throw new java.lang.NullPointerException("microStrategyFacts cannot be null");
            }
            if (this.microStrategyFacts == null) this.microStrategyFacts = new java.util.ArrayList<IMicroStrategyFact>();
            this.microStrategyFacts.addAll(microStrategyFacts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyFacts() {
            if (this.microStrategyFacts != null) this.microStrategyFacts.clear();
            return self();
        }

        /**
         * Whether the asset is certified in MicroStrategy (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyIsCertified(final Boolean microStrategyIsCertified) {
            this.microStrategyIsCertified = microStrategyIsCertified;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putMicroStrategyLocation(final Map<String, String> putMicroStrategyLocation) {
            if (this.microStrategyLocation == null) this.microStrategyLocation = new java.util.ArrayList<Map<String, String>>();
            this.microStrategyLocation.add(putMicroStrategyLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyLocation(final java.util.Collection<? extends Map<String, String>> microStrategyLocation) {
            if (microStrategyLocation == null) {
                throw new java.lang.NullPointerException("microStrategyLocation cannot be null");
            }
            if (this.microStrategyLocation == null) this.microStrategyLocation = new java.util.ArrayList<Map<String, String>>();
            this.microStrategyLocation.addAll(microStrategyLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyLocation() {
            if (this.microStrategyLocation != null) this.microStrategyLocation.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricChild(final IMicroStrategyMetric microStrategyMetricChild) {
            if (this.microStrategyMetricChildren == null) this.microStrategyMetricChildren = new java.util.ArrayList<IMicroStrategyMetric>();
            this.microStrategyMetricChildren.add(microStrategyMetricChild);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricChildren(final java.util.Collection<? extends IMicroStrategyMetric> microStrategyMetricChildren) {
            if (microStrategyMetricChildren == null) {
                throw new java.lang.NullPointerException("microStrategyMetricChildren cannot be null");
            }
            if (this.microStrategyMetricChildren == null) this.microStrategyMetricChildren = new java.util.ArrayList<IMicroStrategyMetric>();
            this.microStrategyMetricChildren.addAll(microStrategyMetricChildren);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyMetricChildren() {
            if (this.microStrategyMetricChildren != null) this.microStrategyMetricChildren.clear();
            return self();
        }

        /**
         * Text specifiying this metric's expression.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricExpression(final String microStrategyMetricExpression) {
            this.microStrategyMetricExpression = microStrategyMetricExpression;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricParentName(final String microStrategyMetricParentName) {
            if (this.microStrategyMetricParentNames == null) this.microStrategyMetricParentNames = new java.util.ArrayList<String>();
            this.microStrategyMetricParentNames.add(microStrategyMetricParentName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricParentNames(final java.util.Collection<? extends String> microStrategyMetricParentNames) {
            if (microStrategyMetricParentNames == null) {
                throw new java.lang.NullPointerException("microStrategyMetricParentNames cannot be null");
            }
            if (this.microStrategyMetricParentNames == null) this.microStrategyMetricParentNames = new java.util.ArrayList<String>();
            this.microStrategyMetricParentNames.addAll(microStrategyMetricParentNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyMetricParentNames() {
            if (this.microStrategyMetricParentNames != null) this.microStrategyMetricParentNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricParentQualifiedName(final String microStrategyMetricParentQualifiedName) {
            if (this.microStrategyMetricParentQualifiedNames == null) this.microStrategyMetricParentQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyMetricParentQualifiedNames.add(microStrategyMetricParentQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricParentQualifiedNames(final java.util.Collection<? extends String> microStrategyMetricParentQualifiedNames) {
            if (microStrategyMetricParentQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyMetricParentQualifiedNames cannot be null");
            }
            if (this.microStrategyMetricParentQualifiedNames == null) this.microStrategyMetricParentQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyMetricParentQualifiedNames.addAll(microStrategyMetricParentQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyMetricParentQualifiedNames() {
            if (this.microStrategyMetricParentQualifiedNames != null) this.microStrategyMetricParentQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricParent(final IMicroStrategyMetric microStrategyMetricParent) {
            if (this.microStrategyMetricParents == null) this.microStrategyMetricParents = new java.util.ArrayList<IMicroStrategyMetric>();
            this.microStrategyMetricParents.add(microStrategyMetricParent);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetricParents(final java.util.Collection<? extends IMicroStrategyMetric> microStrategyMetricParents) {
            if (microStrategyMetricParents == null) {
                throw new java.lang.NullPointerException("microStrategyMetricParents cannot be null");
            }
            if (this.microStrategyMetricParents == null) this.microStrategyMetricParents = new java.util.ArrayList<IMicroStrategyMetric>();
            this.microStrategyMetricParents.addAll(microStrategyMetricParents);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyMetricParents() {
            if (this.microStrategyMetricParents != null) this.microStrategyMetricParents.clear();
            return self();
        }

        /**
         * Project in which this metric exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyProject(final IMicroStrategyProject microStrategyProject) {
            this.microStrategyProject = microStrategyProject;
            return self();
        }

        /**
         * Simple name of the project in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyProjectName(final String microStrategyProjectName) {
            this.microStrategyProjectName = microStrategyProjectName;
            return self();
        }

        /**
         * Unique name of the project in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyProjectQualifiedName(final String microStrategyProjectQualifiedName) {
            this.microStrategyProjectQualifiedName = microStrategyProjectQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportName(final String microStrategyReportName) {
            if (this.microStrategyReportNames == null) this.microStrategyReportNames = new java.util.ArrayList<String>();
            this.microStrategyReportNames.add(microStrategyReportName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportNames(final java.util.Collection<? extends String> microStrategyReportNames) {
            if (microStrategyReportNames == null) {
                throw new java.lang.NullPointerException("microStrategyReportNames cannot be null");
            }
            if (this.microStrategyReportNames == null) this.microStrategyReportNames = new java.util.ArrayList<String>();
            this.microStrategyReportNames.addAll(microStrategyReportNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyReportNames() {
            if (this.microStrategyReportNames != null) this.microStrategyReportNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportQualifiedName(final String microStrategyReportQualifiedName) {
            if (this.microStrategyReportQualifiedNames == null) this.microStrategyReportQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyReportQualifiedNames.add(microStrategyReportQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportQualifiedNames(final java.util.Collection<? extends String> microStrategyReportQualifiedNames) {
            if (microStrategyReportQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyReportQualifiedNames cannot be null");
            }
            if (this.microStrategyReportQualifiedNames == null) this.microStrategyReportQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyReportQualifiedNames.addAll(microStrategyReportQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyReportQualifiedNames() {
            if (this.microStrategyReportQualifiedNames != null) this.microStrategyReportQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReport(final IMicroStrategyReport microStrategyReport) {
            if (this.microStrategyReports == null) this.microStrategyReports = new java.util.ArrayList<IMicroStrategyReport>();
            this.microStrategyReports.add(microStrategyReport);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReports(final java.util.Collection<? extends IMicroStrategyReport> microStrategyReports) {
            if (microStrategyReports == null) {
                throw new java.lang.NullPointerException("microStrategyReports cannot be null");
            }
            if (this.microStrategyReports == null) this.microStrategyReports = new java.util.ArrayList<IMicroStrategyReport>();
            this.microStrategyReports.addAll(microStrategyReports);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyReports() {
            if (this.microStrategyReports != null) this.microStrategyReports.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "MicroStrategyMetric.MicroStrategyMetricBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", microStrategyAttributeNames=" + this.microStrategyAttributeNames + ", microStrategyAttributeQualifiedNames=" + this.microStrategyAttributeQualifiedNames + ", microStrategyAttributes=" + this.microStrategyAttributes + ", microStrategyCertifiedAt=" + this.microStrategyCertifiedAt + ", microStrategyCertifiedBy=" + this.microStrategyCertifiedBy + ", microStrategyCubeNames=" + this.microStrategyCubeNames + ", microStrategyCubeQualifiedNames=" + this.microStrategyCubeQualifiedNames + ", microStrategyCubes=" + this.microStrategyCubes + ", microStrategyFactNames=" + this.microStrategyFactNames + ", microStrategyFactQualifiedNames=" + this.microStrategyFactQualifiedNames + ", microStrategyFacts=" + this.microStrategyFacts + ", microStrategyIsCertified=" + this.microStrategyIsCertified + ", microStrategyLocation=" + this.microStrategyLocation + ", microStrategyMetricChildren=" + this.microStrategyMetricChildren + ", microStrategyMetricExpression=" + this.microStrategyMetricExpression + ", microStrategyMetricParentNames=" + this.microStrategyMetricParentNames + ", microStrategyMetricParentQualifiedNames=" + this.microStrategyMetricParentQualifiedNames + ", microStrategyMetricParents=" + this.microStrategyMetricParents + ", microStrategyProject=" + this.microStrategyProject + ", microStrategyProjectName=" + this.microStrategyProjectName + ", microStrategyProjectQualifiedName=" + this.microStrategyProjectQualifiedName + ", microStrategyReportNames=" + this.microStrategyReportNames + ", microStrategyReportQualifiedNames=" + this.microStrategyReportQualifiedNames + ", microStrategyReports=" + this.microStrategyReports + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class MicroStrategyMetricBuilderImpl extends MicroStrategyMetric.MicroStrategyMetricBuilder<MicroStrategyMetric, MicroStrategyMetric.MicroStrategyMetricBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MicroStrategyMetricBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected MicroStrategyMetric.MicroStrategyMetricBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public MicroStrategyMetric build() {
            return new MicroStrategyMetric(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected MicroStrategyMetric(final MicroStrategyMetric.MicroStrategyMetricBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = MicroStrategyMetric.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<String> microStrategyAttributeNames = new java.util.TreeSet<String>();
        if (b.microStrategyAttributeNames != null) microStrategyAttributeNames.addAll(b.microStrategyAttributeNames);
        microStrategyAttributeNames = java.util.Collections.unmodifiableSortedSet(microStrategyAttributeNames);
        this.microStrategyAttributeNames = microStrategyAttributeNames;
        java.util.SortedSet<String> microStrategyAttributeQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyAttributeQualifiedNames != null) microStrategyAttributeQualifiedNames.addAll(b.microStrategyAttributeQualifiedNames);
        microStrategyAttributeQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyAttributeQualifiedNames);
        this.microStrategyAttributeQualifiedNames = microStrategyAttributeQualifiedNames;
        java.util.SortedSet<IMicroStrategyAttribute> microStrategyAttributes = new java.util.TreeSet<IMicroStrategyAttribute>();
        if (b.microStrategyAttributes != null) microStrategyAttributes.addAll(b.microStrategyAttributes);
        microStrategyAttributes = java.util.Collections.unmodifiableSortedSet(microStrategyAttributes);
        this.microStrategyAttributes = microStrategyAttributes;
        this.microStrategyCertifiedAt = b.microStrategyCertifiedAt;
        this.microStrategyCertifiedBy = b.microStrategyCertifiedBy;
        java.util.SortedSet<String> microStrategyCubeNames = new java.util.TreeSet<String>();
        if (b.microStrategyCubeNames != null) microStrategyCubeNames.addAll(b.microStrategyCubeNames);
        microStrategyCubeNames = java.util.Collections.unmodifiableSortedSet(microStrategyCubeNames);
        this.microStrategyCubeNames = microStrategyCubeNames;
        java.util.SortedSet<String> microStrategyCubeQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyCubeQualifiedNames != null) microStrategyCubeQualifiedNames.addAll(b.microStrategyCubeQualifiedNames);
        microStrategyCubeQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyCubeQualifiedNames);
        this.microStrategyCubeQualifiedNames = microStrategyCubeQualifiedNames;
        java.util.SortedSet<IMicroStrategyCube> microStrategyCubes = new java.util.TreeSet<IMicroStrategyCube>();
        if (b.microStrategyCubes != null) microStrategyCubes.addAll(b.microStrategyCubes);
        microStrategyCubes = java.util.Collections.unmodifiableSortedSet(microStrategyCubes);
        this.microStrategyCubes = microStrategyCubes;
        java.util.SortedSet<String> microStrategyFactNames = new java.util.TreeSet<String>();
        if (b.microStrategyFactNames != null) microStrategyFactNames.addAll(b.microStrategyFactNames);
        microStrategyFactNames = java.util.Collections.unmodifiableSortedSet(microStrategyFactNames);
        this.microStrategyFactNames = microStrategyFactNames;
        java.util.SortedSet<String> microStrategyFactQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyFactQualifiedNames != null) microStrategyFactQualifiedNames.addAll(b.microStrategyFactQualifiedNames);
        microStrategyFactQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyFactQualifiedNames);
        this.microStrategyFactQualifiedNames = microStrategyFactQualifiedNames;
        java.util.SortedSet<IMicroStrategyFact> microStrategyFacts = new java.util.TreeSet<IMicroStrategyFact>();
        if (b.microStrategyFacts != null) microStrategyFacts.addAll(b.microStrategyFacts);
        microStrategyFacts = java.util.Collections.unmodifiableSortedSet(microStrategyFacts);
        this.microStrategyFacts = microStrategyFacts;
        this.microStrategyIsCertified = b.microStrategyIsCertified;
        java.util.List<Map<String, String>> microStrategyLocation;
        switch (b.microStrategyLocation == null ? 0 : b.microStrategyLocation.size()) {
        case 0: 
            microStrategyLocation = java.util.Collections.emptyList();
            break;
        case 1: 
            microStrategyLocation = java.util.Collections.singletonList(b.microStrategyLocation.get(0));
            break;
        default: 
            microStrategyLocation = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.microStrategyLocation));
        }
        this.microStrategyLocation = microStrategyLocation;
        java.util.SortedSet<IMicroStrategyMetric> microStrategyMetricChildren = new java.util.TreeSet<IMicroStrategyMetric>();
        if (b.microStrategyMetricChildren != null) microStrategyMetricChildren.addAll(b.microStrategyMetricChildren);
        microStrategyMetricChildren = java.util.Collections.unmodifiableSortedSet(microStrategyMetricChildren);
        this.microStrategyMetricChildren = microStrategyMetricChildren;
        this.microStrategyMetricExpression = b.microStrategyMetricExpression;
        java.util.SortedSet<String> microStrategyMetricParentNames = new java.util.TreeSet<String>();
        if (b.microStrategyMetricParentNames != null) microStrategyMetricParentNames.addAll(b.microStrategyMetricParentNames);
        microStrategyMetricParentNames = java.util.Collections.unmodifiableSortedSet(microStrategyMetricParentNames);
        this.microStrategyMetricParentNames = microStrategyMetricParentNames;
        java.util.SortedSet<String> microStrategyMetricParentQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyMetricParentQualifiedNames != null) microStrategyMetricParentQualifiedNames.addAll(b.microStrategyMetricParentQualifiedNames);
        microStrategyMetricParentQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyMetricParentQualifiedNames);
        this.microStrategyMetricParentQualifiedNames = microStrategyMetricParentQualifiedNames;
        java.util.SortedSet<IMicroStrategyMetric> microStrategyMetricParents = new java.util.TreeSet<IMicroStrategyMetric>();
        if (b.microStrategyMetricParents != null) microStrategyMetricParents.addAll(b.microStrategyMetricParents);
        microStrategyMetricParents = java.util.Collections.unmodifiableSortedSet(microStrategyMetricParents);
        this.microStrategyMetricParents = microStrategyMetricParents;
        this.microStrategyProject = b.microStrategyProject;
        this.microStrategyProjectName = b.microStrategyProjectName;
        this.microStrategyProjectQualifiedName = b.microStrategyProjectQualifiedName;
        java.util.SortedSet<String> microStrategyReportNames = new java.util.TreeSet<String>();
        if (b.microStrategyReportNames != null) microStrategyReportNames.addAll(b.microStrategyReportNames);
        microStrategyReportNames = java.util.Collections.unmodifiableSortedSet(microStrategyReportNames);
        this.microStrategyReportNames = microStrategyReportNames;
        java.util.SortedSet<String> microStrategyReportQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyReportQualifiedNames != null) microStrategyReportQualifiedNames.addAll(b.microStrategyReportQualifiedNames);
        microStrategyReportQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyReportQualifiedNames);
        this.microStrategyReportQualifiedNames = microStrategyReportQualifiedNames;
        java.util.SortedSet<IMicroStrategyReport> microStrategyReports = new java.util.TreeSet<IMicroStrategyReport>();
        if (b.microStrategyReports != null) microStrategyReports.addAll(b.microStrategyReports);
        microStrategyReports = java.util.Collections.unmodifiableSortedSet(microStrategyReports);
        this.microStrategyReports = microStrategyReports;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static MicroStrategyMetric.MicroStrategyMetricBuilder<?, ?> _internal() {
        return new MicroStrategyMetric.MicroStrategyMetricBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MicroStrategyMetric.MicroStrategyMetricBuilder<?, ?> toBuilder() {
        return new MicroStrategyMetric.MicroStrategyMetricBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * List of simple names of attributes related to this metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyAttributeNames() {
        return this.microStrategyAttributeNames;
    }

    /**
     * List of unique names of attributes related to this metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyAttributeQualifiedNames() {
        return this.microStrategyAttributeQualifiedNames;
    }

    /**
     * Attributes this metric uses.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyAttribute> getMicroStrategyAttributes() {
        return this.microStrategyAttributes;
    }

    /**
     * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMicroStrategyCertifiedAt() {
        return this.microStrategyCertifiedAt;
    }

    /**
     * User who certified this asset, in MicroStrategy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyCertifiedBy() {
        return this.microStrategyCertifiedBy;
    }

    /**
     * Simple names of the cubes related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyCubeNames() {
        return this.microStrategyCubeNames;
    }

    /**
     * Unique names of the cubes related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyCubeQualifiedNames() {
        return this.microStrategyCubeQualifiedNames;
    }

    /**
     * Cubes this metric uses.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyCube> getMicroStrategyCubes() {
        return this.microStrategyCubes;
    }

    /**
     * List of simple names of facts related to this metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyFactNames() {
        return this.microStrategyFactNames;
    }

    /**
     * List of unique names of facts related to this metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyFactQualifiedNames() {
        return this.microStrategyFactQualifiedNames;
    }

    /**
     * Facts this metric uses.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyFact> getMicroStrategyFacts() {
        return this.microStrategyFacts;
    }

    /**
     * Whether the asset is certified in MicroStrategy (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getMicroStrategyIsCertified() {
        return this.microStrategyIsCertified;
    }

    /**
     * Location of this asset in MicroStrategy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getMicroStrategyLocation() {
        return this.microStrategyLocation;
    }

    /**
     * Child metrics of this metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyMetric> getMicroStrategyMetricChildren() {
        return this.microStrategyMetricChildren;
    }

    /**
     * Text specifiying this metric's expression.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyMetricExpression() {
        return this.microStrategyMetricExpression;
    }

    /**
     * List of simple names of parent metrics of this metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyMetricParentNames() {
        return this.microStrategyMetricParentNames;
    }

    /**
     * List of unique names of parent metrics of this metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyMetricParentQualifiedNames() {
        return this.microStrategyMetricParentQualifiedNames;
    }

    /**
     * Parent metrics to this metric.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyMetric> getMicroStrategyMetricParents() {
        return this.microStrategyMetricParents;
    }

    /**
     * Project in which this metric exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IMicroStrategyProject getMicroStrategyProject() {
        return this.microStrategyProject;
    }

    /**
     * Simple name of the project in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyProjectName() {
        return this.microStrategyProjectName;
    }

    /**
     * Unique name of the project in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyProjectQualifiedName() {
        return this.microStrategyProjectQualifiedName;
    }

    /**
     * Simple names of the reports related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyReportNames() {
        return this.microStrategyReportNames;
    }

    /**
     * Unique names of the reports related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyReportQualifiedNames() {
        return this.microStrategyReportQualifiedNames;
    }

    /**
     * Reports in which this metric is used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyReport> getMicroStrategyReports() {
        return this.microStrategyReports;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MicroStrategyMetric)) return false;
        final MicroStrategyMetric other = (MicroStrategyMetric) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$microStrategyCertifiedAt = this.getMicroStrategyCertifiedAt();
        final java.lang.Object other$microStrategyCertifiedAt = other.getMicroStrategyCertifiedAt();
        if (this$microStrategyCertifiedAt == null ? other$microStrategyCertifiedAt != null : !this$microStrategyCertifiedAt.equals(other$microStrategyCertifiedAt)) return false;
        final java.lang.Object this$microStrategyIsCertified = this.getMicroStrategyIsCertified();
        final java.lang.Object other$microStrategyIsCertified = other.getMicroStrategyIsCertified();
        if (this$microStrategyIsCertified == null ? other$microStrategyIsCertified != null : !this$microStrategyIsCertified.equals(other$microStrategyIsCertified)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$microStrategyAttributeNames = this.getMicroStrategyAttributeNames();
        final java.lang.Object other$microStrategyAttributeNames = other.getMicroStrategyAttributeNames();
        if (this$microStrategyAttributeNames == null ? other$microStrategyAttributeNames != null : !this$microStrategyAttributeNames.equals(other$microStrategyAttributeNames)) return false;
        final java.lang.Object this$microStrategyAttributeQualifiedNames = this.getMicroStrategyAttributeQualifiedNames();
        final java.lang.Object other$microStrategyAttributeQualifiedNames = other.getMicroStrategyAttributeQualifiedNames();
        if (this$microStrategyAttributeQualifiedNames == null ? other$microStrategyAttributeQualifiedNames != null : !this$microStrategyAttributeQualifiedNames.equals(other$microStrategyAttributeQualifiedNames)) return false;
        final java.lang.Object this$microStrategyAttributes = this.getMicroStrategyAttributes();
        final java.lang.Object other$microStrategyAttributes = other.getMicroStrategyAttributes();
        if (this$microStrategyAttributes == null ? other$microStrategyAttributes != null : !this$microStrategyAttributes.equals(other$microStrategyAttributes)) return false;
        final java.lang.Object this$microStrategyCertifiedBy = this.getMicroStrategyCertifiedBy();
        final java.lang.Object other$microStrategyCertifiedBy = other.getMicroStrategyCertifiedBy();
        if (this$microStrategyCertifiedBy == null ? other$microStrategyCertifiedBy != null : !this$microStrategyCertifiedBy.equals(other$microStrategyCertifiedBy)) return false;
        final java.lang.Object this$microStrategyCubeNames = this.getMicroStrategyCubeNames();
        final java.lang.Object other$microStrategyCubeNames = other.getMicroStrategyCubeNames();
        if (this$microStrategyCubeNames == null ? other$microStrategyCubeNames != null : !this$microStrategyCubeNames.equals(other$microStrategyCubeNames)) return false;
        final java.lang.Object this$microStrategyCubeQualifiedNames = this.getMicroStrategyCubeQualifiedNames();
        final java.lang.Object other$microStrategyCubeQualifiedNames = other.getMicroStrategyCubeQualifiedNames();
        if (this$microStrategyCubeQualifiedNames == null ? other$microStrategyCubeQualifiedNames != null : !this$microStrategyCubeQualifiedNames.equals(other$microStrategyCubeQualifiedNames)) return false;
        final java.lang.Object this$microStrategyCubes = this.getMicroStrategyCubes();
        final java.lang.Object other$microStrategyCubes = other.getMicroStrategyCubes();
        if (this$microStrategyCubes == null ? other$microStrategyCubes != null : !this$microStrategyCubes.equals(other$microStrategyCubes)) return false;
        final java.lang.Object this$microStrategyFactNames = this.getMicroStrategyFactNames();
        final java.lang.Object other$microStrategyFactNames = other.getMicroStrategyFactNames();
        if (this$microStrategyFactNames == null ? other$microStrategyFactNames != null : !this$microStrategyFactNames.equals(other$microStrategyFactNames)) return false;
        final java.lang.Object this$microStrategyFactQualifiedNames = this.getMicroStrategyFactQualifiedNames();
        final java.lang.Object other$microStrategyFactQualifiedNames = other.getMicroStrategyFactQualifiedNames();
        if (this$microStrategyFactQualifiedNames == null ? other$microStrategyFactQualifiedNames != null : !this$microStrategyFactQualifiedNames.equals(other$microStrategyFactQualifiedNames)) return false;
        final java.lang.Object this$microStrategyFacts = this.getMicroStrategyFacts();
        final java.lang.Object other$microStrategyFacts = other.getMicroStrategyFacts();
        if (this$microStrategyFacts == null ? other$microStrategyFacts != null : !this$microStrategyFacts.equals(other$microStrategyFacts)) return false;
        final java.lang.Object this$microStrategyLocation = this.getMicroStrategyLocation();
        final java.lang.Object other$microStrategyLocation = other.getMicroStrategyLocation();
        if (this$microStrategyLocation == null ? other$microStrategyLocation != null : !this$microStrategyLocation.equals(other$microStrategyLocation)) return false;
        final java.lang.Object this$microStrategyMetricChildren = this.getMicroStrategyMetricChildren();
        final java.lang.Object other$microStrategyMetricChildren = other.getMicroStrategyMetricChildren();
        if (this$microStrategyMetricChildren == null ? other$microStrategyMetricChildren != null : !this$microStrategyMetricChildren.equals(other$microStrategyMetricChildren)) return false;
        final java.lang.Object this$microStrategyMetricExpression = this.getMicroStrategyMetricExpression();
        final java.lang.Object other$microStrategyMetricExpression = other.getMicroStrategyMetricExpression();
        if (this$microStrategyMetricExpression == null ? other$microStrategyMetricExpression != null : !this$microStrategyMetricExpression.equals(other$microStrategyMetricExpression)) return false;
        final java.lang.Object this$microStrategyMetricParentNames = this.getMicroStrategyMetricParentNames();
        final java.lang.Object other$microStrategyMetricParentNames = other.getMicroStrategyMetricParentNames();
        if (this$microStrategyMetricParentNames == null ? other$microStrategyMetricParentNames != null : !this$microStrategyMetricParentNames.equals(other$microStrategyMetricParentNames)) return false;
        final java.lang.Object this$microStrategyMetricParentQualifiedNames = this.getMicroStrategyMetricParentQualifiedNames();
        final java.lang.Object other$microStrategyMetricParentQualifiedNames = other.getMicroStrategyMetricParentQualifiedNames();
        if (this$microStrategyMetricParentQualifiedNames == null ? other$microStrategyMetricParentQualifiedNames != null : !this$microStrategyMetricParentQualifiedNames.equals(other$microStrategyMetricParentQualifiedNames)) return false;
        final java.lang.Object this$microStrategyMetricParents = this.getMicroStrategyMetricParents();
        final java.lang.Object other$microStrategyMetricParents = other.getMicroStrategyMetricParents();
        if (this$microStrategyMetricParents == null ? other$microStrategyMetricParents != null : !this$microStrategyMetricParents.equals(other$microStrategyMetricParents)) return false;
        final java.lang.Object this$microStrategyProject = this.getMicroStrategyProject();
        final java.lang.Object other$microStrategyProject = other.getMicroStrategyProject();
        if (this$microStrategyProject == null ? other$microStrategyProject != null : !this$microStrategyProject.equals(other$microStrategyProject)) return false;
        final java.lang.Object this$microStrategyProjectName = this.getMicroStrategyProjectName();
        final java.lang.Object other$microStrategyProjectName = other.getMicroStrategyProjectName();
        if (this$microStrategyProjectName == null ? other$microStrategyProjectName != null : !this$microStrategyProjectName.equals(other$microStrategyProjectName)) return false;
        final java.lang.Object this$microStrategyProjectQualifiedName = this.getMicroStrategyProjectQualifiedName();
        final java.lang.Object other$microStrategyProjectQualifiedName = other.getMicroStrategyProjectQualifiedName();
        if (this$microStrategyProjectQualifiedName == null ? other$microStrategyProjectQualifiedName != null : !this$microStrategyProjectQualifiedName.equals(other$microStrategyProjectQualifiedName)) return false;
        final java.lang.Object this$microStrategyReportNames = this.getMicroStrategyReportNames();
        final java.lang.Object other$microStrategyReportNames = other.getMicroStrategyReportNames();
        if (this$microStrategyReportNames == null ? other$microStrategyReportNames != null : !this$microStrategyReportNames.equals(other$microStrategyReportNames)) return false;
        final java.lang.Object this$microStrategyReportQualifiedNames = this.getMicroStrategyReportQualifiedNames();
        final java.lang.Object other$microStrategyReportQualifiedNames = other.getMicroStrategyReportQualifiedNames();
        if (this$microStrategyReportQualifiedNames == null ? other$microStrategyReportQualifiedNames != null : !this$microStrategyReportQualifiedNames.equals(other$microStrategyReportQualifiedNames)) return false;
        final java.lang.Object this$microStrategyReports = this.getMicroStrategyReports();
        final java.lang.Object other$microStrategyReports = other.getMicroStrategyReports();
        if (this$microStrategyReports == null ? other$microStrategyReports != null : !this$microStrategyReports.equals(other$microStrategyReports)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MicroStrategyMetric;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $microStrategyCertifiedAt = this.getMicroStrategyCertifiedAt();
        result = result * PRIME + ($microStrategyCertifiedAt == null ? 43 : $microStrategyCertifiedAt.hashCode());
        final java.lang.Object $microStrategyIsCertified = this.getMicroStrategyIsCertified();
        result = result * PRIME + ($microStrategyIsCertified == null ? 43 : $microStrategyIsCertified.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $microStrategyAttributeNames = this.getMicroStrategyAttributeNames();
        result = result * PRIME + ($microStrategyAttributeNames == null ? 43 : $microStrategyAttributeNames.hashCode());
        final java.lang.Object $microStrategyAttributeQualifiedNames = this.getMicroStrategyAttributeQualifiedNames();
        result = result * PRIME + ($microStrategyAttributeQualifiedNames == null ? 43 : $microStrategyAttributeQualifiedNames.hashCode());
        final java.lang.Object $microStrategyAttributes = this.getMicroStrategyAttributes();
        result = result * PRIME + ($microStrategyAttributes == null ? 43 : $microStrategyAttributes.hashCode());
        final java.lang.Object $microStrategyCertifiedBy = this.getMicroStrategyCertifiedBy();
        result = result * PRIME + ($microStrategyCertifiedBy == null ? 43 : $microStrategyCertifiedBy.hashCode());
        final java.lang.Object $microStrategyCubeNames = this.getMicroStrategyCubeNames();
        result = result * PRIME + ($microStrategyCubeNames == null ? 43 : $microStrategyCubeNames.hashCode());
        final java.lang.Object $microStrategyCubeQualifiedNames = this.getMicroStrategyCubeQualifiedNames();
        result = result * PRIME + ($microStrategyCubeQualifiedNames == null ? 43 : $microStrategyCubeQualifiedNames.hashCode());
        final java.lang.Object $microStrategyCubes = this.getMicroStrategyCubes();
        result = result * PRIME + ($microStrategyCubes == null ? 43 : $microStrategyCubes.hashCode());
        final java.lang.Object $microStrategyFactNames = this.getMicroStrategyFactNames();
        result = result * PRIME + ($microStrategyFactNames == null ? 43 : $microStrategyFactNames.hashCode());
        final java.lang.Object $microStrategyFactQualifiedNames = this.getMicroStrategyFactQualifiedNames();
        result = result * PRIME + ($microStrategyFactQualifiedNames == null ? 43 : $microStrategyFactQualifiedNames.hashCode());
        final java.lang.Object $microStrategyFacts = this.getMicroStrategyFacts();
        result = result * PRIME + ($microStrategyFacts == null ? 43 : $microStrategyFacts.hashCode());
        final java.lang.Object $microStrategyLocation = this.getMicroStrategyLocation();
        result = result * PRIME + ($microStrategyLocation == null ? 43 : $microStrategyLocation.hashCode());
        final java.lang.Object $microStrategyMetricChildren = this.getMicroStrategyMetricChildren();
        result = result * PRIME + ($microStrategyMetricChildren == null ? 43 : $microStrategyMetricChildren.hashCode());
        final java.lang.Object $microStrategyMetricExpression = this.getMicroStrategyMetricExpression();
        result = result * PRIME + ($microStrategyMetricExpression == null ? 43 : $microStrategyMetricExpression.hashCode());
        final java.lang.Object $microStrategyMetricParentNames = this.getMicroStrategyMetricParentNames();
        result = result * PRIME + ($microStrategyMetricParentNames == null ? 43 : $microStrategyMetricParentNames.hashCode());
        final java.lang.Object $microStrategyMetricParentQualifiedNames = this.getMicroStrategyMetricParentQualifiedNames();
        result = result * PRIME + ($microStrategyMetricParentQualifiedNames == null ? 43 : $microStrategyMetricParentQualifiedNames.hashCode());
        final java.lang.Object $microStrategyMetricParents = this.getMicroStrategyMetricParents();
        result = result * PRIME + ($microStrategyMetricParents == null ? 43 : $microStrategyMetricParents.hashCode());
        final java.lang.Object $microStrategyProject = this.getMicroStrategyProject();
        result = result * PRIME + ($microStrategyProject == null ? 43 : $microStrategyProject.hashCode());
        final java.lang.Object $microStrategyProjectName = this.getMicroStrategyProjectName();
        result = result * PRIME + ($microStrategyProjectName == null ? 43 : $microStrategyProjectName.hashCode());
        final java.lang.Object $microStrategyProjectQualifiedName = this.getMicroStrategyProjectQualifiedName();
        result = result * PRIME + ($microStrategyProjectQualifiedName == null ? 43 : $microStrategyProjectQualifiedName.hashCode());
        final java.lang.Object $microStrategyReportNames = this.getMicroStrategyReportNames();
        result = result * PRIME + ($microStrategyReportNames == null ? 43 : $microStrategyReportNames.hashCode());
        final java.lang.Object $microStrategyReportQualifiedNames = this.getMicroStrategyReportQualifiedNames();
        result = result * PRIME + ($microStrategyReportQualifiedNames == null ? 43 : $microStrategyReportQualifiedNames.hashCode());
        final java.lang.Object $microStrategyReports = this.getMicroStrategyReports();
        result = result * PRIME + ($microStrategyReports == null ? 43 : $microStrategyReports.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MicroStrategyMetric(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", microStrategyAttributeNames=" + this.getMicroStrategyAttributeNames() + ", microStrategyAttributeQualifiedNames=" + this.getMicroStrategyAttributeQualifiedNames() + ", microStrategyAttributes=" + this.getMicroStrategyAttributes() + ", microStrategyCertifiedAt=" + this.getMicroStrategyCertifiedAt() + ", microStrategyCertifiedBy=" + this.getMicroStrategyCertifiedBy() + ", microStrategyCubeNames=" + this.getMicroStrategyCubeNames() + ", microStrategyCubeQualifiedNames=" + this.getMicroStrategyCubeQualifiedNames() + ", microStrategyCubes=" + this.getMicroStrategyCubes() + ", microStrategyFactNames=" + this.getMicroStrategyFactNames() + ", microStrategyFactQualifiedNames=" + this.getMicroStrategyFactQualifiedNames() + ", microStrategyFacts=" + this.getMicroStrategyFacts() + ", microStrategyIsCertified=" + this.getMicroStrategyIsCertified() + ", microStrategyLocation=" + this.getMicroStrategyLocation() + ", microStrategyMetricChildren=" + this.getMicroStrategyMetricChildren() + ", microStrategyMetricExpression=" + this.getMicroStrategyMetricExpression() + ", microStrategyMetricParentNames=" + this.getMicroStrategyMetricParentNames() + ", microStrategyMetricParentQualifiedNames=" + this.getMicroStrategyMetricParentQualifiedNames() + ", microStrategyMetricParents=" + this.getMicroStrategyMetricParents() + ", microStrategyProject=" + this.getMicroStrategyProject() + ", microStrategyProjectName=" + this.getMicroStrategyProjectName() + ", microStrategyProjectQualifiedName=" + this.getMicroStrategyProjectQualifiedName() + ", microStrategyReportNames=" + this.getMicroStrategyReportNames() + ", microStrategyReportQualifiedNames=" + this.getMicroStrategyReportQualifiedNames() + ", microStrategyReports=" + this.getMicroStrategyReports() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for MicroStrategyMetrics.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
