// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a MicroStrategy project in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class MicroStrategyProject extends Asset implements IMicroStrategyProject, IMicroStrategy, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(MicroStrategyProject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MicroStrategyProject";
    /**
     * Fixed typeName for MicroStrategyProjects.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Attributes that exist within this project.
     */
    @Attribute
    SortedSet<IMicroStrategyAttribute> microStrategyAttributes;
    /**
     * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
     */
    @Attribute
    @Date
    Long microStrategyCertifiedAt;
    /**
     * User who certified this asset, in MicroStrategy.
     */
    @Attribute
    String microStrategyCertifiedBy;
    /**
     * Simple names of the cubes related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyCubeNames;
    /**
     * Unique names of the cubes related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyCubeQualifiedNames;
    /**
     * Cubes that exist within this project.
     */
    @Attribute
    SortedSet<IMicroStrategyCube> microStrategyCubes;
    /**
     * Documents that exist within this project.
     */
    @Attribute
    SortedSet<IMicroStrategyDocument> microStrategyDocuments;
    /**
     * Dossiers that exist within this project.
     */
    @Attribute
    SortedSet<IMicroStrategyDossier> microStrategyDossiers;
    /**
     * Facts that exist within this project.
     */
    @Attribute
    SortedSet<IMicroStrategyFact> microStrategyFacts;
    /**
     * Whether the asset is certified in MicroStrategy (true) or not (false).
     */
    @Attribute
    Boolean microStrategyIsCertified;
    /**
     * Location of this asset in MicroStrategy.
     */
    @Attribute
    List<Map<String, String>> microStrategyLocation;
    /**
     * Metrics that exist within this project.
     */
    @Attribute
    SortedSet<IMicroStrategyMetric> microStrategyMetrics;
    /**
     * Simple name of the project in which this asset exists.
     */
    @Attribute
    String microStrategyProjectName;
    /**
     * Unique name of the project in which this asset exists.
     */
    @Attribute
    String microStrategyProjectQualifiedName;
    /**
     * Simple names of the reports related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyReportNames;
    /**
     * Unique names of the reports related to this asset.
     */
    @Attribute
    SortedSet<String> microStrategyReportQualifiedNames;
    /**
     * Reports that exist within this project.
     */
    @Attribute
    SortedSet<IMicroStrategyReport> microStrategyReports;
    /**
     * Visualizations that exist within this project.
     */
    @Attribute
    SortedSet<IMicroStrategyVisualization> microStrategyVisualizations;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a MicroStrategyProject, from a potentially
     * more-complete MicroStrategyProject object.
     *
     * @return the minimal object necessary to relate to the MicroStrategyProject
     * @throws InvalidRequestException if any of the minimal set of required properties for a MicroStrategyProject relationship are not found in the initial object
     */
    @Override
    public MicroStrategyProject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all MicroStrategyProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MicroStrategyProject assets will be included.
     *
     * @return a fluent search that includes all MicroStrategyProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all MicroStrategyProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) MicroStrategyProject assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all MicroStrategyProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all MicroStrategyProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) MicroStrategyProjects will be included
     * @return a fluent search that includes all MicroStrategyProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all MicroStrategyProject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) MicroStrategyProjects will be included
     * @return a fluent search that includes all MicroStrategyProject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a MicroStrategyProject by GUID. Use this to create a relationship to this MicroStrategyProject,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the MicroStrategyProject to reference
     * @return reference to a MicroStrategyProject that can be used for defining a relationship to a MicroStrategyProject
     */
    public static MicroStrategyProject refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MicroStrategyProject by GUID. Use this to create a relationship to this MicroStrategyProject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the MicroStrategyProject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MicroStrategyProject that can be used for defining a relationship to a MicroStrategyProject
     */
    public static MicroStrategyProject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return MicroStrategyProject._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a MicroStrategyProject by qualifiedName. Use this to create a relationship to this MicroStrategyProject,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the MicroStrategyProject to reference
     * @return reference to a MicroStrategyProject that can be used for defining a relationship to a MicroStrategyProject
     */
    public static MicroStrategyProject refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a MicroStrategyProject by qualifiedName. Use this to create a relationship to this MicroStrategyProject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the MicroStrategyProject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a MicroStrategyProject that can be used for defining a relationship to a MicroStrategyProject
     */
    public static MicroStrategyProject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return MicroStrategyProject._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a MicroStrategyProject by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the MicroStrategyProject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MicroStrategyProject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyProject does not exist or the provided GUID is not a MicroStrategyProject
     */
    @JsonIgnore
    public static MicroStrategyProject get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a MicroStrategyProject by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MicroStrategyProject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full MicroStrategyProject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyProject does not exist or the provided GUID is not a MicroStrategyProject
     */
    @JsonIgnore
    public static MicroStrategyProject get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a MicroStrategyProject by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the MicroStrategyProject to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full MicroStrategyProject, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the MicroStrategyProject does not exist or the provided GUID is not a MicroStrategyProject
     */
    @JsonIgnore
    public static MicroStrategyProject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof MicroStrategyProject) {
                return (MicroStrategyProject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof MicroStrategyProject) {
                return (MicroStrategyProject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) MicroStrategyProject to active.
     *
     * @param qualifiedName for the MicroStrategyProject
     * @return true if the MicroStrategyProject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) MicroStrategyProject to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the MicroStrategyProject
     * @return true if the MicroStrategyProject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the minimal request necessary to update the MicroStrategyProject, as a builder
     */
    public static MicroStrategyProjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return MicroStrategyProject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a MicroStrategyProject, from a potentially
     * more-complete MicroStrategyProject object.
     *
     * @return the minimal object necessary to update the MicroStrategyProject, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for MicroStrategyProject are not found in the initial object
     */
    @Override
    public MicroStrategyProjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a MicroStrategyProject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyProject) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a MicroStrategyProject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyProject) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a MicroStrategyProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MicroStrategyProject's owners
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyProject) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MicroStrategyProject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a MicroStrategyProject.
     *
     * @param client connectivity to the Atlan tenant on which to update the MicroStrategyProject's certificate
     * @param qualifiedName of the MicroStrategyProject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated MicroStrategyProject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MicroStrategyProject) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a MicroStrategyProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the MicroStrategyProject's certificate
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyProject) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a MicroStrategyProject.
     *
     * @param client connectivity to the Atlan tenant on which to update the MicroStrategyProject's announcement
     * @param qualifiedName of the MicroStrategyProject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MicroStrategyProject) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a MicroStrategyProject.
     *
     * @param client connectivity to the Atlan client from which to remove the MicroStrategyProject's announcement
     * @param qualifiedName of the MicroStrategyProject
     * @param name of the MicroStrategyProject
     * @return the updated MicroStrategyProject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyProject) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the MicroStrategyProject.
     *
     * @param qualifiedName for the MicroStrategyProject
     * @param name human-readable name of the MicroStrategyProject
     * @param terms the list of terms to replace on the MicroStrategyProject, or null to remove all terms from the MicroStrategyProject
     * @return the MicroStrategyProject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the MicroStrategyProject.
     *
     * @param client connectivity to the Atlan tenant on which to replace the MicroStrategyProject's assigned terms
     * @param qualifiedName for the MicroStrategyProject
     * @param name human-readable name of the MicroStrategyProject
     * @param terms the list of terms to replace on the MicroStrategyProject, or null to remove all terms from the MicroStrategyProject
     * @return the MicroStrategyProject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyProject) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the MicroStrategyProject, without replacing existing terms linked to the MicroStrategyProject.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyProject's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the MicroStrategyProject
     * @param terms the list of terms to append to the MicroStrategyProject
     * @return the MicroStrategyProject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the MicroStrategyProject, without replacing existing terms linked to the MicroStrategyProject.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyProject's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the MicroStrategyProject
     * @param qualifiedName for the MicroStrategyProject
     * @param terms the list of terms to append to the MicroStrategyProject
     * @return the MicroStrategyProject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyProject) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a MicroStrategyProject, without replacing all existing terms linked to the MicroStrategyProject.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyProject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the MicroStrategyProject
     * @param terms the list of terms to remove from the MicroStrategyProject, which must be referenced by GUID
     * @return the MicroStrategyProject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a MicroStrategyProject, without replacing all existing terms linked to the MicroStrategyProject.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyProject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the MicroStrategyProject
     * @param qualifiedName for the MicroStrategyProject
     * @param terms the list of terms to remove from the MicroStrategyProject, which must be referenced by GUID
     * @return the MicroStrategyProject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static MicroStrategyProject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyProject) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a MicroStrategyProject, without replacing existing Atlan tags linked to the MicroStrategyProject.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyProject
     */
    public static MicroStrategyProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MicroStrategyProject, without replacing existing Atlan tags linked to the MicroStrategyProject.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MicroStrategyProject
     * @param qualifiedName of the MicroStrategyProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyProject
     */
    public static MicroStrategyProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MicroStrategyProject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a MicroStrategyProject, without replacing existing Atlan tags linked to the MicroStrategyProject.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyProject
     */
    public static MicroStrategyProject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a MicroStrategyProject, without replacing existing Atlan tags linked to the MicroStrategyProject.
     * Note: this operation must make two API calls — one to retrieve the MicroStrategyProject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the MicroStrategyProject
     * @param qualifiedName of the MicroStrategyProject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated MicroStrategyProject
     */
    public static MicroStrategyProject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MicroStrategyProject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a MicroStrategyProject.
     *
     * @param qualifiedName of the MicroStrategyProject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MicroStrategyProject
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a MicroStrategyProject.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a MicroStrategyProject
     * @param qualifiedName of the MicroStrategyProject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the MicroStrategyProject
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class MicroStrategyProjectBuilder<C extends MicroStrategyProject, B extends MicroStrategyProject.MicroStrategyProjectBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyAttribute> microStrategyAttributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long microStrategyCertifiedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyCertifiedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyCubeNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyCubeQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyCube> microStrategyCubes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyDocument> microStrategyDocuments;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyDossier> microStrategyDossiers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyFact> microStrategyFacts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean microStrategyIsCertified;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> microStrategyLocation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyMetric> microStrategyMetrics;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyProjectName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String microStrategyProjectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyReportNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> microStrategyReportQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyReport> microStrategyReports;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMicroStrategyVisualization> microStrategyVisualizations;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            MicroStrategyProject.MicroStrategyProjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final MicroStrategyProject instance, final MicroStrategyProject.MicroStrategyProjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.microStrategyAttributes(instance.microStrategyAttributes == null ? java.util.Collections.<IMicroStrategyAttribute>emptySortedSet() : instance.microStrategyAttributes);
            b.microStrategyCertifiedAt(instance.microStrategyCertifiedAt);
            b.microStrategyCertifiedBy(instance.microStrategyCertifiedBy);
            b.microStrategyCubeNames(instance.microStrategyCubeNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyCubeNames);
            b.microStrategyCubeQualifiedNames(instance.microStrategyCubeQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyCubeQualifiedNames);
            b.microStrategyCubes(instance.microStrategyCubes == null ? java.util.Collections.<IMicroStrategyCube>emptySortedSet() : instance.microStrategyCubes);
            b.microStrategyDocuments(instance.microStrategyDocuments == null ? java.util.Collections.<IMicroStrategyDocument>emptySortedSet() : instance.microStrategyDocuments);
            b.microStrategyDossiers(instance.microStrategyDossiers == null ? java.util.Collections.<IMicroStrategyDossier>emptySortedSet() : instance.microStrategyDossiers);
            b.microStrategyFacts(instance.microStrategyFacts == null ? java.util.Collections.<IMicroStrategyFact>emptySortedSet() : instance.microStrategyFacts);
            b.microStrategyIsCertified(instance.microStrategyIsCertified);
            b.microStrategyLocation(instance.microStrategyLocation == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.microStrategyLocation);
            b.microStrategyMetrics(instance.microStrategyMetrics == null ? java.util.Collections.<IMicroStrategyMetric>emptySortedSet() : instance.microStrategyMetrics);
            b.microStrategyProjectName(instance.microStrategyProjectName);
            b.microStrategyProjectQualifiedName(instance.microStrategyProjectQualifiedName);
            b.microStrategyReportNames(instance.microStrategyReportNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyReportNames);
            b.microStrategyReportQualifiedNames(instance.microStrategyReportQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.microStrategyReportQualifiedNames);
            b.microStrategyReports(instance.microStrategyReports == null ? java.util.Collections.<IMicroStrategyReport>emptySortedSet() : instance.microStrategyReports);
            b.microStrategyVisualizations(instance.microStrategyVisualizations == null ? java.util.Collections.<IMicroStrategyVisualization>emptySortedSet() : instance.microStrategyVisualizations);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for MicroStrategyProjects.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyAttribute(final IMicroStrategyAttribute microStrategyAttribute) {
            if (this.microStrategyAttributes == null) this.microStrategyAttributes = new java.util.ArrayList<IMicroStrategyAttribute>();
            this.microStrategyAttributes.add(microStrategyAttribute);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyAttributes(final java.util.Collection<? extends IMicroStrategyAttribute> microStrategyAttributes) {
            if (microStrategyAttributes == null) {
                throw new java.lang.NullPointerException("microStrategyAttributes cannot be null");
            }
            if (this.microStrategyAttributes == null) this.microStrategyAttributes = new java.util.ArrayList<IMicroStrategyAttribute>();
            this.microStrategyAttributes.addAll(microStrategyAttributes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyAttributes() {
            if (this.microStrategyAttributes != null) this.microStrategyAttributes.clear();
            return self();
        }

        /**
         * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCertifiedAt(final Long microStrategyCertifiedAt) {
            this.microStrategyCertifiedAt = microStrategyCertifiedAt;
            return self();
        }

        /**
         * User who certified this asset, in MicroStrategy.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCertifiedBy(final String microStrategyCertifiedBy) {
            this.microStrategyCertifiedBy = microStrategyCertifiedBy;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeName(final String microStrategyCubeName) {
            if (this.microStrategyCubeNames == null) this.microStrategyCubeNames = new java.util.ArrayList<String>();
            this.microStrategyCubeNames.add(microStrategyCubeName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeNames(final java.util.Collection<? extends String> microStrategyCubeNames) {
            if (microStrategyCubeNames == null) {
                throw new java.lang.NullPointerException("microStrategyCubeNames cannot be null");
            }
            if (this.microStrategyCubeNames == null) this.microStrategyCubeNames = new java.util.ArrayList<String>();
            this.microStrategyCubeNames.addAll(microStrategyCubeNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyCubeNames() {
            if (this.microStrategyCubeNames != null) this.microStrategyCubeNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeQualifiedName(final String microStrategyCubeQualifiedName) {
            if (this.microStrategyCubeQualifiedNames == null) this.microStrategyCubeQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyCubeQualifiedNames.add(microStrategyCubeQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubeQualifiedNames(final java.util.Collection<? extends String> microStrategyCubeQualifiedNames) {
            if (microStrategyCubeQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyCubeQualifiedNames cannot be null");
            }
            if (this.microStrategyCubeQualifiedNames == null) this.microStrategyCubeQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyCubeQualifiedNames.addAll(microStrategyCubeQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyCubeQualifiedNames() {
            if (this.microStrategyCubeQualifiedNames != null) this.microStrategyCubeQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCube(final IMicroStrategyCube microStrategyCube) {
            if (this.microStrategyCubes == null) this.microStrategyCubes = new java.util.ArrayList<IMicroStrategyCube>();
            this.microStrategyCubes.add(microStrategyCube);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyCubes(final java.util.Collection<? extends IMicroStrategyCube> microStrategyCubes) {
            if (microStrategyCubes == null) {
                throw new java.lang.NullPointerException("microStrategyCubes cannot be null");
            }
            if (this.microStrategyCubes == null) this.microStrategyCubes = new java.util.ArrayList<IMicroStrategyCube>();
            this.microStrategyCubes.addAll(microStrategyCubes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyCubes() {
            if (this.microStrategyCubes != null) this.microStrategyCubes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyDocument(final IMicroStrategyDocument microStrategyDocument) {
            if (this.microStrategyDocuments == null) this.microStrategyDocuments = new java.util.ArrayList<IMicroStrategyDocument>();
            this.microStrategyDocuments.add(microStrategyDocument);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyDocuments(final java.util.Collection<? extends IMicroStrategyDocument> microStrategyDocuments) {
            if (microStrategyDocuments == null) {
                throw new java.lang.NullPointerException("microStrategyDocuments cannot be null");
            }
            if (this.microStrategyDocuments == null) this.microStrategyDocuments = new java.util.ArrayList<IMicroStrategyDocument>();
            this.microStrategyDocuments.addAll(microStrategyDocuments);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyDocuments() {
            if (this.microStrategyDocuments != null) this.microStrategyDocuments.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyDossier(final IMicroStrategyDossier microStrategyDossier) {
            if (this.microStrategyDossiers == null) this.microStrategyDossiers = new java.util.ArrayList<IMicroStrategyDossier>();
            this.microStrategyDossiers.add(microStrategyDossier);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyDossiers(final java.util.Collection<? extends IMicroStrategyDossier> microStrategyDossiers) {
            if (microStrategyDossiers == null) {
                throw new java.lang.NullPointerException("microStrategyDossiers cannot be null");
            }
            if (this.microStrategyDossiers == null) this.microStrategyDossiers = new java.util.ArrayList<IMicroStrategyDossier>();
            this.microStrategyDossiers.addAll(microStrategyDossiers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyDossiers() {
            if (this.microStrategyDossiers != null) this.microStrategyDossiers.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyFact(final IMicroStrategyFact microStrategyFact) {
            if (this.microStrategyFacts == null) this.microStrategyFacts = new java.util.ArrayList<IMicroStrategyFact>();
            this.microStrategyFacts.add(microStrategyFact);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyFacts(final java.util.Collection<? extends IMicroStrategyFact> microStrategyFacts) {
            if (microStrategyFacts == null) {
                throw new java.lang.NullPointerException("microStrategyFacts cannot be null");
            }
            if (this.microStrategyFacts == null) this.microStrategyFacts = new java.util.ArrayList<IMicroStrategyFact>();
            this.microStrategyFacts.addAll(microStrategyFacts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyFacts() {
            if (this.microStrategyFacts != null) this.microStrategyFacts.clear();
            return self();
        }

        /**
         * Whether the asset is certified in MicroStrategy (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyIsCertified(final Boolean microStrategyIsCertified) {
            this.microStrategyIsCertified = microStrategyIsCertified;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putMicroStrategyLocation(final Map<String, String> putMicroStrategyLocation) {
            if (this.microStrategyLocation == null) this.microStrategyLocation = new java.util.ArrayList<Map<String, String>>();
            this.microStrategyLocation.add(putMicroStrategyLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyLocation(final java.util.Collection<? extends Map<String, String>> microStrategyLocation) {
            if (microStrategyLocation == null) {
                throw new java.lang.NullPointerException("microStrategyLocation cannot be null");
            }
            if (this.microStrategyLocation == null) this.microStrategyLocation = new java.util.ArrayList<Map<String, String>>();
            this.microStrategyLocation.addAll(microStrategyLocation);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyLocation() {
            if (this.microStrategyLocation != null) this.microStrategyLocation.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetric(final IMicroStrategyMetric microStrategyMetric) {
            if (this.microStrategyMetrics == null) this.microStrategyMetrics = new java.util.ArrayList<IMicroStrategyMetric>();
            this.microStrategyMetrics.add(microStrategyMetric);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyMetrics(final java.util.Collection<? extends IMicroStrategyMetric> microStrategyMetrics) {
            if (microStrategyMetrics == null) {
                throw new java.lang.NullPointerException("microStrategyMetrics cannot be null");
            }
            if (this.microStrategyMetrics == null) this.microStrategyMetrics = new java.util.ArrayList<IMicroStrategyMetric>();
            this.microStrategyMetrics.addAll(microStrategyMetrics);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyMetrics() {
            if (this.microStrategyMetrics != null) this.microStrategyMetrics.clear();
            return self();
        }

        /**
         * Simple name of the project in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyProjectName(final String microStrategyProjectName) {
            this.microStrategyProjectName = microStrategyProjectName;
            return self();
        }

        /**
         * Unique name of the project in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyProjectQualifiedName(final String microStrategyProjectQualifiedName) {
            this.microStrategyProjectQualifiedName = microStrategyProjectQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportName(final String microStrategyReportName) {
            if (this.microStrategyReportNames == null) this.microStrategyReportNames = new java.util.ArrayList<String>();
            this.microStrategyReportNames.add(microStrategyReportName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportNames(final java.util.Collection<? extends String> microStrategyReportNames) {
            if (microStrategyReportNames == null) {
                throw new java.lang.NullPointerException("microStrategyReportNames cannot be null");
            }
            if (this.microStrategyReportNames == null) this.microStrategyReportNames = new java.util.ArrayList<String>();
            this.microStrategyReportNames.addAll(microStrategyReportNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyReportNames() {
            if (this.microStrategyReportNames != null) this.microStrategyReportNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportQualifiedName(final String microStrategyReportQualifiedName) {
            if (this.microStrategyReportQualifiedNames == null) this.microStrategyReportQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyReportQualifiedNames.add(microStrategyReportQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReportQualifiedNames(final java.util.Collection<? extends String> microStrategyReportQualifiedNames) {
            if (microStrategyReportQualifiedNames == null) {
                throw new java.lang.NullPointerException("microStrategyReportQualifiedNames cannot be null");
            }
            if (this.microStrategyReportQualifiedNames == null) this.microStrategyReportQualifiedNames = new java.util.ArrayList<String>();
            this.microStrategyReportQualifiedNames.addAll(microStrategyReportQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyReportQualifiedNames() {
            if (this.microStrategyReportQualifiedNames != null) this.microStrategyReportQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReport(final IMicroStrategyReport microStrategyReport) {
            if (this.microStrategyReports == null) this.microStrategyReports = new java.util.ArrayList<IMicroStrategyReport>();
            this.microStrategyReports.add(microStrategyReport);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyReports(final java.util.Collection<? extends IMicroStrategyReport> microStrategyReports) {
            if (microStrategyReports == null) {
                throw new java.lang.NullPointerException("microStrategyReports cannot be null");
            }
            if (this.microStrategyReports == null) this.microStrategyReports = new java.util.ArrayList<IMicroStrategyReport>();
            this.microStrategyReports.addAll(microStrategyReports);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyReports() {
            if (this.microStrategyReports != null) this.microStrategyReports.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyVisualization(final IMicroStrategyVisualization microStrategyVisualization) {
            if (this.microStrategyVisualizations == null) this.microStrategyVisualizations = new java.util.ArrayList<IMicroStrategyVisualization>();
            this.microStrategyVisualizations.add(microStrategyVisualization);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B microStrategyVisualizations(final java.util.Collection<? extends IMicroStrategyVisualization> microStrategyVisualizations) {
            if (microStrategyVisualizations == null) {
                throw new java.lang.NullPointerException("microStrategyVisualizations cannot be null");
            }
            if (this.microStrategyVisualizations == null) this.microStrategyVisualizations = new java.util.ArrayList<IMicroStrategyVisualization>();
            this.microStrategyVisualizations.addAll(microStrategyVisualizations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMicroStrategyVisualizations() {
            if (this.microStrategyVisualizations != null) this.microStrategyVisualizations.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "MicroStrategyProject.MicroStrategyProjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", microStrategyAttributes=" + this.microStrategyAttributes + ", microStrategyCertifiedAt=" + this.microStrategyCertifiedAt + ", microStrategyCertifiedBy=" + this.microStrategyCertifiedBy + ", microStrategyCubeNames=" + this.microStrategyCubeNames + ", microStrategyCubeQualifiedNames=" + this.microStrategyCubeQualifiedNames + ", microStrategyCubes=" + this.microStrategyCubes + ", microStrategyDocuments=" + this.microStrategyDocuments + ", microStrategyDossiers=" + this.microStrategyDossiers + ", microStrategyFacts=" + this.microStrategyFacts + ", microStrategyIsCertified=" + this.microStrategyIsCertified + ", microStrategyLocation=" + this.microStrategyLocation + ", microStrategyMetrics=" + this.microStrategyMetrics + ", microStrategyProjectName=" + this.microStrategyProjectName + ", microStrategyProjectQualifiedName=" + this.microStrategyProjectQualifiedName + ", microStrategyReportNames=" + this.microStrategyReportNames + ", microStrategyReportQualifiedNames=" + this.microStrategyReportQualifiedNames + ", microStrategyReports=" + this.microStrategyReports + ", microStrategyVisualizations=" + this.microStrategyVisualizations + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class MicroStrategyProjectBuilderImpl extends MicroStrategyProject.MicroStrategyProjectBuilder<MicroStrategyProject, MicroStrategyProject.MicroStrategyProjectBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private MicroStrategyProjectBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected MicroStrategyProject.MicroStrategyProjectBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public MicroStrategyProject build() {
            return new MicroStrategyProject(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected MicroStrategyProject(final MicroStrategyProject.MicroStrategyProjectBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = MicroStrategyProject.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IMicroStrategyAttribute> microStrategyAttributes = new java.util.TreeSet<IMicroStrategyAttribute>();
        if (b.microStrategyAttributes != null) microStrategyAttributes.addAll(b.microStrategyAttributes);
        microStrategyAttributes = java.util.Collections.unmodifiableSortedSet(microStrategyAttributes);
        this.microStrategyAttributes = microStrategyAttributes;
        this.microStrategyCertifiedAt = b.microStrategyCertifiedAt;
        this.microStrategyCertifiedBy = b.microStrategyCertifiedBy;
        java.util.SortedSet<String> microStrategyCubeNames = new java.util.TreeSet<String>();
        if (b.microStrategyCubeNames != null) microStrategyCubeNames.addAll(b.microStrategyCubeNames);
        microStrategyCubeNames = java.util.Collections.unmodifiableSortedSet(microStrategyCubeNames);
        this.microStrategyCubeNames = microStrategyCubeNames;
        java.util.SortedSet<String> microStrategyCubeQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyCubeQualifiedNames != null) microStrategyCubeQualifiedNames.addAll(b.microStrategyCubeQualifiedNames);
        microStrategyCubeQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyCubeQualifiedNames);
        this.microStrategyCubeQualifiedNames = microStrategyCubeQualifiedNames;
        java.util.SortedSet<IMicroStrategyCube> microStrategyCubes = new java.util.TreeSet<IMicroStrategyCube>();
        if (b.microStrategyCubes != null) microStrategyCubes.addAll(b.microStrategyCubes);
        microStrategyCubes = java.util.Collections.unmodifiableSortedSet(microStrategyCubes);
        this.microStrategyCubes = microStrategyCubes;
        java.util.SortedSet<IMicroStrategyDocument> microStrategyDocuments = new java.util.TreeSet<IMicroStrategyDocument>();
        if (b.microStrategyDocuments != null) microStrategyDocuments.addAll(b.microStrategyDocuments);
        microStrategyDocuments = java.util.Collections.unmodifiableSortedSet(microStrategyDocuments);
        this.microStrategyDocuments = microStrategyDocuments;
        java.util.SortedSet<IMicroStrategyDossier> microStrategyDossiers = new java.util.TreeSet<IMicroStrategyDossier>();
        if (b.microStrategyDossiers != null) microStrategyDossiers.addAll(b.microStrategyDossiers);
        microStrategyDossiers = java.util.Collections.unmodifiableSortedSet(microStrategyDossiers);
        this.microStrategyDossiers = microStrategyDossiers;
        java.util.SortedSet<IMicroStrategyFact> microStrategyFacts = new java.util.TreeSet<IMicroStrategyFact>();
        if (b.microStrategyFacts != null) microStrategyFacts.addAll(b.microStrategyFacts);
        microStrategyFacts = java.util.Collections.unmodifiableSortedSet(microStrategyFacts);
        this.microStrategyFacts = microStrategyFacts;
        this.microStrategyIsCertified = b.microStrategyIsCertified;
        java.util.List<Map<String, String>> microStrategyLocation;
        switch (b.microStrategyLocation == null ? 0 : b.microStrategyLocation.size()) {
        case 0: 
            microStrategyLocation = java.util.Collections.emptyList();
            break;
        case 1: 
            microStrategyLocation = java.util.Collections.singletonList(b.microStrategyLocation.get(0));
            break;
        default: 
            microStrategyLocation = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.microStrategyLocation));
        }
        this.microStrategyLocation = microStrategyLocation;
        java.util.SortedSet<IMicroStrategyMetric> microStrategyMetrics = new java.util.TreeSet<IMicroStrategyMetric>();
        if (b.microStrategyMetrics != null) microStrategyMetrics.addAll(b.microStrategyMetrics);
        microStrategyMetrics = java.util.Collections.unmodifiableSortedSet(microStrategyMetrics);
        this.microStrategyMetrics = microStrategyMetrics;
        this.microStrategyProjectName = b.microStrategyProjectName;
        this.microStrategyProjectQualifiedName = b.microStrategyProjectQualifiedName;
        java.util.SortedSet<String> microStrategyReportNames = new java.util.TreeSet<String>();
        if (b.microStrategyReportNames != null) microStrategyReportNames.addAll(b.microStrategyReportNames);
        microStrategyReportNames = java.util.Collections.unmodifiableSortedSet(microStrategyReportNames);
        this.microStrategyReportNames = microStrategyReportNames;
        java.util.SortedSet<String> microStrategyReportQualifiedNames = new java.util.TreeSet<String>();
        if (b.microStrategyReportQualifiedNames != null) microStrategyReportQualifiedNames.addAll(b.microStrategyReportQualifiedNames);
        microStrategyReportQualifiedNames = java.util.Collections.unmodifiableSortedSet(microStrategyReportQualifiedNames);
        this.microStrategyReportQualifiedNames = microStrategyReportQualifiedNames;
        java.util.SortedSet<IMicroStrategyReport> microStrategyReports = new java.util.TreeSet<IMicroStrategyReport>();
        if (b.microStrategyReports != null) microStrategyReports.addAll(b.microStrategyReports);
        microStrategyReports = java.util.Collections.unmodifiableSortedSet(microStrategyReports);
        this.microStrategyReports = microStrategyReports;
        java.util.SortedSet<IMicroStrategyVisualization> microStrategyVisualizations = new java.util.TreeSet<IMicroStrategyVisualization>();
        if (b.microStrategyVisualizations != null) microStrategyVisualizations.addAll(b.microStrategyVisualizations);
        microStrategyVisualizations = java.util.Collections.unmodifiableSortedSet(microStrategyVisualizations);
        this.microStrategyVisualizations = microStrategyVisualizations;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static MicroStrategyProject.MicroStrategyProjectBuilder<?, ?> _internal() {
        return new MicroStrategyProject.MicroStrategyProjectBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public MicroStrategyProject.MicroStrategyProjectBuilder<?, ?> toBuilder() {
        return new MicroStrategyProject.MicroStrategyProjectBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Attributes that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyAttribute> getMicroStrategyAttributes() {
        return this.microStrategyAttributes;
    }

    /**
     * Time (epoch) this asset was certified in MicroStrategy, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMicroStrategyCertifiedAt() {
        return this.microStrategyCertifiedAt;
    }

    /**
     * User who certified this asset, in MicroStrategy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyCertifiedBy() {
        return this.microStrategyCertifiedBy;
    }

    /**
     * Simple names of the cubes related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyCubeNames() {
        return this.microStrategyCubeNames;
    }

    /**
     * Unique names of the cubes related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyCubeQualifiedNames() {
        return this.microStrategyCubeQualifiedNames;
    }

    /**
     * Cubes that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyCube> getMicroStrategyCubes() {
        return this.microStrategyCubes;
    }

    /**
     * Documents that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyDocument> getMicroStrategyDocuments() {
        return this.microStrategyDocuments;
    }

    /**
     * Dossiers that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyDossier> getMicroStrategyDossiers() {
        return this.microStrategyDossiers;
    }

    /**
     * Facts that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyFact> getMicroStrategyFacts() {
        return this.microStrategyFacts;
    }

    /**
     * Whether the asset is certified in MicroStrategy (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getMicroStrategyIsCertified() {
        return this.microStrategyIsCertified;
    }

    /**
     * Location of this asset in MicroStrategy.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getMicroStrategyLocation() {
        return this.microStrategyLocation;
    }

    /**
     * Metrics that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyMetric> getMicroStrategyMetrics() {
        return this.microStrategyMetrics;
    }

    /**
     * Simple name of the project in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyProjectName() {
        return this.microStrategyProjectName;
    }

    /**
     * Unique name of the project in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMicroStrategyProjectQualifiedName() {
        return this.microStrategyProjectQualifiedName;
    }

    /**
     * Simple names of the reports related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyReportNames() {
        return this.microStrategyReportNames;
    }

    /**
     * Unique names of the reports related to this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getMicroStrategyReportQualifiedNames() {
        return this.microStrategyReportQualifiedNames;
    }

    /**
     * Reports that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyReport> getMicroStrategyReports() {
        return this.microStrategyReports;
    }

    /**
     * Visualizations that exist within this project.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMicroStrategyVisualization> getMicroStrategyVisualizations() {
        return this.microStrategyVisualizations;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MicroStrategyProject)) return false;
        final MicroStrategyProject other = (MicroStrategyProject) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$microStrategyCertifiedAt = this.getMicroStrategyCertifiedAt();
        final java.lang.Object other$microStrategyCertifiedAt = other.getMicroStrategyCertifiedAt();
        if (this$microStrategyCertifiedAt == null ? other$microStrategyCertifiedAt != null : !this$microStrategyCertifiedAt.equals(other$microStrategyCertifiedAt)) return false;
        final java.lang.Object this$microStrategyIsCertified = this.getMicroStrategyIsCertified();
        final java.lang.Object other$microStrategyIsCertified = other.getMicroStrategyIsCertified();
        if (this$microStrategyIsCertified == null ? other$microStrategyIsCertified != null : !this$microStrategyIsCertified.equals(other$microStrategyIsCertified)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$microStrategyAttributes = this.getMicroStrategyAttributes();
        final java.lang.Object other$microStrategyAttributes = other.getMicroStrategyAttributes();
        if (this$microStrategyAttributes == null ? other$microStrategyAttributes != null : !this$microStrategyAttributes.equals(other$microStrategyAttributes)) return false;
        final java.lang.Object this$microStrategyCertifiedBy = this.getMicroStrategyCertifiedBy();
        final java.lang.Object other$microStrategyCertifiedBy = other.getMicroStrategyCertifiedBy();
        if (this$microStrategyCertifiedBy == null ? other$microStrategyCertifiedBy != null : !this$microStrategyCertifiedBy.equals(other$microStrategyCertifiedBy)) return false;
        final java.lang.Object this$microStrategyCubeNames = this.getMicroStrategyCubeNames();
        final java.lang.Object other$microStrategyCubeNames = other.getMicroStrategyCubeNames();
        if (this$microStrategyCubeNames == null ? other$microStrategyCubeNames != null : !this$microStrategyCubeNames.equals(other$microStrategyCubeNames)) return false;
        final java.lang.Object this$microStrategyCubeQualifiedNames = this.getMicroStrategyCubeQualifiedNames();
        final java.lang.Object other$microStrategyCubeQualifiedNames = other.getMicroStrategyCubeQualifiedNames();
        if (this$microStrategyCubeQualifiedNames == null ? other$microStrategyCubeQualifiedNames != null : !this$microStrategyCubeQualifiedNames.equals(other$microStrategyCubeQualifiedNames)) return false;
        final java.lang.Object this$microStrategyCubes = this.getMicroStrategyCubes();
        final java.lang.Object other$microStrategyCubes = other.getMicroStrategyCubes();
        if (this$microStrategyCubes == null ? other$microStrategyCubes != null : !this$microStrategyCubes.equals(other$microStrategyCubes)) return false;
        final java.lang.Object this$microStrategyDocuments = this.getMicroStrategyDocuments();
        final java.lang.Object other$microStrategyDocuments = other.getMicroStrategyDocuments();
        if (this$microStrategyDocuments == null ? other$microStrategyDocuments != null : !this$microStrategyDocuments.equals(other$microStrategyDocuments)) return false;
        final java.lang.Object this$microStrategyDossiers = this.getMicroStrategyDossiers();
        final java.lang.Object other$microStrategyDossiers = other.getMicroStrategyDossiers();
        if (this$microStrategyDossiers == null ? other$microStrategyDossiers != null : !this$microStrategyDossiers.equals(other$microStrategyDossiers)) return false;
        final java.lang.Object this$microStrategyFacts = this.getMicroStrategyFacts();
        final java.lang.Object other$microStrategyFacts = other.getMicroStrategyFacts();
        if (this$microStrategyFacts == null ? other$microStrategyFacts != null : !this$microStrategyFacts.equals(other$microStrategyFacts)) return false;
        final java.lang.Object this$microStrategyLocation = this.getMicroStrategyLocation();
        final java.lang.Object other$microStrategyLocation = other.getMicroStrategyLocation();
        if (this$microStrategyLocation == null ? other$microStrategyLocation != null : !this$microStrategyLocation.equals(other$microStrategyLocation)) return false;
        final java.lang.Object this$microStrategyMetrics = this.getMicroStrategyMetrics();
        final java.lang.Object other$microStrategyMetrics = other.getMicroStrategyMetrics();
        if (this$microStrategyMetrics == null ? other$microStrategyMetrics != null : !this$microStrategyMetrics.equals(other$microStrategyMetrics)) return false;
        final java.lang.Object this$microStrategyProjectName = this.getMicroStrategyProjectName();
        final java.lang.Object other$microStrategyProjectName = other.getMicroStrategyProjectName();
        if (this$microStrategyProjectName == null ? other$microStrategyProjectName != null : !this$microStrategyProjectName.equals(other$microStrategyProjectName)) return false;
        final java.lang.Object this$microStrategyProjectQualifiedName = this.getMicroStrategyProjectQualifiedName();
        final java.lang.Object other$microStrategyProjectQualifiedName = other.getMicroStrategyProjectQualifiedName();
        if (this$microStrategyProjectQualifiedName == null ? other$microStrategyProjectQualifiedName != null : !this$microStrategyProjectQualifiedName.equals(other$microStrategyProjectQualifiedName)) return false;
        final java.lang.Object this$microStrategyReportNames = this.getMicroStrategyReportNames();
        final java.lang.Object other$microStrategyReportNames = other.getMicroStrategyReportNames();
        if (this$microStrategyReportNames == null ? other$microStrategyReportNames != null : !this$microStrategyReportNames.equals(other$microStrategyReportNames)) return false;
        final java.lang.Object this$microStrategyReportQualifiedNames = this.getMicroStrategyReportQualifiedNames();
        final java.lang.Object other$microStrategyReportQualifiedNames = other.getMicroStrategyReportQualifiedNames();
        if (this$microStrategyReportQualifiedNames == null ? other$microStrategyReportQualifiedNames != null : !this$microStrategyReportQualifiedNames.equals(other$microStrategyReportQualifiedNames)) return false;
        final java.lang.Object this$microStrategyReports = this.getMicroStrategyReports();
        final java.lang.Object other$microStrategyReports = other.getMicroStrategyReports();
        if (this$microStrategyReports == null ? other$microStrategyReports != null : !this$microStrategyReports.equals(other$microStrategyReports)) return false;
        final java.lang.Object this$microStrategyVisualizations = this.getMicroStrategyVisualizations();
        final java.lang.Object other$microStrategyVisualizations = other.getMicroStrategyVisualizations();
        if (this$microStrategyVisualizations == null ? other$microStrategyVisualizations != null : !this$microStrategyVisualizations.equals(other$microStrategyVisualizations)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof MicroStrategyProject;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $microStrategyCertifiedAt = this.getMicroStrategyCertifiedAt();
        result = result * PRIME + ($microStrategyCertifiedAt == null ? 43 : $microStrategyCertifiedAt.hashCode());
        final java.lang.Object $microStrategyIsCertified = this.getMicroStrategyIsCertified();
        result = result * PRIME + ($microStrategyIsCertified == null ? 43 : $microStrategyIsCertified.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $microStrategyAttributes = this.getMicroStrategyAttributes();
        result = result * PRIME + ($microStrategyAttributes == null ? 43 : $microStrategyAttributes.hashCode());
        final java.lang.Object $microStrategyCertifiedBy = this.getMicroStrategyCertifiedBy();
        result = result * PRIME + ($microStrategyCertifiedBy == null ? 43 : $microStrategyCertifiedBy.hashCode());
        final java.lang.Object $microStrategyCubeNames = this.getMicroStrategyCubeNames();
        result = result * PRIME + ($microStrategyCubeNames == null ? 43 : $microStrategyCubeNames.hashCode());
        final java.lang.Object $microStrategyCubeQualifiedNames = this.getMicroStrategyCubeQualifiedNames();
        result = result * PRIME + ($microStrategyCubeQualifiedNames == null ? 43 : $microStrategyCubeQualifiedNames.hashCode());
        final java.lang.Object $microStrategyCubes = this.getMicroStrategyCubes();
        result = result * PRIME + ($microStrategyCubes == null ? 43 : $microStrategyCubes.hashCode());
        final java.lang.Object $microStrategyDocuments = this.getMicroStrategyDocuments();
        result = result * PRIME + ($microStrategyDocuments == null ? 43 : $microStrategyDocuments.hashCode());
        final java.lang.Object $microStrategyDossiers = this.getMicroStrategyDossiers();
        result = result * PRIME + ($microStrategyDossiers == null ? 43 : $microStrategyDossiers.hashCode());
        final java.lang.Object $microStrategyFacts = this.getMicroStrategyFacts();
        result = result * PRIME + ($microStrategyFacts == null ? 43 : $microStrategyFacts.hashCode());
        final java.lang.Object $microStrategyLocation = this.getMicroStrategyLocation();
        result = result * PRIME + ($microStrategyLocation == null ? 43 : $microStrategyLocation.hashCode());
        final java.lang.Object $microStrategyMetrics = this.getMicroStrategyMetrics();
        result = result * PRIME + ($microStrategyMetrics == null ? 43 : $microStrategyMetrics.hashCode());
        final java.lang.Object $microStrategyProjectName = this.getMicroStrategyProjectName();
        result = result * PRIME + ($microStrategyProjectName == null ? 43 : $microStrategyProjectName.hashCode());
        final java.lang.Object $microStrategyProjectQualifiedName = this.getMicroStrategyProjectQualifiedName();
        result = result * PRIME + ($microStrategyProjectQualifiedName == null ? 43 : $microStrategyProjectQualifiedName.hashCode());
        final java.lang.Object $microStrategyReportNames = this.getMicroStrategyReportNames();
        result = result * PRIME + ($microStrategyReportNames == null ? 43 : $microStrategyReportNames.hashCode());
        final java.lang.Object $microStrategyReportQualifiedNames = this.getMicroStrategyReportQualifiedNames();
        result = result * PRIME + ($microStrategyReportQualifiedNames == null ? 43 : $microStrategyReportQualifiedNames.hashCode());
        final java.lang.Object $microStrategyReports = this.getMicroStrategyReports();
        result = result * PRIME + ($microStrategyReports == null ? 43 : $microStrategyReports.hashCode());
        final java.lang.Object $microStrategyVisualizations = this.getMicroStrategyVisualizations();
        result = result * PRIME + ($microStrategyVisualizations == null ? 43 : $microStrategyVisualizations.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "MicroStrategyProject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", microStrategyAttributes=" + this.getMicroStrategyAttributes() + ", microStrategyCertifiedAt=" + this.getMicroStrategyCertifiedAt() + ", microStrategyCertifiedBy=" + this.getMicroStrategyCertifiedBy() + ", microStrategyCubeNames=" + this.getMicroStrategyCubeNames() + ", microStrategyCubeQualifiedNames=" + this.getMicroStrategyCubeQualifiedNames() + ", microStrategyCubes=" + this.getMicroStrategyCubes() + ", microStrategyDocuments=" + this.getMicroStrategyDocuments() + ", microStrategyDossiers=" + this.getMicroStrategyDossiers() + ", microStrategyFacts=" + this.getMicroStrategyFacts() + ", microStrategyIsCertified=" + this.getMicroStrategyIsCertified() + ", microStrategyLocation=" + this.getMicroStrategyLocation() + ", microStrategyMetrics=" + this.getMicroStrategyMetrics() + ", microStrategyProjectName=" + this.getMicroStrategyProjectName() + ", microStrategyProjectQualifiedName=" + this.getMicroStrategyProjectQualifiedName() + ", microStrategyReportNames=" + this.getMicroStrategyReportNames() + ", microStrategyReportQualifiedNames=" + this.getMicroStrategyReportQualifiedNames() + ", microStrategyReports=" + this.getMicroStrategyReports() + ", microStrategyVisualizations=" + this.getMicroStrategyVisualizations() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for MicroStrategyProjects.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
