// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Mode collection in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class ModeCollection extends Asset implements IModeCollection, IMode, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ModeCollection.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModeCollection";
    /**
     * Fixed typeName for ModeCollections.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * State of this collection.
     */
    @Attribute
    String modeCollectionState;
    /**
     * Type of this collection.
     */
    @Attribute
    String modeCollectionType;
    /**
     * TBC
     */
    @Attribute
    String modeId;
    /**
     * TBC
     */
    @Attribute
    String modeQueryName;
    /**
     * TBC
     */
    @Attribute
    String modeQueryQualifiedName;
    /**
     * TBC
     */
    @Attribute
    String modeReportName;
    /**
     * TBC
     */
    @Attribute
    String modeReportQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IModeReport> modeReports;
    /**
     * TBC
     */
    @Attribute
    String modeToken;
    /**
     * Workspace in which this collection exists.
     */
    @Attribute
    IModeWorkspace modeWorkspace;
    /**
     * TBC
     */
    @Attribute
    String modeWorkspaceName;
    /**
     * TBC
     */
    @Attribute
    String modeWorkspaceQualifiedName;
    /**
     * TBC
     */
    @Attribute
    String modeWorkspaceUsername;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a ModeCollection, from a potentially
     * more-complete ModeCollection object.
     *
     * @return the minimal object necessary to relate to the ModeCollection
     * @throws InvalidRequestException if any of the minimal set of required properties for a ModeCollection relationship are not found in the initial object
     */
    @Override
    public ModeCollection trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all ModeCollection assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ModeCollection assets will be included.
     *
     * @return a fluent search that includes all ModeCollection assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all ModeCollection assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ModeCollection assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all ModeCollection assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all ModeCollection assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) ModeCollections will be included
     * @return a fluent search that includes all ModeCollection assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all ModeCollection assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) ModeCollections will be included
     * @return a fluent search that includes all ModeCollection assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a ModeCollection by GUID. Use this to create a relationship to this ModeCollection,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the ModeCollection to reference
     * @return reference to a ModeCollection that can be used for defining a relationship to a ModeCollection
     */
    public static ModeCollection refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ModeCollection by GUID. Use this to create a relationship to this ModeCollection,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the ModeCollection to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ModeCollection that can be used for defining a relationship to a ModeCollection
     */
    public static ModeCollection refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ModeCollection._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a ModeCollection by qualifiedName. Use this to create a relationship to this ModeCollection,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the ModeCollection to reference
     * @return reference to a ModeCollection that can be used for defining a relationship to a ModeCollection
     */
    public static ModeCollection refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ModeCollection by qualifiedName. Use this to create a relationship to this ModeCollection,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the ModeCollection to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ModeCollection that can be used for defining a relationship to a ModeCollection
     */
    public static ModeCollection refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ModeCollection._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a ModeCollection by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the ModeCollection to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ModeCollection, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModeCollection does not exist or the provided GUID is not a ModeCollection
     */
    @JsonIgnore
    public static ModeCollection get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a ModeCollection by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ModeCollection to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ModeCollection, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModeCollection does not exist or the provided GUID is not a ModeCollection
     */
    @JsonIgnore
    public static ModeCollection get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a ModeCollection by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ModeCollection to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full ModeCollection, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModeCollection does not exist or the provided GUID is not a ModeCollection
     */
    @JsonIgnore
    public static ModeCollection get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof ModeCollection) {
                return (ModeCollection) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof ModeCollection) {
                return (ModeCollection) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) ModeCollection to active.
     *
     * @param qualifiedName for the ModeCollection
     * @return true if the ModeCollection is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) ModeCollection to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the ModeCollection
     * @return true if the ModeCollection is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the minimal request necessary to update the ModeCollection, as a builder
     */
    public static ModeCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return ModeCollection._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a ModeCollection, from a potentially
     * more-complete ModeCollection object.
     *
     * @return the minimal object necessary to update the ModeCollection, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for ModeCollection are not found in the initial object
     */
    @Override
    public ModeCollectionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a ModeCollection.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a ModeCollection.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a ModeCollection.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ModeCollection's owners
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ModeCollection, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a ModeCollection.
     *
     * @param client connectivity to the Atlan tenant on which to update the ModeCollection's certificate
     * @param qualifiedName of the ModeCollection
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ModeCollection, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModeCollection) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a ModeCollection.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ModeCollection's certificate
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a ModeCollection.
     *
     * @param client connectivity to the Atlan tenant on which to update the ModeCollection's announcement
     * @param qualifiedName of the ModeCollection
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModeCollection) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a ModeCollection.
     *
     * @param client connectivity to the Atlan client from which to remove the ModeCollection's announcement
     * @param qualifiedName of the ModeCollection
     * @param name of the ModeCollection
     * @return the updated ModeCollection, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModeCollection) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the ModeCollection.
     *
     * @param qualifiedName for the ModeCollection
     * @param name human-readable name of the ModeCollection
     * @param terms the list of terms to replace on the ModeCollection, or null to remove all terms from the ModeCollection
     * @return the ModeCollection that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ModeCollection replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the ModeCollection.
     *
     * @param client connectivity to the Atlan tenant on which to replace the ModeCollection's assigned terms
     * @param qualifiedName for the ModeCollection
     * @param name human-readable name of the ModeCollection
     * @param terms the list of terms to replace on the ModeCollection, or null to remove all terms from the ModeCollection
     * @return the ModeCollection that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ModeCollection replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeCollection) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the ModeCollection, without replacing existing terms linked to the ModeCollection.
     * Note: this operation must make two API calls — one to retrieve the ModeCollection's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the ModeCollection
     * @param terms the list of terms to append to the ModeCollection
     * @return the ModeCollection that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ModeCollection appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the ModeCollection, without replacing existing terms linked to the ModeCollection.
     * Note: this operation must make two API calls — one to retrieve the ModeCollection's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the ModeCollection
     * @param qualifiedName for the ModeCollection
     * @param terms the list of terms to append to the ModeCollection
     * @return the ModeCollection that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ModeCollection appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeCollection) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a ModeCollection, without replacing all existing terms linked to the ModeCollection.
     * Note: this operation must make two API calls — one to retrieve the ModeCollection's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the ModeCollection
     * @param terms the list of terms to remove from the ModeCollection, which must be referenced by GUID
     * @return the ModeCollection that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a ModeCollection, without replacing all existing terms linked to the ModeCollection.
     * Note: this operation must make two API calls — one to retrieve the ModeCollection's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the ModeCollection
     * @param qualifiedName for the ModeCollection
     * @param terms the list of terms to remove from the ModeCollection, which must be referenced by GUID
     * @return the ModeCollection that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ModeCollection removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModeCollection) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a ModeCollection, without replacing existing Atlan tags linked to the ModeCollection.
     * Note: this operation must make two API calls — one to retrieve the ModeCollection's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ModeCollection
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ModeCollection
     */
    public static ModeCollection appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ModeCollection, without replacing existing Atlan tags linked to the ModeCollection.
     * Note: this operation must make two API calls — one to retrieve the ModeCollection's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ModeCollection
     * @param qualifiedName of the ModeCollection
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ModeCollection
     */
    public static ModeCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModeCollection) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ModeCollection, without replacing existing Atlan tags linked to the ModeCollection.
     * Note: this operation must make two API calls — one to retrieve the ModeCollection's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ModeCollection
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ModeCollection
     */
    public static ModeCollection appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a ModeCollection, without replacing existing Atlan tags linked to the ModeCollection.
     * Note: this operation must make two API calls — one to retrieve the ModeCollection's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ModeCollection
     * @param qualifiedName of the ModeCollection
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ModeCollection
     */
    public static ModeCollection appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModeCollection) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a ModeCollection.
     *
     * @param qualifiedName of the ModeCollection
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ModeCollection
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a ModeCollection.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a ModeCollection
     * @param qualifiedName of the ModeCollection
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ModeCollection
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ModeCollectionBuilder<C extends ModeCollection, B extends ModeCollection.ModeCollectionBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeCollectionState;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeCollectionType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeQueryName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeQueryQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeReportName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeReportQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IModeReport> modeReports;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeToken;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IModeWorkspace modeWorkspace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeWorkspaceName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeWorkspaceQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modeWorkspaceUsername;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            ModeCollection.ModeCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final ModeCollection instance, final ModeCollection.ModeCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.modeCollectionState(instance.modeCollectionState);
            b.modeCollectionType(instance.modeCollectionType);
            b.modeId(instance.modeId);
            b.modeQueryName(instance.modeQueryName);
            b.modeQueryQualifiedName(instance.modeQueryQualifiedName);
            b.modeReportName(instance.modeReportName);
            b.modeReportQualifiedName(instance.modeReportQualifiedName);
            b.modeReports(instance.modeReports == null ? java.util.Collections.<IModeReport>emptySortedSet() : instance.modeReports);
            b.modeToken(instance.modeToken);
            b.modeWorkspace(instance.modeWorkspace);
            b.modeWorkspaceName(instance.modeWorkspaceName);
            b.modeWorkspaceQualifiedName(instance.modeWorkspaceQualifiedName);
            b.modeWorkspaceUsername(instance.modeWorkspaceUsername);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for ModeCollections.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * State of this collection.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeCollectionState(final String modeCollectionState) {
            this.modeCollectionState = modeCollectionState;
            return self();
        }

        /**
         * Type of this collection.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeCollectionType(final String modeCollectionType) {
            this.modeCollectionType = modeCollectionType;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeId(final String modeId) {
            this.modeId = modeId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeQueryName(final String modeQueryName) {
            this.modeQueryName = modeQueryName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeQueryQualifiedName(final String modeQueryQualifiedName) {
            this.modeQueryQualifiedName = modeQueryQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeReportName(final String modeReportName) {
            this.modeReportName = modeReportName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeReportQualifiedName(final String modeReportQualifiedName) {
            this.modeReportQualifiedName = modeReportQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeReport(final IModeReport modeReport) {
            if (this.modeReports == null) this.modeReports = new java.util.ArrayList<IModeReport>();
            this.modeReports.add(modeReport);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeReports(final java.util.Collection<? extends IModeReport> modeReports) {
            if (modeReports == null) {
                throw new java.lang.NullPointerException("modeReports cannot be null");
            }
            if (this.modeReports == null) this.modeReports = new java.util.ArrayList<IModeReport>();
            this.modeReports.addAll(modeReports);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModeReports() {
            if (this.modeReports != null) this.modeReports.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeToken(final String modeToken) {
            this.modeToken = modeToken;
            return self();
        }

        /**
         * Workspace in which this collection exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeWorkspace(final IModeWorkspace modeWorkspace) {
            this.modeWorkspace = modeWorkspace;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeWorkspaceName(final String modeWorkspaceName) {
            this.modeWorkspaceName = modeWorkspaceName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeWorkspaceQualifiedName(final String modeWorkspaceQualifiedName) {
            this.modeWorkspaceQualifiedName = modeWorkspaceQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modeWorkspaceUsername(final String modeWorkspaceUsername) {
            this.modeWorkspaceUsername = modeWorkspaceUsername;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ModeCollection.ModeCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modeCollectionState=" + this.modeCollectionState + ", modeCollectionType=" + this.modeCollectionType + ", modeId=" + this.modeId + ", modeQueryName=" + this.modeQueryName + ", modeQueryQualifiedName=" + this.modeQueryQualifiedName + ", modeReportName=" + this.modeReportName + ", modeReportQualifiedName=" + this.modeReportQualifiedName + ", modeReports=" + this.modeReports + ", modeToken=" + this.modeToken + ", modeWorkspace=" + this.modeWorkspace + ", modeWorkspaceName=" + this.modeWorkspaceName + ", modeWorkspaceQualifiedName=" + this.modeWorkspaceQualifiedName + ", modeWorkspaceUsername=" + this.modeWorkspaceUsername + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class ModeCollectionBuilderImpl extends ModeCollection.ModeCollectionBuilder<ModeCollection, ModeCollection.ModeCollectionBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ModeCollectionBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ModeCollection.ModeCollectionBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ModeCollection build() {
            return new ModeCollection(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected ModeCollection(final ModeCollection.ModeCollectionBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = ModeCollection.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.modeCollectionState = b.modeCollectionState;
        this.modeCollectionType = b.modeCollectionType;
        this.modeId = b.modeId;
        this.modeQueryName = b.modeQueryName;
        this.modeQueryQualifiedName = b.modeQueryQualifiedName;
        this.modeReportName = b.modeReportName;
        this.modeReportQualifiedName = b.modeReportQualifiedName;
        java.util.SortedSet<IModeReport> modeReports = new java.util.TreeSet<IModeReport>();
        if (b.modeReports != null) modeReports.addAll(b.modeReports);
        modeReports = java.util.Collections.unmodifiableSortedSet(modeReports);
        this.modeReports = modeReports;
        this.modeToken = b.modeToken;
        this.modeWorkspace = b.modeWorkspace;
        this.modeWorkspaceName = b.modeWorkspaceName;
        this.modeWorkspaceQualifiedName = b.modeWorkspaceQualifiedName;
        this.modeWorkspaceUsername = b.modeWorkspaceUsername;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ModeCollection.ModeCollectionBuilder<?, ?> _internal() {
        return new ModeCollection.ModeCollectionBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ModeCollection.ModeCollectionBuilder<?, ?> toBuilder() {
        return new ModeCollection.ModeCollectionBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * State of this collection.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeCollectionState() {
        return this.modeCollectionState;
    }

    /**
     * Type of this collection.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeCollectionType() {
        return this.modeCollectionType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeId() {
        return this.modeId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeQueryName() {
        return this.modeQueryName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeQueryQualifiedName() {
        return this.modeQueryQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeReportName() {
        return this.modeReportName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeReportQualifiedName() {
        return this.modeReportQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IModeReport> getModeReports() {
        return this.modeReports;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeToken() {
        return this.modeToken;
    }

    /**
     * Workspace in which this collection exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IModeWorkspace getModeWorkspace() {
        return this.modeWorkspace;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeWorkspaceName() {
        return this.modeWorkspaceName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeWorkspaceQualifiedName() {
        return this.modeWorkspaceQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModeWorkspaceUsername() {
        return this.modeWorkspaceUsername;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ModeCollection)) return false;
        final ModeCollection other = (ModeCollection) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$modeCollectionState = this.getModeCollectionState();
        final java.lang.Object other$modeCollectionState = other.getModeCollectionState();
        if (this$modeCollectionState == null ? other$modeCollectionState != null : !this$modeCollectionState.equals(other$modeCollectionState)) return false;
        final java.lang.Object this$modeCollectionType = this.getModeCollectionType();
        final java.lang.Object other$modeCollectionType = other.getModeCollectionType();
        if (this$modeCollectionType == null ? other$modeCollectionType != null : !this$modeCollectionType.equals(other$modeCollectionType)) return false;
        final java.lang.Object this$modeId = this.getModeId();
        final java.lang.Object other$modeId = other.getModeId();
        if (this$modeId == null ? other$modeId != null : !this$modeId.equals(other$modeId)) return false;
        final java.lang.Object this$modeQueryName = this.getModeQueryName();
        final java.lang.Object other$modeQueryName = other.getModeQueryName();
        if (this$modeQueryName == null ? other$modeQueryName != null : !this$modeQueryName.equals(other$modeQueryName)) return false;
        final java.lang.Object this$modeQueryQualifiedName = this.getModeQueryQualifiedName();
        final java.lang.Object other$modeQueryQualifiedName = other.getModeQueryQualifiedName();
        if (this$modeQueryQualifiedName == null ? other$modeQueryQualifiedName != null : !this$modeQueryQualifiedName.equals(other$modeQueryQualifiedName)) return false;
        final java.lang.Object this$modeReportName = this.getModeReportName();
        final java.lang.Object other$modeReportName = other.getModeReportName();
        if (this$modeReportName == null ? other$modeReportName != null : !this$modeReportName.equals(other$modeReportName)) return false;
        final java.lang.Object this$modeReportQualifiedName = this.getModeReportQualifiedName();
        final java.lang.Object other$modeReportQualifiedName = other.getModeReportQualifiedName();
        if (this$modeReportQualifiedName == null ? other$modeReportQualifiedName != null : !this$modeReportQualifiedName.equals(other$modeReportQualifiedName)) return false;
        final java.lang.Object this$modeReports = this.getModeReports();
        final java.lang.Object other$modeReports = other.getModeReports();
        if (this$modeReports == null ? other$modeReports != null : !this$modeReports.equals(other$modeReports)) return false;
        final java.lang.Object this$modeToken = this.getModeToken();
        final java.lang.Object other$modeToken = other.getModeToken();
        if (this$modeToken == null ? other$modeToken != null : !this$modeToken.equals(other$modeToken)) return false;
        final java.lang.Object this$modeWorkspace = this.getModeWorkspace();
        final java.lang.Object other$modeWorkspace = other.getModeWorkspace();
        if (this$modeWorkspace == null ? other$modeWorkspace != null : !this$modeWorkspace.equals(other$modeWorkspace)) return false;
        final java.lang.Object this$modeWorkspaceName = this.getModeWorkspaceName();
        final java.lang.Object other$modeWorkspaceName = other.getModeWorkspaceName();
        if (this$modeWorkspaceName == null ? other$modeWorkspaceName != null : !this$modeWorkspaceName.equals(other$modeWorkspaceName)) return false;
        final java.lang.Object this$modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        final java.lang.Object other$modeWorkspaceQualifiedName = other.getModeWorkspaceQualifiedName();
        if (this$modeWorkspaceQualifiedName == null ? other$modeWorkspaceQualifiedName != null : !this$modeWorkspaceQualifiedName.equals(other$modeWorkspaceQualifiedName)) return false;
        final java.lang.Object this$modeWorkspaceUsername = this.getModeWorkspaceUsername();
        final java.lang.Object other$modeWorkspaceUsername = other.getModeWorkspaceUsername();
        if (this$modeWorkspaceUsername == null ? other$modeWorkspaceUsername != null : !this$modeWorkspaceUsername.equals(other$modeWorkspaceUsername)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ModeCollection;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $modeCollectionState = this.getModeCollectionState();
        result = result * PRIME + ($modeCollectionState == null ? 43 : $modeCollectionState.hashCode());
        final java.lang.Object $modeCollectionType = this.getModeCollectionType();
        result = result * PRIME + ($modeCollectionType == null ? 43 : $modeCollectionType.hashCode());
        final java.lang.Object $modeId = this.getModeId();
        result = result * PRIME + ($modeId == null ? 43 : $modeId.hashCode());
        final java.lang.Object $modeQueryName = this.getModeQueryName();
        result = result * PRIME + ($modeQueryName == null ? 43 : $modeQueryName.hashCode());
        final java.lang.Object $modeQueryQualifiedName = this.getModeQueryQualifiedName();
        result = result * PRIME + ($modeQueryQualifiedName == null ? 43 : $modeQueryQualifiedName.hashCode());
        final java.lang.Object $modeReportName = this.getModeReportName();
        result = result * PRIME + ($modeReportName == null ? 43 : $modeReportName.hashCode());
        final java.lang.Object $modeReportQualifiedName = this.getModeReportQualifiedName();
        result = result * PRIME + ($modeReportQualifiedName == null ? 43 : $modeReportQualifiedName.hashCode());
        final java.lang.Object $modeReports = this.getModeReports();
        result = result * PRIME + ($modeReports == null ? 43 : $modeReports.hashCode());
        final java.lang.Object $modeToken = this.getModeToken();
        result = result * PRIME + ($modeToken == null ? 43 : $modeToken.hashCode());
        final java.lang.Object $modeWorkspace = this.getModeWorkspace();
        result = result * PRIME + ($modeWorkspace == null ? 43 : $modeWorkspace.hashCode());
        final java.lang.Object $modeWorkspaceName = this.getModeWorkspaceName();
        result = result * PRIME + ($modeWorkspaceName == null ? 43 : $modeWorkspaceName.hashCode());
        final java.lang.Object $modeWorkspaceQualifiedName = this.getModeWorkspaceQualifiedName();
        result = result * PRIME + ($modeWorkspaceQualifiedName == null ? 43 : $modeWorkspaceQualifiedName.hashCode());
        final java.lang.Object $modeWorkspaceUsername = this.getModeWorkspaceUsername();
        result = result * PRIME + ($modeWorkspaceUsername == null ? 43 : $modeWorkspaceUsername.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ModeCollection(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modeCollectionState=" + this.getModeCollectionState() + ", modeCollectionType=" + this.getModeCollectionType() + ", modeId=" + this.getModeId() + ", modeQueryName=" + this.getModeQueryName() + ", modeQueryQualifiedName=" + this.getModeQueryQualifiedName() + ", modeReportName=" + this.getModeReportName() + ", modeReportQualifiedName=" + this.getModeReportQualifiedName() + ", modeReports=" + this.getModeReports() + ", modeToken=" + this.getModeToken() + ", modeWorkspace=" + this.getModeWorkspace() + ", modeWorkspaceName=" + this.getModeWorkspaceName() + ", modeWorkspaceQualifiedName=" + this.getModeWorkspaceQualifiedName() + ", modeWorkspaceUsername=" + this.getModeWorkspaceUsername() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for ModeCollections.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
