// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an entity within a version of a data model in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class ModelEntity extends Asset implements IModelEntity, IModel, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ModelEntity.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModelEntity";
    /**
     * Fixed typeName for ModelEntitys.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Business date for the asset.
     */
    @Attribute
    @Date
    Long modelBusinessDate;
    /**
     * Model domain in which this asset exists.
     */
    @Attribute
    String modelDomain;
    /**
     * Number of attributes in the entity.
     */
    @Attribute
    Long modelEntityAttributeCount;
    /**
     * Individual attributes that make up the entity.
     */
    @Attribute
    SortedSet<IModelAttribute> modelEntityAttributes;
    /**
     * Entities from which this entity is mapped.
     */
    @Attribute
    SortedSet<IModelEntity> modelEntityMappedFromEntities;
    /**
     * Entities to which this entity is mapped.
     */
    @Attribute
    SortedSet<IModelEntity> modelEntityMappedToEntities;
    /**
     * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @Attribute
    String modelEntityName;
    /**
     * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @Attribute
    String modelEntityQualifiedName;
    /**
     * Association from which this entity is related.
     */
    @Attribute
    SortedSet<IModelEntityAssociation> modelEntityRelatedFromEntities;
    /**
     * Association to which this entity is related.
     */
    @Attribute
    SortedSet<IModelEntityAssociation> modelEntityRelatedToEntities;
    /**
     * Subject area of the entity.
     */
    @Attribute
    String modelEntitySubjectArea;
    /**
     * Business expiration date for the asset.
     */
    @Attribute
    @Date
    Long modelExpiredAtBusinessDate;
    /**
     * System expiration date for the asset.
     */
    @Attribute
    @Date
    Long modelExpiredAtSystemDate;
    /**
     * Simple name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @Attribute
    String modelName;
    /**
     * Model namespace in which this asset exists.
     */
    @Attribute
    String modelNamespace;
    /**
     * Unique name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @Attribute
    String modelQualifiedName;
    /**
     * System date for the asset.
     */
    @Attribute
    @Date
    Long modelSystemDate;
    /**
     * Type of the model asset (conceptual, logical, physical).
     */
    @Attribute
    String modelType;
    /**
     * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @Attribute
    String modelVersionName;
    /**
     * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @Attribute
    String modelVersionQualifiedName;
    /**
     * Data model version(s) in which this entity exists.
     */
    @Attribute
    SortedSet<IModelVersion> modelVersions;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a ModelEntity, from a potentially
     * more-complete ModelEntity object.
     *
     * @return the minimal object necessary to relate to the ModelEntity
     * @throws InvalidRequestException if any of the minimal set of required properties for a ModelEntity relationship are not found in the initial object
     */
    @Override
    public ModelEntity trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all ModelEntity assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ModelEntity assets will be included.
     *
     * @return a fluent search that includes all ModelEntity assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all ModelEntity assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ModelEntity assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all ModelEntity assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all ModelEntity assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) ModelEntitys will be included
     * @return a fluent search that includes all ModelEntity assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all ModelEntity assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) ModelEntitys will be included
     * @return a fluent search that includes all ModelEntity assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a ModelEntity by GUID. Use this to create a relationship to this ModelEntity,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the ModelEntity to reference
     * @return reference to a ModelEntity that can be used for defining a relationship to a ModelEntity
     */
    public static ModelEntity refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ModelEntity by GUID. Use this to create a relationship to this ModelEntity,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the ModelEntity to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ModelEntity that can be used for defining a relationship to a ModelEntity
     */
    public static ModelEntity refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ModelEntity._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a ModelEntity by qualifiedName. Use this to create a relationship to this ModelEntity,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the ModelEntity to reference
     * @return reference to a ModelEntity that can be used for defining a relationship to a ModelEntity
     */
    public static ModelEntity refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ModelEntity by qualifiedName. Use this to create a relationship to this ModelEntity,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the ModelEntity to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ModelEntity that can be used for defining a relationship to a ModelEntity
     */
    public static ModelEntity refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ModelEntity._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a ModelEntity by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the ModelEntity to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ModelEntity, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModelEntity does not exist or the provided GUID is not a ModelEntity
     */
    @JsonIgnore
    public static ModelEntity get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a ModelEntity by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ModelEntity to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ModelEntity, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModelEntity does not exist or the provided GUID is not a ModelEntity
     */
    @JsonIgnore
    public static ModelEntity get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a ModelEntity by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ModelEntity to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full ModelEntity, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModelEntity does not exist or the provided GUID is not a ModelEntity
     */
    @JsonIgnore
    public static ModelEntity get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof ModelEntity) {
                return (ModelEntity) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof ModelEntity) {
                return (ModelEntity) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) ModelEntity to active.
     *
     * @param qualifiedName for the ModelEntity
     * @return true if the ModelEntity is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) ModelEntity to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the ModelEntity
     * @return true if the ModelEntity is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the minimal request necessary to update the ModelEntity, as a builder
     */
    public static ModelEntityBuilder<?, ?> updater(String qualifiedName, String name) {
        return ModelEntity._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a ModelEntity, from a potentially
     * more-complete ModelEntity object.
     *
     * @return the minimal object necessary to update the ModelEntity, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for ModelEntity are not found in the initial object
     */
    @Override
    public ModelEntityBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a ModelEntity.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntity) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a ModelEntity.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntity) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a ModelEntity.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ModelEntity's owners
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntity) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ModelEntity, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a ModelEntity.
     *
     * @param client connectivity to the Atlan tenant on which to update the ModelEntity's certificate
     * @param qualifiedName of the ModelEntity
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ModelEntity, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModelEntity) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a ModelEntity.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ModelEntity's certificate
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntity) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a ModelEntity.
     *
     * @param client connectivity to the Atlan tenant on which to update the ModelEntity's announcement
     * @param qualifiedName of the ModelEntity
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModelEntity) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a ModelEntity.
     *
     * @param client connectivity to the Atlan client from which to remove the ModelEntity's announcement
     * @param qualifiedName of the ModelEntity
     * @param name of the ModelEntity
     * @return the updated ModelEntity, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntity) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the ModelEntity.
     *
     * @param qualifiedName for the ModelEntity
     * @param name human-readable name of the ModelEntity
     * @param terms the list of terms to replace on the ModelEntity, or null to remove all terms from the ModelEntity
     * @return the ModelEntity that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ModelEntity replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the ModelEntity.
     *
     * @param client connectivity to the Atlan tenant on which to replace the ModelEntity's assigned terms
     * @param qualifiedName for the ModelEntity
     * @param name human-readable name of the ModelEntity
     * @param terms the list of terms to replace on the ModelEntity, or null to remove all terms from the ModelEntity
     * @return the ModelEntity that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ModelEntity replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelEntity) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the ModelEntity, without replacing existing terms linked to the ModelEntity.
     * Note: this operation must make two API calls — one to retrieve the ModelEntity's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the ModelEntity
     * @param terms the list of terms to append to the ModelEntity
     * @return the ModelEntity that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ModelEntity appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the ModelEntity, without replacing existing terms linked to the ModelEntity.
     * Note: this operation must make two API calls — one to retrieve the ModelEntity's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the ModelEntity
     * @param qualifiedName for the ModelEntity
     * @param terms the list of terms to append to the ModelEntity
     * @return the ModelEntity that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ModelEntity appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelEntity) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a ModelEntity, without replacing all existing terms linked to the ModelEntity.
     * Note: this operation must make two API calls — one to retrieve the ModelEntity's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the ModelEntity
     * @param terms the list of terms to remove from the ModelEntity, which must be referenced by GUID
     * @return the ModelEntity that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a ModelEntity, without replacing all existing terms linked to the ModelEntity.
     * Note: this operation must make two API calls — one to retrieve the ModelEntity's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the ModelEntity
     * @param qualifiedName for the ModelEntity
     * @param terms the list of terms to remove from the ModelEntity, which must be referenced by GUID
     * @return the ModelEntity that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ModelEntity removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelEntity) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a ModelEntity, without replacing existing Atlan tags linked to the ModelEntity.
     * Note: this operation must make two API calls — one to retrieve the ModelEntity's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ModelEntity
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ModelEntity
     */
    public static ModelEntity appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ModelEntity, without replacing existing Atlan tags linked to the ModelEntity.
     * Note: this operation must make two API calls — one to retrieve the ModelEntity's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ModelEntity
     * @param qualifiedName of the ModelEntity
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ModelEntity
     */
    public static ModelEntity appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModelEntity) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ModelEntity, without replacing existing Atlan tags linked to the ModelEntity.
     * Note: this operation must make two API calls — one to retrieve the ModelEntity's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ModelEntity
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ModelEntity
     */
    public static ModelEntity appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a ModelEntity, without replacing existing Atlan tags linked to the ModelEntity.
     * Note: this operation must make two API calls — one to retrieve the ModelEntity's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ModelEntity
     * @param qualifiedName of the ModelEntity
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ModelEntity
     */
    public static ModelEntity appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModelEntity) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a ModelEntity.
     *
     * @param qualifiedName of the ModelEntity
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ModelEntity
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a ModelEntity.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a ModelEntity
     * @param qualifiedName of the ModelEntity
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ModelEntity
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ModelEntityBuilder<C extends ModelEntity, B extends ModelEntity.ModelEntityBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelBusinessDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelDomain;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelEntityAttributeCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IModelAttribute> modelEntityAttributes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IModelEntity> modelEntityMappedFromEntities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IModelEntity> modelEntityMappedToEntities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelEntityName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelEntityQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IModelEntityAssociation> modelEntityRelatedFromEntities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IModelEntityAssociation> modelEntityRelatedToEntities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelEntitySubjectArea;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelExpiredAtBusinessDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelExpiredAtSystemDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelNamespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelSystemDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelVersionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelVersionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IModelVersion> modelVersions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            ModelEntity.ModelEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final ModelEntity instance, final ModelEntity.ModelEntityBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.modelBusinessDate(instance.modelBusinessDate);
            b.modelDomain(instance.modelDomain);
            b.modelEntityAttributeCount(instance.modelEntityAttributeCount);
            b.modelEntityAttributes(instance.modelEntityAttributes == null ? java.util.Collections.<IModelAttribute>emptySortedSet() : instance.modelEntityAttributes);
            b.modelEntityMappedFromEntities(instance.modelEntityMappedFromEntities == null ? java.util.Collections.<IModelEntity>emptySortedSet() : instance.modelEntityMappedFromEntities);
            b.modelEntityMappedToEntities(instance.modelEntityMappedToEntities == null ? java.util.Collections.<IModelEntity>emptySortedSet() : instance.modelEntityMappedToEntities);
            b.modelEntityName(instance.modelEntityName);
            b.modelEntityQualifiedName(instance.modelEntityQualifiedName);
            b.modelEntityRelatedFromEntities(instance.modelEntityRelatedFromEntities == null ? java.util.Collections.<IModelEntityAssociation>emptySortedSet() : instance.modelEntityRelatedFromEntities);
            b.modelEntityRelatedToEntities(instance.modelEntityRelatedToEntities == null ? java.util.Collections.<IModelEntityAssociation>emptySortedSet() : instance.modelEntityRelatedToEntities);
            b.modelEntitySubjectArea(instance.modelEntitySubjectArea);
            b.modelExpiredAtBusinessDate(instance.modelExpiredAtBusinessDate);
            b.modelExpiredAtSystemDate(instance.modelExpiredAtSystemDate);
            b.modelName(instance.modelName);
            b.modelNamespace(instance.modelNamespace);
            b.modelQualifiedName(instance.modelQualifiedName);
            b.modelSystemDate(instance.modelSystemDate);
            b.modelType(instance.modelType);
            b.modelVersionName(instance.modelVersionName);
            b.modelVersionQualifiedName(instance.modelVersionQualifiedName);
            b.modelVersions(instance.modelVersions == null ? java.util.Collections.<IModelVersion>emptySortedSet() : instance.modelVersions);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for ModelEntitys.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Business date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelBusinessDate(final Long modelBusinessDate) {
            this.modelBusinessDate = modelBusinessDate;
            return self();
        }

        /**
         * Model domain in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelDomain(final String modelDomain) {
            this.modelDomain = modelDomain;
            return self();
        }

        /**
         * Number of attributes in the entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityAttributeCount(final Long modelEntityAttributeCount) {
            this.modelEntityAttributeCount = modelEntityAttributeCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityAttribute(final IModelAttribute modelEntityAttribute) {
            if (this.modelEntityAttributes == null) this.modelEntityAttributes = new java.util.ArrayList<IModelAttribute>();
            this.modelEntityAttributes.add(modelEntityAttribute);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityAttributes(final java.util.Collection<? extends IModelAttribute> modelEntityAttributes) {
            if (modelEntityAttributes == null) {
                throw new java.lang.NullPointerException("modelEntityAttributes cannot be null");
            }
            if (this.modelEntityAttributes == null) this.modelEntityAttributes = new java.util.ArrayList<IModelAttribute>();
            this.modelEntityAttributes.addAll(modelEntityAttributes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModelEntityAttributes() {
            if (this.modelEntityAttributes != null) this.modelEntityAttributes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityMappedFromEntity(final IModelEntity modelEntityMappedFromEntity) {
            if (this.modelEntityMappedFromEntities == null) this.modelEntityMappedFromEntities = new java.util.ArrayList<IModelEntity>();
            this.modelEntityMappedFromEntities.add(modelEntityMappedFromEntity);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityMappedFromEntities(final java.util.Collection<? extends IModelEntity> modelEntityMappedFromEntities) {
            if (modelEntityMappedFromEntities == null) {
                throw new java.lang.NullPointerException("modelEntityMappedFromEntities cannot be null");
            }
            if (this.modelEntityMappedFromEntities == null) this.modelEntityMappedFromEntities = new java.util.ArrayList<IModelEntity>();
            this.modelEntityMappedFromEntities.addAll(modelEntityMappedFromEntities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModelEntityMappedFromEntities() {
            if (this.modelEntityMappedFromEntities != null) this.modelEntityMappedFromEntities.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityMappedToEntity(final IModelEntity modelEntityMappedToEntity) {
            if (this.modelEntityMappedToEntities == null) this.modelEntityMappedToEntities = new java.util.ArrayList<IModelEntity>();
            this.modelEntityMappedToEntities.add(modelEntityMappedToEntity);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityMappedToEntities(final java.util.Collection<? extends IModelEntity> modelEntityMappedToEntities) {
            if (modelEntityMappedToEntities == null) {
                throw new java.lang.NullPointerException("modelEntityMappedToEntities cannot be null");
            }
            if (this.modelEntityMappedToEntities == null) this.modelEntityMappedToEntities = new java.util.ArrayList<IModelEntity>();
            this.modelEntityMappedToEntities.addAll(modelEntityMappedToEntities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModelEntityMappedToEntities() {
            if (this.modelEntityMappedToEntities != null) this.modelEntityMappedToEntities.clear();
            return self();
        }

        /**
         * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityName(final String modelEntityName) {
            this.modelEntityName = modelEntityName;
            return self();
        }

        /**
         * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityQualifiedName(final String modelEntityQualifiedName) {
            this.modelEntityQualifiedName = modelEntityQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityRelatedFromEntity(final IModelEntityAssociation modelEntityRelatedFromEntity) {
            if (this.modelEntityRelatedFromEntities == null) this.modelEntityRelatedFromEntities = new java.util.ArrayList<IModelEntityAssociation>();
            this.modelEntityRelatedFromEntities.add(modelEntityRelatedFromEntity);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityRelatedFromEntities(final java.util.Collection<? extends IModelEntityAssociation> modelEntityRelatedFromEntities) {
            if (modelEntityRelatedFromEntities == null) {
                throw new java.lang.NullPointerException("modelEntityRelatedFromEntities cannot be null");
            }
            if (this.modelEntityRelatedFromEntities == null) this.modelEntityRelatedFromEntities = new java.util.ArrayList<IModelEntityAssociation>();
            this.modelEntityRelatedFromEntities.addAll(modelEntityRelatedFromEntities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModelEntityRelatedFromEntities() {
            if (this.modelEntityRelatedFromEntities != null) this.modelEntityRelatedFromEntities.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityRelatedToEntity(final IModelEntityAssociation modelEntityRelatedToEntity) {
            if (this.modelEntityRelatedToEntities == null) this.modelEntityRelatedToEntities = new java.util.ArrayList<IModelEntityAssociation>();
            this.modelEntityRelatedToEntities.add(modelEntityRelatedToEntity);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityRelatedToEntities(final java.util.Collection<? extends IModelEntityAssociation> modelEntityRelatedToEntities) {
            if (modelEntityRelatedToEntities == null) {
                throw new java.lang.NullPointerException("modelEntityRelatedToEntities cannot be null");
            }
            if (this.modelEntityRelatedToEntities == null) this.modelEntityRelatedToEntities = new java.util.ArrayList<IModelEntityAssociation>();
            this.modelEntityRelatedToEntities.addAll(modelEntityRelatedToEntities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModelEntityRelatedToEntities() {
            if (this.modelEntityRelatedToEntities != null) this.modelEntityRelatedToEntities.clear();
            return self();
        }

        /**
         * Subject area of the entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntitySubjectArea(final String modelEntitySubjectArea) {
            this.modelEntitySubjectArea = modelEntitySubjectArea;
            return self();
        }

        /**
         * Business expiration date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelExpiredAtBusinessDate(final Long modelExpiredAtBusinessDate) {
            this.modelExpiredAtBusinessDate = modelExpiredAtBusinessDate;
            return self();
        }

        /**
         * System expiration date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelExpiredAtSystemDate(final Long modelExpiredAtSystemDate) {
            this.modelExpiredAtSystemDate = modelExpiredAtSystemDate;
            return self();
        }

        /**
         * Simple name of the model in which this asset exists, or empty if it is itself a data model.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelName(final String modelName) {
            this.modelName = modelName;
            return self();
        }

        /**
         * Model namespace in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelNamespace(final String modelNamespace) {
            this.modelNamespace = modelNamespace;
            return self();
        }

        /**
         * Unique name of the model in which this asset exists, or empty if it is itself a data model.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelQualifiedName(final String modelQualifiedName) {
            this.modelQualifiedName = modelQualifiedName;
            return self();
        }

        /**
         * System date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelSystemDate(final Long modelSystemDate) {
            this.modelSystemDate = modelSystemDate;
            return self();
        }

        /**
         * Type of the model asset (conceptual, logical, physical).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelType(final String modelType) {
            this.modelType = modelType;
            return self();
        }

        /**
         * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersionName(final String modelVersionName) {
            this.modelVersionName = modelVersionName;
            return self();
        }

        /**
         * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersionQualifiedName(final String modelVersionQualifiedName) {
            this.modelVersionQualifiedName = modelVersionQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersion(final IModelVersion modelVersion) {
            if (this.modelVersions == null) this.modelVersions = new java.util.ArrayList<IModelVersion>();
            this.modelVersions.add(modelVersion);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersions(final java.util.Collection<? extends IModelVersion> modelVersions) {
            if (modelVersions == null) {
                throw new java.lang.NullPointerException("modelVersions cannot be null");
            }
            if (this.modelVersions == null) this.modelVersions = new java.util.ArrayList<IModelVersion>();
            this.modelVersions.addAll(modelVersions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModelVersions() {
            if (this.modelVersions != null) this.modelVersions.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ModelEntity.ModelEntityBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelBusinessDate=" + this.modelBusinessDate + ", modelDomain=" + this.modelDomain + ", modelEntityAttributeCount=" + this.modelEntityAttributeCount + ", modelEntityAttributes=" + this.modelEntityAttributes + ", modelEntityMappedFromEntities=" + this.modelEntityMappedFromEntities + ", modelEntityMappedToEntities=" + this.modelEntityMappedToEntities + ", modelEntityName=" + this.modelEntityName + ", modelEntityQualifiedName=" + this.modelEntityQualifiedName + ", modelEntityRelatedFromEntities=" + this.modelEntityRelatedFromEntities + ", modelEntityRelatedToEntities=" + this.modelEntityRelatedToEntities + ", modelEntitySubjectArea=" + this.modelEntitySubjectArea + ", modelExpiredAtBusinessDate=" + this.modelExpiredAtBusinessDate + ", modelExpiredAtSystemDate=" + this.modelExpiredAtSystemDate + ", modelName=" + this.modelName + ", modelNamespace=" + this.modelNamespace + ", modelQualifiedName=" + this.modelQualifiedName + ", modelSystemDate=" + this.modelSystemDate + ", modelType=" + this.modelType + ", modelVersionName=" + this.modelVersionName + ", modelVersionQualifiedName=" + this.modelVersionQualifiedName + ", modelVersions=" + this.modelVersions + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class ModelEntityBuilderImpl extends ModelEntity.ModelEntityBuilder<ModelEntity, ModelEntity.ModelEntityBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ModelEntityBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ModelEntity.ModelEntityBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ModelEntity build() {
            return new ModelEntity(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected ModelEntity(final ModelEntity.ModelEntityBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = ModelEntity.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.modelBusinessDate = b.modelBusinessDate;
        this.modelDomain = b.modelDomain;
        this.modelEntityAttributeCount = b.modelEntityAttributeCount;
        java.util.SortedSet<IModelAttribute> modelEntityAttributes = new java.util.TreeSet<IModelAttribute>();
        if (b.modelEntityAttributes != null) modelEntityAttributes.addAll(b.modelEntityAttributes);
        modelEntityAttributes = java.util.Collections.unmodifiableSortedSet(modelEntityAttributes);
        this.modelEntityAttributes = modelEntityAttributes;
        java.util.SortedSet<IModelEntity> modelEntityMappedFromEntities = new java.util.TreeSet<IModelEntity>();
        if (b.modelEntityMappedFromEntities != null) modelEntityMappedFromEntities.addAll(b.modelEntityMappedFromEntities);
        modelEntityMappedFromEntities = java.util.Collections.unmodifiableSortedSet(modelEntityMappedFromEntities);
        this.modelEntityMappedFromEntities = modelEntityMappedFromEntities;
        java.util.SortedSet<IModelEntity> modelEntityMappedToEntities = new java.util.TreeSet<IModelEntity>();
        if (b.modelEntityMappedToEntities != null) modelEntityMappedToEntities.addAll(b.modelEntityMappedToEntities);
        modelEntityMappedToEntities = java.util.Collections.unmodifiableSortedSet(modelEntityMappedToEntities);
        this.modelEntityMappedToEntities = modelEntityMappedToEntities;
        this.modelEntityName = b.modelEntityName;
        this.modelEntityQualifiedName = b.modelEntityQualifiedName;
        java.util.SortedSet<IModelEntityAssociation> modelEntityRelatedFromEntities = new java.util.TreeSet<IModelEntityAssociation>();
        if (b.modelEntityRelatedFromEntities != null) modelEntityRelatedFromEntities.addAll(b.modelEntityRelatedFromEntities);
        modelEntityRelatedFromEntities = java.util.Collections.unmodifiableSortedSet(modelEntityRelatedFromEntities);
        this.modelEntityRelatedFromEntities = modelEntityRelatedFromEntities;
        java.util.SortedSet<IModelEntityAssociation> modelEntityRelatedToEntities = new java.util.TreeSet<IModelEntityAssociation>();
        if (b.modelEntityRelatedToEntities != null) modelEntityRelatedToEntities.addAll(b.modelEntityRelatedToEntities);
        modelEntityRelatedToEntities = java.util.Collections.unmodifiableSortedSet(modelEntityRelatedToEntities);
        this.modelEntityRelatedToEntities = modelEntityRelatedToEntities;
        this.modelEntitySubjectArea = b.modelEntitySubjectArea;
        this.modelExpiredAtBusinessDate = b.modelExpiredAtBusinessDate;
        this.modelExpiredAtSystemDate = b.modelExpiredAtSystemDate;
        this.modelName = b.modelName;
        this.modelNamespace = b.modelNamespace;
        this.modelQualifiedName = b.modelQualifiedName;
        this.modelSystemDate = b.modelSystemDate;
        this.modelType = b.modelType;
        this.modelVersionName = b.modelVersionName;
        this.modelVersionQualifiedName = b.modelVersionQualifiedName;
        java.util.SortedSet<IModelVersion> modelVersions = new java.util.TreeSet<IModelVersion>();
        if (b.modelVersions != null) modelVersions.addAll(b.modelVersions);
        modelVersions = java.util.Collections.unmodifiableSortedSet(modelVersions);
        this.modelVersions = modelVersions;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ModelEntity.ModelEntityBuilder<?, ?> _internal() {
        return new ModelEntity.ModelEntityBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ModelEntity.ModelEntityBuilder<?, ?> toBuilder() {
        return new ModelEntity.ModelEntityBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Business date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelBusinessDate() {
        return this.modelBusinessDate;
    }

    /**
     * Model domain in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelDomain() {
        return this.modelDomain;
    }

    /**
     * Number of attributes in the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelEntityAttributeCount() {
        return this.modelEntityAttributeCount;
    }

    /**
     * Individual attributes that make up the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IModelAttribute> getModelEntityAttributes() {
        return this.modelEntityAttributes;
    }

    /**
     * Entities from which this entity is mapped.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IModelEntity> getModelEntityMappedFromEntities() {
        return this.modelEntityMappedFromEntities;
    }

    /**
     * Entities to which this entity is mapped.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IModelEntity> getModelEntityMappedToEntities() {
        return this.modelEntityMappedToEntities;
    }

    /**
     * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelEntityName() {
        return this.modelEntityName;
    }

    /**
     * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelEntityQualifiedName() {
        return this.modelEntityQualifiedName;
    }

    /**
     * Association from which this entity is related.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IModelEntityAssociation> getModelEntityRelatedFromEntities() {
        return this.modelEntityRelatedFromEntities;
    }

    /**
     * Association to which this entity is related.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IModelEntityAssociation> getModelEntityRelatedToEntities() {
        return this.modelEntityRelatedToEntities;
    }

    /**
     * Subject area of the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelEntitySubjectArea() {
        return this.modelEntitySubjectArea;
    }

    /**
     * Business expiration date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelExpiredAtBusinessDate() {
        return this.modelExpiredAtBusinessDate;
    }

    /**
     * System expiration date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelExpiredAtSystemDate() {
        return this.modelExpiredAtSystemDate;
    }

    /**
     * Simple name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelName() {
        return this.modelName;
    }

    /**
     * Model namespace in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelNamespace() {
        return this.modelNamespace;
    }

    /**
     * Unique name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelQualifiedName() {
        return this.modelQualifiedName;
    }

    /**
     * System date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelSystemDate() {
        return this.modelSystemDate;
    }

    /**
     * Type of the model asset (conceptual, logical, physical).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelType() {
        return this.modelType;
    }

    /**
     * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelVersionName() {
        return this.modelVersionName;
    }

    /**
     * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelVersionQualifiedName() {
        return this.modelVersionQualifiedName;
    }

    /**
     * Data model version(s) in which this entity exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IModelVersion> getModelVersions() {
        return this.modelVersions;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ModelEntity)) return false;
        final ModelEntity other = (ModelEntity) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$modelBusinessDate = this.getModelBusinessDate();
        final java.lang.Object other$modelBusinessDate = other.getModelBusinessDate();
        if (this$modelBusinessDate == null ? other$modelBusinessDate != null : !this$modelBusinessDate.equals(other$modelBusinessDate)) return false;
        final java.lang.Object this$modelEntityAttributeCount = this.getModelEntityAttributeCount();
        final java.lang.Object other$modelEntityAttributeCount = other.getModelEntityAttributeCount();
        if (this$modelEntityAttributeCount == null ? other$modelEntityAttributeCount != null : !this$modelEntityAttributeCount.equals(other$modelEntityAttributeCount)) return false;
        final java.lang.Object this$modelExpiredAtBusinessDate = this.getModelExpiredAtBusinessDate();
        final java.lang.Object other$modelExpiredAtBusinessDate = other.getModelExpiredAtBusinessDate();
        if (this$modelExpiredAtBusinessDate == null ? other$modelExpiredAtBusinessDate != null : !this$modelExpiredAtBusinessDate.equals(other$modelExpiredAtBusinessDate)) return false;
        final java.lang.Object this$modelExpiredAtSystemDate = this.getModelExpiredAtSystemDate();
        final java.lang.Object other$modelExpiredAtSystemDate = other.getModelExpiredAtSystemDate();
        if (this$modelExpiredAtSystemDate == null ? other$modelExpiredAtSystemDate != null : !this$modelExpiredAtSystemDate.equals(other$modelExpiredAtSystemDate)) return false;
        final java.lang.Object this$modelSystemDate = this.getModelSystemDate();
        final java.lang.Object other$modelSystemDate = other.getModelSystemDate();
        if (this$modelSystemDate == null ? other$modelSystemDate != null : !this$modelSystemDate.equals(other$modelSystemDate)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$modelDomain = this.getModelDomain();
        final java.lang.Object other$modelDomain = other.getModelDomain();
        if (this$modelDomain == null ? other$modelDomain != null : !this$modelDomain.equals(other$modelDomain)) return false;
        final java.lang.Object this$modelEntityAttributes = this.getModelEntityAttributes();
        final java.lang.Object other$modelEntityAttributes = other.getModelEntityAttributes();
        if (this$modelEntityAttributes == null ? other$modelEntityAttributes != null : !this$modelEntityAttributes.equals(other$modelEntityAttributes)) return false;
        final java.lang.Object this$modelEntityMappedFromEntities = this.getModelEntityMappedFromEntities();
        final java.lang.Object other$modelEntityMappedFromEntities = other.getModelEntityMappedFromEntities();
        if (this$modelEntityMappedFromEntities == null ? other$modelEntityMappedFromEntities != null : !this$modelEntityMappedFromEntities.equals(other$modelEntityMappedFromEntities)) return false;
        final java.lang.Object this$modelEntityMappedToEntities = this.getModelEntityMappedToEntities();
        final java.lang.Object other$modelEntityMappedToEntities = other.getModelEntityMappedToEntities();
        if (this$modelEntityMappedToEntities == null ? other$modelEntityMappedToEntities != null : !this$modelEntityMappedToEntities.equals(other$modelEntityMappedToEntities)) return false;
        final java.lang.Object this$modelEntityName = this.getModelEntityName();
        final java.lang.Object other$modelEntityName = other.getModelEntityName();
        if (this$modelEntityName == null ? other$modelEntityName != null : !this$modelEntityName.equals(other$modelEntityName)) return false;
        final java.lang.Object this$modelEntityQualifiedName = this.getModelEntityQualifiedName();
        final java.lang.Object other$modelEntityQualifiedName = other.getModelEntityQualifiedName();
        if (this$modelEntityQualifiedName == null ? other$modelEntityQualifiedName != null : !this$modelEntityQualifiedName.equals(other$modelEntityQualifiedName)) return false;
        final java.lang.Object this$modelEntityRelatedFromEntities = this.getModelEntityRelatedFromEntities();
        final java.lang.Object other$modelEntityRelatedFromEntities = other.getModelEntityRelatedFromEntities();
        if (this$modelEntityRelatedFromEntities == null ? other$modelEntityRelatedFromEntities != null : !this$modelEntityRelatedFromEntities.equals(other$modelEntityRelatedFromEntities)) return false;
        final java.lang.Object this$modelEntityRelatedToEntities = this.getModelEntityRelatedToEntities();
        final java.lang.Object other$modelEntityRelatedToEntities = other.getModelEntityRelatedToEntities();
        if (this$modelEntityRelatedToEntities == null ? other$modelEntityRelatedToEntities != null : !this$modelEntityRelatedToEntities.equals(other$modelEntityRelatedToEntities)) return false;
        final java.lang.Object this$modelEntitySubjectArea = this.getModelEntitySubjectArea();
        final java.lang.Object other$modelEntitySubjectArea = other.getModelEntitySubjectArea();
        if (this$modelEntitySubjectArea == null ? other$modelEntitySubjectArea != null : !this$modelEntitySubjectArea.equals(other$modelEntitySubjectArea)) return false;
        final java.lang.Object this$modelName = this.getModelName();
        final java.lang.Object other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) return false;
        final java.lang.Object this$modelNamespace = this.getModelNamespace();
        final java.lang.Object other$modelNamespace = other.getModelNamespace();
        if (this$modelNamespace == null ? other$modelNamespace != null : !this$modelNamespace.equals(other$modelNamespace)) return false;
        final java.lang.Object this$modelQualifiedName = this.getModelQualifiedName();
        final java.lang.Object other$modelQualifiedName = other.getModelQualifiedName();
        if (this$modelQualifiedName == null ? other$modelQualifiedName != null : !this$modelQualifiedName.equals(other$modelQualifiedName)) return false;
        final java.lang.Object this$modelType = this.getModelType();
        final java.lang.Object other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) return false;
        final java.lang.Object this$modelVersionName = this.getModelVersionName();
        final java.lang.Object other$modelVersionName = other.getModelVersionName();
        if (this$modelVersionName == null ? other$modelVersionName != null : !this$modelVersionName.equals(other$modelVersionName)) return false;
        final java.lang.Object this$modelVersionQualifiedName = this.getModelVersionQualifiedName();
        final java.lang.Object other$modelVersionQualifiedName = other.getModelVersionQualifiedName();
        if (this$modelVersionQualifiedName == null ? other$modelVersionQualifiedName != null : !this$modelVersionQualifiedName.equals(other$modelVersionQualifiedName)) return false;
        final java.lang.Object this$modelVersions = this.getModelVersions();
        final java.lang.Object other$modelVersions = other.getModelVersions();
        if (this$modelVersions == null ? other$modelVersions != null : !this$modelVersions.equals(other$modelVersions)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ModelEntity;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $modelBusinessDate = this.getModelBusinessDate();
        result = result * PRIME + ($modelBusinessDate == null ? 43 : $modelBusinessDate.hashCode());
        final java.lang.Object $modelEntityAttributeCount = this.getModelEntityAttributeCount();
        result = result * PRIME + ($modelEntityAttributeCount == null ? 43 : $modelEntityAttributeCount.hashCode());
        final java.lang.Object $modelExpiredAtBusinessDate = this.getModelExpiredAtBusinessDate();
        result = result * PRIME + ($modelExpiredAtBusinessDate == null ? 43 : $modelExpiredAtBusinessDate.hashCode());
        final java.lang.Object $modelExpiredAtSystemDate = this.getModelExpiredAtSystemDate();
        result = result * PRIME + ($modelExpiredAtSystemDate == null ? 43 : $modelExpiredAtSystemDate.hashCode());
        final java.lang.Object $modelSystemDate = this.getModelSystemDate();
        result = result * PRIME + ($modelSystemDate == null ? 43 : $modelSystemDate.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $modelDomain = this.getModelDomain();
        result = result * PRIME + ($modelDomain == null ? 43 : $modelDomain.hashCode());
        final java.lang.Object $modelEntityAttributes = this.getModelEntityAttributes();
        result = result * PRIME + ($modelEntityAttributes == null ? 43 : $modelEntityAttributes.hashCode());
        final java.lang.Object $modelEntityMappedFromEntities = this.getModelEntityMappedFromEntities();
        result = result * PRIME + ($modelEntityMappedFromEntities == null ? 43 : $modelEntityMappedFromEntities.hashCode());
        final java.lang.Object $modelEntityMappedToEntities = this.getModelEntityMappedToEntities();
        result = result * PRIME + ($modelEntityMappedToEntities == null ? 43 : $modelEntityMappedToEntities.hashCode());
        final java.lang.Object $modelEntityName = this.getModelEntityName();
        result = result * PRIME + ($modelEntityName == null ? 43 : $modelEntityName.hashCode());
        final java.lang.Object $modelEntityQualifiedName = this.getModelEntityQualifiedName();
        result = result * PRIME + ($modelEntityQualifiedName == null ? 43 : $modelEntityQualifiedName.hashCode());
        final java.lang.Object $modelEntityRelatedFromEntities = this.getModelEntityRelatedFromEntities();
        result = result * PRIME + ($modelEntityRelatedFromEntities == null ? 43 : $modelEntityRelatedFromEntities.hashCode());
        final java.lang.Object $modelEntityRelatedToEntities = this.getModelEntityRelatedToEntities();
        result = result * PRIME + ($modelEntityRelatedToEntities == null ? 43 : $modelEntityRelatedToEntities.hashCode());
        final java.lang.Object $modelEntitySubjectArea = this.getModelEntitySubjectArea();
        result = result * PRIME + ($modelEntitySubjectArea == null ? 43 : $modelEntitySubjectArea.hashCode());
        final java.lang.Object $modelName = this.getModelName();
        result = result * PRIME + ($modelName == null ? 43 : $modelName.hashCode());
        final java.lang.Object $modelNamespace = this.getModelNamespace();
        result = result * PRIME + ($modelNamespace == null ? 43 : $modelNamespace.hashCode());
        final java.lang.Object $modelQualifiedName = this.getModelQualifiedName();
        result = result * PRIME + ($modelQualifiedName == null ? 43 : $modelQualifiedName.hashCode());
        final java.lang.Object $modelType = this.getModelType();
        result = result * PRIME + ($modelType == null ? 43 : $modelType.hashCode());
        final java.lang.Object $modelVersionName = this.getModelVersionName();
        result = result * PRIME + ($modelVersionName == null ? 43 : $modelVersionName.hashCode());
        final java.lang.Object $modelVersionQualifiedName = this.getModelVersionQualifiedName();
        result = result * PRIME + ($modelVersionQualifiedName == null ? 43 : $modelVersionQualifiedName.hashCode());
        final java.lang.Object $modelVersions = this.getModelVersions();
        result = result * PRIME + ($modelVersions == null ? 43 : $modelVersions.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ModelEntity(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelBusinessDate=" + this.getModelBusinessDate() + ", modelDomain=" + this.getModelDomain() + ", modelEntityAttributeCount=" + this.getModelEntityAttributeCount() + ", modelEntityAttributes=" + this.getModelEntityAttributes() + ", modelEntityMappedFromEntities=" + this.getModelEntityMappedFromEntities() + ", modelEntityMappedToEntities=" + this.getModelEntityMappedToEntities() + ", modelEntityName=" + this.getModelEntityName() + ", modelEntityQualifiedName=" + this.getModelEntityQualifiedName() + ", modelEntityRelatedFromEntities=" + this.getModelEntityRelatedFromEntities() + ", modelEntityRelatedToEntities=" + this.getModelEntityRelatedToEntities() + ", modelEntitySubjectArea=" + this.getModelEntitySubjectArea() + ", modelExpiredAtBusinessDate=" + this.getModelExpiredAtBusinessDate() + ", modelExpiredAtSystemDate=" + this.getModelExpiredAtSystemDate() + ", modelName=" + this.getModelName() + ", modelNamespace=" + this.getModelNamespace() + ", modelQualifiedName=" + this.getModelQualifiedName() + ", modelSystemDate=" + this.getModelSystemDate() + ", modelType=" + this.getModelType() + ", modelVersionName=" + this.getModelVersionName() + ", modelVersionQualifiedName=" + this.getModelVersionQualifiedName() + ", modelVersions=" + this.getModelVersions() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for ModelEntitys.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
