// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a version of a data model in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class ModelVersion extends Asset implements IModelVersion, IModel, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ModelVersion.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModelVersion";
    /**
     * Fixed typeName for ModelVersions.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Business date for the asset.
     */
    @Attribute
    @Date
    Long modelBusinessDate;
    /**
     * Data model for which this version exists.
     */
    @Attribute
    IModelDataModel modelDataModel;
    /**
     * Model domain in which this asset exists.
     */
    @Attribute
    String modelDomain;
    /**
     * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @Attribute
    String modelEntityName;
    /**
     * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @Attribute
    String modelEntityQualifiedName;
    /**
     * Business expiration date for the asset.
     */
    @Attribute
    @Date
    Long modelExpiredAtBusinessDate;
    /**
     * System expiration date for the asset.
     */
    @Attribute
    @Date
    Long modelExpiredAtSystemDate;
    /**
     * Simple name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @Attribute
    String modelName;
    /**
     * Model namespace in which this asset exists.
     */
    @Attribute
    String modelNamespace;
    /**
     * Unique name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @Attribute
    String modelQualifiedName;
    /**
     * System date for the asset.
     */
    @Attribute
    @Date
    Long modelSystemDate;
    /**
     * Type of the model asset (conceptual, logical, physical).
     */
    @Attribute
    String modelType;
    /**
     * Individual entities that make up this version of the data model.
     */
    @Attribute
    SortedSet<IModelEntity> modelVersionEntities;
    /**
     * Number of entities in the version.
     */
    @Attribute
    Long modelVersionEntityCount;
    /**
     * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @Attribute
    String modelVersionName;
    /**
     * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @Attribute
    String modelVersionQualifiedName;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    /**
     * Builds the minimal object necessary to create a relationship to a ModelVersion, from a potentially
     * more-complete ModelVersion object.
     *
     * @return the minimal object necessary to relate to the ModelVersion
     * @throws InvalidRequestException if any of the minimal set of required properties for a ModelVersion relationship are not found in the initial object
     */
    @Override
    public ModelVersion trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all ModelVersion assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ModelVersion assets will be included.
     *
     * @return a fluent search that includes all ModelVersion assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all ModelVersion assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) ModelVersion assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all ModelVersion assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all ModelVersion assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) ModelVersions will be included
     * @return a fluent search that includes all ModelVersion assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all ModelVersion assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) ModelVersions will be included
     * @return a fluent search that includes all ModelVersion assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a ModelVersion by GUID. Use this to create a relationship to this ModelVersion,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the ModelVersion to reference
     * @return reference to a ModelVersion that can be used for defining a relationship to a ModelVersion
     */
    public static ModelVersion refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ModelVersion by GUID. Use this to create a relationship to this ModelVersion,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the ModelVersion to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ModelVersion that can be used for defining a relationship to a ModelVersion
     */
    public static ModelVersion refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ModelVersion._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a ModelVersion by qualifiedName. Use this to create a relationship to this ModelVersion,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the ModelVersion to reference
     * @return reference to a ModelVersion that can be used for defining a relationship to a ModelVersion
     */
    public static ModelVersion refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a ModelVersion by qualifiedName. Use this to create a relationship to this ModelVersion,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the ModelVersion to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a ModelVersion that can be used for defining a relationship to a ModelVersion
     */
    public static ModelVersion refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ModelVersion._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a ModelVersion by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the ModelVersion to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ModelVersion, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModelVersion does not exist or the provided GUID is not a ModelVersion
     */
    @JsonIgnore
    public static ModelVersion get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a ModelVersion by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ModelVersion to retrieve, either its GUID or its full qualifiedName
     * @return the requested full ModelVersion, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModelVersion does not exist or the provided GUID is not a ModelVersion
     */
    @JsonIgnore
    public static ModelVersion get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a ModelVersion by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the ModelVersion to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full ModelVersion, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the ModelVersion does not exist or the provided GUID is not a ModelVersion
     */
    @JsonIgnore
    public static ModelVersion get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof ModelVersion) {
                return (ModelVersion) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof ModelVersion) {
                return (ModelVersion) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) ModelVersion to active.
     *
     * @param qualifiedName for the ModelVersion
     * @return true if the ModelVersion is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) ModelVersion to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the ModelVersion
     * @return true if the ModelVersion is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the minimal request necessary to update the ModelVersion, as a builder
     */
    public static ModelVersionBuilder<?, ?> updater(String qualifiedName, String name) {
        return ModelVersion._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a ModelVersion, from a potentially
     * more-complete ModelVersion object.
     *
     * @return the minimal object necessary to update the ModelVersion, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for ModelVersion are not found in the initial object
     */
    @Override
    public ModelVersionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a ModelVersion.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelVersion) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a ModelVersion.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelVersion) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a ModelVersion.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ModelVersion's owners
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelVersion) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ModelVersion, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a ModelVersion.
     *
     * @param client connectivity to the Atlan tenant on which to update the ModelVersion's certificate
     * @param qualifiedName of the ModelVersion
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated ModelVersion, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModelVersion) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a ModelVersion.
     *
     * @param client connectivity to the Atlan tenant from which to remove the ModelVersion's certificate
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelVersion) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a ModelVersion.
     *
     * @param client connectivity to the Atlan tenant on which to update the ModelVersion's announcement
     * @param qualifiedName of the ModelVersion
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModelVersion) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a ModelVersion.
     *
     * @param client connectivity to the Atlan client from which to remove the ModelVersion's announcement
     * @param qualifiedName of the ModelVersion
     * @param name of the ModelVersion
     * @return the updated ModelVersion, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelVersion) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the ModelVersion.
     *
     * @param qualifiedName for the ModelVersion
     * @param name human-readable name of the ModelVersion
     * @param terms the list of terms to replace on the ModelVersion, or null to remove all terms from the ModelVersion
     * @return the ModelVersion that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ModelVersion replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the ModelVersion.
     *
     * @param client connectivity to the Atlan tenant on which to replace the ModelVersion's assigned terms
     * @param qualifiedName for the ModelVersion
     * @param name human-readable name of the ModelVersion
     * @param terms the list of terms to replace on the ModelVersion, or null to remove all terms from the ModelVersion
     * @return the ModelVersion that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static ModelVersion replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelVersion) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the ModelVersion, without replacing existing terms linked to the ModelVersion.
     * Note: this operation must make two API calls — one to retrieve the ModelVersion's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the ModelVersion
     * @param terms the list of terms to append to the ModelVersion
     * @return the ModelVersion that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ModelVersion appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the ModelVersion, without replacing existing terms linked to the ModelVersion.
     * Note: this operation must make two API calls — one to retrieve the ModelVersion's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the ModelVersion
     * @param qualifiedName for the ModelVersion
     * @param terms the list of terms to append to the ModelVersion
     * @return the ModelVersion that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static ModelVersion appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelVersion) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a ModelVersion, without replacing all existing terms linked to the ModelVersion.
     * Note: this operation must make two API calls — one to retrieve the ModelVersion's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the ModelVersion
     * @param terms the list of terms to remove from the ModelVersion, which must be referenced by GUID
     * @return the ModelVersion that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a ModelVersion, without replacing all existing terms linked to the ModelVersion.
     * Note: this operation must make two API calls — one to retrieve the ModelVersion's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the ModelVersion
     * @param qualifiedName for the ModelVersion
     * @param terms the list of terms to remove from the ModelVersion, which must be referenced by GUID
     * @return the ModelVersion that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static ModelVersion removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelVersion) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a ModelVersion, without replacing existing Atlan tags linked to the ModelVersion.
     * Note: this operation must make two API calls — one to retrieve the ModelVersion's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ModelVersion
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ModelVersion
     */
    public static ModelVersion appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ModelVersion, without replacing existing Atlan tags linked to the ModelVersion.
     * Note: this operation must make two API calls — one to retrieve the ModelVersion's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ModelVersion
     * @param qualifiedName of the ModelVersion
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated ModelVersion
     */
    public static ModelVersion appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModelVersion) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a ModelVersion, without replacing existing Atlan tags linked to the ModelVersion.
     * Note: this operation must make two API calls — one to retrieve the ModelVersion's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the ModelVersion
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ModelVersion
     */
    public static ModelVersion appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a ModelVersion, without replacing existing Atlan tags linked to the ModelVersion.
     * Note: this operation must make two API calls — one to retrieve the ModelVersion's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the ModelVersion
     * @param qualifiedName of the ModelVersion
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated ModelVersion
     */
    public static ModelVersion appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModelVersion) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a ModelVersion.
     *
     * @param qualifiedName of the ModelVersion
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ModelVersion
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a ModelVersion.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a ModelVersion
     * @param qualifiedName of the ModelVersion
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the ModelVersion
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class ModelVersionBuilder<C extends ModelVersion, B extends ModelVersion.ModelVersionBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelBusinessDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IModelDataModel modelDataModel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelDomain;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelEntityName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelEntityQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelExpiredAtBusinessDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelExpiredAtSystemDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelNamespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelSystemDate;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IModelEntity> modelVersionEntities;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long modelVersionEntityCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelVersionName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String modelVersionQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            ModelVersion.ModelVersionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final ModelVersion instance, final ModelVersion.ModelVersionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.modelBusinessDate(instance.modelBusinessDate);
            b.modelDataModel(instance.modelDataModel);
            b.modelDomain(instance.modelDomain);
            b.modelEntityName(instance.modelEntityName);
            b.modelEntityQualifiedName(instance.modelEntityQualifiedName);
            b.modelExpiredAtBusinessDate(instance.modelExpiredAtBusinessDate);
            b.modelExpiredAtSystemDate(instance.modelExpiredAtSystemDate);
            b.modelName(instance.modelName);
            b.modelNamespace(instance.modelNamespace);
            b.modelQualifiedName(instance.modelQualifiedName);
            b.modelSystemDate(instance.modelSystemDate);
            b.modelType(instance.modelType);
            b.modelVersionEntities(instance.modelVersionEntities == null ? java.util.Collections.<IModelEntity>emptySortedSet() : instance.modelVersionEntities);
            b.modelVersionEntityCount(instance.modelVersionEntityCount);
            b.modelVersionName(instance.modelVersionName);
            b.modelVersionQualifiedName(instance.modelVersionQualifiedName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
        }

        /**
         * Fixed typeName for ModelVersions.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Business date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelBusinessDate(final Long modelBusinessDate) {
            this.modelBusinessDate = modelBusinessDate;
            return self();
        }

        /**
         * Data model for which this version exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelDataModel(final IModelDataModel modelDataModel) {
            this.modelDataModel = modelDataModel;
            return self();
        }

        /**
         * Model domain in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelDomain(final String modelDomain) {
            this.modelDomain = modelDomain;
            return self();
        }

        /**
         * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityName(final String modelEntityName) {
            this.modelEntityName = modelEntityName;
            return self();
        }

        /**
         * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelEntityQualifiedName(final String modelEntityQualifiedName) {
            this.modelEntityQualifiedName = modelEntityQualifiedName;
            return self();
        }

        /**
         * Business expiration date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelExpiredAtBusinessDate(final Long modelExpiredAtBusinessDate) {
            this.modelExpiredAtBusinessDate = modelExpiredAtBusinessDate;
            return self();
        }

        /**
         * System expiration date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelExpiredAtSystemDate(final Long modelExpiredAtSystemDate) {
            this.modelExpiredAtSystemDate = modelExpiredAtSystemDate;
            return self();
        }

        /**
         * Simple name of the model in which this asset exists, or empty if it is itself a data model.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelName(final String modelName) {
            this.modelName = modelName;
            return self();
        }

        /**
         * Model namespace in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelNamespace(final String modelNamespace) {
            this.modelNamespace = modelNamespace;
            return self();
        }

        /**
         * Unique name of the model in which this asset exists, or empty if it is itself a data model.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelQualifiedName(final String modelQualifiedName) {
            this.modelQualifiedName = modelQualifiedName;
            return self();
        }

        /**
         * System date for the asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelSystemDate(final Long modelSystemDate) {
            this.modelSystemDate = modelSystemDate;
            return self();
        }

        /**
         * Type of the model asset (conceptual, logical, physical).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelType(final String modelType) {
            this.modelType = modelType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersionEntity(final IModelEntity modelVersionEntity) {
            if (this.modelVersionEntities == null) this.modelVersionEntities = new java.util.ArrayList<IModelEntity>();
            this.modelVersionEntities.add(modelVersionEntity);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersionEntities(final java.util.Collection<? extends IModelEntity> modelVersionEntities) {
            if (modelVersionEntities == null) {
                throw new java.lang.NullPointerException("modelVersionEntities cannot be null");
            }
            if (this.modelVersionEntities == null) this.modelVersionEntities = new java.util.ArrayList<IModelEntity>();
            this.modelVersionEntities.addAll(modelVersionEntities);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearModelVersionEntities() {
            if (this.modelVersionEntities != null) this.modelVersionEntities.clear();
            return self();
        }

        /**
         * Number of entities in the version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersionEntityCount(final Long modelVersionEntityCount) {
            this.modelVersionEntityCount = modelVersionEntityCount;
            return self();
        }

        /**
         * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersionName(final String modelVersionName) {
            this.modelVersionName = modelVersionName;
            return self();
        }

        /**
         * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B modelVersionQualifiedName(final String modelVersionQualifiedName) {
            this.modelVersionQualifiedName = modelVersionQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ModelVersion.ModelVersionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", modelBusinessDate=" + this.modelBusinessDate + ", modelDataModel=" + this.modelDataModel + ", modelDomain=" + this.modelDomain + ", modelEntityName=" + this.modelEntityName + ", modelEntityQualifiedName=" + this.modelEntityQualifiedName + ", modelExpiredAtBusinessDate=" + this.modelExpiredAtBusinessDate + ", modelExpiredAtSystemDate=" + this.modelExpiredAtSystemDate + ", modelName=" + this.modelName + ", modelNamespace=" + this.modelNamespace + ", modelQualifiedName=" + this.modelQualifiedName + ", modelSystemDate=" + this.modelSystemDate + ", modelType=" + this.modelType + ", modelVersionEntities=" + this.modelVersionEntities + ", modelVersionEntityCount=" + this.modelVersionEntityCount + ", modelVersionName=" + this.modelVersionName + ", modelVersionQualifiedName=" + this.modelVersionQualifiedName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class ModelVersionBuilderImpl extends ModelVersion.ModelVersionBuilder<ModelVersion, ModelVersion.ModelVersionBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ModelVersionBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ModelVersion.ModelVersionBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ModelVersion build() {
            return new ModelVersion(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected ModelVersion(final ModelVersion.ModelVersionBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = ModelVersion.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.modelBusinessDate = b.modelBusinessDate;
        this.modelDataModel = b.modelDataModel;
        this.modelDomain = b.modelDomain;
        this.modelEntityName = b.modelEntityName;
        this.modelEntityQualifiedName = b.modelEntityQualifiedName;
        this.modelExpiredAtBusinessDate = b.modelExpiredAtBusinessDate;
        this.modelExpiredAtSystemDate = b.modelExpiredAtSystemDate;
        this.modelName = b.modelName;
        this.modelNamespace = b.modelNamespace;
        this.modelQualifiedName = b.modelQualifiedName;
        this.modelSystemDate = b.modelSystemDate;
        this.modelType = b.modelType;
        java.util.SortedSet<IModelEntity> modelVersionEntities = new java.util.TreeSet<IModelEntity>();
        if (b.modelVersionEntities != null) modelVersionEntities.addAll(b.modelVersionEntities);
        modelVersionEntities = java.util.Collections.unmodifiableSortedSet(modelVersionEntities);
        this.modelVersionEntities = modelVersionEntities;
        this.modelVersionEntityCount = b.modelVersionEntityCount;
        this.modelVersionName = b.modelVersionName;
        this.modelVersionQualifiedName = b.modelVersionQualifiedName;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ModelVersion.ModelVersionBuilder<?, ?> _internal() {
        return new ModelVersion.ModelVersionBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ModelVersion.ModelVersionBuilder<?, ?> toBuilder() {
        return new ModelVersion.ModelVersionBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Business date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelBusinessDate() {
        return this.modelBusinessDate;
    }

    /**
     * Data model for which this version exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IModelDataModel getModelDataModel() {
        return this.modelDataModel;
    }

    /**
     * Model domain in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelDomain() {
        return this.modelDomain;
    }

    /**
     * Simple name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelEntityName() {
        return this.modelEntityName;
    }

    /**
     * Unique name of the entity in which this asset exists, or empty if it is itself a data model entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelEntityQualifiedName() {
        return this.modelEntityQualifiedName;
    }

    /**
     * Business expiration date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelExpiredAtBusinessDate() {
        return this.modelExpiredAtBusinessDate;
    }

    /**
     * System expiration date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelExpiredAtSystemDate() {
        return this.modelExpiredAtSystemDate;
    }

    /**
     * Simple name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelName() {
        return this.modelName;
    }

    /**
     * Model namespace in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelNamespace() {
        return this.modelNamespace;
    }

    /**
     * Unique name of the model in which this asset exists, or empty if it is itself a data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelQualifiedName() {
        return this.modelQualifiedName;
    }

    /**
     * System date for the asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelSystemDate() {
        return this.modelSystemDate;
    }

    /**
     * Type of the model asset (conceptual, logical, physical).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelType() {
        return this.modelType;
    }

    /**
     * Individual entities that make up this version of the data model.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IModelEntity> getModelVersionEntities() {
        return this.modelVersionEntities;
    }

    /**
     * Number of entities in the version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getModelVersionEntityCount() {
        return this.modelVersionEntityCount;
    }

    /**
     * Simple name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelVersionName() {
        return this.modelVersionName;
    }

    /**
     * Unique name of the version in which this asset exists, or empty if it is itself a data model version.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getModelVersionQualifiedName() {
        return this.modelVersionQualifiedName;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ModelVersion)) return false;
        final ModelVersion other = (ModelVersion) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$modelBusinessDate = this.getModelBusinessDate();
        final java.lang.Object other$modelBusinessDate = other.getModelBusinessDate();
        if (this$modelBusinessDate == null ? other$modelBusinessDate != null : !this$modelBusinessDate.equals(other$modelBusinessDate)) return false;
        final java.lang.Object this$modelExpiredAtBusinessDate = this.getModelExpiredAtBusinessDate();
        final java.lang.Object other$modelExpiredAtBusinessDate = other.getModelExpiredAtBusinessDate();
        if (this$modelExpiredAtBusinessDate == null ? other$modelExpiredAtBusinessDate != null : !this$modelExpiredAtBusinessDate.equals(other$modelExpiredAtBusinessDate)) return false;
        final java.lang.Object this$modelExpiredAtSystemDate = this.getModelExpiredAtSystemDate();
        final java.lang.Object other$modelExpiredAtSystemDate = other.getModelExpiredAtSystemDate();
        if (this$modelExpiredAtSystemDate == null ? other$modelExpiredAtSystemDate != null : !this$modelExpiredAtSystemDate.equals(other$modelExpiredAtSystemDate)) return false;
        final java.lang.Object this$modelSystemDate = this.getModelSystemDate();
        final java.lang.Object other$modelSystemDate = other.getModelSystemDate();
        if (this$modelSystemDate == null ? other$modelSystemDate != null : !this$modelSystemDate.equals(other$modelSystemDate)) return false;
        final java.lang.Object this$modelVersionEntityCount = this.getModelVersionEntityCount();
        final java.lang.Object other$modelVersionEntityCount = other.getModelVersionEntityCount();
        if (this$modelVersionEntityCount == null ? other$modelVersionEntityCount != null : !this$modelVersionEntityCount.equals(other$modelVersionEntityCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$modelDataModel = this.getModelDataModel();
        final java.lang.Object other$modelDataModel = other.getModelDataModel();
        if (this$modelDataModel == null ? other$modelDataModel != null : !this$modelDataModel.equals(other$modelDataModel)) return false;
        final java.lang.Object this$modelDomain = this.getModelDomain();
        final java.lang.Object other$modelDomain = other.getModelDomain();
        if (this$modelDomain == null ? other$modelDomain != null : !this$modelDomain.equals(other$modelDomain)) return false;
        final java.lang.Object this$modelEntityName = this.getModelEntityName();
        final java.lang.Object other$modelEntityName = other.getModelEntityName();
        if (this$modelEntityName == null ? other$modelEntityName != null : !this$modelEntityName.equals(other$modelEntityName)) return false;
        final java.lang.Object this$modelEntityQualifiedName = this.getModelEntityQualifiedName();
        final java.lang.Object other$modelEntityQualifiedName = other.getModelEntityQualifiedName();
        if (this$modelEntityQualifiedName == null ? other$modelEntityQualifiedName != null : !this$modelEntityQualifiedName.equals(other$modelEntityQualifiedName)) return false;
        final java.lang.Object this$modelName = this.getModelName();
        final java.lang.Object other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) return false;
        final java.lang.Object this$modelNamespace = this.getModelNamespace();
        final java.lang.Object other$modelNamespace = other.getModelNamespace();
        if (this$modelNamespace == null ? other$modelNamespace != null : !this$modelNamespace.equals(other$modelNamespace)) return false;
        final java.lang.Object this$modelQualifiedName = this.getModelQualifiedName();
        final java.lang.Object other$modelQualifiedName = other.getModelQualifiedName();
        if (this$modelQualifiedName == null ? other$modelQualifiedName != null : !this$modelQualifiedName.equals(other$modelQualifiedName)) return false;
        final java.lang.Object this$modelType = this.getModelType();
        final java.lang.Object other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) return false;
        final java.lang.Object this$modelVersionEntities = this.getModelVersionEntities();
        final java.lang.Object other$modelVersionEntities = other.getModelVersionEntities();
        if (this$modelVersionEntities == null ? other$modelVersionEntities != null : !this$modelVersionEntities.equals(other$modelVersionEntities)) return false;
        final java.lang.Object this$modelVersionName = this.getModelVersionName();
        final java.lang.Object other$modelVersionName = other.getModelVersionName();
        if (this$modelVersionName == null ? other$modelVersionName != null : !this$modelVersionName.equals(other$modelVersionName)) return false;
        final java.lang.Object this$modelVersionQualifiedName = this.getModelVersionQualifiedName();
        final java.lang.Object other$modelVersionQualifiedName = other.getModelVersionQualifiedName();
        if (this$modelVersionQualifiedName == null ? other$modelVersionQualifiedName != null : !this$modelVersionQualifiedName.equals(other$modelVersionQualifiedName)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ModelVersion;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $modelBusinessDate = this.getModelBusinessDate();
        result = result * PRIME + ($modelBusinessDate == null ? 43 : $modelBusinessDate.hashCode());
        final java.lang.Object $modelExpiredAtBusinessDate = this.getModelExpiredAtBusinessDate();
        result = result * PRIME + ($modelExpiredAtBusinessDate == null ? 43 : $modelExpiredAtBusinessDate.hashCode());
        final java.lang.Object $modelExpiredAtSystemDate = this.getModelExpiredAtSystemDate();
        result = result * PRIME + ($modelExpiredAtSystemDate == null ? 43 : $modelExpiredAtSystemDate.hashCode());
        final java.lang.Object $modelSystemDate = this.getModelSystemDate();
        result = result * PRIME + ($modelSystemDate == null ? 43 : $modelSystemDate.hashCode());
        final java.lang.Object $modelVersionEntityCount = this.getModelVersionEntityCount();
        result = result * PRIME + ($modelVersionEntityCount == null ? 43 : $modelVersionEntityCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $modelDataModel = this.getModelDataModel();
        result = result * PRIME + ($modelDataModel == null ? 43 : $modelDataModel.hashCode());
        final java.lang.Object $modelDomain = this.getModelDomain();
        result = result * PRIME + ($modelDomain == null ? 43 : $modelDomain.hashCode());
        final java.lang.Object $modelEntityName = this.getModelEntityName();
        result = result * PRIME + ($modelEntityName == null ? 43 : $modelEntityName.hashCode());
        final java.lang.Object $modelEntityQualifiedName = this.getModelEntityQualifiedName();
        result = result * PRIME + ($modelEntityQualifiedName == null ? 43 : $modelEntityQualifiedName.hashCode());
        final java.lang.Object $modelName = this.getModelName();
        result = result * PRIME + ($modelName == null ? 43 : $modelName.hashCode());
        final java.lang.Object $modelNamespace = this.getModelNamespace();
        result = result * PRIME + ($modelNamespace == null ? 43 : $modelNamespace.hashCode());
        final java.lang.Object $modelQualifiedName = this.getModelQualifiedName();
        result = result * PRIME + ($modelQualifiedName == null ? 43 : $modelQualifiedName.hashCode());
        final java.lang.Object $modelType = this.getModelType();
        result = result * PRIME + ($modelType == null ? 43 : $modelType.hashCode());
        final java.lang.Object $modelVersionEntities = this.getModelVersionEntities();
        result = result * PRIME + ($modelVersionEntities == null ? 43 : $modelVersionEntities.hashCode());
        final java.lang.Object $modelVersionName = this.getModelVersionName();
        result = result * PRIME + ($modelVersionName == null ? 43 : $modelVersionName.hashCode());
        final java.lang.Object $modelVersionQualifiedName = this.getModelVersionQualifiedName();
        result = result * PRIME + ($modelVersionQualifiedName == null ? 43 : $modelVersionQualifiedName.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ModelVersion(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", modelBusinessDate=" + this.getModelBusinessDate() + ", modelDataModel=" + this.getModelDataModel() + ", modelDomain=" + this.getModelDomain() + ", modelEntityName=" + this.getModelEntityName() + ", modelEntityQualifiedName=" + this.getModelEntityQualifiedName() + ", modelExpiredAtBusinessDate=" + this.getModelExpiredAtBusinessDate() + ", modelExpiredAtSystemDate=" + this.getModelExpiredAtSystemDate() + ", modelName=" + this.getModelName() + ", modelNamespace=" + this.getModelNamespace() + ", modelQualifiedName=" + this.getModelQualifiedName() + ", modelSystemDate=" + this.getModelSystemDate() + ", modelType=" + this.getModelType() + ", modelVersionEntities=" + this.getModelVersionEntities() + ", modelVersionEntityCount=" + this.getModelVersionEntityCount() + ", modelVersionName=" + this.getModelVersionName() + ", modelVersionQualifiedName=" + this.getModelVersionQualifiedName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    /**
     * Fixed typeName for ModelVersions.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
