// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Power BI dataflow in Atlan. Dataflows are reusable transformation logic that can be shared by many datasets and reports inside Power BI.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class PowerBIDataflow extends Asset implements IPowerBIDataflow, IPowerBI, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(PowerBIDataflow.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIDataflow";
    /**
     * Fixed typeName for PowerBIDataflows.
     */
    String typeName;
    /**
     * Datasets used by this dataflow.
     */
    @Attribute
    SortedSet<IPowerBIDataset> datasets;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Child Dataflows to this PowerBI Dataflow.
     */
    @Attribute
    SortedSet<IPowerBIDataflow> powerBIDataflowChildren;
    /**
     * Parent Dataflows to this PowerBI Dataflow.
     */
    @Attribute
    SortedSet<IPowerBIDataflow> powerBIDataflowParents;
    /**
     * Refresh Schedule frequency for a PowerBI Dataflow.
     */
    @Attribute
    String powerBIDataflowRefreshScheduleFrequency;
    /**
     * Time zone for the refresh schedule set for a PowerBI Dataflow.
     */
    @Attribute
    String powerBIDataflowRefreshScheduleTimeZone;
    /**
     * Time for the refresh schedule set for a PowerBI Dataflow.
     */
    @Attribute
    SortedSet<String> powerBIDataflowRefreshScheduleTimes;
    /**
     * Endorsement status of this asset, in Power BI.
     */
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    /**
     * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
     */
    @Attribute
    String powerBIFormatString;
    /**
     * Whether this asset is hidden in Power BI (true) or not (false).
     */
    @Attribute
    Boolean powerBIIsHidden;
    /**
     * Lineage process that associates this PowerBI Dataflow.
     */
    @Attribute
    SortedSet<ILineageProcess> powerBIProcesses;
    /**
     * Unique name of the Power BI table in which this asset exists.
     */
    @Attribute
    String powerBITableQualifiedName;
    /**
     * PowerBI Tables that are associated with this Dataflow.
     */
    @Attribute
    SortedSet<IPowerBITable> tables;
    /**
     * Deprecated. See 'sourceUrl' instead.
     */
    @Attribute
    String webUrl;
    /**
     * Workspace in which this dataflow exists.
     */
    @Attribute
    IPowerBIWorkspace workspace;
    /**
     * Unique name of the workspace in which this dataflow exists.
     */
    @Attribute
    String workspaceQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a PowerBIDataflow, from a potentially
     * more-complete PowerBIDataflow object.
     *
     * @return the minimal object necessary to relate to the PowerBIDataflow
     * @throws InvalidRequestException if any of the minimal set of required properties for a PowerBIDataflow relationship are not found in the initial object
     */
    @Override
    public PowerBIDataflow trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all PowerBIDataflow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PowerBIDataflow assets will be included.
     *
     * @return a fluent search that includes all PowerBIDataflow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all PowerBIDataflow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PowerBIDataflow assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all PowerBIDataflow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all PowerBIDataflow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) PowerBIDataflows will be included
     * @return a fluent search that includes all PowerBIDataflow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all PowerBIDataflow assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) PowerBIDataflows will be included
     * @return a fluent search that includes all PowerBIDataflow assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a PowerBIDataflow by GUID. Use this to create a relationship to this PowerBIDataflow,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the PowerBIDataflow to reference
     * @return reference to a PowerBIDataflow that can be used for defining a relationship to a PowerBIDataflow
     */
    public static PowerBIDataflow refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PowerBIDataflow by GUID. Use this to create a relationship to this PowerBIDataflow,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the PowerBIDataflow to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PowerBIDataflow that can be used for defining a relationship to a PowerBIDataflow
     */
    public static PowerBIDataflow refByGuid(String guid, Reference.SaveSemantic semantic) {
        return PowerBIDataflow._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a PowerBIDataflow by qualifiedName. Use this to create a relationship to this PowerBIDataflow,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the PowerBIDataflow to reference
     * @return reference to a PowerBIDataflow that can be used for defining a relationship to a PowerBIDataflow
     */
    public static PowerBIDataflow refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PowerBIDataflow by qualifiedName. Use this to create a relationship to this PowerBIDataflow,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the PowerBIDataflow to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PowerBIDataflow that can be used for defining a relationship to a PowerBIDataflow
     */
    public static PowerBIDataflow refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return PowerBIDataflow._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a PowerBIDataflow by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the PowerBIDataflow to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PowerBIDataflow, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIDataflow does not exist or the provided GUID is not a PowerBIDataflow
     */
    @JsonIgnore
    public static PowerBIDataflow get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a PowerBIDataflow by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PowerBIDataflow to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PowerBIDataflow, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIDataflow does not exist or the provided GUID is not a PowerBIDataflow
     */
    @JsonIgnore
    public static PowerBIDataflow get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a PowerBIDataflow by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PowerBIDataflow to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full PowerBIDataflow, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIDataflow does not exist or the provided GUID is not a PowerBIDataflow
     */
    @JsonIgnore
    public static PowerBIDataflow get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof PowerBIDataflow) {
                return (PowerBIDataflow) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof PowerBIDataflow) {
                return (PowerBIDataflow) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) PowerBIDataflow to active.
     *
     * @param qualifiedName for the PowerBIDataflow
     * @return true if the PowerBIDataflow is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) PowerBIDataflow to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the PowerBIDataflow
     * @return true if the PowerBIDataflow is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the minimal request necessary to update the PowerBIDataflow, as a builder
     */
    public static PowerBIDataflowBuilder<?, ?> updater(String qualifiedName, String name) {
        return PowerBIDataflow._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a PowerBIDataflow, from a potentially
     * more-complete PowerBIDataflow object.
     *
     * @return the minimal object necessary to update the PowerBIDataflow, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for PowerBIDataflow are not found in the initial object
     */
    @Override
    public PowerBIDataflowBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a PowerBIDataflow.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a PowerBIDataflow.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a PowerBIDataflow.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PowerBIDataflow's owners
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PowerBIDataflow, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a PowerBIDataflow.
     *
     * @param client connectivity to the Atlan tenant on which to update the PowerBIDataflow's certificate
     * @param qualifiedName of the PowerBIDataflow
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PowerBIDataflow, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIDataflow) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a PowerBIDataflow.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PowerBIDataflow's certificate
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a PowerBIDataflow.
     *
     * @param client connectivity to the Atlan tenant on which to update the PowerBIDataflow's announcement
     * @param qualifiedName of the PowerBIDataflow
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIDataflow) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a PowerBIDataflow.
     *
     * @param client connectivity to the Atlan client from which to remove the PowerBIDataflow's announcement
     * @param qualifiedName of the PowerBIDataflow
     * @param name of the PowerBIDataflow
     * @return the updated PowerBIDataflow, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the PowerBIDataflow.
     *
     * @param qualifiedName for the PowerBIDataflow
     * @param name human-readable name of the PowerBIDataflow
     * @param terms the list of terms to replace on the PowerBIDataflow, or null to remove all terms from the PowerBIDataflow
     * @return the PowerBIDataflow that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the PowerBIDataflow.
     *
     * @param client connectivity to the Atlan tenant on which to replace the PowerBIDataflow's assigned terms
     * @param qualifiedName for the PowerBIDataflow
     * @param name human-readable name of the PowerBIDataflow
     * @param terms the list of terms to replace on the PowerBIDataflow, or null to remove all terms from the PowerBIDataflow
     * @return the PowerBIDataflow that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the PowerBIDataflow, without replacing existing terms linked to the PowerBIDataflow.
     * Note: this operation must make two API calls — one to retrieve the PowerBIDataflow's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the PowerBIDataflow
     * @param terms the list of terms to append to the PowerBIDataflow
     * @return the PowerBIDataflow that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the PowerBIDataflow, without replacing existing terms linked to the PowerBIDataflow.
     * Note: this operation must make two API calls — one to retrieve the PowerBIDataflow's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the PowerBIDataflow
     * @param qualifiedName for the PowerBIDataflow
     * @param terms the list of terms to append to the PowerBIDataflow
     * @return the PowerBIDataflow that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a PowerBIDataflow, without replacing all existing terms linked to the PowerBIDataflow.
     * Note: this operation must make two API calls — one to retrieve the PowerBIDataflow's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the PowerBIDataflow
     * @param terms the list of terms to remove from the PowerBIDataflow, which must be referenced by GUID
     * @return the PowerBIDataflow that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a PowerBIDataflow, without replacing all existing terms linked to the PowerBIDataflow.
     * Note: this operation must make two API calls — one to retrieve the PowerBIDataflow's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the PowerBIDataflow
     * @param qualifiedName for the PowerBIDataflow
     * @param terms the list of terms to remove from the PowerBIDataflow, which must be referenced by GUID
     * @return the PowerBIDataflow that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIDataflow removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a PowerBIDataflow, without replacing existing Atlan tags linked to the PowerBIDataflow.
     * Note: this operation must make two API calls — one to retrieve the PowerBIDataflow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PowerBIDataflow
     */
    public static PowerBIDataflow appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PowerBIDataflow, without replacing existing Atlan tags linked to the PowerBIDataflow.
     * Note: this operation must make two API calls — one to retrieve the PowerBIDataflow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PowerBIDataflow
     * @param qualifiedName of the PowerBIDataflow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PowerBIDataflow
     */
    public static PowerBIDataflow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBIDataflow) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PowerBIDataflow, without replacing existing Atlan tags linked to the PowerBIDataflow.
     * Note: this operation must make two API calls — one to retrieve the PowerBIDataflow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PowerBIDataflow
     */
    public static PowerBIDataflow appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a PowerBIDataflow, without replacing existing Atlan tags linked to the PowerBIDataflow.
     * Note: this operation must make two API calls — one to retrieve the PowerBIDataflow's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PowerBIDataflow
     * @param qualifiedName of the PowerBIDataflow
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PowerBIDataflow
     */
    public static PowerBIDataflow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBIDataflow) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a PowerBIDataflow.
     *
     * @param qualifiedName of the PowerBIDataflow
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PowerBIDataflow
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a PowerBIDataflow.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a PowerBIDataflow
     * @param qualifiedName of the PowerBIDataflow
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PowerBIDataflow
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class PowerBIDataflowBuilder<C extends PowerBIDataflow, B extends PowerBIDataflow.PowerBIDataflowBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIDataset> datasets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIDataflow> powerBIDataflowChildren;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIDataflow> powerBIDataflowParents;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBIDataflowRefreshScheduleFrequency;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBIDataflowRefreshScheduleTimeZone;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> powerBIDataflowRefreshScheduleTimes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBIFormatString;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean powerBIIsHidden;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> powerBIProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBITableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBITable> tables;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String webUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IPowerBIWorkspace workspace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workspaceQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            PowerBIDataflow.PowerBIDataflowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final PowerBIDataflow instance, final PowerBIDataflow.PowerBIDataflowBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.datasets(instance.datasets == null ? java.util.Collections.<IPowerBIDataset>emptySortedSet() : instance.datasets);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.powerBIDataflowChildren(instance.powerBIDataflowChildren == null ? java.util.Collections.<IPowerBIDataflow>emptySortedSet() : instance.powerBIDataflowChildren);
            b.powerBIDataflowParents(instance.powerBIDataflowParents == null ? java.util.Collections.<IPowerBIDataflow>emptySortedSet() : instance.powerBIDataflowParents);
            b.powerBIDataflowRefreshScheduleFrequency(instance.powerBIDataflowRefreshScheduleFrequency);
            b.powerBIDataflowRefreshScheduleTimeZone(instance.powerBIDataflowRefreshScheduleTimeZone);
            b.powerBIDataflowRefreshScheduleTimes(instance.powerBIDataflowRefreshScheduleTimes == null ? java.util.Collections.<String>emptySortedSet() : instance.powerBIDataflowRefreshScheduleTimes);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBIProcesses(instance.powerBIProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.powerBIProcesses);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
            b.tables(instance.tables == null ? java.util.Collections.<IPowerBITable>emptySortedSet() : instance.tables);
            b.webUrl(instance.webUrl);
            b.workspace(instance.workspace);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
        }

        /**
         * Fixed typeName for PowerBIDataflows.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataset(final IPowerBIDataset dataset) {
            if (this.datasets == null) this.datasets = new java.util.ArrayList<IPowerBIDataset>();
            this.datasets.add(dataset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasets(final java.util.Collection<? extends IPowerBIDataset> datasets) {
            if (datasets == null) {
                throw new java.lang.NullPointerException("datasets cannot be null");
            }
            if (this.datasets == null) this.datasets = new java.util.ArrayList<IPowerBIDataset>();
            this.datasets.addAll(datasets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDatasets() {
            if (this.datasets != null) this.datasets.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflowChild(final IPowerBIDataflow powerBIDataflowChild) {
            if (this.powerBIDataflowChildren == null) this.powerBIDataflowChildren = new java.util.ArrayList<IPowerBIDataflow>();
            this.powerBIDataflowChildren.add(powerBIDataflowChild);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflowChildren(final java.util.Collection<? extends IPowerBIDataflow> powerBIDataflowChildren) {
            if (powerBIDataflowChildren == null) {
                throw new java.lang.NullPointerException("powerBIDataflowChildren cannot be null");
            }
            if (this.powerBIDataflowChildren == null) this.powerBIDataflowChildren = new java.util.ArrayList<IPowerBIDataflow>();
            this.powerBIDataflowChildren.addAll(powerBIDataflowChildren);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPowerBIDataflowChildren() {
            if (this.powerBIDataflowChildren != null) this.powerBIDataflowChildren.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflowParent(final IPowerBIDataflow powerBIDataflowParent) {
            if (this.powerBIDataflowParents == null) this.powerBIDataflowParents = new java.util.ArrayList<IPowerBIDataflow>();
            this.powerBIDataflowParents.add(powerBIDataflowParent);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflowParents(final java.util.Collection<? extends IPowerBIDataflow> powerBIDataflowParents) {
            if (powerBIDataflowParents == null) {
                throw new java.lang.NullPointerException("powerBIDataflowParents cannot be null");
            }
            if (this.powerBIDataflowParents == null) this.powerBIDataflowParents = new java.util.ArrayList<IPowerBIDataflow>();
            this.powerBIDataflowParents.addAll(powerBIDataflowParents);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPowerBIDataflowParents() {
            if (this.powerBIDataflowParents != null) this.powerBIDataflowParents.clear();
            return self();
        }

        /**
         * Refresh Schedule frequency for a PowerBI Dataflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflowRefreshScheduleFrequency(final String powerBIDataflowRefreshScheduleFrequency) {
            this.powerBIDataflowRefreshScheduleFrequency = powerBIDataflowRefreshScheduleFrequency;
            return self();
        }

        /**
         * Time zone for the refresh schedule set for a PowerBI Dataflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflowRefreshScheduleTimeZone(final String powerBIDataflowRefreshScheduleTimeZone) {
            this.powerBIDataflowRefreshScheduleTimeZone = powerBIDataflowRefreshScheduleTimeZone;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflowRefreshScheduleTime(final String powerBIDataflowRefreshScheduleTime) {
            if (this.powerBIDataflowRefreshScheduleTimes == null) this.powerBIDataflowRefreshScheduleTimes = new java.util.ArrayList<String>();
            this.powerBIDataflowRefreshScheduleTimes.add(powerBIDataflowRefreshScheduleTime);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIDataflowRefreshScheduleTimes(final java.util.Collection<? extends String> powerBIDataflowRefreshScheduleTimes) {
            if (powerBIDataflowRefreshScheduleTimes == null) {
                throw new java.lang.NullPointerException("powerBIDataflowRefreshScheduleTimes cannot be null");
            }
            if (this.powerBIDataflowRefreshScheduleTimes == null) this.powerBIDataflowRefreshScheduleTimes = new java.util.ArrayList<String>();
            this.powerBIDataflowRefreshScheduleTimes.addAll(powerBIDataflowRefreshScheduleTimes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPowerBIDataflowRefreshScheduleTimes() {
            if (this.powerBIDataflowRefreshScheduleTimes != null) this.powerBIDataflowRefreshScheduleTimes.clear();
            return self();
        }

        /**
         * Endorsement status of this asset, in Power BI.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIEndorsement(final PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return self();
        }

        /**
         * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIFormatString(final String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return self();
        }

        /**
         * Whether this asset is hidden in Power BI (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIIsHidden(final Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIProcess(final ILineageProcess powerBIProcess) {
            if (this.powerBIProcesses == null) this.powerBIProcesses = new java.util.ArrayList<ILineageProcess>();
            this.powerBIProcesses.add(powerBIProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIProcesses(final java.util.Collection<? extends ILineageProcess> powerBIProcesses) {
            if (powerBIProcesses == null) {
                throw new java.lang.NullPointerException("powerBIProcesses cannot be null");
            }
            if (this.powerBIProcesses == null) this.powerBIProcesses = new java.util.ArrayList<ILineageProcess>();
            this.powerBIProcesses.addAll(powerBIProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPowerBIProcesses() {
            if (this.powerBIProcesses != null) this.powerBIProcesses.clear();
            return self();
        }

        /**
         * Unique name of the Power BI table in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBITableQualifiedName(final String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B table(final IPowerBITable table) {
            if (this.tables == null) this.tables = new java.util.ArrayList<IPowerBITable>();
            this.tables.add(table);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tables(final java.util.Collection<? extends IPowerBITable> tables) {
            if (tables == null) {
                throw new java.lang.NullPointerException("tables cannot be null");
            }
            if (this.tables == null) this.tables = new java.util.ArrayList<IPowerBITable>();
            this.tables.addAll(tables);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTables() {
            if (this.tables != null) this.tables.clear();
            return self();
        }

        /**
         * Deprecated. See 'sourceUrl' instead.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B webUrl(final String webUrl) {
            this.webUrl = webUrl;
            return self();
        }

        /**
         * Workspace in which this dataflow exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workspace(final IPowerBIWorkspace workspace) {
            this.workspace = workspace;
            return self();
        }

        /**
         * Unique name of the workspace in which this dataflow exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workspaceQualifiedName(final String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "PowerBIDataflow.PowerBIDataflowBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", datasets=" + this.datasets + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", powerBIDataflowChildren=" + this.powerBIDataflowChildren + ", powerBIDataflowParents=" + this.powerBIDataflowParents + ", powerBIDataflowRefreshScheduleFrequency=" + this.powerBIDataflowRefreshScheduleFrequency + ", powerBIDataflowRefreshScheduleTimeZone=" + this.powerBIDataflowRefreshScheduleTimeZone + ", powerBIDataflowRefreshScheduleTimes=" + this.powerBIDataflowRefreshScheduleTimes + ", powerBIEndorsement=" + this.powerBIEndorsement + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBIProcesses=" + this.powerBIProcesses + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ", tables=" + this.tables + ", webUrl=" + this.webUrl + ", workspace=" + this.workspace + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class PowerBIDataflowBuilderImpl extends PowerBIDataflow.PowerBIDataflowBuilder<PowerBIDataflow, PowerBIDataflow.PowerBIDataflowBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PowerBIDataflowBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected PowerBIDataflow.PowerBIDataflowBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PowerBIDataflow build() {
            return new PowerBIDataflow(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected PowerBIDataflow(final PowerBIDataflow.PowerBIDataflowBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = PowerBIDataflow.$default$typeName();
        java.util.SortedSet<IPowerBIDataset> datasets = new java.util.TreeSet<IPowerBIDataset>();
        if (b.datasets != null) datasets.addAll(b.datasets);
        datasets = java.util.Collections.unmodifiableSortedSet(datasets);
        this.datasets = datasets;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<IPowerBIDataflow> powerBIDataflowChildren = new java.util.TreeSet<IPowerBIDataflow>();
        if (b.powerBIDataflowChildren != null) powerBIDataflowChildren.addAll(b.powerBIDataflowChildren);
        powerBIDataflowChildren = java.util.Collections.unmodifiableSortedSet(powerBIDataflowChildren);
        this.powerBIDataflowChildren = powerBIDataflowChildren;
        java.util.SortedSet<IPowerBIDataflow> powerBIDataflowParents = new java.util.TreeSet<IPowerBIDataflow>();
        if (b.powerBIDataflowParents != null) powerBIDataflowParents.addAll(b.powerBIDataflowParents);
        powerBIDataflowParents = java.util.Collections.unmodifiableSortedSet(powerBIDataflowParents);
        this.powerBIDataflowParents = powerBIDataflowParents;
        this.powerBIDataflowRefreshScheduleFrequency = b.powerBIDataflowRefreshScheduleFrequency;
        this.powerBIDataflowRefreshScheduleTimeZone = b.powerBIDataflowRefreshScheduleTimeZone;
        java.util.SortedSet<String> powerBIDataflowRefreshScheduleTimes = new java.util.TreeSet<String>();
        if (b.powerBIDataflowRefreshScheduleTimes != null) powerBIDataflowRefreshScheduleTimes.addAll(b.powerBIDataflowRefreshScheduleTimes);
        powerBIDataflowRefreshScheduleTimes = java.util.Collections.unmodifiableSortedSet(powerBIDataflowRefreshScheduleTimes);
        this.powerBIDataflowRefreshScheduleTimes = powerBIDataflowRefreshScheduleTimes;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        java.util.SortedSet<ILineageProcess> powerBIProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.powerBIProcesses != null) powerBIProcesses.addAll(b.powerBIProcesses);
        powerBIProcesses = java.util.Collections.unmodifiableSortedSet(powerBIProcesses);
        this.powerBIProcesses = powerBIProcesses;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
        java.util.SortedSet<IPowerBITable> tables = new java.util.TreeSet<IPowerBITable>();
        if (b.tables != null) tables.addAll(b.tables);
        tables = java.util.Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        this.webUrl = b.webUrl;
        this.workspace = b.workspace;
        this.workspaceQualifiedName = b.workspaceQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static PowerBIDataflow.PowerBIDataflowBuilder<?, ?> _internal() {
        return new PowerBIDataflow.PowerBIDataflowBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PowerBIDataflow.PowerBIDataflowBuilder<?, ?> toBuilder() {
        return new PowerBIDataflow.PowerBIDataflowBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Datasets used by this dataflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIDataset> getDatasets() {
        return this.datasets;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Child Dataflows to this PowerBI Dataflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIDataflow> getPowerBIDataflowChildren() {
        return this.powerBIDataflowChildren;
    }

    /**
     * Parent Dataflows to this PowerBI Dataflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIDataflow> getPowerBIDataflowParents() {
        return this.powerBIDataflowParents;
    }

    /**
     * Refresh Schedule frequency for a PowerBI Dataflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBIDataflowRefreshScheduleFrequency() {
        return this.powerBIDataflowRefreshScheduleFrequency;
    }

    /**
     * Time zone for the refresh schedule set for a PowerBI Dataflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBIDataflowRefreshScheduleTimeZone() {
        return this.powerBIDataflowRefreshScheduleTimeZone;
    }

    /**
     * Time for the refresh schedule set for a PowerBI Dataflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPowerBIDataflowRefreshScheduleTimes() {
        return this.powerBIDataflowRefreshScheduleTimes;
    }

    /**
     * Endorsement status of this asset, in Power BI.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    /**
     * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    /**
     * Whether this asset is hidden in Power BI (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    /**
     * Lineage process that associates this PowerBI Dataflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getPowerBIProcesses() {
        return this.powerBIProcesses;
    }

    /**
     * Unique name of the Power BI table in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    /**
     * PowerBI Tables that are associated with this Dataflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBITable> getTables() {
        return this.tables;
    }

    /**
     * Deprecated. See 'sourceUrl' instead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    /**
     * Workspace in which this dataflow exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IPowerBIWorkspace getWorkspace() {
        return this.workspace;
    }

    /**
     * Unique name of the workspace in which this dataflow exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PowerBIDataflow)) return false;
        final PowerBIDataflow other = (PowerBIDataflow) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$powerBIIsHidden = this.getPowerBIIsHidden();
        final java.lang.Object other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !this$powerBIIsHidden.equals(other$powerBIIsHidden)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$datasets = this.getDatasets();
        final java.lang.Object other$datasets = other.getDatasets();
        if (this$datasets == null ? other$datasets != null : !this$datasets.equals(other$datasets)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$powerBIDataflowChildren = this.getPowerBIDataflowChildren();
        final java.lang.Object other$powerBIDataflowChildren = other.getPowerBIDataflowChildren();
        if (this$powerBIDataflowChildren == null ? other$powerBIDataflowChildren != null : !this$powerBIDataflowChildren.equals(other$powerBIDataflowChildren)) return false;
        final java.lang.Object this$powerBIDataflowParents = this.getPowerBIDataflowParents();
        final java.lang.Object other$powerBIDataflowParents = other.getPowerBIDataflowParents();
        if (this$powerBIDataflowParents == null ? other$powerBIDataflowParents != null : !this$powerBIDataflowParents.equals(other$powerBIDataflowParents)) return false;
        final java.lang.Object this$powerBIDataflowRefreshScheduleFrequency = this.getPowerBIDataflowRefreshScheduleFrequency();
        final java.lang.Object other$powerBIDataflowRefreshScheduleFrequency = other.getPowerBIDataflowRefreshScheduleFrequency();
        if (this$powerBIDataflowRefreshScheduleFrequency == null ? other$powerBIDataflowRefreshScheduleFrequency != null : !this$powerBIDataflowRefreshScheduleFrequency.equals(other$powerBIDataflowRefreshScheduleFrequency)) return false;
        final java.lang.Object this$powerBIDataflowRefreshScheduleTimeZone = this.getPowerBIDataflowRefreshScheduleTimeZone();
        final java.lang.Object other$powerBIDataflowRefreshScheduleTimeZone = other.getPowerBIDataflowRefreshScheduleTimeZone();
        if (this$powerBIDataflowRefreshScheduleTimeZone == null ? other$powerBIDataflowRefreshScheduleTimeZone != null : !this$powerBIDataflowRefreshScheduleTimeZone.equals(other$powerBIDataflowRefreshScheduleTimeZone)) return false;
        final java.lang.Object this$powerBIDataflowRefreshScheduleTimes = this.getPowerBIDataflowRefreshScheduleTimes();
        final java.lang.Object other$powerBIDataflowRefreshScheduleTimes = other.getPowerBIDataflowRefreshScheduleTimes();
        if (this$powerBIDataflowRefreshScheduleTimes == null ? other$powerBIDataflowRefreshScheduleTimes != null : !this$powerBIDataflowRefreshScheduleTimes.equals(other$powerBIDataflowRefreshScheduleTimes)) return false;
        final java.lang.Object this$powerBIEndorsement = this.getPowerBIEndorsement();
        final java.lang.Object other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) return false;
        final java.lang.Object this$powerBIFormatString = this.getPowerBIFormatString();
        final java.lang.Object other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) return false;
        final java.lang.Object this$powerBIProcesses = this.getPowerBIProcesses();
        final java.lang.Object other$powerBIProcesses = other.getPowerBIProcesses();
        if (this$powerBIProcesses == null ? other$powerBIProcesses != null : !this$powerBIProcesses.equals(other$powerBIProcesses)) return false;
        final java.lang.Object this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        final java.lang.Object other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        if (this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName)) return false;
        final java.lang.Object this$tables = this.getTables();
        final java.lang.Object other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) return false;
        final java.lang.Object this$webUrl = this.getWebUrl();
        final java.lang.Object other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) return false;
        final java.lang.Object this$workspace = this.getWorkspace();
        final java.lang.Object other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !this$workspace.equals(other$workspace)) return false;
        final java.lang.Object this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        final java.lang.Object other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PowerBIDataflow;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * PRIME + ($powerBIIsHidden == null ? 43 : $powerBIIsHidden.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $datasets = this.getDatasets();
        result = result * PRIME + ($datasets == null ? 43 : $datasets.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $powerBIDataflowChildren = this.getPowerBIDataflowChildren();
        result = result * PRIME + ($powerBIDataflowChildren == null ? 43 : $powerBIDataflowChildren.hashCode());
        final java.lang.Object $powerBIDataflowParents = this.getPowerBIDataflowParents();
        result = result * PRIME + ($powerBIDataflowParents == null ? 43 : $powerBIDataflowParents.hashCode());
        final java.lang.Object $powerBIDataflowRefreshScheduleFrequency = this.getPowerBIDataflowRefreshScheduleFrequency();
        result = result * PRIME + ($powerBIDataflowRefreshScheduleFrequency == null ? 43 : $powerBIDataflowRefreshScheduleFrequency.hashCode());
        final java.lang.Object $powerBIDataflowRefreshScheduleTimeZone = this.getPowerBIDataflowRefreshScheduleTimeZone();
        result = result * PRIME + ($powerBIDataflowRefreshScheduleTimeZone == null ? 43 : $powerBIDataflowRefreshScheduleTimeZone.hashCode());
        final java.lang.Object $powerBIDataflowRefreshScheduleTimes = this.getPowerBIDataflowRefreshScheduleTimes();
        result = result * PRIME + ($powerBIDataflowRefreshScheduleTimes == null ? 43 : $powerBIDataflowRefreshScheduleTimes.hashCode());
        final java.lang.Object $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * PRIME + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        final java.lang.Object $powerBIFormatString = this.getPowerBIFormatString();
        result = result * PRIME + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        final java.lang.Object $powerBIProcesses = this.getPowerBIProcesses();
        result = result * PRIME + ($powerBIProcesses == null ? 43 : $powerBIProcesses.hashCode());
        final java.lang.Object $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * PRIME + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        final java.lang.Object $tables = this.getTables();
        result = result * PRIME + ($tables == null ? 43 : $tables.hashCode());
        final java.lang.Object $webUrl = this.getWebUrl();
        result = result * PRIME + ($webUrl == null ? 43 : $webUrl.hashCode());
        final java.lang.Object $workspace = this.getWorkspace();
        result = result * PRIME + ($workspace == null ? 43 : $workspace.hashCode());
        final java.lang.Object $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * PRIME + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PowerBIDataflow(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", datasets=" + this.getDatasets() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", powerBIDataflowChildren=" + this.getPowerBIDataflowChildren() + ", powerBIDataflowParents=" + this.getPowerBIDataflowParents() + ", powerBIDataflowRefreshScheduleFrequency=" + this.getPowerBIDataflowRefreshScheduleFrequency() + ", powerBIDataflowRefreshScheduleTimeZone=" + this.getPowerBIDataflowRefreshScheduleTimeZone() + ", powerBIDataflowRefreshScheduleTimes=" + this.getPowerBIDataflowRefreshScheduleTimes() + ", powerBIEndorsement=" + this.getPowerBIEndorsement() + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBIProcesses=" + this.getPowerBIProcesses() + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ", tables=" + this.getTables() + ", webUrl=" + this.getWebUrl() + ", workspace=" + this.getWorkspace() + ", workspaceQualifiedName=" + this.getWorkspaceQualifiedName() + ")";
    }

    /**
     * Fixed typeName for PowerBIDataflows.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
