// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Power BI report in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class PowerBIReport extends Asset implements IPowerBIReport, IPowerBI, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(PowerBIReport.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIReport";
    /**
     * Fixed typeName for PowerBIReports.
     */
    String typeName;
    /**
     * Dataset from which this report was built.
     */
    @Attribute
    IPowerBIDataset dataset;
    /**
     * Unique name of the dataset used to build this report.
     */
    @Attribute
    String datasetQualifiedName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Number of pages in this report.
     */
    @Attribute
    Long pageCount;
    /**
     * Pages that exist within this report.
     */
    @Attribute
    SortedSet<IPowerBIPage> pages;
    /**
     * Endorsement status of this asset, in Power BI.
     */
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    /**
     * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
     */
    @Attribute
    String powerBIFormatString;
    /**
     * Whether this asset is hidden in Power BI (true) or not (false).
     */
    @Attribute
    Boolean powerBIIsHidden;
    /**
     * Unique name of the Power BI table in which this asset exists.
     */
    @Attribute
    String powerBITableQualifiedName;
    /**
     * Tiles that exist within this report.
     */
    @Attribute
    SortedSet<IPowerBITile> tiles;
    /**
     * Deprecated. See 'sourceUrl' instead.
     */
    @Attribute
    String webUrl;
    /**
     * Workspace in which this report exists.
     */
    @Attribute
    IPowerBIWorkspace workspace;
    /**
     * Unique name of the workspace in which this report exists.
     */
    @Attribute
    String workspaceQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a PowerBIReport, from a potentially
     * more-complete PowerBIReport object.
     *
     * @return the minimal object necessary to relate to the PowerBIReport
     * @throws InvalidRequestException if any of the minimal set of required properties for a PowerBIReport relationship are not found in the initial object
     */
    @Override
    public PowerBIReport trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all PowerBIReport assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PowerBIReport assets will be included.
     *
     * @return a fluent search that includes all PowerBIReport assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all PowerBIReport assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PowerBIReport assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all PowerBIReport assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all PowerBIReport assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) PowerBIReports will be included
     * @return a fluent search that includes all PowerBIReport assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all PowerBIReport assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) PowerBIReports will be included
     * @return a fluent search that includes all PowerBIReport assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a PowerBIReport by GUID. Use this to create a relationship to this PowerBIReport,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the PowerBIReport to reference
     * @return reference to a PowerBIReport that can be used for defining a relationship to a PowerBIReport
     */
    public static PowerBIReport refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PowerBIReport by GUID. Use this to create a relationship to this PowerBIReport,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the PowerBIReport to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PowerBIReport that can be used for defining a relationship to a PowerBIReport
     */
    public static PowerBIReport refByGuid(String guid, Reference.SaveSemantic semantic) {
        return PowerBIReport._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a PowerBIReport by qualifiedName. Use this to create a relationship to this PowerBIReport,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the PowerBIReport to reference
     * @return reference to a PowerBIReport that can be used for defining a relationship to a PowerBIReport
     */
    public static PowerBIReport refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PowerBIReport by qualifiedName. Use this to create a relationship to this PowerBIReport,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the PowerBIReport to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PowerBIReport that can be used for defining a relationship to a PowerBIReport
     */
    public static PowerBIReport refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return PowerBIReport._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a PowerBIReport by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the PowerBIReport to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PowerBIReport, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIReport does not exist or the provided GUID is not a PowerBIReport
     */
    @JsonIgnore
    public static PowerBIReport get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a PowerBIReport by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PowerBIReport to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PowerBIReport, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIReport does not exist or the provided GUID is not a PowerBIReport
     */
    @JsonIgnore
    public static PowerBIReport get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a PowerBIReport by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PowerBIReport to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full PowerBIReport, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIReport does not exist or the provided GUID is not a PowerBIReport
     */
    @JsonIgnore
    public static PowerBIReport get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof PowerBIReport) {
                return (PowerBIReport) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof PowerBIReport) {
                return (PowerBIReport) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) PowerBIReport to active.
     *
     * @param qualifiedName for the PowerBIReport
     * @return true if the PowerBIReport is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) PowerBIReport to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the PowerBIReport
     * @return true if the PowerBIReport is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the minimal request necessary to update the PowerBIReport, as a builder
     */
    public static PowerBIReportBuilder<?, ?> updater(String qualifiedName, String name) {
        return PowerBIReport._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a PowerBIReport, from a potentially
     * more-complete PowerBIReport object.
     *
     * @return the minimal object necessary to update the PowerBIReport, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for PowerBIReport are not found in the initial object
     */
    @Override
    public PowerBIReportBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a PowerBIReport.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a PowerBIReport.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a PowerBIReport.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PowerBIReport's owners
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PowerBIReport, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a PowerBIReport.
     *
     * @param client connectivity to the Atlan tenant on which to update the PowerBIReport's certificate
     * @param qualifiedName of the PowerBIReport
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PowerBIReport, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIReport) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a PowerBIReport.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PowerBIReport's certificate
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a PowerBIReport.
     *
     * @param client connectivity to the Atlan tenant on which to update the PowerBIReport's announcement
     * @param qualifiedName of the PowerBIReport
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIReport) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a PowerBIReport.
     *
     * @param client connectivity to the Atlan client from which to remove the PowerBIReport's announcement
     * @param qualifiedName of the PowerBIReport
     * @param name of the PowerBIReport
     * @return the updated PowerBIReport, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIReport) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the PowerBIReport.
     *
     * @param qualifiedName for the PowerBIReport
     * @param name human-readable name of the PowerBIReport
     * @param terms the list of terms to replace on the PowerBIReport, or null to remove all terms from the PowerBIReport
     * @return the PowerBIReport that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the PowerBIReport.
     *
     * @param client connectivity to the Atlan tenant on which to replace the PowerBIReport's assigned terms
     * @param qualifiedName for the PowerBIReport
     * @param name human-readable name of the PowerBIReport
     * @param terms the list of terms to replace on the PowerBIReport, or null to remove all terms from the PowerBIReport
     * @return the PowerBIReport that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIReport) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the PowerBIReport, without replacing existing terms linked to the PowerBIReport.
     * Note: this operation must make two API calls — one to retrieve the PowerBIReport's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the PowerBIReport
     * @param terms the list of terms to append to the PowerBIReport
     * @return the PowerBIReport that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the PowerBIReport, without replacing existing terms linked to the PowerBIReport.
     * Note: this operation must make two API calls — one to retrieve the PowerBIReport's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the PowerBIReport
     * @param qualifiedName for the PowerBIReport
     * @param terms the list of terms to append to the PowerBIReport
     * @return the PowerBIReport that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIReport) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a PowerBIReport, without replacing all existing terms linked to the PowerBIReport.
     * Note: this operation must make two API calls — one to retrieve the PowerBIReport's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the PowerBIReport
     * @param terms the list of terms to remove from the PowerBIReport, which must be referenced by GUID
     * @return the PowerBIReport that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a PowerBIReport, without replacing all existing terms linked to the PowerBIReport.
     * Note: this operation must make two API calls — one to retrieve the PowerBIReport's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the PowerBIReport
     * @param qualifiedName for the PowerBIReport
     * @param terms the list of terms to remove from the PowerBIReport, which must be referenced by GUID
     * @return the PowerBIReport that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIReport removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIReport) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a PowerBIReport, without replacing existing Atlan tags linked to the PowerBIReport.
     * Note: this operation must make two API calls — one to retrieve the PowerBIReport's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PowerBIReport
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PowerBIReport
     */
    public static PowerBIReport appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PowerBIReport, without replacing existing Atlan tags linked to the PowerBIReport.
     * Note: this operation must make two API calls — one to retrieve the PowerBIReport's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PowerBIReport
     * @param qualifiedName of the PowerBIReport
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PowerBIReport
     */
    public static PowerBIReport appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBIReport) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PowerBIReport, without replacing existing Atlan tags linked to the PowerBIReport.
     * Note: this operation must make two API calls — one to retrieve the PowerBIReport's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PowerBIReport
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PowerBIReport
     */
    public static PowerBIReport appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a PowerBIReport, without replacing existing Atlan tags linked to the PowerBIReport.
     * Note: this operation must make two API calls — one to retrieve the PowerBIReport's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PowerBIReport
     * @param qualifiedName of the PowerBIReport
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PowerBIReport
     */
    public static PowerBIReport appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBIReport) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a PowerBIReport.
     *
     * @param qualifiedName of the PowerBIReport
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PowerBIReport
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a PowerBIReport.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a PowerBIReport
     * @param qualifiedName of the PowerBIReport
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PowerBIReport
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class PowerBIReportBuilder<C extends PowerBIReport, B extends PowerBIReport.PowerBIReportBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IPowerBIDataset dataset;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String datasetQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long pageCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIPage> pages;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBIFormatString;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean powerBIIsHidden;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBITableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBITile> tiles;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String webUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IPowerBIWorkspace workspace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workspaceQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            PowerBIReport.PowerBIReportBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final PowerBIReport instance, final PowerBIReport.PowerBIReportBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataset(instance.dataset);
            b.datasetQualifiedName(instance.datasetQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.pageCount(instance.pageCount);
            b.pages(instance.pages == null ? java.util.Collections.<IPowerBIPage>emptySortedSet() : instance.pages);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
            b.tiles(instance.tiles == null ? java.util.Collections.<IPowerBITile>emptySortedSet() : instance.tiles);
            b.webUrl(instance.webUrl);
            b.workspace(instance.workspace);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
        }

        /**
         * Fixed typeName for PowerBIReports.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Dataset from which this report was built.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataset(final IPowerBIDataset dataset) {
            this.dataset = dataset;
            return self();
        }

        /**
         * Unique name of the dataset used to build this report.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasetQualifiedName(final String datasetQualifiedName) {
            this.datasetQualifiedName = datasetQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Number of pages in this report.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pageCount(final Long pageCount) {
            this.pageCount = pageCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B page(final IPowerBIPage page) {
            if (this.pages == null) this.pages = new java.util.ArrayList<IPowerBIPage>();
            this.pages.add(page);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B pages(final java.util.Collection<? extends IPowerBIPage> pages) {
            if (pages == null) {
                throw new java.lang.NullPointerException("pages cannot be null");
            }
            if (this.pages == null) this.pages = new java.util.ArrayList<IPowerBIPage>();
            this.pages.addAll(pages);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPages() {
            if (this.pages != null) this.pages.clear();
            return self();
        }

        /**
         * Endorsement status of this asset, in Power BI.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIEndorsement(final PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return self();
        }

        /**
         * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIFormatString(final String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return self();
        }

        /**
         * Whether this asset is hidden in Power BI (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIIsHidden(final Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return self();
        }

        /**
         * Unique name of the Power BI table in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBITableQualifiedName(final String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tile(final IPowerBITile tile) {
            if (this.tiles == null) this.tiles = new java.util.ArrayList<IPowerBITile>();
            this.tiles.add(tile);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tiles(final java.util.Collection<? extends IPowerBITile> tiles) {
            if (tiles == null) {
                throw new java.lang.NullPointerException("tiles cannot be null");
            }
            if (this.tiles == null) this.tiles = new java.util.ArrayList<IPowerBITile>();
            this.tiles.addAll(tiles);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTiles() {
            if (this.tiles != null) this.tiles.clear();
            return self();
        }

        /**
         * Deprecated. See 'sourceUrl' instead.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B webUrl(final String webUrl) {
            this.webUrl = webUrl;
            return self();
        }

        /**
         * Workspace in which this report exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workspace(final IPowerBIWorkspace workspace) {
            this.workspace = workspace;
            return self();
        }

        /**
         * Unique name of the workspace in which this report exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workspaceQualifiedName(final String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "PowerBIReport.PowerBIReportBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataset=" + this.dataset + ", datasetQualifiedName=" + this.datasetQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", pageCount=" + this.pageCount + ", pages=" + this.pages + ", powerBIEndorsement=" + this.powerBIEndorsement + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ", tiles=" + this.tiles + ", webUrl=" + this.webUrl + ", workspace=" + this.workspace + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class PowerBIReportBuilderImpl extends PowerBIReport.PowerBIReportBuilder<PowerBIReport, PowerBIReport.PowerBIReportBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PowerBIReportBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected PowerBIReport.PowerBIReportBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PowerBIReport build() {
            return new PowerBIReport(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected PowerBIReport(final PowerBIReport.PowerBIReportBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = PowerBIReport.$default$typeName();
        this.dataset = b.dataset;
        this.datasetQualifiedName = b.datasetQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.pageCount = b.pageCount;
        java.util.SortedSet<IPowerBIPage> pages = new java.util.TreeSet<IPowerBIPage>();
        if (b.pages != null) pages.addAll(b.pages);
        pages = java.util.Collections.unmodifiableSortedSet(pages);
        this.pages = pages;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
        java.util.SortedSet<IPowerBITile> tiles = new java.util.TreeSet<IPowerBITile>();
        if (b.tiles != null) tiles.addAll(b.tiles);
        tiles = java.util.Collections.unmodifiableSortedSet(tiles);
        this.tiles = tiles;
        this.webUrl = b.webUrl;
        this.workspace = b.workspace;
        this.workspaceQualifiedName = b.workspaceQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static PowerBIReport.PowerBIReportBuilder<?, ?> _internal() {
        return new PowerBIReport.PowerBIReportBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PowerBIReport.PowerBIReportBuilder<?, ?> toBuilder() {
        return new PowerBIReport.PowerBIReportBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Dataset from which this report was built.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IPowerBIDataset getDataset() {
        return this.dataset;
    }

    /**
     * Unique name of the dataset used to build this report.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatasetQualifiedName() {
        return this.datasetQualifiedName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Number of pages in this report.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPageCount() {
        return this.pageCount;
    }

    /**
     * Pages that exist within this report.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIPage> getPages() {
        return this.pages;
    }

    /**
     * Endorsement status of this asset, in Power BI.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    /**
     * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    /**
     * Whether this asset is hidden in Power BI (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    /**
     * Unique name of the Power BI table in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    /**
     * Tiles that exist within this report.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBITile> getTiles() {
        return this.tiles;
    }

    /**
     * Deprecated. See 'sourceUrl' instead.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    /**
     * Workspace in which this report exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IPowerBIWorkspace getWorkspace() {
        return this.workspace;
    }

    /**
     * Unique name of the workspace in which this report exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PowerBIReport)) return false;
        final PowerBIReport other = (PowerBIReport) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$pageCount = this.getPageCount();
        final java.lang.Object other$pageCount = other.getPageCount();
        if (this$pageCount == null ? other$pageCount != null : !this$pageCount.equals(other$pageCount)) return false;
        final java.lang.Object this$powerBIIsHidden = this.getPowerBIIsHidden();
        final java.lang.Object other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !this$powerBIIsHidden.equals(other$powerBIIsHidden)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dataset = this.getDataset();
        final java.lang.Object other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) return false;
        final java.lang.Object this$datasetQualifiedName = this.getDatasetQualifiedName();
        final java.lang.Object other$datasetQualifiedName = other.getDatasetQualifiedName();
        if (this$datasetQualifiedName == null ? other$datasetQualifiedName != null : !this$datasetQualifiedName.equals(other$datasetQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$pages = this.getPages();
        final java.lang.Object other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !this$pages.equals(other$pages)) return false;
        final java.lang.Object this$powerBIEndorsement = this.getPowerBIEndorsement();
        final java.lang.Object other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) return false;
        final java.lang.Object this$powerBIFormatString = this.getPowerBIFormatString();
        final java.lang.Object other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) return false;
        final java.lang.Object this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        final java.lang.Object other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        if (this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName)) return false;
        final java.lang.Object this$tiles = this.getTiles();
        final java.lang.Object other$tiles = other.getTiles();
        if (this$tiles == null ? other$tiles != null : !this$tiles.equals(other$tiles)) return false;
        final java.lang.Object this$webUrl = this.getWebUrl();
        final java.lang.Object other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) return false;
        final java.lang.Object this$workspace = this.getWorkspace();
        final java.lang.Object other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !this$workspace.equals(other$workspace)) return false;
        final java.lang.Object this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        final java.lang.Object other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PowerBIReport;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $pageCount = this.getPageCount();
        result = result * PRIME + ($pageCount == null ? 43 : $pageCount.hashCode());
        final java.lang.Object $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * PRIME + ($powerBIIsHidden == null ? 43 : $powerBIIsHidden.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dataset = this.getDataset();
        result = result * PRIME + ($dataset == null ? 43 : $dataset.hashCode());
        final java.lang.Object $datasetQualifiedName = this.getDatasetQualifiedName();
        result = result * PRIME + ($datasetQualifiedName == null ? 43 : $datasetQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $pages = this.getPages();
        result = result * PRIME + ($pages == null ? 43 : $pages.hashCode());
        final java.lang.Object $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * PRIME + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        final java.lang.Object $powerBIFormatString = this.getPowerBIFormatString();
        result = result * PRIME + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        final java.lang.Object $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * PRIME + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        final java.lang.Object $tiles = this.getTiles();
        result = result * PRIME + ($tiles == null ? 43 : $tiles.hashCode());
        final java.lang.Object $webUrl = this.getWebUrl();
        result = result * PRIME + ($webUrl == null ? 43 : $webUrl.hashCode());
        final java.lang.Object $workspace = this.getWorkspace();
        result = result * PRIME + ($workspace == null ? 43 : $workspace.hashCode());
        final java.lang.Object $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * PRIME + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PowerBIReport(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dataset=" + this.getDataset() + ", datasetQualifiedName=" + this.getDatasetQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", pageCount=" + this.getPageCount() + ", pages=" + this.getPages() + ", powerBIEndorsement=" + this.getPowerBIEndorsement() + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ", tiles=" + this.getTiles() + ", webUrl=" + this.getWebUrl() + ", workspace=" + this.getWorkspace() + ", workspaceQualifiedName=" + this.getWorkspaceQualifiedName() + ")";
    }

    /**
     * Fixed typeName for PowerBIReports.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
