// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Power BI table in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class PowerBITable extends Asset implements IPowerBITable, IPowerBI, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(PowerBITable.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBITable";
    /**
     * Fixed typeName for PowerBITables.
     */
    String typeName;
    /**
     * Columns that exist within this table.
     */
    @Attribute
    SortedSet<IPowerBIColumn> columns;
    /**
     * List of qualified names of associated Power BI Dataflows.
     */
    @Attribute
    SortedSet<String> dataflowQualifiedNames;
    /**
     * PowerBI Dataflow that is associated with this PowerBI Table.
     */
    @Attribute
    SortedSet<IPowerBIDataflow> dataflows;
    /**
     * Dataset in which this table exists.
     */
    @Attribute
    IPowerBIDataset dataset;
    /**
     * Unique name of the dataset in which this table exists.
     */
    @Attribute
    String datasetQualifiedName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Measures that exist within this table.
     */
    @Attribute
    SortedSet<IPowerBIMeasure> measures;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Endorsement status of this asset, in Power BI.
     */
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    /**
     * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
     */
    @Attribute
    String powerBIFormatString;
    /**
     * Whether this asset is hidden in Power BI (true) or not (false).
     */
    @Attribute
    Boolean powerBIIsHidden;
    /**
     * Number of columns in this table.
     */
    @Attribute
    Long powerBITableColumnCount;
    /**
     * Number of measures in this table.
     */
    @Attribute
    Long powerBITableMeasureCount;
    /**
     * Unique name of the Power BI table in which this asset exists.
     */
    @Attribute
    String powerBITableQualifiedName;
    /**
     * Power Query M expressions for the table.
     */
    @Attribute
    SortedSet<String> powerBITableSourceExpressions;
    /**
     * Unique name of the workspace in which this table exists.
     */
    @Attribute
    String workspaceQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a PowerBITable, from a potentially
     * more-complete PowerBITable object.
     *
     * @return the minimal object necessary to relate to the PowerBITable
     * @throws InvalidRequestException if any of the minimal set of required properties for a PowerBITable relationship are not found in the initial object
     */
    @Override
    public PowerBITable trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all PowerBITable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PowerBITable assets will be included.
     *
     * @return a fluent search that includes all PowerBITable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all PowerBITable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PowerBITable assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all PowerBITable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all PowerBITable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) PowerBITables will be included
     * @return a fluent search that includes all PowerBITable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all PowerBITable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) PowerBITables will be included
     * @return a fluent search that includes all PowerBITable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a PowerBITable by GUID. Use this to create a relationship to this PowerBITable,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the PowerBITable to reference
     * @return reference to a PowerBITable that can be used for defining a relationship to a PowerBITable
     */
    public static PowerBITable refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PowerBITable by GUID. Use this to create a relationship to this PowerBITable,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the PowerBITable to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PowerBITable that can be used for defining a relationship to a PowerBITable
     */
    public static PowerBITable refByGuid(String guid, Reference.SaveSemantic semantic) {
        return PowerBITable._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a PowerBITable by qualifiedName. Use this to create a relationship to this PowerBITable,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the PowerBITable to reference
     * @return reference to a PowerBITable that can be used for defining a relationship to a PowerBITable
     */
    public static PowerBITable refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PowerBITable by qualifiedName. Use this to create a relationship to this PowerBITable,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the PowerBITable to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PowerBITable that can be used for defining a relationship to a PowerBITable
     */
    public static PowerBITable refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return PowerBITable._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a PowerBITable by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the PowerBITable to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PowerBITable, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBITable does not exist or the provided GUID is not a PowerBITable
     */
    @JsonIgnore
    public static PowerBITable get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a PowerBITable by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PowerBITable to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PowerBITable, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBITable does not exist or the provided GUID is not a PowerBITable
     */
    @JsonIgnore
    public static PowerBITable get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a PowerBITable by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PowerBITable to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full PowerBITable, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBITable does not exist or the provided GUID is not a PowerBITable
     */
    @JsonIgnore
    public static PowerBITable get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof PowerBITable) {
                return (PowerBITable) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof PowerBITable) {
                return (PowerBITable) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) PowerBITable to active.
     *
     * @param qualifiedName for the PowerBITable
     * @return true if the PowerBITable is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) PowerBITable to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the PowerBITable
     * @return true if the PowerBITable is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the minimal request necessary to update the PowerBITable, as a builder
     */
    public static PowerBITableBuilder<?, ?> updater(String qualifiedName, String name) {
        return PowerBITable._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a PowerBITable, from a potentially
     * more-complete PowerBITable object.
     *
     * @return the minimal object necessary to update the PowerBITable, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for PowerBITable are not found in the initial object
     */
    @Override
    public PowerBITableBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a PowerBITable.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a PowerBITable.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a PowerBITable.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PowerBITable's owners
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PowerBITable, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a PowerBITable.
     *
     * @param client connectivity to the Atlan tenant on which to update the PowerBITable's certificate
     * @param qualifiedName of the PowerBITable
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PowerBITable, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBITable) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a PowerBITable.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PowerBITable's certificate
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a PowerBITable.
     *
     * @param client connectivity to the Atlan tenant on which to update the PowerBITable's announcement
     * @param qualifiedName of the PowerBITable
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBITable) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a PowerBITable.
     *
     * @param client connectivity to the Atlan client from which to remove the PowerBITable's announcement
     * @param qualifiedName of the PowerBITable
     * @param name of the PowerBITable
     * @return the updated PowerBITable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBITable) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the PowerBITable.
     *
     * @param qualifiedName for the PowerBITable
     * @param name human-readable name of the PowerBITable
     * @param terms the list of terms to replace on the PowerBITable, or null to remove all terms from the PowerBITable
     * @return the PowerBITable that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBITable replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the PowerBITable.
     *
     * @param client connectivity to the Atlan tenant on which to replace the PowerBITable's assigned terms
     * @param qualifiedName for the PowerBITable
     * @param name human-readable name of the PowerBITable
     * @param terms the list of terms to replace on the PowerBITable, or null to remove all terms from the PowerBITable
     * @return the PowerBITable that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBITable replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBITable) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the PowerBITable, without replacing existing terms linked to the PowerBITable.
     * Note: this operation must make two API calls — one to retrieve the PowerBITable's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the PowerBITable
     * @param terms the list of terms to append to the PowerBITable
     * @return the PowerBITable that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBITable appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the PowerBITable, without replacing existing terms linked to the PowerBITable.
     * Note: this operation must make two API calls — one to retrieve the PowerBITable's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the PowerBITable
     * @param qualifiedName for the PowerBITable
     * @param terms the list of terms to append to the PowerBITable
     * @return the PowerBITable that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBITable appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBITable) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a PowerBITable, without replacing all existing terms linked to the PowerBITable.
     * Note: this operation must make two API calls — one to retrieve the PowerBITable's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the PowerBITable
     * @param terms the list of terms to remove from the PowerBITable, which must be referenced by GUID
     * @return the PowerBITable that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a PowerBITable, without replacing all existing terms linked to the PowerBITable.
     * Note: this operation must make two API calls — one to retrieve the PowerBITable's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the PowerBITable
     * @param qualifiedName for the PowerBITable
     * @param terms the list of terms to remove from the PowerBITable, which must be referenced by GUID
     * @return the PowerBITable that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBITable removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBITable) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a PowerBITable, without replacing existing Atlan tags linked to the PowerBITable.
     * Note: this operation must make two API calls — one to retrieve the PowerBITable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PowerBITable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PowerBITable
     */
    public static PowerBITable appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PowerBITable, without replacing existing Atlan tags linked to the PowerBITable.
     * Note: this operation must make two API calls — one to retrieve the PowerBITable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PowerBITable
     * @param qualifiedName of the PowerBITable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PowerBITable
     */
    public static PowerBITable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBITable) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PowerBITable, without replacing existing Atlan tags linked to the PowerBITable.
     * Note: this operation must make two API calls — one to retrieve the PowerBITable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PowerBITable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PowerBITable
     */
    public static PowerBITable appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a PowerBITable, without replacing existing Atlan tags linked to the PowerBITable.
     * Note: this operation must make two API calls — one to retrieve the PowerBITable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PowerBITable
     * @param qualifiedName of the PowerBITable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PowerBITable
     */
    public static PowerBITable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBITable) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a PowerBITable.
     *
     * @param qualifiedName of the PowerBITable
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PowerBITable
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a PowerBITable.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a PowerBITable
     * @param qualifiedName of the PowerBITable
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PowerBITable
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class PowerBITableBuilder<C extends PowerBITable, B extends PowerBITable.PowerBITableBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIColumn> columns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> dataflowQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIDataflow> dataflows;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IPowerBIDataset dataset;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String datasetQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIMeasure> measures;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBIFormatString;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean powerBIIsHidden;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long powerBITableColumnCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long powerBITableMeasureCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBITableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> powerBITableSourceExpressions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String workspaceQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            PowerBITable.PowerBITableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final PowerBITable instance, final PowerBITable.PowerBITableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.columns(instance.columns == null ? java.util.Collections.<IPowerBIColumn>emptySortedSet() : instance.columns);
            b.dataflowQualifiedNames(instance.dataflowQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.dataflowQualifiedNames);
            b.dataflows(instance.dataflows == null ? java.util.Collections.<IPowerBIDataflow>emptySortedSet() : instance.dataflows);
            b.dataset(instance.dataset);
            b.datasetQualifiedName(instance.datasetQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.measures(instance.measures == null ? java.util.Collections.<IPowerBIMeasure>emptySortedSet() : instance.measures);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBITableColumnCount(instance.powerBITableColumnCount);
            b.powerBITableMeasureCount(instance.powerBITableMeasureCount);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
            b.powerBITableSourceExpressions(instance.powerBITableSourceExpressions == null ? java.util.Collections.<String>emptySortedSet() : instance.powerBITableSourceExpressions);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
        }

        /**
         * Fixed typeName for PowerBITables.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B column(final IPowerBIColumn column) {
            if (this.columns == null) this.columns = new java.util.ArrayList<IPowerBIColumn>();
            this.columns.add(column);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B columns(final java.util.Collection<? extends IPowerBIColumn> columns) {
            if (columns == null) {
                throw new java.lang.NullPointerException("columns cannot be null");
            }
            if (this.columns == null) this.columns = new java.util.ArrayList<IPowerBIColumn>();
            this.columns.addAll(columns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearColumns() {
            if (this.columns != null) this.columns.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataflowQualifiedName(final String dataflowQualifiedName) {
            if (this.dataflowQualifiedNames == null) this.dataflowQualifiedNames = new java.util.ArrayList<String>();
            this.dataflowQualifiedNames.add(dataflowQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataflowQualifiedNames(final java.util.Collection<? extends String> dataflowQualifiedNames) {
            if (dataflowQualifiedNames == null) {
                throw new java.lang.NullPointerException("dataflowQualifiedNames cannot be null");
            }
            if (this.dataflowQualifiedNames == null) this.dataflowQualifiedNames = new java.util.ArrayList<String>();
            this.dataflowQualifiedNames.addAll(dataflowQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDataflowQualifiedNames() {
            if (this.dataflowQualifiedNames != null) this.dataflowQualifiedNames.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataflow(final IPowerBIDataflow dataflow) {
            if (this.dataflows == null) this.dataflows = new java.util.ArrayList<IPowerBIDataflow>();
            this.dataflows.add(dataflow);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataflows(final java.util.Collection<? extends IPowerBIDataflow> dataflows) {
            if (dataflows == null) {
                throw new java.lang.NullPointerException("dataflows cannot be null");
            }
            if (this.dataflows == null) this.dataflows = new java.util.ArrayList<IPowerBIDataflow>();
            this.dataflows.addAll(dataflows);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDataflows() {
            if (this.dataflows != null) this.dataflows.clear();
            return self();
        }

        /**
         * Dataset in which this table exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataset(final IPowerBIDataset dataset) {
            this.dataset = dataset;
            return self();
        }

        /**
         * Unique name of the dataset in which this table exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasetQualifiedName(final String datasetQualifiedName) {
            this.datasetQualifiedName = datasetQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B measure(final IPowerBIMeasure measure) {
            if (this.measures == null) this.measures = new java.util.ArrayList<IPowerBIMeasure>();
            this.measures.add(measure);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B measures(final java.util.Collection<? extends IPowerBIMeasure> measures) {
            if (measures == null) {
                throw new java.lang.NullPointerException("measures cannot be null");
            }
            if (this.measures == null) this.measures = new java.util.ArrayList<IPowerBIMeasure>();
            this.measures.addAll(measures);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMeasures() {
            if (this.measures != null) this.measures.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Endorsement status of this asset, in Power BI.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIEndorsement(final PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return self();
        }

        /**
         * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIFormatString(final String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return self();
        }

        /**
         * Whether this asset is hidden in Power BI (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIIsHidden(final Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return self();
        }

        /**
         * Number of columns in this table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBITableColumnCount(final Long powerBITableColumnCount) {
            this.powerBITableColumnCount = powerBITableColumnCount;
            return self();
        }

        /**
         * Number of measures in this table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBITableMeasureCount(final Long powerBITableMeasureCount) {
            this.powerBITableMeasureCount = powerBITableMeasureCount;
            return self();
        }

        /**
         * Unique name of the Power BI table in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBITableQualifiedName(final String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBITableSourceExpression(final String powerBITableSourceExpression) {
            if (this.powerBITableSourceExpressions == null) this.powerBITableSourceExpressions = new java.util.ArrayList<String>();
            this.powerBITableSourceExpressions.add(powerBITableSourceExpression);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBITableSourceExpressions(final java.util.Collection<? extends String> powerBITableSourceExpressions) {
            if (powerBITableSourceExpressions == null) {
                throw new java.lang.NullPointerException("powerBITableSourceExpressions cannot be null");
            }
            if (this.powerBITableSourceExpressions == null) this.powerBITableSourceExpressions = new java.util.ArrayList<String>();
            this.powerBITableSourceExpressions.addAll(powerBITableSourceExpressions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPowerBITableSourceExpressions() {
            if (this.powerBITableSourceExpressions != null) this.powerBITableSourceExpressions.clear();
            return self();
        }

        /**
         * Unique name of the workspace in which this table exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B workspaceQualifiedName(final String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "PowerBITable.PowerBITableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", columns=" + this.columns + ", dataflowQualifiedNames=" + this.dataflowQualifiedNames + ", dataflows=" + this.dataflows + ", dataset=" + this.dataset + ", datasetQualifiedName=" + this.datasetQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", measures=" + this.measures + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", powerBIEndorsement=" + this.powerBIEndorsement + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBITableColumnCount=" + this.powerBITableColumnCount + ", powerBITableMeasureCount=" + this.powerBITableMeasureCount + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ", powerBITableSourceExpressions=" + this.powerBITableSourceExpressions + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class PowerBITableBuilderImpl extends PowerBITable.PowerBITableBuilder<PowerBITable, PowerBITable.PowerBITableBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PowerBITableBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected PowerBITable.PowerBITableBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PowerBITable build() {
            return new PowerBITable(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected PowerBITable(final PowerBITable.PowerBITableBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = PowerBITable.$default$typeName();
        java.util.SortedSet<IPowerBIColumn> columns = new java.util.TreeSet<IPowerBIColumn>();
        if (b.columns != null) columns.addAll(b.columns);
        columns = java.util.Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        java.util.SortedSet<String> dataflowQualifiedNames = new java.util.TreeSet<String>();
        if (b.dataflowQualifiedNames != null) dataflowQualifiedNames.addAll(b.dataflowQualifiedNames);
        dataflowQualifiedNames = java.util.Collections.unmodifiableSortedSet(dataflowQualifiedNames);
        this.dataflowQualifiedNames = dataflowQualifiedNames;
        java.util.SortedSet<IPowerBIDataflow> dataflows = new java.util.TreeSet<IPowerBIDataflow>();
        if (b.dataflows != null) dataflows.addAll(b.dataflows);
        dataflows = java.util.Collections.unmodifiableSortedSet(dataflows);
        this.dataflows = dataflows;
        this.dataset = b.dataset;
        this.datasetQualifiedName = b.datasetQualifiedName;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IPowerBIMeasure> measures = new java.util.TreeSet<IPowerBIMeasure>();
        if (b.measures != null) measures.addAll(b.measures);
        measures = java.util.Collections.unmodifiableSortedSet(measures);
        this.measures = measures;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        this.powerBITableColumnCount = b.powerBITableColumnCount;
        this.powerBITableMeasureCount = b.powerBITableMeasureCount;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
        java.util.SortedSet<String> powerBITableSourceExpressions = new java.util.TreeSet<String>();
        if (b.powerBITableSourceExpressions != null) powerBITableSourceExpressions.addAll(b.powerBITableSourceExpressions);
        powerBITableSourceExpressions = java.util.Collections.unmodifiableSortedSet(powerBITableSourceExpressions);
        this.powerBITableSourceExpressions = powerBITableSourceExpressions;
        this.workspaceQualifiedName = b.workspaceQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static PowerBITable.PowerBITableBuilder<?, ?> _internal() {
        return new PowerBITable.PowerBITableBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PowerBITable.PowerBITableBuilder<?, ?> toBuilder() {
        return new PowerBITable.PowerBITableBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Columns that exist within this table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIColumn> getColumns() {
        return this.columns;
    }

    /**
     * List of qualified names of associated Power BI Dataflows.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDataflowQualifiedNames() {
        return this.dataflowQualifiedNames;
    }

    /**
     * PowerBI Dataflow that is associated with this PowerBI Table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIDataflow> getDataflows() {
        return this.dataflows;
    }

    /**
     * Dataset in which this table exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IPowerBIDataset getDataset() {
        return this.dataset;
    }

    /**
     * Unique name of the dataset in which this table exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatasetQualifiedName() {
        return this.datasetQualifiedName;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Measures that exist within this table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIMeasure> getMeasures() {
        return this.measures;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Endorsement status of this asset, in Power BI.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    /**
     * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    /**
     * Whether this asset is hidden in Power BI (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    /**
     * Number of columns in this table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPowerBITableColumnCount() {
        return this.powerBITableColumnCount;
    }

    /**
     * Number of measures in this table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPowerBITableMeasureCount() {
        return this.powerBITableMeasureCount;
    }

    /**
     * Unique name of the Power BI table in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    /**
     * Power Query M expressions for the table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPowerBITableSourceExpressions() {
        return this.powerBITableSourceExpressions;
    }

    /**
     * Unique name of the workspace in which this table exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PowerBITable)) return false;
        final PowerBITable other = (PowerBITable) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$powerBIIsHidden = this.getPowerBIIsHidden();
        final java.lang.Object other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !this$powerBIIsHidden.equals(other$powerBIIsHidden)) return false;
        final java.lang.Object this$powerBITableColumnCount = this.getPowerBITableColumnCount();
        final java.lang.Object other$powerBITableColumnCount = other.getPowerBITableColumnCount();
        if (this$powerBITableColumnCount == null ? other$powerBITableColumnCount != null : !this$powerBITableColumnCount.equals(other$powerBITableColumnCount)) return false;
        final java.lang.Object this$powerBITableMeasureCount = this.getPowerBITableMeasureCount();
        final java.lang.Object other$powerBITableMeasureCount = other.getPowerBITableMeasureCount();
        if (this$powerBITableMeasureCount == null ? other$powerBITableMeasureCount != null : !this$powerBITableMeasureCount.equals(other$powerBITableMeasureCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$columns = this.getColumns();
        final java.lang.Object other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        final java.lang.Object this$dataflowQualifiedNames = this.getDataflowQualifiedNames();
        final java.lang.Object other$dataflowQualifiedNames = other.getDataflowQualifiedNames();
        if (this$dataflowQualifiedNames == null ? other$dataflowQualifiedNames != null : !this$dataflowQualifiedNames.equals(other$dataflowQualifiedNames)) return false;
        final java.lang.Object this$dataflows = this.getDataflows();
        final java.lang.Object other$dataflows = other.getDataflows();
        if (this$dataflows == null ? other$dataflows != null : !this$dataflows.equals(other$dataflows)) return false;
        final java.lang.Object this$dataset = this.getDataset();
        final java.lang.Object other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) return false;
        final java.lang.Object this$datasetQualifiedName = this.getDatasetQualifiedName();
        final java.lang.Object other$datasetQualifiedName = other.getDatasetQualifiedName();
        if (this$datasetQualifiedName == null ? other$datasetQualifiedName != null : !this$datasetQualifiedName.equals(other$datasetQualifiedName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$measures = this.getMeasures();
        final java.lang.Object other$measures = other.getMeasures();
        if (this$measures == null ? other$measures != null : !this$measures.equals(other$measures)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$powerBIEndorsement = this.getPowerBIEndorsement();
        final java.lang.Object other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) return false;
        final java.lang.Object this$powerBIFormatString = this.getPowerBIFormatString();
        final java.lang.Object other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) return false;
        final java.lang.Object this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        final java.lang.Object other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        if (this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName)) return false;
        final java.lang.Object this$powerBITableSourceExpressions = this.getPowerBITableSourceExpressions();
        final java.lang.Object other$powerBITableSourceExpressions = other.getPowerBITableSourceExpressions();
        if (this$powerBITableSourceExpressions == null ? other$powerBITableSourceExpressions != null : !this$powerBITableSourceExpressions.equals(other$powerBITableSourceExpressions)) return false;
        final java.lang.Object this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        final java.lang.Object other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        if (this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PowerBITable;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * PRIME + ($powerBIIsHidden == null ? 43 : $powerBIIsHidden.hashCode());
        final java.lang.Object $powerBITableColumnCount = this.getPowerBITableColumnCount();
        result = result * PRIME + ($powerBITableColumnCount == null ? 43 : $powerBITableColumnCount.hashCode());
        final java.lang.Object $powerBITableMeasureCount = this.getPowerBITableMeasureCount();
        result = result * PRIME + ($powerBITableMeasureCount == null ? 43 : $powerBITableMeasureCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $columns = this.getColumns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        final java.lang.Object $dataflowQualifiedNames = this.getDataflowQualifiedNames();
        result = result * PRIME + ($dataflowQualifiedNames == null ? 43 : $dataflowQualifiedNames.hashCode());
        final java.lang.Object $dataflows = this.getDataflows();
        result = result * PRIME + ($dataflows == null ? 43 : $dataflows.hashCode());
        final java.lang.Object $dataset = this.getDataset();
        result = result * PRIME + ($dataset == null ? 43 : $dataset.hashCode());
        final java.lang.Object $datasetQualifiedName = this.getDatasetQualifiedName();
        result = result * PRIME + ($datasetQualifiedName == null ? 43 : $datasetQualifiedName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $measures = this.getMeasures();
        result = result * PRIME + ($measures == null ? 43 : $measures.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * PRIME + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        final java.lang.Object $powerBIFormatString = this.getPowerBIFormatString();
        result = result * PRIME + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        final java.lang.Object $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * PRIME + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        final java.lang.Object $powerBITableSourceExpressions = this.getPowerBITableSourceExpressions();
        result = result * PRIME + ($powerBITableSourceExpressions == null ? 43 : $powerBITableSourceExpressions.hashCode());
        final java.lang.Object $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * PRIME + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PowerBITable(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", columns=" + this.getColumns() + ", dataflowQualifiedNames=" + this.getDataflowQualifiedNames() + ", dataflows=" + this.getDataflows() + ", dataset=" + this.getDataset() + ", datasetQualifiedName=" + this.getDatasetQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", measures=" + this.getMeasures() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", powerBIEndorsement=" + this.getPowerBIEndorsement() + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBITableColumnCount=" + this.getPowerBITableColumnCount() + ", powerBITableMeasureCount=" + this.getPowerBITableMeasureCount() + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ", powerBITableSourceExpressions=" + this.getPowerBITableSourceExpressions() + ", workspaceQualifiedName=" + this.getWorkspaceQualifiedName() + ")";
    }

    /**
     * Fixed typeName for PowerBITables.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
