// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Power BI workspace in Atlan. Workspaces contain dashboards, reports, workbooks, datasets and dataflows.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class PowerBIWorkspace extends Asset implements IPowerBIWorkspace, IPowerBI, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(PowerBIWorkspace.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIWorkspace";
    /**
     * Fixed typeName for PowerBIWorkspaces.
     */
    String typeName;
    /**
     * Number of dashboards in this workspace.
     */
    @Attribute
    Long dashboardCount;
    /**
     * Dashboards that exist within this workspace.
     */
    @Attribute
    SortedSet<IPowerBIDashboard> dashboards;
    /**
     * Number of dataflows in this workspace.
     */
    @Attribute
    Long dataflowCount;
    /**
     * Dataflows that exist within this workspace.
     */
    @Attribute
    SortedSet<IPowerBIDataflow> dataflows;
    /**
     * Number of datasets in this workspace.
     */
    @Attribute
    Long datasetCount;
    /**
     * Datasets that exist within this workspace.
     */
    @Attribute
    SortedSet<IPowerBIDataset> datasets;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Endorsement status of this asset, in Power BI.
     */
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    /**
     * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
     */
    @Attribute
    String powerBIFormatString;
    /**
     * Whether this asset is hidden in Power BI (true) or not (false).
     */
    @Attribute
    Boolean powerBIIsHidden;
    /**
     * Unique name of the Power BI table in which this asset exists.
     */
    @Attribute
    String powerBITableQualifiedName;
    /**
     * Number of reports in this workspace.
     */
    @Attribute
    Long reportCount;
    /**
     * Reports that exist within this workspace.
     */
    @Attribute
    SortedSet<IPowerBIReport> reports;
    /**
     * Deprecated.
     */
    @Attribute
    String webUrl;

    /**
     * Builds the minimal object necessary to create a relationship to a PowerBIWorkspace, from a potentially
     * more-complete PowerBIWorkspace object.
     *
     * @return the minimal object necessary to relate to the PowerBIWorkspace
     * @throws InvalidRequestException if any of the minimal set of required properties for a PowerBIWorkspace relationship are not found in the initial object
     */
    @Override
    public PowerBIWorkspace trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all PowerBIWorkspace assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PowerBIWorkspace assets will be included.
     *
     * @return a fluent search that includes all PowerBIWorkspace assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all PowerBIWorkspace assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PowerBIWorkspace assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all PowerBIWorkspace assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all PowerBIWorkspace assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) PowerBIWorkspaces will be included
     * @return a fluent search that includes all PowerBIWorkspace assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all PowerBIWorkspace assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) PowerBIWorkspaces will be included
     * @return a fluent search that includes all PowerBIWorkspace assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a PowerBIWorkspace by GUID. Use this to create a relationship to this PowerBIWorkspace,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the PowerBIWorkspace to reference
     * @return reference to a PowerBIWorkspace that can be used for defining a relationship to a PowerBIWorkspace
     */
    public static PowerBIWorkspace refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PowerBIWorkspace by GUID. Use this to create a relationship to this PowerBIWorkspace,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the PowerBIWorkspace to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PowerBIWorkspace that can be used for defining a relationship to a PowerBIWorkspace
     */
    public static PowerBIWorkspace refByGuid(String guid, Reference.SaveSemantic semantic) {
        return PowerBIWorkspace._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a PowerBIWorkspace by qualifiedName. Use this to create a relationship to this PowerBIWorkspace,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the PowerBIWorkspace to reference
     * @return reference to a PowerBIWorkspace that can be used for defining a relationship to a PowerBIWorkspace
     */
    public static PowerBIWorkspace refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PowerBIWorkspace by qualifiedName. Use this to create a relationship to this PowerBIWorkspace,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the PowerBIWorkspace to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PowerBIWorkspace that can be used for defining a relationship to a PowerBIWorkspace
     */
    public static PowerBIWorkspace refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return PowerBIWorkspace._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a PowerBIWorkspace by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the PowerBIWorkspace to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PowerBIWorkspace, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIWorkspace does not exist or the provided GUID is not a PowerBIWorkspace
     */
    @JsonIgnore
    public static PowerBIWorkspace get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a PowerBIWorkspace by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PowerBIWorkspace to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PowerBIWorkspace, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIWorkspace does not exist or the provided GUID is not a PowerBIWorkspace
     */
    @JsonIgnore
    public static PowerBIWorkspace get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a PowerBIWorkspace by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PowerBIWorkspace to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full PowerBIWorkspace, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PowerBIWorkspace does not exist or the provided GUID is not a PowerBIWorkspace
     */
    @JsonIgnore
    public static PowerBIWorkspace get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof PowerBIWorkspace) {
                return (PowerBIWorkspace) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof PowerBIWorkspace) {
                return (PowerBIWorkspace) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) PowerBIWorkspace to active.
     *
     * @param qualifiedName for the PowerBIWorkspace
     * @return true if the PowerBIWorkspace is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) PowerBIWorkspace to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the PowerBIWorkspace
     * @return true if the PowerBIWorkspace is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the minimal request necessary to update the PowerBIWorkspace, as a builder
     */
    public static PowerBIWorkspaceBuilder<?, ?> updater(String qualifiedName, String name) {
        return PowerBIWorkspace._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a PowerBIWorkspace, from a potentially
     * more-complete PowerBIWorkspace object.
     *
     * @return the minimal object necessary to update the PowerBIWorkspace, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for PowerBIWorkspace are not found in the initial object
     */
    @Override
    public PowerBIWorkspaceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PowerBIWorkspace's owners
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PowerBIWorkspace, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to update the PowerBIWorkspace's certificate
     * @param qualifiedName of the PowerBIWorkspace
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PowerBIWorkspace, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIWorkspace) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PowerBIWorkspace's certificate
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to update the PowerBIWorkspace's announcement
     * @param qualifiedName of the PowerBIWorkspace
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIWorkspace) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan client from which to remove the PowerBIWorkspace's announcement
     * @param qualifiedName of the PowerBIWorkspace
     * @param name of the PowerBIWorkspace
     * @return the updated PowerBIWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIWorkspace) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the PowerBIWorkspace.
     *
     * @param qualifiedName for the PowerBIWorkspace
     * @param name human-readable name of the PowerBIWorkspace
     * @param terms the list of terms to replace on the PowerBIWorkspace, or null to remove all terms from the PowerBIWorkspace
     * @return the PowerBIWorkspace that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to replace the PowerBIWorkspace's assigned terms
     * @param qualifiedName for the PowerBIWorkspace
     * @param name human-readable name of the PowerBIWorkspace
     * @param terms the list of terms to replace on the PowerBIWorkspace, or null to remove all terms from the PowerBIWorkspace
     * @return the PowerBIWorkspace that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIWorkspace) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the PowerBIWorkspace, without replacing existing terms linked to the PowerBIWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PowerBIWorkspace's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the PowerBIWorkspace
     * @param terms the list of terms to append to the PowerBIWorkspace
     * @return the PowerBIWorkspace that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the PowerBIWorkspace, without replacing existing terms linked to the PowerBIWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PowerBIWorkspace's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the PowerBIWorkspace
     * @param qualifiedName for the PowerBIWorkspace
     * @param terms the list of terms to append to the PowerBIWorkspace
     * @return the PowerBIWorkspace that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIWorkspace) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a PowerBIWorkspace, without replacing all existing terms linked to the PowerBIWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PowerBIWorkspace's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the PowerBIWorkspace
     * @param terms the list of terms to remove from the PowerBIWorkspace, which must be referenced by GUID
     * @return the PowerBIWorkspace that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a PowerBIWorkspace, without replacing all existing terms linked to the PowerBIWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PowerBIWorkspace's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the PowerBIWorkspace
     * @param qualifiedName for the PowerBIWorkspace
     * @param terms the list of terms to remove from the PowerBIWorkspace, which must be referenced by GUID
     * @return the PowerBIWorkspace that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PowerBIWorkspace removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIWorkspace) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a PowerBIWorkspace, without replacing existing Atlan tags linked to the PowerBIWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PowerBIWorkspace's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PowerBIWorkspace
     */
    public static PowerBIWorkspace appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PowerBIWorkspace, without replacing existing Atlan tags linked to the PowerBIWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PowerBIWorkspace's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PowerBIWorkspace
     * @param qualifiedName of the PowerBIWorkspace
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PowerBIWorkspace
     */
    public static PowerBIWorkspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBIWorkspace) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PowerBIWorkspace, without replacing existing Atlan tags linked to the PowerBIWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PowerBIWorkspace's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PowerBIWorkspace
     */
    public static PowerBIWorkspace appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a PowerBIWorkspace, without replacing existing Atlan tags linked to the PowerBIWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PowerBIWorkspace's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PowerBIWorkspace
     * @param qualifiedName of the PowerBIWorkspace
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PowerBIWorkspace
     */
    public static PowerBIWorkspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBIWorkspace) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a PowerBIWorkspace.
     *
     * @param qualifiedName of the PowerBIWorkspace
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PowerBIWorkspace
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a PowerBIWorkspace.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a PowerBIWorkspace
     * @param qualifiedName of the PowerBIWorkspace
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PowerBIWorkspace
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class PowerBIWorkspaceBuilder<C extends PowerBIWorkspace, B extends PowerBIWorkspace.PowerBIWorkspaceBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dashboardCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIDashboard> dashboards;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long dataflowCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIDataflow> dataflows;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long datasetCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIDataset> datasets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBIFormatString;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean powerBIIsHidden;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String powerBITableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long reportCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPowerBIReport> reports;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String webUrl;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            PowerBIWorkspace.PowerBIWorkspaceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final PowerBIWorkspace instance, final PowerBIWorkspace.PowerBIWorkspaceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboardCount(instance.dashboardCount);
            b.dashboards(instance.dashboards == null ? java.util.Collections.<IPowerBIDashboard>emptySortedSet() : instance.dashboards);
            b.dataflowCount(instance.dataflowCount);
            b.dataflows(instance.dataflows == null ? java.util.Collections.<IPowerBIDataflow>emptySortedSet() : instance.dataflows);
            b.datasetCount(instance.datasetCount);
            b.datasets(instance.datasets == null ? java.util.Collections.<IPowerBIDataset>emptySortedSet() : instance.datasets);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
            b.reportCount(instance.reportCount);
            b.reports(instance.reports == null ? java.util.Collections.<IPowerBIReport>emptySortedSet() : instance.reports);
            b.webUrl(instance.webUrl);
        }

        /**
         * Fixed typeName for PowerBIWorkspaces.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Number of dashboards in this workspace.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dashboardCount(final Long dashboardCount) {
            this.dashboardCount = dashboardCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dashboard(final IPowerBIDashboard dashboard) {
            if (this.dashboards == null) this.dashboards = new java.util.ArrayList<IPowerBIDashboard>();
            this.dashboards.add(dashboard);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dashboards(final java.util.Collection<? extends IPowerBIDashboard> dashboards) {
            if (dashboards == null) {
                throw new java.lang.NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) this.dashboards = new java.util.ArrayList<IPowerBIDashboard>();
            this.dashboards.addAll(dashboards);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDashboards() {
            if (this.dashboards != null) this.dashboards.clear();
            return self();
        }

        /**
         * Number of dataflows in this workspace.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataflowCount(final Long dataflowCount) {
            this.dataflowCount = dataflowCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataflow(final IPowerBIDataflow dataflow) {
            if (this.dataflows == null) this.dataflows = new java.util.ArrayList<IPowerBIDataflow>();
            this.dataflows.add(dataflow);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataflows(final java.util.Collection<? extends IPowerBIDataflow> dataflows) {
            if (dataflows == null) {
                throw new java.lang.NullPointerException("dataflows cannot be null");
            }
            if (this.dataflows == null) this.dataflows = new java.util.ArrayList<IPowerBIDataflow>();
            this.dataflows.addAll(dataflows);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDataflows() {
            if (this.dataflows != null) this.dataflows.clear();
            return self();
        }

        /**
         * Number of datasets in this workspace.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasetCount(final Long datasetCount) {
            this.datasetCount = datasetCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataset(final IPowerBIDataset dataset) {
            if (this.datasets == null) this.datasets = new java.util.ArrayList<IPowerBIDataset>();
            this.datasets.add(dataset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B datasets(final java.util.Collection<? extends IPowerBIDataset> datasets) {
            if (datasets == null) {
                throw new java.lang.NullPointerException("datasets cannot be null");
            }
            if (this.datasets == null) this.datasets = new java.util.ArrayList<IPowerBIDataset>();
            this.datasets.addAll(datasets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDatasets() {
            if (this.datasets != null) this.datasets.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Endorsement status of this asset, in Power BI.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIEndorsement(final PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return self();
        }

        /**
         * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIFormatString(final String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return self();
        }

        /**
         * Whether this asset is hidden in Power BI (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBIIsHidden(final Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return self();
        }

        /**
         * Unique name of the Power BI table in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B powerBITableQualifiedName(final String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return self();
        }

        /**
         * Number of reports in this workspace.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B reportCount(final Long reportCount) {
            this.reportCount = reportCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B report(final IPowerBIReport report) {
            if (this.reports == null) this.reports = new java.util.ArrayList<IPowerBIReport>();
            this.reports.add(report);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B reports(final java.util.Collection<? extends IPowerBIReport> reports) {
            if (reports == null) {
                throw new java.lang.NullPointerException("reports cannot be null");
            }
            if (this.reports == null) this.reports = new java.util.ArrayList<IPowerBIReport>();
            this.reports.addAll(reports);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearReports() {
            if (this.reports != null) this.reports.clear();
            return self();
        }

        /**
         * Deprecated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B webUrl(final String webUrl) {
            this.webUrl = webUrl;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "PowerBIWorkspace.PowerBIWorkspaceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboardCount=" + this.dashboardCount + ", dashboards=" + this.dashboards + ", dataflowCount=" + this.dataflowCount + ", dataflows=" + this.dataflows + ", datasetCount=" + this.datasetCount + ", datasets=" + this.datasets + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", powerBIEndorsement=" + this.powerBIEndorsement + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ", reportCount=" + this.reportCount + ", reports=" + this.reports + ", webUrl=" + this.webUrl + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class PowerBIWorkspaceBuilderImpl extends PowerBIWorkspace.PowerBIWorkspaceBuilder<PowerBIWorkspace, PowerBIWorkspace.PowerBIWorkspaceBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PowerBIWorkspaceBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected PowerBIWorkspace.PowerBIWorkspaceBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PowerBIWorkspace build() {
            return new PowerBIWorkspace(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected PowerBIWorkspace(final PowerBIWorkspace.PowerBIWorkspaceBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = PowerBIWorkspace.$default$typeName();
        this.dashboardCount = b.dashboardCount;
        java.util.SortedSet<IPowerBIDashboard> dashboards = new java.util.TreeSet<IPowerBIDashboard>();
        if (b.dashboards != null) dashboards.addAll(b.dashboards);
        dashboards = java.util.Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
        this.dataflowCount = b.dataflowCount;
        java.util.SortedSet<IPowerBIDataflow> dataflows = new java.util.TreeSet<IPowerBIDataflow>();
        if (b.dataflows != null) dataflows.addAll(b.dataflows);
        dataflows = java.util.Collections.unmodifiableSortedSet(dataflows);
        this.dataflows = dataflows;
        this.datasetCount = b.datasetCount;
        java.util.SortedSet<IPowerBIDataset> datasets = new java.util.TreeSet<IPowerBIDataset>();
        if (b.datasets != null) datasets.addAll(b.datasets);
        datasets = java.util.Collections.unmodifiableSortedSet(datasets);
        this.datasets = datasets;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
        this.reportCount = b.reportCount;
        java.util.SortedSet<IPowerBIReport> reports = new java.util.TreeSet<IPowerBIReport>();
        if (b.reports != null) reports.addAll(b.reports);
        reports = java.util.Collections.unmodifiableSortedSet(reports);
        this.reports = reports;
        this.webUrl = b.webUrl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static PowerBIWorkspace.PowerBIWorkspaceBuilder<?, ?> _internal() {
        return new PowerBIWorkspace.PowerBIWorkspaceBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PowerBIWorkspace.PowerBIWorkspaceBuilder<?, ?> toBuilder() {
        return new PowerBIWorkspace.PowerBIWorkspaceBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Number of dashboards in this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDashboardCount() {
        return this.dashboardCount;
    }

    /**
     * Dashboards that exist within this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIDashboard> getDashboards() {
        return this.dashboards;
    }

    /**
     * Number of dataflows in this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDataflowCount() {
        return this.dataflowCount;
    }

    /**
     * Dataflows that exist within this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIDataflow> getDataflows() {
        return this.dataflows;
    }

    /**
     * Number of datasets in this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getDatasetCount() {
        return this.datasetCount;
    }

    /**
     * Datasets that exist within this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIDataset> getDatasets() {
        return this.datasets;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Endorsement status of this asset, in Power BI.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    /**
     * Format of this asset, as specified in the FORMAT_STRING of the MDX cell property.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    /**
     * Whether this asset is hidden in Power BI (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    /**
     * Unique name of the Power BI table in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    /**
     * Number of reports in this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getReportCount() {
        return this.reportCount;
    }

    /**
     * Reports that exist within this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPowerBIReport> getReports() {
        return this.reports;
    }

    /**
     * Deprecated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PowerBIWorkspace)) return false;
        final PowerBIWorkspace other = (PowerBIWorkspace) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dashboardCount = this.getDashboardCount();
        final java.lang.Object other$dashboardCount = other.getDashboardCount();
        if (this$dashboardCount == null ? other$dashboardCount != null : !this$dashboardCount.equals(other$dashboardCount)) return false;
        final java.lang.Object this$dataflowCount = this.getDataflowCount();
        final java.lang.Object other$dataflowCount = other.getDataflowCount();
        if (this$dataflowCount == null ? other$dataflowCount != null : !this$dataflowCount.equals(other$dataflowCount)) return false;
        final java.lang.Object this$datasetCount = this.getDatasetCount();
        final java.lang.Object other$datasetCount = other.getDatasetCount();
        if (this$datasetCount == null ? other$datasetCount != null : !this$datasetCount.equals(other$datasetCount)) return false;
        final java.lang.Object this$powerBIIsHidden = this.getPowerBIIsHidden();
        final java.lang.Object other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !this$powerBIIsHidden.equals(other$powerBIIsHidden)) return false;
        final java.lang.Object this$reportCount = this.getReportCount();
        final java.lang.Object other$reportCount = other.getReportCount();
        if (this$reportCount == null ? other$reportCount != null : !this$reportCount.equals(other$reportCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$dashboards = this.getDashboards();
        final java.lang.Object other$dashboards = other.getDashboards();
        if (this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards)) return false;
        final java.lang.Object this$dataflows = this.getDataflows();
        final java.lang.Object other$dataflows = other.getDataflows();
        if (this$dataflows == null ? other$dataflows != null : !this$dataflows.equals(other$dataflows)) return false;
        final java.lang.Object this$datasets = this.getDatasets();
        final java.lang.Object other$datasets = other.getDatasets();
        if (this$datasets == null ? other$datasets != null : !this$datasets.equals(other$datasets)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$powerBIEndorsement = this.getPowerBIEndorsement();
        final java.lang.Object other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) return false;
        final java.lang.Object this$powerBIFormatString = this.getPowerBIFormatString();
        final java.lang.Object other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) return false;
        final java.lang.Object this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        final java.lang.Object other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        if (this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName)) return false;
        final java.lang.Object this$reports = this.getReports();
        final java.lang.Object other$reports = other.getReports();
        if (this$reports == null ? other$reports != null : !this$reports.equals(other$reports)) return false;
        final java.lang.Object this$webUrl = this.getWebUrl();
        final java.lang.Object other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PowerBIWorkspace;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dashboardCount = this.getDashboardCount();
        result = result * PRIME + ($dashboardCount == null ? 43 : $dashboardCount.hashCode());
        final java.lang.Object $dataflowCount = this.getDataflowCount();
        result = result * PRIME + ($dataflowCount == null ? 43 : $dataflowCount.hashCode());
        final java.lang.Object $datasetCount = this.getDatasetCount();
        result = result * PRIME + ($datasetCount == null ? 43 : $datasetCount.hashCode());
        final java.lang.Object $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * PRIME + ($powerBIIsHidden == null ? 43 : $powerBIIsHidden.hashCode());
        final java.lang.Object $reportCount = this.getReportCount();
        result = result * PRIME + ($reportCount == null ? 43 : $reportCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $dashboards = this.getDashboards();
        result = result * PRIME + ($dashboards == null ? 43 : $dashboards.hashCode());
        final java.lang.Object $dataflows = this.getDataflows();
        result = result * PRIME + ($dataflows == null ? 43 : $dataflows.hashCode());
        final java.lang.Object $datasets = this.getDatasets();
        result = result * PRIME + ($datasets == null ? 43 : $datasets.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * PRIME + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        final java.lang.Object $powerBIFormatString = this.getPowerBIFormatString();
        result = result * PRIME + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        final java.lang.Object $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * PRIME + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        final java.lang.Object $reports = this.getReports();
        result = result * PRIME + ($reports == null ? 43 : $reports.hashCode());
        final java.lang.Object $webUrl = this.getWebUrl();
        result = result * PRIME + ($webUrl == null ? 43 : $webUrl.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PowerBIWorkspace(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboardCount=" + this.getDashboardCount() + ", dashboards=" + this.getDashboards() + ", dataflowCount=" + this.getDataflowCount() + ", dataflows=" + this.getDataflows() + ", datasetCount=" + this.getDatasetCount() + ", datasets=" + this.getDatasets() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", powerBIEndorsement=" + this.getPowerBIEndorsement() + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ", reportCount=" + this.getReportCount() + ", reports=" + this.getReports() + ", webUrl=" + this.getWebUrl() + ")";
    }

    /**
     * Fixed typeName for PowerBIWorkspaces.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
