// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Preset dashboard in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class PresetDashboard extends Asset implements IPresetDashboard, IPreset, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(PresetDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetDashboard";
    /**
     * Fixed typeName for PresetDashboards.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Charts that exist within this dashboard.
     */
    @Attribute
    SortedSet<IPresetChart> presetCharts;
    /**
     * TBC
     */
    @Attribute
    String presetDashboardChangedByName;
    /**
     * TBC
     */
    @Attribute
    String presetDashboardChangedByURL;
    /**
     * TBC
     */
    @Attribute
    Long presetDashboardChartCount;
    /**
     * Identifier of the dashboard in which this asset exists, in Preset.
     */
    @Attribute
    Long presetDashboardId;
    /**
     * TBC
     */
    @Attribute
    Boolean presetDashboardIsManagedExternally;
    /**
     * TBC
     */
    @Attribute
    Boolean presetDashboardIsPublished;
    /**
     * Unique name of the dashboard in which this asset exists.
     */
    @Attribute
    String presetDashboardQualifiedName;
    /**
     * TBC
     */
    @Attribute
    String presetDashboardThumbnailURL;
    /**
     * Datasets that exist within this dashboard.
     */
    @Attribute
    SortedSet<IPresetDataset> presetDatasets;
    /**
     * Workspace in which this dashboard exists.
     */
    @Attribute
    IPresetWorkspace presetWorkspace;
    /**
     * Identifier of the workspace in which this asset exists, in Preset.
     */
    @Attribute
    Long presetWorkspaceId;
    /**
     * Unique name of the workspace in which this asset exists.
     */
    @Attribute
    String presetWorkspaceQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a PresetDashboard, from a potentially
     * more-complete PresetDashboard object.
     *
     * @return the minimal object necessary to relate to the PresetDashboard
     * @throws InvalidRequestException if any of the minimal set of required properties for a PresetDashboard relationship are not found in the initial object
     */
    @Override
    public PresetDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all PresetDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PresetDashboard assets will be included.
     *
     * @return a fluent search that includes all PresetDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all PresetDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PresetDashboard assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all PresetDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all PresetDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) PresetDashboards will be included
     * @return a fluent search that includes all PresetDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all PresetDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) PresetDashboards will be included
     * @return a fluent search that includes all PresetDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a PresetDashboard by GUID. Use this to create a relationship to this PresetDashboard,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the PresetDashboard to reference
     * @return reference to a PresetDashboard that can be used for defining a relationship to a PresetDashboard
     */
    public static PresetDashboard refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PresetDashboard by GUID. Use this to create a relationship to this PresetDashboard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the PresetDashboard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PresetDashboard that can be used for defining a relationship to a PresetDashboard
     */
    public static PresetDashboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return PresetDashboard._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a PresetDashboard by qualifiedName. Use this to create a relationship to this PresetDashboard,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the PresetDashboard to reference
     * @return reference to a PresetDashboard that can be used for defining a relationship to a PresetDashboard
     */
    public static PresetDashboard refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PresetDashboard by qualifiedName. Use this to create a relationship to this PresetDashboard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the PresetDashboard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PresetDashboard that can be used for defining a relationship to a PresetDashboard
     */
    public static PresetDashboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return PresetDashboard._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a PresetDashboard by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the PresetDashboard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PresetDashboard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PresetDashboard does not exist or the provided GUID is not a PresetDashboard
     */
    @JsonIgnore
    public static PresetDashboard get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a PresetDashboard by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PresetDashboard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PresetDashboard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PresetDashboard does not exist or the provided GUID is not a PresetDashboard
     */
    @JsonIgnore
    public static PresetDashboard get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a PresetDashboard by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PresetDashboard to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full PresetDashboard, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PresetDashboard does not exist or the provided GUID is not a PresetDashboard
     */
    @JsonIgnore
    public static PresetDashboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof PresetDashboard) {
                return (PresetDashboard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof PresetDashboard) {
                return (PresetDashboard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) PresetDashboard to active.
     *
     * @param qualifiedName for the PresetDashboard
     * @return true if the PresetDashboard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) PresetDashboard to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the PresetDashboard
     * @return true if the PresetDashboard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Preset collection.
     *
     * @param name of the collection
     * @param workspace in which the collection should be created, which must have at least
     *                  a qualifiedName
     * @return the minimal request necessary to create the collection, as a builder
     * @throws InvalidRequestException if the workspace provided is without a qualifiedName
     */
    public static PresetDashboardBuilder<?, ?> creator(String name, PresetWorkspace workspace) throws InvalidRequestException {
        validateRelationship(PresetWorkspace.TYPE_NAME, Map.of("connectionQualifiedName", workspace.getConnectionQualifiedName(), "qualifiedName", workspace.getQualifiedName()));
        return creator(name, workspace.getConnectionQualifiedName(), workspace.getQualifiedName()).presetWorkspace(workspace.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a Preset collection.
     *
     * @param name of the collection
     * @param workspaceQualifiedName unique name of the workspace in which the collection exists
     * @return the minimal object necessary to create the collection, as a builder
     */
    public static PresetDashboardBuilder<?, ?> creator(String name, String workspaceQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(workspaceQualifiedName);
        return creator(name, connectionQualifiedName, workspaceQualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Preset collection.
     *
     * @param name of the collection
     * @param connectionQualifiedName unique name of the connection in which to create the PresetDashboard
     * @param workspaceQualifiedName unique name of the PresetWorkspace in which to create the PresetDashboard
     * @return the minimal object necessary to create the collection, as a builder
     */
    public static PresetDashboardBuilder<?, ?> creator(String name, String connectionQualifiedName, String workspaceQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return PresetDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(workspaceQualifiedName + "/" + name).connectorType(connectorType).presetWorkspaceQualifiedName(workspaceQualifiedName).presetWorkspace(PresetWorkspace.refByQualifiedName(workspaceQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the minimal request necessary to update the PresetDashboard, as a builder
     */
    public static PresetDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return PresetDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a PresetDashboard, from a potentially
     * more-complete PresetDashboard object.
     *
     * @return the minimal object necessary to update the PresetDashboard, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for PresetDashboard are not found in the initial object
     */
    @Override
    public PresetDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a PresetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a PresetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a PresetDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PresetDashboard's owners
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PresetDashboard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a PresetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to update the PresetDashboard's certificate
     * @param qualifiedName of the PresetDashboard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PresetDashboard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PresetDashboard) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a PresetDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PresetDashboard's certificate
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a PresetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to update the PresetDashboard's announcement
     * @param qualifiedName of the PresetDashboard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetDashboard) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a PresetDashboard.
     *
     * @param client connectivity to the Atlan client from which to remove the PresetDashboard's announcement
     * @param qualifiedName of the PresetDashboard
     * @param name of the PresetDashboard
     * @return the updated PresetDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetDashboard) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the PresetDashboard.
     *
     * @param qualifiedName for the PresetDashboard
     * @param name human-readable name of the PresetDashboard
     * @param terms the list of terms to replace on the PresetDashboard, or null to remove all terms from the PresetDashboard
     * @return the PresetDashboard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the PresetDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to replace the PresetDashboard's assigned terms
     * @param qualifiedName for the PresetDashboard
     * @param name human-readable name of the PresetDashboard
     * @param terms the list of terms to replace on the PresetDashboard, or null to remove all terms from the PresetDashboard
     * @return the PresetDashboard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the PresetDashboard, without replacing existing terms linked to the PresetDashboard.
     * Note: this operation must make two API calls — one to retrieve the PresetDashboard's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the PresetDashboard
     * @param terms the list of terms to append to the PresetDashboard
     * @return the PresetDashboard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the PresetDashboard, without replacing existing terms linked to the PresetDashboard.
     * Note: this operation must make two API calls — one to retrieve the PresetDashboard's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the PresetDashboard
     * @param qualifiedName for the PresetDashboard
     * @param terms the list of terms to append to the PresetDashboard
     * @return the PresetDashboard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a PresetDashboard, without replacing all existing terms linked to the PresetDashboard.
     * Note: this operation must make two API calls — one to retrieve the PresetDashboard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the PresetDashboard
     * @param terms the list of terms to remove from the PresetDashboard, which must be referenced by GUID
     * @return the PresetDashboard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a PresetDashboard, without replacing all existing terms linked to the PresetDashboard.
     * Note: this operation must make two API calls — one to retrieve the PresetDashboard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the PresetDashboard
     * @param qualifiedName for the PresetDashboard
     * @param terms the list of terms to remove from the PresetDashboard, which must be referenced by GUID
     * @return the PresetDashboard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PresetDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetDashboard) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a PresetDashboard, without replacing existing Atlan tags linked to the PresetDashboard.
     * Note: this operation must make two API calls — one to retrieve the PresetDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PresetDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PresetDashboard
     */
    public static PresetDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PresetDashboard, without replacing existing Atlan tags linked to the PresetDashboard.
     * Note: this operation must make two API calls — one to retrieve the PresetDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PresetDashboard
     * @param qualifiedName of the PresetDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PresetDashboard
     */
    public static PresetDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PresetDashboard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PresetDashboard, without replacing existing Atlan tags linked to the PresetDashboard.
     * Note: this operation must make two API calls — one to retrieve the PresetDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PresetDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PresetDashboard
     */
    public static PresetDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a PresetDashboard, without replacing existing Atlan tags linked to the PresetDashboard.
     * Note: this operation must make two API calls — one to retrieve the PresetDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PresetDashboard
     * @param qualifiedName of the PresetDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PresetDashboard
     */
    public static PresetDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PresetDashboard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a PresetDashboard.
     *
     * @param qualifiedName of the PresetDashboard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PresetDashboard
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a PresetDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a PresetDashboard
     * @param qualifiedName of the PresetDashboard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PresetDashboard
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class PresetDashboardBuilder<C extends PresetDashboard, B extends PresetDashboard.PresetDashboardBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPresetChart> presetCharts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetDashboardChangedByName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetDashboardChangedByURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetDashboardChartCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetDashboardId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean presetDashboardIsManagedExternally;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean presetDashboardIsPublished;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetDashboardQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetDashboardThumbnailURL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPresetDataset> presetDatasets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IPresetWorkspace presetWorkspace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetWorkspaceId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetWorkspaceQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            PresetDashboard.PresetDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final PresetDashboard instance, final PresetDashboard.PresetDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.presetCharts(instance.presetCharts == null ? java.util.Collections.<IPresetChart>emptySortedSet() : instance.presetCharts);
            b.presetDashboardChangedByName(instance.presetDashboardChangedByName);
            b.presetDashboardChangedByURL(instance.presetDashboardChangedByURL);
            b.presetDashboardChartCount(instance.presetDashboardChartCount);
            b.presetDashboardId(instance.presetDashboardId);
            b.presetDashboardIsManagedExternally(instance.presetDashboardIsManagedExternally);
            b.presetDashboardIsPublished(instance.presetDashboardIsPublished);
            b.presetDashboardQualifiedName(instance.presetDashboardQualifiedName);
            b.presetDashboardThumbnailURL(instance.presetDashboardThumbnailURL);
            b.presetDatasets(instance.presetDatasets == null ? java.util.Collections.<IPresetDataset>emptySortedSet() : instance.presetDatasets);
            b.presetWorkspace(instance.presetWorkspace);
            b.presetWorkspaceId(instance.presetWorkspaceId);
            b.presetWorkspaceQualifiedName(instance.presetWorkspaceQualifiedName);
        }

        /**
         * Fixed typeName for PresetDashboards.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetChart(final IPresetChart presetChart) {
            if (this.presetCharts == null) this.presetCharts = new java.util.ArrayList<IPresetChart>();
            this.presetCharts.add(presetChart);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetCharts(final java.util.Collection<? extends IPresetChart> presetCharts) {
            if (presetCharts == null) {
                throw new java.lang.NullPointerException("presetCharts cannot be null");
            }
            if (this.presetCharts == null) this.presetCharts = new java.util.ArrayList<IPresetChart>();
            this.presetCharts.addAll(presetCharts);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPresetCharts() {
            if (this.presetCharts != null) this.presetCharts.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardChangedByName(final String presetDashboardChangedByName) {
            this.presetDashboardChangedByName = presetDashboardChangedByName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardChangedByURL(final String presetDashboardChangedByURL) {
            this.presetDashboardChangedByURL = presetDashboardChangedByURL;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardChartCount(final Long presetDashboardChartCount) {
            this.presetDashboardChartCount = presetDashboardChartCount;
            return self();
        }

        /**
         * Identifier of the dashboard in which this asset exists, in Preset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardId(final Long presetDashboardId) {
            this.presetDashboardId = presetDashboardId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardIsManagedExternally(final Boolean presetDashboardIsManagedExternally) {
            this.presetDashboardIsManagedExternally = presetDashboardIsManagedExternally;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardIsPublished(final Boolean presetDashboardIsPublished) {
            this.presetDashboardIsPublished = presetDashboardIsPublished;
            return self();
        }

        /**
         * Unique name of the dashboard in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardQualifiedName(final String presetDashboardQualifiedName) {
            this.presetDashboardQualifiedName = presetDashboardQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardThumbnailURL(final String presetDashboardThumbnailURL) {
            this.presetDashboardThumbnailURL = presetDashboardThumbnailURL;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDataset(final IPresetDataset presetDataset) {
            if (this.presetDatasets == null) this.presetDatasets = new java.util.ArrayList<IPresetDataset>();
            this.presetDatasets.add(presetDataset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDatasets(final java.util.Collection<? extends IPresetDataset> presetDatasets) {
            if (presetDatasets == null) {
                throw new java.lang.NullPointerException("presetDatasets cannot be null");
            }
            if (this.presetDatasets == null) this.presetDatasets = new java.util.ArrayList<IPresetDataset>();
            this.presetDatasets.addAll(presetDatasets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPresetDatasets() {
            if (this.presetDatasets != null) this.presetDatasets.clear();
            return self();
        }

        /**
         * Workspace in which this dashboard exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspace(final IPresetWorkspace presetWorkspace) {
            this.presetWorkspace = presetWorkspace;
            return self();
        }

        /**
         * Identifier of the workspace in which this asset exists, in Preset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceId(final Long presetWorkspaceId) {
            this.presetWorkspaceId = presetWorkspaceId;
            return self();
        }

        /**
         * Unique name of the workspace in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceQualifiedName(final String presetWorkspaceQualifiedName) {
            this.presetWorkspaceQualifiedName = presetWorkspaceQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "PresetDashboard.PresetDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", presetCharts=" + this.presetCharts + ", presetDashboardChangedByName=" + this.presetDashboardChangedByName + ", presetDashboardChangedByURL=" + this.presetDashboardChangedByURL + ", presetDashboardChartCount=" + this.presetDashboardChartCount + ", presetDashboardId=" + this.presetDashboardId + ", presetDashboardIsManagedExternally=" + this.presetDashboardIsManagedExternally + ", presetDashboardIsPublished=" + this.presetDashboardIsPublished + ", presetDashboardQualifiedName=" + this.presetDashboardQualifiedName + ", presetDashboardThumbnailURL=" + this.presetDashboardThumbnailURL + ", presetDatasets=" + this.presetDatasets + ", presetWorkspace=" + this.presetWorkspace + ", presetWorkspaceId=" + this.presetWorkspaceId + ", presetWorkspaceQualifiedName=" + this.presetWorkspaceQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class PresetDashboardBuilderImpl extends PresetDashboard.PresetDashboardBuilder<PresetDashboard, PresetDashboard.PresetDashboardBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PresetDashboardBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected PresetDashboard.PresetDashboardBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PresetDashboard build() {
            return new PresetDashboard(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected PresetDashboard(final PresetDashboard.PresetDashboardBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = PresetDashboard.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<IPresetChart> presetCharts = new java.util.TreeSet<IPresetChart>();
        if (b.presetCharts != null) presetCharts.addAll(b.presetCharts);
        presetCharts = java.util.Collections.unmodifiableSortedSet(presetCharts);
        this.presetCharts = presetCharts;
        this.presetDashboardChangedByName = b.presetDashboardChangedByName;
        this.presetDashboardChangedByURL = b.presetDashboardChangedByURL;
        this.presetDashboardChartCount = b.presetDashboardChartCount;
        this.presetDashboardId = b.presetDashboardId;
        this.presetDashboardIsManagedExternally = b.presetDashboardIsManagedExternally;
        this.presetDashboardIsPublished = b.presetDashboardIsPublished;
        this.presetDashboardQualifiedName = b.presetDashboardQualifiedName;
        this.presetDashboardThumbnailURL = b.presetDashboardThumbnailURL;
        java.util.SortedSet<IPresetDataset> presetDatasets = new java.util.TreeSet<IPresetDataset>();
        if (b.presetDatasets != null) presetDatasets.addAll(b.presetDatasets);
        presetDatasets = java.util.Collections.unmodifiableSortedSet(presetDatasets);
        this.presetDatasets = presetDatasets;
        this.presetWorkspace = b.presetWorkspace;
        this.presetWorkspaceId = b.presetWorkspaceId;
        this.presetWorkspaceQualifiedName = b.presetWorkspaceQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static PresetDashboard.PresetDashboardBuilder<?, ?> _internal() {
        return new PresetDashboard.PresetDashboardBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PresetDashboard.PresetDashboardBuilder<?, ?> toBuilder() {
        return new PresetDashboard.PresetDashboardBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Charts that exist within this dashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPresetChart> getPresetCharts() {
        return this.presetCharts;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetDashboardChangedByName() {
        return this.presetDashboardChangedByName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetDashboardChangedByURL() {
        return this.presetDashboardChangedByURL;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetDashboardChartCount() {
        return this.presetDashboardChartCount;
    }

    /**
     * Identifier of the dashboard in which this asset exists, in Preset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetDashboardId() {
        return this.presetDashboardId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPresetDashboardIsManagedExternally() {
        return this.presetDashboardIsManagedExternally;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPresetDashboardIsPublished() {
        return this.presetDashboardIsPublished;
    }

    /**
     * Unique name of the dashboard in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetDashboardQualifiedName() {
        return this.presetDashboardQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetDashboardThumbnailURL() {
        return this.presetDashboardThumbnailURL;
    }

    /**
     * Datasets that exist within this dashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPresetDataset> getPresetDatasets() {
        return this.presetDatasets;
    }

    /**
     * Workspace in which this dashboard exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IPresetWorkspace getPresetWorkspace() {
        return this.presetWorkspace;
    }

    /**
     * Identifier of the workspace in which this asset exists, in Preset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetWorkspaceId() {
        return this.presetWorkspaceId;
    }

    /**
     * Unique name of the workspace in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetWorkspaceQualifiedName() {
        return this.presetWorkspaceQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PresetDashboard)) return false;
        final PresetDashboard other = (PresetDashboard) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$presetDashboardChartCount = this.getPresetDashboardChartCount();
        final java.lang.Object other$presetDashboardChartCount = other.getPresetDashboardChartCount();
        if (this$presetDashboardChartCount == null ? other$presetDashboardChartCount != null : !this$presetDashboardChartCount.equals(other$presetDashboardChartCount)) return false;
        final java.lang.Object this$presetDashboardId = this.getPresetDashboardId();
        final java.lang.Object other$presetDashboardId = other.getPresetDashboardId();
        if (this$presetDashboardId == null ? other$presetDashboardId != null : !this$presetDashboardId.equals(other$presetDashboardId)) return false;
        final java.lang.Object this$presetDashboardIsManagedExternally = this.getPresetDashboardIsManagedExternally();
        final java.lang.Object other$presetDashboardIsManagedExternally = other.getPresetDashboardIsManagedExternally();
        if (this$presetDashboardIsManagedExternally == null ? other$presetDashboardIsManagedExternally != null : !this$presetDashboardIsManagedExternally.equals(other$presetDashboardIsManagedExternally)) return false;
        final java.lang.Object this$presetDashboardIsPublished = this.getPresetDashboardIsPublished();
        final java.lang.Object other$presetDashboardIsPublished = other.getPresetDashboardIsPublished();
        if (this$presetDashboardIsPublished == null ? other$presetDashboardIsPublished != null : !this$presetDashboardIsPublished.equals(other$presetDashboardIsPublished)) return false;
        final java.lang.Object this$presetWorkspaceId = this.getPresetWorkspaceId();
        final java.lang.Object other$presetWorkspaceId = other.getPresetWorkspaceId();
        if (this$presetWorkspaceId == null ? other$presetWorkspaceId != null : !this$presetWorkspaceId.equals(other$presetWorkspaceId)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$presetCharts = this.getPresetCharts();
        final java.lang.Object other$presetCharts = other.getPresetCharts();
        if (this$presetCharts == null ? other$presetCharts != null : !this$presetCharts.equals(other$presetCharts)) return false;
        final java.lang.Object this$presetDashboardChangedByName = this.getPresetDashboardChangedByName();
        final java.lang.Object other$presetDashboardChangedByName = other.getPresetDashboardChangedByName();
        if (this$presetDashboardChangedByName == null ? other$presetDashboardChangedByName != null : !this$presetDashboardChangedByName.equals(other$presetDashboardChangedByName)) return false;
        final java.lang.Object this$presetDashboardChangedByURL = this.getPresetDashboardChangedByURL();
        final java.lang.Object other$presetDashboardChangedByURL = other.getPresetDashboardChangedByURL();
        if (this$presetDashboardChangedByURL == null ? other$presetDashboardChangedByURL != null : !this$presetDashboardChangedByURL.equals(other$presetDashboardChangedByURL)) return false;
        final java.lang.Object this$presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        final java.lang.Object other$presetDashboardQualifiedName = other.getPresetDashboardQualifiedName();
        if (this$presetDashboardQualifiedName == null ? other$presetDashboardQualifiedName != null : !this$presetDashboardQualifiedName.equals(other$presetDashboardQualifiedName)) return false;
        final java.lang.Object this$presetDashboardThumbnailURL = this.getPresetDashboardThumbnailURL();
        final java.lang.Object other$presetDashboardThumbnailURL = other.getPresetDashboardThumbnailURL();
        if (this$presetDashboardThumbnailURL == null ? other$presetDashboardThumbnailURL != null : !this$presetDashboardThumbnailURL.equals(other$presetDashboardThumbnailURL)) return false;
        final java.lang.Object this$presetDatasets = this.getPresetDatasets();
        final java.lang.Object other$presetDatasets = other.getPresetDatasets();
        if (this$presetDatasets == null ? other$presetDatasets != null : !this$presetDatasets.equals(other$presetDatasets)) return false;
        final java.lang.Object this$presetWorkspace = this.getPresetWorkspace();
        final java.lang.Object other$presetWorkspace = other.getPresetWorkspace();
        if (this$presetWorkspace == null ? other$presetWorkspace != null : !this$presetWorkspace.equals(other$presetWorkspace)) return false;
        final java.lang.Object this$presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        final java.lang.Object other$presetWorkspaceQualifiedName = other.getPresetWorkspaceQualifiedName();
        if (this$presetWorkspaceQualifiedName == null ? other$presetWorkspaceQualifiedName != null : !this$presetWorkspaceQualifiedName.equals(other$presetWorkspaceQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PresetDashboard;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $presetDashboardChartCount = this.getPresetDashboardChartCount();
        result = result * PRIME + ($presetDashboardChartCount == null ? 43 : $presetDashboardChartCount.hashCode());
        final java.lang.Object $presetDashboardId = this.getPresetDashboardId();
        result = result * PRIME + ($presetDashboardId == null ? 43 : $presetDashboardId.hashCode());
        final java.lang.Object $presetDashboardIsManagedExternally = this.getPresetDashboardIsManagedExternally();
        result = result * PRIME + ($presetDashboardIsManagedExternally == null ? 43 : $presetDashboardIsManagedExternally.hashCode());
        final java.lang.Object $presetDashboardIsPublished = this.getPresetDashboardIsPublished();
        result = result * PRIME + ($presetDashboardIsPublished == null ? 43 : $presetDashboardIsPublished.hashCode());
        final java.lang.Object $presetWorkspaceId = this.getPresetWorkspaceId();
        result = result * PRIME + ($presetWorkspaceId == null ? 43 : $presetWorkspaceId.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $presetCharts = this.getPresetCharts();
        result = result * PRIME + ($presetCharts == null ? 43 : $presetCharts.hashCode());
        final java.lang.Object $presetDashboardChangedByName = this.getPresetDashboardChangedByName();
        result = result * PRIME + ($presetDashboardChangedByName == null ? 43 : $presetDashboardChangedByName.hashCode());
        final java.lang.Object $presetDashboardChangedByURL = this.getPresetDashboardChangedByURL();
        result = result * PRIME + ($presetDashboardChangedByURL == null ? 43 : $presetDashboardChangedByURL.hashCode());
        final java.lang.Object $presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        result = result * PRIME + ($presetDashboardQualifiedName == null ? 43 : $presetDashboardQualifiedName.hashCode());
        final java.lang.Object $presetDashboardThumbnailURL = this.getPresetDashboardThumbnailURL();
        result = result * PRIME + ($presetDashboardThumbnailURL == null ? 43 : $presetDashboardThumbnailURL.hashCode());
        final java.lang.Object $presetDatasets = this.getPresetDatasets();
        result = result * PRIME + ($presetDatasets == null ? 43 : $presetDatasets.hashCode());
        final java.lang.Object $presetWorkspace = this.getPresetWorkspace();
        result = result * PRIME + ($presetWorkspace == null ? 43 : $presetWorkspace.hashCode());
        final java.lang.Object $presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        result = result * PRIME + ($presetWorkspaceQualifiedName == null ? 43 : $presetWorkspaceQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PresetDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", presetCharts=" + this.getPresetCharts() + ", presetDashboardChangedByName=" + this.getPresetDashboardChangedByName() + ", presetDashboardChangedByURL=" + this.getPresetDashboardChangedByURL() + ", presetDashboardChartCount=" + this.getPresetDashboardChartCount() + ", presetDashboardId=" + this.getPresetDashboardId() + ", presetDashboardIsManagedExternally=" + this.getPresetDashboardIsManagedExternally() + ", presetDashboardIsPublished=" + this.getPresetDashboardIsPublished() + ", presetDashboardQualifiedName=" + this.getPresetDashboardQualifiedName() + ", presetDashboardThumbnailURL=" + this.getPresetDashboardThumbnailURL() + ", presetDatasets=" + this.getPresetDatasets() + ", presetWorkspace=" + this.getPresetWorkspace() + ", presetWorkspaceId=" + this.getPresetWorkspaceId() + ", presetWorkspaceQualifiedName=" + this.getPresetWorkspaceQualifiedName() + ")";
    }

    /**
     * Fixed typeName for PresetDashboards.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
