// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Preset workspace in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class PresetWorkspace extends Asset implements IPresetWorkspace, IPreset, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(PresetWorkspace.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetWorkspace";
    /**
     * Fixed typeName for PresetWorkspaces.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Identifier of the dashboard in which this asset exists, in Preset.
     */
    @Attribute
    Long presetDashboardId;
    /**
     * Unique name of the dashboard in which this asset exists.
     */
    @Attribute
    String presetDashboardQualifiedName;
    /**
     * Dashboards that exist within this workspace.
     */
    @Attribute
    SortedSet<IPresetDashboard> presetDashboards;
    /**
     * TBC
     */
    @Attribute
    Long presetWorkspaceClusterId;
    /**
     * TBC
     */
    @Attribute
    Long presetWorkspaceDashboardCount;
    /**
     * TBC
     */
    @Attribute
    Long presetWorkspaceDatasetCount;
    /**
     * TBC
     */
    @Attribute
    Long presetWorkspaceDeploymentId;
    /**
     * TBC
     */
    @Attribute
    String presetWorkspaceHostname;
    /**
     * Identifier of the workspace in which this asset exists, in Preset.
     */
    @Attribute
    Long presetWorkspaceId;
    /**
     * TBC
     */
    @Attribute
    Boolean presetWorkspaceIsInMaintenanceMode;
    /**
     * TBC
     */
    @Attribute
    Boolean presetWorkspacePublicDashboardsAllowed;
    /**
     * Unique name of the workspace in which this asset exists.
     */
    @Attribute
    String presetWorkspaceQualifiedName;
    /**
     * TBC
     */
    @Attribute
    String presetWorkspaceRegion;
    /**
     * TBC
     */
    @Attribute
    String presetWorkspaceStatus;

    /**
     * Builds the minimal object necessary to create a relationship to a PresetWorkspace, from a potentially
     * more-complete PresetWorkspace object.
     *
     * @return the minimal object necessary to relate to the PresetWorkspace
     * @throws InvalidRequestException if any of the minimal set of required properties for a PresetWorkspace relationship are not found in the initial object
     */
    @Override
    public PresetWorkspace trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all PresetWorkspace assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PresetWorkspace assets will be included.
     *
     * @return a fluent search that includes all PresetWorkspace assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all PresetWorkspace assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) PresetWorkspace assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all PresetWorkspace assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all PresetWorkspace assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) PresetWorkspaces will be included
     * @return a fluent search that includes all PresetWorkspace assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all PresetWorkspace assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) PresetWorkspaces will be included
     * @return a fluent search that includes all PresetWorkspace assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a PresetWorkspace by GUID. Use this to create a relationship to this PresetWorkspace,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the PresetWorkspace to reference
     * @return reference to a PresetWorkspace that can be used for defining a relationship to a PresetWorkspace
     */
    public static PresetWorkspace refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PresetWorkspace by GUID. Use this to create a relationship to this PresetWorkspace,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the PresetWorkspace to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PresetWorkspace that can be used for defining a relationship to a PresetWorkspace
     */
    public static PresetWorkspace refByGuid(String guid, Reference.SaveSemantic semantic) {
        return PresetWorkspace._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a PresetWorkspace by qualifiedName. Use this to create a relationship to this PresetWorkspace,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the PresetWorkspace to reference
     * @return reference to a PresetWorkspace that can be used for defining a relationship to a PresetWorkspace
     */
    public static PresetWorkspace refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a PresetWorkspace by qualifiedName. Use this to create a relationship to this PresetWorkspace,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the PresetWorkspace to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a PresetWorkspace that can be used for defining a relationship to a PresetWorkspace
     */
    public static PresetWorkspace refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return PresetWorkspace._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a PresetWorkspace by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the PresetWorkspace to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PresetWorkspace, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PresetWorkspace does not exist or the provided GUID is not a PresetWorkspace
     */
    @JsonIgnore
    public static PresetWorkspace get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a PresetWorkspace by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PresetWorkspace to retrieve, either its GUID or its full qualifiedName
     * @return the requested full PresetWorkspace, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PresetWorkspace does not exist or the provided GUID is not a PresetWorkspace
     */
    @JsonIgnore
    public static PresetWorkspace get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a PresetWorkspace by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the PresetWorkspace to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full PresetWorkspace, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the PresetWorkspace does not exist or the provided GUID is not a PresetWorkspace
     */
    @JsonIgnore
    public static PresetWorkspace get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof PresetWorkspace) {
                return (PresetWorkspace) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof PresetWorkspace) {
                return (PresetWorkspace) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) PresetWorkspace to active.
     *
     * @param qualifiedName for the PresetWorkspace
     * @return true if the PresetWorkspace is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) PresetWorkspace to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the PresetWorkspace
     * @return true if the PresetWorkspace is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Preset workspace.
     *
     * @param name of the workspace
     * @param connectionQualifiedName unique name of the connection through which the workspace is accessible
     * @return the minimal object necessary to create the workspace, as a builder
     */
    public static PresetWorkspaceBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return PresetWorkspace._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(connectionQualifiedName, name)).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.PRESET);
    }

    /**
     * Builds the minimal object necessary to update a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the minimal request necessary to update the PresetWorkspace, as a builder
     */
    public static PresetWorkspaceBuilder<?, ?> updater(String qualifiedName, String name) {
        return PresetWorkspace._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a PresetWorkspace, from a potentially
     * more-complete PresetWorkspace object.
     *
     * @return the minimal object necessary to update the PresetWorkspace, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for PresetWorkspace are not found in the initial object
     */
    @Override
    public PresetWorkspaceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Generate a unique Preset workspace name.
     *
     * @param connectionQualifiedName unique name of the connection
     * @param name for the workspace
     * @return a unique name for the workspace
     */
    private static String generateQualifiedName(String connectionQualifiedName, String name) {
        return connectionQualifiedName + "/" + name;
    }

    /**
     * Remove the system description from a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a PresetWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a PresetWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a PresetWorkspace.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PresetWorkspace's owners
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PresetWorkspace, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a PresetWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to update the PresetWorkspace's certificate
     * @param qualifiedName of the PresetWorkspace
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated PresetWorkspace, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PresetWorkspace) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a PresetWorkspace.
     *
     * @param client connectivity to the Atlan tenant from which to remove the PresetWorkspace's certificate
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a PresetWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to update the PresetWorkspace's announcement
     * @param qualifiedName of the PresetWorkspace
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetWorkspace) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a PresetWorkspace.
     *
     * @param client connectivity to the Atlan client from which to remove the PresetWorkspace's announcement
     * @param qualifiedName of the PresetWorkspace
     * @param name of the PresetWorkspace
     * @return the updated PresetWorkspace, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the PresetWorkspace.
     *
     * @param qualifiedName for the PresetWorkspace
     * @param name human-readable name of the PresetWorkspace
     * @param terms the list of terms to replace on the PresetWorkspace, or null to remove all terms from the PresetWorkspace
     * @return the PresetWorkspace that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the PresetWorkspace.
     *
     * @param client connectivity to the Atlan tenant on which to replace the PresetWorkspace's assigned terms
     * @param qualifiedName for the PresetWorkspace
     * @param name human-readable name of the PresetWorkspace
     * @param terms the list of terms to replace on the PresetWorkspace, or null to remove all terms from the PresetWorkspace
     * @return the PresetWorkspace that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the PresetWorkspace, without replacing existing terms linked to the PresetWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PresetWorkspace's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the PresetWorkspace
     * @param terms the list of terms to append to the PresetWorkspace
     * @return the PresetWorkspace that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the PresetWorkspace, without replacing existing terms linked to the PresetWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PresetWorkspace's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the PresetWorkspace
     * @param qualifiedName for the PresetWorkspace
     * @param terms the list of terms to append to the PresetWorkspace
     * @return the PresetWorkspace that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a PresetWorkspace, without replacing all existing terms linked to the PresetWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PresetWorkspace's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the PresetWorkspace
     * @param terms the list of terms to remove from the PresetWorkspace, which must be referenced by GUID
     * @return the PresetWorkspace that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a PresetWorkspace, without replacing all existing terms linked to the PresetWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PresetWorkspace's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the PresetWorkspace
     * @param qualifiedName for the PresetWorkspace
     * @param terms the list of terms to remove from the PresetWorkspace, which must be referenced by GUID
     * @return the PresetWorkspace that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static PresetWorkspace removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a PresetWorkspace, without replacing existing Atlan tags linked to the PresetWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PresetWorkspace's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PresetWorkspace
     */
    public static PresetWorkspace appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PresetWorkspace, without replacing existing Atlan tags linked to the PresetWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PresetWorkspace's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PresetWorkspace
     * @param qualifiedName of the PresetWorkspace
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated PresetWorkspace
     */
    public static PresetWorkspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PresetWorkspace) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a PresetWorkspace, without replacing existing Atlan tags linked to the PresetWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PresetWorkspace's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PresetWorkspace
     */
    public static PresetWorkspace appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a PresetWorkspace, without replacing existing Atlan tags linked to the PresetWorkspace.
     * Note: this operation must make two API calls — one to retrieve the PresetWorkspace's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the PresetWorkspace
     * @param qualifiedName of the PresetWorkspace
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated PresetWorkspace
     */
    public static PresetWorkspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PresetWorkspace) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a PresetWorkspace.
     *
     * @param qualifiedName of the PresetWorkspace
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PresetWorkspace
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a PresetWorkspace.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a PresetWorkspace
     * @param qualifiedName of the PresetWorkspace
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the PresetWorkspace
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class PresetWorkspaceBuilder<C extends PresetWorkspace, B extends PresetWorkspace.PresetWorkspaceBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetDashboardId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetDashboardQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IPresetDashboard> presetDashboards;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetWorkspaceClusterId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetWorkspaceDashboardCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetWorkspaceDatasetCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetWorkspaceDeploymentId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetWorkspaceHostname;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long presetWorkspaceId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean presetWorkspaceIsInMaintenanceMode;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean presetWorkspacePublicDashboardsAllowed;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetWorkspaceQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetWorkspaceRegion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String presetWorkspaceStatus;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            PresetWorkspace.PresetWorkspaceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final PresetWorkspace instance, final PresetWorkspace.PresetWorkspaceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.presetDashboardId(instance.presetDashboardId);
            b.presetDashboardQualifiedName(instance.presetDashboardQualifiedName);
            b.presetDashboards(instance.presetDashboards == null ? java.util.Collections.<IPresetDashboard>emptySortedSet() : instance.presetDashboards);
            b.presetWorkspaceClusterId(instance.presetWorkspaceClusterId);
            b.presetWorkspaceDashboardCount(instance.presetWorkspaceDashboardCount);
            b.presetWorkspaceDatasetCount(instance.presetWorkspaceDatasetCount);
            b.presetWorkspaceDeploymentId(instance.presetWorkspaceDeploymentId);
            b.presetWorkspaceHostname(instance.presetWorkspaceHostname);
            b.presetWorkspaceId(instance.presetWorkspaceId);
            b.presetWorkspaceIsInMaintenanceMode(instance.presetWorkspaceIsInMaintenanceMode);
            b.presetWorkspacePublicDashboardsAllowed(instance.presetWorkspacePublicDashboardsAllowed);
            b.presetWorkspaceQualifiedName(instance.presetWorkspaceQualifiedName);
            b.presetWorkspaceRegion(instance.presetWorkspaceRegion);
            b.presetWorkspaceStatus(instance.presetWorkspaceStatus);
        }

        /**
         * Fixed typeName for PresetWorkspaces.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Identifier of the dashboard in which this asset exists, in Preset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardId(final Long presetDashboardId) {
            this.presetDashboardId = presetDashboardId;
            return self();
        }

        /**
         * Unique name of the dashboard in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboardQualifiedName(final String presetDashboardQualifiedName) {
            this.presetDashboardQualifiedName = presetDashboardQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboard(final IPresetDashboard presetDashboard) {
            if (this.presetDashboards == null) this.presetDashboards = new java.util.ArrayList<IPresetDashboard>();
            this.presetDashboards.add(presetDashboard);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetDashboards(final java.util.Collection<? extends IPresetDashboard> presetDashboards) {
            if (presetDashboards == null) {
                throw new java.lang.NullPointerException("presetDashboards cannot be null");
            }
            if (this.presetDashboards == null) this.presetDashboards = new java.util.ArrayList<IPresetDashboard>();
            this.presetDashboards.addAll(presetDashboards);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPresetDashboards() {
            if (this.presetDashboards != null) this.presetDashboards.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceClusterId(final Long presetWorkspaceClusterId) {
            this.presetWorkspaceClusterId = presetWorkspaceClusterId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceDashboardCount(final Long presetWorkspaceDashboardCount) {
            this.presetWorkspaceDashboardCount = presetWorkspaceDashboardCount;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceDatasetCount(final Long presetWorkspaceDatasetCount) {
            this.presetWorkspaceDatasetCount = presetWorkspaceDatasetCount;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceDeploymentId(final Long presetWorkspaceDeploymentId) {
            this.presetWorkspaceDeploymentId = presetWorkspaceDeploymentId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceHostname(final String presetWorkspaceHostname) {
            this.presetWorkspaceHostname = presetWorkspaceHostname;
            return self();
        }

        /**
         * Identifier of the workspace in which this asset exists, in Preset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceId(final Long presetWorkspaceId) {
            this.presetWorkspaceId = presetWorkspaceId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceIsInMaintenanceMode(final Boolean presetWorkspaceIsInMaintenanceMode) {
            this.presetWorkspaceIsInMaintenanceMode = presetWorkspaceIsInMaintenanceMode;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspacePublicDashboardsAllowed(final Boolean presetWorkspacePublicDashboardsAllowed) {
            this.presetWorkspacePublicDashboardsAllowed = presetWorkspacePublicDashboardsAllowed;
            return self();
        }

        /**
         * Unique name of the workspace in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceQualifiedName(final String presetWorkspaceQualifiedName) {
            this.presetWorkspaceQualifiedName = presetWorkspaceQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceRegion(final String presetWorkspaceRegion) {
            this.presetWorkspaceRegion = presetWorkspaceRegion;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B presetWorkspaceStatus(final String presetWorkspaceStatus) {
            this.presetWorkspaceStatus = presetWorkspaceStatus;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "PresetWorkspace.PresetWorkspaceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", presetDashboardId=" + this.presetDashboardId + ", presetDashboardQualifiedName=" + this.presetDashboardQualifiedName + ", presetDashboards=" + this.presetDashboards + ", presetWorkspaceClusterId=" + this.presetWorkspaceClusterId + ", presetWorkspaceDashboardCount=" + this.presetWorkspaceDashboardCount + ", presetWorkspaceDatasetCount=" + this.presetWorkspaceDatasetCount + ", presetWorkspaceDeploymentId=" + this.presetWorkspaceDeploymentId + ", presetWorkspaceHostname=" + this.presetWorkspaceHostname + ", presetWorkspaceId=" + this.presetWorkspaceId + ", presetWorkspaceIsInMaintenanceMode=" + this.presetWorkspaceIsInMaintenanceMode + ", presetWorkspacePublicDashboardsAllowed=" + this.presetWorkspacePublicDashboardsAllowed + ", presetWorkspaceQualifiedName=" + this.presetWorkspaceQualifiedName + ", presetWorkspaceRegion=" + this.presetWorkspaceRegion + ", presetWorkspaceStatus=" + this.presetWorkspaceStatus + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class PresetWorkspaceBuilderImpl extends PresetWorkspace.PresetWorkspaceBuilder<PresetWorkspace, PresetWorkspace.PresetWorkspaceBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PresetWorkspaceBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected PresetWorkspace.PresetWorkspaceBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PresetWorkspace build() {
            return new PresetWorkspace(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected PresetWorkspace(final PresetWorkspace.PresetWorkspaceBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = PresetWorkspace.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.presetDashboardId = b.presetDashboardId;
        this.presetDashboardQualifiedName = b.presetDashboardQualifiedName;
        java.util.SortedSet<IPresetDashboard> presetDashboards = new java.util.TreeSet<IPresetDashboard>();
        if (b.presetDashboards != null) presetDashboards.addAll(b.presetDashboards);
        presetDashboards = java.util.Collections.unmodifiableSortedSet(presetDashboards);
        this.presetDashboards = presetDashboards;
        this.presetWorkspaceClusterId = b.presetWorkspaceClusterId;
        this.presetWorkspaceDashboardCount = b.presetWorkspaceDashboardCount;
        this.presetWorkspaceDatasetCount = b.presetWorkspaceDatasetCount;
        this.presetWorkspaceDeploymentId = b.presetWorkspaceDeploymentId;
        this.presetWorkspaceHostname = b.presetWorkspaceHostname;
        this.presetWorkspaceId = b.presetWorkspaceId;
        this.presetWorkspaceIsInMaintenanceMode = b.presetWorkspaceIsInMaintenanceMode;
        this.presetWorkspacePublicDashboardsAllowed = b.presetWorkspacePublicDashboardsAllowed;
        this.presetWorkspaceQualifiedName = b.presetWorkspaceQualifiedName;
        this.presetWorkspaceRegion = b.presetWorkspaceRegion;
        this.presetWorkspaceStatus = b.presetWorkspaceStatus;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static PresetWorkspace.PresetWorkspaceBuilder<?, ?> _internal() {
        return new PresetWorkspace.PresetWorkspaceBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PresetWorkspace.PresetWorkspaceBuilder<?, ?> toBuilder() {
        return new PresetWorkspace.PresetWorkspaceBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Identifier of the dashboard in which this asset exists, in Preset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetDashboardId() {
        return this.presetDashboardId;
    }

    /**
     * Unique name of the dashboard in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetDashboardQualifiedName() {
        return this.presetDashboardQualifiedName;
    }

    /**
     * Dashboards that exist within this workspace.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IPresetDashboard> getPresetDashboards() {
        return this.presetDashboards;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetWorkspaceClusterId() {
        return this.presetWorkspaceClusterId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetWorkspaceDashboardCount() {
        return this.presetWorkspaceDashboardCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetWorkspaceDatasetCount() {
        return this.presetWorkspaceDatasetCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetWorkspaceDeploymentId() {
        return this.presetWorkspaceDeploymentId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetWorkspaceHostname() {
        return this.presetWorkspaceHostname;
    }

    /**
     * Identifier of the workspace in which this asset exists, in Preset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getPresetWorkspaceId() {
        return this.presetWorkspaceId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPresetWorkspaceIsInMaintenanceMode() {
        return this.presetWorkspaceIsInMaintenanceMode;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getPresetWorkspacePublicDashboardsAllowed() {
        return this.presetWorkspacePublicDashboardsAllowed;
    }

    /**
     * Unique name of the workspace in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetWorkspaceQualifiedName() {
        return this.presetWorkspaceQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetWorkspaceRegion() {
        return this.presetWorkspaceRegion;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPresetWorkspaceStatus() {
        return this.presetWorkspaceStatus;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PresetWorkspace)) return false;
        final PresetWorkspace other = (PresetWorkspace) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$presetDashboardId = this.getPresetDashboardId();
        final java.lang.Object other$presetDashboardId = other.getPresetDashboardId();
        if (this$presetDashboardId == null ? other$presetDashboardId != null : !this$presetDashboardId.equals(other$presetDashboardId)) return false;
        final java.lang.Object this$presetWorkspaceClusterId = this.getPresetWorkspaceClusterId();
        final java.lang.Object other$presetWorkspaceClusterId = other.getPresetWorkspaceClusterId();
        if (this$presetWorkspaceClusterId == null ? other$presetWorkspaceClusterId != null : !this$presetWorkspaceClusterId.equals(other$presetWorkspaceClusterId)) return false;
        final java.lang.Object this$presetWorkspaceDashboardCount = this.getPresetWorkspaceDashboardCount();
        final java.lang.Object other$presetWorkspaceDashboardCount = other.getPresetWorkspaceDashboardCount();
        if (this$presetWorkspaceDashboardCount == null ? other$presetWorkspaceDashboardCount != null : !this$presetWorkspaceDashboardCount.equals(other$presetWorkspaceDashboardCount)) return false;
        final java.lang.Object this$presetWorkspaceDatasetCount = this.getPresetWorkspaceDatasetCount();
        final java.lang.Object other$presetWorkspaceDatasetCount = other.getPresetWorkspaceDatasetCount();
        if (this$presetWorkspaceDatasetCount == null ? other$presetWorkspaceDatasetCount != null : !this$presetWorkspaceDatasetCount.equals(other$presetWorkspaceDatasetCount)) return false;
        final java.lang.Object this$presetWorkspaceDeploymentId = this.getPresetWorkspaceDeploymentId();
        final java.lang.Object other$presetWorkspaceDeploymentId = other.getPresetWorkspaceDeploymentId();
        if (this$presetWorkspaceDeploymentId == null ? other$presetWorkspaceDeploymentId != null : !this$presetWorkspaceDeploymentId.equals(other$presetWorkspaceDeploymentId)) return false;
        final java.lang.Object this$presetWorkspaceId = this.getPresetWorkspaceId();
        final java.lang.Object other$presetWorkspaceId = other.getPresetWorkspaceId();
        if (this$presetWorkspaceId == null ? other$presetWorkspaceId != null : !this$presetWorkspaceId.equals(other$presetWorkspaceId)) return false;
        final java.lang.Object this$presetWorkspaceIsInMaintenanceMode = this.getPresetWorkspaceIsInMaintenanceMode();
        final java.lang.Object other$presetWorkspaceIsInMaintenanceMode = other.getPresetWorkspaceIsInMaintenanceMode();
        if (this$presetWorkspaceIsInMaintenanceMode == null ? other$presetWorkspaceIsInMaintenanceMode != null : !this$presetWorkspaceIsInMaintenanceMode.equals(other$presetWorkspaceIsInMaintenanceMode)) return false;
        final java.lang.Object this$presetWorkspacePublicDashboardsAllowed = this.getPresetWorkspacePublicDashboardsAllowed();
        final java.lang.Object other$presetWorkspacePublicDashboardsAllowed = other.getPresetWorkspacePublicDashboardsAllowed();
        if (this$presetWorkspacePublicDashboardsAllowed == null ? other$presetWorkspacePublicDashboardsAllowed != null : !this$presetWorkspacePublicDashboardsAllowed.equals(other$presetWorkspacePublicDashboardsAllowed)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        final java.lang.Object other$presetDashboardQualifiedName = other.getPresetDashboardQualifiedName();
        if (this$presetDashboardQualifiedName == null ? other$presetDashboardQualifiedName != null : !this$presetDashboardQualifiedName.equals(other$presetDashboardQualifiedName)) return false;
        final java.lang.Object this$presetDashboards = this.getPresetDashboards();
        final java.lang.Object other$presetDashboards = other.getPresetDashboards();
        if (this$presetDashboards == null ? other$presetDashboards != null : !this$presetDashboards.equals(other$presetDashboards)) return false;
        final java.lang.Object this$presetWorkspaceHostname = this.getPresetWorkspaceHostname();
        final java.lang.Object other$presetWorkspaceHostname = other.getPresetWorkspaceHostname();
        if (this$presetWorkspaceHostname == null ? other$presetWorkspaceHostname != null : !this$presetWorkspaceHostname.equals(other$presetWorkspaceHostname)) return false;
        final java.lang.Object this$presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        final java.lang.Object other$presetWorkspaceQualifiedName = other.getPresetWorkspaceQualifiedName();
        if (this$presetWorkspaceQualifiedName == null ? other$presetWorkspaceQualifiedName != null : !this$presetWorkspaceQualifiedName.equals(other$presetWorkspaceQualifiedName)) return false;
        final java.lang.Object this$presetWorkspaceRegion = this.getPresetWorkspaceRegion();
        final java.lang.Object other$presetWorkspaceRegion = other.getPresetWorkspaceRegion();
        if (this$presetWorkspaceRegion == null ? other$presetWorkspaceRegion != null : !this$presetWorkspaceRegion.equals(other$presetWorkspaceRegion)) return false;
        final java.lang.Object this$presetWorkspaceStatus = this.getPresetWorkspaceStatus();
        final java.lang.Object other$presetWorkspaceStatus = other.getPresetWorkspaceStatus();
        if (this$presetWorkspaceStatus == null ? other$presetWorkspaceStatus != null : !this$presetWorkspaceStatus.equals(other$presetWorkspaceStatus)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PresetWorkspace;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $presetDashboardId = this.getPresetDashboardId();
        result = result * PRIME + ($presetDashboardId == null ? 43 : $presetDashboardId.hashCode());
        final java.lang.Object $presetWorkspaceClusterId = this.getPresetWorkspaceClusterId();
        result = result * PRIME + ($presetWorkspaceClusterId == null ? 43 : $presetWorkspaceClusterId.hashCode());
        final java.lang.Object $presetWorkspaceDashboardCount = this.getPresetWorkspaceDashboardCount();
        result = result * PRIME + ($presetWorkspaceDashboardCount == null ? 43 : $presetWorkspaceDashboardCount.hashCode());
        final java.lang.Object $presetWorkspaceDatasetCount = this.getPresetWorkspaceDatasetCount();
        result = result * PRIME + ($presetWorkspaceDatasetCount == null ? 43 : $presetWorkspaceDatasetCount.hashCode());
        final java.lang.Object $presetWorkspaceDeploymentId = this.getPresetWorkspaceDeploymentId();
        result = result * PRIME + ($presetWorkspaceDeploymentId == null ? 43 : $presetWorkspaceDeploymentId.hashCode());
        final java.lang.Object $presetWorkspaceId = this.getPresetWorkspaceId();
        result = result * PRIME + ($presetWorkspaceId == null ? 43 : $presetWorkspaceId.hashCode());
        final java.lang.Object $presetWorkspaceIsInMaintenanceMode = this.getPresetWorkspaceIsInMaintenanceMode();
        result = result * PRIME + ($presetWorkspaceIsInMaintenanceMode == null ? 43 : $presetWorkspaceIsInMaintenanceMode.hashCode());
        final java.lang.Object $presetWorkspacePublicDashboardsAllowed = this.getPresetWorkspacePublicDashboardsAllowed();
        result = result * PRIME + ($presetWorkspacePublicDashboardsAllowed == null ? 43 : $presetWorkspacePublicDashboardsAllowed.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        result = result * PRIME + ($presetDashboardQualifiedName == null ? 43 : $presetDashboardQualifiedName.hashCode());
        final java.lang.Object $presetDashboards = this.getPresetDashboards();
        result = result * PRIME + ($presetDashboards == null ? 43 : $presetDashboards.hashCode());
        final java.lang.Object $presetWorkspaceHostname = this.getPresetWorkspaceHostname();
        result = result * PRIME + ($presetWorkspaceHostname == null ? 43 : $presetWorkspaceHostname.hashCode());
        final java.lang.Object $presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        result = result * PRIME + ($presetWorkspaceQualifiedName == null ? 43 : $presetWorkspaceQualifiedName.hashCode());
        final java.lang.Object $presetWorkspaceRegion = this.getPresetWorkspaceRegion();
        result = result * PRIME + ($presetWorkspaceRegion == null ? 43 : $presetWorkspaceRegion.hashCode());
        final java.lang.Object $presetWorkspaceStatus = this.getPresetWorkspaceStatus();
        result = result * PRIME + ($presetWorkspaceStatus == null ? 43 : $presetWorkspaceStatus.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "PresetWorkspace(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", presetDashboardId=" + this.getPresetDashboardId() + ", presetDashboardQualifiedName=" + this.getPresetDashboardQualifiedName() + ", presetDashboards=" + this.getPresetDashboards() + ", presetWorkspaceClusterId=" + this.getPresetWorkspaceClusterId() + ", presetWorkspaceDashboardCount=" + this.getPresetWorkspaceDashboardCount() + ", presetWorkspaceDatasetCount=" + this.getPresetWorkspaceDatasetCount() + ", presetWorkspaceDeploymentId=" + this.getPresetWorkspaceDeploymentId() + ", presetWorkspaceHostname=" + this.getPresetWorkspaceHostname() + ", presetWorkspaceId=" + this.getPresetWorkspaceId() + ", presetWorkspaceIsInMaintenanceMode=" + this.getPresetWorkspaceIsInMaintenanceMode() + ", presetWorkspacePublicDashboardsAllowed=" + this.getPresetWorkspacePublicDashboardsAllowed() + ", presetWorkspaceQualifiedName=" + this.getPresetWorkspaceQualifiedName() + ", presetWorkspaceRegion=" + this.getPresetWorkspaceRegion() + ", presetWorkspaceStatus=" + this.getPresetWorkspaceStatus() + ")";
    }

    /**
     * Fixed typeName for PresetWorkspaces.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
