// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AssetFilterGroup;
import com.atlan.model.enums.AssetSidebarTab;
import com.atlan.model.enums.AuthPolicyCategory;
import com.atlan.model.enums.AuthPolicyResourceCategory;
import com.atlan.model.enums.AuthPolicyType;
import com.atlan.model.enums.DataAction;
import com.atlan.model.enums.PurposeMetadataAction;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Atlan Type representing a Purpose model
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class Purpose extends Asset implements IPurpose, IAccessControl, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Purpose.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Purpose";
    /**
     * Fixed typeName for Purposes.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    String channelLink;
    /**
     * TBC
     */
    @Attribute
    String defaultNavigation;
    /**
     * TBC
     */
    @Attribute
    SortedSet<AssetFilterGroup> denyAssetFilters;
    /**
     * TBC
     */
    @Attribute
    SortedSet<AssetSidebarTab> denyAssetTabs;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> denyAssetTypes;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> denyCustomMetadataGuids;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> denyNavigationPages;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> displayPreferences;
    /**
     * TBC
     */
    @Attribute
    Boolean isAccessControlEnabled;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAuthPolicy> policies;
    /**
     * TBC
     */
    @Attribute
    @JsonProperty("purposeClassifications")
    SortedSet<String> purposeAtlanTags;

    /**
     * Builds the minimal object necessary to create a relationship to a Purpose, from a potentially
     * more-complete Purpose object.
     *
     * @return the minimal object necessary to relate to the Purpose
     * @throws InvalidRequestException if any of the minimal set of required properties for a Purpose relationship are not found in the initial object
     */
    @Override
    public Purpose trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Purpose assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Purpose assets will be included.
     *
     * @return a fluent search that includes all Purpose assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Purpose assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Purpose assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Purpose assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Purpose assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Purposes will be included
     * @return a fluent search that includes all Purpose assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Purpose assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Purposes will be included
     * @return a fluent search that includes all Purpose assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Purpose by GUID. Use this to create a relationship to this Purpose,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Purpose to reference
     * @return reference to a Purpose that can be used for defining a relationship to a Purpose
     */
    public static Purpose refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Purpose by GUID. Use this to create a relationship to this Purpose,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Purpose to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Purpose that can be used for defining a relationship to a Purpose
     */
    public static Purpose refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Purpose._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Purpose by qualifiedName. Use this to create a relationship to this Purpose,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Purpose to reference
     * @return reference to a Purpose that can be used for defining a relationship to a Purpose
     */
    public static Purpose refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Purpose by qualifiedName. Use this to create a relationship to this Purpose,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Purpose to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Purpose that can be used for defining a relationship to a Purpose
     */
    public static Purpose refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Purpose._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Purpose by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Purpose to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Purpose, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Purpose does not exist or the provided GUID is not a Purpose
     */
    @JsonIgnore
    public static Purpose get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Purpose by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Purpose to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Purpose, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Purpose does not exist or the provided GUID is not a Purpose
     */
    @JsonIgnore
    public static Purpose get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Purpose by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Purpose to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Purpose, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Purpose does not exist or the provided GUID is not a Purpose
     */
    @JsonIgnore
    public static Purpose get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Purpose) {
                return (Purpose) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Purpose) {
                return (Purpose) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Purpose to active.
     *
     * @param qualifiedName for the Purpose
     * @return true if the Purpose is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Purpose to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Purpose
     * @return true if the Purpose is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a Purpose.
     *
     * @param name of the Purpose
     * @param atlanTags Atlan tags on which this purpose should be applied
     * @return the minimal request necessary to create the Purpose, as a builder
     * @throws InvalidRequestException if at least one Atlan tag is not specified
     */
    public static PurposeBuilder<?, ?> creator(String name, Collection<String> atlanTags) throws InvalidRequestException {
        if (atlanTags == null || atlanTags.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_TAG_FOR_PURPOSE);
        }
        return Purpose._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(name).name(name).displayName(name).isAccessControlEnabled(true).description("").purposeAtlanTags(atlanTags);
    }

    /**
     * Builds the minimal object necessary to update a Purpose.
     *
     * @param qualifiedName of the Purpose
     * @param name of the Purpose
     * @param isEnabled whether the Purpose should be activated (true) or deactivated (false)
     * @return the minimal request necessary to update the Purpose, as a builder
     */
    public static PurposeBuilder<?, ?> updater(String qualifiedName, String name, boolean isEnabled) {
        return Purpose._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name).isAccessControlEnabled(isEnabled);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Purpose, from a potentially
     * more-complete Purpose object.
     *
     * @return the minimal object necessary to update the Purpose, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Purpose are not found in the initial object
     */
    @Override
    public PurposeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        if (this.getIsAccessControlEnabled() == null) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, "isAccessControlEnabled");
        }
        return updater(this.getQualifiedName(), this.getName(), this.getIsAccessControlEnabled());
    }

    /**
     * Find a Purpose by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the purpose, if found.
     *
     * @param name of the Purpose
     * @return all Purposes with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the Purpose does not exist
     */
    public static List<Purpose> findByName(String name) throws AtlanException {
        return findByName(name, (List<AtlanField>) null);
    }

    /**
     * Find a Purpose by its human-readable name.
     *
     * @param name of the Purpose
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the Purpose
     * @return all Purposes with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the Purpose does not exist
     */
    public static List<Purpose> findByName(String name, Collection<String> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, attributes);
    }

    /**
     * Find a Purpose by its human-readable name.
     *
     * @param name of the Purpose
     * @param attributes an optional collection of attributes (checked) to retrieve for the Purpose
     * @return all Purposes with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the Purpose does not exist
     */
    public static List<Purpose> findByName(String name, List<AtlanField> attributes) throws AtlanException {
        return findByName(Atlan.getDefaultClient(), name, attributes);
    }

    /**
     * Find a Purpose by its human-readable name. Only the bare minimum set of attributes and no
     * relationships will be retrieved for the purpose, if found.
     *
     * @param client connectivity to the Atlan tenant in which to search for the purpose
     * @param name of the Purpose
     * @return all Purposes with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the Purpose does not exist
     */
    public static List<Purpose> findByName(AtlanClient client, String name) throws AtlanException {
        return findByName(client, name, (List<AtlanField>) null);
    }

    /**
     * Find a Purpose by its human-readable name.
     *
     * @param client connectivity to the Atlan tenant in which to search for the purpose
     * @param name of the Purpose
     * @param attributes an optional collection of attributes (unchecked) to retrieve for the Purpose
     * @return all Purposes with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the Purpose does not exist
     */
    public static List<Purpose> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        List<Purpose> results = new ArrayList<>();
        Purpose.select(client).where(Purpose.NAME.eq(name))._includesOnResults(attributes == null ? Collections.emptyList() : attributes).stream().filter(a -> a instanceof Purpose).forEach(p -> results.add((Purpose) p));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.PURPOSE_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    /**
     * Find a Purpose by its human-readable name.
     *
     * @param client connectivity to the Atlan tenant in which to search for the Purpose
     * @param name of the Purpose
     * @param attributes an optional list of attributes (checked) to retrieve for the Purpose
     * @return all Purposes with that name, if found
     * @throws AtlanException on any API problems
     * @throws NotFoundException if the Purpose does not exist
     */
    public static List<Purpose> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        List<Purpose> results = new ArrayList<>();
        Purpose.select(client).where(Purpose.NAME.eq(name)).includesOnResults(attributes == null ? Collections.emptyList() : attributes).stream().filter(a -> a instanceof Purpose).forEach(p -> results.add((Purpose) p));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.PURPOSE_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    /**
     * Builds the minimal object necessary to create a metadata policy for a Purpose.
     *
     * @param name of the policy
     * @param purposeId unique identifier (GUID) of the purpose for which to create this metadata policy
     * @param policyType type of policy (for example allow vs deny)
     * @param actions to include in the policy
     * @param policyGroups groups to whom this policy applies, given as internal group names (at least one of these or policyUsers must be specified)
     * @param policyUsers users to whom this policy applies, given as usernames (at least one of these or policyGroups must be specified)
     * @param allUsers whether to apply this policy to all users (true) or not (false). If true this will override the other users and groups parameters.
     * @return the minimal request necessary to create the metadata policy for the Purpose, as a builder
     * @throws AtlanException on any other error related to the request, such as an inability to find the specified users or groups
     */
    public static AuthPolicy.AuthPolicyBuilder<?, ?> createMetadataPolicy(String name, String purposeId, AuthPolicyType policyType, Collection<PurposeMetadataAction> actions, Collection<String> policyGroups, Collection<String> policyUsers, boolean allUsers) throws AtlanException {
        return createMetadataPolicy(Atlan.getDefaultClient(), name, purposeId, policyType, actions, policyGroups, policyUsers, allUsers);
    }

    /**
     * Builds the minimal object necessary to create a metadata policy for a Purpose.
     *
     * @param client connectivity to the Atlan tenant on which the policy is intended to be created
     * @param name of the policy
     * @param purposeId unique identifier (GUID) of the purpose for which to create this metadata policy
     * @param policyType type of policy (for example allow vs deny)
     * @param actions to include in the policy
     * @param policyGroups groups to whom this policy applies, given as internal group names (at least one of these or policyUsers must be specified)
     * @param policyUsers users to whom this policy applies, given as usernames (at least one of these or policyGroups must be specified)
     * @param allUsers whether to apply this policy to all users (true) or not (false). If true this will override the other users and groups parameters.
     * @return the minimal request necessary to create the metadata policy for the Purpose, as a builder
     * @throws AtlanException on any other error related to the request, such as an inability to find the specified users or groups
     */
    public static AuthPolicy.AuthPolicyBuilder<?, ?> createMetadataPolicy(AtlanClient client, String name, String purposeId, AuthPolicyType policyType, Collection<PurposeMetadataAction> actions, Collection<String> policyGroups, Collection<String> policyUsers, boolean allUsers) throws AtlanException {
        boolean targetFound = false;
        AuthPolicy.AuthPolicyBuilder<?, ?> builder = AuthPolicy.creator(name).policyActions(actions).policyCategory(AuthPolicyCategory.PURPOSE).policyType(policyType).policyResourceCategory(AuthPolicyResourceCategory.TAG).policyServiceName("atlas_tag").policySubCategory("metadata").accessControl(Purpose.refByGuid(purposeId));
        if (allUsers) {
            targetFound = true;
            builder.policyGroup("public");
        } else {
            if (policyGroups != null && !policyGroups.isEmpty()) {
                for (String groupName : policyGroups) {
                    client.getGroupCache().getIdForName(groupName);
                }
                targetFound = true;
                builder.policyGroups(policyGroups);
            } else {
                builder.nullField("policyGroups");
            }
            if (policyUsers != null && !policyUsers.isEmpty()) {
                for (String userName : policyUsers) {
                    client.getUserCache().getIdForName(userName);
                }
                targetFound = true;
                builder.policyUsers(policyUsers);
            } else {
                builder.nullField("policyUsers");
            }
        }
        if (targetFound) {
            return builder;
        } else {
            throw new InvalidRequestException(ErrorCode.NO_USERS_FOR_POLICY);
        }
    }

    /**
     * Builds the minimal object necessary to create a data policy for a Purpose.
     *
     * @param name of the policy
     * @param purposeId unique identifier (GUID) of the purpose for which to create this data policy
     * @param policyType type of policy (for example allow vs deny)
     * @param policyGroups groups to whom this policy applies, given as internal group names (at least one of these or policyUsers must be specified)
     * @param policyUsers users to whom this policy applies, given as usernames (at least one of these or policyGroups must be specified)
     * @param allUsers whether to apply this policy to all users (true) or not (false). If true this will override the other users and groups parameters.
     * @return the minimal request necessary to create the data policy for the Purpose, as a builder
     * @throws AtlanException on any other error related to the request, such as an inability to find the specified users or groups
     */
    public static AuthPolicy.AuthPolicyBuilder<?, ?> createDataPolicy(String name, String purposeId, AuthPolicyType policyType, Collection<String> policyGroups, Collection<String> policyUsers, boolean allUsers) throws AtlanException {
        return createDataPolicy(Atlan.getDefaultClient(), name, purposeId, policyType, policyGroups, policyUsers, allUsers);
    }

    /**
     * Builds the minimal object necessary to create a data policy for a Purpose.
     *
     * @param client connectivity to the Atlan tenant on which the policy is intended to be created
     * @param name of the policy
     * @param purposeId unique identifier (GUID) of the purpose for which to create this data policy
     * @param policyType type of policy (for example allow vs deny)
     * @param policyGroups groups to whom this policy applies, given as internal group names (at least one of these or policyUsers must be specified)
     * @param policyUsers users to whom this policy applies, given as usernames (at least one of these or policyGroups must be specified)
     * @param allUsers whether to apply this policy to all users (true) or not (false). If true this will override the other users and groups parameters.
     * @return the minimal request necessary to create the data policy for the Purpose, as a builder
     * @throws AtlanException on any other error related to the request, such as an inability to find the specified users or groups
     */
    public static AuthPolicy.AuthPolicyBuilder<?, ?> createDataPolicy(AtlanClient client, String name, String purposeId, AuthPolicyType policyType, Collection<String> policyGroups, Collection<String> policyUsers, boolean allUsers) throws AtlanException {
        boolean targetFound = false;
        AuthPolicy.AuthPolicyBuilder<?, ?> builder = AuthPolicy.creator(name).policyAction(DataAction.SELECT).policyCategory(AuthPolicyCategory.PURPOSE).policyType(policyType).policyResourceCategory(AuthPolicyResourceCategory.TAG).policyServiceName("atlas_tag").policySubCategory("data").accessControl(Purpose.refByGuid(purposeId));
        if (allUsers) {
            targetFound = true;
            builder.policyGroup("public");
        } else {
            if (policyGroups != null && !policyGroups.isEmpty()) {
                for (String groupName : policyGroups) {
                    client.getGroupCache().getIdForName(groupName);
                }
                targetFound = true;
                builder.policyGroups(policyGroups);
            } else {
                builder.nullField("policyGroups");
            }
            if (policyUsers != null && !policyUsers.isEmpty()) {
                for (String userName : policyUsers) {
                    client.getUserCache().getIdForName(userName);
                }
                targetFound = true;
                builder.policyUsers(policyUsers);
            } else {
                builder.nullField("policyUsers");
            }
        }
        if (targetFound) {
            return builder;
        } else {
            throw new InvalidRequestException(ErrorCode.NO_USERS_FOR_POLICY);
        }
    }

    /**
     * Remove the system description from a Purpose.
     *
     * @param qualifiedName of the Purpose
     * @param name of the Purpose
     * @param isEnabled whether the Purpose should be activated (true) or deactivated (false)
     * @return the updated Purpose, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Purpose removeDescription(String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name, isEnabled);
    }

    /**
     * Remove the system description from a Purpose.
     *
     * @param client connectivity to the Atlan tenant from which to remove this Purpose's description
     * @param qualifiedName of the Purpose
     * @param name of the Purpose
     * @param isEnabled whether the Purpose should be activated (true) or deactivated (false)
     * @return the updated Purpose, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Purpose removeDescription(AtlanClient client, String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return (Purpose) Asset.removeDescription(client, updater(qualifiedName, name, isEnabled));
    }

    /**
     * Remove the user's description from a Purpose.
     *
     * @param qualifiedName of the Purpose
     * @param name of the Purpose
     * @param isEnabled whether the Purpose should be activated (true) or deactivated (false)
     * @return the updated Purpose, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Purpose removeUserDescription(String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name, isEnabled);
    }

    /**
     * Remove the user's description from a Purpose.
     *
     * @param client connectivity to the Atlan tenant from which to remove this Purpose's description
     * @param qualifiedName of the Purpose
     * @param name of the Purpose
     * @param isEnabled whether the Purpose should be activated (true) or deactivated (false)
     * @return the updated Purpose, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Purpose removeUserDescription(AtlanClient client, String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return (Purpose) Asset.removeUserDescription(client, updater(qualifiedName, name, isEnabled));
    }

    /**
     * Add Atlan tags to a Purpose, without replacing existing Atlan tags linked to the Purpose.
     * Note: this operation must make two API calls — one to retrieve the Purpose's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Purpose
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Purpose
     */
    public static Purpose appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Purpose, without replacing existing Atlan tags linked to the Purpose.
     * Note: this operation must make two API calls — one to retrieve the Purpose's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Purpose
     * @param qualifiedName of the Purpose
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Purpose
     */
    public static Purpose appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Purpose) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Purpose, without replacing existing Atlan tags linked to the Purpose.
     * Note: this operation must make two API calls — one to retrieve the Purpose's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Purpose
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Purpose
     */
    public static Purpose appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Purpose, without replacing existing Atlan tags linked to the Purpose.
     * Note: this operation must make two API calls — one to retrieve the Purpose's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Purpose
     * @param qualifiedName of the Purpose
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Purpose
     */
    public static Purpose appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Purpose) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Purpose.
     *
     * @param qualifiedName of the Purpose
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Purpose
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Purpose.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Purpose
     * @param qualifiedName of the Purpose
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Purpose
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class PurposeBuilder<C extends Purpose, B extends Purpose.PurposeBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String channelLink;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String defaultNavigation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AssetFilterGroup> denyAssetFilters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AssetSidebarTab> denyAssetTabs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> denyAssetTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> denyCustomMetadataGuids;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> denyNavigationPages;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> displayPreferences;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isAccessControlEnabled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAuthPolicy> policies;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> purposeAtlanTags;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Purpose.PurposeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Purpose instance, final Purpose.PurposeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.channelLink(instance.channelLink);
            b.defaultNavigation(instance.defaultNavigation);
            b.denyAssetFilters(instance.denyAssetFilters == null ? java.util.Collections.<AssetFilterGroup>emptySortedSet() : instance.denyAssetFilters);
            b.denyAssetTabs(instance.denyAssetTabs == null ? java.util.Collections.<AssetSidebarTab>emptySortedSet() : instance.denyAssetTabs);
            b.denyAssetTypes(instance.denyAssetTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.denyAssetTypes);
            b.denyCustomMetadataGuids(instance.denyCustomMetadataGuids == null ? java.util.Collections.<String>emptySortedSet() : instance.denyCustomMetadataGuids);
            b.denyNavigationPages(instance.denyNavigationPages == null ? java.util.Collections.<String>emptySortedSet() : instance.denyNavigationPages);
            b.displayPreferences(instance.displayPreferences == null ? java.util.Collections.<String>emptySortedSet() : instance.displayPreferences);
            b.isAccessControlEnabled(instance.isAccessControlEnabled);
            b.policies(instance.policies == null ? java.util.Collections.<IAuthPolicy>emptySortedSet() : instance.policies);
            b.purposeAtlanTags(instance.purposeAtlanTags == null ? java.util.Collections.<String>emptySortedSet() : instance.purposeAtlanTags);
        }

        /**
         * Fixed typeName for Purposes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B channelLink(final String channelLink) {
            this.channelLink = channelLink;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultNavigation(final String defaultNavigation) {
            this.defaultNavigation = defaultNavigation;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetFilter(final AssetFilterGroup denyAssetFilter) {
            if (this.denyAssetFilters == null) this.denyAssetFilters = new java.util.ArrayList<AssetFilterGroup>();
            this.denyAssetFilters.add(denyAssetFilter);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetFilters(final java.util.Collection<? extends AssetFilterGroup> denyAssetFilters) {
            if (denyAssetFilters == null) {
                throw new java.lang.NullPointerException("denyAssetFilters cannot be null");
            }
            if (this.denyAssetFilters == null) this.denyAssetFilters = new java.util.ArrayList<AssetFilterGroup>();
            this.denyAssetFilters.addAll(denyAssetFilters);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyAssetFilters() {
            if (this.denyAssetFilters != null) this.denyAssetFilters.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetTab(final AssetSidebarTab denyAssetTab) {
            if (this.denyAssetTabs == null) this.denyAssetTabs = new java.util.ArrayList<AssetSidebarTab>();
            this.denyAssetTabs.add(denyAssetTab);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetTabs(final java.util.Collection<? extends AssetSidebarTab> denyAssetTabs) {
            if (denyAssetTabs == null) {
                throw new java.lang.NullPointerException("denyAssetTabs cannot be null");
            }
            if (this.denyAssetTabs == null) this.denyAssetTabs = new java.util.ArrayList<AssetSidebarTab>();
            this.denyAssetTabs.addAll(denyAssetTabs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyAssetTabs() {
            if (this.denyAssetTabs != null) this.denyAssetTabs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetType(final String denyAssetType) {
            if (this.denyAssetTypes == null) this.denyAssetTypes = new java.util.ArrayList<String>();
            this.denyAssetTypes.add(denyAssetType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetTypes(final java.util.Collection<? extends String> denyAssetTypes) {
            if (denyAssetTypes == null) {
                throw new java.lang.NullPointerException("denyAssetTypes cannot be null");
            }
            if (this.denyAssetTypes == null) this.denyAssetTypes = new java.util.ArrayList<String>();
            this.denyAssetTypes.addAll(denyAssetTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyAssetTypes() {
            if (this.denyAssetTypes != null) this.denyAssetTypes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyCustomMetadataGuid(final String denyCustomMetadataGuid) {
            if (this.denyCustomMetadataGuids == null) this.denyCustomMetadataGuids = new java.util.ArrayList<String>();
            this.denyCustomMetadataGuids.add(denyCustomMetadataGuid);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyCustomMetadataGuids(final java.util.Collection<? extends String> denyCustomMetadataGuids) {
            if (denyCustomMetadataGuids == null) {
                throw new java.lang.NullPointerException("denyCustomMetadataGuids cannot be null");
            }
            if (this.denyCustomMetadataGuids == null) this.denyCustomMetadataGuids = new java.util.ArrayList<String>();
            this.denyCustomMetadataGuids.addAll(denyCustomMetadataGuids);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyCustomMetadataGuids() {
            if (this.denyCustomMetadataGuids != null) this.denyCustomMetadataGuids.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyNavigationPage(final String denyNavigationPage) {
            if (this.denyNavigationPages == null) this.denyNavigationPages = new java.util.ArrayList<String>();
            this.denyNavigationPages.add(denyNavigationPage);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyNavigationPages(final java.util.Collection<? extends String> denyNavigationPages) {
            if (denyNavigationPages == null) {
                throw new java.lang.NullPointerException("denyNavigationPages cannot be null");
            }
            if (this.denyNavigationPages == null) this.denyNavigationPages = new java.util.ArrayList<String>();
            this.denyNavigationPages.addAll(denyNavigationPages);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyNavigationPages() {
            if (this.denyNavigationPages != null) this.denyNavigationPages.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayPreference(final String displayPreference) {
            if (this.displayPreferences == null) this.displayPreferences = new java.util.ArrayList<String>();
            this.displayPreferences.add(displayPreference);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayPreferences(final java.util.Collection<? extends String> displayPreferences) {
            if (displayPreferences == null) {
                throw new java.lang.NullPointerException("displayPreferences cannot be null");
            }
            if (this.displayPreferences == null) this.displayPreferences = new java.util.ArrayList<String>();
            this.displayPreferences.addAll(displayPreferences);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDisplayPreferences() {
            if (this.displayPreferences != null) this.displayPreferences.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isAccessControlEnabled(final Boolean isAccessControlEnabled) {
            this.isAccessControlEnabled = isAccessControlEnabled;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policy(final IAuthPolicy policy) {
            if (this.policies == null) this.policies = new java.util.ArrayList<IAuthPolicy>();
            this.policies.add(policy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policies(final java.util.Collection<? extends IAuthPolicy> policies) {
            if (policies == null) {
                throw new java.lang.NullPointerException("policies cannot be null");
            }
            if (this.policies == null) this.policies = new java.util.ArrayList<IAuthPolicy>();
            this.policies.addAll(policies);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicies() {
            if (this.policies != null) this.policies.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B purposeAtlanTag(final String purposeAtlanTag) {
            if (this.purposeAtlanTags == null) this.purposeAtlanTags = new java.util.ArrayList<String>();
            this.purposeAtlanTags.add(purposeAtlanTag);
            return self();
        }

        @JsonProperty("purposeClassifications")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B purposeAtlanTags(final java.util.Collection<? extends String> purposeAtlanTags) {
            if (purposeAtlanTags == null) {
                throw new java.lang.NullPointerException("purposeAtlanTags cannot be null");
            }
            if (this.purposeAtlanTags == null) this.purposeAtlanTags = new java.util.ArrayList<String>();
            this.purposeAtlanTags.addAll(purposeAtlanTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPurposeAtlanTags() {
            if (this.purposeAtlanTags != null) this.purposeAtlanTags.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Purpose.PurposeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", channelLink=" + this.channelLink + ", defaultNavigation=" + this.defaultNavigation + ", denyAssetFilters=" + this.denyAssetFilters + ", denyAssetTabs=" + this.denyAssetTabs + ", denyAssetTypes=" + this.denyAssetTypes + ", denyCustomMetadataGuids=" + this.denyCustomMetadataGuids + ", denyNavigationPages=" + this.denyNavigationPages + ", displayPreferences=" + this.displayPreferences + ", isAccessControlEnabled=" + this.isAccessControlEnabled + ", policies=" + this.policies + ", purposeAtlanTags=" + this.purposeAtlanTags + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class PurposeBuilderImpl extends Purpose.PurposeBuilder<Purpose, Purpose.PurposeBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PurposeBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Purpose.PurposeBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Purpose build() {
            return new Purpose(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Purpose(final Purpose.PurposeBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Purpose.$default$typeName();
        this.channelLink = b.channelLink;
        this.defaultNavigation = b.defaultNavigation;
        java.util.SortedSet<AssetFilterGroup> denyAssetFilters = new java.util.TreeSet<AssetFilterGroup>();
        if (b.denyAssetFilters != null) denyAssetFilters.addAll(b.denyAssetFilters);
        denyAssetFilters = java.util.Collections.unmodifiableSortedSet(denyAssetFilters);
        this.denyAssetFilters = denyAssetFilters;
        java.util.SortedSet<AssetSidebarTab> denyAssetTabs = new java.util.TreeSet<AssetSidebarTab>();
        if (b.denyAssetTabs != null) denyAssetTabs.addAll(b.denyAssetTabs);
        denyAssetTabs = java.util.Collections.unmodifiableSortedSet(denyAssetTabs);
        this.denyAssetTabs = denyAssetTabs;
        java.util.SortedSet<String> denyAssetTypes = new java.util.TreeSet<String>();
        if (b.denyAssetTypes != null) denyAssetTypes.addAll(b.denyAssetTypes);
        denyAssetTypes = java.util.Collections.unmodifiableSortedSet(denyAssetTypes);
        this.denyAssetTypes = denyAssetTypes;
        java.util.SortedSet<String> denyCustomMetadataGuids = new java.util.TreeSet<String>();
        if (b.denyCustomMetadataGuids != null) denyCustomMetadataGuids.addAll(b.denyCustomMetadataGuids);
        denyCustomMetadataGuids = java.util.Collections.unmodifiableSortedSet(denyCustomMetadataGuids);
        this.denyCustomMetadataGuids = denyCustomMetadataGuids;
        java.util.SortedSet<String> denyNavigationPages = new java.util.TreeSet<String>();
        if (b.denyNavigationPages != null) denyNavigationPages.addAll(b.denyNavigationPages);
        denyNavigationPages = java.util.Collections.unmodifiableSortedSet(denyNavigationPages);
        this.denyNavigationPages = denyNavigationPages;
        java.util.SortedSet<String> displayPreferences = new java.util.TreeSet<String>();
        if (b.displayPreferences != null) displayPreferences.addAll(b.displayPreferences);
        displayPreferences = java.util.Collections.unmodifiableSortedSet(displayPreferences);
        this.displayPreferences = displayPreferences;
        this.isAccessControlEnabled = b.isAccessControlEnabled;
        java.util.SortedSet<IAuthPolicy> policies = new java.util.TreeSet<IAuthPolicy>();
        if (b.policies != null) policies.addAll(b.policies);
        policies = java.util.Collections.unmodifiableSortedSet(policies);
        this.policies = policies;
        java.util.SortedSet<String> purposeAtlanTags = new java.util.TreeSet<String>();
        if (b.purposeAtlanTags != null) purposeAtlanTags.addAll(b.purposeAtlanTags);
        purposeAtlanTags = java.util.Collections.unmodifiableSortedSet(purposeAtlanTags);
        this.purposeAtlanTags = purposeAtlanTags;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Purpose.PurposeBuilder<?, ?> _internal() {
        return new Purpose.PurposeBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Purpose.PurposeBuilder<?, ?> toBuilder() {
        return new Purpose.PurposeBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getChannelLink() {
        return this.channelLink;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultNavigation() {
        return this.defaultNavigation;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<AssetFilterGroup> getDenyAssetFilters() {
        return this.denyAssetFilters;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<AssetSidebarTab> getDenyAssetTabs() {
        return this.denyAssetTabs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDenyAssetTypes() {
        return this.denyAssetTypes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDenyCustomMetadataGuids() {
        return this.denyCustomMetadataGuids;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDenyNavigationPages() {
        return this.denyNavigationPages;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDisplayPreferences() {
        return this.displayPreferences;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsAccessControlEnabled() {
        return this.isAccessControlEnabled;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAuthPolicy> getPolicies() {
        return this.policies;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPurposeAtlanTags() {
        return this.purposeAtlanTags;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Purpose)) return false;
        final Purpose other = (Purpose) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isAccessControlEnabled = this.getIsAccessControlEnabled();
        final java.lang.Object other$isAccessControlEnabled = other.getIsAccessControlEnabled();
        if (this$isAccessControlEnabled == null ? other$isAccessControlEnabled != null : !this$isAccessControlEnabled.equals(other$isAccessControlEnabled)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$channelLink = this.getChannelLink();
        final java.lang.Object other$channelLink = other.getChannelLink();
        if (this$channelLink == null ? other$channelLink != null : !this$channelLink.equals(other$channelLink)) return false;
        final java.lang.Object this$defaultNavigation = this.getDefaultNavigation();
        final java.lang.Object other$defaultNavigation = other.getDefaultNavigation();
        if (this$defaultNavigation == null ? other$defaultNavigation != null : !this$defaultNavigation.equals(other$defaultNavigation)) return false;
        final java.lang.Object this$denyAssetFilters = this.getDenyAssetFilters();
        final java.lang.Object other$denyAssetFilters = other.getDenyAssetFilters();
        if (this$denyAssetFilters == null ? other$denyAssetFilters != null : !this$denyAssetFilters.equals(other$denyAssetFilters)) return false;
        final java.lang.Object this$denyAssetTabs = this.getDenyAssetTabs();
        final java.lang.Object other$denyAssetTabs = other.getDenyAssetTabs();
        if (this$denyAssetTabs == null ? other$denyAssetTabs != null : !this$denyAssetTabs.equals(other$denyAssetTabs)) return false;
        final java.lang.Object this$denyAssetTypes = this.getDenyAssetTypes();
        final java.lang.Object other$denyAssetTypes = other.getDenyAssetTypes();
        if (this$denyAssetTypes == null ? other$denyAssetTypes != null : !this$denyAssetTypes.equals(other$denyAssetTypes)) return false;
        final java.lang.Object this$denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        final java.lang.Object other$denyCustomMetadataGuids = other.getDenyCustomMetadataGuids();
        if (this$denyCustomMetadataGuids == null ? other$denyCustomMetadataGuids != null : !this$denyCustomMetadataGuids.equals(other$denyCustomMetadataGuids)) return false;
        final java.lang.Object this$denyNavigationPages = this.getDenyNavigationPages();
        final java.lang.Object other$denyNavigationPages = other.getDenyNavigationPages();
        if (this$denyNavigationPages == null ? other$denyNavigationPages != null : !this$denyNavigationPages.equals(other$denyNavigationPages)) return false;
        final java.lang.Object this$displayPreferences = this.getDisplayPreferences();
        final java.lang.Object other$displayPreferences = other.getDisplayPreferences();
        if (this$displayPreferences == null ? other$displayPreferences != null : !this$displayPreferences.equals(other$displayPreferences)) return false;
        final java.lang.Object this$policies = this.getPolicies();
        final java.lang.Object other$policies = other.getPolicies();
        if (this$policies == null ? other$policies != null : !this$policies.equals(other$policies)) return false;
        final java.lang.Object this$purposeAtlanTags = this.getPurposeAtlanTags();
        final java.lang.Object other$purposeAtlanTags = other.getPurposeAtlanTags();
        if (this$purposeAtlanTags == null ? other$purposeAtlanTags != null : !this$purposeAtlanTags.equals(other$purposeAtlanTags)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Purpose;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isAccessControlEnabled = this.getIsAccessControlEnabled();
        result = result * PRIME + ($isAccessControlEnabled == null ? 43 : $isAccessControlEnabled.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $channelLink = this.getChannelLink();
        result = result * PRIME + ($channelLink == null ? 43 : $channelLink.hashCode());
        final java.lang.Object $defaultNavigation = this.getDefaultNavigation();
        result = result * PRIME + ($defaultNavigation == null ? 43 : $defaultNavigation.hashCode());
        final java.lang.Object $denyAssetFilters = this.getDenyAssetFilters();
        result = result * PRIME + ($denyAssetFilters == null ? 43 : $denyAssetFilters.hashCode());
        final java.lang.Object $denyAssetTabs = this.getDenyAssetTabs();
        result = result * PRIME + ($denyAssetTabs == null ? 43 : $denyAssetTabs.hashCode());
        final java.lang.Object $denyAssetTypes = this.getDenyAssetTypes();
        result = result * PRIME + ($denyAssetTypes == null ? 43 : $denyAssetTypes.hashCode());
        final java.lang.Object $denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        result = result * PRIME + ($denyCustomMetadataGuids == null ? 43 : $denyCustomMetadataGuids.hashCode());
        final java.lang.Object $denyNavigationPages = this.getDenyNavigationPages();
        result = result * PRIME + ($denyNavigationPages == null ? 43 : $denyNavigationPages.hashCode());
        final java.lang.Object $displayPreferences = this.getDisplayPreferences();
        result = result * PRIME + ($displayPreferences == null ? 43 : $displayPreferences.hashCode());
        final java.lang.Object $policies = this.getPolicies();
        result = result * PRIME + ($policies == null ? 43 : $policies.hashCode());
        final java.lang.Object $purposeAtlanTags = this.getPurposeAtlanTags();
        result = result * PRIME + ($purposeAtlanTags == null ? 43 : $purposeAtlanTags.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Purpose(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", channelLink=" + this.getChannelLink() + ", defaultNavigation=" + this.getDefaultNavigation() + ", denyAssetFilters=" + this.getDenyAssetFilters() + ", denyAssetTabs=" + this.getDenyAssetTabs() + ", denyAssetTypes=" + this.getDenyAssetTypes() + ", denyCustomMetadataGuids=" + this.getDenyCustomMetadataGuids() + ", denyNavigationPages=" + this.getDenyNavigationPages() + ", displayPreferences=" + this.getDisplayPreferences() + ", isAccessControlEnabled=" + this.getIsAccessControlEnabled() + ", policies=" + this.getPolicies() + ", purposeAtlanTags=" + this.getPurposeAtlanTags() + ")";
    }

    /**
     * Fixed typeName for Purposes.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
