// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Qlik app in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class QlikApp extends Asset implements IQlikApp, IQlik, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(QlikApp.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QlikApp";
    /**
     * Fixed typeName for QlikApps.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Identifier of the app in which this asset belongs, from Qlik.
     */
    @Attribute
    String qlikAppId;
    /**
     * Unique name of the app where this asset belongs.
     */
    @Attribute
    String qlikAppQualifiedName;
    /**
     * Static space used by this app, in bytes.
     */
    @Attribute
    Long qlikAppStaticByteSize;
    /**
     * Whether section access or data masking is enabled on the source (true) or not (false).
     */
    @Attribute
    Boolean qlikHasSectionAccess;
    /**
     * Identifier of this asset, from Qlik.
     */
    @Attribute
    String qlikId;
    /**
     * Whether this app is in direct query mode (true) or not (false).
     */
    @Attribute
    Boolean qlikIsDirectQueryMode;
    /**
     * Whether this app is encrypted (true) or not (false).
     */
    @Attribute
    Boolean qlikIsEncrypted;
    /**
     * Whether this asset is published in Qlik (true) or not (false).
     */
    @Attribute
    Boolean qlikIsPublished;
    /**
     * Value of originAppId for this app.
     */
    @Attribute
    String qlikOriginAppId;
    /**
     * Identifier of the owner of this asset, in Qlik.
     */
    @Attribute
    String qlikOwnerId;
    /**
     * Unique QRI of this asset, from Qlik.
     */
    @Attribute
    String qlikQRI;
    /**
     * Sheets that exist within this app.
     */
    @Attribute
    SortedSet<IQlikSheet> qlikSheets;
    /**
     * Space in which this app exists.
     */
    @Attribute
    IQlikSpace qlikSpace;
    /**
     * Identifier of the space in which this asset exists, from Qlik.
     */
    @Attribute
    String qlikSpaceId;
    /**
     * Unique name of the space in which this asset exists.
     */
    @Attribute
    String qlikSpaceQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a QlikApp, from a potentially
     * more-complete QlikApp object.
     *
     * @return the minimal object necessary to relate to the QlikApp
     * @throws InvalidRequestException if any of the minimal set of required properties for a QlikApp relationship are not found in the initial object
     */
    @Override
    public QlikApp trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all QlikApp assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QlikApp assets will be included.
     *
     * @return a fluent search that includes all QlikApp assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all QlikApp assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QlikApp assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all QlikApp assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all QlikApp assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) QlikApps will be included
     * @return a fluent search that includes all QlikApp assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all QlikApp assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) QlikApps will be included
     * @return a fluent search that includes all QlikApp assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a QlikApp by GUID. Use this to create a relationship to this QlikApp,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the QlikApp to reference
     * @return reference to a QlikApp that can be used for defining a relationship to a QlikApp
     */
    public static QlikApp refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QlikApp by GUID. Use this to create a relationship to this QlikApp,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the QlikApp to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QlikApp that can be used for defining a relationship to a QlikApp
     */
    public static QlikApp refByGuid(String guid, Reference.SaveSemantic semantic) {
        return QlikApp._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a QlikApp by qualifiedName. Use this to create a relationship to this QlikApp,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the QlikApp to reference
     * @return reference to a QlikApp that can be used for defining a relationship to a QlikApp
     */
    public static QlikApp refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QlikApp by qualifiedName. Use this to create a relationship to this QlikApp,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the QlikApp to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QlikApp that can be used for defining a relationship to a QlikApp
     */
    public static QlikApp refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return QlikApp._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a QlikApp by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the QlikApp to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QlikApp, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QlikApp does not exist or the provided GUID is not a QlikApp
     */
    @JsonIgnore
    public static QlikApp get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a QlikApp by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QlikApp to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QlikApp, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QlikApp does not exist or the provided GUID is not a QlikApp
     */
    @JsonIgnore
    public static QlikApp get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a QlikApp by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QlikApp to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full QlikApp, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QlikApp does not exist or the provided GUID is not a QlikApp
     */
    @JsonIgnore
    public static QlikApp get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof QlikApp) {
                return (QlikApp) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof QlikApp) {
                return (QlikApp) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) QlikApp to active.
     *
     * @param qualifiedName for the QlikApp
     * @return true if the QlikApp is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) QlikApp to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the QlikApp
     * @return true if the QlikApp is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the minimal request necessary to update the QlikApp, as a builder
     */
    public static QlikAppBuilder<?, ?> updater(String qualifiedName, String name) {
        return QlikApp._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a QlikApp, from a potentially
     * more-complete QlikApp object.
     *
     * @return the minimal object necessary to update the QlikApp, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for QlikApp are not found in the initial object
     */
    @Override
    public QlikAppBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a QlikApp.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a QlikApp.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a QlikApp.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QlikApp's owners
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QlikApp, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a QlikApp.
     *
     * @param client connectivity to the Atlan tenant on which to update the QlikApp's certificate
     * @param qualifiedName of the QlikApp
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QlikApp, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QlikApp) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a QlikApp.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QlikApp's certificate
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a QlikApp.
     *
     * @param client connectivity to the Atlan tenant on which to update the QlikApp's announcement
     * @param qualifiedName of the QlikApp
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QlikApp) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a QlikApp.
     *
     * @param client connectivity to the Atlan client from which to remove the QlikApp's announcement
     * @param qualifiedName of the QlikApp
     * @param name of the QlikApp
     * @return the updated QlikApp, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikApp) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the QlikApp.
     *
     * @param qualifiedName for the QlikApp
     * @param name human-readable name of the QlikApp
     * @param terms the list of terms to replace on the QlikApp, or null to remove all terms from the QlikApp
     * @return the QlikApp that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QlikApp replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the QlikApp.
     *
     * @param client connectivity to the Atlan tenant on which to replace the QlikApp's assigned terms
     * @param qualifiedName for the QlikApp
     * @param name human-readable name of the QlikApp
     * @param terms the list of terms to replace on the QlikApp, or null to remove all terms from the QlikApp
     * @return the QlikApp that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QlikApp replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikApp) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the QlikApp, without replacing existing terms linked to the QlikApp.
     * Note: this operation must make two API calls — one to retrieve the QlikApp's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the QlikApp
     * @param terms the list of terms to append to the QlikApp
     * @return the QlikApp that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QlikApp appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the QlikApp, without replacing existing terms linked to the QlikApp.
     * Note: this operation must make two API calls — one to retrieve the QlikApp's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the QlikApp
     * @param qualifiedName for the QlikApp
     * @param terms the list of terms to append to the QlikApp
     * @return the QlikApp that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QlikApp appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikApp) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a QlikApp, without replacing all existing terms linked to the QlikApp.
     * Note: this operation must make two API calls — one to retrieve the QlikApp's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the QlikApp
     * @param terms the list of terms to remove from the QlikApp, which must be referenced by GUID
     * @return the QlikApp that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a QlikApp, without replacing all existing terms linked to the QlikApp.
     * Note: this operation must make two API calls — one to retrieve the QlikApp's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the QlikApp
     * @param qualifiedName for the QlikApp
     * @param terms the list of terms to remove from the QlikApp, which must be referenced by GUID
     * @return the QlikApp that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QlikApp removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikApp) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a QlikApp, without replacing existing Atlan tags linked to the QlikApp.
     * Note: this operation must make two API calls — one to retrieve the QlikApp's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QlikApp
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QlikApp
     */
    public static QlikApp appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QlikApp, without replacing existing Atlan tags linked to the QlikApp.
     * Note: this operation must make two API calls — one to retrieve the QlikApp's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QlikApp
     * @param qualifiedName of the QlikApp
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QlikApp
     */
    public static QlikApp appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QlikApp) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QlikApp, without replacing existing Atlan tags linked to the QlikApp.
     * Note: this operation must make two API calls — one to retrieve the QlikApp's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QlikApp
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QlikApp
     */
    public static QlikApp appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a QlikApp, without replacing existing Atlan tags linked to the QlikApp.
     * Note: this operation must make two API calls — one to retrieve the QlikApp's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QlikApp
     * @param qualifiedName of the QlikApp
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QlikApp
     */
    public static QlikApp appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QlikApp) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a QlikApp.
     *
     * @param qualifiedName of the QlikApp
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QlikApp
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a QlikApp.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a QlikApp
     * @param qualifiedName of the QlikApp
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QlikApp
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class QlikAppBuilder<C extends QlikApp, B extends QlikApp.QlikAppBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikAppId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikAppQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long qlikAppStaticByteSize;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean qlikHasSectionAccess;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean qlikIsDirectQueryMode;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean qlikIsEncrypted;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean qlikIsPublished;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikOriginAppId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikOwnerId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikQRI;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IQlikSheet> qlikSheets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IQlikSpace qlikSpace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikSpaceId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikSpaceQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QlikApp.QlikAppBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final QlikApp instance, final QlikApp.QlikAppBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.qlikAppId(instance.qlikAppId);
            b.qlikAppQualifiedName(instance.qlikAppQualifiedName);
            b.qlikAppStaticByteSize(instance.qlikAppStaticByteSize);
            b.qlikHasSectionAccess(instance.qlikHasSectionAccess);
            b.qlikId(instance.qlikId);
            b.qlikIsDirectQueryMode(instance.qlikIsDirectQueryMode);
            b.qlikIsEncrypted(instance.qlikIsEncrypted);
            b.qlikIsPublished(instance.qlikIsPublished);
            b.qlikOriginAppId(instance.qlikOriginAppId);
            b.qlikOwnerId(instance.qlikOwnerId);
            b.qlikQRI(instance.qlikQRI);
            b.qlikSheets(instance.qlikSheets == null ? java.util.Collections.<IQlikSheet>emptySortedSet() : instance.qlikSheets);
            b.qlikSpace(instance.qlikSpace);
            b.qlikSpaceId(instance.qlikSpaceId);
            b.qlikSpaceQualifiedName(instance.qlikSpaceQualifiedName);
        }

        /**
         * Fixed typeName for QlikApps.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Identifier of the app in which this asset belongs, from Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikAppId(final String qlikAppId) {
            this.qlikAppId = qlikAppId;
            return self();
        }

        /**
         * Unique name of the app where this asset belongs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikAppQualifiedName(final String qlikAppQualifiedName) {
            this.qlikAppQualifiedName = qlikAppQualifiedName;
            return self();
        }

        /**
         * Static space used by this app, in bytes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikAppStaticByteSize(final Long qlikAppStaticByteSize) {
            this.qlikAppStaticByteSize = qlikAppStaticByteSize;
            return self();
        }

        /**
         * Whether section access or data masking is enabled on the source (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikHasSectionAccess(final Boolean qlikHasSectionAccess) {
            this.qlikHasSectionAccess = qlikHasSectionAccess;
            return self();
        }

        /**
         * Identifier of this asset, from Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikId(final String qlikId) {
            this.qlikId = qlikId;
            return self();
        }

        /**
         * Whether this app is in direct query mode (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikIsDirectQueryMode(final Boolean qlikIsDirectQueryMode) {
            this.qlikIsDirectQueryMode = qlikIsDirectQueryMode;
            return self();
        }

        /**
         * Whether this app is encrypted (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikIsEncrypted(final Boolean qlikIsEncrypted) {
            this.qlikIsEncrypted = qlikIsEncrypted;
            return self();
        }

        /**
         * Whether this asset is published in Qlik (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikIsPublished(final Boolean qlikIsPublished) {
            this.qlikIsPublished = qlikIsPublished;
            return self();
        }

        /**
         * Value of originAppId for this app.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikOriginAppId(final String qlikOriginAppId) {
            this.qlikOriginAppId = qlikOriginAppId;
            return self();
        }

        /**
         * Identifier of the owner of this asset, in Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikOwnerId(final String qlikOwnerId) {
            this.qlikOwnerId = qlikOwnerId;
            return self();
        }

        /**
         * Unique QRI of this asset, from Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikQRI(final String qlikQRI) {
            this.qlikQRI = qlikQRI;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikSheet(final IQlikSheet qlikSheet) {
            if (this.qlikSheets == null) this.qlikSheets = new java.util.ArrayList<IQlikSheet>();
            this.qlikSheets.add(qlikSheet);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikSheets(final java.util.Collection<? extends IQlikSheet> qlikSheets) {
            if (qlikSheets == null) {
                throw new java.lang.NullPointerException("qlikSheets cannot be null");
            }
            if (this.qlikSheets == null) this.qlikSheets = new java.util.ArrayList<IQlikSheet>();
            this.qlikSheets.addAll(qlikSheets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQlikSheets() {
            if (this.qlikSheets != null) this.qlikSheets.clear();
            return self();
        }

        /**
         * Space in which this app exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikSpace(final IQlikSpace qlikSpace) {
            this.qlikSpace = qlikSpace;
            return self();
        }

        /**
         * Identifier of the space in which this asset exists, from Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikSpaceId(final String qlikSpaceId) {
            this.qlikSpaceId = qlikSpaceId;
            return self();
        }

        /**
         * Unique name of the space in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikSpaceQualifiedName(final String qlikSpaceQualifiedName) {
            this.qlikSpaceQualifiedName = qlikSpaceQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QlikApp.QlikAppBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", qlikAppId=" + this.qlikAppId + ", qlikAppQualifiedName=" + this.qlikAppQualifiedName + ", qlikAppStaticByteSize=" + this.qlikAppStaticByteSize + ", qlikHasSectionAccess=" + this.qlikHasSectionAccess + ", qlikId=" + this.qlikId + ", qlikIsDirectQueryMode=" + this.qlikIsDirectQueryMode + ", qlikIsEncrypted=" + this.qlikIsEncrypted + ", qlikIsPublished=" + this.qlikIsPublished + ", qlikOriginAppId=" + this.qlikOriginAppId + ", qlikOwnerId=" + this.qlikOwnerId + ", qlikQRI=" + this.qlikQRI + ", qlikSheets=" + this.qlikSheets + ", qlikSpace=" + this.qlikSpace + ", qlikSpaceId=" + this.qlikSpaceId + ", qlikSpaceQualifiedName=" + this.qlikSpaceQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class QlikAppBuilderImpl extends QlikApp.QlikAppBuilder<QlikApp, QlikApp.QlikAppBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private QlikAppBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected QlikApp.QlikAppBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QlikApp build() {
            return new QlikApp(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected QlikApp(final QlikApp.QlikAppBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = QlikApp.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.qlikAppId = b.qlikAppId;
        this.qlikAppQualifiedName = b.qlikAppQualifiedName;
        this.qlikAppStaticByteSize = b.qlikAppStaticByteSize;
        this.qlikHasSectionAccess = b.qlikHasSectionAccess;
        this.qlikId = b.qlikId;
        this.qlikIsDirectQueryMode = b.qlikIsDirectQueryMode;
        this.qlikIsEncrypted = b.qlikIsEncrypted;
        this.qlikIsPublished = b.qlikIsPublished;
        this.qlikOriginAppId = b.qlikOriginAppId;
        this.qlikOwnerId = b.qlikOwnerId;
        this.qlikQRI = b.qlikQRI;
        java.util.SortedSet<IQlikSheet> qlikSheets = new java.util.TreeSet<IQlikSheet>();
        if (b.qlikSheets != null) qlikSheets.addAll(b.qlikSheets);
        qlikSheets = java.util.Collections.unmodifiableSortedSet(qlikSheets);
        this.qlikSheets = qlikSheets;
        this.qlikSpace = b.qlikSpace;
        this.qlikSpaceId = b.qlikSpaceId;
        this.qlikSpaceQualifiedName = b.qlikSpaceQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static QlikApp.QlikAppBuilder<?, ?> _internal() {
        return new QlikApp.QlikAppBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QlikApp.QlikAppBuilder<?, ?> toBuilder() {
        return new QlikApp.QlikAppBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Identifier of the app in which this asset belongs, from Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikAppId() {
        return this.qlikAppId;
    }

    /**
     * Unique name of the app where this asset belongs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikAppQualifiedName() {
        return this.qlikAppQualifiedName;
    }

    /**
     * Static space used by this app, in bytes.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQlikAppStaticByteSize() {
        return this.qlikAppStaticByteSize;
    }

    /**
     * Whether section access or data masking is enabled on the source (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getQlikHasSectionAccess() {
        return this.qlikHasSectionAccess;
    }

    /**
     * Identifier of this asset, from Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikId() {
        return this.qlikId;
    }

    /**
     * Whether this app is in direct query mode (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getQlikIsDirectQueryMode() {
        return this.qlikIsDirectQueryMode;
    }

    /**
     * Whether this app is encrypted (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getQlikIsEncrypted() {
        return this.qlikIsEncrypted;
    }

    /**
     * Whether this asset is published in Qlik (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getQlikIsPublished() {
        return this.qlikIsPublished;
    }

    /**
     * Value of originAppId for this app.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikOriginAppId() {
        return this.qlikOriginAppId;
    }

    /**
     * Identifier of the owner of this asset, in Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikOwnerId() {
        return this.qlikOwnerId;
    }

    /**
     * Unique QRI of this asset, from Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikQRI() {
        return this.qlikQRI;
    }

    /**
     * Sheets that exist within this app.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IQlikSheet> getQlikSheets() {
        return this.qlikSheets;
    }

    /**
     * Space in which this app exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IQlikSpace getQlikSpace() {
        return this.qlikSpace;
    }

    /**
     * Identifier of the space in which this asset exists, from Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikSpaceId() {
        return this.qlikSpaceId;
    }

    /**
     * Unique name of the space in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikSpaceQualifiedName() {
        return this.qlikSpaceQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof QlikApp)) return false;
        final QlikApp other = (QlikApp) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$qlikAppStaticByteSize = this.getQlikAppStaticByteSize();
        final java.lang.Object other$qlikAppStaticByteSize = other.getQlikAppStaticByteSize();
        if (this$qlikAppStaticByteSize == null ? other$qlikAppStaticByteSize != null : !this$qlikAppStaticByteSize.equals(other$qlikAppStaticByteSize)) return false;
        final java.lang.Object this$qlikHasSectionAccess = this.getQlikHasSectionAccess();
        final java.lang.Object other$qlikHasSectionAccess = other.getQlikHasSectionAccess();
        if (this$qlikHasSectionAccess == null ? other$qlikHasSectionAccess != null : !this$qlikHasSectionAccess.equals(other$qlikHasSectionAccess)) return false;
        final java.lang.Object this$qlikIsDirectQueryMode = this.getQlikIsDirectQueryMode();
        final java.lang.Object other$qlikIsDirectQueryMode = other.getQlikIsDirectQueryMode();
        if (this$qlikIsDirectQueryMode == null ? other$qlikIsDirectQueryMode != null : !this$qlikIsDirectQueryMode.equals(other$qlikIsDirectQueryMode)) return false;
        final java.lang.Object this$qlikIsEncrypted = this.getQlikIsEncrypted();
        final java.lang.Object other$qlikIsEncrypted = other.getQlikIsEncrypted();
        if (this$qlikIsEncrypted == null ? other$qlikIsEncrypted != null : !this$qlikIsEncrypted.equals(other$qlikIsEncrypted)) return false;
        final java.lang.Object this$qlikIsPublished = this.getQlikIsPublished();
        final java.lang.Object other$qlikIsPublished = other.getQlikIsPublished();
        if (this$qlikIsPublished == null ? other$qlikIsPublished != null : !this$qlikIsPublished.equals(other$qlikIsPublished)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$qlikAppId = this.getQlikAppId();
        final java.lang.Object other$qlikAppId = other.getQlikAppId();
        if (this$qlikAppId == null ? other$qlikAppId != null : !this$qlikAppId.equals(other$qlikAppId)) return false;
        final java.lang.Object this$qlikAppQualifiedName = this.getQlikAppQualifiedName();
        final java.lang.Object other$qlikAppQualifiedName = other.getQlikAppQualifiedName();
        if (this$qlikAppQualifiedName == null ? other$qlikAppQualifiedName != null : !this$qlikAppQualifiedName.equals(other$qlikAppQualifiedName)) return false;
        final java.lang.Object this$qlikId = this.getQlikId();
        final java.lang.Object other$qlikId = other.getQlikId();
        if (this$qlikId == null ? other$qlikId != null : !this$qlikId.equals(other$qlikId)) return false;
        final java.lang.Object this$qlikOriginAppId = this.getQlikOriginAppId();
        final java.lang.Object other$qlikOriginAppId = other.getQlikOriginAppId();
        if (this$qlikOriginAppId == null ? other$qlikOriginAppId != null : !this$qlikOriginAppId.equals(other$qlikOriginAppId)) return false;
        final java.lang.Object this$qlikOwnerId = this.getQlikOwnerId();
        final java.lang.Object other$qlikOwnerId = other.getQlikOwnerId();
        if (this$qlikOwnerId == null ? other$qlikOwnerId != null : !this$qlikOwnerId.equals(other$qlikOwnerId)) return false;
        final java.lang.Object this$qlikQRI = this.getQlikQRI();
        final java.lang.Object other$qlikQRI = other.getQlikQRI();
        if (this$qlikQRI == null ? other$qlikQRI != null : !this$qlikQRI.equals(other$qlikQRI)) return false;
        final java.lang.Object this$qlikSheets = this.getQlikSheets();
        final java.lang.Object other$qlikSheets = other.getQlikSheets();
        if (this$qlikSheets == null ? other$qlikSheets != null : !this$qlikSheets.equals(other$qlikSheets)) return false;
        final java.lang.Object this$qlikSpace = this.getQlikSpace();
        final java.lang.Object other$qlikSpace = other.getQlikSpace();
        if (this$qlikSpace == null ? other$qlikSpace != null : !this$qlikSpace.equals(other$qlikSpace)) return false;
        final java.lang.Object this$qlikSpaceId = this.getQlikSpaceId();
        final java.lang.Object other$qlikSpaceId = other.getQlikSpaceId();
        if (this$qlikSpaceId == null ? other$qlikSpaceId != null : !this$qlikSpaceId.equals(other$qlikSpaceId)) return false;
        final java.lang.Object this$qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        final java.lang.Object other$qlikSpaceQualifiedName = other.getQlikSpaceQualifiedName();
        if (this$qlikSpaceQualifiedName == null ? other$qlikSpaceQualifiedName != null : !this$qlikSpaceQualifiedName.equals(other$qlikSpaceQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof QlikApp;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $qlikAppStaticByteSize = this.getQlikAppStaticByteSize();
        result = result * PRIME + ($qlikAppStaticByteSize == null ? 43 : $qlikAppStaticByteSize.hashCode());
        final java.lang.Object $qlikHasSectionAccess = this.getQlikHasSectionAccess();
        result = result * PRIME + ($qlikHasSectionAccess == null ? 43 : $qlikHasSectionAccess.hashCode());
        final java.lang.Object $qlikIsDirectQueryMode = this.getQlikIsDirectQueryMode();
        result = result * PRIME + ($qlikIsDirectQueryMode == null ? 43 : $qlikIsDirectQueryMode.hashCode());
        final java.lang.Object $qlikIsEncrypted = this.getQlikIsEncrypted();
        result = result * PRIME + ($qlikIsEncrypted == null ? 43 : $qlikIsEncrypted.hashCode());
        final java.lang.Object $qlikIsPublished = this.getQlikIsPublished();
        result = result * PRIME + ($qlikIsPublished == null ? 43 : $qlikIsPublished.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $qlikAppId = this.getQlikAppId();
        result = result * PRIME + ($qlikAppId == null ? 43 : $qlikAppId.hashCode());
        final java.lang.Object $qlikAppQualifiedName = this.getQlikAppQualifiedName();
        result = result * PRIME + ($qlikAppQualifiedName == null ? 43 : $qlikAppQualifiedName.hashCode());
        final java.lang.Object $qlikId = this.getQlikId();
        result = result * PRIME + ($qlikId == null ? 43 : $qlikId.hashCode());
        final java.lang.Object $qlikOriginAppId = this.getQlikOriginAppId();
        result = result * PRIME + ($qlikOriginAppId == null ? 43 : $qlikOriginAppId.hashCode());
        final java.lang.Object $qlikOwnerId = this.getQlikOwnerId();
        result = result * PRIME + ($qlikOwnerId == null ? 43 : $qlikOwnerId.hashCode());
        final java.lang.Object $qlikQRI = this.getQlikQRI();
        result = result * PRIME + ($qlikQRI == null ? 43 : $qlikQRI.hashCode());
        final java.lang.Object $qlikSheets = this.getQlikSheets();
        result = result * PRIME + ($qlikSheets == null ? 43 : $qlikSheets.hashCode());
        final java.lang.Object $qlikSpace = this.getQlikSpace();
        result = result * PRIME + ($qlikSpace == null ? 43 : $qlikSpace.hashCode());
        final java.lang.Object $qlikSpaceId = this.getQlikSpaceId();
        result = result * PRIME + ($qlikSpaceId == null ? 43 : $qlikSpaceId.hashCode());
        final java.lang.Object $qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        result = result * PRIME + ($qlikSpaceQualifiedName == null ? 43 : $qlikSpaceQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "QlikApp(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", qlikAppId=" + this.getQlikAppId() + ", qlikAppQualifiedName=" + this.getQlikAppQualifiedName() + ", qlikAppStaticByteSize=" + this.getQlikAppStaticByteSize() + ", qlikHasSectionAccess=" + this.getQlikHasSectionAccess() + ", qlikId=" + this.getQlikId() + ", qlikIsDirectQueryMode=" + this.getQlikIsDirectQueryMode() + ", qlikIsEncrypted=" + this.getQlikIsEncrypted() + ", qlikIsPublished=" + this.getQlikIsPublished() + ", qlikOriginAppId=" + this.getQlikOriginAppId() + ", qlikOwnerId=" + this.getQlikOwnerId() + ", qlikQRI=" + this.getQlikQRI() + ", qlikSheets=" + this.getQlikSheets() + ", qlikSpace=" + this.getQlikSpace() + ", qlikSpaceId=" + this.getQlikSpaceId() + ", qlikSpaceQualifiedName=" + this.getQlikSpaceQualifiedName() + ")";
    }

    /**
     * Fixed typeName for QlikApps.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
