// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Qlik stream in Atlan, which is analogus to a Qlik space.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class QlikStream extends Asset implements IQlikStream, IQlikSpace, IQlik, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(QlikStream.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QlikStream";
    /**
     * Fixed typeName for QlikStreams.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Identifier of the app in which this asset belongs, from Qlik.
     */
    @Attribute
    String qlikAppId;
    /**
     * Unique name of the app where this asset belongs.
     */
    @Attribute
    String qlikAppQualifiedName;
    /**
     * Apps that exist within this space.
     */
    @Attribute
    SortedSet<IQlikApp> qlikApps;
    /**
     * Datasets that exist within this space.
     */
    @Attribute
    SortedSet<IQlikDataset> qlikDatasets;
    /**
     * Identifier of this asset, from Qlik.
     */
    @Attribute
    String qlikId;
    /**
     * Whether this asset is published in Qlik (true) or not (false).
     */
    @Attribute
    Boolean qlikIsPublished;
    /**
     * Identifier of the owner of this asset, in Qlik.
     */
    @Attribute
    String qlikOwnerId;
    /**
     * Unique QRI of this asset, from Qlik.
     */
    @Attribute
    String qlikQRI;
    /**
     * Identifier of the space in which this asset exists, from Qlik.
     */
    @Attribute
    String qlikSpaceId;
    /**
     * Unique name of the space in which this asset exists.
     */
    @Attribute
    String qlikSpaceQualifiedName;
    /**
     * Type of this space, for exmaple: Private, Shared, etc.
     */
    @Attribute
    String qlikSpaceType;

    /**
     * Builds the minimal object necessary to create a relationship to a QlikStream, from a potentially
     * more-complete QlikStream object.
     *
     * @return the minimal object necessary to relate to the QlikStream
     * @throws InvalidRequestException if any of the minimal set of required properties for a QlikStream relationship are not found in the initial object
     */
    @Override
    public QlikStream trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all QlikStream assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QlikStream assets will be included.
     *
     * @return a fluent search that includes all QlikStream assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all QlikStream assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QlikStream assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all QlikStream assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all QlikStream assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) QlikStreams will be included
     * @return a fluent search that includes all QlikStream assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all QlikStream assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) QlikStreams will be included
     * @return a fluent search that includes all QlikStream assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a QlikStream by GUID. Use this to create a relationship to this QlikStream,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the QlikStream to reference
     * @return reference to a QlikStream that can be used for defining a relationship to a QlikStream
     */
    public static QlikStream refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QlikStream by GUID. Use this to create a relationship to this QlikStream,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the QlikStream to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QlikStream that can be used for defining a relationship to a QlikStream
     */
    public static QlikStream refByGuid(String guid, Reference.SaveSemantic semantic) {
        return QlikStream._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a QlikStream by qualifiedName. Use this to create a relationship to this QlikStream,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the QlikStream to reference
     * @return reference to a QlikStream that can be used for defining a relationship to a QlikStream
     */
    public static QlikStream refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QlikStream by qualifiedName. Use this to create a relationship to this QlikStream,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the QlikStream to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QlikStream that can be used for defining a relationship to a QlikStream
     */
    public static QlikStream refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return QlikStream._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a QlikStream by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the QlikStream to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QlikStream, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QlikStream does not exist or the provided GUID is not a QlikStream
     */
    @JsonIgnore
    public static QlikStream get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a QlikStream by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QlikStream to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QlikStream, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QlikStream does not exist or the provided GUID is not a QlikStream
     */
    @JsonIgnore
    public static QlikStream get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a QlikStream by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QlikStream to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full QlikStream, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QlikStream does not exist or the provided GUID is not a QlikStream
     */
    @JsonIgnore
    public static QlikStream get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof QlikStream) {
                return (QlikStream) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof QlikStream) {
                return (QlikStream) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) QlikStream to active.
     *
     * @param qualifiedName for the QlikStream
     * @return true if the QlikStream is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) QlikStream to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the QlikStream
     * @return true if the QlikStream is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the minimal request necessary to update the QlikStream, as a builder
     */
    public static QlikStreamBuilder<?, ?> updater(String qualifiedName, String name) {
        return QlikStream._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a QlikStream, from a potentially
     * more-complete QlikStream object.
     *
     * @return the minimal object necessary to update the QlikStream, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for QlikStream are not found in the initial object
     */
    @Override
    public QlikStreamBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a QlikStream.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a QlikStream.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a QlikStream.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QlikStream's owners
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QlikStream, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a QlikStream.
     *
     * @param client connectivity to the Atlan tenant on which to update the QlikStream's certificate
     * @param qualifiedName of the QlikStream
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QlikStream, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QlikStream) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a QlikStream.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QlikStream's certificate
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a QlikStream.
     *
     * @param client connectivity to the Atlan tenant on which to update the QlikStream's announcement
     * @param qualifiedName of the QlikStream
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QlikStream) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a QlikStream.
     *
     * @param client connectivity to the Atlan client from which to remove the QlikStream's announcement
     * @param qualifiedName of the QlikStream
     * @param name of the QlikStream
     * @return the updated QlikStream, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QlikStream) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the QlikStream.
     *
     * @param qualifiedName for the QlikStream
     * @param name human-readable name of the QlikStream
     * @param terms the list of terms to replace on the QlikStream, or null to remove all terms from the QlikStream
     * @return the QlikStream that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QlikStream replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the QlikStream.
     *
     * @param client connectivity to the Atlan tenant on which to replace the QlikStream's assigned terms
     * @param qualifiedName for the QlikStream
     * @param name human-readable name of the QlikStream
     * @param terms the list of terms to replace on the QlikStream, or null to remove all terms from the QlikStream
     * @return the QlikStream that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QlikStream replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikStream) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the QlikStream, without replacing existing terms linked to the QlikStream.
     * Note: this operation must make two API calls — one to retrieve the QlikStream's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the QlikStream
     * @param terms the list of terms to append to the QlikStream
     * @return the QlikStream that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QlikStream appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the QlikStream, without replacing existing terms linked to the QlikStream.
     * Note: this operation must make two API calls — one to retrieve the QlikStream's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the QlikStream
     * @param qualifiedName for the QlikStream
     * @param terms the list of terms to append to the QlikStream
     * @return the QlikStream that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QlikStream appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikStream) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a QlikStream, without replacing all existing terms linked to the QlikStream.
     * Note: this operation must make two API calls — one to retrieve the QlikStream's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the QlikStream
     * @param terms the list of terms to remove from the QlikStream, which must be referenced by GUID
     * @return the QlikStream that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a QlikStream, without replacing all existing terms linked to the QlikStream.
     * Note: this operation must make two API calls — one to retrieve the QlikStream's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the QlikStream
     * @param qualifiedName for the QlikStream
     * @param terms the list of terms to remove from the QlikStream, which must be referenced by GUID
     * @return the QlikStream that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QlikStream removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QlikStream) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a QlikStream, without replacing existing Atlan tags linked to the QlikStream.
     * Note: this operation must make two API calls — one to retrieve the QlikStream's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QlikStream
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QlikStream
     */
    public static QlikStream appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QlikStream, without replacing existing Atlan tags linked to the QlikStream.
     * Note: this operation must make two API calls — one to retrieve the QlikStream's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QlikStream
     * @param qualifiedName of the QlikStream
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QlikStream
     */
    public static QlikStream appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QlikStream) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QlikStream, without replacing existing Atlan tags linked to the QlikStream.
     * Note: this operation must make two API calls — one to retrieve the QlikStream's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QlikStream
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QlikStream
     */
    public static QlikStream appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a QlikStream, without replacing existing Atlan tags linked to the QlikStream.
     * Note: this operation must make two API calls — one to retrieve the QlikStream's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QlikStream
     * @param qualifiedName of the QlikStream
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QlikStream
     */
    public static QlikStream appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QlikStream) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a QlikStream.
     *
     * @param qualifiedName of the QlikStream
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QlikStream
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a QlikStream.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a QlikStream
     * @param qualifiedName of the QlikStream
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QlikStream
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class QlikStreamBuilder<C extends QlikStream, B extends QlikStream.QlikStreamBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikAppId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikAppQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IQlikApp> qlikApps;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IQlikDataset> qlikDatasets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean qlikIsPublished;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikOwnerId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikQRI;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikSpaceId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikSpaceQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String qlikSpaceType;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QlikStream.QlikStreamBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final QlikStream instance, final QlikStream.QlikStreamBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.qlikAppId(instance.qlikAppId);
            b.qlikAppQualifiedName(instance.qlikAppQualifiedName);
            b.qlikApps(instance.qlikApps == null ? java.util.Collections.<IQlikApp>emptySortedSet() : instance.qlikApps);
            b.qlikDatasets(instance.qlikDatasets == null ? java.util.Collections.<IQlikDataset>emptySortedSet() : instance.qlikDatasets);
            b.qlikId(instance.qlikId);
            b.qlikIsPublished(instance.qlikIsPublished);
            b.qlikOwnerId(instance.qlikOwnerId);
            b.qlikQRI(instance.qlikQRI);
            b.qlikSpaceId(instance.qlikSpaceId);
            b.qlikSpaceQualifiedName(instance.qlikSpaceQualifiedName);
            b.qlikSpaceType(instance.qlikSpaceType);
        }

        /**
         * Fixed typeName for QlikStreams.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Identifier of the app in which this asset belongs, from Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikAppId(final String qlikAppId) {
            this.qlikAppId = qlikAppId;
            return self();
        }

        /**
         * Unique name of the app where this asset belongs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikAppQualifiedName(final String qlikAppQualifiedName) {
            this.qlikAppQualifiedName = qlikAppQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikApp(final IQlikApp qlikApp) {
            if (this.qlikApps == null) this.qlikApps = new java.util.ArrayList<IQlikApp>();
            this.qlikApps.add(qlikApp);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikApps(final java.util.Collection<? extends IQlikApp> qlikApps) {
            if (qlikApps == null) {
                throw new java.lang.NullPointerException("qlikApps cannot be null");
            }
            if (this.qlikApps == null) this.qlikApps = new java.util.ArrayList<IQlikApp>();
            this.qlikApps.addAll(qlikApps);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQlikApps() {
            if (this.qlikApps != null) this.qlikApps.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikDataset(final IQlikDataset qlikDataset) {
            if (this.qlikDatasets == null) this.qlikDatasets = new java.util.ArrayList<IQlikDataset>();
            this.qlikDatasets.add(qlikDataset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikDatasets(final java.util.Collection<? extends IQlikDataset> qlikDatasets) {
            if (qlikDatasets == null) {
                throw new java.lang.NullPointerException("qlikDatasets cannot be null");
            }
            if (this.qlikDatasets == null) this.qlikDatasets = new java.util.ArrayList<IQlikDataset>();
            this.qlikDatasets.addAll(qlikDatasets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQlikDatasets() {
            if (this.qlikDatasets != null) this.qlikDatasets.clear();
            return self();
        }

        /**
         * Identifier of this asset, from Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikId(final String qlikId) {
            this.qlikId = qlikId;
            return self();
        }

        /**
         * Whether this asset is published in Qlik (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikIsPublished(final Boolean qlikIsPublished) {
            this.qlikIsPublished = qlikIsPublished;
            return self();
        }

        /**
         * Identifier of the owner of this asset, in Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikOwnerId(final String qlikOwnerId) {
            this.qlikOwnerId = qlikOwnerId;
            return self();
        }

        /**
         * Unique QRI of this asset, from Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikQRI(final String qlikQRI) {
            this.qlikQRI = qlikQRI;
            return self();
        }

        /**
         * Identifier of the space in which this asset exists, from Qlik.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikSpaceId(final String qlikSpaceId) {
            this.qlikSpaceId = qlikSpaceId;
            return self();
        }

        /**
         * Unique name of the space in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikSpaceQualifiedName(final String qlikSpaceQualifiedName) {
            this.qlikSpaceQualifiedName = qlikSpaceQualifiedName;
            return self();
        }

        /**
         * Type of this space, for exmaple: Private, Shared, etc.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B qlikSpaceType(final String qlikSpaceType) {
            this.qlikSpaceType = qlikSpaceType;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QlikStream.QlikStreamBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", qlikAppId=" + this.qlikAppId + ", qlikAppQualifiedName=" + this.qlikAppQualifiedName + ", qlikApps=" + this.qlikApps + ", qlikDatasets=" + this.qlikDatasets + ", qlikId=" + this.qlikId + ", qlikIsPublished=" + this.qlikIsPublished + ", qlikOwnerId=" + this.qlikOwnerId + ", qlikQRI=" + this.qlikQRI + ", qlikSpaceId=" + this.qlikSpaceId + ", qlikSpaceQualifiedName=" + this.qlikSpaceQualifiedName + ", qlikSpaceType=" + this.qlikSpaceType + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class QlikStreamBuilderImpl extends QlikStream.QlikStreamBuilder<QlikStream, QlikStream.QlikStreamBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private QlikStreamBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected QlikStream.QlikStreamBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QlikStream build() {
            return new QlikStream(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected QlikStream(final QlikStream.QlikStreamBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = QlikStream.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.qlikAppId = b.qlikAppId;
        this.qlikAppQualifiedName = b.qlikAppQualifiedName;
        java.util.SortedSet<IQlikApp> qlikApps = new java.util.TreeSet<IQlikApp>();
        if (b.qlikApps != null) qlikApps.addAll(b.qlikApps);
        qlikApps = java.util.Collections.unmodifiableSortedSet(qlikApps);
        this.qlikApps = qlikApps;
        java.util.SortedSet<IQlikDataset> qlikDatasets = new java.util.TreeSet<IQlikDataset>();
        if (b.qlikDatasets != null) qlikDatasets.addAll(b.qlikDatasets);
        qlikDatasets = java.util.Collections.unmodifiableSortedSet(qlikDatasets);
        this.qlikDatasets = qlikDatasets;
        this.qlikId = b.qlikId;
        this.qlikIsPublished = b.qlikIsPublished;
        this.qlikOwnerId = b.qlikOwnerId;
        this.qlikQRI = b.qlikQRI;
        this.qlikSpaceId = b.qlikSpaceId;
        this.qlikSpaceQualifiedName = b.qlikSpaceQualifiedName;
        this.qlikSpaceType = b.qlikSpaceType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static QlikStream.QlikStreamBuilder<?, ?> _internal() {
        return new QlikStream.QlikStreamBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QlikStream.QlikStreamBuilder<?, ?> toBuilder() {
        return new QlikStream.QlikStreamBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Identifier of the app in which this asset belongs, from Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikAppId() {
        return this.qlikAppId;
    }

    /**
     * Unique name of the app where this asset belongs.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikAppQualifiedName() {
        return this.qlikAppQualifiedName;
    }

    /**
     * Apps that exist within this space.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IQlikApp> getQlikApps() {
        return this.qlikApps;
    }

    /**
     * Datasets that exist within this space.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IQlikDataset> getQlikDatasets() {
        return this.qlikDatasets;
    }

    /**
     * Identifier of this asset, from Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikId() {
        return this.qlikId;
    }

    /**
     * Whether this asset is published in Qlik (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getQlikIsPublished() {
        return this.qlikIsPublished;
    }

    /**
     * Identifier of the owner of this asset, in Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikOwnerId() {
        return this.qlikOwnerId;
    }

    /**
     * Unique QRI of this asset, from Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikQRI() {
        return this.qlikQRI;
    }

    /**
     * Identifier of the space in which this asset exists, from Qlik.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikSpaceId() {
        return this.qlikSpaceId;
    }

    /**
     * Unique name of the space in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikSpaceQualifiedName() {
        return this.qlikSpaceQualifiedName;
    }

    /**
     * Type of this space, for exmaple: Private, Shared, etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQlikSpaceType() {
        return this.qlikSpaceType;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof QlikStream)) return false;
        final QlikStream other = (QlikStream) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$qlikIsPublished = this.getQlikIsPublished();
        final java.lang.Object other$qlikIsPublished = other.getQlikIsPublished();
        if (this$qlikIsPublished == null ? other$qlikIsPublished != null : !this$qlikIsPublished.equals(other$qlikIsPublished)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$qlikAppId = this.getQlikAppId();
        final java.lang.Object other$qlikAppId = other.getQlikAppId();
        if (this$qlikAppId == null ? other$qlikAppId != null : !this$qlikAppId.equals(other$qlikAppId)) return false;
        final java.lang.Object this$qlikAppQualifiedName = this.getQlikAppQualifiedName();
        final java.lang.Object other$qlikAppQualifiedName = other.getQlikAppQualifiedName();
        if (this$qlikAppQualifiedName == null ? other$qlikAppQualifiedName != null : !this$qlikAppQualifiedName.equals(other$qlikAppQualifiedName)) return false;
        final java.lang.Object this$qlikApps = this.getQlikApps();
        final java.lang.Object other$qlikApps = other.getQlikApps();
        if (this$qlikApps == null ? other$qlikApps != null : !this$qlikApps.equals(other$qlikApps)) return false;
        final java.lang.Object this$qlikDatasets = this.getQlikDatasets();
        final java.lang.Object other$qlikDatasets = other.getQlikDatasets();
        if (this$qlikDatasets == null ? other$qlikDatasets != null : !this$qlikDatasets.equals(other$qlikDatasets)) return false;
        final java.lang.Object this$qlikId = this.getQlikId();
        final java.lang.Object other$qlikId = other.getQlikId();
        if (this$qlikId == null ? other$qlikId != null : !this$qlikId.equals(other$qlikId)) return false;
        final java.lang.Object this$qlikOwnerId = this.getQlikOwnerId();
        final java.lang.Object other$qlikOwnerId = other.getQlikOwnerId();
        if (this$qlikOwnerId == null ? other$qlikOwnerId != null : !this$qlikOwnerId.equals(other$qlikOwnerId)) return false;
        final java.lang.Object this$qlikQRI = this.getQlikQRI();
        final java.lang.Object other$qlikQRI = other.getQlikQRI();
        if (this$qlikQRI == null ? other$qlikQRI != null : !this$qlikQRI.equals(other$qlikQRI)) return false;
        final java.lang.Object this$qlikSpaceId = this.getQlikSpaceId();
        final java.lang.Object other$qlikSpaceId = other.getQlikSpaceId();
        if (this$qlikSpaceId == null ? other$qlikSpaceId != null : !this$qlikSpaceId.equals(other$qlikSpaceId)) return false;
        final java.lang.Object this$qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        final java.lang.Object other$qlikSpaceQualifiedName = other.getQlikSpaceQualifiedName();
        if (this$qlikSpaceQualifiedName == null ? other$qlikSpaceQualifiedName != null : !this$qlikSpaceQualifiedName.equals(other$qlikSpaceQualifiedName)) return false;
        final java.lang.Object this$qlikSpaceType = this.getQlikSpaceType();
        final java.lang.Object other$qlikSpaceType = other.getQlikSpaceType();
        if (this$qlikSpaceType == null ? other$qlikSpaceType != null : !this$qlikSpaceType.equals(other$qlikSpaceType)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof QlikStream;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $qlikIsPublished = this.getQlikIsPublished();
        result = result * PRIME + ($qlikIsPublished == null ? 43 : $qlikIsPublished.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $qlikAppId = this.getQlikAppId();
        result = result * PRIME + ($qlikAppId == null ? 43 : $qlikAppId.hashCode());
        final java.lang.Object $qlikAppQualifiedName = this.getQlikAppQualifiedName();
        result = result * PRIME + ($qlikAppQualifiedName == null ? 43 : $qlikAppQualifiedName.hashCode());
        final java.lang.Object $qlikApps = this.getQlikApps();
        result = result * PRIME + ($qlikApps == null ? 43 : $qlikApps.hashCode());
        final java.lang.Object $qlikDatasets = this.getQlikDatasets();
        result = result * PRIME + ($qlikDatasets == null ? 43 : $qlikDatasets.hashCode());
        final java.lang.Object $qlikId = this.getQlikId();
        result = result * PRIME + ($qlikId == null ? 43 : $qlikId.hashCode());
        final java.lang.Object $qlikOwnerId = this.getQlikOwnerId();
        result = result * PRIME + ($qlikOwnerId == null ? 43 : $qlikOwnerId.hashCode());
        final java.lang.Object $qlikQRI = this.getQlikQRI();
        result = result * PRIME + ($qlikQRI == null ? 43 : $qlikQRI.hashCode());
        final java.lang.Object $qlikSpaceId = this.getQlikSpaceId();
        result = result * PRIME + ($qlikSpaceId == null ? 43 : $qlikSpaceId.hashCode());
        final java.lang.Object $qlikSpaceQualifiedName = this.getQlikSpaceQualifiedName();
        result = result * PRIME + ($qlikSpaceQualifiedName == null ? 43 : $qlikSpaceQualifiedName.hashCode());
        final java.lang.Object $qlikSpaceType = this.getQlikSpaceType();
        result = result * PRIME + ($qlikSpaceType == null ? 43 : $qlikSpaceType.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "QlikStream(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", qlikAppId=" + this.getQlikAppId() + ", qlikAppQualifiedName=" + this.getQlikAppQualifiedName() + ", qlikApps=" + this.getQlikApps() + ", qlikDatasets=" + this.getQlikDatasets() + ", qlikId=" + this.getQlikId() + ", qlikIsPublished=" + this.getQlikIsPublished() + ", qlikOwnerId=" + this.getQlikOwnerId() + ", qlikQRI=" + this.getQlikQRI() + ", qlikSpaceId=" + this.getQlikSpaceId() + ", qlikSpaceQualifiedName=" + this.getQlikSpaceQualifiedName() + ", qlikSpaceType=" + this.getQlikSpaceType() + ")";
    }

    /**
     * Fixed typeName for QlikStreams.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
