// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a QuickSight dashboard visual in Atlan. These represent individual visuals inside a dashboard.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class QuickSightDashboardVisual extends Asset implements IQuickSightDashboardVisual, IQuickSight, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(QuickSightDashboardVisual.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QuickSightDashboardVisual";
    /**
     * Fixed typeName for QuickSightDashboardVisuals.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Dashboard in which this visual exists.
     */
    @Attribute
    IQuickSightDashboard quickSightDashboard;
    /**
     * Unique name of the dashboard in which this visual exists.
     */
    @Attribute
    String quickSightDashboardQualifiedName;
    /**
     * TBC
     */
    @Attribute
    String quickSightId;
    /**
     * TBC
     */
    @Attribute
    String quickSightSheetId;
    /**
     * TBC
     */
    @Attribute
    String quickSightSheetName;

    /**
     * Builds the minimal object necessary to create a relationship to a QuickSightDashboardVisual, from a potentially
     * more-complete QuickSightDashboardVisual object.
     *
     * @return the minimal object necessary to relate to the QuickSightDashboardVisual
     * @throws InvalidRequestException if any of the minimal set of required properties for a QuickSightDashboardVisual relationship are not found in the initial object
     */
    @Override
    public QuickSightDashboardVisual trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all QuickSightDashboardVisual assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QuickSightDashboardVisual assets will be included.
     *
     * @return a fluent search that includes all QuickSightDashboardVisual assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all QuickSightDashboardVisual assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QuickSightDashboardVisual assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all QuickSightDashboardVisual assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all QuickSightDashboardVisual assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) QuickSightDashboardVisuals will be included
     * @return a fluent search that includes all QuickSightDashboardVisual assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all QuickSightDashboardVisual assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) QuickSightDashboardVisuals will be included
     * @return a fluent search that includes all QuickSightDashboardVisual assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a QuickSightDashboardVisual by GUID. Use this to create a relationship to this QuickSightDashboardVisual,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the QuickSightDashboardVisual to reference
     * @return reference to a QuickSightDashboardVisual that can be used for defining a relationship to a QuickSightDashboardVisual
     */
    public static QuickSightDashboardVisual refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QuickSightDashboardVisual by GUID. Use this to create a relationship to this QuickSightDashboardVisual,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the QuickSightDashboardVisual to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QuickSightDashboardVisual that can be used for defining a relationship to a QuickSightDashboardVisual
     */
    public static QuickSightDashboardVisual refByGuid(String guid, Reference.SaveSemantic semantic) {
        return QuickSightDashboardVisual._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a QuickSightDashboardVisual by qualifiedName. Use this to create a relationship to this QuickSightDashboardVisual,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the QuickSightDashboardVisual to reference
     * @return reference to a QuickSightDashboardVisual that can be used for defining a relationship to a QuickSightDashboardVisual
     */
    public static QuickSightDashboardVisual refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QuickSightDashboardVisual by qualifiedName. Use this to create a relationship to this QuickSightDashboardVisual,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the QuickSightDashboardVisual to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QuickSightDashboardVisual that can be used for defining a relationship to a QuickSightDashboardVisual
     */
    public static QuickSightDashboardVisual refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return QuickSightDashboardVisual._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a QuickSightDashboardVisual by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the QuickSightDashboardVisual to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QuickSightDashboardVisual, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightDashboardVisual does not exist or the provided GUID is not a QuickSightDashboardVisual
     */
    @JsonIgnore
    public static QuickSightDashboardVisual get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a QuickSightDashboardVisual by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QuickSightDashboardVisual to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QuickSightDashboardVisual, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightDashboardVisual does not exist or the provided GUID is not a QuickSightDashboardVisual
     */
    @JsonIgnore
    public static QuickSightDashboardVisual get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a QuickSightDashboardVisual by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QuickSightDashboardVisual to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full QuickSightDashboardVisual, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightDashboardVisual does not exist or the provided GUID is not a QuickSightDashboardVisual
     */
    @JsonIgnore
    public static QuickSightDashboardVisual get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof QuickSightDashboardVisual) {
                return (QuickSightDashboardVisual) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof QuickSightDashboardVisual) {
                return (QuickSightDashboardVisual) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) QuickSightDashboardVisual to active.
     *
     * @param qualifiedName for the QuickSightDashboardVisual
     * @return true if the QuickSightDashboardVisual is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) QuickSightDashboardVisual to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the QuickSightDashboardVisual
     * @return true if the QuickSightDashboardVisual is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the minimal request necessary to update the QuickSightDashboardVisual, as a builder
     */
    public static QuickSightDashboardVisualBuilder<?, ?> updater(String qualifiedName, String name) {
        return QuickSightDashboardVisual._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a QuickSightDashboardVisual, from a potentially
     * more-complete QuickSightDashboardVisual object.
     *
     * @return the minimal object necessary to update the QuickSightDashboardVisual, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for QuickSightDashboardVisual are not found in the initial object
     */
    @Override
    public QuickSightDashboardVisualBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QuickSightDashboardVisual's owners
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QuickSightDashboardVisual, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan tenant on which to update the QuickSightDashboardVisual's certificate
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QuickSightDashboardVisual, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QuickSightDashboardVisual's certificate
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan tenant on which to update the QuickSightDashboardVisual's announcement
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan client from which to remove the QuickSightDashboardVisual's announcement
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param name of the QuickSightDashboardVisual
     * @return the updated QuickSightDashboardVisual, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the QuickSightDashboardVisual.
     *
     * @param qualifiedName for the QuickSightDashboardVisual
     * @param name human-readable name of the QuickSightDashboardVisual
     * @param terms the list of terms to replace on the QuickSightDashboardVisual, or null to remove all terms from the QuickSightDashboardVisual
     * @return the QuickSightDashboardVisual that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan tenant on which to replace the QuickSightDashboardVisual's assigned terms
     * @param qualifiedName for the QuickSightDashboardVisual
     * @param name human-readable name of the QuickSightDashboardVisual
     * @param terms the list of terms to replace on the QuickSightDashboardVisual, or null to remove all terms from the QuickSightDashboardVisual
     * @return the QuickSightDashboardVisual that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the QuickSightDashboardVisual, without replacing existing terms linked to the QuickSightDashboardVisual.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDashboardVisual's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the QuickSightDashboardVisual
     * @param terms the list of terms to append to the QuickSightDashboardVisual
     * @return the QuickSightDashboardVisual that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the QuickSightDashboardVisual, without replacing existing terms linked to the QuickSightDashboardVisual.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDashboardVisual's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the QuickSightDashboardVisual
     * @param qualifiedName for the QuickSightDashboardVisual
     * @param terms the list of terms to append to the QuickSightDashboardVisual
     * @return the QuickSightDashboardVisual that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a QuickSightDashboardVisual, without replacing all existing terms linked to the QuickSightDashboardVisual.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDashboardVisual's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the QuickSightDashboardVisual
     * @param terms the list of terms to remove from the QuickSightDashboardVisual, which must be referenced by GUID
     * @return the QuickSightDashboardVisual that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a QuickSightDashboardVisual, without replacing all existing terms linked to the QuickSightDashboardVisual.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDashboardVisual's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the QuickSightDashboardVisual
     * @param qualifiedName for the QuickSightDashboardVisual
     * @param terms the list of terms to remove from the QuickSightDashboardVisual, which must be referenced by GUID
     * @return the QuickSightDashboardVisual that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDashboardVisual removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a QuickSightDashboardVisual, without replacing existing Atlan tags linked to the QuickSightDashboardVisual.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDashboardVisual's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QuickSightDashboardVisual
     */
    public static QuickSightDashboardVisual appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QuickSightDashboardVisual, without replacing existing Atlan tags linked to the QuickSightDashboardVisual.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDashboardVisual's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QuickSightDashboardVisual
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QuickSightDashboardVisual
     */
    public static QuickSightDashboardVisual appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QuickSightDashboardVisual, without replacing existing Atlan tags linked to the QuickSightDashboardVisual.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDashboardVisual's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QuickSightDashboardVisual
     */
    public static QuickSightDashboardVisual appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a QuickSightDashboardVisual, without replacing existing Atlan tags linked to the QuickSightDashboardVisual.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDashboardVisual's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QuickSightDashboardVisual
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QuickSightDashboardVisual
     */
    public static QuickSightDashboardVisual appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QuickSightDashboardVisual) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a QuickSightDashboardVisual.
     *
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QuickSightDashboardVisual
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a QuickSightDashboardVisual.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a QuickSightDashboardVisual
     * @param qualifiedName of the QuickSightDashboardVisual
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QuickSightDashboardVisual
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class QuickSightDashboardVisualBuilder<C extends QuickSightDashboardVisual, B extends QuickSightDashboardVisual.QuickSightDashboardVisualBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IQuickSightDashboard quickSightDashboard;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightDashboardQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightSheetId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightSheetName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QuickSightDashboardVisual.QuickSightDashboardVisualBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final QuickSightDashboardVisual instance, final QuickSightDashboardVisual.QuickSightDashboardVisualBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.quickSightDashboard(instance.quickSightDashboard);
            b.quickSightDashboardQualifiedName(instance.quickSightDashboardQualifiedName);
            b.quickSightId(instance.quickSightId);
            b.quickSightSheetId(instance.quickSightSheetId);
            b.quickSightSheetName(instance.quickSightSheetName);
        }

        /**
         * Fixed typeName for QuickSightDashboardVisuals.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Dashboard in which this visual exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDashboard(final IQuickSightDashboard quickSightDashboard) {
            this.quickSightDashboard = quickSightDashboard;
            return self();
        }

        /**
         * Unique name of the dashboard in which this visual exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDashboardQualifiedName(final String quickSightDashboardQualifiedName) {
            this.quickSightDashboardQualifiedName = quickSightDashboardQualifiedName;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightId(final String quickSightId) {
            this.quickSightId = quickSightId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightSheetId(final String quickSightSheetId) {
            this.quickSightSheetId = quickSightSheetId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightSheetName(final String quickSightSheetName) {
            this.quickSightSheetName = quickSightSheetName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QuickSightDashboardVisual.QuickSightDashboardVisualBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", quickSightDashboard=" + this.quickSightDashboard + ", quickSightDashboardQualifiedName=" + this.quickSightDashboardQualifiedName + ", quickSightId=" + this.quickSightId + ", quickSightSheetId=" + this.quickSightSheetId + ", quickSightSheetName=" + this.quickSightSheetName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class QuickSightDashboardVisualBuilderImpl extends QuickSightDashboardVisual.QuickSightDashboardVisualBuilder<QuickSightDashboardVisual, QuickSightDashboardVisual.QuickSightDashboardVisualBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private QuickSightDashboardVisualBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected QuickSightDashboardVisual.QuickSightDashboardVisualBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QuickSightDashboardVisual build() {
            return new QuickSightDashboardVisual(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected QuickSightDashboardVisual(final QuickSightDashboardVisual.QuickSightDashboardVisualBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = QuickSightDashboardVisual.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.quickSightDashboard = b.quickSightDashboard;
        this.quickSightDashboardQualifiedName = b.quickSightDashboardQualifiedName;
        this.quickSightId = b.quickSightId;
        this.quickSightSheetId = b.quickSightSheetId;
        this.quickSightSheetName = b.quickSightSheetName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static QuickSightDashboardVisual.QuickSightDashboardVisualBuilder<?, ?> _internal() {
        return new QuickSightDashboardVisual.QuickSightDashboardVisualBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QuickSightDashboardVisual.QuickSightDashboardVisualBuilder<?, ?> toBuilder() {
        return new QuickSightDashboardVisual.QuickSightDashboardVisualBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Dashboard in which this visual exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IQuickSightDashboard getQuickSightDashboard() {
        return this.quickSightDashboard;
    }

    /**
     * Unique name of the dashboard in which this visual exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightDashboardQualifiedName() {
        return this.quickSightDashboardQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightId() {
        return this.quickSightId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightSheetId() {
        return this.quickSightSheetId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightSheetName() {
        return this.quickSightSheetName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof QuickSightDashboardVisual)) return false;
        final QuickSightDashboardVisual other = (QuickSightDashboardVisual) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$quickSightDashboard = this.getQuickSightDashboard();
        final java.lang.Object other$quickSightDashboard = other.getQuickSightDashboard();
        if (this$quickSightDashboard == null ? other$quickSightDashboard != null : !this$quickSightDashboard.equals(other$quickSightDashboard)) return false;
        final java.lang.Object this$quickSightDashboardQualifiedName = this.getQuickSightDashboardQualifiedName();
        final java.lang.Object other$quickSightDashboardQualifiedName = other.getQuickSightDashboardQualifiedName();
        if (this$quickSightDashboardQualifiedName == null ? other$quickSightDashboardQualifiedName != null : !this$quickSightDashboardQualifiedName.equals(other$quickSightDashboardQualifiedName)) return false;
        final java.lang.Object this$quickSightId = this.getQuickSightId();
        final java.lang.Object other$quickSightId = other.getQuickSightId();
        if (this$quickSightId == null ? other$quickSightId != null : !this$quickSightId.equals(other$quickSightId)) return false;
        final java.lang.Object this$quickSightSheetId = this.getQuickSightSheetId();
        final java.lang.Object other$quickSightSheetId = other.getQuickSightSheetId();
        if (this$quickSightSheetId == null ? other$quickSightSheetId != null : !this$quickSightSheetId.equals(other$quickSightSheetId)) return false;
        final java.lang.Object this$quickSightSheetName = this.getQuickSightSheetName();
        final java.lang.Object other$quickSightSheetName = other.getQuickSightSheetName();
        if (this$quickSightSheetName == null ? other$quickSightSheetName != null : !this$quickSightSheetName.equals(other$quickSightSheetName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof QuickSightDashboardVisual;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $quickSightDashboard = this.getQuickSightDashboard();
        result = result * PRIME + ($quickSightDashboard == null ? 43 : $quickSightDashboard.hashCode());
        final java.lang.Object $quickSightDashboardQualifiedName = this.getQuickSightDashboardQualifiedName();
        result = result * PRIME + ($quickSightDashboardQualifiedName == null ? 43 : $quickSightDashboardQualifiedName.hashCode());
        final java.lang.Object $quickSightId = this.getQuickSightId();
        result = result * PRIME + ($quickSightId == null ? 43 : $quickSightId.hashCode());
        final java.lang.Object $quickSightSheetId = this.getQuickSightSheetId();
        result = result * PRIME + ($quickSightSheetId == null ? 43 : $quickSightSheetId.hashCode());
        final java.lang.Object $quickSightSheetName = this.getQuickSightSheetName();
        result = result * PRIME + ($quickSightSheetName == null ? 43 : $quickSightSheetName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "QuickSightDashboardVisual(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", quickSightDashboard=" + this.getQuickSightDashboard() + ", quickSightDashboardQualifiedName=" + this.getQuickSightDashboardQualifiedName() + ", quickSightId=" + this.getQuickSightId() + ", quickSightSheetId=" + this.getQuickSightSheetId() + ", quickSightSheetName=" + this.getQuickSightSheetName() + ")";
    }

    /**
     * Fixed typeName for QuickSightDashboardVisuals.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
