// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.QuickSightDatasetImportMode;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a QuickSight dataset in Atlan. These are an internal data model built to be used by analysis. In a dataset, data can be pulled from different sources, joined, filtered, and columns translated to more business-friendly names when preparing the data for visualizing in the analysis layer.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class QuickSightDataset extends Asset implements IQuickSightDataset, IQuickSight, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(QuickSightDataset.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QuickSightDataset";
    /**
     * Fixed typeName for QuickSightDatasets.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Number of columns present in this dataset.
     */
    @Attribute
    Long quickSightDatasetColumnCount;
    /**
     * Fields that exist within this dataset.
     */
    @Attribute
    SortedSet<IQuickSightDatasetField> quickSightDatasetFields;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IQuickSightFolder> quickSightDatasetFolders;
    /**
     * Import mode for this dataset, for example: SPICE or DIRECT_QUERY.
     */
    @Attribute
    QuickSightDatasetImportMode quickSightDatasetImportMode;
    /**
     * TBC
     */
    @Attribute
    String quickSightId;
    /**
     * TBC
     */
    @Attribute
    String quickSightSheetId;
    /**
     * TBC
     */
    @Attribute
    String quickSightSheetName;

    /**
     * Builds the minimal object necessary to create a relationship to a QuickSightDataset, from a potentially
     * more-complete QuickSightDataset object.
     *
     * @return the minimal object necessary to relate to the QuickSightDataset
     * @throws InvalidRequestException if any of the minimal set of required properties for a QuickSightDataset relationship are not found in the initial object
     */
    @Override
    public QuickSightDataset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all QuickSightDataset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QuickSightDataset assets will be included.
     *
     * @return a fluent search that includes all QuickSightDataset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all QuickSightDataset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QuickSightDataset assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all QuickSightDataset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all QuickSightDataset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) QuickSightDatasets will be included
     * @return a fluent search that includes all QuickSightDataset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all QuickSightDataset assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) QuickSightDatasets will be included
     * @return a fluent search that includes all QuickSightDataset assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a QuickSightDataset by GUID. Use this to create a relationship to this QuickSightDataset,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the QuickSightDataset to reference
     * @return reference to a QuickSightDataset that can be used for defining a relationship to a QuickSightDataset
     */
    public static QuickSightDataset refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QuickSightDataset by GUID. Use this to create a relationship to this QuickSightDataset,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the QuickSightDataset to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QuickSightDataset that can be used for defining a relationship to a QuickSightDataset
     */
    public static QuickSightDataset refByGuid(String guid, Reference.SaveSemantic semantic) {
        return QuickSightDataset._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a QuickSightDataset by qualifiedName. Use this to create a relationship to this QuickSightDataset,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the QuickSightDataset to reference
     * @return reference to a QuickSightDataset that can be used for defining a relationship to a QuickSightDataset
     */
    public static QuickSightDataset refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QuickSightDataset by qualifiedName. Use this to create a relationship to this QuickSightDataset,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the QuickSightDataset to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QuickSightDataset that can be used for defining a relationship to a QuickSightDataset
     */
    public static QuickSightDataset refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return QuickSightDataset._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a QuickSightDataset by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the QuickSightDataset to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QuickSightDataset, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightDataset does not exist or the provided GUID is not a QuickSightDataset
     */
    @JsonIgnore
    public static QuickSightDataset get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a QuickSightDataset by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QuickSightDataset to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QuickSightDataset, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightDataset does not exist or the provided GUID is not a QuickSightDataset
     */
    @JsonIgnore
    public static QuickSightDataset get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a QuickSightDataset by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QuickSightDataset to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full QuickSightDataset, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightDataset does not exist or the provided GUID is not a QuickSightDataset
     */
    @JsonIgnore
    public static QuickSightDataset get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof QuickSightDataset) {
                return (QuickSightDataset) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof QuickSightDataset) {
                return (QuickSightDataset) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) QuickSightDataset to active.
     *
     * @param qualifiedName for the QuickSightDataset
     * @return true if the QuickSightDataset is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) QuickSightDataset to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the QuickSightDataset
     * @return true if the QuickSightDataset is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the minimal request necessary to update the QuickSightDataset, as a builder
     */
    public static QuickSightDatasetBuilder<?, ?> updater(String qualifiedName, String name) {
        return QuickSightDataset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a QuickSightDataset, from a potentially
     * more-complete QuickSightDataset object.
     *
     * @return the minimal object necessary to update the QuickSightDataset, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for QuickSightDataset are not found in the initial object
     */
    @Override
    public QuickSightDatasetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a QuickSightDataset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDataset) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a QuickSightDataset.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDataset) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a QuickSightDataset.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QuickSightDataset's owners
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDataset) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QuickSightDataset, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a QuickSightDataset.
     *
     * @param client connectivity to the Atlan tenant on which to update the QuickSightDataset's certificate
     * @param qualifiedName of the QuickSightDataset
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QuickSightDataset, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QuickSightDataset) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a QuickSightDataset.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QuickSightDataset's certificate
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDataset) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a QuickSightDataset.
     *
     * @param client connectivity to the Atlan tenant on which to update the QuickSightDataset's announcement
     * @param qualifiedName of the QuickSightDataset
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QuickSightDataset) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a QuickSightDataset.
     *
     * @param client connectivity to the Atlan client from which to remove the QuickSightDataset's announcement
     * @param qualifiedName of the QuickSightDataset
     * @param name of the QuickSightDataset
     * @return the updated QuickSightDataset, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDataset) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the QuickSightDataset.
     *
     * @param qualifiedName for the QuickSightDataset
     * @param name human-readable name of the QuickSightDataset
     * @param terms the list of terms to replace on the QuickSightDataset, or null to remove all terms from the QuickSightDataset
     * @return the QuickSightDataset that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the QuickSightDataset.
     *
     * @param client connectivity to the Atlan tenant on which to replace the QuickSightDataset's assigned terms
     * @param qualifiedName for the QuickSightDataset
     * @param name human-readable name of the QuickSightDataset
     * @param terms the list of terms to replace on the QuickSightDataset, or null to remove all terms from the QuickSightDataset
     * @return the QuickSightDataset that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDataset) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the QuickSightDataset, without replacing existing terms linked to the QuickSightDataset.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDataset's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the QuickSightDataset
     * @param terms the list of terms to append to the QuickSightDataset
     * @return the QuickSightDataset that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the QuickSightDataset, without replacing existing terms linked to the QuickSightDataset.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDataset's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the QuickSightDataset
     * @param qualifiedName for the QuickSightDataset
     * @param terms the list of terms to append to the QuickSightDataset
     * @return the QuickSightDataset that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDataset) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a QuickSightDataset, without replacing all existing terms linked to the QuickSightDataset.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDataset's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the QuickSightDataset
     * @param terms the list of terms to remove from the QuickSightDataset, which must be referenced by GUID
     * @return the QuickSightDataset that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a QuickSightDataset, without replacing all existing terms linked to the QuickSightDataset.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDataset's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the QuickSightDataset
     * @param qualifiedName for the QuickSightDataset
     * @param terms the list of terms to remove from the QuickSightDataset, which must be referenced by GUID
     * @return the QuickSightDataset that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightDataset removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDataset) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a QuickSightDataset, without replacing existing Atlan tags linked to the QuickSightDataset.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDataset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QuickSightDataset
     */
    public static QuickSightDataset appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QuickSightDataset, without replacing existing Atlan tags linked to the QuickSightDataset.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDataset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QuickSightDataset
     * @param qualifiedName of the QuickSightDataset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QuickSightDataset
     */
    public static QuickSightDataset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QuickSightDataset) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QuickSightDataset, without replacing existing Atlan tags linked to the QuickSightDataset.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDataset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QuickSightDataset
     */
    public static QuickSightDataset appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a QuickSightDataset, without replacing existing Atlan tags linked to the QuickSightDataset.
     * Note: this operation must make two API calls — one to retrieve the QuickSightDataset's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QuickSightDataset
     * @param qualifiedName of the QuickSightDataset
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QuickSightDataset
     */
    public static QuickSightDataset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QuickSightDataset) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a QuickSightDataset.
     *
     * @param qualifiedName of the QuickSightDataset
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QuickSightDataset
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a QuickSightDataset.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a QuickSightDataset
     * @param qualifiedName of the QuickSightDataset
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QuickSightDataset
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class QuickSightDatasetBuilder<C extends QuickSightDataset, B extends QuickSightDataset.QuickSightDatasetBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long quickSightDatasetColumnCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IQuickSightDatasetField> quickSightDatasetFields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IQuickSightFolder> quickSightDatasetFolders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private QuickSightDatasetImportMode quickSightDatasetImportMode;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightSheetId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightSheetName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QuickSightDataset.QuickSightDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final QuickSightDataset instance, final QuickSightDataset.QuickSightDatasetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.quickSightDatasetColumnCount(instance.quickSightDatasetColumnCount);
            b.quickSightDatasetFields(instance.quickSightDatasetFields == null ? java.util.Collections.<IQuickSightDatasetField>emptySortedSet() : instance.quickSightDatasetFields);
            b.quickSightDatasetFolders(instance.quickSightDatasetFolders == null ? java.util.Collections.<IQuickSightFolder>emptySortedSet() : instance.quickSightDatasetFolders);
            b.quickSightDatasetImportMode(instance.quickSightDatasetImportMode);
            b.quickSightId(instance.quickSightId);
            b.quickSightSheetId(instance.quickSightSheetId);
            b.quickSightSheetName(instance.quickSightSheetName);
        }

        /**
         * Fixed typeName for QuickSightDatasets.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Number of columns present in this dataset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDatasetColumnCount(final Long quickSightDatasetColumnCount) {
            this.quickSightDatasetColumnCount = quickSightDatasetColumnCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDatasetField(final IQuickSightDatasetField quickSightDatasetField) {
            if (this.quickSightDatasetFields == null) this.quickSightDatasetFields = new java.util.ArrayList<IQuickSightDatasetField>();
            this.quickSightDatasetFields.add(quickSightDatasetField);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDatasetFields(final java.util.Collection<? extends IQuickSightDatasetField> quickSightDatasetFields) {
            if (quickSightDatasetFields == null) {
                throw new java.lang.NullPointerException("quickSightDatasetFields cannot be null");
            }
            if (this.quickSightDatasetFields == null) this.quickSightDatasetFields = new java.util.ArrayList<IQuickSightDatasetField>();
            this.quickSightDatasetFields.addAll(quickSightDatasetFields);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQuickSightDatasetFields() {
            if (this.quickSightDatasetFields != null) this.quickSightDatasetFields.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDatasetFolder(final IQuickSightFolder quickSightDatasetFolder) {
            if (this.quickSightDatasetFolders == null) this.quickSightDatasetFolders = new java.util.ArrayList<IQuickSightFolder>();
            this.quickSightDatasetFolders.add(quickSightDatasetFolder);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDatasetFolders(final java.util.Collection<? extends IQuickSightFolder> quickSightDatasetFolders) {
            if (quickSightDatasetFolders == null) {
                throw new java.lang.NullPointerException("quickSightDatasetFolders cannot be null");
            }
            if (this.quickSightDatasetFolders == null) this.quickSightDatasetFolders = new java.util.ArrayList<IQuickSightFolder>();
            this.quickSightDatasetFolders.addAll(quickSightDatasetFolders);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQuickSightDatasetFolders() {
            if (this.quickSightDatasetFolders != null) this.quickSightDatasetFolders.clear();
            return self();
        }

        /**
         * Import mode for this dataset, for example: SPICE or DIRECT_QUERY.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDatasetImportMode(final QuickSightDatasetImportMode quickSightDatasetImportMode) {
            this.quickSightDatasetImportMode = quickSightDatasetImportMode;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightId(final String quickSightId) {
            this.quickSightId = quickSightId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightSheetId(final String quickSightSheetId) {
            this.quickSightSheetId = quickSightSheetId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightSheetName(final String quickSightSheetName) {
            this.quickSightSheetName = quickSightSheetName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QuickSightDataset.QuickSightDatasetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", quickSightDatasetColumnCount=" + this.quickSightDatasetColumnCount + ", quickSightDatasetFields=" + this.quickSightDatasetFields + ", quickSightDatasetFolders=" + this.quickSightDatasetFolders + ", quickSightDatasetImportMode=" + this.quickSightDatasetImportMode + ", quickSightId=" + this.quickSightId + ", quickSightSheetId=" + this.quickSightSheetId + ", quickSightSheetName=" + this.quickSightSheetName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class QuickSightDatasetBuilderImpl extends QuickSightDataset.QuickSightDatasetBuilder<QuickSightDataset, QuickSightDataset.QuickSightDatasetBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private QuickSightDatasetBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected QuickSightDataset.QuickSightDatasetBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QuickSightDataset build() {
            return new QuickSightDataset(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected QuickSightDataset(final QuickSightDataset.QuickSightDatasetBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = QuickSightDataset.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.quickSightDatasetColumnCount = b.quickSightDatasetColumnCount;
        java.util.SortedSet<IQuickSightDatasetField> quickSightDatasetFields = new java.util.TreeSet<IQuickSightDatasetField>();
        if (b.quickSightDatasetFields != null) quickSightDatasetFields.addAll(b.quickSightDatasetFields);
        quickSightDatasetFields = java.util.Collections.unmodifiableSortedSet(quickSightDatasetFields);
        this.quickSightDatasetFields = quickSightDatasetFields;
        java.util.SortedSet<IQuickSightFolder> quickSightDatasetFolders = new java.util.TreeSet<IQuickSightFolder>();
        if (b.quickSightDatasetFolders != null) quickSightDatasetFolders.addAll(b.quickSightDatasetFolders);
        quickSightDatasetFolders = java.util.Collections.unmodifiableSortedSet(quickSightDatasetFolders);
        this.quickSightDatasetFolders = quickSightDatasetFolders;
        this.quickSightDatasetImportMode = b.quickSightDatasetImportMode;
        this.quickSightId = b.quickSightId;
        this.quickSightSheetId = b.quickSightSheetId;
        this.quickSightSheetName = b.quickSightSheetName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static QuickSightDataset.QuickSightDatasetBuilder<?, ?> _internal() {
        return new QuickSightDataset.QuickSightDatasetBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QuickSightDataset.QuickSightDatasetBuilder<?, ?> toBuilder() {
        return new QuickSightDataset.QuickSightDatasetBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Number of columns present in this dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQuickSightDatasetColumnCount() {
        return this.quickSightDatasetColumnCount;
    }

    /**
     * Fields that exist within this dataset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IQuickSightDatasetField> getQuickSightDatasetFields() {
        return this.quickSightDatasetFields;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IQuickSightFolder> getQuickSightDatasetFolders() {
        return this.quickSightDatasetFolders;
    }

    /**
     * Import mode for this dataset, for example: SPICE or DIRECT_QUERY.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QuickSightDatasetImportMode getQuickSightDatasetImportMode() {
        return this.quickSightDatasetImportMode;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightId() {
        return this.quickSightId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightSheetId() {
        return this.quickSightSheetId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightSheetName() {
        return this.quickSightSheetName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof QuickSightDataset)) return false;
        final QuickSightDataset other = (QuickSightDataset) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$quickSightDatasetColumnCount = this.getQuickSightDatasetColumnCount();
        final java.lang.Object other$quickSightDatasetColumnCount = other.getQuickSightDatasetColumnCount();
        if (this$quickSightDatasetColumnCount == null ? other$quickSightDatasetColumnCount != null : !this$quickSightDatasetColumnCount.equals(other$quickSightDatasetColumnCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$quickSightDatasetFields = this.getQuickSightDatasetFields();
        final java.lang.Object other$quickSightDatasetFields = other.getQuickSightDatasetFields();
        if (this$quickSightDatasetFields == null ? other$quickSightDatasetFields != null : !this$quickSightDatasetFields.equals(other$quickSightDatasetFields)) return false;
        final java.lang.Object this$quickSightDatasetFolders = this.getQuickSightDatasetFolders();
        final java.lang.Object other$quickSightDatasetFolders = other.getQuickSightDatasetFolders();
        if (this$quickSightDatasetFolders == null ? other$quickSightDatasetFolders != null : !this$quickSightDatasetFolders.equals(other$quickSightDatasetFolders)) return false;
        final java.lang.Object this$quickSightDatasetImportMode = this.getQuickSightDatasetImportMode();
        final java.lang.Object other$quickSightDatasetImportMode = other.getQuickSightDatasetImportMode();
        if (this$quickSightDatasetImportMode == null ? other$quickSightDatasetImportMode != null : !this$quickSightDatasetImportMode.equals(other$quickSightDatasetImportMode)) return false;
        final java.lang.Object this$quickSightId = this.getQuickSightId();
        final java.lang.Object other$quickSightId = other.getQuickSightId();
        if (this$quickSightId == null ? other$quickSightId != null : !this$quickSightId.equals(other$quickSightId)) return false;
        final java.lang.Object this$quickSightSheetId = this.getQuickSightSheetId();
        final java.lang.Object other$quickSightSheetId = other.getQuickSightSheetId();
        if (this$quickSightSheetId == null ? other$quickSightSheetId != null : !this$quickSightSheetId.equals(other$quickSightSheetId)) return false;
        final java.lang.Object this$quickSightSheetName = this.getQuickSightSheetName();
        final java.lang.Object other$quickSightSheetName = other.getQuickSightSheetName();
        if (this$quickSightSheetName == null ? other$quickSightSheetName != null : !this$quickSightSheetName.equals(other$quickSightSheetName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof QuickSightDataset;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $quickSightDatasetColumnCount = this.getQuickSightDatasetColumnCount();
        result = result * PRIME + ($quickSightDatasetColumnCount == null ? 43 : $quickSightDatasetColumnCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $quickSightDatasetFields = this.getQuickSightDatasetFields();
        result = result * PRIME + ($quickSightDatasetFields == null ? 43 : $quickSightDatasetFields.hashCode());
        final java.lang.Object $quickSightDatasetFolders = this.getQuickSightDatasetFolders();
        result = result * PRIME + ($quickSightDatasetFolders == null ? 43 : $quickSightDatasetFolders.hashCode());
        final java.lang.Object $quickSightDatasetImportMode = this.getQuickSightDatasetImportMode();
        result = result * PRIME + ($quickSightDatasetImportMode == null ? 43 : $quickSightDatasetImportMode.hashCode());
        final java.lang.Object $quickSightId = this.getQuickSightId();
        result = result * PRIME + ($quickSightId == null ? 43 : $quickSightId.hashCode());
        final java.lang.Object $quickSightSheetId = this.getQuickSightSheetId();
        result = result * PRIME + ($quickSightSheetId == null ? 43 : $quickSightSheetId.hashCode());
        final java.lang.Object $quickSightSheetName = this.getQuickSightSheetName();
        result = result * PRIME + ($quickSightSheetName == null ? 43 : $quickSightSheetName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "QuickSightDataset(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", quickSightDatasetColumnCount=" + this.getQuickSightDatasetColumnCount() + ", quickSightDatasetFields=" + this.getQuickSightDatasetFields() + ", quickSightDatasetFolders=" + this.getQuickSightDatasetFolders() + ", quickSightDatasetImportMode=" + this.getQuickSightDatasetImportMode() + ", quickSightId=" + this.getQuickSightId() + ", quickSightSheetId=" + this.getQuickSightSheetId() + ", quickSightSheetName=" + this.getQuickSightSheetName() + ")";
    }

    /**
     * Fixed typeName for QuickSightDatasets.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
