// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.QuickSightFolderType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a QuickSight folder in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class QuickSightFolder extends Asset implements IQuickSightFolder, IQuickSight, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(QuickSightFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QuickSightFolder";
    /**
     * Fixed typeName for QuickSightFolders.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IQuickSightAnalysis> quickSightAnalyses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IQuickSightDashboard> quickSightDashboards;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IQuickSightDataset> quickSightDatasets;
    /**
     * Detailed path of this folder.
     */
    @Attribute
    List<Map<String, String>> quickSightFolderHierarchy;
    /**
     * Type of this folder, for example: SHARED.
     */
    @Attribute
    QuickSightFolderType quickSightFolderType;
    /**
     * TBC
     */
    @Attribute
    String quickSightId;
    /**
     * TBC
     */
    @Attribute
    String quickSightSheetId;
    /**
     * TBC
     */
    @Attribute
    String quickSightSheetName;

    /**
     * Builds the minimal object necessary to create a relationship to a QuickSightFolder, from a potentially
     * more-complete QuickSightFolder object.
     *
     * @return the minimal object necessary to relate to the QuickSightFolder
     * @throws InvalidRequestException if any of the minimal set of required properties for a QuickSightFolder relationship are not found in the initial object
     */
    @Override
    public QuickSightFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all QuickSightFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QuickSightFolder assets will be included.
     *
     * @return a fluent search that includes all QuickSightFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all QuickSightFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) QuickSightFolder assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all QuickSightFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all QuickSightFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) QuickSightFolders will be included
     * @return a fluent search that includes all QuickSightFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all QuickSightFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) QuickSightFolders will be included
     * @return a fluent search that includes all QuickSightFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a QuickSightFolder by GUID. Use this to create a relationship to this QuickSightFolder,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the QuickSightFolder to reference
     * @return reference to a QuickSightFolder that can be used for defining a relationship to a QuickSightFolder
     */
    public static QuickSightFolder refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QuickSightFolder by GUID. Use this to create a relationship to this QuickSightFolder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the QuickSightFolder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QuickSightFolder that can be used for defining a relationship to a QuickSightFolder
     */
    public static QuickSightFolder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return QuickSightFolder._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a QuickSightFolder by qualifiedName. Use this to create a relationship to this QuickSightFolder,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the QuickSightFolder to reference
     * @return reference to a QuickSightFolder that can be used for defining a relationship to a QuickSightFolder
     */
    public static QuickSightFolder refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a QuickSightFolder by qualifiedName. Use this to create a relationship to this QuickSightFolder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the QuickSightFolder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a QuickSightFolder that can be used for defining a relationship to a QuickSightFolder
     */
    public static QuickSightFolder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return QuickSightFolder._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a QuickSightFolder by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the QuickSightFolder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QuickSightFolder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightFolder does not exist or the provided GUID is not a QuickSightFolder
     */
    @JsonIgnore
    public static QuickSightFolder get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a QuickSightFolder by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QuickSightFolder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full QuickSightFolder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightFolder does not exist or the provided GUID is not a QuickSightFolder
     */
    @JsonIgnore
    public static QuickSightFolder get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a QuickSightFolder by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the QuickSightFolder to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full QuickSightFolder, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the QuickSightFolder does not exist or the provided GUID is not a QuickSightFolder
     */
    @JsonIgnore
    public static QuickSightFolder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof QuickSightFolder) {
                return (QuickSightFolder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof QuickSightFolder) {
                return (QuickSightFolder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) QuickSightFolder to active.
     *
     * @param qualifiedName for the QuickSightFolder
     * @return true if the QuickSightFolder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) QuickSightFolder to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the QuickSightFolder
     * @return true if the QuickSightFolder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the minimal request necessary to update the QuickSightFolder, as a builder
     */
    public static QuickSightFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return QuickSightFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a QuickSightFolder, from a potentially
     * more-complete QuickSightFolder object.
     *
     * @return the minimal object necessary to update the QuickSightFolder, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for QuickSightFolder are not found in the initial object
     */
    @Override
    public QuickSightFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a QuickSightFolder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a QuickSightFolder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a QuickSightFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QuickSightFolder's owners
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QuickSightFolder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a QuickSightFolder.
     *
     * @param client connectivity to the Atlan tenant on which to update the QuickSightFolder's certificate
     * @param qualifiedName of the QuickSightFolder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated QuickSightFolder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QuickSightFolder) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a QuickSightFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the QuickSightFolder's certificate
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a QuickSightFolder.
     *
     * @param client connectivity to the Atlan tenant on which to update the QuickSightFolder's announcement
     * @param qualifiedName of the QuickSightFolder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QuickSightFolder) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a QuickSightFolder.
     *
     * @param client connectivity to the Atlan client from which to remove the QuickSightFolder's announcement
     * @param qualifiedName of the QuickSightFolder
     * @param name of the QuickSightFolder
     * @return the updated QuickSightFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightFolder) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the QuickSightFolder.
     *
     * @param qualifiedName for the QuickSightFolder
     * @param name human-readable name of the QuickSightFolder
     * @param terms the list of terms to replace on the QuickSightFolder, or null to remove all terms from the QuickSightFolder
     * @return the QuickSightFolder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the QuickSightFolder.
     *
     * @param client connectivity to the Atlan tenant on which to replace the QuickSightFolder's assigned terms
     * @param qualifiedName for the QuickSightFolder
     * @param name human-readable name of the QuickSightFolder
     * @param terms the list of terms to replace on the QuickSightFolder, or null to remove all terms from the QuickSightFolder
     * @return the QuickSightFolder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightFolder) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the QuickSightFolder, without replacing existing terms linked to the QuickSightFolder.
     * Note: this operation must make two API calls — one to retrieve the QuickSightFolder's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the QuickSightFolder
     * @param terms the list of terms to append to the QuickSightFolder
     * @return the QuickSightFolder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the QuickSightFolder, without replacing existing terms linked to the QuickSightFolder.
     * Note: this operation must make two API calls — one to retrieve the QuickSightFolder's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the QuickSightFolder
     * @param qualifiedName for the QuickSightFolder
     * @param terms the list of terms to append to the QuickSightFolder
     * @return the QuickSightFolder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightFolder) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a QuickSightFolder, without replacing all existing terms linked to the QuickSightFolder.
     * Note: this operation must make two API calls — one to retrieve the QuickSightFolder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the QuickSightFolder
     * @param terms the list of terms to remove from the QuickSightFolder, which must be referenced by GUID
     * @return the QuickSightFolder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a QuickSightFolder, without replacing all existing terms linked to the QuickSightFolder.
     * Note: this operation must make two API calls — one to retrieve the QuickSightFolder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the QuickSightFolder
     * @param qualifiedName for the QuickSightFolder
     * @param terms the list of terms to remove from the QuickSightFolder, which must be referenced by GUID
     * @return the QuickSightFolder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static QuickSightFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightFolder) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a QuickSightFolder, without replacing existing Atlan tags linked to the QuickSightFolder.
     * Note: this operation must make two API calls — one to retrieve the QuickSightFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QuickSightFolder
     */
    public static QuickSightFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QuickSightFolder, without replacing existing Atlan tags linked to the QuickSightFolder.
     * Note: this operation must make two API calls — one to retrieve the QuickSightFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QuickSightFolder
     * @param qualifiedName of the QuickSightFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated QuickSightFolder
     */
    public static QuickSightFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QuickSightFolder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a QuickSightFolder, without replacing existing Atlan tags linked to the QuickSightFolder.
     * Note: this operation must make two API calls — one to retrieve the QuickSightFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QuickSightFolder
     */
    public static QuickSightFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a QuickSightFolder, without replacing existing Atlan tags linked to the QuickSightFolder.
     * Note: this operation must make two API calls — one to retrieve the QuickSightFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the QuickSightFolder
     * @param qualifiedName of the QuickSightFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated QuickSightFolder
     */
    public static QuickSightFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QuickSightFolder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a QuickSightFolder.
     *
     * @param qualifiedName of the QuickSightFolder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QuickSightFolder
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a QuickSightFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a QuickSightFolder
     * @param qualifiedName of the QuickSightFolder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the QuickSightFolder
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class QuickSightFolderBuilder<C extends QuickSightFolder, B extends QuickSightFolder.QuickSightFolderBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IQuickSightAnalysis> quickSightAnalyses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IQuickSightDashboard> quickSightDashboards;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IQuickSightDataset> quickSightDatasets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Map<String, String>> quickSightFolderHierarchy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private QuickSightFolderType quickSightFolderType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightSheetId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String quickSightSheetName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            QuickSightFolder.QuickSightFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final QuickSightFolder instance, final QuickSightFolder.QuickSightFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.quickSightAnalyses(instance.quickSightAnalyses == null ? java.util.Collections.<IQuickSightAnalysis>emptySortedSet() : instance.quickSightAnalyses);
            b.quickSightDashboards(instance.quickSightDashboards == null ? java.util.Collections.<IQuickSightDashboard>emptySortedSet() : instance.quickSightDashboards);
            b.quickSightDatasets(instance.quickSightDatasets == null ? java.util.Collections.<IQuickSightDataset>emptySortedSet() : instance.quickSightDatasets);
            b.quickSightFolderHierarchy(instance.quickSightFolderHierarchy == null ? java.util.Collections.<Map<String, String>>emptyList() : instance.quickSightFolderHierarchy);
            b.quickSightFolderType(instance.quickSightFolderType);
            b.quickSightId(instance.quickSightId);
            b.quickSightSheetId(instance.quickSightSheetId);
            b.quickSightSheetName(instance.quickSightSheetName);
        }

        /**
         * Fixed typeName for QuickSightFolders.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightAnalysis(final IQuickSightAnalysis quickSightAnalysis) {
            if (this.quickSightAnalyses == null) this.quickSightAnalyses = new java.util.ArrayList<IQuickSightAnalysis>();
            this.quickSightAnalyses.add(quickSightAnalysis);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightAnalyses(final java.util.Collection<? extends IQuickSightAnalysis> quickSightAnalyses) {
            if (quickSightAnalyses == null) {
                throw new java.lang.NullPointerException("quickSightAnalyses cannot be null");
            }
            if (this.quickSightAnalyses == null) this.quickSightAnalyses = new java.util.ArrayList<IQuickSightAnalysis>();
            this.quickSightAnalyses.addAll(quickSightAnalyses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQuickSightAnalyses() {
            if (this.quickSightAnalyses != null) this.quickSightAnalyses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDashboard(final IQuickSightDashboard quickSightDashboard) {
            if (this.quickSightDashboards == null) this.quickSightDashboards = new java.util.ArrayList<IQuickSightDashboard>();
            this.quickSightDashboards.add(quickSightDashboard);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDashboards(final java.util.Collection<? extends IQuickSightDashboard> quickSightDashboards) {
            if (quickSightDashboards == null) {
                throw new java.lang.NullPointerException("quickSightDashboards cannot be null");
            }
            if (this.quickSightDashboards == null) this.quickSightDashboards = new java.util.ArrayList<IQuickSightDashboard>();
            this.quickSightDashboards.addAll(quickSightDashboards);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQuickSightDashboards() {
            if (this.quickSightDashboards != null) this.quickSightDashboards.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDataset(final IQuickSightDataset quickSightDataset) {
            if (this.quickSightDatasets == null) this.quickSightDatasets = new java.util.ArrayList<IQuickSightDataset>();
            this.quickSightDatasets.add(quickSightDataset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightDatasets(final java.util.Collection<? extends IQuickSightDataset> quickSightDatasets) {
            if (quickSightDatasets == null) {
                throw new java.lang.NullPointerException("quickSightDatasets cannot be null");
            }
            if (this.quickSightDatasets == null) this.quickSightDatasets = new java.util.ArrayList<IQuickSightDataset>();
            this.quickSightDatasets.addAll(quickSightDatasets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQuickSightDatasets() {
            if (this.quickSightDatasets != null) this.quickSightDatasets.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B addQuickSightFolderHierarchy(final Map<String, String> addQuickSightFolderHierarchy) {
            if (this.quickSightFolderHierarchy == null) this.quickSightFolderHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.quickSightFolderHierarchy.add(addQuickSightFolderHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightFolderHierarchy(final java.util.Collection<? extends Map<String, String>> quickSightFolderHierarchy) {
            if (quickSightFolderHierarchy == null) {
                throw new java.lang.NullPointerException("quickSightFolderHierarchy cannot be null");
            }
            if (this.quickSightFolderHierarchy == null) this.quickSightFolderHierarchy = new java.util.ArrayList<Map<String, String>>();
            this.quickSightFolderHierarchy.addAll(quickSightFolderHierarchy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQuickSightFolderHierarchy() {
            if (this.quickSightFolderHierarchy != null) this.quickSightFolderHierarchy.clear();
            return self();
        }

        /**
         * Type of this folder, for example: SHARED.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightFolderType(final QuickSightFolderType quickSightFolderType) {
            this.quickSightFolderType = quickSightFolderType;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightId(final String quickSightId) {
            this.quickSightId = quickSightId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightSheetId(final String quickSightSheetId) {
            this.quickSightSheetId = quickSightSheetId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B quickSightSheetName(final String quickSightSheetName) {
            this.quickSightSheetName = quickSightSheetName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "QuickSightFolder.QuickSightFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", quickSightAnalyses=" + this.quickSightAnalyses + ", quickSightDashboards=" + this.quickSightDashboards + ", quickSightDatasets=" + this.quickSightDatasets + ", quickSightFolderHierarchy=" + this.quickSightFolderHierarchy + ", quickSightFolderType=" + this.quickSightFolderType + ", quickSightId=" + this.quickSightId + ", quickSightSheetId=" + this.quickSightSheetId + ", quickSightSheetName=" + this.quickSightSheetName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class QuickSightFolderBuilderImpl extends QuickSightFolder.QuickSightFolderBuilder<QuickSightFolder, QuickSightFolder.QuickSightFolderBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private QuickSightFolderBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected QuickSightFolder.QuickSightFolderBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public QuickSightFolder build() {
            return new QuickSightFolder(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected QuickSightFolder(final QuickSightFolder.QuickSightFolderBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = QuickSightFolder.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<IQuickSightAnalysis> quickSightAnalyses = new java.util.TreeSet<IQuickSightAnalysis>();
        if (b.quickSightAnalyses != null) quickSightAnalyses.addAll(b.quickSightAnalyses);
        quickSightAnalyses = java.util.Collections.unmodifiableSortedSet(quickSightAnalyses);
        this.quickSightAnalyses = quickSightAnalyses;
        java.util.SortedSet<IQuickSightDashboard> quickSightDashboards = new java.util.TreeSet<IQuickSightDashboard>();
        if (b.quickSightDashboards != null) quickSightDashboards.addAll(b.quickSightDashboards);
        quickSightDashboards = java.util.Collections.unmodifiableSortedSet(quickSightDashboards);
        this.quickSightDashboards = quickSightDashboards;
        java.util.SortedSet<IQuickSightDataset> quickSightDatasets = new java.util.TreeSet<IQuickSightDataset>();
        if (b.quickSightDatasets != null) quickSightDatasets.addAll(b.quickSightDatasets);
        quickSightDatasets = java.util.Collections.unmodifiableSortedSet(quickSightDatasets);
        this.quickSightDatasets = quickSightDatasets;
        java.util.List<Map<String, String>> quickSightFolderHierarchy;
        switch (b.quickSightFolderHierarchy == null ? 0 : b.quickSightFolderHierarchy.size()) {
        case 0: 
            quickSightFolderHierarchy = java.util.Collections.emptyList();
            break;
        case 1: 
            quickSightFolderHierarchy = java.util.Collections.singletonList(b.quickSightFolderHierarchy.get(0));
            break;
        default: 
            quickSightFolderHierarchy = java.util.Collections.unmodifiableList(new java.util.ArrayList<Map<String, String>>(b.quickSightFolderHierarchy));
        }
        this.quickSightFolderHierarchy = quickSightFolderHierarchy;
        this.quickSightFolderType = b.quickSightFolderType;
        this.quickSightId = b.quickSightId;
        this.quickSightSheetId = b.quickSightSheetId;
        this.quickSightSheetName = b.quickSightSheetName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static QuickSightFolder.QuickSightFolderBuilder<?, ?> _internal() {
        return new QuickSightFolder.QuickSightFolderBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QuickSightFolder.QuickSightFolderBuilder<?, ?> toBuilder() {
        return new QuickSightFolder.QuickSightFolderBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IQuickSightAnalysis> getQuickSightAnalyses() {
        return this.quickSightAnalyses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IQuickSightDashboard> getQuickSightDashboards() {
        return this.quickSightDashboards;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IQuickSightDataset> getQuickSightDatasets() {
        return this.quickSightDatasets;
    }

    /**
     * Detailed path of this folder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Map<String, String>> getQuickSightFolderHierarchy() {
        return this.quickSightFolderHierarchy;
    }

    /**
     * Type of this folder, for example: SHARED.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public QuickSightFolderType getQuickSightFolderType() {
        return this.quickSightFolderType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightId() {
        return this.quickSightId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightSheetId() {
        return this.quickSightSheetId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getQuickSightSheetName() {
        return this.quickSightSheetName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof QuickSightFolder)) return false;
        final QuickSightFolder other = (QuickSightFolder) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$quickSightAnalyses = this.getQuickSightAnalyses();
        final java.lang.Object other$quickSightAnalyses = other.getQuickSightAnalyses();
        if (this$quickSightAnalyses == null ? other$quickSightAnalyses != null : !this$quickSightAnalyses.equals(other$quickSightAnalyses)) return false;
        final java.lang.Object this$quickSightDashboards = this.getQuickSightDashboards();
        final java.lang.Object other$quickSightDashboards = other.getQuickSightDashboards();
        if (this$quickSightDashboards == null ? other$quickSightDashboards != null : !this$quickSightDashboards.equals(other$quickSightDashboards)) return false;
        final java.lang.Object this$quickSightDatasets = this.getQuickSightDatasets();
        final java.lang.Object other$quickSightDatasets = other.getQuickSightDatasets();
        if (this$quickSightDatasets == null ? other$quickSightDatasets != null : !this$quickSightDatasets.equals(other$quickSightDatasets)) return false;
        final java.lang.Object this$quickSightFolderHierarchy = this.getQuickSightFolderHierarchy();
        final java.lang.Object other$quickSightFolderHierarchy = other.getQuickSightFolderHierarchy();
        if (this$quickSightFolderHierarchy == null ? other$quickSightFolderHierarchy != null : !this$quickSightFolderHierarchy.equals(other$quickSightFolderHierarchy)) return false;
        final java.lang.Object this$quickSightFolderType = this.getQuickSightFolderType();
        final java.lang.Object other$quickSightFolderType = other.getQuickSightFolderType();
        if (this$quickSightFolderType == null ? other$quickSightFolderType != null : !this$quickSightFolderType.equals(other$quickSightFolderType)) return false;
        final java.lang.Object this$quickSightId = this.getQuickSightId();
        final java.lang.Object other$quickSightId = other.getQuickSightId();
        if (this$quickSightId == null ? other$quickSightId != null : !this$quickSightId.equals(other$quickSightId)) return false;
        final java.lang.Object this$quickSightSheetId = this.getQuickSightSheetId();
        final java.lang.Object other$quickSightSheetId = other.getQuickSightSheetId();
        if (this$quickSightSheetId == null ? other$quickSightSheetId != null : !this$quickSightSheetId.equals(other$quickSightSheetId)) return false;
        final java.lang.Object this$quickSightSheetName = this.getQuickSightSheetName();
        final java.lang.Object other$quickSightSheetName = other.getQuickSightSheetName();
        if (this$quickSightSheetName == null ? other$quickSightSheetName != null : !this$quickSightSheetName.equals(other$quickSightSheetName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof QuickSightFolder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $quickSightAnalyses = this.getQuickSightAnalyses();
        result = result * PRIME + ($quickSightAnalyses == null ? 43 : $quickSightAnalyses.hashCode());
        final java.lang.Object $quickSightDashboards = this.getQuickSightDashboards();
        result = result * PRIME + ($quickSightDashboards == null ? 43 : $quickSightDashboards.hashCode());
        final java.lang.Object $quickSightDatasets = this.getQuickSightDatasets();
        result = result * PRIME + ($quickSightDatasets == null ? 43 : $quickSightDatasets.hashCode());
        final java.lang.Object $quickSightFolderHierarchy = this.getQuickSightFolderHierarchy();
        result = result * PRIME + ($quickSightFolderHierarchy == null ? 43 : $quickSightFolderHierarchy.hashCode());
        final java.lang.Object $quickSightFolderType = this.getQuickSightFolderType();
        result = result * PRIME + ($quickSightFolderType == null ? 43 : $quickSightFolderType.hashCode());
        final java.lang.Object $quickSightId = this.getQuickSightId();
        result = result * PRIME + ($quickSightId == null ? 43 : $quickSightId.hashCode());
        final java.lang.Object $quickSightSheetId = this.getQuickSightSheetId();
        result = result * PRIME + ($quickSightSheetId == null ? 43 : $quickSightSheetId.hashCode());
        final java.lang.Object $quickSightSheetName = this.getQuickSightSheetName();
        result = result * PRIME + ($quickSightSheetName == null ? 43 : $quickSightSheetName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "QuickSightFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", quickSightAnalyses=" + this.getQuickSightAnalyses() + ", quickSightDashboards=" + this.getQuickSightDashboards() + ", quickSightDatasets=" + this.getQuickSightDatasets() + ", quickSightFolderHierarchy=" + this.getQuickSightFolderHierarchy() + ", quickSightFolderType=" + this.getQuickSightFolderType() + ", quickSightId=" + this.getQuickSightId() + ", quickSightSheetId=" + this.getQuickSightSheetId() + ", quickSightSheetName=" + this.getQuickSightSheetName() + ")";
    }

    /**
     * Fixed typeName for QuickSightFolders.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
