// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Redash query in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class RedashQuery extends Asset implements IRedashQuery, IRedash, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(RedashQuery.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "RedashQuery";
    /**
     * Fixed typeName for RedashQuerys.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Whether this asset is published in Redash (true) or not (false).
     */
    @Attribute
    Boolean redashIsPublished;
    /**
     * Time (epoch) when this query was last executed, in milliseconds.
     */
    @Attribute
    @Date
    Long redashQueryLastExecutedAt;
    /**
     * Elapsed time of the last execution of this query.
     */
    @Attribute
    Double redashQueryLastExecutionRuntime;
    /**
     * Parameters of this query.
     */
    @Attribute
    String redashQueryParameters;
    /**
     * SQL code of this query.
     */
    @Attribute
    String redashQuerySQL;
    /**
     * Schedule for this query.
     */
    @Attribute
    Map<String, String> redashQuerySchedule;
    /**
     * Schdule for this query in readable text for overview tab and filtering.
     */
    @Attribute
    String redashQueryScheduleHumanized;
    /**
     * Visualizations that were created by this query.
     */
    @Attribute
    SortedSet<IRedashVisualization> redashVisualizations;

    /**
     * Builds the minimal object necessary to create a relationship to a RedashQuery, from a potentially
     * more-complete RedashQuery object.
     *
     * @return the minimal object necessary to relate to the RedashQuery
     * @throws InvalidRequestException if any of the minimal set of required properties for a RedashQuery relationship are not found in the initial object
     */
    @Override
    public RedashQuery trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all RedashQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) RedashQuery assets will be included.
     *
     * @return a fluent search that includes all RedashQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all RedashQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) RedashQuery assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all RedashQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all RedashQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) RedashQuerys will be included
     * @return a fluent search that includes all RedashQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all RedashQuery assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) RedashQuerys will be included
     * @return a fluent search that includes all RedashQuery assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a RedashQuery by GUID. Use this to create a relationship to this RedashQuery,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the RedashQuery to reference
     * @return reference to a RedashQuery that can be used for defining a relationship to a RedashQuery
     */
    public static RedashQuery refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a RedashQuery by GUID. Use this to create a relationship to this RedashQuery,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the RedashQuery to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a RedashQuery that can be used for defining a relationship to a RedashQuery
     */
    public static RedashQuery refByGuid(String guid, Reference.SaveSemantic semantic) {
        return RedashQuery._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a RedashQuery by qualifiedName. Use this to create a relationship to this RedashQuery,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the RedashQuery to reference
     * @return reference to a RedashQuery that can be used for defining a relationship to a RedashQuery
     */
    public static RedashQuery refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a RedashQuery by qualifiedName. Use this to create a relationship to this RedashQuery,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the RedashQuery to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a RedashQuery that can be used for defining a relationship to a RedashQuery
     */
    public static RedashQuery refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return RedashQuery._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a RedashQuery by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the RedashQuery to retrieve, either its GUID or its full qualifiedName
     * @return the requested full RedashQuery, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the RedashQuery does not exist or the provided GUID is not a RedashQuery
     */
    @JsonIgnore
    public static RedashQuery get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a RedashQuery by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the RedashQuery to retrieve, either its GUID or its full qualifiedName
     * @return the requested full RedashQuery, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the RedashQuery does not exist or the provided GUID is not a RedashQuery
     */
    @JsonIgnore
    public static RedashQuery get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a RedashQuery by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the RedashQuery to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full RedashQuery, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the RedashQuery does not exist or the provided GUID is not a RedashQuery
     */
    @JsonIgnore
    public static RedashQuery get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof RedashQuery) {
                return (RedashQuery) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof RedashQuery) {
                return (RedashQuery) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) RedashQuery to active.
     *
     * @param qualifiedName for the RedashQuery
     * @return true if the RedashQuery is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) RedashQuery to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the RedashQuery
     * @return true if the RedashQuery is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the minimal request necessary to update the RedashQuery, as a builder
     */
    public static RedashQueryBuilder<?, ?> updater(String qualifiedName, String name) {
        return RedashQuery._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a RedashQuery, from a potentially
     * more-complete RedashQuery object.
     *
     * @return the minimal object necessary to update the RedashQuery, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for RedashQuery are not found in the initial object
     */
    @Override
    public RedashQueryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a RedashQuery.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a RedashQuery.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a RedashQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the RedashQuery's owners
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated RedashQuery, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a RedashQuery.
     *
     * @param client connectivity to the Atlan tenant on which to update the RedashQuery's certificate
     * @param qualifiedName of the RedashQuery
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated RedashQuery, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (RedashQuery) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a RedashQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove the RedashQuery's certificate
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a RedashQuery.
     *
     * @param client connectivity to the Atlan tenant on which to update the RedashQuery's announcement
     * @param qualifiedName of the RedashQuery
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (RedashQuery) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a RedashQuery.
     *
     * @param client connectivity to the Atlan client from which to remove the RedashQuery's announcement
     * @param qualifiedName of the RedashQuery
     * @param name of the RedashQuery
     * @return the updated RedashQuery, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashQuery) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the RedashQuery.
     *
     * @param qualifiedName for the RedashQuery
     * @param name human-readable name of the RedashQuery
     * @param terms the list of terms to replace on the RedashQuery, or null to remove all terms from the RedashQuery
     * @return the RedashQuery that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static RedashQuery replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the RedashQuery.
     *
     * @param client connectivity to the Atlan tenant on which to replace the RedashQuery's assigned terms
     * @param qualifiedName for the RedashQuery
     * @param name human-readable name of the RedashQuery
     * @param terms the list of terms to replace on the RedashQuery, or null to remove all terms from the RedashQuery
     * @return the RedashQuery that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static RedashQuery replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashQuery) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the RedashQuery, without replacing existing terms linked to the RedashQuery.
     * Note: this operation must make two API calls — one to retrieve the RedashQuery's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the RedashQuery
     * @param terms the list of terms to append to the RedashQuery
     * @return the RedashQuery that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static RedashQuery appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the RedashQuery, without replacing existing terms linked to the RedashQuery.
     * Note: this operation must make two API calls — one to retrieve the RedashQuery's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the RedashQuery
     * @param qualifiedName for the RedashQuery
     * @param terms the list of terms to append to the RedashQuery
     * @return the RedashQuery that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static RedashQuery appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashQuery) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a RedashQuery, without replacing all existing terms linked to the RedashQuery.
     * Note: this operation must make two API calls — one to retrieve the RedashQuery's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the RedashQuery
     * @param terms the list of terms to remove from the RedashQuery, which must be referenced by GUID
     * @return the RedashQuery that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a RedashQuery, without replacing all existing terms linked to the RedashQuery.
     * Note: this operation must make two API calls — one to retrieve the RedashQuery's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the RedashQuery
     * @param qualifiedName for the RedashQuery
     * @param terms the list of terms to remove from the RedashQuery, which must be referenced by GUID
     * @return the RedashQuery that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static RedashQuery removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashQuery) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a RedashQuery, without replacing existing Atlan tags linked to the RedashQuery.
     * Note: this operation must make two API calls — one to retrieve the RedashQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the RedashQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated RedashQuery
     */
    public static RedashQuery appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a RedashQuery, without replacing existing Atlan tags linked to the RedashQuery.
     * Note: this operation must make two API calls — one to retrieve the RedashQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the RedashQuery
     * @param qualifiedName of the RedashQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated RedashQuery
     */
    public static RedashQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (RedashQuery) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a RedashQuery, without replacing existing Atlan tags linked to the RedashQuery.
     * Note: this operation must make two API calls — one to retrieve the RedashQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the RedashQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated RedashQuery
     */
    public static RedashQuery appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a RedashQuery, without replacing existing Atlan tags linked to the RedashQuery.
     * Note: this operation must make two API calls — one to retrieve the RedashQuery's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the RedashQuery
     * @param qualifiedName of the RedashQuery
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated RedashQuery
     */
    public static RedashQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (RedashQuery) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a RedashQuery.
     *
     * @param qualifiedName of the RedashQuery
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the RedashQuery
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a RedashQuery.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a RedashQuery
     * @param qualifiedName of the RedashQuery
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the RedashQuery
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class RedashQueryBuilder<C extends RedashQuery, B extends RedashQuery.RedashQueryBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean redashIsPublished;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long redashQueryLastExecutedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double redashQueryLastExecutionRuntime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String redashQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String redashQuerySQL;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> redashQuerySchedule$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> redashQuerySchedule$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String redashQueryScheduleHumanized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IRedashVisualization> redashVisualizations;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            RedashQuery.RedashQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final RedashQuery instance, final RedashQuery.RedashQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.redashIsPublished(instance.redashIsPublished);
            b.redashQueryLastExecutedAt(instance.redashQueryLastExecutedAt);
            b.redashQueryLastExecutionRuntime(instance.redashQueryLastExecutionRuntime);
            b.redashQueryParameters(instance.redashQueryParameters);
            b.redashQuerySQL(instance.redashQuerySQL);
            b.redashQuerySchedule(instance.redashQuerySchedule == null ? java.util.Collections.<String, String>emptyMap() : instance.redashQuerySchedule);
            b.redashQueryScheduleHumanized(instance.redashQueryScheduleHumanized);
            b.redashVisualizations(instance.redashVisualizations == null ? java.util.Collections.<IRedashVisualization>emptySortedSet() : instance.redashVisualizations);
        }

        /**
         * Fixed typeName for RedashQuerys.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Whether this asset is published in Redash (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashIsPublished(final Boolean redashIsPublished) {
            this.redashIsPublished = redashIsPublished;
            return self();
        }

        /**
         * Time (epoch) when this query was last executed, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQueryLastExecutedAt(final Long redashQueryLastExecutedAt) {
            this.redashQueryLastExecutedAt = redashQueryLastExecutedAt;
            return self();
        }

        /**
         * Elapsed time of the last execution of this query.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQueryLastExecutionRuntime(final Double redashQueryLastExecutionRuntime) {
            this.redashQueryLastExecutionRuntime = redashQueryLastExecutionRuntime;
            return self();
        }

        /**
         * Parameters of this query.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQueryParameters(final String redashQueryParameters) {
            this.redashQueryParameters = redashQueryParameters;
            return self();
        }

        /**
         * SQL code of this query.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQuerySQL(final String redashQuerySQL) {
            this.redashQuerySQL = redashQuerySQL;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putRedashQuerySchedule(final String putRedashQueryScheduleKey, final String putRedashQueryScheduleValue) {
            if (this.redashQuerySchedule$key == null) {
                this.redashQuerySchedule$key = new java.util.ArrayList<String>();
                this.redashQuerySchedule$value = new java.util.ArrayList<String>();
            }
            this.redashQuerySchedule$key.add(putRedashQueryScheduleKey);
            this.redashQuerySchedule$value.add(putRedashQueryScheduleValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQuerySchedule(final java.util.Map<? extends String, ? extends String> redashQuerySchedule) {
            if (redashQuerySchedule == null) {
                throw new java.lang.NullPointerException("redashQuerySchedule cannot be null");
            }
            if (this.redashQuerySchedule$key == null) {
                this.redashQuerySchedule$key = new java.util.ArrayList<String>();
                this.redashQuerySchedule$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : redashQuerySchedule.entrySet()) {
                this.redashQuerySchedule$key.add($lombokEntry.getKey());
                this.redashQuerySchedule$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRedashQuerySchedule() {
            if (this.redashQuerySchedule$key != null) {
                this.redashQuerySchedule$key.clear();
                this.redashQuerySchedule$value.clear();
            }
            return self();
        }

        /**
         * Schdule for this query in readable text for overview tab and filtering.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQueryScheduleHumanized(final String redashQueryScheduleHumanized) {
            this.redashQueryScheduleHumanized = redashQueryScheduleHumanized;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashVisualization(final IRedashVisualization redashVisualization) {
            if (this.redashVisualizations == null) this.redashVisualizations = new java.util.ArrayList<IRedashVisualization>();
            this.redashVisualizations.add(redashVisualization);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashVisualizations(final java.util.Collection<? extends IRedashVisualization> redashVisualizations) {
            if (redashVisualizations == null) {
                throw new java.lang.NullPointerException("redashVisualizations cannot be null");
            }
            if (this.redashVisualizations == null) this.redashVisualizations = new java.util.ArrayList<IRedashVisualization>();
            this.redashVisualizations.addAll(redashVisualizations);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearRedashVisualizations() {
            if (this.redashVisualizations != null) this.redashVisualizations.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "RedashQuery.RedashQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", redashIsPublished=" + this.redashIsPublished + ", redashQueryLastExecutedAt=" + this.redashQueryLastExecutedAt + ", redashQueryLastExecutionRuntime=" + this.redashQueryLastExecutionRuntime + ", redashQueryParameters=" + this.redashQueryParameters + ", redashQuerySQL=" + this.redashQuerySQL + ", redashQuerySchedule$key=" + this.redashQuerySchedule$key + ", redashQuerySchedule$value=" + this.redashQuerySchedule$value + ", redashQueryScheduleHumanized=" + this.redashQueryScheduleHumanized + ", redashVisualizations=" + this.redashVisualizations + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class RedashQueryBuilderImpl extends RedashQuery.RedashQueryBuilder<RedashQuery, RedashQuery.RedashQueryBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private RedashQueryBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected RedashQuery.RedashQueryBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RedashQuery build() {
            return new RedashQuery(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected RedashQuery(final RedashQuery.RedashQueryBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = RedashQuery.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.redashIsPublished = b.redashIsPublished;
        this.redashQueryLastExecutedAt = b.redashQueryLastExecutedAt;
        this.redashQueryLastExecutionRuntime = b.redashQueryLastExecutionRuntime;
        this.redashQueryParameters = b.redashQueryParameters;
        this.redashQuerySQL = b.redashQuerySQL;
        java.util.Map<String, String> redashQuerySchedule;
        switch (b.redashQuerySchedule$key == null ? 0 : b.redashQuerySchedule$key.size()) {
        case 0: 
            redashQuerySchedule = java.util.Collections.emptyMap();
            break;
        case 1: 
            redashQuerySchedule = java.util.Collections.singletonMap(b.redashQuerySchedule$key.get(0), b.redashQuerySchedule$value.get(0));
            break;
        default: 
            redashQuerySchedule = new java.util.LinkedHashMap<String, String>(b.redashQuerySchedule$key.size() < 1073741824 ? 1 + b.redashQuerySchedule$key.size() + (b.redashQuerySchedule$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.redashQuerySchedule$key.size(); $i++) redashQuerySchedule.put(b.redashQuerySchedule$key.get($i), (String) b.redashQuerySchedule$value.get($i));
            redashQuerySchedule = java.util.Collections.unmodifiableMap(redashQuerySchedule);
        }
        this.redashQuerySchedule = redashQuerySchedule;
        this.redashQueryScheduleHumanized = b.redashQueryScheduleHumanized;
        java.util.SortedSet<IRedashVisualization> redashVisualizations = new java.util.TreeSet<IRedashVisualization>();
        if (b.redashVisualizations != null) redashVisualizations.addAll(b.redashVisualizations);
        redashVisualizations = java.util.Collections.unmodifiableSortedSet(redashVisualizations);
        this.redashVisualizations = redashVisualizations;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static RedashQuery.RedashQueryBuilder<?, ?> _internal() {
        return new RedashQuery.RedashQueryBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RedashQuery.RedashQueryBuilder<?, ?> toBuilder() {
        return new RedashQuery.RedashQueryBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Whether this asset is published in Redash (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRedashIsPublished() {
        return this.redashIsPublished;
    }

    /**
     * Time (epoch) when this query was last executed, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getRedashQueryLastExecutedAt() {
        return this.redashQueryLastExecutedAt;
    }

    /**
     * Elapsed time of the last execution of this query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getRedashQueryLastExecutionRuntime() {
        return this.redashQueryLastExecutionRuntime;
    }

    /**
     * Parameters of this query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRedashQueryParameters() {
        return this.redashQueryParameters;
    }

    /**
     * SQL code of this query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRedashQuerySQL() {
        return this.redashQuerySQL;
    }

    /**
     * Schedule for this query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getRedashQuerySchedule() {
        return this.redashQuerySchedule;
    }

    /**
     * Schdule for this query in readable text for overview tab and filtering.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRedashQueryScheduleHumanized() {
        return this.redashQueryScheduleHumanized;
    }

    /**
     * Visualizations that were created by this query.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IRedashVisualization> getRedashVisualizations() {
        return this.redashVisualizations;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RedashQuery)) return false;
        final RedashQuery other = (RedashQuery) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$redashIsPublished = this.getRedashIsPublished();
        final java.lang.Object other$redashIsPublished = other.getRedashIsPublished();
        if (this$redashIsPublished == null ? other$redashIsPublished != null : !this$redashIsPublished.equals(other$redashIsPublished)) return false;
        final java.lang.Object this$redashQueryLastExecutedAt = this.getRedashQueryLastExecutedAt();
        final java.lang.Object other$redashQueryLastExecutedAt = other.getRedashQueryLastExecutedAt();
        if (this$redashQueryLastExecutedAt == null ? other$redashQueryLastExecutedAt != null : !this$redashQueryLastExecutedAt.equals(other$redashQueryLastExecutedAt)) return false;
        final java.lang.Object this$redashQueryLastExecutionRuntime = this.getRedashQueryLastExecutionRuntime();
        final java.lang.Object other$redashQueryLastExecutionRuntime = other.getRedashQueryLastExecutionRuntime();
        if (this$redashQueryLastExecutionRuntime == null ? other$redashQueryLastExecutionRuntime != null : !this$redashQueryLastExecutionRuntime.equals(other$redashQueryLastExecutionRuntime)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$redashQueryParameters = this.getRedashQueryParameters();
        final java.lang.Object other$redashQueryParameters = other.getRedashQueryParameters();
        if (this$redashQueryParameters == null ? other$redashQueryParameters != null : !this$redashQueryParameters.equals(other$redashQueryParameters)) return false;
        final java.lang.Object this$redashQuerySQL = this.getRedashQuerySQL();
        final java.lang.Object other$redashQuerySQL = other.getRedashQuerySQL();
        if (this$redashQuerySQL == null ? other$redashQuerySQL != null : !this$redashQuerySQL.equals(other$redashQuerySQL)) return false;
        final java.lang.Object this$redashQuerySchedule = this.getRedashQuerySchedule();
        final java.lang.Object other$redashQuerySchedule = other.getRedashQuerySchedule();
        if (this$redashQuerySchedule == null ? other$redashQuerySchedule != null : !this$redashQuerySchedule.equals(other$redashQuerySchedule)) return false;
        final java.lang.Object this$redashQueryScheduleHumanized = this.getRedashQueryScheduleHumanized();
        final java.lang.Object other$redashQueryScheduleHumanized = other.getRedashQueryScheduleHumanized();
        if (this$redashQueryScheduleHumanized == null ? other$redashQueryScheduleHumanized != null : !this$redashQueryScheduleHumanized.equals(other$redashQueryScheduleHumanized)) return false;
        final java.lang.Object this$redashVisualizations = this.getRedashVisualizations();
        final java.lang.Object other$redashVisualizations = other.getRedashVisualizations();
        if (this$redashVisualizations == null ? other$redashVisualizations != null : !this$redashVisualizations.equals(other$redashVisualizations)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof RedashQuery;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $redashIsPublished = this.getRedashIsPublished();
        result = result * PRIME + ($redashIsPublished == null ? 43 : $redashIsPublished.hashCode());
        final java.lang.Object $redashQueryLastExecutedAt = this.getRedashQueryLastExecutedAt();
        result = result * PRIME + ($redashQueryLastExecutedAt == null ? 43 : $redashQueryLastExecutedAt.hashCode());
        final java.lang.Object $redashQueryLastExecutionRuntime = this.getRedashQueryLastExecutionRuntime();
        result = result * PRIME + ($redashQueryLastExecutionRuntime == null ? 43 : $redashQueryLastExecutionRuntime.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $redashQueryParameters = this.getRedashQueryParameters();
        result = result * PRIME + ($redashQueryParameters == null ? 43 : $redashQueryParameters.hashCode());
        final java.lang.Object $redashQuerySQL = this.getRedashQuerySQL();
        result = result * PRIME + ($redashQuerySQL == null ? 43 : $redashQuerySQL.hashCode());
        final java.lang.Object $redashQuerySchedule = this.getRedashQuerySchedule();
        result = result * PRIME + ($redashQuerySchedule == null ? 43 : $redashQuerySchedule.hashCode());
        final java.lang.Object $redashQueryScheduleHumanized = this.getRedashQueryScheduleHumanized();
        result = result * PRIME + ($redashQueryScheduleHumanized == null ? 43 : $redashQueryScheduleHumanized.hashCode());
        final java.lang.Object $redashVisualizations = this.getRedashVisualizations();
        result = result * PRIME + ($redashVisualizations == null ? 43 : $redashVisualizations.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "RedashQuery(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", redashIsPublished=" + this.getRedashIsPublished() + ", redashQueryLastExecutedAt=" + this.getRedashQueryLastExecutedAt() + ", redashQueryLastExecutionRuntime=" + this.getRedashQueryLastExecutionRuntime() + ", redashQueryParameters=" + this.getRedashQueryParameters() + ", redashQuerySQL=" + this.getRedashQuerySQL() + ", redashQuerySchedule=" + this.getRedashQuerySchedule() + ", redashQueryScheduleHumanized=" + this.getRedashQueryScheduleHumanized() + ", redashVisualizations=" + this.getRedashVisualizations() + ")";
    }

    /**
     * Fixed typeName for RedashQuerys.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
