// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Redash visualization in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class RedashVisualization extends Asset implements IRedashVisualization, IRedash, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(RedashVisualization.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "RedashVisualization";
    /**
     * Fixed typeName for RedashVisualizations.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Whether this asset is published in Redash (true) or not (false).
     */
    @Attribute
    Boolean redashIsPublished;
    /**
     * Query which created this visualization.
     */
    @Attribute
    IRedashQuery redashQuery;
    /**
     * Simple name of the query from which this visualization is created.
     */
    @Attribute
    String redashQueryName;
    /**
     * Unique name of the query from which this visualization is created.
     */
    @Attribute
    String redashQueryQualifiedName;
    /**
     * Type of this visualization.
     */
    @Attribute
    String redashVisualizationType;

    /**
     * Builds the minimal object necessary to create a relationship to a RedashVisualization, from a potentially
     * more-complete RedashVisualization object.
     *
     * @return the minimal object necessary to relate to the RedashVisualization
     * @throws InvalidRequestException if any of the minimal set of required properties for a RedashVisualization relationship are not found in the initial object
     */
    @Override
    public RedashVisualization trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all RedashVisualization assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) RedashVisualization assets will be included.
     *
     * @return a fluent search that includes all RedashVisualization assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all RedashVisualization assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) RedashVisualization assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all RedashVisualization assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all RedashVisualization assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) RedashVisualizations will be included
     * @return a fluent search that includes all RedashVisualization assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all RedashVisualization assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) RedashVisualizations will be included
     * @return a fluent search that includes all RedashVisualization assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a RedashVisualization by GUID. Use this to create a relationship to this RedashVisualization,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the RedashVisualization to reference
     * @return reference to a RedashVisualization that can be used for defining a relationship to a RedashVisualization
     */
    public static RedashVisualization refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a RedashVisualization by GUID. Use this to create a relationship to this RedashVisualization,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the RedashVisualization to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a RedashVisualization that can be used for defining a relationship to a RedashVisualization
     */
    public static RedashVisualization refByGuid(String guid, Reference.SaveSemantic semantic) {
        return RedashVisualization._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a RedashVisualization by qualifiedName. Use this to create a relationship to this RedashVisualization,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the RedashVisualization to reference
     * @return reference to a RedashVisualization that can be used for defining a relationship to a RedashVisualization
     */
    public static RedashVisualization refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a RedashVisualization by qualifiedName. Use this to create a relationship to this RedashVisualization,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the RedashVisualization to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a RedashVisualization that can be used for defining a relationship to a RedashVisualization
     */
    public static RedashVisualization refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return RedashVisualization._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a RedashVisualization by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the RedashVisualization to retrieve, either its GUID or its full qualifiedName
     * @return the requested full RedashVisualization, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the RedashVisualization does not exist or the provided GUID is not a RedashVisualization
     */
    @JsonIgnore
    public static RedashVisualization get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a RedashVisualization by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the RedashVisualization to retrieve, either its GUID or its full qualifiedName
     * @return the requested full RedashVisualization, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the RedashVisualization does not exist or the provided GUID is not a RedashVisualization
     */
    @JsonIgnore
    public static RedashVisualization get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a RedashVisualization by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the RedashVisualization to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full RedashVisualization, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the RedashVisualization does not exist or the provided GUID is not a RedashVisualization
     */
    @JsonIgnore
    public static RedashVisualization get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof RedashVisualization) {
                return (RedashVisualization) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof RedashVisualization) {
                return (RedashVisualization) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) RedashVisualization to active.
     *
     * @param qualifiedName for the RedashVisualization
     * @return true if the RedashVisualization is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) RedashVisualization to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the RedashVisualization
     * @return true if the RedashVisualization is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the minimal request necessary to update the RedashVisualization, as a builder
     */
    public static RedashVisualizationBuilder<?, ?> updater(String qualifiedName, String name) {
        return RedashVisualization._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a RedashVisualization, from a potentially
     * more-complete RedashVisualization object.
     *
     * @return the minimal object necessary to update the RedashVisualization, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for RedashVisualization are not found in the initial object
     */
    @Override
    public RedashVisualizationBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a RedashVisualization.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a RedashVisualization.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a RedashVisualization.
     *
     * @param client connectivity to the Atlan tenant from which to remove the RedashVisualization's owners
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated RedashVisualization, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a RedashVisualization.
     *
     * @param client connectivity to the Atlan tenant on which to update the RedashVisualization's certificate
     * @param qualifiedName of the RedashVisualization
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated RedashVisualization, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (RedashVisualization) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a RedashVisualization.
     *
     * @param client connectivity to the Atlan tenant from which to remove the RedashVisualization's certificate
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a RedashVisualization.
     *
     * @param client connectivity to the Atlan tenant on which to update the RedashVisualization's announcement
     * @param qualifiedName of the RedashVisualization
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (RedashVisualization) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a RedashVisualization.
     *
     * @param client connectivity to the Atlan client from which to remove the RedashVisualization's announcement
     * @param qualifiedName of the RedashVisualization
     * @param name of the RedashVisualization
     * @return the updated RedashVisualization, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the RedashVisualization.
     *
     * @param qualifiedName for the RedashVisualization
     * @param name human-readable name of the RedashVisualization
     * @param terms the list of terms to replace on the RedashVisualization, or null to remove all terms from the RedashVisualization
     * @return the RedashVisualization that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the RedashVisualization.
     *
     * @param client connectivity to the Atlan tenant on which to replace the RedashVisualization's assigned terms
     * @param qualifiedName for the RedashVisualization
     * @param name human-readable name of the RedashVisualization
     * @param terms the list of terms to replace on the RedashVisualization, or null to remove all terms from the RedashVisualization
     * @return the RedashVisualization that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashVisualization) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the RedashVisualization, without replacing existing terms linked to the RedashVisualization.
     * Note: this operation must make two API calls — one to retrieve the RedashVisualization's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the RedashVisualization
     * @param terms the list of terms to append to the RedashVisualization
     * @return the RedashVisualization that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the RedashVisualization, without replacing existing terms linked to the RedashVisualization.
     * Note: this operation must make two API calls — one to retrieve the RedashVisualization's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the RedashVisualization
     * @param qualifiedName for the RedashVisualization
     * @param terms the list of terms to append to the RedashVisualization
     * @return the RedashVisualization that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashVisualization) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a RedashVisualization, without replacing all existing terms linked to the RedashVisualization.
     * Note: this operation must make two API calls — one to retrieve the RedashVisualization's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the RedashVisualization
     * @param terms the list of terms to remove from the RedashVisualization, which must be referenced by GUID
     * @return the RedashVisualization that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a RedashVisualization, without replacing all existing terms linked to the RedashVisualization.
     * Note: this operation must make two API calls — one to retrieve the RedashVisualization's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the RedashVisualization
     * @param qualifiedName for the RedashVisualization
     * @param terms the list of terms to remove from the RedashVisualization, which must be referenced by GUID
     * @return the RedashVisualization that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static RedashVisualization removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashVisualization) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a RedashVisualization, without replacing existing Atlan tags linked to the RedashVisualization.
     * Note: this operation must make two API calls — one to retrieve the RedashVisualization's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the RedashVisualization
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated RedashVisualization
     */
    public static RedashVisualization appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a RedashVisualization, without replacing existing Atlan tags linked to the RedashVisualization.
     * Note: this operation must make two API calls — one to retrieve the RedashVisualization's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the RedashVisualization
     * @param qualifiedName of the RedashVisualization
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated RedashVisualization
     */
    public static RedashVisualization appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (RedashVisualization) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a RedashVisualization, without replacing existing Atlan tags linked to the RedashVisualization.
     * Note: this operation must make two API calls — one to retrieve the RedashVisualization's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the RedashVisualization
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated RedashVisualization
     */
    public static RedashVisualization appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a RedashVisualization, without replacing existing Atlan tags linked to the RedashVisualization.
     * Note: this operation must make two API calls — one to retrieve the RedashVisualization's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the RedashVisualization
     * @param qualifiedName of the RedashVisualization
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated RedashVisualization
     */
    public static RedashVisualization appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (RedashVisualization) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a RedashVisualization.
     *
     * @param qualifiedName of the RedashVisualization
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the RedashVisualization
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a RedashVisualization.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a RedashVisualization
     * @param qualifiedName of the RedashVisualization
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the RedashVisualization
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class RedashVisualizationBuilder<C extends RedashVisualization, B extends RedashVisualization.RedashVisualizationBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean redashIsPublished;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IRedashQuery redashQuery;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String redashQueryName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String redashQueryQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String redashVisualizationType;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            RedashVisualization.RedashVisualizationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final RedashVisualization instance, final RedashVisualization.RedashVisualizationBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.redashIsPublished(instance.redashIsPublished);
            b.redashQuery(instance.redashQuery);
            b.redashQueryName(instance.redashQueryName);
            b.redashQueryQualifiedName(instance.redashQueryQualifiedName);
            b.redashVisualizationType(instance.redashVisualizationType);
        }

        /**
         * Fixed typeName for RedashVisualizations.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Whether this asset is published in Redash (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashIsPublished(final Boolean redashIsPublished) {
            this.redashIsPublished = redashIsPublished;
            return self();
        }

        /**
         * Query which created this visualization.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQuery(final IRedashQuery redashQuery) {
            this.redashQuery = redashQuery;
            return self();
        }

        /**
         * Simple name of the query from which this visualization is created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQueryName(final String redashQueryName) {
            this.redashQueryName = redashQueryName;
            return self();
        }

        /**
         * Unique name of the query from which this visualization is created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashQueryQualifiedName(final String redashQueryQualifiedName) {
            this.redashQueryQualifiedName = redashQueryQualifiedName;
            return self();
        }

        /**
         * Type of this visualization.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B redashVisualizationType(final String redashVisualizationType) {
            this.redashVisualizationType = redashVisualizationType;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "RedashVisualization.RedashVisualizationBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", redashIsPublished=" + this.redashIsPublished + ", redashQuery=" + this.redashQuery + ", redashQueryName=" + this.redashQueryName + ", redashQueryQualifiedName=" + this.redashQueryQualifiedName + ", redashVisualizationType=" + this.redashVisualizationType + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class RedashVisualizationBuilderImpl extends RedashVisualization.RedashVisualizationBuilder<RedashVisualization, RedashVisualization.RedashVisualizationBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private RedashVisualizationBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected RedashVisualization.RedashVisualizationBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RedashVisualization build() {
            return new RedashVisualization(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected RedashVisualization(final RedashVisualization.RedashVisualizationBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = RedashVisualization.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.redashIsPublished = b.redashIsPublished;
        this.redashQuery = b.redashQuery;
        this.redashQueryName = b.redashQueryName;
        this.redashQueryQualifiedName = b.redashQueryQualifiedName;
        this.redashVisualizationType = b.redashVisualizationType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static RedashVisualization.RedashVisualizationBuilder<?, ?> _internal() {
        return new RedashVisualization.RedashVisualizationBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RedashVisualization.RedashVisualizationBuilder<?, ?> toBuilder() {
        return new RedashVisualization.RedashVisualizationBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Whether this asset is published in Redash (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getRedashIsPublished() {
        return this.redashIsPublished;
    }

    /**
     * Query which created this visualization.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IRedashQuery getRedashQuery() {
        return this.redashQuery;
    }

    /**
     * Simple name of the query from which this visualization is created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRedashQueryName() {
        return this.redashQueryName;
    }

    /**
     * Unique name of the query from which this visualization is created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRedashQueryQualifiedName() {
        return this.redashQueryQualifiedName;
    }

    /**
     * Type of this visualization.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRedashVisualizationType() {
        return this.redashVisualizationType;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RedashVisualization)) return false;
        final RedashVisualization other = (RedashVisualization) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$redashIsPublished = this.getRedashIsPublished();
        final java.lang.Object other$redashIsPublished = other.getRedashIsPublished();
        if (this$redashIsPublished == null ? other$redashIsPublished != null : !this$redashIsPublished.equals(other$redashIsPublished)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$redashQuery = this.getRedashQuery();
        final java.lang.Object other$redashQuery = other.getRedashQuery();
        if (this$redashQuery == null ? other$redashQuery != null : !this$redashQuery.equals(other$redashQuery)) return false;
        final java.lang.Object this$redashQueryName = this.getRedashQueryName();
        final java.lang.Object other$redashQueryName = other.getRedashQueryName();
        if (this$redashQueryName == null ? other$redashQueryName != null : !this$redashQueryName.equals(other$redashQueryName)) return false;
        final java.lang.Object this$redashQueryQualifiedName = this.getRedashQueryQualifiedName();
        final java.lang.Object other$redashQueryQualifiedName = other.getRedashQueryQualifiedName();
        if (this$redashQueryQualifiedName == null ? other$redashQueryQualifiedName != null : !this$redashQueryQualifiedName.equals(other$redashQueryQualifiedName)) return false;
        final java.lang.Object this$redashVisualizationType = this.getRedashVisualizationType();
        final java.lang.Object other$redashVisualizationType = other.getRedashVisualizationType();
        if (this$redashVisualizationType == null ? other$redashVisualizationType != null : !this$redashVisualizationType.equals(other$redashVisualizationType)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof RedashVisualization;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $redashIsPublished = this.getRedashIsPublished();
        result = result * PRIME + ($redashIsPublished == null ? 43 : $redashIsPublished.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $redashQuery = this.getRedashQuery();
        result = result * PRIME + ($redashQuery == null ? 43 : $redashQuery.hashCode());
        final java.lang.Object $redashQueryName = this.getRedashQueryName();
        result = result * PRIME + ($redashQueryName == null ? 43 : $redashQueryName.hashCode());
        final java.lang.Object $redashQueryQualifiedName = this.getRedashQueryQualifiedName();
        result = result * PRIME + ($redashQueryQualifiedName == null ? 43 : $redashQueryQualifiedName.hashCode());
        final java.lang.Object $redashVisualizationType = this.getRedashVisualizationType();
        result = result * PRIME + ($redashVisualizationType == null ? 43 : $redashVisualizationType.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "RedashVisualization(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", redashIsPublished=" + this.getRedashIsPublished() + ", redashQuery=" + this.getRedashQuery() + ", redashQueryName=" + this.getRedashQueryName() + ", redashQueryQualifiedName=" + this.getRedashQueryQualifiedName() + ", redashVisualizationType=" + this.getRedashVisualizationType() + ")";
    }

    /**
     * Fixed typeName for RedashVisualizations.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
