// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AwsTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an S3 bucket in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class S3Bucket extends Asset implements IS3Bucket, IS3, IObjectStore, IAWS, ICatalog, IAsset, IReferenceable, ICloud {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(S3Bucket.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "S3Bucket";
    /**
     * Fixed typeName for S3Buckets.
     */
    String typeName;
    /**
     * 12-digit number that uniquely identifies an AWS account.
     */
    @Attribute
    String awsAccountId;
    /**
     * Amazon Resource Name (ARN) for this asset. This uniquely identifies the asset in AWS, and thus must be unique across all AWS asset instances.
     */
    @Attribute
    String awsArn;
    /**
     * Root user's ID.
     */
    @Attribute
    String awsOwnerId;
    /**
     * Root user's name.
     */
    @Attribute
    String awsOwnerName;
    /**
     * Group of AWS region and service objects.
     */
    @Attribute
    String awsPartition;
    /**
     * Physical region where the data center in which the asset exists is clustered.
     */
    @Attribute
    String awsRegion;
    /**
     * Unique resource ID assigned when a new resource is created.
     */
    @Attribute
    String awsResourceId;
    /**
     * Type of service in which the asset exists.
     */
    @Attribute
    String awsService;
    /**
     * List of tags that have been applied to the asset in AWS.
     */
    @Attribute
    List<AwsTag> awsTags;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * S3 objects within this bucket.
     */
    @Attribute
    SortedSet<IS3Object> objects;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Whether versioning is enabled for the bucket (true) or not (false).
     */
    @Attribute
    Boolean s3BucketVersioningEnabled;
    /**
     * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
     */
    @Attribute
    String s3ETag;
    /**
     * TBC
     */
    @Attribute
    String s3Encryption;
    /**
     * Number of objects within the bucket.
     */
    @Attribute
    Long s3ObjectCount;

    /**
     * Builds the minimal object necessary to create a relationship to a S3Bucket, from a potentially
     * more-complete S3Bucket object.
     *
     * @return the minimal object necessary to relate to the S3Bucket
     * @throws InvalidRequestException if any of the minimal set of required properties for a S3Bucket relationship are not found in the initial object
     */
    @Override
    public S3Bucket trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all S3Bucket assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) S3Bucket assets will be included.
     *
     * @return a fluent search that includes all S3Bucket assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all S3Bucket assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) S3Bucket assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all S3Bucket assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all S3Bucket assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) S3Buckets will be included
     * @return a fluent search that includes all S3Bucket assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all S3Bucket assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) S3Buckets will be included
     * @return a fluent search that includes all S3Bucket assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a S3Bucket by GUID. Use this to create a relationship to this S3Bucket,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the S3Bucket to reference
     * @return reference to a S3Bucket that can be used for defining a relationship to a S3Bucket
     */
    public static S3Bucket refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a S3Bucket by GUID. Use this to create a relationship to this S3Bucket,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the S3Bucket to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a S3Bucket that can be used for defining a relationship to a S3Bucket
     */
    public static S3Bucket refByGuid(String guid, Reference.SaveSemantic semantic) {
        return S3Bucket._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a S3Bucket by qualifiedName. Use this to create a relationship to this S3Bucket,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the S3Bucket to reference
     * @return reference to a S3Bucket that can be used for defining a relationship to a S3Bucket
     */
    public static S3Bucket refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a S3Bucket by qualifiedName. Use this to create a relationship to this S3Bucket,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the S3Bucket to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a S3Bucket that can be used for defining a relationship to a S3Bucket
     */
    public static S3Bucket refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return S3Bucket._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a S3Bucket by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the S3Bucket to retrieve, either its GUID or its full qualifiedName
     * @return the requested full S3Bucket, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the S3Bucket does not exist or the provided GUID is not a S3Bucket
     */
    @JsonIgnore
    public static S3Bucket get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a S3Bucket by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the S3Bucket to retrieve, either its GUID or its full qualifiedName
     * @return the requested full S3Bucket, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the S3Bucket does not exist or the provided GUID is not a S3Bucket
     */
    @JsonIgnore
    public static S3Bucket get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a S3Bucket by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the S3Bucket to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full S3Bucket, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the S3Bucket does not exist or the provided GUID is not a S3Bucket
     */
    @JsonIgnore
    public static S3Bucket get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof S3Bucket) {
                return (S3Bucket) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof S3Bucket) {
                return (S3Bucket) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) S3Bucket to active.
     *
     * @param qualifiedName for the S3Bucket
     * @return true if the S3Bucket is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) S3Bucket to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the S3Bucket
     * @return true if the S3Bucket is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create an S3 bucket.
     * Note: this will use the name of the bucket to construct the qualifiedName for the bucket.
     *
     * @param name of the S3 bucket
     * @param connectionQualifiedName unique name of the connection through which the bucket is accessible
     * @return the minimal object necessary to create the S3 bucket, as a builder
     */
    public static S3BucketBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return S3Bucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(IS3.generateQualifiedName(connectionQualifiedName, name)).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.S3);
    }

    /**
     * Builds the minimal object necessary to create an S3 bucket.
     * Note: this will use the provided ARN to construct the qualifiedName for the bucket.
     *
     * @param name of the S3 bucket
     * @param connectionQualifiedName unique name of the connection through which the bucket is accessible
     * @param awsArn unique ARN of the bucket
     * @return the minimal object necessary to create the S3 bucket, as a builder
     */
    public static S3BucketBuilder<?, ?> creator(String name, String connectionQualifiedName, String awsArn) {
        return S3Bucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(IS3.generateQualifiedName(connectionQualifiedName, awsArn)).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.S3).awsArn(awsArn);
    }

    /**
     * Builds the minimal object necessary to update a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the minimal request necessary to update the S3Bucket, as a builder
     */
    public static S3BucketBuilder<?, ?> updater(String qualifiedName, String name) {
        return S3Bucket._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a S3Bucket, from a potentially
     * more-complete S3Bucket object.
     *
     * @return the minimal object necessary to update the S3Bucket, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for S3Bucket are not found in the initial object
     */
    @Override
    public S3BucketBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a S3Bucket.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a S3Bucket.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a S3Bucket.
     *
     * @param client connectivity to the Atlan tenant from which to remove the S3Bucket's owners
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated S3Bucket, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a S3Bucket.
     *
     * @param client connectivity to the Atlan tenant on which to update the S3Bucket's certificate
     * @param qualifiedName of the S3Bucket
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated S3Bucket, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (S3Bucket) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a S3Bucket.
     *
     * @param client connectivity to the Atlan tenant from which to remove the S3Bucket's certificate
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a S3Bucket.
     *
     * @param client connectivity to the Atlan tenant on which to update the S3Bucket's announcement
     * @param qualifiedName of the S3Bucket
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (S3Bucket) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a S3Bucket.
     *
     * @param client connectivity to the Atlan client from which to remove the S3Bucket's announcement
     * @param qualifiedName of the S3Bucket
     * @param name of the S3Bucket
     * @return the updated S3Bucket, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Bucket) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the S3Bucket.
     *
     * @param qualifiedName for the S3Bucket
     * @param name human-readable name of the S3Bucket
     * @param terms the list of terms to replace on the S3Bucket, or null to remove all terms from the S3Bucket
     * @return the S3Bucket that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static S3Bucket replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the S3Bucket.
     *
     * @param client connectivity to the Atlan tenant on which to replace the S3Bucket's assigned terms
     * @param qualifiedName for the S3Bucket
     * @param name human-readable name of the S3Bucket
     * @param terms the list of terms to replace on the S3Bucket, or null to remove all terms from the S3Bucket
     * @return the S3Bucket that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static S3Bucket replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Bucket) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the S3Bucket, without replacing existing terms linked to the S3Bucket.
     * Note: this operation must make two API calls — one to retrieve the S3Bucket's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the S3Bucket
     * @param terms the list of terms to append to the S3Bucket
     * @return the S3Bucket that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static S3Bucket appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the S3Bucket, without replacing existing terms linked to the S3Bucket.
     * Note: this operation must make two API calls — one to retrieve the S3Bucket's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the S3Bucket
     * @param qualifiedName for the S3Bucket
     * @param terms the list of terms to append to the S3Bucket
     * @return the S3Bucket that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static S3Bucket appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Bucket) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a S3Bucket, without replacing all existing terms linked to the S3Bucket.
     * Note: this operation must make two API calls — one to retrieve the S3Bucket's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the S3Bucket
     * @param terms the list of terms to remove from the S3Bucket, which must be referenced by GUID
     * @return the S3Bucket that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a S3Bucket, without replacing all existing terms linked to the S3Bucket.
     * Note: this operation must make two API calls — one to retrieve the S3Bucket's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the S3Bucket
     * @param qualifiedName for the S3Bucket
     * @param terms the list of terms to remove from the S3Bucket, which must be referenced by GUID
     * @return the S3Bucket that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static S3Bucket removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Bucket) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a S3Bucket, without replacing existing Atlan tags linked to the S3Bucket.
     * Note: this operation must make two API calls — one to retrieve the S3Bucket's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the S3Bucket
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated S3Bucket
     */
    public static S3Bucket appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a S3Bucket, without replacing existing Atlan tags linked to the S3Bucket.
     * Note: this operation must make two API calls — one to retrieve the S3Bucket's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the S3Bucket
     * @param qualifiedName of the S3Bucket
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated S3Bucket
     */
    public static S3Bucket appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (S3Bucket) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a S3Bucket, without replacing existing Atlan tags linked to the S3Bucket.
     * Note: this operation must make two API calls — one to retrieve the S3Bucket's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the S3Bucket
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated S3Bucket
     */
    public static S3Bucket appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a S3Bucket, without replacing existing Atlan tags linked to the S3Bucket.
     * Note: this operation must make two API calls — one to retrieve the S3Bucket's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the S3Bucket
     * @param qualifiedName of the S3Bucket
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated S3Bucket
     */
    public static S3Bucket appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (S3Bucket) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a S3Bucket.
     *
     * @param qualifiedName of the S3Bucket
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the S3Bucket
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a S3Bucket.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a S3Bucket
     * @param qualifiedName of the S3Bucket
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the S3Bucket
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class S3BucketBuilder<C extends S3Bucket, B extends S3Bucket.S3BucketBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsAccountId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsArn;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsOwnerId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsOwnerName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsPartition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsRegion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsResourceId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsService;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AwsTag> awsTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IS3Object> objects;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean s3BucketVersioningEnabled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3ETag;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3Encryption;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long s3ObjectCount;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            S3Bucket.S3BucketBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final S3Bucket instance, final S3Bucket.S3BucketBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.awsAccountId(instance.awsAccountId);
            b.awsArn(instance.awsArn);
            b.awsOwnerId(instance.awsOwnerId);
            b.awsOwnerName(instance.awsOwnerName);
            b.awsPartition(instance.awsPartition);
            b.awsRegion(instance.awsRegion);
            b.awsResourceId(instance.awsResourceId);
            b.awsService(instance.awsService);
            b.awsTags(instance.awsTags == null ? java.util.Collections.<AwsTag>emptyList() : instance.awsTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.objects(instance.objects == null ? java.util.Collections.<IS3Object>emptySortedSet() : instance.objects);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.s3BucketVersioningEnabled(instance.s3BucketVersioningEnabled);
            b.s3ETag(instance.s3ETag);
            b.s3Encryption(instance.s3Encryption);
            b.s3ObjectCount(instance.s3ObjectCount);
        }

        /**
         * Fixed typeName for S3Buckets.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * 12-digit number that uniquely identifies an AWS account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsAccountId(final String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return self();
        }

        /**
         * Amazon Resource Name (ARN) for this asset. This uniquely identifies the asset in AWS, and thus must be unique across all AWS asset instances.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsArn(final String awsArn) {
            this.awsArn = awsArn;
            return self();
        }

        /**
         * Root user's ID.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsOwnerId(final String awsOwnerId) {
            this.awsOwnerId = awsOwnerId;
            return self();
        }

        /**
         * Root user's name.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsOwnerName(final String awsOwnerName) {
            this.awsOwnerName = awsOwnerName;
            return self();
        }

        /**
         * Group of AWS region and service objects.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsPartition(final String awsPartition) {
            this.awsPartition = awsPartition;
            return self();
        }

        /**
         * Physical region where the data center in which the asset exists is clustered.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsRegion(final String awsRegion) {
            this.awsRegion = awsRegion;
            return self();
        }

        /**
         * Unique resource ID assigned when a new resource is created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsResourceId(final String awsResourceId) {
            this.awsResourceId = awsResourceId;
            return self();
        }

        /**
         * Type of service in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsService(final String awsService) {
            this.awsService = awsService;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsTag(final AwsTag awsTag) {
            if (this.awsTags == null) this.awsTags = new java.util.ArrayList<AwsTag>();
            this.awsTags.add(awsTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsTags(final java.util.Collection<? extends AwsTag> awsTags) {
            if (awsTags == null) {
                throw new java.lang.NullPointerException("awsTags cannot be null");
            }
            if (this.awsTags == null) this.awsTags = new java.util.ArrayList<AwsTag>();
            this.awsTags.addAll(awsTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAwsTags() {
            if (this.awsTags != null) this.awsTags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B object(final IS3Object object) {
            if (this.objects == null) this.objects = new java.util.ArrayList<IS3Object>();
            this.objects.add(object);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B objects(final java.util.Collection<? extends IS3Object> objects) {
            if (objects == null) {
                throw new java.lang.NullPointerException("objects cannot be null");
            }
            if (this.objects == null) this.objects = new java.util.ArrayList<IS3Object>();
            this.objects.addAll(objects);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearObjects() {
            if (this.objects != null) this.objects.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Whether versioning is enabled for the bucket (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3BucketVersioningEnabled(final Boolean s3BucketVersioningEnabled) {
            this.s3BucketVersioningEnabled = s3BucketVersioningEnabled;
            return self();
        }

        /**
         * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ETag(final String s3ETag) {
            this.s3ETag = s3ETag;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3Encryption(final String s3Encryption) {
            this.s3Encryption = s3Encryption;
            return self();
        }

        /**
         * Number of objects within the bucket.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ObjectCount(final Long s3ObjectCount) {
            this.s3ObjectCount = s3ObjectCount;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "S3Bucket.S3BucketBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", awsAccountId=" + this.awsAccountId + ", awsArn=" + this.awsArn + ", awsOwnerId=" + this.awsOwnerId + ", awsOwnerName=" + this.awsOwnerName + ", awsPartition=" + this.awsPartition + ", awsRegion=" + this.awsRegion + ", awsResourceId=" + this.awsResourceId + ", awsService=" + this.awsService + ", awsTags=" + this.awsTags + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", objects=" + this.objects + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", s3BucketVersioningEnabled=" + this.s3BucketVersioningEnabled + ", s3ETag=" + this.s3ETag + ", s3Encryption=" + this.s3Encryption + ", s3ObjectCount=" + this.s3ObjectCount + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class S3BucketBuilderImpl extends S3Bucket.S3BucketBuilder<S3Bucket, S3Bucket.S3BucketBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private S3BucketBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected S3Bucket.S3BucketBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public S3Bucket build() {
            return new S3Bucket(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected S3Bucket(final S3Bucket.S3BucketBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = S3Bucket.$default$typeName();
        this.awsAccountId = b.awsAccountId;
        this.awsArn = b.awsArn;
        this.awsOwnerId = b.awsOwnerId;
        this.awsOwnerName = b.awsOwnerName;
        this.awsPartition = b.awsPartition;
        this.awsRegion = b.awsRegion;
        this.awsResourceId = b.awsResourceId;
        this.awsService = b.awsService;
        java.util.List<AwsTag> awsTags;
        switch (b.awsTags == null ? 0 : b.awsTags.size()) {
        case 0: 
            awsTags = java.util.Collections.emptyList();
            break;
        case 1: 
            awsTags = java.util.Collections.singletonList(b.awsTags.get(0));
            break;
        default: 
            awsTags = java.util.Collections.unmodifiableList(new java.util.ArrayList<AwsTag>(b.awsTags));
        }
        this.awsTags = awsTags;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IS3Object> objects = new java.util.TreeSet<IS3Object>();
        if (b.objects != null) objects.addAll(b.objects);
        objects = java.util.Collections.unmodifiableSortedSet(objects);
        this.objects = objects;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.s3BucketVersioningEnabled = b.s3BucketVersioningEnabled;
        this.s3ETag = b.s3ETag;
        this.s3Encryption = b.s3Encryption;
        this.s3ObjectCount = b.s3ObjectCount;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static S3Bucket.S3BucketBuilder<?, ?> _internal() {
        return new S3Bucket.S3BucketBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public S3Bucket.S3BucketBuilder<?, ?> toBuilder() {
        return new S3Bucket.S3BucketBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * 12-digit number that uniquely identifies an AWS account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    /**
     * Amazon Resource Name (ARN) for this asset. This uniquely identifies the asset in AWS, and thus must be unique across all AWS asset instances.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsArn() {
        return this.awsArn;
    }

    /**
     * Root user's ID.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsOwnerId() {
        return this.awsOwnerId;
    }

    /**
     * Root user's name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsOwnerName() {
        return this.awsOwnerName;
    }

    /**
     * Group of AWS region and service objects.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsPartition() {
        return this.awsPartition;
    }

    /**
     * Physical region where the data center in which the asset exists is clustered.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsRegion() {
        return this.awsRegion;
    }

    /**
     * Unique resource ID assigned when a new resource is created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsResourceId() {
        return this.awsResourceId;
    }

    /**
     * Type of service in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsService() {
        return this.awsService;
    }

    /**
     * List of tags that have been applied to the asset in AWS.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AwsTag> getAwsTags() {
        return this.awsTags;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * S3 objects within this bucket.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IS3Object> getObjects() {
        return this.objects;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Whether versioning is enabled for the bucket (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getS3BucketVersioningEnabled() {
        return this.s3BucketVersioningEnabled;
    }

    /**
     * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3ETag() {
        return this.s3ETag;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3Encryption() {
        return this.s3Encryption;
    }

    /**
     * Number of objects within the bucket.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getS3ObjectCount() {
        return this.s3ObjectCount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof S3Bucket)) return false;
        final S3Bucket other = (S3Bucket) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$s3BucketVersioningEnabled = this.getS3BucketVersioningEnabled();
        final java.lang.Object other$s3BucketVersioningEnabled = other.getS3BucketVersioningEnabled();
        if (this$s3BucketVersioningEnabled == null ? other$s3BucketVersioningEnabled != null : !this$s3BucketVersioningEnabled.equals(other$s3BucketVersioningEnabled)) return false;
        final java.lang.Object this$s3ObjectCount = this.getS3ObjectCount();
        final java.lang.Object other$s3ObjectCount = other.getS3ObjectCount();
        if (this$s3ObjectCount == null ? other$s3ObjectCount != null : !this$s3ObjectCount.equals(other$s3ObjectCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$awsAccountId = this.getAwsAccountId();
        final java.lang.Object other$awsAccountId = other.getAwsAccountId();
        if (this$awsAccountId == null ? other$awsAccountId != null : !this$awsAccountId.equals(other$awsAccountId)) return false;
        final java.lang.Object this$awsArn = this.getAwsArn();
        final java.lang.Object other$awsArn = other.getAwsArn();
        if (this$awsArn == null ? other$awsArn != null : !this$awsArn.equals(other$awsArn)) return false;
        final java.lang.Object this$awsOwnerId = this.getAwsOwnerId();
        final java.lang.Object other$awsOwnerId = other.getAwsOwnerId();
        if (this$awsOwnerId == null ? other$awsOwnerId != null : !this$awsOwnerId.equals(other$awsOwnerId)) return false;
        final java.lang.Object this$awsOwnerName = this.getAwsOwnerName();
        final java.lang.Object other$awsOwnerName = other.getAwsOwnerName();
        if (this$awsOwnerName == null ? other$awsOwnerName != null : !this$awsOwnerName.equals(other$awsOwnerName)) return false;
        final java.lang.Object this$awsPartition = this.getAwsPartition();
        final java.lang.Object other$awsPartition = other.getAwsPartition();
        if (this$awsPartition == null ? other$awsPartition != null : !this$awsPartition.equals(other$awsPartition)) return false;
        final java.lang.Object this$awsRegion = this.getAwsRegion();
        final java.lang.Object other$awsRegion = other.getAwsRegion();
        if (this$awsRegion == null ? other$awsRegion != null : !this$awsRegion.equals(other$awsRegion)) return false;
        final java.lang.Object this$awsResourceId = this.getAwsResourceId();
        final java.lang.Object other$awsResourceId = other.getAwsResourceId();
        if (this$awsResourceId == null ? other$awsResourceId != null : !this$awsResourceId.equals(other$awsResourceId)) return false;
        final java.lang.Object this$awsService = this.getAwsService();
        final java.lang.Object other$awsService = other.getAwsService();
        if (this$awsService == null ? other$awsService != null : !this$awsService.equals(other$awsService)) return false;
        final java.lang.Object this$awsTags = this.getAwsTags();
        final java.lang.Object other$awsTags = other.getAwsTags();
        if (this$awsTags == null ? other$awsTags != null : !this$awsTags.equals(other$awsTags)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$objects = this.getObjects();
        final java.lang.Object other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !this$objects.equals(other$objects)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$s3ETag = this.getS3ETag();
        final java.lang.Object other$s3ETag = other.getS3ETag();
        if (this$s3ETag == null ? other$s3ETag != null : !this$s3ETag.equals(other$s3ETag)) return false;
        final java.lang.Object this$s3Encryption = this.getS3Encryption();
        final java.lang.Object other$s3Encryption = other.getS3Encryption();
        if (this$s3Encryption == null ? other$s3Encryption != null : !this$s3Encryption.equals(other$s3Encryption)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof S3Bucket;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $s3BucketVersioningEnabled = this.getS3BucketVersioningEnabled();
        result = result * PRIME + ($s3BucketVersioningEnabled == null ? 43 : $s3BucketVersioningEnabled.hashCode());
        final java.lang.Object $s3ObjectCount = this.getS3ObjectCount();
        result = result * PRIME + ($s3ObjectCount == null ? 43 : $s3ObjectCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $awsAccountId = this.getAwsAccountId();
        result = result * PRIME + ($awsAccountId == null ? 43 : $awsAccountId.hashCode());
        final java.lang.Object $awsArn = this.getAwsArn();
        result = result * PRIME + ($awsArn == null ? 43 : $awsArn.hashCode());
        final java.lang.Object $awsOwnerId = this.getAwsOwnerId();
        result = result * PRIME + ($awsOwnerId == null ? 43 : $awsOwnerId.hashCode());
        final java.lang.Object $awsOwnerName = this.getAwsOwnerName();
        result = result * PRIME + ($awsOwnerName == null ? 43 : $awsOwnerName.hashCode());
        final java.lang.Object $awsPartition = this.getAwsPartition();
        result = result * PRIME + ($awsPartition == null ? 43 : $awsPartition.hashCode());
        final java.lang.Object $awsRegion = this.getAwsRegion();
        result = result * PRIME + ($awsRegion == null ? 43 : $awsRegion.hashCode());
        final java.lang.Object $awsResourceId = this.getAwsResourceId();
        result = result * PRIME + ($awsResourceId == null ? 43 : $awsResourceId.hashCode());
        final java.lang.Object $awsService = this.getAwsService();
        result = result * PRIME + ($awsService == null ? 43 : $awsService.hashCode());
        final java.lang.Object $awsTags = this.getAwsTags();
        result = result * PRIME + ($awsTags == null ? 43 : $awsTags.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $objects = this.getObjects();
        result = result * PRIME + ($objects == null ? 43 : $objects.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $s3ETag = this.getS3ETag();
        result = result * PRIME + ($s3ETag == null ? 43 : $s3ETag.hashCode());
        final java.lang.Object $s3Encryption = this.getS3Encryption();
        result = result * PRIME + ($s3Encryption == null ? 43 : $s3Encryption.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "S3Bucket(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", awsAccountId=" + this.getAwsAccountId() + ", awsArn=" + this.getAwsArn() + ", awsOwnerId=" + this.getAwsOwnerId() + ", awsOwnerName=" + this.getAwsOwnerName() + ", awsPartition=" + this.getAwsPartition() + ", awsRegion=" + this.getAwsRegion() + ", awsResourceId=" + this.getAwsResourceId() + ", awsService=" + this.getAwsService() + ", awsTags=" + this.getAwsTags() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", objects=" + this.getObjects() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", s3BucketVersioningEnabled=" + this.getS3BucketVersioningEnabled() + ", s3ETag=" + this.getS3ETag() + ", s3Encryption=" + this.getS3Encryption() + ", s3ObjectCount=" + this.getS3ObjectCount() + ")";
    }

    /**
     * Fixed typeName for S3Buckets.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
