// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.AwsTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of an S3 object in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class S3Object extends Asset implements IS3Object, IS3, IObjectStore, IAWS, ICatalog, IAsset, IReferenceable, ICloud {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(S3Object.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "S3Object";
    /**
     * Fixed typeName for S3Objects.
     */
    String typeName;
    /**
     * 12-digit number that uniquely identifies an AWS account.
     */
    @Attribute
    String awsAccountId;
    /**
     * Amazon Resource Name (ARN) for this asset. This uniquely identifies the asset in AWS, and thus must be unique across all AWS asset instances.
     */
    @Attribute
    String awsArn;
    /**
     * Root user's ID.
     */
    @Attribute
    String awsOwnerId;
    /**
     * Root user's name.
     */
    @Attribute
    String awsOwnerName;
    /**
     * Group of AWS region and service objects.
     */
    @Attribute
    String awsPartition;
    /**
     * Physical region where the data center in which the asset exists is clustered.
     */
    @Attribute
    String awsRegion;
    /**
     * Unique resource ID assigned when a new resource is created.
     */
    @Attribute
    String awsResourceId;
    /**
     * Type of service in which the asset exists.
     */
    @Attribute
    String awsService;
    /**
     * List of tags that have been applied to the asset in AWS.
     */
    @Attribute
    List<AwsTag> awsTags;
    /**
     * S3 bucket in which the object exists.
     */
    @Attribute
    IS3Bucket bucket;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Simple name of the bucket in which this object exists.
     */
    @Attribute
    String s3BucketName;
    /**
     * Unique name of the bucket in which this object exists.
     */
    @Attribute
    String s3BucketQualifiedName;
    /**
     * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
     */
    @Attribute
    String s3ETag;
    /**
     * TBC
     */
    @Attribute
    String s3Encryption;
    /**
     * Information about how this object's content should be presented.
     */
    @Attribute
    String s3ObjectContentDisposition;
    /**
     * Type of content in this object, for example: text/plain, application/json, etc.
     */
    @Attribute
    String s3ObjectContentType;
    /**
     * Unique identity of this object in an S3 bucket. This is usually the concatenation of any prefix (folder) in the S3 bucket with the name of the object (file) itself.
     */
    @Attribute
    String s3ObjectKey;
    /**
     * Time (epoch) at which this object was last updated, in milliseconds, or when it was created if it has never been modified.
     */
    @Attribute
    @Date
    Long s3ObjectLastModifiedTime;
    /**
     * Object size in bytes.
     */
    @Attribute
    Long s3ObjectSize;
    /**
     * Storage class used for storing this object, for example: standard, intelligent-tiering, glacier, etc.
     */
    @Attribute
    String s3ObjectStorageClass;
    /**
     * Version of this object. This is only applicable when versioning is enabled on the bucket in which this object exists.
     */
    @Attribute
    String s3ObjectVersionId;

    /**
     * Builds the minimal object necessary to create a relationship to a S3Object, from a potentially
     * more-complete S3Object object.
     *
     * @return the minimal object necessary to relate to the S3Object
     * @throws InvalidRequestException if any of the minimal set of required properties for a S3Object relationship are not found in the initial object
     */
    @Override
    public S3Object trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all S3Object assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) S3Object assets will be included.
     *
     * @return a fluent search that includes all S3Object assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all S3Object assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) S3Object assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all S3Object assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all S3Object assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) S3Objects will be included
     * @return a fluent search that includes all S3Object assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all S3Object assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) S3Objects will be included
     * @return a fluent search that includes all S3Object assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a S3Object by GUID. Use this to create a relationship to this S3Object,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the S3Object to reference
     * @return reference to a S3Object that can be used for defining a relationship to a S3Object
     */
    public static S3Object refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a S3Object by GUID. Use this to create a relationship to this S3Object,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the S3Object to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a S3Object that can be used for defining a relationship to a S3Object
     */
    public static S3Object refByGuid(String guid, Reference.SaveSemantic semantic) {
        return S3Object._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a S3Object by qualifiedName. Use this to create a relationship to this S3Object,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the S3Object to reference
     * @return reference to a S3Object that can be used for defining a relationship to a S3Object
     */
    public static S3Object refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a S3Object by qualifiedName. Use this to create a relationship to this S3Object,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the S3Object to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a S3Object that can be used for defining a relationship to a S3Object
     */
    public static S3Object refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return S3Object._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a S3Object by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the S3Object to retrieve, either its GUID or its full qualifiedName
     * @return the requested full S3Object, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the S3Object does not exist or the provided GUID is not a S3Object
     */
    @JsonIgnore
    public static S3Object get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a S3Object by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the S3Object to retrieve, either its GUID or its full qualifiedName
     * @return the requested full S3Object, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the S3Object does not exist or the provided GUID is not a S3Object
     */
    @JsonIgnore
    public static S3Object get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a S3Object by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the S3Object to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full S3Object, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the S3Object does not exist or the provided GUID is not a S3Object
     */
    @JsonIgnore
    public static S3Object get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof S3Object) {
                return (S3Object) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof S3Object) {
                return (S3Object) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) S3Object to active.
     *
     * @param qualifiedName for the S3Object
     * @return true if the S3Object is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) S3Object to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the S3Object
     * @return true if the S3Object is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create an S3 object.
     * Note: this will use the provided prefix and name of the object to construct the qualifiedName for the object.
     *
     * @param name of the S3 object
     * @param bucket in which the S3 object should be created, which must have at least
     *               a qualifiedName and name
     * @param prefix the "folder(s)" in which the object exists, within the bucket
     * @return the minimal request necessary to create the S3 object, as a builder
     * @throws InvalidRequestException if the bucket provided is without any required attributes
     */
    public static S3ObjectBuilder<?, ?> creatorWithPrefix(String name, S3Bucket bucket, String prefix) throws InvalidRequestException {
        validateRelationship(S3Bucket.TYPE_NAME, Map.of("qualifiedName", bucket.getQualifiedName(), "name", bucket.getName()));
        return creatorWithPrefix(name, bucket.getQualifiedName(), bucket.getName(), prefix).bucket(bucket.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create an S3 object.
     * Note: this will use the provided ARN to construct the qualifiedName for the object.
     *
     * @param name of the S3 object
     * @param bucket in which the S3 object should be created, which must have at least
     *               a qualifiedName and name
     * @param awsArn unique ARN of the object
     * @return the minimal request necessary to create the S3 object, as a builder
     * @throws InvalidRequestException if the bucket provided is without any required attributes
     */
    public static S3ObjectBuilder<?, ?> creator(String name, S3Bucket bucket, String awsArn) throws InvalidRequestException {
        validateRelationship(S3Bucket.TYPE_NAME, Map.of("qualifiedName", bucket.getQualifiedName(), "name", bucket.getName()));
        return creator(name, bucket.getQualifiedName(), bucket.getName(), awsArn).bucket(bucket.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create an S3 object.
     * Note: this will use the prefix and name of the object to construct the qualifiedName for the object.
     *
     * @param name of the S3 object (must be unique within the bucket)
     * @param bucketQualifiedName unique name of the S3 bucket in which the object exists
     * @param bucketName simple human-readable name of the S3 bucket in which the object exists
     * @param prefix the "folder(s)" in which the object exists, within the bucket
     * @return the minimal object necessary to create the S3 object, as a builder
     */
    public static S3ObjectBuilder<?, ?> creatorWithPrefix(String name, String bucketQualifiedName, String bucketName, String prefix) {
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(bucketQualifiedName);
        String objectKey = prefix + "/" + name;
        return S3Object._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(IS3.generateQualifiedName(connectionQualifiedName, objectKey)).name(name).s3ObjectKey(objectKey).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.S3).s3BucketQualifiedName(bucketQualifiedName).s3BucketName(bucketName).bucket(S3Bucket.refByQualifiedName(bucketQualifiedName));
    }

    /**
     * Builds the minimal object necessary to create an S3 object.
     * Note: this will use the provided ARN to construct the qualifiedName for the object.
     *
     * @param name of the S3 object
     * @param bucketQualifiedName unique name of the S3 bucket in which the object exists
     * @param bucketName simple human-readable name of the S3 bucket in which the object exists
     * @param awsArn unique ARN of the object
     * @return the minimal object necessary to create the S3 object, as a builder
     */
    public static S3ObjectBuilder<?, ?> creator(String name, String bucketQualifiedName, String bucketName, String awsArn) {
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(bucketQualifiedName);
        return S3Object._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(IS3.generateQualifiedName(connectionQualifiedName, awsArn)).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.S3).awsArn(awsArn).s3BucketQualifiedName(bucketQualifiedName).s3BucketName(bucketName).bucket(S3Bucket.refByQualifiedName(bucketQualifiedName));
    }

    /**
     * Builds the minimal object necessary to update a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the minimal request necessary to update the S3Object, as a builder
     */
    public static S3ObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return S3Object._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a S3Object, from a potentially
     * more-complete S3Object object.
     *
     * @return the minimal object necessary to update the S3Object, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for S3Object are not found in the initial object
     */
    @Override
    public S3ObjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a S3Object.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Object) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a S3Object.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Object) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a S3Object.
     *
     * @param client connectivity to the Atlan tenant from which to remove the S3Object's owners
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Object) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated S3Object, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static S3Object updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a S3Object.
     *
     * @param client connectivity to the Atlan tenant on which to update the S3Object's certificate
     * @param qualifiedName of the S3Object
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated S3Object, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static S3Object updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (S3Object) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a S3Object.
     *
     * @param client connectivity to the Atlan tenant from which to remove the S3Object's certificate
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Object) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static S3Object updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a S3Object.
     *
     * @param client connectivity to the Atlan tenant on which to update the S3Object's announcement
     * @param qualifiedName of the S3Object
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static S3Object updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (S3Object) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a S3Object.
     *
     * @param client connectivity to the Atlan client from which to remove the S3Object's announcement
     * @param qualifiedName of the S3Object
     * @param name of the S3Object
     * @return the updated S3Object, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static S3Object removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (S3Object) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the S3Object.
     *
     * @param qualifiedName for the S3Object
     * @param name human-readable name of the S3Object
     * @param terms the list of terms to replace on the S3Object, or null to remove all terms from the S3Object
     * @return the S3Object that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static S3Object replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the S3Object.
     *
     * @param client connectivity to the Atlan tenant on which to replace the S3Object's assigned terms
     * @param qualifiedName for the S3Object
     * @param name human-readable name of the S3Object
     * @param terms the list of terms to replace on the S3Object, or null to remove all terms from the S3Object
     * @return the S3Object that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static S3Object replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Object) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the S3Object, without replacing existing terms linked to the S3Object.
     * Note: this operation must make two API calls — one to retrieve the S3Object's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the S3Object
     * @param terms the list of terms to append to the S3Object
     * @return the S3Object that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static S3Object appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the S3Object, without replacing existing terms linked to the S3Object.
     * Note: this operation must make two API calls — one to retrieve the S3Object's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the S3Object
     * @param qualifiedName for the S3Object
     * @param terms the list of terms to append to the S3Object
     * @return the S3Object that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static S3Object appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Object) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a S3Object, without replacing all existing terms linked to the S3Object.
     * Note: this operation must make two API calls — one to retrieve the S3Object's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the S3Object
     * @param terms the list of terms to remove from the S3Object, which must be referenced by GUID
     * @return the S3Object that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static S3Object removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a S3Object, without replacing all existing terms linked to the S3Object.
     * Note: this operation must make two API calls — one to retrieve the S3Object's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the S3Object
     * @param qualifiedName for the S3Object
     * @param terms the list of terms to remove from the S3Object, which must be referenced by GUID
     * @return the S3Object that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static S3Object removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (S3Object) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a S3Object, without replacing existing Atlan tags linked to the S3Object.
     * Note: this operation must make two API calls — one to retrieve the S3Object's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the S3Object
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated S3Object
     */
    public static S3Object appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a S3Object, without replacing existing Atlan tags linked to the S3Object.
     * Note: this operation must make two API calls — one to retrieve the S3Object's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the S3Object
     * @param qualifiedName of the S3Object
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated S3Object
     */
    public static S3Object appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (S3Object) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a S3Object, without replacing existing Atlan tags linked to the S3Object.
     * Note: this operation must make two API calls — one to retrieve the S3Object's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the S3Object
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated S3Object
     */
    public static S3Object appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a S3Object, without replacing existing Atlan tags linked to the S3Object.
     * Note: this operation must make two API calls — one to retrieve the S3Object's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the S3Object
     * @param qualifiedName of the S3Object
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated S3Object
     */
    public static S3Object appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (S3Object) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a S3Object.
     *
     * @param qualifiedName of the S3Object
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the S3Object
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a S3Object.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a S3Object
     * @param qualifiedName of the S3Object
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the S3Object
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class S3ObjectBuilder<C extends S3Object, B extends S3Object.S3ObjectBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsAccountId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsArn;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsOwnerId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsOwnerName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsPartition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsRegion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsResourceId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String awsService;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AwsTag> awsTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IS3Bucket bucket;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3BucketName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3BucketQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3ETag;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3Encryption;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3ObjectContentDisposition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3ObjectContentType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3ObjectKey;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long s3ObjectLastModifiedTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long s3ObjectSize;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3ObjectStorageClass;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String s3ObjectVersionId;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            S3Object.S3ObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final S3Object instance, final S3Object.S3ObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.awsAccountId(instance.awsAccountId);
            b.awsArn(instance.awsArn);
            b.awsOwnerId(instance.awsOwnerId);
            b.awsOwnerName(instance.awsOwnerName);
            b.awsPartition(instance.awsPartition);
            b.awsRegion(instance.awsRegion);
            b.awsResourceId(instance.awsResourceId);
            b.awsService(instance.awsService);
            b.awsTags(instance.awsTags == null ? java.util.Collections.<AwsTag>emptyList() : instance.awsTags);
            b.bucket(instance.bucket);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.s3BucketName(instance.s3BucketName);
            b.s3BucketQualifiedName(instance.s3BucketQualifiedName);
            b.s3ETag(instance.s3ETag);
            b.s3Encryption(instance.s3Encryption);
            b.s3ObjectContentDisposition(instance.s3ObjectContentDisposition);
            b.s3ObjectContentType(instance.s3ObjectContentType);
            b.s3ObjectKey(instance.s3ObjectKey);
            b.s3ObjectLastModifiedTime(instance.s3ObjectLastModifiedTime);
            b.s3ObjectSize(instance.s3ObjectSize);
            b.s3ObjectStorageClass(instance.s3ObjectStorageClass);
            b.s3ObjectVersionId(instance.s3ObjectVersionId);
        }

        /**
         * Fixed typeName for S3Objects.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * 12-digit number that uniquely identifies an AWS account.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsAccountId(final String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return self();
        }

        /**
         * Amazon Resource Name (ARN) for this asset. This uniquely identifies the asset in AWS, and thus must be unique across all AWS asset instances.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsArn(final String awsArn) {
            this.awsArn = awsArn;
            return self();
        }

        /**
         * Root user's ID.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsOwnerId(final String awsOwnerId) {
            this.awsOwnerId = awsOwnerId;
            return self();
        }

        /**
         * Root user's name.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsOwnerName(final String awsOwnerName) {
            this.awsOwnerName = awsOwnerName;
            return self();
        }

        /**
         * Group of AWS region and service objects.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsPartition(final String awsPartition) {
            this.awsPartition = awsPartition;
            return self();
        }

        /**
         * Physical region where the data center in which the asset exists is clustered.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsRegion(final String awsRegion) {
            this.awsRegion = awsRegion;
            return self();
        }

        /**
         * Unique resource ID assigned when a new resource is created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsResourceId(final String awsResourceId) {
            this.awsResourceId = awsResourceId;
            return self();
        }

        /**
         * Type of service in which the asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsService(final String awsService) {
            this.awsService = awsService;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsTag(final AwsTag awsTag) {
            if (this.awsTags == null) this.awsTags = new java.util.ArrayList<AwsTag>();
            this.awsTags.add(awsTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B awsTags(final java.util.Collection<? extends AwsTag> awsTags) {
            if (awsTags == null) {
                throw new java.lang.NullPointerException("awsTags cannot be null");
            }
            if (this.awsTags == null) this.awsTags = new java.util.ArrayList<AwsTag>();
            this.awsTags.addAll(awsTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAwsTags() {
            if (this.awsTags != null) this.awsTags.clear();
            return self();
        }

        /**
         * S3 bucket in which the object exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B bucket(final IS3Bucket bucket) {
            this.bucket = bucket;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Simple name of the bucket in which this object exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3BucketName(final String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return self();
        }

        /**
         * Unique name of the bucket in which this object exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3BucketQualifiedName(final String s3BucketQualifiedName) {
            this.s3BucketQualifiedName = s3BucketQualifiedName;
            return self();
        }

        /**
         * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ETag(final String s3ETag) {
            this.s3ETag = s3ETag;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3Encryption(final String s3Encryption) {
            this.s3Encryption = s3Encryption;
            return self();
        }

        /**
         * Information about how this object's content should be presented.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ObjectContentDisposition(final String s3ObjectContentDisposition) {
            this.s3ObjectContentDisposition = s3ObjectContentDisposition;
            return self();
        }

        /**
         * Type of content in this object, for example: text/plain, application/json, etc.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ObjectContentType(final String s3ObjectContentType) {
            this.s3ObjectContentType = s3ObjectContentType;
            return self();
        }

        /**
         * Unique identity of this object in an S3 bucket. This is usually the concatenation of any prefix (folder) in the S3 bucket with the name of the object (file) itself.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ObjectKey(final String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
            return self();
        }

        /**
         * Time (epoch) at which this object was last updated, in milliseconds, or when it was created if it has never been modified.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ObjectLastModifiedTime(final Long s3ObjectLastModifiedTime) {
            this.s3ObjectLastModifiedTime = s3ObjectLastModifiedTime;
            return self();
        }

        /**
         * Object size in bytes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ObjectSize(final Long s3ObjectSize) {
            this.s3ObjectSize = s3ObjectSize;
            return self();
        }

        /**
         * Storage class used for storing this object, for example: standard, intelligent-tiering, glacier, etc.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ObjectStorageClass(final String s3ObjectStorageClass) {
            this.s3ObjectStorageClass = s3ObjectStorageClass;
            return self();
        }

        /**
         * Version of this object. This is only applicable when versioning is enabled on the bucket in which this object exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B s3ObjectVersionId(final String s3ObjectVersionId) {
            this.s3ObjectVersionId = s3ObjectVersionId;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "S3Object.S3ObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", awsAccountId=" + this.awsAccountId + ", awsArn=" + this.awsArn + ", awsOwnerId=" + this.awsOwnerId + ", awsOwnerName=" + this.awsOwnerName + ", awsPartition=" + this.awsPartition + ", awsRegion=" + this.awsRegion + ", awsResourceId=" + this.awsResourceId + ", awsService=" + this.awsService + ", awsTags=" + this.awsTags + ", bucket=" + this.bucket + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", s3BucketName=" + this.s3BucketName + ", s3BucketQualifiedName=" + this.s3BucketQualifiedName + ", s3ETag=" + this.s3ETag + ", s3Encryption=" + this.s3Encryption + ", s3ObjectContentDisposition=" + this.s3ObjectContentDisposition + ", s3ObjectContentType=" + this.s3ObjectContentType + ", s3ObjectKey=" + this.s3ObjectKey + ", s3ObjectLastModifiedTime=" + this.s3ObjectLastModifiedTime + ", s3ObjectSize=" + this.s3ObjectSize + ", s3ObjectStorageClass=" + this.s3ObjectStorageClass + ", s3ObjectVersionId=" + this.s3ObjectVersionId + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class S3ObjectBuilderImpl extends S3Object.S3ObjectBuilder<S3Object, S3Object.S3ObjectBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private S3ObjectBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected S3Object.S3ObjectBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public S3Object build() {
            return new S3Object(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected S3Object(final S3Object.S3ObjectBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = S3Object.$default$typeName();
        this.awsAccountId = b.awsAccountId;
        this.awsArn = b.awsArn;
        this.awsOwnerId = b.awsOwnerId;
        this.awsOwnerName = b.awsOwnerName;
        this.awsPartition = b.awsPartition;
        this.awsRegion = b.awsRegion;
        this.awsResourceId = b.awsResourceId;
        this.awsService = b.awsService;
        java.util.List<AwsTag> awsTags;
        switch (b.awsTags == null ? 0 : b.awsTags.size()) {
        case 0: 
            awsTags = java.util.Collections.emptyList();
            break;
        case 1: 
            awsTags = java.util.Collections.singletonList(b.awsTags.get(0));
            break;
        default: 
            awsTags = java.util.Collections.unmodifiableList(new java.util.ArrayList<AwsTag>(b.awsTags));
        }
        this.awsTags = awsTags;
        this.bucket = b.bucket;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.s3BucketName = b.s3BucketName;
        this.s3BucketQualifiedName = b.s3BucketQualifiedName;
        this.s3ETag = b.s3ETag;
        this.s3Encryption = b.s3Encryption;
        this.s3ObjectContentDisposition = b.s3ObjectContentDisposition;
        this.s3ObjectContentType = b.s3ObjectContentType;
        this.s3ObjectKey = b.s3ObjectKey;
        this.s3ObjectLastModifiedTime = b.s3ObjectLastModifiedTime;
        this.s3ObjectSize = b.s3ObjectSize;
        this.s3ObjectStorageClass = b.s3ObjectStorageClass;
        this.s3ObjectVersionId = b.s3ObjectVersionId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static S3Object.S3ObjectBuilder<?, ?> _internal() {
        return new S3Object.S3ObjectBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public S3Object.S3ObjectBuilder<?, ?> toBuilder() {
        return new S3Object.S3ObjectBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * 12-digit number that uniquely identifies an AWS account.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    /**
     * Amazon Resource Name (ARN) for this asset. This uniquely identifies the asset in AWS, and thus must be unique across all AWS asset instances.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsArn() {
        return this.awsArn;
    }

    /**
     * Root user's ID.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsOwnerId() {
        return this.awsOwnerId;
    }

    /**
     * Root user's name.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsOwnerName() {
        return this.awsOwnerName;
    }

    /**
     * Group of AWS region and service objects.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsPartition() {
        return this.awsPartition;
    }

    /**
     * Physical region where the data center in which the asset exists is clustered.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsRegion() {
        return this.awsRegion;
    }

    /**
     * Unique resource ID assigned when a new resource is created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsResourceId() {
        return this.awsResourceId;
    }

    /**
     * Type of service in which the asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getAwsService() {
        return this.awsService;
    }

    /**
     * List of tags that have been applied to the asset in AWS.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AwsTag> getAwsTags() {
        return this.awsTags;
    }

    /**
     * S3 bucket in which the object exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IS3Bucket getBucket() {
        return this.bucket;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Simple name of the bucket in which this object exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3BucketName() {
        return this.s3BucketName;
    }

    /**
     * Unique name of the bucket in which this object exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3BucketQualifiedName() {
        return this.s3BucketQualifiedName;
    }

    /**
     * Entity tag for the asset. An entity tag is a hash of the object and represents changes to the contents of an object only, not its metadata.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3ETag() {
        return this.s3ETag;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3Encryption() {
        return this.s3Encryption;
    }

    /**
     * Information about how this object's content should be presented.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3ObjectContentDisposition() {
        return this.s3ObjectContentDisposition;
    }

    /**
     * Type of content in this object, for example: text/plain, application/json, etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3ObjectContentType() {
        return this.s3ObjectContentType;
    }

    /**
     * Unique identity of this object in an S3 bucket. This is usually the concatenation of any prefix (folder) in the S3 bucket with the name of the object (file) itself.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3ObjectKey() {
        return this.s3ObjectKey;
    }

    /**
     * Time (epoch) at which this object was last updated, in milliseconds, or when it was created if it has never been modified.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getS3ObjectLastModifiedTime() {
        return this.s3ObjectLastModifiedTime;
    }

    /**
     * Object size in bytes.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getS3ObjectSize() {
        return this.s3ObjectSize;
    }

    /**
     * Storage class used for storing this object, for example: standard, intelligent-tiering, glacier, etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3ObjectStorageClass() {
        return this.s3ObjectStorageClass;
    }

    /**
     * Version of this object. This is only applicable when versioning is enabled on the bucket in which this object exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getS3ObjectVersionId() {
        return this.s3ObjectVersionId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof S3Object)) return false;
        final S3Object other = (S3Object) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$s3ObjectLastModifiedTime = this.getS3ObjectLastModifiedTime();
        final java.lang.Object other$s3ObjectLastModifiedTime = other.getS3ObjectLastModifiedTime();
        if (this$s3ObjectLastModifiedTime == null ? other$s3ObjectLastModifiedTime != null : !this$s3ObjectLastModifiedTime.equals(other$s3ObjectLastModifiedTime)) return false;
        final java.lang.Object this$s3ObjectSize = this.getS3ObjectSize();
        final java.lang.Object other$s3ObjectSize = other.getS3ObjectSize();
        if (this$s3ObjectSize == null ? other$s3ObjectSize != null : !this$s3ObjectSize.equals(other$s3ObjectSize)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$awsAccountId = this.getAwsAccountId();
        final java.lang.Object other$awsAccountId = other.getAwsAccountId();
        if (this$awsAccountId == null ? other$awsAccountId != null : !this$awsAccountId.equals(other$awsAccountId)) return false;
        final java.lang.Object this$awsArn = this.getAwsArn();
        final java.lang.Object other$awsArn = other.getAwsArn();
        if (this$awsArn == null ? other$awsArn != null : !this$awsArn.equals(other$awsArn)) return false;
        final java.lang.Object this$awsOwnerId = this.getAwsOwnerId();
        final java.lang.Object other$awsOwnerId = other.getAwsOwnerId();
        if (this$awsOwnerId == null ? other$awsOwnerId != null : !this$awsOwnerId.equals(other$awsOwnerId)) return false;
        final java.lang.Object this$awsOwnerName = this.getAwsOwnerName();
        final java.lang.Object other$awsOwnerName = other.getAwsOwnerName();
        if (this$awsOwnerName == null ? other$awsOwnerName != null : !this$awsOwnerName.equals(other$awsOwnerName)) return false;
        final java.lang.Object this$awsPartition = this.getAwsPartition();
        final java.lang.Object other$awsPartition = other.getAwsPartition();
        if (this$awsPartition == null ? other$awsPartition != null : !this$awsPartition.equals(other$awsPartition)) return false;
        final java.lang.Object this$awsRegion = this.getAwsRegion();
        final java.lang.Object other$awsRegion = other.getAwsRegion();
        if (this$awsRegion == null ? other$awsRegion != null : !this$awsRegion.equals(other$awsRegion)) return false;
        final java.lang.Object this$awsResourceId = this.getAwsResourceId();
        final java.lang.Object other$awsResourceId = other.getAwsResourceId();
        if (this$awsResourceId == null ? other$awsResourceId != null : !this$awsResourceId.equals(other$awsResourceId)) return false;
        final java.lang.Object this$awsService = this.getAwsService();
        final java.lang.Object other$awsService = other.getAwsService();
        if (this$awsService == null ? other$awsService != null : !this$awsService.equals(other$awsService)) return false;
        final java.lang.Object this$awsTags = this.getAwsTags();
        final java.lang.Object other$awsTags = other.getAwsTags();
        if (this$awsTags == null ? other$awsTags != null : !this$awsTags.equals(other$awsTags)) return false;
        final java.lang.Object this$bucket = this.getBucket();
        final java.lang.Object other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$s3BucketName = this.getS3BucketName();
        final java.lang.Object other$s3BucketName = other.getS3BucketName();
        if (this$s3BucketName == null ? other$s3BucketName != null : !this$s3BucketName.equals(other$s3BucketName)) return false;
        final java.lang.Object this$s3BucketQualifiedName = this.getS3BucketQualifiedName();
        final java.lang.Object other$s3BucketQualifiedName = other.getS3BucketQualifiedName();
        if (this$s3BucketQualifiedName == null ? other$s3BucketQualifiedName != null : !this$s3BucketQualifiedName.equals(other$s3BucketQualifiedName)) return false;
        final java.lang.Object this$s3ETag = this.getS3ETag();
        final java.lang.Object other$s3ETag = other.getS3ETag();
        if (this$s3ETag == null ? other$s3ETag != null : !this$s3ETag.equals(other$s3ETag)) return false;
        final java.lang.Object this$s3Encryption = this.getS3Encryption();
        final java.lang.Object other$s3Encryption = other.getS3Encryption();
        if (this$s3Encryption == null ? other$s3Encryption != null : !this$s3Encryption.equals(other$s3Encryption)) return false;
        final java.lang.Object this$s3ObjectContentDisposition = this.getS3ObjectContentDisposition();
        final java.lang.Object other$s3ObjectContentDisposition = other.getS3ObjectContentDisposition();
        if (this$s3ObjectContentDisposition == null ? other$s3ObjectContentDisposition != null : !this$s3ObjectContentDisposition.equals(other$s3ObjectContentDisposition)) return false;
        final java.lang.Object this$s3ObjectContentType = this.getS3ObjectContentType();
        final java.lang.Object other$s3ObjectContentType = other.getS3ObjectContentType();
        if (this$s3ObjectContentType == null ? other$s3ObjectContentType != null : !this$s3ObjectContentType.equals(other$s3ObjectContentType)) return false;
        final java.lang.Object this$s3ObjectKey = this.getS3ObjectKey();
        final java.lang.Object other$s3ObjectKey = other.getS3ObjectKey();
        if (this$s3ObjectKey == null ? other$s3ObjectKey != null : !this$s3ObjectKey.equals(other$s3ObjectKey)) return false;
        final java.lang.Object this$s3ObjectStorageClass = this.getS3ObjectStorageClass();
        final java.lang.Object other$s3ObjectStorageClass = other.getS3ObjectStorageClass();
        if (this$s3ObjectStorageClass == null ? other$s3ObjectStorageClass != null : !this$s3ObjectStorageClass.equals(other$s3ObjectStorageClass)) return false;
        final java.lang.Object this$s3ObjectVersionId = this.getS3ObjectVersionId();
        final java.lang.Object other$s3ObjectVersionId = other.getS3ObjectVersionId();
        if (this$s3ObjectVersionId == null ? other$s3ObjectVersionId != null : !this$s3ObjectVersionId.equals(other$s3ObjectVersionId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof S3Object;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $s3ObjectLastModifiedTime = this.getS3ObjectLastModifiedTime();
        result = result * PRIME + ($s3ObjectLastModifiedTime == null ? 43 : $s3ObjectLastModifiedTime.hashCode());
        final java.lang.Object $s3ObjectSize = this.getS3ObjectSize();
        result = result * PRIME + ($s3ObjectSize == null ? 43 : $s3ObjectSize.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $awsAccountId = this.getAwsAccountId();
        result = result * PRIME + ($awsAccountId == null ? 43 : $awsAccountId.hashCode());
        final java.lang.Object $awsArn = this.getAwsArn();
        result = result * PRIME + ($awsArn == null ? 43 : $awsArn.hashCode());
        final java.lang.Object $awsOwnerId = this.getAwsOwnerId();
        result = result * PRIME + ($awsOwnerId == null ? 43 : $awsOwnerId.hashCode());
        final java.lang.Object $awsOwnerName = this.getAwsOwnerName();
        result = result * PRIME + ($awsOwnerName == null ? 43 : $awsOwnerName.hashCode());
        final java.lang.Object $awsPartition = this.getAwsPartition();
        result = result * PRIME + ($awsPartition == null ? 43 : $awsPartition.hashCode());
        final java.lang.Object $awsRegion = this.getAwsRegion();
        result = result * PRIME + ($awsRegion == null ? 43 : $awsRegion.hashCode());
        final java.lang.Object $awsResourceId = this.getAwsResourceId();
        result = result * PRIME + ($awsResourceId == null ? 43 : $awsResourceId.hashCode());
        final java.lang.Object $awsService = this.getAwsService();
        result = result * PRIME + ($awsService == null ? 43 : $awsService.hashCode());
        final java.lang.Object $awsTags = this.getAwsTags();
        result = result * PRIME + ($awsTags == null ? 43 : $awsTags.hashCode());
        final java.lang.Object $bucket = this.getBucket();
        result = result * PRIME + ($bucket == null ? 43 : $bucket.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $s3BucketName = this.getS3BucketName();
        result = result * PRIME + ($s3BucketName == null ? 43 : $s3BucketName.hashCode());
        final java.lang.Object $s3BucketQualifiedName = this.getS3BucketQualifiedName();
        result = result * PRIME + ($s3BucketQualifiedName == null ? 43 : $s3BucketQualifiedName.hashCode());
        final java.lang.Object $s3ETag = this.getS3ETag();
        result = result * PRIME + ($s3ETag == null ? 43 : $s3ETag.hashCode());
        final java.lang.Object $s3Encryption = this.getS3Encryption();
        result = result * PRIME + ($s3Encryption == null ? 43 : $s3Encryption.hashCode());
        final java.lang.Object $s3ObjectContentDisposition = this.getS3ObjectContentDisposition();
        result = result * PRIME + ($s3ObjectContentDisposition == null ? 43 : $s3ObjectContentDisposition.hashCode());
        final java.lang.Object $s3ObjectContentType = this.getS3ObjectContentType();
        result = result * PRIME + ($s3ObjectContentType == null ? 43 : $s3ObjectContentType.hashCode());
        final java.lang.Object $s3ObjectKey = this.getS3ObjectKey();
        result = result * PRIME + ($s3ObjectKey == null ? 43 : $s3ObjectKey.hashCode());
        final java.lang.Object $s3ObjectStorageClass = this.getS3ObjectStorageClass();
        result = result * PRIME + ($s3ObjectStorageClass == null ? 43 : $s3ObjectStorageClass.hashCode());
        final java.lang.Object $s3ObjectVersionId = this.getS3ObjectVersionId();
        result = result * PRIME + ($s3ObjectVersionId == null ? 43 : $s3ObjectVersionId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "S3Object(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", awsAccountId=" + this.getAwsAccountId() + ", awsArn=" + this.getAwsArn() + ", awsOwnerId=" + this.getAwsOwnerId() + ", awsOwnerName=" + this.getAwsOwnerName() + ", awsPartition=" + this.getAwsPartition() + ", awsRegion=" + this.getAwsRegion() + ", awsResourceId=" + this.getAwsResourceId() + ", awsService=" + this.getAwsService() + ", awsTags=" + this.getAwsTags() + ", bucket=" + this.getBucket() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", s3BucketName=" + this.getS3BucketName() + ", s3BucketQualifiedName=" + this.getS3BucketQualifiedName() + ", s3ETag=" + this.getS3ETag() + ", s3Encryption=" + this.getS3Encryption() + ", s3ObjectContentDisposition=" + this.getS3ObjectContentDisposition() + ", s3ObjectContentType=" + this.getS3ObjectContentType() + ", s3ObjectKey=" + this.getS3ObjectKey() + ", s3ObjectLastModifiedTime=" + this.getS3ObjectLastModifiedTime() + ", s3ObjectSize=" + this.getS3ObjectSize() + ", s3ObjectStorageClass=" + this.getS3ObjectStorageClass() + ", s3ObjectVersionId=" + this.getS3ObjectVersionId() + ")";
    }

    /**
     * Fixed typeName for S3Objects.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
