// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Salesforce field in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SalesforceField extends Asset implements ISalesforceField, ISalesforce, ISaaS, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SalesforceField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceField";
    /**
     * Fixed typeName for SalesforceFields.
     */
    String typeName;
    /**
     * Name of this asset in the Salesforce API.
     */
    @Attribute
    String apiName;
    /**
     * Data type of values in this field.
     */
    @Attribute
    String dataType;
    /**
     * Formula for the default value for this field.
     */
    @Attribute
    String defaultValueFormula;
    /**
     * Formula for this field, if it is a calculated field.
     */
    @Attribute
    String formula;
    /**
     * Help text for this field.
     */
    @Attribute
    String inlineHelpText;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Whether this field is calculated (true) or not (false).
     */
    @Attribute
    Boolean isCalculated;
    /**
     * Whether this field is case sensitive (true) or in-sensitive (false).
     */
    @Attribute
    Boolean isCaseSensitive;
    /**
     * Whether this field is encrypted (true) or not (false).
     */
    @Attribute
    Boolean isEncrypted;
    /**
     * Whether this field allows null values (true) or not (false).
     */
    @Attribute
    Boolean isNullable;
    /**
     * Whether this field references a record of multiple objects (true) or not (false).
     */
    @Attribute
    Boolean isPolymorphicForeignKey;
    /**
     * Whether this field must have unique values (true) or not (false).
     */
    @Attribute
    Boolean isUnique;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISalesforceObject> lookupObjects;
    /**
     * Maximum length of this field.
     */
    @Attribute
    Long maxLength;
    /**
     * Number of digits allowed to the right of the decimal point.
     */
    @Attribute
    Double numericScale;
    /**
     * Object in which this field exists.
     */
    @Attribute
    ISalesforceObject object;
    /**
     * Unique name of the object in which this field exists.
     */
    @Attribute
    String objectQualifiedName;
    /**
     * Order (position) of this field within the object.
     */
    @Attribute
    Integer order;
    /**
     * Fully-qualified name of the organization in Salesforce.
     */
    @Attribute
    String organizationQualifiedName;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * List of values from which a user can pick while adding a record.
     */
    @Attribute
    SortedSet<String> picklistValues;
    /**
     * Total number of digits allowed
     */
    @Attribute
    Integer precision;

    /**
     * Builds the minimal object necessary to create a relationship to a SalesforceField, from a potentially
     * more-complete SalesforceField object.
     *
     * @return the minimal object necessary to relate to the SalesforceField
     * @throws InvalidRequestException if any of the minimal set of required properties for a SalesforceField relationship are not found in the initial object
     */
    @Override
    public SalesforceField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SalesforceField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SalesforceField assets will be included.
     *
     * @return a fluent search that includes all SalesforceField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SalesforceField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SalesforceField assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SalesforceField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SalesforceField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SalesforceFields will be included
     * @return a fluent search that includes all SalesforceField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SalesforceField assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SalesforceFields will be included
     * @return a fluent search that includes all SalesforceField assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SalesforceField by GUID. Use this to create a relationship to this SalesforceField,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SalesforceField to reference
     * @return reference to a SalesforceField that can be used for defining a relationship to a SalesforceField
     */
    public static SalesforceField refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SalesforceField by GUID. Use this to create a relationship to this SalesforceField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SalesforceField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SalesforceField that can be used for defining a relationship to a SalesforceField
     */
    public static SalesforceField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SalesforceField._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SalesforceField by qualifiedName. Use this to create a relationship to this SalesforceField,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SalesforceField to reference
     * @return reference to a SalesforceField that can be used for defining a relationship to a SalesforceField
     */
    public static SalesforceField refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SalesforceField by qualifiedName. Use this to create a relationship to this SalesforceField,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SalesforceField to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SalesforceField that can be used for defining a relationship to a SalesforceField
     */
    public static SalesforceField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SalesforceField._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SalesforceField by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SalesforceField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SalesforceField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SalesforceField does not exist or the provided GUID is not a SalesforceField
     */
    @JsonIgnore
    public static SalesforceField get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SalesforceField by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SalesforceField to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SalesforceField, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SalesforceField does not exist or the provided GUID is not a SalesforceField
     */
    @JsonIgnore
    public static SalesforceField get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SalesforceField by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SalesforceField to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SalesforceField, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SalesforceField does not exist or the provided GUID is not a SalesforceField
     */
    @JsonIgnore
    public static SalesforceField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SalesforceField) {
                return (SalesforceField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SalesforceField) {
                return (SalesforceField) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SalesforceField to active.
     *
     * @param qualifiedName for the SalesforceField
     * @return true if the SalesforceField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SalesforceField to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SalesforceField
     * @return true if the SalesforceField is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a SalesforceField asset.
     *
     * @param name of the field
     * @param object Salesforce object through which the asset is accessible, which must have its qualifiedName populated
     * @return the minimal object necessary to create the asset, as a builder
     * @throws InvalidRequestException if the provided object does not have a qualifiedName
     */
    public static SalesforceFieldBuilder<?, ?> creator(String name, SalesforceObject object) throws InvalidRequestException {
        validateRelationship(SalesforceObject.TYPE_NAME, Map.of("connectionQualifiedName", object.getConnectionQualifiedName(), "organizationQualifiedName", object.getOrganizationQualifiedName(), "qualifiedName", object.getQualifiedName()));
        return creator(name, object.getConnectionQualifiedName(), object.getOrganizationQualifiedName(), object.getQualifiedName()).object(object.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a SalesforceField asset.
     *
     * @param name of the field
     * @param objectQualifiedName unique name of the object through which the asset is accessible
     * @return the minimal object necessary to create the asset, as a builder
     */
    public static SalesforceFieldBuilder<?, ?> creator(String name, String objectQualifiedName) {
        String organizationQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(objectQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(organizationQualifiedName);
        return creator(name, connectionQualifiedName, organizationQualifiedName, objectQualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a SalesforceField asset.
     *
     * @param name of the field
     * @param connectionQualifiedName unique name of the connection in which to create the SalesforceField
     * @param organizationQualifiedName unique name of the SalesforceOrganization in which to create the SalesforceField
     * @param objectQualifiedName unique name of the object through which the asset is accessible
     * @return the minimal object necessary to create the asset, as a builder
     */
    public static SalesforceFieldBuilder<?, ?> creator(String name, String connectionQualifiedName, String organizationQualifiedName, String objectQualifiedName) {
        return SalesforceField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(generateQualifiedName(name, objectQualifiedName)).name(name).connectionQualifiedName(connectionQualifiedName).connectorType(AtlanConnectorType.SALESFORCE).organizationQualifiedName(organizationQualifiedName).object(SalesforceObject.refByQualifiedName(objectQualifiedName)).objectQualifiedName(objectQualifiedName);
    }

    /**
     * Generate a unique SalesforceField name.
     *
     * @param name unique name of the object within Salesforce
     * @param objectQualifiedName unique name of the object through which the asset is accessible
     * @return a unique name for the SalesforceField
     */
    public static String generateQualifiedName(String name, String objectQualifiedName) {
        return objectQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the minimal request necessary to update the SalesforceField, as a builder
     */
    public static SalesforceFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return SalesforceField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SalesforceField, from a potentially
     * more-complete SalesforceField object.
     *
     * @return the minimal object necessary to update the SalesforceField, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SalesforceField are not found in the initial object
     */
    @Override
    public SalesforceFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SalesforceField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SalesforceField.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SalesforceField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SalesforceField's owners
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SalesforceField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SalesforceField.
     *
     * @param client connectivity to the Atlan tenant on which to update the SalesforceField's certificate
     * @param qualifiedName of the SalesforceField
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SalesforceField, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceField) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SalesforceField.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SalesforceField's certificate
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SalesforceField.
     *
     * @param client connectivity to the Atlan tenant on which to update the SalesforceField's announcement
     * @param qualifiedName of the SalesforceField
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceField) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SalesforceField.
     *
     * @param client connectivity to the Atlan client from which to remove the SalesforceField's announcement
     * @param qualifiedName of the SalesforceField
     * @param name of the SalesforceField
     * @return the updated SalesforceField, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SalesforceField.
     *
     * @param qualifiedName for the SalesforceField
     * @param name human-readable name of the SalesforceField
     * @param terms the list of terms to replace on the SalesforceField, or null to remove all terms from the SalesforceField
     * @return the SalesforceField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SalesforceField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SalesforceField.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SalesforceField's assigned terms
     * @param qualifiedName for the SalesforceField
     * @param name human-readable name of the SalesforceField
     * @param terms the list of terms to replace on the SalesforceField, or null to remove all terms from the SalesforceField
     * @return the SalesforceField that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SalesforceField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceField) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SalesforceField, without replacing existing terms linked to the SalesforceField.
     * Note: this operation must make two API calls — one to retrieve the SalesforceField's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SalesforceField
     * @param terms the list of terms to append to the SalesforceField
     * @return the SalesforceField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SalesforceField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SalesforceField, without replacing existing terms linked to the SalesforceField.
     * Note: this operation must make two API calls — one to retrieve the SalesforceField's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SalesforceField
     * @param qualifiedName for the SalesforceField
     * @param terms the list of terms to append to the SalesforceField
     * @return the SalesforceField that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SalesforceField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceField) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SalesforceField, without replacing all existing terms linked to the SalesforceField.
     * Note: this operation must make two API calls — one to retrieve the SalesforceField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SalesforceField
     * @param terms the list of terms to remove from the SalesforceField, which must be referenced by GUID
     * @return the SalesforceField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SalesforceField, without replacing all existing terms linked to the SalesforceField.
     * Note: this operation must make two API calls — one to retrieve the SalesforceField's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SalesforceField
     * @param qualifiedName for the SalesforceField
     * @param terms the list of terms to remove from the SalesforceField, which must be referenced by GUID
     * @return the SalesforceField that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SalesforceField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceField) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SalesforceField, without replacing existing Atlan tags linked to the SalesforceField.
     * Note: this operation must make two API calls — one to retrieve the SalesforceField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SalesforceField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SalesforceField
     */
    public static SalesforceField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SalesforceField, without replacing existing Atlan tags linked to the SalesforceField.
     * Note: this operation must make two API calls — one to retrieve the SalesforceField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SalesforceField
     * @param qualifiedName of the SalesforceField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SalesforceField
     */
    public static SalesforceField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SalesforceField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SalesforceField, without replacing existing Atlan tags linked to the SalesforceField.
     * Note: this operation must make two API calls — one to retrieve the SalesforceField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SalesforceField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SalesforceField
     */
    public static SalesforceField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SalesforceField, without replacing existing Atlan tags linked to the SalesforceField.
     * Note: this operation must make two API calls — one to retrieve the SalesforceField's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SalesforceField
     * @param qualifiedName of the SalesforceField
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SalesforceField
     */
    public static SalesforceField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SalesforceField) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SalesforceField.
     *
     * @param qualifiedName of the SalesforceField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SalesforceField
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SalesforceField.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SalesforceField
     * @param qualifiedName of the SalesforceField
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SalesforceField
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SalesforceFieldBuilder<C extends SalesforceField, B extends SalesforceField.SalesforceFieldBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String apiName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String dataType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String defaultValueFormula;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String formula;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String inlineHelpText;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isCalculated;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isCaseSensitive;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isEncrypted;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isNullable;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isPolymorphicForeignKey;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isUnique;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISalesforceObject> lookupObjects;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long maxLength;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Double numericScale;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ISalesforceObject object;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String objectQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer order;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String organizationQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> picklistValues;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer precision;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SalesforceField.SalesforceFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SalesforceField instance, final SalesforceField.SalesforceFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiName(instance.apiName);
            b.dataType(instance.dataType);
            b.defaultValueFormula(instance.defaultValueFormula);
            b.formula(instance.formula);
            b.inlineHelpText(instance.inlineHelpText);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.isCalculated(instance.isCalculated);
            b.isCaseSensitive(instance.isCaseSensitive);
            b.isEncrypted(instance.isEncrypted);
            b.isNullable(instance.isNullable);
            b.isPolymorphicForeignKey(instance.isPolymorphicForeignKey);
            b.isUnique(instance.isUnique);
            b.lookupObjects(instance.lookupObjects == null ? java.util.Collections.<ISalesforceObject>emptySortedSet() : instance.lookupObjects);
            b.maxLength(instance.maxLength);
            b.numericScale(instance.numericScale);
            b.object(instance.object);
            b.objectQualifiedName(instance.objectQualifiedName);
            b.order(instance.order);
            b.organizationQualifiedName(instance.organizationQualifiedName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.picklistValues(instance.picklistValues == null ? java.util.Collections.<String>emptySortedSet() : instance.picklistValues);
            b.precision(instance.precision);
        }

        /**
         * Fixed typeName for SalesforceFields.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Name of this asset in the Salesforce API.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B apiName(final String apiName) {
            this.apiName = apiName;
            return self();
        }

        /**
         * Data type of values in this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dataType(final String dataType) {
            this.dataType = dataType;
            return self();
        }

        /**
         * Formula for the default value for this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultValueFormula(final String defaultValueFormula) {
            this.defaultValueFormula = defaultValueFormula;
            return self();
        }

        /**
         * Formula for this field, if it is a calculated field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B formula(final String formula) {
            this.formula = formula;
            return self();
        }

        /**
         * Help text for this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inlineHelpText(final String inlineHelpText) {
            this.inlineHelpText = inlineHelpText;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Whether this field is calculated (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isCalculated(final Boolean isCalculated) {
            this.isCalculated = isCalculated;
            return self();
        }

        /**
         * Whether this field is case sensitive (true) or in-sensitive (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isCaseSensitive(final Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            return self();
        }

        /**
         * Whether this field is encrypted (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isEncrypted(final Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return self();
        }

        /**
         * Whether this field allows null values (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isNullable(final Boolean isNullable) {
            this.isNullable = isNullable;
            return self();
        }

        /**
         * Whether this field references a record of multiple objects (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isPolymorphicForeignKey(final Boolean isPolymorphicForeignKey) {
            this.isPolymorphicForeignKey = isPolymorphicForeignKey;
            return self();
        }

        /**
         * Whether this field must have unique values (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isUnique(final Boolean isUnique) {
            this.isUnique = isUnique;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookupObject(final ISalesforceObject lookupObject) {
            if (this.lookupObjects == null) this.lookupObjects = new java.util.ArrayList<ISalesforceObject>();
            this.lookupObjects.add(lookupObject);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lookupObjects(final java.util.Collection<? extends ISalesforceObject> lookupObjects) {
            if (lookupObjects == null) {
                throw new java.lang.NullPointerException("lookupObjects cannot be null");
            }
            if (this.lookupObjects == null) this.lookupObjects = new java.util.ArrayList<ISalesforceObject>();
            this.lookupObjects.addAll(lookupObjects);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLookupObjects() {
            if (this.lookupObjects != null) this.lookupObjects.clear();
            return self();
        }

        /**
         * Maximum length of this field.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B maxLength(final Long maxLength) {
            this.maxLength = maxLength;
            return self();
        }

        /**
         * Number of digits allowed to the right of the decimal point.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B numericScale(final Double numericScale) {
            this.numericScale = numericScale;
            return self();
        }

        /**
         * Object in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B object(final ISalesforceObject object) {
            this.object = object;
            return self();
        }

        /**
         * Unique name of the object in which this field exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B objectQualifiedName(final String objectQualifiedName) {
            this.objectQualifiedName = objectQualifiedName;
            return self();
        }

        /**
         * Order (position) of this field within the object.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B order(final Integer order) {
            this.order = order;
            return self();
        }

        /**
         * Fully-qualified name of the organization in Salesforce.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B organizationQualifiedName(final String organizationQualifiedName) {
            this.organizationQualifiedName = organizationQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B picklistValue(final String picklistValue) {
            if (this.picklistValues == null) this.picklistValues = new java.util.ArrayList<String>();
            this.picklistValues.add(picklistValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B picklistValues(final java.util.Collection<? extends String> picklistValues) {
            if (picklistValues == null) {
                throw new java.lang.NullPointerException("picklistValues cannot be null");
            }
            if (this.picklistValues == null) this.picklistValues = new java.util.ArrayList<String>();
            this.picklistValues.addAll(picklistValues);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPicklistValues() {
            if (this.picklistValues != null) this.picklistValues.clear();
            return self();
        }

        /**
         * Total number of digits allowed
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B precision(final Integer precision) {
            this.precision = precision;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SalesforceField.SalesforceFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiName=" + this.apiName + ", dataType=" + this.dataType + ", defaultValueFormula=" + this.defaultValueFormula + ", formula=" + this.formula + ", inlineHelpText=" + this.inlineHelpText + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isCalculated=" + this.isCalculated + ", isCaseSensitive=" + this.isCaseSensitive + ", isEncrypted=" + this.isEncrypted + ", isNullable=" + this.isNullable + ", isPolymorphicForeignKey=" + this.isPolymorphicForeignKey + ", isUnique=" + this.isUnique + ", lookupObjects=" + this.lookupObjects + ", maxLength=" + this.maxLength + ", numericScale=" + this.numericScale + ", object=" + this.object + ", objectQualifiedName=" + this.objectQualifiedName + ", order=" + this.order + ", organizationQualifiedName=" + this.organizationQualifiedName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", picklistValues=" + this.picklistValues + ", precision=" + this.precision + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SalesforceFieldBuilderImpl extends SalesforceField.SalesforceFieldBuilder<SalesforceField, SalesforceField.SalesforceFieldBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SalesforceFieldBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SalesforceField.SalesforceFieldBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SalesforceField build() {
            return new SalesforceField(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SalesforceField(final SalesforceField.SalesforceFieldBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SalesforceField.$default$typeName();
        this.apiName = b.apiName;
        this.dataType = b.dataType;
        this.defaultValueFormula = b.defaultValueFormula;
        this.formula = b.formula;
        this.inlineHelpText = b.inlineHelpText;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isCalculated = b.isCalculated;
        this.isCaseSensitive = b.isCaseSensitive;
        this.isEncrypted = b.isEncrypted;
        this.isNullable = b.isNullable;
        this.isPolymorphicForeignKey = b.isPolymorphicForeignKey;
        this.isUnique = b.isUnique;
        java.util.SortedSet<ISalesforceObject> lookupObjects = new java.util.TreeSet<ISalesforceObject>();
        if (b.lookupObjects != null) lookupObjects.addAll(b.lookupObjects);
        lookupObjects = java.util.Collections.unmodifiableSortedSet(lookupObjects);
        this.lookupObjects = lookupObjects;
        this.maxLength = b.maxLength;
        this.numericScale = b.numericScale;
        this.object = b.object;
        this.objectQualifiedName = b.objectQualifiedName;
        this.order = b.order;
        this.organizationQualifiedName = b.organizationQualifiedName;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<String> picklistValues = new java.util.TreeSet<String>();
        if (b.picklistValues != null) picklistValues.addAll(b.picklistValues);
        picklistValues = java.util.Collections.unmodifiableSortedSet(picklistValues);
        this.picklistValues = picklistValues;
        this.precision = b.precision;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SalesforceField.SalesforceFieldBuilder<?, ?> _internal() {
        return new SalesforceField.SalesforceFieldBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SalesforceField.SalesforceFieldBuilder<?, ?> toBuilder() {
        return new SalesforceField.SalesforceFieldBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Name of this asset in the Salesforce API.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getApiName() {
        return this.apiName;
    }

    /**
     * Data type of values in this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDataType() {
        return this.dataType;
    }

    /**
     * Formula for the default value for this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultValueFormula() {
        return this.defaultValueFormula;
    }

    /**
     * Formula for this field, if it is a calculated field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFormula() {
        return this.formula;
    }

    /**
     * Help text for this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getInlineHelpText() {
        return this.inlineHelpText;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Whether this field is calculated (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsCalculated() {
        return this.isCalculated;
    }

    /**
     * Whether this field is case sensitive (true) or in-sensitive (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    /**
     * Whether this field is encrypted (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    /**
     * Whether this field allows null values (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsNullable() {
        return this.isNullable;
    }

    /**
     * Whether this field references a record of multiple objects (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsPolymorphicForeignKey() {
        return this.isPolymorphicForeignKey;
    }

    /**
     * Whether this field must have unique values (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsUnique() {
        return this.isUnique;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISalesforceObject> getLookupObjects() {
        return this.lookupObjects;
    }

    /**
     * Maximum length of this field.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getMaxLength() {
        return this.maxLength;
    }

    /**
     * Number of digits allowed to the right of the decimal point.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Double getNumericScale() {
        return this.numericScale;
    }

    /**
     * Object in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ISalesforceObject getObject() {
        return this.object;
    }

    /**
     * Unique name of the object in which this field exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getObjectQualifiedName() {
        return this.objectQualifiedName;
    }

    /**
     * Order (position) of this field within the object.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getOrder() {
        return this.order;
    }

    /**
     * Fully-qualified name of the organization in Salesforce.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getOrganizationQualifiedName() {
        return this.organizationQualifiedName;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * List of values from which a user can pick while adding a record.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPicklistValues() {
        return this.picklistValues;
    }

    /**
     * Total number of digits allowed
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getPrecision() {
        return this.precision;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SalesforceField)) return false;
        final SalesforceField other = (SalesforceField) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isCalculated = this.getIsCalculated();
        final java.lang.Object other$isCalculated = other.getIsCalculated();
        if (this$isCalculated == null ? other$isCalculated != null : !this$isCalculated.equals(other$isCalculated)) return false;
        final java.lang.Object this$isCaseSensitive = this.getIsCaseSensitive();
        final java.lang.Object other$isCaseSensitive = other.getIsCaseSensitive();
        if (this$isCaseSensitive == null ? other$isCaseSensitive != null : !this$isCaseSensitive.equals(other$isCaseSensitive)) return false;
        final java.lang.Object this$isEncrypted = this.getIsEncrypted();
        final java.lang.Object other$isEncrypted = other.getIsEncrypted();
        if (this$isEncrypted == null ? other$isEncrypted != null : !this$isEncrypted.equals(other$isEncrypted)) return false;
        final java.lang.Object this$isNullable = this.getIsNullable();
        final java.lang.Object other$isNullable = other.getIsNullable();
        if (this$isNullable == null ? other$isNullable != null : !this$isNullable.equals(other$isNullable)) return false;
        final java.lang.Object this$isPolymorphicForeignKey = this.getIsPolymorphicForeignKey();
        final java.lang.Object other$isPolymorphicForeignKey = other.getIsPolymorphicForeignKey();
        if (this$isPolymorphicForeignKey == null ? other$isPolymorphicForeignKey != null : !this$isPolymorphicForeignKey.equals(other$isPolymorphicForeignKey)) return false;
        final java.lang.Object this$isUnique = this.getIsUnique();
        final java.lang.Object other$isUnique = other.getIsUnique();
        if (this$isUnique == null ? other$isUnique != null : !this$isUnique.equals(other$isUnique)) return false;
        final java.lang.Object this$maxLength = this.getMaxLength();
        final java.lang.Object other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !this$maxLength.equals(other$maxLength)) return false;
        final java.lang.Object this$numericScale = this.getNumericScale();
        final java.lang.Object other$numericScale = other.getNumericScale();
        if (this$numericScale == null ? other$numericScale != null : !this$numericScale.equals(other$numericScale)) return false;
        final java.lang.Object this$order = this.getOrder();
        final java.lang.Object other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) return false;
        final java.lang.Object this$precision = this.getPrecision();
        final java.lang.Object other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !this$precision.equals(other$precision)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$apiName = this.getApiName();
        final java.lang.Object other$apiName = other.getApiName();
        if (this$apiName == null ? other$apiName != null : !this$apiName.equals(other$apiName)) return false;
        final java.lang.Object this$dataType = this.getDataType();
        final java.lang.Object other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) return false;
        final java.lang.Object this$defaultValueFormula = this.getDefaultValueFormula();
        final java.lang.Object other$defaultValueFormula = other.getDefaultValueFormula();
        if (this$defaultValueFormula == null ? other$defaultValueFormula != null : !this$defaultValueFormula.equals(other$defaultValueFormula)) return false;
        final java.lang.Object this$formula = this.getFormula();
        final java.lang.Object other$formula = other.getFormula();
        if (this$formula == null ? other$formula != null : !this$formula.equals(other$formula)) return false;
        final java.lang.Object this$inlineHelpText = this.getInlineHelpText();
        final java.lang.Object other$inlineHelpText = other.getInlineHelpText();
        if (this$inlineHelpText == null ? other$inlineHelpText != null : !this$inlineHelpText.equals(other$inlineHelpText)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$lookupObjects = this.getLookupObjects();
        final java.lang.Object other$lookupObjects = other.getLookupObjects();
        if (this$lookupObjects == null ? other$lookupObjects != null : !this$lookupObjects.equals(other$lookupObjects)) return false;
        final java.lang.Object this$object = this.getObject();
        final java.lang.Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
        final java.lang.Object this$objectQualifiedName = this.getObjectQualifiedName();
        final java.lang.Object other$objectQualifiedName = other.getObjectQualifiedName();
        if (this$objectQualifiedName == null ? other$objectQualifiedName != null : !this$objectQualifiedName.equals(other$objectQualifiedName)) return false;
        final java.lang.Object this$organizationQualifiedName = this.getOrganizationQualifiedName();
        final java.lang.Object other$organizationQualifiedName = other.getOrganizationQualifiedName();
        if (this$organizationQualifiedName == null ? other$organizationQualifiedName != null : !this$organizationQualifiedName.equals(other$organizationQualifiedName)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$picklistValues = this.getPicklistValues();
        final java.lang.Object other$picklistValues = other.getPicklistValues();
        if (this$picklistValues == null ? other$picklistValues != null : !this$picklistValues.equals(other$picklistValues)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SalesforceField;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isCalculated = this.getIsCalculated();
        result = result * PRIME + ($isCalculated == null ? 43 : $isCalculated.hashCode());
        final java.lang.Object $isCaseSensitive = this.getIsCaseSensitive();
        result = result * PRIME + ($isCaseSensitive == null ? 43 : $isCaseSensitive.hashCode());
        final java.lang.Object $isEncrypted = this.getIsEncrypted();
        result = result * PRIME + ($isEncrypted == null ? 43 : $isEncrypted.hashCode());
        final java.lang.Object $isNullable = this.getIsNullable();
        result = result * PRIME + ($isNullable == null ? 43 : $isNullable.hashCode());
        final java.lang.Object $isPolymorphicForeignKey = this.getIsPolymorphicForeignKey();
        result = result * PRIME + ($isPolymorphicForeignKey == null ? 43 : $isPolymorphicForeignKey.hashCode());
        final java.lang.Object $isUnique = this.getIsUnique();
        result = result * PRIME + ($isUnique == null ? 43 : $isUnique.hashCode());
        final java.lang.Object $maxLength = this.getMaxLength();
        result = result * PRIME + ($maxLength == null ? 43 : $maxLength.hashCode());
        final java.lang.Object $numericScale = this.getNumericScale();
        result = result * PRIME + ($numericScale == null ? 43 : $numericScale.hashCode());
        final java.lang.Object $order = this.getOrder();
        result = result * PRIME + ($order == null ? 43 : $order.hashCode());
        final java.lang.Object $precision = this.getPrecision();
        result = result * PRIME + ($precision == null ? 43 : $precision.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $apiName = this.getApiName();
        result = result * PRIME + ($apiName == null ? 43 : $apiName.hashCode());
        final java.lang.Object $dataType = this.getDataType();
        result = result * PRIME + ($dataType == null ? 43 : $dataType.hashCode());
        final java.lang.Object $defaultValueFormula = this.getDefaultValueFormula();
        result = result * PRIME + ($defaultValueFormula == null ? 43 : $defaultValueFormula.hashCode());
        final java.lang.Object $formula = this.getFormula();
        result = result * PRIME + ($formula == null ? 43 : $formula.hashCode());
        final java.lang.Object $inlineHelpText = this.getInlineHelpText();
        result = result * PRIME + ($inlineHelpText == null ? 43 : $inlineHelpText.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $lookupObjects = this.getLookupObjects();
        result = result * PRIME + ($lookupObjects == null ? 43 : $lookupObjects.hashCode());
        final java.lang.Object $object = this.getObject();
        result = result * PRIME + ($object == null ? 43 : $object.hashCode());
        final java.lang.Object $objectQualifiedName = this.getObjectQualifiedName();
        result = result * PRIME + ($objectQualifiedName == null ? 43 : $objectQualifiedName.hashCode());
        final java.lang.Object $organizationQualifiedName = this.getOrganizationQualifiedName();
        result = result * PRIME + ($organizationQualifiedName == null ? 43 : $organizationQualifiedName.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $picklistValues = this.getPicklistValues();
        result = result * PRIME + ($picklistValues == null ? 43 : $picklistValues.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SalesforceField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiName=" + this.getApiName() + ", dataType=" + this.getDataType() + ", defaultValueFormula=" + this.getDefaultValueFormula() + ", formula=" + this.getFormula() + ", inlineHelpText=" + this.getInlineHelpText() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isCalculated=" + this.getIsCalculated() + ", isCaseSensitive=" + this.getIsCaseSensitive() + ", isEncrypted=" + this.getIsEncrypted() + ", isNullable=" + this.getIsNullable() + ", isPolymorphicForeignKey=" + this.getIsPolymorphicForeignKey() + ", isUnique=" + this.getIsUnique() + ", lookupObjects=" + this.getLookupObjects() + ", maxLength=" + this.getMaxLength() + ", numericScale=" + this.getNumericScale() + ", object=" + this.getObject() + ", objectQualifiedName=" + this.getObjectQualifiedName() + ", order=" + this.getOrder() + ", organizationQualifiedName=" + this.getOrganizationQualifiedName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", picklistValues=" + this.getPicklistValues() + ", precision=" + this.getPrecision() + ")";
    }

    /**
     * Fixed typeName for SalesforceFields.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
