// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a database schema in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@SuppressWarnings("cast")
public class Schema extends Asset implements ISchema, ISQL, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Schema.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Schema";
    /**
     * Fixed typeName for Schemas.
     */
    String typeName;
    /**
     * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @Attribute
    String calculationViewName;
    /**
     * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @Attribute
    String calculationViewQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ICalculationView> calculationViews;
    /**
     * Database in which this schema exists.
     */
    @Attribute
    IDatabase database;
    /**
     * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @Attribute
    String databaseName;
    /**
     * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @Attribute
    String databaseQualifiedName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    /**
     * Functions that exist within this schema.
     */
    @Attribute
    SortedSet<IFunction> functions;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Whether this asset has been profiled (true) or not (false).
     */
    @Attribute
    Boolean isProfiled;
    /**
     * Time (epoch) at which this asset was last profiled, in milliseconds.
     */
    @Attribute
    @Date
    Long lastProfiledAt;
    /**
     * Unique name of the Linked Schema on which this Schema is dependent. This concept is mostly applicable for linked datasets/datasource in Google BigQuery via Analytics Hub Listing
     */
    @Attribute
    String linkedSchemaQualifiedName;
    /**
     * Materialized views that exist within this schema.
     */
    @Attribute
    @JsonProperty("materialisedViews")
    SortedSet<IMaterializedView> materializedViews;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Stored procedures that exist within this schema.
     */
    @Attribute
    SortedSet<IProcedure> procedures;
    /**
     * Number of times this asset has been queried.
     */
    @Attribute
    Long queryCount;
    /**
     * Time (epoch) at which the query count was last updated, in milliseconds.
     */
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    /**
     * Number of unique users who have queried this asset.
     */
    @Attribute
    Long queryUserCount;
    /**
     * Map of unique users who have queried this asset to the number of times they have queried it.
     */
    @Attribute
    Map<String, Long> queryUserMap;
    /**
     * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @Attribute
    String schemaName;
    /**
     * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @Attribute
    String schemaQualifiedName;
    /**
     * Snowflake dynamic tables that exist within this schema.
     */
    @Attribute
    SortedSet<ISnowflakeDynamicTable> snowflakeDynamicTables;
    /**
     * Snowflake pipes that exist within this schema.
     */
    @Attribute
    SortedSet<ISnowflakePipe> snowflakePipes;
    /**
     * Snowflake streams that exist within this schema.
     */
    @Attribute
    SortedSet<ISnowflakeStream> snowflakeStreams;
    /**
     * Snowflake tags that exist within this schema.
     */
    @Attribute
    SortedSet<ISnowflakeTag> snowflakeTags;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    /**
     * Number of tables in this schema.
     */
    @Attribute
    Integer tableCount;
    /**
     * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @Attribute
    String tableName;
    /**
     * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @Attribute
    String tableQualifiedName;
    /**
     * Tables that exist within this schema.
     */
    @Attribute
    SortedSet<ITable> tables;
    /**
     * Number of views in this schema.
     */
    @Attribute
    @JsonProperty("viewsCount")
    Integer viewCount;
    /**
     * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @Attribute
    String viewName;
    /**
     * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @Attribute
    String viewQualifiedName;
    /**
     * Views that exist within this schema.
     */
    @Attribute
    SortedSet<IView> views;

    /**
     * Builds the minimal object necessary to create a relationship to a Schema, from a potentially
     * more-complete Schema object.
     *
     * @return the minimal object necessary to relate to the Schema
     * @throws InvalidRequestException if any of the minimal set of required properties for a Schema relationship are not found in the initial object
     */
    @Override
    public Schema trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Schema assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Schema assets will be included.
     *
     * @return a fluent search that includes all Schema assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Schema assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Schema assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Schema assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Schema assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Schemas will be included
     * @return a fluent search that includes all Schema assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Schema assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Schemas will be included
     * @return a fluent search that includes all Schema assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Schema by GUID. Use this to create a relationship to this Schema,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Schema to reference
     * @return reference to a Schema that can be used for defining a relationship to a Schema
     */
    public static Schema refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Schema by GUID. Use this to create a relationship to this Schema,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Schema to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Schema that can be used for defining a relationship to a Schema
     */
    public static Schema refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Schema._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Schema by qualifiedName. Use this to create a relationship to this Schema,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Schema to reference
     * @return reference to a Schema that can be used for defining a relationship to a Schema
     */
    public static Schema refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Schema by qualifiedName. Use this to create a relationship to this Schema,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Schema to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Schema that can be used for defining a relationship to a Schema
     */
    public static Schema refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Schema._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Schema by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Schema to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Schema, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Schema does not exist or the provided GUID is not a Schema
     */
    @JsonIgnore
    public static Schema get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Schema by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Schema to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Schema, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Schema does not exist or the provided GUID is not a Schema
     */
    @JsonIgnore
    public static Schema get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Schema by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Schema to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Schema, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Schema does not exist or the provided GUID is not a Schema
     */
    @JsonIgnore
    public static Schema get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Schema) {
                return (Schema) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Schema) {
                return (Schema) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Schema to active.
     *
     * @param qualifiedName for the Schema
     * @return true if the Schema is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Schema to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Schema
     * @return true if the Schema is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a schema.
     *
     * @param name of the schema
     * @param database in which the schema should be created, which must have at least
     *                 a qualifiedName
     * @return the minimal request necessary to create the schema, as a builder
     * @throws InvalidRequestException if the database provided is without a qualifiedName
     */
    public static SchemaBuilder<?, ?> creator(String name, Database database) throws InvalidRequestException {
        validateRelationship(Database.TYPE_NAME, Map.of("connectionQualifiedName", database.getConnectionQualifiedName(), "name", database.getName(), "qualifiedName", database.getQualifiedName()));
        return creator(name, database.getConnectionQualifiedName(), database.getName(), database.getQualifiedName()).database(database.trimToReference());
    }

    /**
     * Builds the minimal object necessary to create a schema.
     *
     * @param name of the schema
     * @param databaseQualifiedName unique name of the database in which this schema exists
     * @return the minimal request necessary to create the schema, as a builder
     */
    public static SchemaBuilder<?, ?> creator(String name, String databaseQualifiedName) {
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return creator(name, connectionQualifiedName, databaseName, databaseQualifiedName);
    }

    /**
     * Builds the minimal object necessary to create a schema.
     *
     * @param name of the schema
     * @param connectionQualifiedName unique name of the connection in which to create the Schema
     * @param databaseName simple name of the database in which to create the Schema
     * @param databaseQualifiedName unique name of the database in which to create the Schema
     * @return the minimal request necessary to create the schema, as a builder
     */
    public static SchemaBuilder<?, ?> creator(String name, String connectionQualifiedName, String databaseName, String databaseQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return Schema._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).name(name).qualifiedName(generateQualifiedName(name, databaseQualifiedName)).connectorType(connectorType).databaseName(databaseName).databaseQualifiedName(databaseQualifiedName).database(Database.refByQualifiedName(databaseQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    /**
     * Generate a unique schema name.
     *
     * @param name of the schema
     * @param databaseQualifiedName unique name of the database in which this schema exists
     * @return a unique name for the schema
     */
    public static String generateQualifiedName(String name, String databaseQualifiedName) {
        return databaseQualifiedName + "/" + name;
    }

    /**
     * Builds the minimal object necessary to update a Schema.
     *
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the minimal request necessary to update the Schema, as a builder
     */
    public static SchemaBuilder<?, ?> updater(String qualifiedName, String name) {
        return Schema._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Schema, from a potentially
     * more-complete Schema object.
     *
     * @return the minimal object necessary to update the Schema, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Schema are not found in the initial object
     */
    @Override
    public SchemaBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a Schema.
     *
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Schema.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a Schema.
     *
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Schema.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a Schema.
     *
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a Schema.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Schema's owners
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a Schema.
     *
     * @param qualifiedName of the Schema
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Schema, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Schema updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a Schema.
     *
     * @param client connectivity to the Atlan tenant on which to update the Schema's certificate
     * @param qualifiedName of the Schema
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Schema, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Schema updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Schema) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a Schema.
     *
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a Schema.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Schema's certificate
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a Schema.
     *
     * @param qualifiedName of the Schema
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Schema updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a Schema.
     *
     * @param client connectivity to the Atlan tenant on which to update the Schema's announcement
     * @param qualifiedName of the Schema
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Schema updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Schema) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a Schema.
     *
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a Schema.
     *
     * @param client connectivity to the Atlan client from which to remove the Schema's announcement
     * @param qualifiedName of the Schema
     * @param name of the Schema
     * @return the updated Schema, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Schema removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the Schema.
     *
     * @param qualifiedName for the Schema
     * @param name human-readable name of the Schema
     * @param terms the list of terms to replace on the Schema, or null to remove all terms from the Schema
     * @return the Schema that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Schema replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the Schema.
     *
     * @param client connectivity to the Atlan tenant on which to replace the Schema's assigned terms
     * @param qualifiedName for the Schema
     * @param name human-readable name of the Schema
     * @param terms the list of terms to replace on the Schema, or null to remove all terms from the Schema
     * @return the Schema that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Schema replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Schema) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the Schema, without replacing existing terms linked to the Schema.
     * Note: this operation must make two API calls — one to retrieve the Schema's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the Schema
     * @param terms the list of terms to append to the Schema
     * @return the Schema that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Schema appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the Schema, without replacing existing terms linked to the Schema.
     * Note: this operation must make two API calls — one to retrieve the Schema's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the Schema
     * @param qualifiedName for the Schema
     * @param terms the list of terms to append to the Schema
     * @return the Schema that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Schema appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Schema) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a Schema, without replacing all existing terms linked to the Schema.
     * Note: this operation must make two API calls — one to retrieve the Schema's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the Schema
     * @param terms the list of terms to remove from the Schema, which must be referenced by GUID
     * @return the Schema that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Schema removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a Schema, without replacing all existing terms linked to the Schema.
     * Note: this operation must make two API calls — one to retrieve the Schema's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the Schema
     * @param qualifiedName for the Schema
     * @param terms the list of terms to remove from the Schema, which must be referenced by GUID
     * @return the Schema that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Schema removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Schema) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a Schema, without replacing existing Atlan tags linked to the Schema.
     * Note: this operation must make two API calls — one to retrieve the Schema's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Schema
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Schema
     */
    public static Schema appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Schema, without replacing existing Atlan tags linked to the Schema.
     * Note: this operation must make two API calls — one to retrieve the Schema's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Schema
     * @param qualifiedName of the Schema
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Schema
     */
    public static Schema appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Schema) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Schema, without replacing existing Atlan tags linked to the Schema.
     * Note: this operation must make two API calls — one to retrieve the Schema's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Schema
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Schema
     */
    public static Schema appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Schema, without replacing existing Atlan tags linked to the Schema.
     * Note: this operation must make two API calls — one to retrieve the Schema's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Schema
     * @param qualifiedName of the Schema
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Schema
     */
    public static Schema appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Schema) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Schema.
     *
     * @param qualifiedName of the Schema
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Schema
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Schema.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Schema
     * @param qualifiedName of the Schema
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Schema
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SchemaBuilder<C extends Schema, B extends Schema.SchemaBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String calculationViewQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ICalculationView> calculationViews;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDatabase database;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String databaseQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> dbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> dbtSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtTest> dbtTests;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IFunction> functions;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isProfiled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long lastProfiledAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String linkedSchemaQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IMaterializedView> materializedViews;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IProcedure> procedures;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryCountUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long queryUserCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> queryUserMap$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Long> queryUserMap$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISnowflakeDynamicTable> snowflakeDynamicTables;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISnowflakePipe> snowflakePipes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISnowflakeStream> snowflakeStreams;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISnowflakeTag> snowflakeTags;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtSource> sqlDBTSources;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IDbtModel> sqlDbtModels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer tableCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tableQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ITable> tables;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer viewCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String viewQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IView> views;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Schema.SchemaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Schema instance, final Schema.SchemaBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.calculationViews(instance.calculationViews == null ? java.util.Collections.<ICalculationView>emptySortedSet() : instance.calculationViews);
            b.database(instance.database);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? java.util.Collections.<IDbtTest>emptySortedSet() : instance.dbtTests);
            b.functions(instance.functions == null ? java.util.Collections.<IFunction>emptySortedSet() : instance.functions);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.isProfiled(instance.isProfiled);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.linkedSchemaQualifiedName(instance.linkedSchemaQualifiedName);
            b.materializedViews(instance.materializedViews == null ? java.util.Collections.<IMaterializedView>emptySortedSet() : instance.materializedViews);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.procedures(instance.procedures == null ? java.util.Collections.<IProcedure>emptySortedSet() : instance.procedures);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? java.util.Collections.<String, Long>emptyMap() : instance.queryUserMap);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.snowflakeDynamicTables(instance.snowflakeDynamicTables == null ? java.util.Collections.<ISnowflakeDynamicTable>emptySortedSet() : instance.snowflakeDynamicTables);
            b.snowflakePipes(instance.snowflakePipes == null ? java.util.Collections.<ISnowflakePipe>emptySortedSet() : instance.snowflakePipes);
            b.snowflakeStreams(instance.snowflakeStreams == null ? java.util.Collections.<ISnowflakeStream>emptySortedSet() : instance.snowflakeStreams);
            b.snowflakeTags(instance.snowflakeTags == null ? java.util.Collections.<ISnowflakeTag>emptySortedSet() : instance.snowflakeTags);
            b.sqlDBTSources(instance.sqlDBTSources == null ? java.util.Collections.<IDbtSource>emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? java.util.Collections.<IDbtModel>emptySortedSet() : instance.sqlDbtModels);
            b.tableCount(instance.tableCount);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.tables(instance.tables == null ? java.util.Collections.<ITable>emptySortedSet() : instance.tables);
            b.viewCount(instance.viewCount);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
            b.views(instance.views == null ? java.util.Collections.<IView>emptySortedSet() : instance.views);
        }

        /**
         * Fixed typeName for Schemas.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewName(final String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return self();
        }

        /**
         * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViewQualifiedName(final String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationView(final ICalculationView calculationView) {
            if (this.calculationViews == null) this.calculationViews = new java.util.ArrayList<ICalculationView>();
            this.calculationViews.add(calculationView);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B calculationViews(final java.util.Collection<? extends ICalculationView> calculationViews) {
            if (calculationViews == null) {
                throw new java.lang.NullPointerException("calculationViews cannot be null");
            }
            if (this.calculationViews == null) this.calculationViews = new java.util.ArrayList<ICalculationView>();
            this.calculationViews.addAll(calculationViews);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearCalculationViews() {
            if (this.calculationViews != null) this.calculationViews.clear();
            return self();
        }

        /**
         * Database in which this schema exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B database(final IDatabase database) {
            this.database = database;
            return self();
        }

        /**
         * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseName(final String databaseName) {
            this.databaseName = databaseName;
            return self();
        }

        /**
         * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B databaseQualifiedName(final String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModel(final IDbtModel dbtModel) {
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.add(dbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtModels(final java.util.Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new java.lang.NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) this.dbtModels = new java.util.ArrayList<IDbtModel>();
            this.dbtModels.addAll(dbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) this.dbtModels.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSource(final IDbtSource dbtSource) {
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.add(dbtSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtSources(final java.util.Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new java.lang.NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) this.dbtSources = new java.util.ArrayList<IDbtSource>();
            this.dbtSources.addAll(dbtSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) this.dbtSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTest(final IDbtTest dbtTest) {
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.add(dbtTest);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dbtTests(final java.util.Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new java.lang.NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) this.dbtTests = new java.util.ArrayList<IDbtTest>();
            this.dbtTests.addAll(dbtTests);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) this.dbtTests.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B function(final IFunction function) {
            if (this.functions == null) this.functions = new java.util.ArrayList<IFunction>();
            this.functions.add(function);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B functions(final java.util.Collection<? extends IFunction> functions) {
            if (functions == null) {
                throw new java.lang.NullPointerException("functions cannot be null");
            }
            if (this.functions == null) this.functions = new java.util.ArrayList<IFunction>();
            this.functions.addAll(functions);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearFunctions() {
            if (this.functions != null) this.functions.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        /**
         * Whether this asset has been profiled (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isProfiled(final Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return self();
        }

        /**
         * Time (epoch) at which this asset was last profiled, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B lastProfiledAt(final Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return self();
        }

        /**
         * Unique name of the Linked Schema on which this Schema is dependent. This concept is mostly applicable for linked datasets/datasource in Google BigQuery via Analytics Hub Listing
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B linkedSchemaQualifiedName(final String linkedSchemaQualifiedName) {
            this.linkedSchemaQualifiedName = linkedSchemaQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B materializedView(final IMaterializedView materializedView) {
            if (this.materializedViews == null) this.materializedViews = new java.util.ArrayList<IMaterializedView>();
            this.materializedViews.add(materializedView);
            return self();
        }

        @JsonProperty("materialisedViews")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B materializedViews(final java.util.Collection<? extends IMaterializedView> materializedViews) {
            if (materializedViews == null) {
                throw new java.lang.NullPointerException("materializedViews cannot be null");
            }
            if (this.materializedViews == null) this.materializedViews = new java.util.ArrayList<IMaterializedView>();
            this.materializedViews.addAll(materializedViews);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearMaterializedViews() {
            if (this.materializedViews != null) this.materializedViews.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B procedure(final IProcedure procedure) {
            if (this.procedures == null) this.procedures = new java.util.ArrayList<IProcedure>();
            this.procedures.add(procedure);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B procedures(final java.util.Collection<? extends IProcedure> procedures) {
            if (procedures == null) {
                throw new java.lang.NullPointerException("procedures cannot be null");
            }
            if (this.procedures == null) this.procedures = new java.util.ArrayList<IProcedure>();
            this.procedures.addAll(procedures);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearProcedures() {
            if (this.procedures != null) this.procedures.clear();
            return self();
        }

        /**
         * Number of times this asset has been queried.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCount(final Long queryCount) {
            this.queryCount = queryCount;
            return self();
        }

        /**
         * Time (epoch) at which the query count was last updated, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryCountUpdatedAt(final Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return self();
        }

        /**
         * Number of unique users who have queried this asset.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserCount(final Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B putQueryUserMap(final String putQueryUserMapKey, final Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B queryUserMap(final java.util.Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new java.lang.NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new java.util.ArrayList<String>();
                this.queryUserMap$value = new java.util.ArrayList<Long>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return self();
        }

        /**
         * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaName(final String schemaName) {
            this.schemaName = schemaName;
            return self();
        }

        /**
         * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaQualifiedName(final String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakeDynamicTable(final ISnowflakeDynamicTable snowflakeDynamicTable) {
            if (this.snowflakeDynamicTables == null) this.snowflakeDynamicTables = new java.util.ArrayList<ISnowflakeDynamicTable>();
            this.snowflakeDynamicTables.add(snowflakeDynamicTable);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakeDynamicTables(final java.util.Collection<? extends ISnowflakeDynamicTable> snowflakeDynamicTables) {
            if (snowflakeDynamicTables == null) {
                throw new java.lang.NullPointerException("snowflakeDynamicTables cannot be null");
            }
            if (this.snowflakeDynamicTables == null) this.snowflakeDynamicTables = new java.util.ArrayList<ISnowflakeDynamicTable>();
            this.snowflakeDynamicTables.addAll(snowflakeDynamicTables);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSnowflakeDynamicTables() {
            if (this.snowflakeDynamicTables != null) this.snowflakeDynamicTables.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakePipe(final ISnowflakePipe snowflakePipe) {
            if (this.snowflakePipes == null) this.snowflakePipes = new java.util.ArrayList<ISnowflakePipe>();
            this.snowflakePipes.add(snowflakePipe);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakePipes(final java.util.Collection<? extends ISnowflakePipe> snowflakePipes) {
            if (snowflakePipes == null) {
                throw new java.lang.NullPointerException("snowflakePipes cannot be null");
            }
            if (this.snowflakePipes == null) this.snowflakePipes = new java.util.ArrayList<ISnowflakePipe>();
            this.snowflakePipes.addAll(snowflakePipes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSnowflakePipes() {
            if (this.snowflakePipes != null) this.snowflakePipes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakeStream(final ISnowflakeStream snowflakeStream) {
            if (this.snowflakeStreams == null) this.snowflakeStreams = new java.util.ArrayList<ISnowflakeStream>();
            this.snowflakeStreams.add(snowflakeStream);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakeStreams(final java.util.Collection<? extends ISnowflakeStream> snowflakeStreams) {
            if (snowflakeStreams == null) {
                throw new java.lang.NullPointerException("snowflakeStreams cannot be null");
            }
            if (this.snowflakeStreams == null) this.snowflakeStreams = new java.util.ArrayList<ISnowflakeStream>();
            this.snowflakeStreams.addAll(snowflakeStreams);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSnowflakeStreams() {
            if (this.snowflakeStreams != null) this.snowflakeStreams.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakeTag(final ISnowflakeTag snowflakeTag) {
            if (this.snowflakeTags == null) this.snowflakeTags = new java.util.ArrayList<ISnowflakeTag>();
            this.snowflakeTags.add(snowflakeTag);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B snowflakeTags(final java.util.Collection<? extends ISnowflakeTag> snowflakeTags) {
            if (snowflakeTags == null) {
                throw new java.lang.NullPointerException("snowflakeTags cannot be null");
            }
            if (this.snowflakeTags == null) this.snowflakeTags = new java.util.ArrayList<ISnowflakeTag>();
            this.snowflakeTags.addAll(snowflakeTags);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSnowflakeTags() {
            if (this.snowflakeTags != null) this.snowflakeTags.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSource(final IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.add(sqlDBTSource);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDBTSources(final java.util.Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new java.lang.NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) this.sqlDBTSources = new java.util.ArrayList<IDbtSource>();
            this.sqlDBTSources.addAll(sqlDBTSources);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) this.sqlDBTSources.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModel(final IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.add(sqlDbtModel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sqlDbtModels(final java.util.Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new java.lang.NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) this.sqlDbtModels = new java.util.ArrayList<IDbtModel>();
            this.sqlDbtModels.addAll(sqlDbtModels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) this.sqlDbtModels.clear();
            return self();
        }

        /**
         * Number of tables in this schema.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableCount(final Integer tableCount) {
            this.tableCount = tableCount;
            return self();
        }

        /**
         * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableName(final String tableName) {
            this.tableName = tableName;
            return self();
        }

        /**
         * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tableQualifiedName(final String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B table(final ITable table) {
            if (this.tables == null) this.tables = new java.util.ArrayList<ITable>();
            this.tables.add(table);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B tables(final java.util.Collection<? extends ITable> tables) {
            if (tables == null) {
                throw new java.lang.NullPointerException("tables cannot be null");
            }
            if (this.tables == null) this.tables = new java.util.ArrayList<ITable>();
            this.tables.addAll(tables);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearTables() {
            if (this.tables != null) this.tables.clear();
            return self();
        }

        /**
         * Number of views in this schema.
         * @return {@code this}.
         */
        @JsonProperty("viewsCount")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewCount(final Integer viewCount) {
            this.viewCount = viewCount;
            return self();
        }

        /**
         * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewName(final String viewName) {
            this.viewName = viewName;
            return self();
        }

        /**
         * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B viewQualifiedName(final String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B view(final IView view) {
            if (this.views == null) this.views = new java.util.ArrayList<IView>();
            this.views.add(view);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B views(final java.util.Collection<? extends IView> views) {
            if (views == null) {
                throw new java.lang.NullPointerException("views cannot be null");
            }
            if (this.views == null) this.views = new java.util.ArrayList<IView>();
            this.views.addAll(views);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearViews() {
            if (this.views != null) this.views.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Schema.SchemaBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", calculationViews=" + this.calculationViews + ", database=" + this.database + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", functions=" + this.functions + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isProfiled=" + this.isProfiled + ", lastProfiledAt=" + this.lastProfiledAt + ", linkedSchemaQualifiedName=" + this.linkedSchemaQualifiedName + ", materializedViews=" + this.materializedViews + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", procedures=" + this.procedures + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", snowflakeDynamicTables=" + this.snowflakeDynamicTables + ", snowflakePipes=" + this.snowflakePipes + ", snowflakeStreams=" + this.snowflakeStreams + ", snowflakeTags=" + this.snowflakeTags + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", tableCount=" + this.tableCount + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", tables=" + this.tables + ", viewCount=" + this.viewCount + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ", views=" + this.views + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SchemaBuilderImpl extends Schema.SchemaBuilder<Schema, Schema.SchemaBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SchemaBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Schema.SchemaBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Schema build() {
            return new Schema(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Schema(final Schema.SchemaBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Schema.$default$typeName();
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        java.util.SortedSet<ICalculationView> calculationViews = new java.util.TreeSet<ICalculationView>();
        if (b.calculationViews != null) calculationViews.addAll(b.calculationViews);
        calculationViews = java.util.Collections.unmodifiableSortedSet(calculationViews);
        this.calculationViews = calculationViews;
        this.database = b.database;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        java.util.SortedSet<IDbtModel> dbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.dbtModels != null) dbtModels.addAll(b.dbtModels);
        dbtModels = java.util.Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        java.util.SortedSet<IDbtSource> dbtSources = new java.util.TreeSet<IDbtSource>();
        if (b.dbtSources != null) dbtSources.addAll(b.dbtSources);
        dbtSources = java.util.Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        java.util.SortedSet<IDbtTest> dbtTests = new java.util.TreeSet<IDbtTest>();
        if (b.dbtTests != null) dbtTests.addAll(b.dbtTests);
        dbtTests = java.util.Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        java.util.SortedSet<IFunction> functions = new java.util.TreeSet<IFunction>();
        if (b.functions != null) functions.addAll(b.functions);
        functions = java.util.Collections.unmodifiableSortedSet(functions);
        this.functions = functions;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isProfiled = b.isProfiled;
        this.lastProfiledAt = b.lastProfiledAt;
        this.linkedSchemaQualifiedName = b.linkedSchemaQualifiedName;
        java.util.SortedSet<IMaterializedView> materializedViews = new java.util.TreeSet<IMaterializedView>();
        if (b.materializedViews != null) materializedViews.addAll(b.materializedViews);
        materializedViews = java.util.Collections.unmodifiableSortedSet(materializedViews);
        this.materializedViews = materializedViews;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<IProcedure> procedures = new java.util.TreeSet<IProcedure>();
        if (b.procedures != null) procedures.addAll(b.procedures);
        procedures = java.util.Collections.unmodifiableSortedSet(procedures);
        this.procedures = procedures;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        this.queryUserCount = b.queryUserCount;
        java.util.Map<String, Long> queryUserMap;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
        case 0: 
            queryUserMap = java.util.Collections.emptyMap();
            break;
        case 1: 
            queryUserMap = java.util.Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
            break;
        default: 
            queryUserMap = new java.util.LinkedHashMap<String, Long>(b.queryUserMap$key.size() < 1073741824 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.queryUserMap$key.size(); $i++) queryUserMap.put(b.queryUserMap$key.get($i), (Long) b.queryUserMap$value.get($i));
            queryUserMap = java.util.Collections.unmodifiableMap(queryUserMap);
        }
        this.queryUserMap = queryUserMap;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        java.util.SortedSet<ISnowflakeDynamicTable> snowflakeDynamicTables = new java.util.TreeSet<ISnowflakeDynamicTable>();
        if (b.snowflakeDynamicTables != null) snowflakeDynamicTables.addAll(b.snowflakeDynamicTables);
        snowflakeDynamicTables = java.util.Collections.unmodifiableSortedSet(snowflakeDynamicTables);
        this.snowflakeDynamicTables = snowflakeDynamicTables;
        java.util.SortedSet<ISnowflakePipe> snowflakePipes = new java.util.TreeSet<ISnowflakePipe>();
        if (b.snowflakePipes != null) snowflakePipes.addAll(b.snowflakePipes);
        snowflakePipes = java.util.Collections.unmodifiableSortedSet(snowflakePipes);
        this.snowflakePipes = snowflakePipes;
        java.util.SortedSet<ISnowflakeStream> snowflakeStreams = new java.util.TreeSet<ISnowflakeStream>();
        if (b.snowflakeStreams != null) snowflakeStreams.addAll(b.snowflakeStreams);
        snowflakeStreams = java.util.Collections.unmodifiableSortedSet(snowflakeStreams);
        this.snowflakeStreams = snowflakeStreams;
        java.util.SortedSet<ISnowflakeTag> snowflakeTags = new java.util.TreeSet<ISnowflakeTag>();
        if (b.snowflakeTags != null) snowflakeTags.addAll(b.snowflakeTags);
        snowflakeTags = java.util.Collections.unmodifiableSortedSet(snowflakeTags);
        this.snowflakeTags = snowflakeTags;
        java.util.SortedSet<IDbtSource> sqlDBTSources = new java.util.TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) sqlDBTSources.addAll(b.sqlDBTSources);
        sqlDBTSources = java.util.Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        java.util.SortedSet<IDbtModel> sqlDbtModels = new java.util.TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) sqlDbtModels.addAll(b.sqlDbtModels);
        sqlDbtModels = java.util.Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableCount = b.tableCount;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        java.util.SortedSet<ITable> tables = new java.util.TreeSet<ITable>();
        if (b.tables != null) tables.addAll(b.tables);
        tables = java.util.Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        this.viewCount = b.viewCount;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
        java.util.SortedSet<IView> views = new java.util.TreeSet<IView>();
        if (b.views != null) views.addAll(b.views);
        views = java.util.Collections.unmodifiableSortedSet(views);
        this.views = views;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Schema.SchemaBuilder<?, ?> _internal() {
        return new Schema.SchemaBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Schema.SchemaBuilder<?, ?> toBuilder() {
        return new Schema.SchemaBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Simple name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    /**
     * Unique name of the calculation view in which this SQL asset exists, or empty if it does not exist within a calculation view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ICalculationView> getCalculationViews() {
        return this.calculationViews;
    }

    /**
     * Database in which this schema exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDatabase getDatabase() {
        return this.database;
    }

    /**
     * Simple name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * Unique name of the database in which this SQL asset exists, or empty if it does not exist within a database.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    /**
     * Functions that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IFunction> getFunctions() {
        return this.functions;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Whether this asset has been profiled (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    /**
     * Time (epoch) at which this asset was last profiled, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    /**
     * Unique name of the Linked Schema on which this Schema is dependent. This concept is mostly applicable for linked datasets/datasource in Google BigQuery via Analytics Hub Listing
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLinkedSchemaQualifiedName() {
        return this.linkedSchemaQualifiedName;
    }

    /**
     * Materialized views that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IMaterializedView> getMaterializedViews() {
        return this.materializedViews;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Stored procedures that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IProcedure> getProcedures() {
        return this.procedures;
    }

    /**
     * Number of times this asset has been queried.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    /**
     * Time (epoch) at which the query count was last updated, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    /**
     * Number of unique users who have queried this asset.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    /**
     * Map of unique users who have queried this asset to the number of times they have queried it.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    /**
     * Simple name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    /**
     * Unique name of the schema in which this SQL asset exists, or empty if it does not exist within a schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    /**
     * Snowflake dynamic tables that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISnowflakeDynamicTable> getSnowflakeDynamicTables() {
        return this.snowflakeDynamicTables;
    }

    /**
     * Snowflake pipes that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISnowflakePipe> getSnowflakePipes() {
        return this.snowflakePipes;
    }

    /**
     * Snowflake streams that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISnowflakeStream> getSnowflakeStreams() {
        return this.snowflakeStreams;
    }

    /**
     * Snowflake tags that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISnowflakeTag> getSnowflakeTags() {
        return this.snowflakeTags;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    /**
     * Number of tables in this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getTableCount() {
        return this.tableCount;
    }

    /**
     * Simple name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableName() {
        return this.tableName;
    }

    /**
     * Unique name of the table in which this SQL asset exists, or empty if it does not exist within a table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    /**
     * Tables that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ITable> getTables() {
        return this.tables;
    }

    /**
     * Number of views in this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getViewCount() {
        return this.viewCount;
    }

    /**
     * Simple name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewName() {
        return this.viewName;
    }

    /**
     * Unique name of the view in which this SQL asset exists, or empty if it does not exist within a view.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    /**
     * Views that exist within this schema.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IView> getViews() {
        return this.views;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Schema)) return false;
        final Schema other = (Schema) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isProfiled = this.getIsProfiled();
        final java.lang.Object other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !this$isProfiled.equals(other$isProfiled)) return false;
        final java.lang.Object this$lastProfiledAt = this.getLastProfiledAt();
        final java.lang.Object other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !this$lastProfiledAt.equals(other$lastProfiledAt)) return false;
        final java.lang.Object this$queryCount = this.getQueryCount();
        final java.lang.Object other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !this$queryCount.equals(other$queryCount)) return false;
        final java.lang.Object this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        final java.lang.Object other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !this$queryCountUpdatedAt.equals(other$queryCountUpdatedAt)) return false;
        final java.lang.Object this$queryUserCount = this.getQueryUserCount();
        final java.lang.Object other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !this$queryUserCount.equals(other$queryUserCount)) return false;
        final java.lang.Object this$tableCount = this.getTableCount();
        final java.lang.Object other$tableCount = other.getTableCount();
        if (this$tableCount == null ? other$tableCount != null : !this$tableCount.equals(other$tableCount)) return false;
        final java.lang.Object this$viewCount = this.getViewCount();
        final java.lang.Object other$viewCount = other.getViewCount();
        if (this$viewCount == null ? other$viewCount != null : !this$viewCount.equals(other$viewCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$calculationViewName = this.getCalculationViewName();
        final java.lang.Object other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) return false;
        final java.lang.Object this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        final java.lang.Object other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) return false;
        final java.lang.Object this$calculationViews = this.getCalculationViews();
        final java.lang.Object other$calculationViews = other.getCalculationViews();
        if (this$calculationViews == null ? other$calculationViews != null : !this$calculationViews.equals(other$calculationViews)) return false;
        final java.lang.Object this$database = this.getDatabase();
        final java.lang.Object other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) return false;
        final java.lang.Object this$databaseName = this.getDatabaseName();
        final java.lang.Object other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) return false;
        final java.lang.Object this$databaseQualifiedName = this.getDatabaseQualifiedName();
        final java.lang.Object other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) return false;
        final java.lang.Object this$dbtModels = this.getDbtModels();
        final java.lang.Object other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) return false;
        final java.lang.Object this$dbtSources = this.getDbtSources();
        final java.lang.Object other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) return false;
        final java.lang.Object this$dbtTests = this.getDbtTests();
        final java.lang.Object other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) return false;
        final java.lang.Object this$functions = this.getFunctions();
        final java.lang.Object other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !this$functions.equals(other$functions)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$linkedSchemaQualifiedName = this.getLinkedSchemaQualifiedName();
        final java.lang.Object other$linkedSchemaQualifiedName = other.getLinkedSchemaQualifiedName();
        if (this$linkedSchemaQualifiedName == null ? other$linkedSchemaQualifiedName != null : !this$linkedSchemaQualifiedName.equals(other$linkedSchemaQualifiedName)) return false;
        final java.lang.Object this$materializedViews = this.getMaterializedViews();
        final java.lang.Object other$materializedViews = other.getMaterializedViews();
        if (this$materializedViews == null ? other$materializedViews != null : !this$materializedViews.equals(other$materializedViews)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$procedures = this.getProcedures();
        final java.lang.Object other$procedures = other.getProcedures();
        if (this$procedures == null ? other$procedures != null : !this$procedures.equals(other$procedures)) return false;
        final java.lang.Object this$queryUserMap = this.getQueryUserMap();
        final java.lang.Object other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !this$queryUserMap.equals(other$queryUserMap)) return false;
        final java.lang.Object this$schemaName = this.getSchemaName();
        final java.lang.Object other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) return false;
        final java.lang.Object this$schemaQualifiedName = this.getSchemaQualifiedName();
        final java.lang.Object other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) return false;
        final java.lang.Object this$snowflakeDynamicTables = this.getSnowflakeDynamicTables();
        final java.lang.Object other$snowflakeDynamicTables = other.getSnowflakeDynamicTables();
        if (this$snowflakeDynamicTables == null ? other$snowflakeDynamicTables != null : !this$snowflakeDynamicTables.equals(other$snowflakeDynamicTables)) return false;
        final java.lang.Object this$snowflakePipes = this.getSnowflakePipes();
        final java.lang.Object other$snowflakePipes = other.getSnowflakePipes();
        if (this$snowflakePipes == null ? other$snowflakePipes != null : !this$snowflakePipes.equals(other$snowflakePipes)) return false;
        final java.lang.Object this$snowflakeStreams = this.getSnowflakeStreams();
        final java.lang.Object other$snowflakeStreams = other.getSnowflakeStreams();
        if (this$snowflakeStreams == null ? other$snowflakeStreams != null : !this$snowflakeStreams.equals(other$snowflakeStreams)) return false;
        final java.lang.Object this$snowflakeTags = this.getSnowflakeTags();
        final java.lang.Object other$snowflakeTags = other.getSnowflakeTags();
        if (this$snowflakeTags == null ? other$snowflakeTags != null : !this$snowflakeTags.equals(other$snowflakeTags)) return false;
        final java.lang.Object this$sqlDBTSources = this.getSqlDBTSources();
        final java.lang.Object other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) return false;
        final java.lang.Object this$sqlDbtModels = this.getSqlDbtModels();
        final java.lang.Object other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) return false;
        final java.lang.Object this$tableName = this.getTableName();
        final java.lang.Object other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) return false;
        final java.lang.Object this$tableQualifiedName = this.getTableQualifiedName();
        final java.lang.Object other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) return false;
        final java.lang.Object this$tables = this.getTables();
        final java.lang.Object other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) return false;
        final java.lang.Object this$viewName = this.getViewName();
        final java.lang.Object other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) return false;
        final java.lang.Object this$viewQualifiedName = this.getViewQualifiedName();
        final java.lang.Object other$viewQualifiedName = other.getViewQualifiedName();
        if (this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName)) return false;
        final java.lang.Object this$views = this.getViews();
        final java.lang.Object other$views = other.getViews();
        if (this$views == null ? other$views != null : !this$views.equals(other$views)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Schema;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isProfiled = this.getIsProfiled();
        result = result * PRIME + ($isProfiled == null ? 43 : $isProfiled.hashCode());
        final java.lang.Object $lastProfiledAt = this.getLastProfiledAt();
        result = result * PRIME + ($lastProfiledAt == null ? 43 : $lastProfiledAt.hashCode());
        final java.lang.Object $queryCount = this.getQueryCount();
        result = result * PRIME + ($queryCount == null ? 43 : $queryCount.hashCode());
        final java.lang.Object $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * PRIME + ($queryCountUpdatedAt == null ? 43 : $queryCountUpdatedAt.hashCode());
        final java.lang.Object $queryUserCount = this.getQueryUserCount();
        result = result * PRIME + ($queryUserCount == null ? 43 : $queryUserCount.hashCode());
        final java.lang.Object $tableCount = this.getTableCount();
        result = result * PRIME + ($tableCount == null ? 43 : $tableCount.hashCode());
        final java.lang.Object $viewCount = this.getViewCount();
        result = result * PRIME + ($viewCount == null ? 43 : $viewCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $calculationViewName = this.getCalculationViewName();
        result = result * PRIME + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        final java.lang.Object $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * PRIME + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        final java.lang.Object $calculationViews = this.getCalculationViews();
        result = result * PRIME + ($calculationViews == null ? 43 : $calculationViews.hashCode());
        final java.lang.Object $database = this.getDatabase();
        result = result * PRIME + ($database == null ? 43 : $database.hashCode());
        final java.lang.Object $databaseName = this.getDatabaseName();
        result = result * PRIME + ($databaseName == null ? 43 : $databaseName.hashCode());
        final java.lang.Object $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * PRIME + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        final java.lang.Object $dbtModels = this.getDbtModels();
        result = result * PRIME + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        final java.lang.Object $dbtSources = this.getDbtSources();
        result = result * PRIME + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        final java.lang.Object $dbtTests = this.getDbtTests();
        result = result * PRIME + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        final java.lang.Object $functions = this.getFunctions();
        result = result * PRIME + ($functions == null ? 43 : $functions.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $linkedSchemaQualifiedName = this.getLinkedSchemaQualifiedName();
        result = result * PRIME + ($linkedSchemaQualifiedName == null ? 43 : $linkedSchemaQualifiedName.hashCode());
        final java.lang.Object $materializedViews = this.getMaterializedViews();
        result = result * PRIME + ($materializedViews == null ? 43 : $materializedViews.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $procedures = this.getProcedures();
        result = result * PRIME + ($procedures == null ? 43 : $procedures.hashCode());
        final java.lang.Object $queryUserMap = this.getQueryUserMap();
        result = result * PRIME + ($queryUserMap == null ? 43 : $queryUserMap.hashCode());
        final java.lang.Object $schemaName = this.getSchemaName();
        result = result * PRIME + ($schemaName == null ? 43 : $schemaName.hashCode());
        final java.lang.Object $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * PRIME + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        final java.lang.Object $snowflakeDynamicTables = this.getSnowflakeDynamicTables();
        result = result * PRIME + ($snowflakeDynamicTables == null ? 43 : $snowflakeDynamicTables.hashCode());
        final java.lang.Object $snowflakePipes = this.getSnowflakePipes();
        result = result * PRIME + ($snowflakePipes == null ? 43 : $snowflakePipes.hashCode());
        final java.lang.Object $snowflakeStreams = this.getSnowflakeStreams();
        result = result * PRIME + ($snowflakeStreams == null ? 43 : $snowflakeStreams.hashCode());
        final java.lang.Object $snowflakeTags = this.getSnowflakeTags();
        result = result * PRIME + ($snowflakeTags == null ? 43 : $snowflakeTags.hashCode());
        final java.lang.Object $sqlDBTSources = this.getSqlDBTSources();
        result = result * PRIME + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        final java.lang.Object $sqlDbtModels = this.getSqlDbtModels();
        result = result * PRIME + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        final java.lang.Object $tableName = this.getTableName();
        result = result * PRIME + ($tableName == null ? 43 : $tableName.hashCode());
        final java.lang.Object $tableQualifiedName = this.getTableQualifiedName();
        result = result * PRIME + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        final java.lang.Object $tables = this.getTables();
        result = result * PRIME + ($tables == null ? 43 : $tables.hashCode());
        final java.lang.Object $viewName = this.getViewName();
        result = result * PRIME + ($viewName == null ? 43 : $viewName.hashCode());
        final java.lang.Object $viewQualifiedName = this.getViewQualifiedName();
        result = result * PRIME + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        final java.lang.Object $views = this.getViews();
        result = result * PRIME + ($views == null ? 43 : $views.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Schema(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", calculationViews=" + this.getCalculationViews() + ", database=" + this.getDatabase() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", functions=" + this.getFunctions() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isProfiled=" + this.getIsProfiled() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", linkedSchemaQualifiedName=" + this.getLinkedSchemaQualifiedName() + ", materializedViews=" + this.getMaterializedViews() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", procedures=" + this.getProcedures() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", snowflakeDynamicTables=" + this.getSnowflakeDynamicTables() + ", snowflakePipes=" + this.getSnowflakePipes() + ", snowflakeStreams=" + this.getSnowflakeStreams() + ", snowflakeTags=" + this.getSnowflakeTags() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", tableCount=" + this.getTableCount() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", tables=" + this.getTables() + ", viewCount=" + this.getViewCount() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ", views=" + this.getViews() + ")";
    }

    /**
     * Fixed typeName for Schemas.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
