// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.SchemaRegistrySchemaCompatibility;
import com.atlan.model.enums.SchemaRegistrySchemaType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a schema registry subject in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SchemaRegistrySubject extends Asset implements ISchemaRegistrySubject, ISchemaRegistry, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SchemaRegistrySubject.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SchemaRegistrySubject";
    /**
     * Fixed typeName for SchemaRegistrySubjects.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAsset> assets;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Unique identifier for schema definition set by the schema registry.
     */
    @Attribute
    String schemaRegistrySchemaId;
    /**
     * Type of language or specification used to define the schema, for example: JSON, Protobuf, etc.
     */
    @Attribute
    SchemaRegistrySchemaType schemaRegistrySchemaType;
    /**
     * Base name of the subject, without -key, -value prefixes.
     */
    @Attribute
    String schemaRegistrySubjectBaseName;
    /**
     * List of asset qualified names that this subject is governing/validating.
     */
    @Attribute
    SortedSet<String> schemaRegistrySubjectGoverningAssetQualifiedNames;
    /**
     * Whether the subject is a schema for the keys of the messages (true) or not (false).
     */
    @Attribute
    Boolean schemaRegistrySubjectIsKeySchema;
    /**
     * Definition of the latest schema in the subject.
     */
    @Attribute
    String schemaRegistrySubjectLatestSchemaDefinition;
    /**
     * Latest schema version of the subject.
     */
    @Attribute
    String schemaRegistrySubjectLatestSchemaVersion;
    /**
     * Compatibility of the schema across versions.
     */
    @Attribute
    SchemaRegistrySchemaCompatibility schemaRegistrySubjectSchemaCompatibility;

    /**
     * Builds the minimal object necessary to create a relationship to a SchemaRegistrySubject, from a potentially
     * more-complete SchemaRegistrySubject object.
     *
     * @return the minimal object necessary to relate to the SchemaRegistrySubject
     * @throws InvalidRequestException if any of the minimal set of required properties for a SchemaRegistrySubject relationship are not found in the initial object
     */
    @Override
    public SchemaRegistrySubject trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SchemaRegistrySubject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SchemaRegistrySubject assets will be included.
     *
     * @return a fluent search that includes all SchemaRegistrySubject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SchemaRegistrySubject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SchemaRegistrySubject assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SchemaRegistrySubject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SchemaRegistrySubject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SchemaRegistrySubjects will be included
     * @return a fluent search that includes all SchemaRegistrySubject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SchemaRegistrySubject assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SchemaRegistrySubjects will be included
     * @return a fluent search that includes all SchemaRegistrySubject assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SchemaRegistrySubject by GUID. Use this to create a relationship to this SchemaRegistrySubject,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SchemaRegistrySubject to reference
     * @return reference to a SchemaRegistrySubject that can be used for defining a relationship to a SchemaRegistrySubject
     */
    public static SchemaRegistrySubject refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SchemaRegistrySubject by GUID. Use this to create a relationship to this SchemaRegistrySubject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SchemaRegistrySubject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SchemaRegistrySubject that can be used for defining a relationship to a SchemaRegistrySubject
     */
    public static SchemaRegistrySubject refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SchemaRegistrySubject._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SchemaRegistrySubject by qualifiedName. Use this to create a relationship to this SchemaRegistrySubject,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SchemaRegistrySubject to reference
     * @return reference to a SchemaRegistrySubject that can be used for defining a relationship to a SchemaRegistrySubject
     */
    public static SchemaRegistrySubject refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SchemaRegistrySubject by qualifiedName. Use this to create a relationship to this SchemaRegistrySubject,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SchemaRegistrySubject to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SchemaRegistrySubject that can be used for defining a relationship to a SchemaRegistrySubject
     */
    public static SchemaRegistrySubject refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SchemaRegistrySubject._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SchemaRegistrySubject by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SchemaRegistrySubject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SchemaRegistrySubject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SchemaRegistrySubject does not exist or the provided GUID is not a SchemaRegistrySubject
     */
    @JsonIgnore
    public static SchemaRegistrySubject get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SchemaRegistrySubject by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SchemaRegistrySubject to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SchemaRegistrySubject, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SchemaRegistrySubject does not exist or the provided GUID is not a SchemaRegistrySubject
     */
    @JsonIgnore
    public static SchemaRegistrySubject get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SchemaRegistrySubject by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SchemaRegistrySubject to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SchemaRegistrySubject, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SchemaRegistrySubject does not exist or the provided GUID is not a SchemaRegistrySubject
     */
    @JsonIgnore
    public static SchemaRegistrySubject get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SchemaRegistrySubject) {
                return (SchemaRegistrySubject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SchemaRegistrySubject) {
                return (SchemaRegistrySubject) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SchemaRegistrySubject to active.
     *
     * @param qualifiedName for the SchemaRegistrySubject
     * @return true if the SchemaRegistrySubject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SchemaRegistrySubject to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SchemaRegistrySubject
     * @return true if the SchemaRegistrySubject is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the minimal request necessary to update the SchemaRegistrySubject, as a builder
     */
    public static SchemaRegistrySubjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return SchemaRegistrySubject._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SchemaRegistrySubject, from a potentially
     * more-complete SchemaRegistrySubject object.
     *
     * @return the minimal object necessary to update the SchemaRegistrySubject, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SchemaRegistrySubject are not found in the initial object
     */
    @Override
    public SchemaRegistrySubjectBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SchemaRegistrySubject's owners
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SchemaRegistrySubject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan tenant on which to update the SchemaRegistrySubject's certificate
     * @param qualifiedName of the SchemaRegistrySubject
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SchemaRegistrySubject, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SchemaRegistrySubject) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SchemaRegistrySubject's certificate
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan tenant on which to update the SchemaRegistrySubject's announcement
     * @param qualifiedName of the SchemaRegistrySubject
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SchemaRegistrySubject) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan client from which to remove the SchemaRegistrySubject's announcement
     * @param qualifiedName of the SchemaRegistrySubject
     * @param name of the SchemaRegistrySubject
     * @return the updated SchemaRegistrySubject, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SchemaRegistrySubject) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SchemaRegistrySubject.
     *
     * @param qualifiedName for the SchemaRegistrySubject
     * @param name human-readable name of the SchemaRegistrySubject
     * @param terms the list of terms to replace on the SchemaRegistrySubject, or null to remove all terms from the SchemaRegistrySubject
     * @return the SchemaRegistrySubject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SchemaRegistrySubject's assigned terms
     * @param qualifiedName for the SchemaRegistrySubject
     * @param name human-readable name of the SchemaRegistrySubject
     * @param terms the list of terms to replace on the SchemaRegistrySubject, or null to remove all terms from the SchemaRegistrySubject
     * @return the SchemaRegistrySubject that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SchemaRegistrySubject) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SchemaRegistrySubject, without replacing existing terms linked to the SchemaRegistrySubject.
     * Note: this operation must make two API calls — one to retrieve the SchemaRegistrySubject's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SchemaRegistrySubject
     * @param terms the list of terms to append to the SchemaRegistrySubject
     * @return the SchemaRegistrySubject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SchemaRegistrySubject, without replacing existing terms linked to the SchemaRegistrySubject.
     * Note: this operation must make two API calls — one to retrieve the SchemaRegistrySubject's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SchemaRegistrySubject
     * @param qualifiedName for the SchemaRegistrySubject
     * @param terms the list of terms to append to the SchemaRegistrySubject
     * @return the SchemaRegistrySubject that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SchemaRegistrySubject) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SchemaRegistrySubject, without replacing all existing terms linked to the SchemaRegistrySubject.
     * Note: this operation must make two API calls — one to retrieve the SchemaRegistrySubject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SchemaRegistrySubject
     * @param terms the list of terms to remove from the SchemaRegistrySubject, which must be referenced by GUID
     * @return the SchemaRegistrySubject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SchemaRegistrySubject, without replacing all existing terms linked to the SchemaRegistrySubject.
     * Note: this operation must make two API calls — one to retrieve the SchemaRegistrySubject's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SchemaRegistrySubject
     * @param qualifiedName for the SchemaRegistrySubject
     * @param terms the list of terms to remove from the SchemaRegistrySubject, which must be referenced by GUID
     * @return the SchemaRegistrySubject that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SchemaRegistrySubject removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SchemaRegistrySubject) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SchemaRegistrySubject, without replacing existing Atlan tags linked to the SchemaRegistrySubject.
     * Note: this operation must make two API calls — one to retrieve the SchemaRegistrySubject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SchemaRegistrySubject
     */
    public static SchemaRegistrySubject appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SchemaRegistrySubject, without replacing existing Atlan tags linked to the SchemaRegistrySubject.
     * Note: this operation must make two API calls — one to retrieve the SchemaRegistrySubject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SchemaRegistrySubject
     * @param qualifiedName of the SchemaRegistrySubject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SchemaRegistrySubject
     */
    public static SchemaRegistrySubject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SchemaRegistrySubject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SchemaRegistrySubject, without replacing existing Atlan tags linked to the SchemaRegistrySubject.
     * Note: this operation must make two API calls — one to retrieve the SchemaRegistrySubject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SchemaRegistrySubject
     */
    public static SchemaRegistrySubject appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SchemaRegistrySubject, without replacing existing Atlan tags linked to the SchemaRegistrySubject.
     * Note: this operation must make two API calls — one to retrieve the SchemaRegistrySubject's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SchemaRegistrySubject
     * @param qualifiedName of the SchemaRegistrySubject
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SchemaRegistrySubject
     */
    public static SchemaRegistrySubject appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SchemaRegistrySubject) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SchemaRegistrySubject.
     *
     * @param qualifiedName of the SchemaRegistrySubject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SchemaRegistrySubject
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SchemaRegistrySubject.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SchemaRegistrySubject
     * @param qualifiedName of the SchemaRegistrySubject
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SchemaRegistrySubject
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SchemaRegistrySubjectBuilder<C extends SchemaRegistrySubject, B extends SchemaRegistrySubject.SchemaRegistrySubjectBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> assets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaRegistrySchemaId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SchemaRegistrySchemaType schemaRegistrySchemaType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaRegistrySubjectBaseName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> schemaRegistrySubjectGoverningAssetQualifiedNames;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean schemaRegistrySubjectIsKeySchema;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaRegistrySubjectLatestSchemaDefinition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String schemaRegistrySubjectLatestSchemaVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SchemaRegistrySchemaCompatibility schemaRegistrySubjectSchemaCompatibility;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SchemaRegistrySubject.SchemaRegistrySubjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SchemaRegistrySubject instance, final SchemaRegistrySubject.SchemaRegistrySubjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.assets(instance.assets == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.assets);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.schemaRegistrySchemaId(instance.schemaRegistrySchemaId);
            b.schemaRegistrySchemaType(instance.schemaRegistrySchemaType);
            b.schemaRegistrySubjectBaseName(instance.schemaRegistrySubjectBaseName);
            b.schemaRegistrySubjectGoverningAssetQualifiedNames(instance.schemaRegistrySubjectGoverningAssetQualifiedNames == null ? java.util.Collections.<String>emptySortedSet() : instance.schemaRegistrySubjectGoverningAssetQualifiedNames);
            b.schemaRegistrySubjectIsKeySchema(instance.schemaRegistrySubjectIsKeySchema);
            b.schemaRegistrySubjectLatestSchemaDefinition(instance.schemaRegistrySubjectLatestSchemaDefinition);
            b.schemaRegistrySubjectLatestSchemaVersion(instance.schemaRegistrySubjectLatestSchemaVersion);
            b.schemaRegistrySubjectSchemaCompatibility(instance.schemaRegistrySubjectSchemaCompatibility);
        }

        /**
         * Fixed typeName for SchemaRegistrySubjects.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B asset(final IAsset asset) {
            if (this.assets == null) this.assets = new java.util.ArrayList<IAsset>();
            this.assets.add(asset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B assets(final java.util.Collection<? extends IAsset> assets) {
            if (assets == null) {
                throw new java.lang.NullPointerException("assets cannot be null");
            }
            if (this.assets == null) this.assets = new java.util.ArrayList<IAsset>();
            this.assets.addAll(assets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAssets() {
            if (this.assets != null) this.assets.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Unique identifier for schema definition set by the schema registry.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySchemaId(final String schemaRegistrySchemaId) {
            this.schemaRegistrySchemaId = schemaRegistrySchemaId;
            return self();
        }

        /**
         * Type of language or specification used to define the schema, for example: JSON, Protobuf, etc.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySchemaType(final SchemaRegistrySchemaType schemaRegistrySchemaType) {
            this.schemaRegistrySchemaType = schemaRegistrySchemaType;
            return self();
        }

        /**
         * Base name of the subject, without -key, -value prefixes.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubjectBaseName(final String schemaRegistrySubjectBaseName) {
            this.schemaRegistrySubjectBaseName = schemaRegistrySubjectBaseName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubjectGoverningAssetQualifiedName(final String schemaRegistrySubjectGoverningAssetQualifiedName) {
            if (this.schemaRegistrySubjectGoverningAssetQualifiedNames == null) this.schemaRegistrySubjectGoverningAssetQualifiedNames = new java.util.ArrayList<String>();
            this.schemaRegistrySubjectGoverningAssetQualifiedNames.add(schemaRegistrySubjectGoverningAssetQualifiedName);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubjectGoverningAssetQualifiedNames(final java.util.Collection<? extends String> schemaRegistrySubjectGoverningAssetQualifiedNames) {
            if (schemaRegistrySubjectGoverningAssetQualifiedNames == null) {
                throw new java.lang.NullPointerException("schemaRegistrySubjectGoverningAssetQualifiedNames cannot be null");
            }
            if (this.schemaRegistrySubjectGoverningAssetQualifiedNames == null) this.schemaRegistrySubjectGoverningAssetQualifiedNames = new java.util.ArrayList<String>();
            this.schemaRegistrySubjectGoverningAssetQualifiedNames.addAll(schemaRegistrySubjectGoverningAssetQualifiedNames);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSchemaRegistrySubjectGoverningAssetQualifiedNames() {
            if (this.schemaRegistrySubjectGoverningAssetQualifiedNames != null) this.schemaRegistrySubjectGoverningAssetQualifiedNames.clear();
            return self();
        }

        /**
         * Whether the subject is a schema for the keys of the messages (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubjectIsKeySchema(final Boolean schemaRegistrySubjectIsKeySchema) {
            this.schemaRegistrySubjectIsKeySchema = schemaRegistrySubjectIsKeySchema;
            return self();
        }

        /**
         * Definition of the latest schema in the subject.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubjectLatestSchemaDefinition(final String schemaRegistrySubjectLatestSchemaDefinition) {
            this.schemaRegistrySubjectLatestSchemaDefinition = schemaRegistrySubjectLatestSchemaDefinition;
            return self();
        }

        /**
         * Latest schema version of the subject.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubjectLatestSchemaVersion(final String schemaRegistrySubjectLatestSchemaVersion) {
            this.schemaRegistrySubjectLatestSchemaVersion = schemaRegistrySubjectLatestSchemaVersion;
            return self();
        }

        /**
         * Compatibility of the schema across versions.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B schemaRegistrySubjectSchemaCompatibility(final SchemaRegistrySchemaCompatibility schemaRegistrySubjectSchemaCompatibility) {
            this.schemaRegistrySubjectSchemaCompatibility = schemaRegistrySubjectSchemaCompatibility;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SchemaRegistrySubject.SchemaRegistrySubjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", assets=" + this.assets + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", schemaRegistrySchemaId=" + this.schemaRegistrySchemaId + ", schemaRegistrySchemaType=" + this.schemaRegistrySchemaType + ", schemaRegistrySubjectBaseName=" + this.schemaRegistrySubjectBaseName + ", schemaRegistrySubjectGoverningAssetQualifiedNames=" + this.schemaRegistrySubjectGoverningAssetQualifiedNames + ", schemaRegistrySubjectIsKeySchema=" + this.schemaRegistrySubjectIsKeySchema + ", schemaRegistrySubjectLatestSchemaDefinition=" + this.schemaRegistrySubjectLatestSchemaDefinition + ", schemaRegistrySubjectLatestSchemaVersion=" + this.schemaRegistrySubjectLatestSchemaVersion + ", schemaRegistrySubjectSchemaCompatibility=" + this.schemaRegistrySubjectSchemaCompatibility + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SchemaRegistrySubjectBuilderImpl extends SchemaRegistrySubject.SchemaRegistrySubjectBuilder<SchemaRegistrySubject, SchemaRegistrySubject.SchemaRegistrySubjectBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SchemaRegistrySubjectBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SchemaRegistrySubject.SchemaRegistrySubjectBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SchemaRegistrySubject build() {
            return new SchemaRegistrySubject(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SchemaRegistrySubject(final SchemaRegistrySubject.SchemaRegistrySubjectBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SchemaRegistrySubject.$default$typeName();
        java.util.SortedSet<IAsset> assets = new java.util.TreeSet<IAsset>();
        if (b.assets != null) assets.addAll(b.assets);
        assets = java.util.Collections.unmodifiableSortedSet(assets);
        this.assets = assets;
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.schemaRegistrySchemaId = b.schemaRegistrySchemaId;
        this.schemaRegistrySchemaType = b.schemaRegistrySchemaType;
        this.schemaRegistrySubjectBaseName = b.schemaRegistrySubjectBaseName;
        java.util.SortedSet<String> schemaRegistrySubjectGoverningAssetQualifiedNames = new java.util.TreeSet<String>();
        if (b.schemaRegistrySubjectGoverningAssetQualifiedNames != null) schemaRegistrySubjectGoverningAssetQualifiedNames.addAll(b.schemaRegistrySubjectGoverningAssetQualifiedNames);
        schemaRegistrySubjectGoverningAssetQualifiedNames = java.util.Collections.unmodifiableSortedSet(schemaRegistrySubjectGoverningAssetQualifiedNames);
        this.schemaRegistrySubjectGoverningAssetQualifiedNames = schemaRegistrySubjectGoverningAssetQualifiedNames;
        this.schemaRegistrySubjectIsKeySchema = b.schemaRegistrySubjectIsKeySchema;
        this.schemaRegistrySubjectLatestSchemaDefinition = b.schemaRegistrySubjectLatestSchemaDefinition;
        this.schemaRegistrySubjectLatestSchemaVersion = b.schemaRegistrySubjectLatestSchemaVersion;
        this.schemaRegistrySubjectSchemaCompatibility = b.schemaRegistrySubjectSchemaCompatibility;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SchemaRegistrySubject.SchemaRegistrySubjectBuilder<?, ?> _internal() {
        return new SchemaRegistrySubject.SchemaRegistrySubjectBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SchemaRegistrySubject.SchemaRegistrySubjectBuilder<?, ?> toBuilder() {
        return new SchemaRegistrySubject.SchemaRegistrySubjectBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getAssets() {
        return this.assets;
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Unique identifier for schema definition set by the schema registry.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaRegistrySchemaId() {
        return this.schemaRegistrySchemaId;
    }

    /**
     * Type of language or specification used to define the schema, for example: JSON, Protobuf, etc.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SchemaRegistrySchemaType getSchemaRegistrySchemaType() {
        return this.schemaRegistrySchemaType;
    }

    /**
     * Base name of the subject, without -key, -value prefixes.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaRegistrySubjectBaseName() {
        return this.schemaRegistrySubjectBaseName;
    }

    /**
     * List of asset qualified names that this subject is governing/validating.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getSchemaRegistrySubjectGoverningAssetQualifiedNames() {
        return this.schemaRegistrySubjectGoverningAssetQualifiedNames;
    }

    /**
     * Whether the subject is a schema for the keys of the messages (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSchemaRegistrySubjectIsKeySchema() {
        return this.schemaRegistrySubjectIsKeySchema;
    }

    /**
     * Definition of the latest schema in the subject.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaRegistrySubjectLatestSchemaDefinition() {
        return this.schemaRegistrySubjectLatestSchemaDefinition;
    }

    /**
     * Latest schema version of the subject.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSchemaRegistrySubjectLatestSchemaVersion() {
        return this.schemaRegistrySubjectLatestSchemaVersion;
    }

    /**
     * Compatibility of the schema across versions.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SchemaRegistrySchemaCompatibility getSchemaRegistrySubjectSchemaCompatibility() {
        return this.schemaRegistrySubjectSchemaCompatibility;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SchemaRegistrySubject)) return false;
        final SchemaRegistrySubject other = (SchemaRegistrySubject) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$schemaRegistrySubjectIsKeySchema = this.getSchemaRegistrySubjectIsKeySchema();
        final java.lang.Object other$schemaRegistrySubjectIsKeySchema = other.getSchemaRegistrySubjectIsKeySchema();
        if (this$schemaRegistrySubjectIsKeySchema == null ? other$schemaRegistrySubjectIsKeySchema != null : !this$schemaRegistrySubjectIsKeySchema.equals(other$schemaRegistrySubjectIsKeySchema)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$assets = this.getAssets();
        final java.lang.Object other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !this$assets.equals(other$assets)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$schemaRegistrySchemaId = this.getSchemaRegistrySchemaId();
        final java.lang.Object other$schemaRegistrySchemaId = other.getSchemaRegistrySchemaId();
        if (this$schemaRegistrySchemaId == null ? other$schemaRegistrySchemaId != null : !this$schemaRegistrySchemaId.equals(other$schemaRegistrySchemaId)) return false;
        final java.lang.Object this$schemaRegistrySchemaType = this.getSchemaRegistrySchemaType();
        final java.lang.Object other$schemaRegistrySchemaType = other.getSchemaRegistrySchemaType();
        if (this$schemaRegistrySchemaType == null ? other$schemaRegistrySchemaType != null : !this$schemaRegistrySchemaType.equals(other$schemaRegistrySchemaType)) return false;
        final java.lang.Object this$schemaRegistrySubjectBaseName = this.getSchemaRegistrySubjectBaseName();
        final java.lang.Object other$schemaRegistrySubjectBaseName = other.getSchemaRegistrySubjectBaseName();
        if (this$schemaRegistrySubjectBaseName == null ? other$schemaRegistrySubjectBaseName != null : !this$schemaRegistrySubjectBaseName.equals(other$schemaRegistrySubjectBaseName)) return false;
        final java.lang.Object this$schemaRegistrySubjectGoverningAssetQualifiedNames = this.getSchemaRegistrySubjectGoverningAssetQualifiedNames();
        final java.lang.Object other$schemaRegistrySubjectGoverningAssetQualifiedNames = other.getSchemaRegistrySubjectGoverningAssetQualifiedNames();
        if (this$schemaRegistrySubjectGoverningAssetQualifiedNames == null ? other$schemaRegistrySubjectGoverningAssetQualifiedNames != null : !this$schemaRegistrySubjectGoverningAssetQualifiedNames.equals(other$schemaRegistrySubjectGoverningAssetQualifiedNames)) return false;
        final java.lang.Object this$schemaRegistrySubjectLatestSchemaDefinition = this.getSchemaRegistrySubjectLatestSchemaDefinition();
        final java.lang.Object other$schemaRegistrySubjectLatestSchemaDefinition = other.getSchemaRegistrySubjectLatestSchemaDefinition();
        if (this$schemaRegistrySubjectLatestSchemaDefinition == null ? other$schemaRegistrySubjectLatestSchemaDefinition != null : !this$schemaRegistrySubjectLatestSchemaDefinition.equals(other$schemaRegistrySubjectLatestSchemaDefinition)) return false;
        final java.lang.Object this$schemaRegistrySubjectLatestSchemaVersion = this.getSchemaRegistrySubjectLatestSchemaVersion();
        final java.lang.Object other$schemaRegistrySubjectLatestSchemaVersion = other.getSchemaRegistrySubjectLatestSchemaVersion();
        if (this$schemaRegistrySubjectLatestSchemaVersion == null ? other$schemaRegistrySubjectLatestSchemaVersion != null : !this$schemaRegistrySubjectLatestSchemaVersion.equals(other$schemaRegistrySubjectLatestSchemaVersion)) return false;
        final java.lang.Object this$schemaRegistrySubjectSchemaCompatibility = this.getSchemaRegistrySubjectSchemaCompatibility();
        final java.lang.Object other$schemaRegistrySubjectSchemaCompatibility = other.getSchemaRegistrySubjectSchemaCompatibility();
        if (this$schemaRegistrySubjectSchemaCompatibility == null ? other$schemaRegistrySubjectSchemaCompatibility != null : !this$schemaRegistrySubjectSchemaCompatibility.equals(other$schemaRegistrySubjectSchemaCompatibility)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SchemaRegistrySubject;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $schemaRegistrySubjectIsKeySchema = this.getSchemaRegistrySubjectIsKeySchema();
        result = result * PRIME + ($schemaRegistrySubjectIsKeySchema == null ? 43 : $schemaRegistrySubjectIsKeySchema.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $assets = this.getAssets();
        result = result * PRIME + ($assets == null ? 43 : $assets.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $schemaRegistrySchemaId = this.getSchemaRegistrySchemaId();
        result = result * PRIME + ($schemaRegistrySchemaId == null ? 43 : $schemaRegistrySchemaId.hashCode());
        final java.lang.Object $schemaRegistrySchemaType = this.getSchemaRegistrySchemaType();
        result = result * PRIME + ($schemaRegistrySchemaType == null ? 43 : $schemaRegistrySchemaType.hashCode());
        final java.lang.Object $schemaRegistrySubjectBaseName = this.getSchemaRegistrySubjectBaseName();
        result = result * PRIME + ($schemaRegistrySubjectBaseName == null ? 43 : $schemaRegistrySubjectBaseName.hashCode());
        final java.lang.Object $schemaRegistrySubjectGoverningAssetQualifiedNames = this.getSchemaRegistrySubjectGoverningAssetQualifiedNames();
        result = result * PRIME + ($schemaRegistrySubjectGoverningAssetQualifiedNames == null ? 43 : $schemaRegistrySubjectGoverningAssetQualifiedNames.hashCode());
        final java.lang.Object $schemaRegistrySubjectLatestSchemaDefinition = this.getSchemaRegistrySubjectLatestSchemaDefinition();
        result = result * PRIME + ($schemaRegistrySubjectLatestSchemaDefinition == null ? 43 : $schemaRegistrySubjectLatestSchemaDefinition.hashCode());
        final java.lang.Object $schemaRegistrySubjectLatestSchemaVersion = this.getSchemaRegistrySubjectLatestSchemaVersion();
        result = result * PRIME + ($schemaRegistrySubjectLatestSchemaVersion == null ? 43 : $schemaRegistrySubjectLatestSchemaVersion.hashCode());
        final java.lang.Object $schemaRegistrySubjectSchemaCompatibility = this.getSchemaRegistrySubjectSchemaCompatibility();
        result = result * PRIME + ($schemaRegistrySubjectSchemaCompatibility == null ? 43 : $schemaRegistrySubjectSchemaCompatibility.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SchemaRegistrySubject(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", assets=" + this.getAssets() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", schemaRegistrySchemaId=" + this.getSchemaRegistrySchemaId() + ", schemaRegistrySchemaType=" + this.getSchemaRegistrySchemaType() + ", schemaRegistrySubjectBaseName=" + this.getSchemaRegistrySubjectBaseName() + ", schemaRegistrySubjectGoverningAssetQualifiedNames=" + this.getSchemaRegistrySubjectGoverningAssetQualifiedNames() + ", schemaRegistrySubjectIsKeySchema=" + this.getSchemaRegistrySubjectIsKeySchema() + ", schemaRegistrySubjectLatestSchemaDefinition=" + this.getSchemaRegistrySubjectLatestSchemaDefinition() + ", schemaRegistrySubjectLatestSchemaVersion=" + this.getSchemaRegistrySubjectLatestSchemaVersion() + ", schemaRegistrySubjectSchemaCompatibility=" + this.getSchemaRegistrySubjectSchemaCompatibility() + ")";
    }

    /**
     * Fixed typeName for SchemaRegistrySubjects.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
