// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Sigma page in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SigmaPage extends Asset implements ISigmaPage, ISigma, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SigmaPage.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SigmaPage";
    /**
     * Fixed typeName for SigmaPages.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Number of data elements on this page.
     */
    @Attribute
    Long sigmaDataElementCount;
    /**
     * Simple name of the data element in which this asset exists.
     */
    @Attribute
    String sigmaDataElementName;
    /**
     * Unique name of the data element in which this asset exists.
     */
    @Attribute
    String sigmaDataElementQualifiedName;
    /**
     * Data elements that exist on this page.
     */
    @Attribute
    SortedSet<ISigmaDataElement> sigmaDataElements;
    /**
     * Simple name of the page on which this asset exists.
     */
    @Attribute
    String sigmaPageName;
    /**
     * Unique name of the page on which this asset exists.
     */
    @Attribute
    String sigmaPageQualifiedName;
    /**
     * Workbook in which this page exists.
     */
    @Attribute
    ISigmaWorkbook sigmaWorkbook;
    /**
     * Simple name of the workbook in which this asset exists.
     */
    @Attribute
    String sigmaWorkbookName;
    /**
     * Unique name of the workbook in which this asset exists.
     */
    @Attribute
    String sigmaWorkbookQualifiedName;

    /**
     * Builds the minimal object necessary to create a relationship to a SigmaPage, from a potentially
     * more-complete SigmaPage object.
     *
     * @return the minimal object necessary to relate to the SigmaPage
     * @throws InvalidRequestException if any of the minimal set of required properties for a SigmaPage relationship are not found in the initial object
     */
    @Override
    public SigmaPage trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SigmaPage assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SigmaPage assets will be included.
     *
     * @return a fluent search that includes all SigmaPage assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SigmaPage assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SigmaPage assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SigmaPage assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SigmaPage assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SigmaPages will be included
     * @return a fluent search that includes all SigmaPage assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SigmaPage assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SigmaPages will be included
     * @return a fluent search that includes all SigmaPage assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SigmaPage by GUID. Use this to create a relationship to this SigmaPage,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SigmaPage to reference
     * @return reference to a SigmaPage that can be used for defining a relationship to a SigmaPage
     */
    public static SigmaPage refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SigmaPage by GUID. Use this to create a relationship to this SigmaPage,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SigmaPage to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SigmaPage that can be used for defining a relationship to a SigmaPage
     */
    public static SigmaPage refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SigmaPage._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SigmaPage by qualifiedName. Use this to create a relationship to this SigmaPage,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SigmaPage to reference
     * @return reference to a SigmaPage that can be used for defining a relationship to a SigmaPage
     */
    public static SigmaPage refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SigmaPage by qualifiedName. Use this to create a relationship to this SigmaPage,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SigmaPage to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SigmaPage that can be used for defining a relationship to a SigmaPage
     */
    public static SigmaPage refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SigmaPage._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SigmaPage by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SigmaPage to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SigmaPage, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SigmaPage does not exist or the provided GUID is not a SigmaPage
     */
    @JsonIgnore
    public static SigmaPage get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SigmaPage by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SigmaPage to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SigmaPage, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SigmaPage does not exist or the provided GUID is not a SigmaPage
     */
    @JsonIgnore
    public static SigmaPage get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SigmaPage by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SigmaPage to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SigmaPage, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SigmaPage does not exist or the provided GUID is not a SigmaPage
     */
    @JsonIgnore
    public static SigmaPage get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SigmaPage) {
                return (SigmaPage) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SigmaPage) {
                return (SigmaPage) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SigmaPage to active.
     *
     * @param qualifiedName for the SigmaPage
     * @return true if the SigmaPage is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SigmaPage to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SigmaPage
     * @return true if the SigmaPage is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the minimal request necessary to update the SigmaPage, as a builder
     */
    public static SigmaPageBuilder<?, ?> updater(String qualifiedName, String name) {
        return SigmaPage._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SigmaPage, from a potentially
     * more-complete SigmaPage object.
     *
     * @return the minimal object necessary to update the SigmaPage, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SigmaPage are not found in the initial object
     */
    @Override
    public SigmaPageBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SigmaPage.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SigmaPage.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SigmaPage.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SigmaPage's owners
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SigmaPage, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SigmaPage.
     *
     * @param client connectivity to the Atlan tenant on which to update the SigmaPage's certificate
     * @param qualifiedName of the SigmaPage
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SigmaPage, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SigmaPage) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SigmaPage.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SigmaPage's certificate
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SigmaPage.
     *
     * @param client connectivity to the Atlan tenant on which to update the SigmaPage's announcement
     * @param qualifiedName of the SigmaPage
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SigmaPage) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SigmaPage.
     *
     * @param client connectivity to the Atlan client from which to remove the SigmaPage's announcement
     * @param qualifiedName of the SigmaPage
     * @param name of the SigmaPage
     * @return the updated SigmaPage, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaPage) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SigmaPage.
     *
     * @param qualifiedName for the SigmaPage
     * @param name human-readable name of the SigmaPage
     * @param terms the list of terms to replace on the SigmaPage, or null to remove all terms from the SigmaPage
     * @return the SigmaPage that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SigmaPage replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SigmaPage.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SigmaPage's assigned terms
     * @param qualifiedName for the SigmaPage
     * @param name human-readable name of the SigmaPage
     * @param terms the list of terms to replace on the SigmaPage, or null to remove all terms from the SigmaPage
     * @return the SigmaPage that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SigmaPage replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaPage) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SigmaPage, without replacing existing terms linked to the SigmaPage.
     * Note: this operation must make two API calls — one to retrieve the SigmaPage's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SigmaPage
     * @param terms the list of terms to append to the SigmaPage
     * @return the SigmaPage that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SigmaPage appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SigmaPage, without replacing existing terms linked to the SigmaPage.
     * Note: this operation must make two API calls — one to retrieve the SigmaPage's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SigmaPage
     * @param qualifiedName for the SigmaPage
     * @param terms the list of terms to append to the SigmaPage
     * @return the SigmaPage that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SigmaPage appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaPage) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SigmaPage, without replacing all existing terms linked to the SigmaPage.
     * Note: this operation must make two API calls — one to retrieve the SigmaPage's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SigmaPage
     * @param terms the list of terms to remove from the SigmaPage, which must be referenced by GUID
     * @return the SigmaPage that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SigmaPage, without replacing all existing terms linked to the SigmaPage.
     * Note: this operation must make two API calls — one to retrieve the SigmaPage's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SigmaPage
     * @param qualifiedName for the SigmaPage
     * @param terms the list of terms to remove from the SigmaPage, which must be referenced by GUID
     * @return the SigmaPage that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SigmaPage removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaPage) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SigmaPage, without replacing existing Atlan tags linked to the SigmaPage.
     * Note: this operation must make two API calls — one to retrieve the SigmaPage's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SigmaPage
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SigmaPage
     */
    public static SigmaPage appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SigmaPage, without replacing existing Atlan tags linked to the SigmaPage.
     * Note: this operation must make two API calls — one to retrieve the SigmaPage's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SigmaPage
     * @param qualifiedName of the SigmaPage
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SigmaPage
     */
    public static SigmaPage appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SigmaPage) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SigmaPage, without replacing existing Atlan tags linked to the SigmaPage.
     * Note: this operation must make two API calls — one to retrieve the SigmaPage's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SigmaPage
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SigmaPage
     */
    public static SigmaPage appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SigmaPage, without replacing existing Atlan tags linked to the SigmaPage.
     * Note: this operation must make two API calls — one to retrieve the SigmaPage's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SigmaPage
     * @param qualifiedName of the SigmaPage
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SigmaPage
     */
    public static SigmaPage appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SigmaPage) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SigmaPage.
     *
     * @param qualifiedName of the SigmaPage
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SigmaPage
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SigmaPage.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SigmaPage
     * @param qualifiedName of the SigmaPage
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SigmaPage
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SigmaPageBuilder<C extends SigmaPage, B extends SigmaPage.SigmaPageBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sigmaDataElementCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sigmaDataElementName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sigmaDataElementQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISigmaDataElement> sigmaDataElements;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sigmaPageName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sigmaPageQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ISigmaWorkbook sigmaWorkbook;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sigmaWorkbookName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sigmaWorkbookQualifiedName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SigmaPage.SigmaPageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SigmaPage instance, final SigmaPage.SigmaPageBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.sigmaDataElementCount(instance.sigmaDataElementCount);
            b.sigmaDataElementName(instance.sigmaDataElementName);
            b.sigmaDataElementQualifiedName(instance.sigmaDataElementQualifiedName);
            b.sigmaDataElements(instance.sigmaDataElements == null ? java.util.Collections.<ISigmaDataElement>emptySortedSet() : instance.sigmaDataElements);
            b.sigmaPageName(instance.sigmaPageName);
            b.sigmaPageQualifiedName(instance.sigmaPageQualifiedName);
            b.sigmaWorkbook(instance.sigmaWorkbook);
            b.sigmaWorkbookName(instance.sigmaWorkbookName);
            b.sigmaWorkbookQualifiedName(instance.sigmaWorkbookQualifiedName);
        }

        /**
         * Fixed typeName for SigmaPages.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Number of data elements on this page.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaDataElementCount(final Long sigmaDataElementCount) {
            this.sigmaDataElementCount = sigmaDataElementCount;
            return self();
        }

        /**
         * Simple name of the data element in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaDataElementName(final String sigmaDataElementName) {
            this.sigmaDataElementName = sigmaDataElementName;
            return self();
        }

        /**
         * Unique name of the data element in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaDataElementQualifiedName(final String sigmaDataElementQualifiedName) {
            this.sigmaDataElementQualifiedName = sigmaDataElementQualifiedName;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaDataElement(final ISigmaDataElement sigmaDataElement) {
            if (this.sigmaDataElements == null) this.sigmaDataElements = new java.util.ArrayList<ISigmaDataElement>();
            this.sigmaDataElements.add(sigmaDataElement);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaDataElements(final java.util.Collection<? extends ISigmaDataElement> sigmaDataElements) {
            if (sigmaDataElements == null) {
                throw new java.lang.NullPointerException("sigmaDataElements cannot be null");
            }
            if (this.sigmaDataElements == null) this.sigmaDataElements = new java.util.ArrayList<ISigmaDataElement>();
            this.sigmaDataElements.addAll(sigmaDataElements);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSigmaDataElements() {
            if (this.sigmaDataElements != null) this.sigmaDataElements.clear();
            return self();
        }

        /**
         * Simple name of the page on which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaPageName(final String sigmaPageName) {
            this.sigmaPageName = sigmaPageName;
            return self();
        }

        /**
         * Unique name of the page on which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaPageQualifiedName(final String sigmaPageQualifiedName) {
            this.sigmaPageQualifiedName = sigmaPageQualifiedName;
            return self();
        }

        /**
         * Workbook in which this page exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaWorkbook(final ISigmaWorkbook sigmaWorkbook) {
            this.sigmaWorkbook = sigmaWorkbook;
            return self();
        }

        /**
         * Simple name of the workbook in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaWorkbookName(final String sigmaWorkbookName) {
            this.sigmaWorkbookName = sigmaWorkbookName;
            return self();
        }

        /**
         * Unique name of the workbook in which this asset exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sigmaWorkbookQualifiedName(final String sigmaWorkbookQualifiedName) {
            this.sigmaWorkbookQualifiedName = sigmaWorkbookQualifiedName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SigmaPage.SigmaPageBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sigmaDataElementCount=" + this.sigmaDataElementCount + ", sigmaDataElementName=" + this.sigmaDataElementName + ", sigmaDataElementQualifiedName=" + this.sigmaDataElementQualifiedName + ", sigmaDataElements=" + this.sigmaDataElements + ", sigmaPageName=" + this.sigmaPageName + ", sigmaPageQualifiedName=" + this.sigmaPageQualifiedName + ", sigmaWorkbook=" + this.sigmaWorkbook + ", sigmaWorkbookName=" + this.sigmaWorkbookName + ", sigmaWorkbookQualifiedName=" + this.sigmaWorkbookQualifiedName + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SigmaPageBuilderImpl extends SigmaPage.SigmaPageBuilder<SigmaPage, SigmaPage.SigmaPageBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SigmaPageBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SigmaPage.SigmaPageBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SigmaPage build() {
            return new SigmaPage(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SigmaPage(final SigmaPage.SigmaPageBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SigmaPage.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sigmaDataElementCount = b.sigmaDataElementCount;
        this.sigmaDataElementName = b.sigmaDataElementName;
        this.sigmaDataElementQualifiedName = b.sigmaDataElementQualifiedName;
        java.util.SortedSet<ISigmaDataElement> sigmaDataElements = new java.util.TreeSet<ISigmaDataElement>();
        if (b.sigmaDataElements != null) sigmaDataElements.addAll(b.sigmaDataElements);
        sigmaDataElements = java.util.Collections.unmodifiableSortedSet(sigmaDataElements);
        this.sigmaDataElements = sigmaDataElements;
        this.sigmaPageName = b.sigmaPageName;
        this.sigmaPageQualifiedName = b.sigmaPageQualifiedName;
        this.sigmaWorkbook = b.sigmaWorkbook;
        this.sigmaWorkbookName = b.sigmaWorkbookName;
        this.sigmaWorkbookQualifiedName = b.sigmaWorkbookQualifiedName;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SigmaPage.SigmaPageBuilder<?, ?> _internal() {
        return new SigmaPage.SigmaPageBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SigmaPage.SigmaPageBuilder<?, ?> toBuilder() {
        return new SigmaPage.SigmaPageBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Number of data elements on this page.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSigmaDataElementCount() {
        return this.sigmaDataElementCount;
    }

    /**
     * Simple name of the data element in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSigmaDataElementName() {
        return this.sigmaDataElementName;
    }

    /**
     * Unique name of the data element in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSigmaDataElementQualifiedName() {
        return this.sigmaDataElementQualifiedName;
    }

    /**
     * Data elements that exist on this page.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISigmaDataElement> getSigmaDataElements() {
        return this.sigmaDataElements;
    }

    /**
     * Simple name of the page on which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSigmaPageName() {
        return this.sigmaPageName;
    }

    /**
     * Unique name of the page on which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSigmaPageQualifiedName() {
        return this.sigmaPageQualifiedName;
    }

    /**
     * Workbook in which this page exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ISigmaWorkbook getSigmaWorkbook() {
        return this.sigmaWorkbook;
    }

    /**
     * Simple name of the workbook in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSigmaWorkbookName() {
        return this.sigmaWorkbookName;
    }

    /**
     * Unique name of the workbook in which this asset exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSigmaWorkbookQualifiedName() {
        return this.sigmaWorkbookQualifiedName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SigmaPage)) return false;
        final SigmaPage other = (SigmaPage) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$sigmaDataElementCount = this.getSigmaDataElementCount();
        final java.lang.Object other$sigmaDataElementCount = other.getSigmaDataElementCount();
        if (this$sigmaDataElementCount == null ? other$sigmaDataElementCount != null : !this$sigmaDataElementCount.equals(other$sigmaDataElementCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$sigmaDataElementName = this.getSigmaDataElementName();
        final java.lang.Object other$sigmaDataElementName = other.getSigmaDataElementName();
        if (this$sigmaDataElementName == null ? other$sigmaDataElementName != null : !this$sigmaDataElementName.equals(other$sigmaDataElementName)) return false;
        final java.lang.Object this$sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        final java.lang.Object other$sigmaDataElementQualifiedName = other.getSigmaDataElementQualifiedName();
        if (this$sigmaDataElementQualifiedName == null ? other$sigmaDataElementQualifiedName != null : !this$sigmaDataElementQualifiedName.equals(other$sigmaDataElementQualifiedName)) return false;
        final java.lang.Object this$sigmaDataElements = this.getSigmaDataElements();
        final java.lang.Object other$sigmaDataElements = other.getSigmaDataElements();
        if (this$sigmaDataElements == null ? other$sigmaDataElements != null : !this$sigmaDataElements.equals(other$sigmaDataElements)) return false;
        final java.lang.Object this$sigmaPageName = this.getSigmaPageName();
        final java.lang.Object other$sigmaPageName = other.getSigmaPageName();
        if (this$sigmaPageName == null ? other$sigmaPageName != null : !this$sigmaPageName.equals(other$sigmaPageName)) return false;
        final java.lang.Object this$sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        final java.lang.Object other$sigmaPageQualifiedName = other.getSigmaPageQualifiedName();
        if (this$sigmaPageQualifiedName == null ? other$sigmaPageQualifiedName != null : !this$sigmaPageQualifiedName.equals(other$sigmaPageQualifiedName)) return false;
        final java.lang.Object this$sigmaWorkbook = this.getSigmaWorkbook();
        final java.lang.Object other$sigmaWorkbook = other.getSigmaWorkbook();
        if (this$sigmaWorkbook == null ? other$sigmaWorkbook != null : !this$sigmaWorkbook.equals(other$sigmaWorkbook)) return false;
        final java.lang.Object this$sigmaWorkbookName = this.getSigmaWorkbookName();
        final java.lang.Object other$sigmaWorkbookName = other.getSigmaWorkbookName();
        if (this$sigmaWorkbookName == null ? other$sigmaWorkbookName != null : !this$sigmaWorkbookName.equals(other$sigmaWorkbookName)) return false;
        final java.lang.Object this$sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        final java.lang.Object other$sigmaWorkbookQualifiedName = other.getSigmaWorkbookQualifiedName();
        if (this$sigmaWorkbookQualifiedName == null ? other$sigmaWorkbookQualifiedName != null : !this$sigmaWorkbookQualifiedName.equals(other$sigmaWorkbookQualifiedName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SigmaPage;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $sigmaDataElementCount = this.getSigmaDataElementCount();
        result = result * PRIME + ($sigmaDataElementCount == null ? 43 : $sigmaDataElementCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $sigmaDataElementName = this.getSigmaDataElementName();
        result = result * PRIME + ($sigmaDataElementName == null ? 43 : $sigmaDataElementName.hashCode());
        final java.lang.Object $sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        result = result * PRIME + ($sigmaDataElementQualifiedName == null ? 43 : $sigmaDataElementQualifiedName.hashCode());
        final java.lang.Object $sigmaDataElements = this.getSigmaDataElements();
        result = result * PRIME + ($sigmaDataElements == null ? 43 : $sigmaDataElements.hashCode());
        final java.lang.Object $sigmaPageName = this.getSigmaPageName();
        result = result * PRIME + ($sigmaPageName == null ? 43 : $sigmaPageName.hashCode());
        final java.lang.Object $sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        result = result * PRIME + ($sigmaPageQualifiedName == null ? 43 : $sigmaPageQualifiedName.hashCode());
        final java.lang.Object $sigmaWorkbook = this.getSigmaWorkbook();
        result = result * PRIME + ($sigmaWorkbook == null ? 43 : $sigmaWorkbook.hashCode());
        final java.lang.Object $sigmaWorkbookName = this.getSigmaWorkbookName();
        result = result * PRIME + ($sigmaWorkbookName == null ? 43 : $sigmaWorkbookName.hashCode());
        final java.lang.Object $sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        result = result * PRIME + ($sigmaWorkbookQualifiedName == null ? 43 : $sigmaWorkbookQualifiedName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SigmaPage(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sigmaDataElementCount=" + this.getSigmaDataElementCount() + ", sigmaDataElementName=" + this.getSigmaDataElementName() + ", sigmaDataElementQualifiedName=" + this.getSigmaDataElementQualifiedName() + ", sigmaDataElements=" + this.getSigmaDataElements() + ", sigmaPageName=" + this.getSigmaPageName() + ", sigmaPageQualifiedName=" + this.getSigmaPageQualifiedName() + ", sigmaWorkbook=" + this.getSigmaWorkbook() + ", sigmaWorkbookName=" + this.getSigmaWorkbookName() + ", sigmaWorkbookQualifiedName=" + this.getSigmaWorkbookQualifiedName() + ")";
    }

    /**
     * Fixed typeName for SigmaPages.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
