// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Sisense dashboard in Atlan. These allow you to place multiple widgets on a single page.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SisenseDashboard extends Asset implements ISisenseDashboard, ISisense, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SisenseDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseDashboard";
    /**
     * Fixed typeName for SisenseDashboards.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Unique name of the folder in which this dashboard exists.
     */
    @Attribute
    String sisenseDashboardFolderQualifiedName;
    /**
     * Number of widgets in this dashboard.
     */
    @Attribute
    Long sisenseDashboardWidgetCount;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISisenseDatamodel> sisenseDatamodels;
    /**
     * Folder in which this dashboard exists.
     */
    @Attribute
    ISisenseFolder sisenseFolder;
    /**
     * Widgets that exist in this dashboard.
     */
    @Attribute
    SortedSet<ISisenseWidget> sisenseWidgets;

    /**
     * Builds the minimal object necessary to create a relationship to a SisenseDashboard, from a potentially
     * more-complete SisenseDashboard object.
     *
     * @return the minimal object necessary to relate to the SisenseDashboard
     * @throws InvalidRequestException if any of the minimal set of required properties for a SisenseDashboard relationship are not found in the initial object
     */
    @Override
    public SisenseDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SisenseDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SisenseDashboard assets will be included.
     *
     * @return a fluent search that includes all SisenseDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SisenseDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SisenseDashboard assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SisenseDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SisenseDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SisenseDashboards will be included
     * @return a fluent search that includes all SisenseDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SisenseDashboard assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SisenseDashboards will be included
     * @return a fluent search that includes all SisenseDashboard assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SisenseDashboard by GUID. Use this to create a relationship to this SisenseDashboard,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SisenseDashboard to reference
     * @return reference to a SisenseDashboard that can be used for defining a relationship to a SisenseDashboard
     */
    public static SisenseDashboard refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SisenseDashboard by GUID. Use this to create a relationship to this SisenseDashboard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SisenseDashboard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SisenseDashboard that can be used for defining a relationship to a SisenseDashboard
     */
    public static SisenseDashboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SisenseDashboard._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SisenseDashboard by qualifiedName. Use this to create a relationship to this SisenseDashboard,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SisenseDashboard to reference
     * @return reference to a SisenseDashboard that can be used for defining a relationship to a SisenseDashboard
     */
    public static SisenseDashboard refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SisenseDashboard by qualifiedName. Use this to create a relationship to this SisenseDashboard,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SisenseDashboard to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SisenseDashboard that can be used for defining a relationship to a SisenseDashboard
     */
    public static SisenseDashboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SisenseDashboard._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SisenseDashboard by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SisenseDashboard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SisenseDashboard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDashboard does not exist or the provided GUID is not a SisenseDashboard
     */
    @JsonIgnore
    public static SisenseDashboard get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SisenseDashboard by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SisenseDashboard to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SisenseDashboard, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDashboard does not exist or the provided GUID is not a SisenseDashboard
     */
    @JsonIgnore
    public static SisenseDashboard get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SisenseDashboard by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SisenseDashboard to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SisenseDashboard, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDashboard does not exist or the provided GUID is not a SisenseDashboard
     */
    @JsonIgnore
    public static SisenseDashboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SisenseDashboard) {
                return (SisenseDashboard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SisenseDashboard) {
                return (SisenseDashboard) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SisenseDashboard to active.
     *
     * @param qualifiedName for the SisenseDashboard
     * @return true if the SisenseDashboard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SisenseDashboard to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SisenseDashboard
     * @return true if the SisenseDashboard is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the minimal request necessary to update the SisenseDashboard, as a builder
     */
    public static SisenseDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return SisenseDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SisenseDashboard, from a potentially
     * more-complete SisenseDashboard object.
     *
     * @return the minimal object necessary to update the SisenseDashboard, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SisenseDashboard are not found in the initial object
     */
    @Override
    public SisenseDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SisenseDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SisenseDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SisenseDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SisenseDashboard's owners
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SisenseDashboard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SisenseDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to update the SisenseDashboard's certificate
     * @param qualifiedName of the SisenseDashboard
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SisenseDashboard, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseDashboard) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SisenseDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SisenseDashboard's certificate
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SisenseDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to update the SisenseDashboard's announcement
     * @param qualifiedName of the SisenseDashboard
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseDashboard) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SisenseDashboard.
     *
     * @param client connectivity to the Atlan client from which to remove the SisenseDashboard's announcement
     * @param qualifiedName of the SisenseDashboard
     * @param name of the SisenseDashboard
     * @return the updated SisenseDashboard, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDashboard) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SisenseDashboard.
     *
     * @param qualifiedName for the SisenseDashboard
     * @param name human-readable name of the SisenseDashboard
     * @param terms the list of terms to replace on the SisenseDashboard, or null to remove all terms from the SisenseDashboard
     * @return the SisenseDashboard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SisenseDashboard.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SisenseDashboard's assigned terms
     * @param qualifiedName for the SisenseDashboard
     * @param name human-readable name of the SisenseDashboard
     * @param terms the list of terms to replace on the SisenseDashboard, or null to remove all terms from the SisenseDashboard
     * @return the SisenseDashboard that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDashboard) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SisenseDashboard, without replacing existing terms linked to the SisenseDashboard.
     * Note: this operation must make two API calls — one to retrieve the SisenseDashboard's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SisenseDashboard
     * @param terms the list of terms to append to the SisenseDashboard
     * @return the SisenseDashboard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SisenseDashboard, without replacing existing terms linked to the SisenseDashboard.
     * Note: this operation must make two API calls — one to retrieve the SisenseDashboard's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SisenseDashboard
     * @param qualifiedName for the SisenseDashboard
     * @param terms the list of terms to append to the SisenseDashboard
     * @return the SisenseDashboard that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDashboard) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SisenseDashboard, without replacing all existing terms linked to the SisenseDashboard.
     * Note: this operation must make two API calls — one to retrieve the SisenseDashboard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SisenseDashboard
     * @param terms the list of terms to remove from the SisenseDashboard, which must be referenced by GUID
     * @return the SisenseDashboard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SisenseDashboard, without replacing all existing terms linked to the SisenseDashboard.
     * Note: this operation must make two API calls — one to retrieve the SisenseDashboard's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SisenseDashboard
     * @param qualifiedName for the SisenseDashboard
     * @param terms the list of terms to remove from the SisenseDashboard, which must be referenced by GUID
     * @return the SisenseDashboard that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDashboard) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SisenseDashboard, without replacing existing Atlan tags linked to the SisenseDashboard.
     * Note: this operation must make two API calls — one to retrieve the SisenseDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SisenseDashboard
     */
    public static SisenseDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SisenseDashboard, without replacing existing Atlan tags linked to the SisenseDashboard.
     * Note: this operation must make two API calls — one to retrieve the SisenseDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SisenseDashboard
     * @param qualifiedName of the SisenseDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SisenseDashboard
     */
    public static SisenseDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseDashboard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SisenseDashboard, without replacing existing Atlan tags linked to the SisenseDashboard.
     * Note: this operation must make two API calls — one to retrieve the SisenseDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SisenseDashboard
     */
    public static SisenseDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SisenseDashboard, without replacing existing Atlan tags linked to the SisenseDashboard.
     * Note: this operation must make two API calls — one to retrieve the SisenseDashboard's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SisenseDashboard
     * @param qualifiedName of the SisenseDashboard
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SisenseDashboard
     */
    public static SisenseDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseDashboard) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SisenseDashboard.
     *
     * @param qualifiedName of the SisenseDashboard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SisenseDashboard
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SisenseDashboard.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SisenseDashboard
     * @param qualifiedName of the SisenseDashboard
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SisenseDashboard
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SisenseDashboardBuilder<C extends SisenseDashboard, B extends SisenseDashboard.SisenseDashboardBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDashboardFolderQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sisenseDashboardWidgetCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISisenseDatamodel> sisenseDatamodels;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ISisenseFolder sisenseFolder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISisenseWidget> sisenseWidgets;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SisenseDashboard.SisenseDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SisenseDashboard instance, final SisenseDashboard.SisenseDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseDashboardFolderQualifiedName(instance.sisenseDashboardFolderQualifiedName);
            b.sisenseDashboardWidgetCount(instance.sisenseDashboardWidgetCount);
            b.sisenseDatamodels(instance.sisenseDatamodels == null ? java.util.Collections.<ISisenseDatamodel>emptySortedSet() : instance.sisenseDatamodels);
            b.sisenseFolder(instance.sisenseFolder);
            b.sisenseWidgets(instance.sisenseWidgets == null ? java.util.Collections.<ISisenseWidget>emptySortedSet() : instance.sisenseWidgets);
        }

        /**
         * Fixed typeName for SisenseDashboards.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Unique name of the folder in which this dashboard exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDashboardFolderQualifiedName(final String sisenseDashboardFolderQualifiedName) {
            this.sisenseDashboardFolderQualifiedName = sisenseDashboardFolderQualifiedName;
            return self();
        }

        /**
         * Number of widgets in this dashboard.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDashboardWidgetCount(final Long sisenseDashboardWidgetCount) {
            this.sisenseDashboardWidgetCount = sisenseDashboardWidgetCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodel(final ISisenseDatamodel sisenseDatamodel) {
            if (this.sisenseDatamodels == null) this.sisenseDatamodels = new java.util.ArrayList<ISisenseDatamodel>();
            this.sisenseDatamodels.add(sisenseDatamodel);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodels(final java.util.Collection<? extends ISisenseDatamodel> sisenseDatamodels) {
            if (sisenseDatamodels == null) {
                throw new java.lang.NullPointerException("sisenseDatamodels cannot be null");
            }
            if (this.sisenseDatamodels == null) this.sisenseDatamodels = new java.util.ArrayList<ISisenseDatamodel>();
            this.sisenseDatamodels.addAll(sisenseDatamodels);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSisenseDatamodels() {
            if (this.sisenseDatamodels != null) this.sisenseDatamodels.clear();
            return self();
        }

        /**
         * Folder in which this dashboard exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseFolder(final ISisenseFolder sisenseFolder) {
            this.sisenseFolder = sisenseFolder;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseWidget(final ISisenseWidget sisenseWidget) {
            if (this.sisenseWidgets == null) this.sisenseWidgets = new java.util.ArrayList<ISisenseWidget>();
            this.sisenseWidgets.add(sisenseWidget);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseWidgets(final java.util.Collection<? extends ISisenseWidget> sisenseWidgets) {
            if (sisenseWidgets == null) {
                throw new java.lang.NullPointerException("sisenseWidgets cannot be null");
            }
            if (this.sisenseWidgets == null) this.sisenseWidgets = new java.util.ArrayList<ISisenseWidget>();
            this.sisenseWidgets.addAll(sisenseWidgets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSisenseWidgets() {
            if (this.sisenseWidgets != null) this.sisenseWidgets.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SisenseDashboard.SisenseDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sisenseDashboardFolderQualifiedName=" + this.sisenseDashboardFolderQualifiedName + ", sisenseDashboardWidgetCount=" + this.sisenseDashboardWidgetCount + ", sisenseDatamodels=" + this.sisenseDatamodels + ", sisenseFolder=" + this.sisenseFolder + ", sisenseWidgets=" + this.sisenseWidgets + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SisenseDashboardBuilderImpl extends SisenseDashboard.SisenseDashboardBuilder<SisenseDashboard, SisenseDashboard.SisenseDashboardBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SisenseDashboardBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SisenseDashboard.SisenseDashboardBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SisenseDashboard build() {
            return new SisenseDashboard(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SisenseDashboard(final SisenseDashboard.SisenseDashboardBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SisenseDashboard.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sisenseDashboardFolderQualifiedName = b.sisenseDashboardFolderQualifiedName;
        this.sisenseDashboardWidgetCount = b.sisenseDashboardWidgetCount;
        java.util.SortedSet<ISisenseDatamodel> sisenseDatamodels = new java.util.TreeSet<ISisenseDatamodel>();
        if (b.sisenseDatamodels != null) sisenseDatamodels.addAll(b.sisenseDatamodels);
        sisenseDatamodels = java.util.Collections.unmodifiableSortedSet(sisenseDatamodels);
        this.sisenseDatamodels = sisenseDatamodels;
        this.sisenseFolder = b.sisenseFolder;
        java.util.SortedSet<ISisenseWidget> sisenseWidgets = new java.util.TreeSet<ISisenseWidget>();
        if (b.sisenseWidgets != null) sisenseWidgets.addAll(b.sisenseWidgets);
        sisenseWidgets = java.util.Collections.unmodifiableSortedSet(sisenseWidgets);
        this.sisenseWidgets = sisenseWidgets;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SisenseDashboard.SisenseDashboardBuilder<?, ?> _internal() {
        return new SisenseDashboard.SisenseDashboardBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SisenseDashboard.SisenseDashboardBuilder<?, ?> toBuilder() {
        return new SisenseDashboard.SisenseDashboardBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Unique name of the folder in which this dashboard exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDashboardFolderQualifiedName() {
        return this.sisenseDashboardFolderQualifiedName;
    }

    /**
     * Number of widgets in this dashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSisenseDashboardWidgetCount() {
        return this.sisenseDashboardWidgetCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISisenseDatamodel> getSisenseDatamodels() {
        return this.sisenseDatamodels;
    }

    /**
     * Folder in which this dashboard exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ISisenseFolder getSisenseFolder() {
        return this.sisenseFolder;
    }

    /**
     * Widgets that exist in this dashboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISisenseWidget> getSisenseWidgets() {
        return this.sisenseWidgets;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SisenseDashboard)) return false;
        final SisenseDashboard other = (SisenseDashboard) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$sisenseDashboardWidgetCount = this.getSisenseDashboardWidgetCount();
        final java.lang.Object other$sisenseDashboardWidgetCount = other.getSisenseDashboardWidgetCount();
        if (this$sisenseDashboardWidgetCount == null ? other$sisenseDashboardWidgetCount != null : !this$sisenseDashboardWidgetCount.equals(other$sisenseDashboardWidgetCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$sisenseDashboardFolderQualifiedName = this.getSisenseDashboardFolderQualifiedName();
        final java.lang.Object other$sisenseDashboardFolderQualifiedName = other.getSisenseDashboardFolderQualifiedName();
        if (this$sisenseDashboardFolderQualifiedName == null ? other$sisenseDashboardFolderQualifiedName != null : !this$sisenseDashboardFolderQualifiedName.equals(other$sisenseDashboardFolderQualifiedName)) return false;
        final java.lang.Object this$sisenseDatamodels = this.getSisenseDatamodels();
        final java.lang.Object other$sisenseDatamodels = other.getSisenseDatamodels();
        if (this$sisenseDatamodels == null ? other$sisenseDatamodels != null : !this$sisenseDatamodels.equals(other$sisenseDatamodels)) return false;
        final java.lang.Object this$sisenseFolder = this.getSisenseFolder();
        final java.lang.Object other$sisenseFolder = other.getSisenseFolder();
        if (this$sisenseFolder == null ? other$sisenseFolder != null : !this$sisenseFolder.equals(other$sisenseFolder)) return false;
        final java.lang.Object this$sisenseWidgets = this.getSisenseWidgets();
        final java.lang.Object other$sisenseWidgets = other.getSisenseWidgets();
        if (this$sisenseWidgets == null ? other$sisenseWidgets != null : !this$sisenseWidgets.equals(other$sisenseWidgets)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SisenseDashboard;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $sisenseDashboardWidgetCount = this.getSisenseDashboardWidgetCount();
        result = result * PRIME + ($sisenseDashboardWidgetCount == null ? 43 : $sisenseDashboardWidgetCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $sisenseDashboardFolderQualifiedName = this.getSisenseDashboardFolderQualifiedName();
        result = result * PRIME + ($sisenseDashboardFolderQualifiedName == null ? 43 : $sisenseDashboardFolderQualifiedName.hashCode());
        final java.lang.Object $sisenseDatamodels = this.getSisenseDatamodels();
        result = result * PRIME + ($sisenseDatamodels == null ? 43 : $sisenseDatamodels.hashCode());
        final java.lang.Object $sisenseFolder = this.getSisenseFolder();
        result = result * PRIME + ($sisenseFolder == null ? 43 : $sisenseFolder.hashCode());
        final java.lang.Object $sisenseWidgets = this.getSisenseWidgets();
        result = result * PRIME + ($sisenseWidgets == null ? 43 : $sisenseWidgets.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SisenseDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sisenseDashboardFolderQualifiedName=" + this.getSisenseDashboardFolderQualifiedName() + ", sisenseDashboardWidgetCount=" + this.getSisenseDashboardWidgetCount() + ", sisenseDatamodels=" + this.getSisenseDatamodels() + ", sisenseFolder=" + this.getSisenseFolder() + ", sisenseWidgets=" + this.getSisenseWidgets() + ")";
    }

    /**
     * Fixed typeName for SisenseDashboards.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
