// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Sisense datamodel in Atlan. These group tables together that you can use to build dashboards.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SisenseDatamodel extends Asset implements ISisenseDatamodel, ISisense, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SisenseDatamodel.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseDatamodel";
    /**
     * Fixed typeName for SisenseDatamodels.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISisenseDashboard> sisenseDashboards;
    /**
     * Time (epoch) when this datamodel was last built, in milliseconds.
     */
    @Attribute
    @Date
    Long sisenseDatamodelLastBuildTime;
    /**
     * Time (epoch) when this datamodel was last published, in milliseconds.
     */
    @Attribute
    @Date
    Long sisenseDatamodelLastPublishTime;
    /**
     * Time (epoch) when this datamodel was last built successfully, in milliseconds.
     */
    @Attribute
    @Date
    Long sisenseDatamodelLastSuccessfulBuildTime;
    /**
     * Default relation type for this datamodel. 'extract' type Datamodels have regular relations by default. 'live' type Datamodels have direct relations by default.
     */
    @Attribute
    String sisenseDatamodelRelationType;
    /**
     * Revision of this datamodel.
     */
    @Attribute
    String sisenseDatamodelRevision;
    /**
     * Hostname of the server on which this datamodel was created.
     */
    @Attribute
    String sisenseDatamodelServer;
    /**
     * Number of tables in this datamodel.
     */
    @Attribute
    Long sisenseDatamodelTableCount;
    /**
     * Datamodel tables that exist within this datamodel.
     */
    @Attribute
    SortedSet<ISisenseDatamodelTable> sisenseDatamodelTables;
    /**
     * Type of this datamodel, for example: 'extract' or 'custom'.
     */
    @Attribute
    String sisenseDatamodelType;

    /**
     * Builds the minimal object necessary to create a relationship to a SisenseDatamodel, from a potentially
     * more-complete SisenseDatamodel object.
     *
     * @return the minimal object necessary to relate to the SisenseDatamodel
     * @throws InvalidRequestException if any of the minimal set of required properties for a SisenseDatamodel relationship are not found in the initial object
     */
    @Override
    public SisenseDatamodel trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SisenseDatamodel assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SisenseDatamodel assets will be included.
     *
     * @return a fluent search that includes all SisenseDatamodel assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SisenseDatamodel assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SisenseDatamodel assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SisenseDatamodel assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SisenseDatamodel assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SisenseDatamodels will be included
     * @return a fluent search that includes all SisenseDatamodel assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SisenseDatamodel assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SisenseDatamodels will be included
     * @return a fluent search that includes all SisenseDatamodel assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SisenseDatamodel by GUID. Use this to create a relationship to this SisenseDatamodel,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SisenseDatamodel to reference
     * @return reference to a SisenseDatamodel that can be used for defining a relationship to a SisenseDatamodel
     */
    public static SisenseDatamodel refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SisenseDatamodel by GUID. Use this to create a relationship to this SisenseDatamodel,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SisenseDatamodel to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SisenseDatamodel that can be used for defining a relationship to a SisenseDatamodel
     */
    public static SisenseDatamodel refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SisenseDatamodel._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SisenseDatamodel by qualifiedName. Use this to create a relationship to this SisenseDatamodel,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SisenseDatamodel to reference
     * @return reference to a SisenseDatamodel that can be used for defining a relationship to a SisenseDatamodel
     */
    public static SisenseDatamodel refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SisenseDatamodel by qualifiedName. Use this to create a relationship to this SisenseDatamodel,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SisenseDatamodel to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SisenseDatamodel that can be used for defining a relationship to a SisenseDatamodel
     */
    public static SisenseDatamodel refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SisenseDatamodel._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SisenseDatamodel by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SisenseDatamodel to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SisenseDatamodel, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDatamodel does not exist or the provided GUID is not a SisenseDatamodel
     */
    @JsonIgnore
    public static SisenseDatamodel get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SisenseDatamodel by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SisenseDatamodel to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SisenseDatamodel, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDatamodel does not exist or the provided GUID is not a SisenseDatamodel
     */
    @JsonIgnore
    public static SisenseDatamodel get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SisenseDatamodel by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SisenseDatamodel to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SisenseDatamodel, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDatamodel does not exist or the provided GUID is not a SisenseDatamodel
     */
    @JsonIgnore
    public static SisenseDatamodel get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SisenseDatamodel) {
                return (SisenseDatamodel) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SisenseDatamodel) {
                return (SisenseDatamodel) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SisenseDatamodel to active.
     *
     * @param qualifiedName for the SisenseDatamodel
     * @return true if the SisenseDatamodel is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SisenseDatamodel to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SisenseDatamodel
     * @return true if the SisenseDatamodel is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the minimal request necessary to update the SisenseDatamodel, as a builder
     */
    public static SisenseDatamodelBuilder<?, ?> updater(String qualifiedName, String name) {
        return SisenseDatamodel._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SisenseDatamodel, from a potentially
     * more-complete SisenseDatamodel object.
     *
     * @return the minimal object necessary to update the SisenseDatamodel, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SisenseDatamodel are not found in the initial object
     */
    @Override
    public SisenseDatamodelBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SisenseDatamodel.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SisenseDatamodel.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SisenseDatamodel.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SisenseDatamodel's owners
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SisenseDatamodel, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SisenseDatamodel.
     *
     * @param client connectivity to the Atlan tenant on which to update the SisenseDatamodel's certificate
     * @param qualifiedName of the SisenseDatamodel
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SisenseDatamodel, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseDatamodel) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SisenseDatamodel.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SisenseDatamodel's certificate
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SisenseDatamodel.
     *
     * @param client connectivity to the Atlan tenant on which to update the SisenseDatamodel's announcement
     * @param qualifiedName of the SisenseDatamodel
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseDatamodel) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SisenseDatamodel.
     *
     * @param client connectivity to the Atlan client from which to remove the SisenseDatamodel's announcement
     * @param qualifiedName of the SisenseDatamodel
     * @param name of the SisenseDatamodel
     * @return the updated SisenseDatamodel, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodel) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SisenseDatamodel.
     *
     * @param qualifiedName for the SisenseDatamodel
     * @param name human-readable name of the SisenseDatamodel
     * @param terms the list of terms to replace on the SisenseDatamodel, or null to remove all terms from the SisenseDatamodel
     * @return the SisenseDatamodel that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SisenseDatamodel.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SisenseDatamodel's assigned terms
     * @param qualifiedName for the SisenseDatamodel
     * @param name human-readable name of the SisenseDatamodel
     * @param terms the list of terms to replace on the SisenseDatamodel, or null to remove all terms from the SisenseDatamodel
     * @return the SisenseDatamodel that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodel) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SisenseDatamodel, without replacing existing terms linked to the SisenseDatamodel.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodel's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SisenseDatamodel
     * @param terms the list of terms to append to the SisenseDatamodel
     * @return the SisenseDatamodel that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SisenseDatamodel, without replacing existing terms linked to the SisenseDatamodel.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodel's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SisenseDatamodel
     * @param qualifiedName for the SisenseDatamodel
     * @param terms the list of terms to append to the SisenseDatamodel
     * @return the SisenseDatamodel that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodel) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SisenseDatamodel, without replacing all existing terms linked to the SisenseDatamodel.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodel's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SisenseDatamodel
     * @param terms the list of terms to remove from the SisenseDatamodel, which must be referenced by GUID
     * @return the SisenseDatamodel that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SisenseDatamodel, without replacing all existing terms linked to the SisenseDatamodel.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodel's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SisenseDatamodel
     * @param qualifiedName for the SisenseDatamodel
     * @param terms the list of terms to remove from the SisenseDatamodel, which must be referenced by GUID
     * @return the SisenseDatamodel that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodel removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodel) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SisenseDatamodel, without replacing existing Atlan tags linked to the SisenseDatamodel.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodel's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SisenseDatamodel
     */
    public static SisenseDatamodel appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SisenseDatamodel, without replacing existing Atlan tags linked to the SisenseDatamodel.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodel's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SisenseDatamodel
     * @param qualifiedName of the SisenseDatamodel
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SisenseDatamodel
     */
    public static SisenseDatamodel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseDatamodel) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SisenseDatamodel, without replacing existing Atlan tags linked to the SisenseDatamodel.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodel's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SisenseDatamodel
     */
    public static SisenseDatamodel appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SisenseDatamodel, without replacing existing Atlan tags linked to the SisenseDatamodel.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodel's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SisenseDatamodel
     * @param qualifiedName of the SisenseDatamodel
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SisenseDatamodel
     */
    public static SisenseDatamodel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseDatamodel) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SisenseDatamodel.
     *
     * @param qualifiedName of the SisenseDatamodel
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SisenseDatamodel
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SisenseDatamodel.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SisenseDatamodel
     * @param qualifiedName of the SisenseDatamodel
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SisenseDatamodel
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SisenseDatamodelBuilder<C extends SisenseDatamodel, B extends SisenseDatamodel.SisenseDatamodelBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISisenseDashboard> sisenseDashboards;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sisenseDatamodelLastBuildTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sisenseDatamodelLastPublishTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sisenseDatamodelLastSuccessfulBuildTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelRelationType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelRevision;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelServer;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sisenseDatamodelTableCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISisenseDatamodelTable> sisenseDatamodelTables;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelType;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SisenseDatamodel.SisenseDatamodelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SisenseDatamodel instance, final SisenseDatamodel.SisenseDatamodelBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseDashboards(instance.sisenseDashboards == null ? java.util.Collections.<ISisenseDashboard>emptySortedSet() : instance.sisenseDashboards);
            b.sisenseDatamodelLastBuildTime(instance.sisenseDatamodelLastBuildTime);
            b.sisenseDatamodelLastPublishTime(instance.sisenseDatamodelLastPublishTime);
            b.sisenseDatamodelLastSuccessfulBuildTime(instance.sisenseDatamodelLastSuccessfulBuildTime);
            b.sisenseDatamodelRelationType(instance.sisenseDatamodelRelationType);
            b.sisenseDatamodelRevision(instance.sisenseDatamodelRevision);
            b.sisenseDatamodelServer(instance.sisenseDatamodelServer);
            b.sisenseDatamodelTableCount(instance.sisenseDatamodelTableCount);
            b.sisenseDatamodelTables(instance.sisenseDatamodelTables == null ? java.util.Collections.<ISisenseDatamodelTable>emptySortedSet() : instance.sisenseDatamodelTables);
            b.sisenseDatamodelType(instance.sisenseDatamodelType);
        }

        /**
         * Fixed typeName for SisenseDatamodels.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDashboard(final ISisenseDashboard sisenseDashboard) {
            if (this.sisenseDashboards == null) this.sisenseDashboards = new java.util.ArrayList<ISisenseDashboard>();
            this.sisenseDashboards.add(sisenseDashboard);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDashboards(final java.util.Collection<? extends ISisenseDashboard> sisenseDashboards) {
            if (sisenseDashboards == null) {
                throw new java.lang.NullPointerException("sisenseDashboards cannot be null");
            }
            if (this.sisenseDashboards == null) this.sisenseDashboards = new java.util.ArrayList<ISisenseDashboard>();
            this.sisenseDashboards.addAll(sisenseDashboards);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSisenseDashboards() {
            if (this.sisenseDashboards != null) this.sisenseDashboards.clear();
            return self();
        }

        /**
         * Time (epoch) when this datamodel was last built, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelLastBuildTime(final Long sisenseDatamodelLastBuildTime) {
            this.sisenseDatamodelLastBuildTime = sisenseDatamodelLastBuildTime;
            return self();
        }

        /**
         * Time (epoch) when this datamodel was last published, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelLastPublishTime(final Long sisenseDatamodelLastPublishTime) {
            this.sisenseDatamodelLastPublishTime = sisenseDatamodelLastPublishTime;
            return self();
        }

        /**
         * Time (epoch) when this datamodel was last built successfully, in milliseconds.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelLastSuccessfulBuildTime(final Long sisenseDatamodelLastSuccessfulBuildTime) {
            this.sisenseDatamodelLastSuccessfulBuildTime = sisenseDatamodelLastSuccessfulBuildTime;
            return self();
        }

        /**
         * Default relation type for this datamodel. 'extract' type Datamodels have regular relations by default. 'live' type Datamodels have direct relations by default.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelRelationType(final String sisenseDatamodelRelationType) {
            this.sisenseDatamodelRelationType = sisenseDatamodelRelationType;
            return self();
        }

        /**
         * Revision of this datamodel.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelRevision(final String sisenseDatamodelRevision) {
            this.sisenseDatamodelRevision = sisenseDatamodelRevision;
            return self();
        }

        /**
         * Hostname of the server on which this datamodel was created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelServer(final String sisenseDatamodelServer) {
            this.sisenseDatamodelServer = sisenseDatamodelServer;
            return self();
        }

        /**
         * Number of tables in this datamodel.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTableCount(final Long sisenseDatamodelTableCount) {
            this.sisenseDatamodelTableCount = sisenseDatamodelTableCount;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTable(final ISisenseDatamodelTable sisenseDatamodelTable) {
            if (this.sisenseDatamodelTables == null) this.sisenseDatamodelTables = new java.util.ArrayList<ISisenseDatamodelTable>();
            this.sisenseDatamodelTables.add(sisenseDatamodelTable);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTables(final java.util.Collection<? extends ISisenseDatamodelTable> sisenseDatamodelTables) {
            if (sisenseDatamodelTables == null) {
                throw new java.lang.NullPointerException("sisenseDatamodelTables cannot be null");
            }
            if (this.sisenseDatamodelTables == null) this.sisenseDatamodelTables = new java.util.ArrayList<ISisenseDatamodelTable>();
            this.sisenseDatamodelTables.addAll(sisenseDatamodelTables);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSisenseDatamodelTables() {
            if (this.sisenseDatamodelTables != null) this.sisenseDatamodelTables.clear();
            return self();
        }

        /**
         * Type of this datamodel, for example: 'extract' or 'custom'.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelType(final String sisenseDatamodelType) {
            this.sisenseDatamodelType = sisenseDatamodelType;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SisenseDatamodel.SisenseDatamodelBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sisenseDashboards=" + this.sisenseDashboards + ", sisenseDatamodelLastBuildTime=" + this.sisenseDatamodelLastBuildTime + ", sisenseDatamodelLastPublishTime=" + this.sisenseDatamodelLastPublishTime + ", sisenseDatamodelLastSuccessfulBuildTime=" + this.sisenseDatamodelLastSuccessfulBuildTime + ", sisenseDatamodelRelationType=" + this.sisenseDatamodelRelationType + ", sisenseDatamodelRevision=" + this.sisenseDatamodelRevision + ", sisenseDatamodelServer=" + this.sisenseDatamodelServer + ", sisenseDatamodelTableCount=" + this.sisenseDatamodelTableCount + ", sisenseDatamodelTables=" + this.sisenseDatamodelTables + ", sisenseDatamodelType=" + this.sisenseDatamodelType + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SisenseDatamodelBuilderImpl extends SisenseDatamodel.SisenseDatamodelBuilder<SisenseDatamodel, SisenseDatamodel.SisenseDatamodelBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SisenseDatamodelBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SisenseDatamodel.SisenseDatamodelBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SisenseDatamodel build() {
            return new SisenseDatamodel(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SisenseDatamodel(final SisenseDatamodel.SisenseDatamodelBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SisenseDatamodel.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<ISisenseDashboard> sisenseDashboards = new java.util.TreeSet<ISisenseDashboard>();
        if (b.sisenseDashboards != null) sisenseDashboards.addAll(b.sisenseDashboards);
        sisenseDashboards = java.util.Collections.unmodifiableSortedSet(sisenseDashboards);
        this.sisenseDashboards = sisenseDashboards;
        this.sisenseDatamodelLastBuildTime = b.sisenseDatamodelLastBuildTime;
        this.sisenseDatamodelLastPublishTime = b.sisenseDatamodelLastPublishTime;
        this.sisenseDatamodelLastSuccessfulBuildTime = b.sisenseDatamodelLastSuccessfulBuildTime;
        this.sisenseDatamodelRelationType = b.sisenseDatamodelRelationType;
        this.sisenseDatamodelRevision = b.sisenseDatamodelRevision;
        this.sisenseDatamodelServer = b.sisenseDatamodelServer;
        this.sisenseDatamodelTableCount = b.sisenseDatamodelTableCount;
        java.util.SortedSet<ISisenseDatamodelTable> sisenseDatamodelTables = new java.util.TreeSet<ISisenseDatamodelTable>();
        if (b.sisenseDatamodelTables != null) sisenseDatamodelTables.addAll(b.sisenseDatamodelTables);
        sisenseDatamodelTables = java.util.Collections.unmodifiableSortedSet(sisenseDatamodelTables);
        this.sisenseDatamodelTables = sisenseDatamodelTables;
        this.sisenseDatamodelType = b.sisenseDatamodelType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SisenseDatamodel.SisenseDatamodelBuilder<?, ?> _internal() {
        return new SisenseDatamodel.SisenseDatamodelBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SisenseDatamodel.SisenseDatamodelBuilder<?, ?> toBuilder() {
        return new SisenseDatamodel.SisenseDatamodelBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISisenseDashboard> getSisenseDashboards() {
        return this.sisenseDashboards;
    }

    /**
     * Time (epoch) when this datamodel was last built, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSisenseDatamodelLastBuildTime() {
        return this.sisenseDatamodelLastBuildTime;
    }

    /**
     * Time (epoch) when this datamodel was last published, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSisenseDatamodelLastPublishTime() {
        return this.sisenseDatamodelLastPublishTime;
    }

    /**
     * Time (epoch) when this datamodel was last built successfully, in milliseconds.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSisenseDatamodelLastSuccessfulBuildTime() {
        return this.sisenseDatamodelLastSuccessfulBuildTime;
    }

    /**
     * Default relation type for this datamodel. 'extract' type Datamodels have regular relations by default. 'live' type Datamodels have direct relations by default.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelRelationType() {
        return this.sisenseDatamodelRelationType;
    }

    /**
     * Revision of this datamodel.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelRevision() {
        return this.sisenseDatamodelRevision;
    }

    /**
     * Hostname of the server on which this datamodel was created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelServer() {
        return this.sisenseDatamodelServer;
    }

    /**
     * Number of tables in this datamodel.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSisenseDatamodelTableCount() {
        return this.sisenseDatamodelTableCount;
    }

    /**
     * Datamodel tables that exist within this datamodel.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISisenseDatamodelTable> getSisenseDatamodelTables() {
        return this.sisenseDatamodelTables;
    }

    /**
     * Type of this datamodel, for example: 'extract' or 'custom'.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelType() {
        return this.sisenseDatamodelType;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SisenseDatamodel)) return false;
        final SisenseDatamodel other = (SisenseDatamodel) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$sisenseDatamodelLastBuildTime = this.getSisenseDatamodelLastBuildTime();
        final java.lang.Object other$sisenseDatamodelLastBuildTime = other.getSisenseDatamodelLastBuildTime();
        if (this$sisenseDatamodelLastBuildTime == null ? other$sisenseDatamodelLastBuildTime != null : !this$sisenseDatamodelLastBuildTime.equals(other$sisenseDatamodelLastBuildTime)) return false;
        final java.lang.Object this$sisenseDatamodelLastPublishTime = this.getSisenseDatamodelLastPublishTime();
        final java.lang.Object other$sisenseDatamodelLastPublishTime = other.getSisenseDatamodelLastPublishTime();
        if (this$sisenseDatamodelLastPublishTime == null ? other$sisenseDatamodelLastPublishTime != null : !this$sisenseDatamodelLastPublishTime.equals(other$sisenseDatamodelLastPublishTime)) return false;
        final java.lang.Object this$sisenseDatamodelLastSuccessfulBuildTime = this.getSisenseDatamodelLastSuccessfulBuildTime();
        final java.lang.Object other$sisenseDatamodelLastSuccessfulBuildTime = other.getSisenseDatamodelLastSuccessfulBuildTime();
        if (this$sisenseDatamodelLastSuccessfulBuildTime == null ? other$sisenseDatamodelLastSuccessfulBuildTime != null : !this$sisenseDatamodelLastSuccessfulBuildTime.equals(other$sisenseDatamodelLastSuccessfulBuildTime)) return false;
        final java.lang.Object this$sisenseDatamodelTableCount = this.getSisenseDatamodelTableCount();
        final java.lang.Object other$sisenseDatamodelTableCount = other.getSisenseDatamodelTableCount();
        if (this$sisenseDatamodelTableCount == null ? other$sisenseDatamodelTableCount != null : !this$sisenseDatamodelTableCount.equals(other$sisenseDatamodelTableCount)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$sisenseDashboards = this.getSisenseDashboards();
        final java.lang.Object other$sisenseDashboards = other.getSisenseDashboards();
        if (this$sisenseDashboards == null ? other$sisenseDashboards != null : !this$sisenseDashboards.equals(other$sisenseDashboards)) return false;
        final java.lang.Object this$sisenseDatamodelRelationType = this.getSisenseDatamodelRelationType();
        final java.lang.Object other$sisenseDatamodelRelationType = other.getSisenseDatamodelRelationType();
        if (this$sisenseDatamodelRelationType == null ? other$sisenseDatamodelRelationType != null : !this$sisenseDatamodelRelationType.equals(other$sisenseDatamodelRelationType)) return false;
        final java.lang.Object this$sisenseDatamodelRevision = this.getSisenseDatamodelRevision();
        final java.lang.Object other$sisenseDatamodelRevision = other.getSisenseDatamodelRevision();
        if (this$sisenseDatamodelRevision == null ? other$sisenseDatamodelRevision != null : !this$sisenseDatamodelRevision.equals(other$sisenseDatamodelRevision)) return false;
        final java.lang.Object this$sisenseDatamodelServer = this.getSisenseDatamodelServer();
        final java.lang.Object other$sisenseDatamodelServer = other.getSisenseDatamodelServer();
        if (this$sisenseDatamodelServer == null ? other$sisenseDatamodelServer != null : !this$sisenseDatamodelServer.equals(other$sisenseDatamodelServer)) return false;
        final java.lang.Object this$sisenseDatamodelTables = this.getSisenseDatamodelTables();
        final java.lang.Object other$sisenseDatamodelTables = other.getSisenseDatamodelTables();
        if (this$sisenseDatamodelTables == null ? other$sisenseDatamodelTables != null : !this$sisenseDatamodelTables.equals(other$sisenseDatamodelTables)) return false;
        final java.lang.Object this$sisenseDatamodelType = this.getSisenseDatamodelType();
        final java.lang.Object other$sisenseDatamodelType = other.getSisenseDatamodelType();
        if (this$sisenseDatamodelType == null ? other$sisenseDatamodelType != null : !this$sisenseDatamodelType.equals(other$sisenseDatamodelType)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SisenseDatamodel;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $sisenseDatamodelLastBuildTime = this.getSisenseDatamodelLastBuildTime();
        result = result * PRIME + ($sisenseDatamodelLastBuildTime == null ? 43 : $sisenseDatamodelLastBuildTime.hashCode());
        final java.lang.Object $sisenseDatamodelLastPublishTime = this.getSisenseDatamodelLastPublishTime();
        result = result * PRIME + ($sisenseDatamodelLastPublishTime == null ? 43 : $sisenseDatamodelLastPublishTime.hashCode());
        final java.lang.Object $sisenseDatamodelLastSuccessfulBuildTime = this.getSisenseDatamodelLastSuccessfulBuildTime();
        result = result * PRIME + ($sisenseDatamodelLastSuccessfulBuildTime == null ? 43 : $sisenseDatamodelLastSuccessfulBuildTime.hashCode());
        final java.lang.Object $sisenseDatamodelTableCount = this.getSisenseDatamodelTableCount();
        result = result * PRIME + ($sisenseDatamodelTableCount == null ? 43 : $sisenseDatamodelTableCount.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $sisenseDashboards = this.getSisenseDashboards();
        result = result * PRIME + ($sisenseDashboards == null ? 43 : $sisenseDashboards.hashCode());
        final java.lang.Object $sisenseDatamodelRelationType = this.getSisenseDatamodelRelationType();
        result = result * PRIME + ($sisenseDatamodelRelationType == null ? 43 : $sisenseDatamodelRelationType.hashCode());
        final java.lang.Object $sisenseDatamodelRevision = this.getSisenseDatamodelRevision();
        result = result * PRIME + ($sisenseDatamodelRevision == null ? 43 : $sisenseDatamodelRevision.hashCode());
        final java.lang.Object $sisenseDatamodelServer = this.getSisenseDatamodelServer();
        result = result * PRIME + ($sisenseDatamodelServer == null ? 43 : $sisenseDatamodelServer.hashCode());
        final java.lang.Object $sisenseDatamodelTables = this.getSisenseDatamodelTables();
        result = result * PRIME + ($sisenseDatamodelTables == null ? 43 : $sisenseDatamodelTables.hashCode());
        final java.lang.Object $sisenseDatamodelType = this.getSisenseDatamodelType();
        result = result * PRIME + ($sisenseDatamodelType == null ? 43 : $sisenseDatamodelType.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SisenseDatamodel(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sisenseDashboards=" + this.getSisenseDashboards() + ", sisenseDatamodelLastBuildTime=" + this.getSisenseDatamodelLastBuildTime() + ", sisenseDatamodelLastPublishTime=" + this.getSisenseDatamodelLastPublishTime() + ", sisenseDatamodelLastSuccessfulBuildTime=" + this.getSisenseDatamodelLastSuccessfulBuildTime() + ", sisenseDatamodelRelationType=" + this.getSisenseDatamodelRelationType() + ", sisenseDatamodelRevision=" + this.getSisenseDatamodelRevision() + ", sisenseDatamodelServer=" + this.getSisenseDatamodelServer() + ", sisenseDatamodelTableCount=" + this.getSisenseDatamodelTableCount() + ", sisenseDatamodelTables=" + this.getSisenseDatamodelTables() + ", sisenseDatamodelType=" + this.getSisenseDatamodelType() + ")";
    }

    /**
     * Fixed typeName for SisenseDatamodels.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
