// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Sisense datamodel table in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SisenseDatamodelTable extends Asset implements ISisenseDatamodelTable, ISisense, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SisenseDatamodelTable.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseDatamodelTable";
    /**
     * Fixed typeName for SisenseDatamodelTables.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Datamodel in which this datamodel table exists.
     */
    @Attribute
    ISisenseDatamodel sisenseDatamodel;
    /**
     * Unique name of the datamodel in which this datamodel table exists.
     */
    @Attribute
    String sisenseDatamodelQualifiedName;
    /**
     * Number of columns present in this datamodel table.
     */
    @Attribute
    Long sisenseDatamodelTableColumnCount;
    /**
     * SQL expression of this datamodel table.
     */
    @Attribute
    String sisenseDatamodelTableExpression;
    /**
     * Whether this datamodel table is hidden in Sisense (true) or not (false).
     */
    @Attribute
    Boolean sisenseDatamodelTableIsHidden;
    /**
     * Whether this datamodel table is materialised (true) or not (false).
     */
    @Attribute
    Boolean sisenseDatamodelTableIsMaterialized;
    /**
     * JSON specifying the LiveQuery settings of this datamodel table.
     */
    @Attribute
    String sisenseDatamodelTableLiveQuerySettings;
    /**
     * JSON specifying the refresh schedule of this datamodel table.
     */
    @Attribute
    String sisenseDatamodelTableSchedule;
    /**
     * Type of this datamodel table, for example: 'base' for regular tables, 'custom' for SQL expression-based tables.
     */
    @Attribute
    String sisenseDatamodelTableType;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISisenseWidget> sisenseWidgets;

    /**
     * Builds the minimal object necessary to create a relationship to a SisenseDatamodelTable, from a potentially
     * more-complete SisenseDatamodelTable object.
     *
     * @return the minimal object necessary to relate to the SisenseDatamodelTable
     * @throws InvalidRequestException if any of the minimal set of required properties for a SisenseDatamodelTable relationship are not found in the initial object
     */
    @Override
    public SisenseDatamodelTable trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SisenseDatamodelTable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SisenseDatamodelTable assets will be included.
     *
     * @return a fluent search that includes all SisenseDatamodelTable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SisenseDatamodelTable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SisenseDatamodelTable assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SisenseDatamodelTable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SisenseDatamodelTable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SisenseDatamodelTables will be included
     * @return a fluent search that includes all SisenseDatamodelTable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SisenseDatamodelTable assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SisenseDatamodelTables will be included
     * @return a fluent search that includes all SisenseDatamodelTable assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SisenseDatamodelTable by GUID. Use this to create a relationship to this SisenseDatamodelTable,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SisenseDatamodelTable to reference
     * @return reference to a SisenseDatamodelTable that can be used for defining a relationship to a SisenseDatamodelTable
     */
    public static SisenseDatamodelTable refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SisenseDatamodelTable by GUID. Use this to create a relationship to this SisenseDatamodelTable,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SisenseDatamodelTable to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SisenseDatamodelTable that can be used for defining a relationship to a SisenseDatamodelTable
     */
    public static SisenseDatamodelTable refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SisenseDatamodelTable._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SisenseDatamodelTable by qualifiedName. Use this to create a relationship to this SisenseDatamodelTable,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SisenseDatamodelTable to reference
     * @return reference to a SisenseDatamodelTable that can be used for defining a relationship to a SisenseDatamodelTable
     */
    public static SisenseDatamodelTable refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SisenseDatamodelTable by qualifiedName. Use this to create a relationship to this SisenseDatamodelTable,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SisenseDatamodelTable to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SisenseDatamodelTable that can be used for defining a relationship to a SisenseDatamodelTable
     */
    public static SisenseDatamodelTable refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SisenseDatamodelTable._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SisenseDatamodelTable by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SisenseDatamodelTable to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SisenseDatamodelTable, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDatamodelTable does not exist or the provided GUID is not a SisenseDatamodelTable
     */
    @JsonIgnore
    public static SisenseDatamodelTable get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SisenseDatamodelTable by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SisenseDatamodelTable to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SisenseDatamodelTable, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDatamodelTable does not exist or the provided GUID is not a SisenseDatamodelTable
     */
    @JsonIgnore
    public static SisenseDatamodelTable get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SisenseDatamodelTable by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SisenseDatamodelTable to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SisenseDatamodelTable, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseDatamodelTable does not exist or the provided GUID is not a SisenseDatamodelTable
     */
    @JsonIgnore
    public static SisenseDatamodelTable get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SisenseDatamodelTable) {
                return (SisenseDatamodelTable) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SisenseDatamodelTable) {
                return (SisenseDatamodelTable) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SisenseDatamodelTable to active.
     *
     * @param qualifiedName for the SisenseDatamodelTable
     * @return true if the SisenseDatamodelTable is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SisenseDatamodelTable to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SisenseDatamodelTable
     * @return true if the SisenseDatamodelTable is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the minimal request necessary to update the SisenseDatamodelTable, as a builder
     */
    public static SisenseDatamodelTableBuilder<?, ?> updater(String qualifiedName, String name) {
        return SisenseDatamodelTable._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SisenseDatamodelTable, from a potentially
     * more-complete SisenseDatamodelTable object.
     *
     * @return the minimal object necessary to update the SisenseDatamodelTable, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SisenseDatamodelTable are not found in the initial object
     */
    @Override
    public SisenseDatamodelTableBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SisenseDatamodelTable's owners
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SisenseDatamodelTable, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan tenant on which to update the SisenseDatamodelTable's certificate
     * @param qualifiedName of the SisenseDatamodelTable
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SisenseDatamodelTable, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseDatamodelTable) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SisenseDatamodelTable's certificate
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan tenant on which to update the SisenseDatamodelTable's announcement
     * @param qualifiedName of the SisenseDatamodelTable
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseDatamodelTable) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan client from which to remove the SisenseDatamodelTable's announcement
     * @param qualifiedName of the SisenseDatamodelTable
     * @param name of the SisenseDatamodelTable
     * @return the updated SisenseDatamodelTable, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseDatamodelTable) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SisenseDatamodelTable.
     *
     * @param qualifiedName for the SisenseDatamodelTable
     * @param name human-readable name of the SisenseDatamodelTable
     * @param terms the list of terms to replace on the SisenseDatamodelTable, or null to remove all terms from the SisenseDatamodelTable
     * @return the SisenseDatamodelTable that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SisenseDatamodelTable's assigned terms
     * @param qualifiedName for the SisenseDatamodelTable
     * @param name human-readable name of the SisenseDatamodelTable
     * @param terms the list of terms to replace on the SisenseDatamodelTable, or null to remove all terms from the SisenseDatamodelTable
     * @return the SisenseDatamodelTable that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodelTable) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SisenseDatamodelTable, without replacing existing terms linked to the SisenseDatamodelTable.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodelTable's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SisenseDatamodelTable
     * @param terms the list of terms to append to the SisenseDatamodelTable
     * @return the SisenseDatamodelTable that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SisenseDatamodelTable, without replacing existing terms linked to the SisenseDatamodelTable.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodelTable's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SisenseDatamodelTable
     * @param qualifiedName for the SisenseDatamodelTable
     * @param terms the list of terms to append to the SisenseDatamodelTable
     * @return the SisenseDatamodelTable that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodelTable) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SisenseDatamodelTable, without replacing all existing terms linked to the SisenseDatamodelTable.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodelTable's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SisenseDatamodelTable
     * @param terms the list of terms to remove from the SisenseDatamodelTable, which must be referenced by GUID
     * @return the SisenseDatamodelTable that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SisenseDatamodelTable, without replacing all existing terms linked to the SisenseDatamodelTable.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodelTable's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SisenseDatamodelTable
     * @param qualifiedName for the SisenseDatamodelTable
     * @param terms the list of terms to remove from the SisenseDatamodelTable, which must be referenced by GUID
     * @return the SisenseDatamodelTable that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseDatamodelTable removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseDatamodelTable) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SisenseDatamodelTable, without replacing existing Atlan tags linked to the SisenseDatamodelTable.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodelTable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SisenseDatamodelTable
     */
    public static SisenseDatamodelTable appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SisenseDatamodelTable, without replacing existing Atlan tags linked to the SisenseDatamodelTable.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodelTable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SisenseDatamodelTable
     * @param qualifiedName of the SisenseDatamodelTable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SisenseDatamodelTable
     */
    public static SisenseDatamodelTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseDatamodelTable) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SisenseDatamodelTable, without replacing existing Atlan tags linked to the SisenseDatamodelTable.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodelTable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SisenseDatamodelTable
     */
    public static SisenseDatamodelTable appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SisenseDatamodelTable, without replacing existing Atlan tags linked to the SisenseDatamodelTable.
     * Note: this operation must make two API calls — one to retrieve the SisenseDatamodelTable's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SisenseDatamodelTable
     * @param qualifiedName of the SisenseDatamodelTable
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SisenseDatamodelTable
     */
    public static SisenseDatamodelTable appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseDatamodelTable) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SisenseDatamodelTable.
     *
     * @param qualifiedName of the SisenseDatamodelTable
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SisenseDatamodelTable
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SisenseDatamodelTable.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SisenseDatamodelTable
     * @param qualifiedName of the SisenseDatamodelTable
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SisenseDatamodelTable
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SisenseDatamodelTableBuilder<C extends SisenseDatamodelTable, B extends SisenseDatamodelTable.SisenseDatamodelTableBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ISisenseDatamodel sisenseDatamodel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sisenseDatamodelTableColumnCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelTableExpression;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean sisenseDatamodelTableIsHidden;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean sisenseDatamodelTableIsMaterialized;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelTableLiveQuerySettings;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelTableSchedule;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseDatamodelTableType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISisenseWidget> sisenseWidgets;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SisenseDatamodelTable.SisenseDatamodelTableBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SisenseDatamodelTable instance, final SisenseDatamodelTable.SisenseDatamodelTableBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseDatamodel(instance.sisenseDatamodel);
            b.sisenseDatamodelQualifiedName(instance.sisenseDatamodelQualifiedName);
            b.sisenseDatamodelTableColumnCount(instance.sisenseDatamodelTableColumnCount);
            b.sisenseDatamodelTableExpression(instance.sisenseDatamodelTableExpression);
            b.sisenseDatamodelTableIsHidden(instance.sisenseDatamodelTableIsHidden);
            b.sisenseDatamodelTableIsMaterialized(instance.sisenseDatamodelTableIsMaterialized);
            b.sisenseDatamodelTableLiveQuerySettings(instance.sisenseDatamodelTableLiveQuerySettings);
            b.sisenseDatamodelTableSchedule(instance.sisenseDatamodelTableSchedule);
            b.sisenseDatamodelTableType(instance.sisenseDatamodelTableType);
            b.sisenseWidgets(instance.sisenseWidgets == null ? java.util.Collections.<ISisenseWidget>emptySortedSet() : instance.sisenseWidgets);
        }

        /**
         * Fixed typeName for SisenseDatamodelTables.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        /**
         * Datamodel in which this datamodel table exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodel(final ISisenseDatamodel sisenseDatamodel) {
            this.sisenseDatamodel = sisenseDatamodel;
            return self();
        }

        /**
         * Unique name of the datamodel in which this datamodel table exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelQualifiedName(final String sisenseDatamodelQualifiedName) {
            this.sisenseDatamodelQualifiedName = sisenseDatamodelQualifiedName;
            return self();
        }

        /**
         * Number of columns present in this datamodel table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTableColumnCount(final Long sisenseDatamodelTableColumnCount) {
            this.sisenseDatamodelTableColumnCount = sisenseDatamodelTableColumnCount;
            return self();
        }

        /**
         * SQL expression of this datamodel table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTableExpression(final String sisenseDatamodelTableExpression) {
            this.sisenseDatamodelTableExpression = sisenseDatamodelTableExpression;
            return self();
        }

        /**
         * Whether this datamodel table is hidden in Sisense (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTableIsHidden(final Boolean sisenseDatamodelTableIsHidden) {
            this.sisenseDatamodelTableIsHidden = sisenseDatamodelTableIsHidden;
            return self();
        }

        /**
         * Whether this datamodel table is materialised (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTableIsMaterialized(final Boolean sisenseDatamodelTableIsMaterialized) {
            this.sisenseDatamodelTableIsMaterialized = sisenseDatamodelTableIsMaterialized;
            return self();
        }

        /**
         * JSON specifying the LiveQuery settings of this datamodel table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTableLiveQuerySettings(final String sisenseDatamodelTableLiveQuerySettings) {
            this.sisenseDatamodelTableLiveQuerySettings = sisenseDatamodelTableLiveQuerySettings;
            return self();
        }

        /**
         * JSON specifying the refresh schedule of this datamodel table.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTableSchedule(final String sisenseDatamodelTableSchedule) {
            this.sisenseDatamodelTableSchedule = sisenseDatamodelTableSchedule;
            return self();
        }

        /**
         * Type of this datamodel table, for example: 'base' for regular tables, 'custom' for SQL expression-based tables.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDatamodelTableType(final String sisenseDatamodelTableType) {
            this.sisenseDatamodelTableType = sisenseDatamodelTableType;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseWidget(final ISisenseWidget sisenseWidget) {
            if (this.sisenseWidgets == null) this.sisenseWidgets = new java.util.ArrayList<ISisenseWidget>();
            this.sisenseWidgets.add(sisenseWidget);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseWidgets(final java.util.Collection<? extends ISisenseWidget> sisenseWidgets) {
            if (sisenseWidgets == null) {
                throw new java.lang.NullPointerException("sisenseWidgets cannot be null");
            }
            if (this.sisenseWidgets == null) this.sisenseWidgets = new java.util.ArrayList<ISisenseWidget>();
            this.sisenseWidgets.addAll(sisenseWidgets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSisenseWidgets() {
            if (this.sisenseWidgets != null) this.sisenseWidgets.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SisenseDatamodelTable.SisenseDatamodelTableBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sisenseDatamodel=" + this.sisenseDatamodel + ", sisenseDatamodelQualifiedName=" + this.sisenseDatamodelQualifiedName + ", sisenseDatamodelTableColumnCount=" + this.sisenseDatamodelTableColumnCount + ", sisenseDatamodelTableExpression=" + this.sisenseDatamodelTableExpression + ", sisenseDatamodelTableIsHidden=" + this.sisenseDatamodelTableIsHidden + ", sisenseDatamodelTableIsMaterialized=" + this.sisenseDatamodelTableIsMaterialized + ", sisenseDatamodelTableLiveQuerySettings=" + this.sisenseDatamodelTableLiveQuerySettings + ", sisenseDatamodelTableSchedule=" + this.sisenseDatamodelTableSchedule + ", sisenseDatamodelTableType=" + this.sisenseDatamodelTableType + ", sisenseWidgets=" + this.sisenseWidgets + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SisenseDatamodelTableBuilderImpl extends SisenseDatamodelTable.SisenseDatamodelTableBuilder<SisenseDatamodelTable, SisenseDatamodelTable.SisenseDatamodelTableBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SisenseDatamodelTableBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SisenseDatamodelTable.SisenseDatamodelTableBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SisenseDatamodelTable build() {
            return new SisenseDatamodelTable(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SisenseDatamodelTable(final SisenseDatamodelTable.SisenseDatamodelTableBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SisenseDatamodelTable.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sisenseDatamodel = b.sisenseDatamodel;
        this.sisenseDatamodelQualifiedName = b.sisenseDatamodelQualifiedName;
        this.sisenseDatamodelTableColumnCount = b.sisenseDatamodelTableColumnCount;
        this.sisenseDatamodelTableExpression = b.sisenseDatamodelTableExpression;
        this.sisenseDatamodelTableIsHidden = b.sisenseDatamodelTableIsHidden;
        this.sisenseDatamodelTableIsMaterialized = b.sisenseDatamodelTableIsMaterialized;
        this.sisenseDatamodelTableLiveQuerySettings = b.sisenseDatamodelTableLiveQuerySettings;
        this.sisenseDatamodelTableSchedule = b.sisenseDatamodelTableSchedule;
        this.sisenseDatamodelTableType = b.sisenseDatamodelTableType;
        java.util.SortedSet<ISisenseWidget> sisenseWidgets = new java.util.TreeSet<ISisenseWidget>();
        if (b.sisenseWidgets != null) sisenseWidgets.addAll(b.sisenseWidgets);
        sisenseWidgets = java.util.Collections.unmodifiableSortedSet(sisenseWidgets);
        this.sisenseWidgets = sisenseWidgets;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SisenseDatamodelTable.SisenseDatamodelTableBuilder<?, ?> _internal() {
        return new SisenseDatamodelTable.SisenseDatamodelTableBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SisenseDatamodelTable.SisenseDatamodelTableBuilder<?, ?> toBuilder() {
        return new SisenseDatamodelTable.SisenseDatamodelTableBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Datamodel in which this datamodel table exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ISisenseDatamodel getSisenseDatamodel() {
        return this.sisenseDatamodel;
    }

    /**
     * Unique name of the datamodel in which this datamodel table exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelQualifiedName() {
        return this.sisenseDatamodelQualifiedName;
    }

    /**
     * Number of columns present in this datamodel table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSisenseDatamodelTableColumnCount() {
        return this.sisenseDatamodelTableColumnCount;
    }

    /**
     * SQL expression of this datamodel table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelTableExpression() {
        return this.sisenseDatamodelTableExpression;
    }

    /**
     * Whether this datamodel table is hidden in Sisense (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSisenseDatamodelTableIsHidden() {
        return this.sisenseDatamodelTableIsHidden;
    }

    /**
     * Whether this datamodel table is materialised (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSisenseDatamodelTableIsMaterialized() {
        return this.sisenseDatamodelTableIsMaterialized;
    }

    /**
     * JSON specifying the LiveQuery settings of this datamodel table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelTableLiveQuerySettings() {
        return this.sisenseDatamodelTableLiveQuerySettings;
    }

    /**
     * JSON specifying the refresh schedule of this datamodel table.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelTableSchedule() {
        return this.sisenseDatamodelTableSchedule;
    }

    /**
     * Type of this datamodel table, for example: 'base' for regular tables, 'custom' for SQL expression-based tables.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseDatamodelTableType() {
        return this.sisenseDatamodelTableType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISisenseWidget> getSisenseWidgets() {
        return this.sisenseWidgets;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SisenseDatamodelTable)) return false;
        final SisenseDatamodelTable other = (SisenseDatamodelTable) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$sisenseDatamodelTableColumnCount = this.getSisenseDatamodelTableColumnCount();
        final java.lang.Object other$sisenseDatamodelTableColumnCount = other.getSisenseDatamodelTableColumnCount();
        if (this$sisenseDatamodelTableColumnCount == null ? other$sisenseDatamodelTableColumnCount != null : !this$sisenseDatamodelTableColumnCount.equals(other$sisenseDatamodelTableColumnCount)) return false;
        final java.lang.Object this$sisenseDatamodelTableIsHidden = this.getSisenseDatamodelTableIsHidden();
        final java.lang.Object other$sisenseDatamodelTableIsHidden = other.getSisenseDatamodelTableIsHidden();
        if (this$sisenseDatamodelTableIsHidden == null ? other$sisenseDatamodelTableIsHidden != null : !this$sisenseDatamodelTableIsHidden.equals(other$sisenseDatamodelTableIsHidden)) return false;
        final java.lang.Object this$sisenseDatamodelTableIsMaterialized = this.getSisenseDatamodelTableIsMaterialized();
        final java.lang.Object other$sisenseDatamodelTableIsMaterialized = other.getSisenseDatamodelTableIsMaterialized();
        if (this$sisenseDatamodelTableIsMaterialized == null ? other$sisenseDatamodelTableIsMaterialized != null : !this$sisenseDatamodelTableIsMaterialized.equals(other$sisenseDatamodelTableIsMaterialized)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$sisenseDatamodel = this.getSisenseDatamodel();
        final java.lang.Object other$sisenseDatamodel = other.getSisenseDatamodel();
        if (this$sisenseDatamodel == null ? other$sisenseDatamodel != null : !this$sisenseDatamodel.equals(other$sisenseDatamodel)) return false;
        final java.lang.Object this$sisenseDatamodelQualifiedName = this.getSisenseDatamodelQualifiedName();
        final java.lang.Object other$sisenseDatamodelQualifiedName = other.getSisenseDatamodelQualifiedName();
        if (this$sisenseDatamodelQualifiedName == null ? other$sisenseDatamodelQualifiedName != null : !this$sisenseDatamodelQualifiedName.equals(other$sisenseDatamodelQualifiedName)) return false;
        final java.lang.Object this$sisenseDatamodelTableExpression = this.getSisenseDatamodelTableExpression();
        final java.lang.Object other$sisenseDatamodelTableExpression = other.getSisenseDatamodelTableExpression();
        if (this$sisenseDatamodelTableExpression == null ? other$sisenseDatamodelTableExpression != null : !this$sisenseDatamodelTableExpression.equals(other$sisenseDatamodelTableExpression)) return false;
        final java.lang.Object this$sisenseDatamodelTableLiveQuerySettings = this.getSisenseDatamodelTableLiveQuerySettings();
        final java.lang.Object other$sisenseDatamodelTableLiveQuerySettings = other.getSisenseDatamodelTableLiveQuerySettings();
        if (this$sisenseDatamodelTableLiveQuerySettings == null ? other$sisenseDatamodelTableLiveQuerySettings != null : !this$sisenseDatamodelTableLiveQuerySettings.equals(other$sisenseDatamodelTableLiveQuerySettings)) return false;
        final java.lang.Object this$sisenseDatamodelTableSchedule = this.getSisenseDatamodelTableSchedule();
        final java.lang.Object other$sisenseDatamodelTableSchedule = other.getSisenseDatamodelTableSchedule();
        if (this$sisenseDatamodelTableSchedule == null ? other$sisenseDatamodelTableSchedule != null : !this$sisenseDatamodelTableSchedule.equals(other$sisenseDatamodelTableSchedule)) return false;
        final java.lang.Object this$sisenseDatamodelTableType = this.getSisenseDatamodelTableType();
        final java.lang.Object other$sisenseDatamodelTableType = other.getSisenseDatamodelTableType();
        if (this$sisenseDatamodelTableType == null ? other$sisenseDatamodelTableType != null : !this$sisenseDatamodelTableType.equals(other$sisenseDatamodelTableType)) return false;
        final java.lang.Object this$sisenseWidgets = this.getSisenseWidgets();
        final java.lang.Object other$sisenseWidgets = other.getSisenseWidgets();
        if (this$sisenseWidgets == null ? other$sisenseWidgets != null : !this$sisenseWidgets.equals(other$sisenseWidgets)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SisenseDatamodelTable;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $sisenseDatamodelTableColumnCount = this.getSisenseDatamodelTableColumnCount();
        result = result * PRIME + ($sisenseDatamodelTableColumnCount == null ? 43 : $sisenseDatamodelTableColumnCount.hashCode());
        final java.lang.Object $sisenseDatamodelTableIsHidden = this.getSisenseDatamodelTableIsHidden();
        result = result * PRIME + ($sisenseDatamodelTableIsHidden == null ? 43 : $sisenseDatamodelTableIsHidden.hashCode());
        final java.lang.Object $sisenseDatamodelTableIsMaterialized = this.getSisenseDatamodelTableIsMaterialized();
        result = result * PRIME + ($sisenseDatamodelTableIsMaterialized == null ? 43 : $sisenseDatamodelTableIsMaterialized.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $sisenseDatamodel = this.getSisenseDatamodel();
        result = result * PRIME + ($sisenseDatamodel == null ? 43 : $sisenseDatamodel.hashCode());
        final java.lang.Object $sisenseDatamodelQualifiedName = this.getSisenseDatamodelQualifiedName();
        result = result * PRIME + ($sisenseDatamodelQualifiedName == null ? 43 : $sisenseDatamodelQualifiedName.hashCode());
        final java.lang.Object $sisenseDatamodelTableExpression = this.getSisenseDatamodelTableExpression();
        result = result * PRIME + ($sisenseDatamodelTableExpression == null ? 43 : $sisenseDatamodelTableExpression.hashCode());
        final java.lang.Object $sisenseDatamodelTableLiveQuerySettings = this.getSisenseDatamodelTableLiveQuerySettings();
        result = result * PRIME + ($sisenseDatamodelTableLiveQuerySettings == null ? 43 : $sisenseDatamodelTableLiveQuerySettings.hashCode());
        final java.lang.Object $sisenseDatamodelTableSchedule = this.getSisenseDatamodelTableSchedule();
        result = result * PRIME + ($sisenseDatamodelTableSchedule == null ? 43 : $sisenseDatamodelTableSchedule.hashCode());
        final java.lang.Object $sisenseDatamodelTableType = this.getSisenseDatamodelTableType();
        result = result * PRIME + ($sisenseDatamodelTableType == null ? 43 : $sisenseDatamodelTableType.hashCode());
        final java.lang.Object $sisenseWidgets = this.getSisenseWidgets();
        result = result * PRIME + ($sisenseWidgets == null ? 43 : $sisenseWidgets.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SisenseDatamodelTable(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sisenseDatamodel=" + this.getSisenseDatamodel() + ", sisenseDatamodelQualifiedName=" + this.getSisenseDatamodelQualifiedName() + ", sisenseDatamodelTableColumnCount=" + this.getSisenseDatamodelTableColumnCount() + ", sisenseDatamodelTableExpression=" + this.getSisenseDatamodelTableExpression() + ", sisenseDatamodelTableIsHidden=" + this.getSisenseDatamodelTableIsHidden() + ", sisenseDatamodelTableIsMaterialized=" + this.getSisenseDatamodelTableIsMaterialized() + ", sisenseDatamodelTableLiveQuerySettings=" + this.getSisenseDatamodelTableLiveQuerySettings() + ", sisenseDatamodelTableSchedule=" + this.getSisenseDatamodelTableSchedule() + ", sisenseDatamodelTableType=" + this.getSisenseDatamodelTableType() + ", sisenseWidgets=" + this.getSisenseWidgets() + ")";
    }

    /**
     * Fixed typeName for SisenseDatamodelTables.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
