// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Sisense folder in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SisenseFolder extends Asset implements ISisenseFolder, ISisense, IBI, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SisenseFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseFolder";
    /**
     * Fixed typeName for SisenseFolders.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * Sub-folders that exist within this folder.
     */
    @Attribute
    SortedSet<ISisenseFolder> sisenseChildFolders;
    /**
     * Dashboards that exist within this folder.
     */
    @Attribute
    SortedSet<ISisenseDashboard> sisenseDashboards;
    /**
     * Unique name of the parent folder in which this folder exists.
     */
    @Attribute
    String sisenseFolderParentFolderQualifiedName;
    /**
     * Folder in which this sub-folder exists.
     */
    @Attribute
    ISisenseFolder sisenseParentFolder;
    /**
     * Widgets that exist within this folder.
     */
    @Attribute
    SortedSet<ISisenseWidget> sisenseWidgets;

    /**
     * Builds the minimal object necessary to create a relationship to a SisenseFolder, from a potentially
     * more-complete SisenseFolder object.
     *
     * @return the minimal object necessary to relate to the SisenseFolder
     * @throws InvalidRequestException if any of the minimal set of required properties for a SisenseFolder relationship are not found in the initial object
     */
    @Override
    public SisenseFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SisenseFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SisenseFolder assets will be included.
     *
     * @return a fluent search that includes all SisenseFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SisenseFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SisenseFolder assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SisenseFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SisenseFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SisenseFolders will be included
     * @return a fluent search that includes all SisenseFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SisenseFolder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SisenseFolders will be included
     * @return a fluent search that includes all SisenseFolder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SisenseFolder by GUID. Use this to create a relationship to this SisenseFolder,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SisenseFolder to reference
     * @return reference to a SisenseFolder that can be used for defining a relationship to a SisenseFolder
     */
    public static SisenseFolder refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SisenseFolder by GUID. Use this to create a relationship to this SisenseFolder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SisenseFolder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SisenseFolder that can be used for defining a relationship to a SisenseFolder
     */
    public static SisenseFolder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SisenseFolder._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SisenseFolder by qualifiedName. Use this to create a relationship to this SisenseFolder,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SisenseFolder to reference
     * @return reference to a SisenseFolder that can be used for defining a relationship to a SisenseFolder
     */
    public static SisenseFolder refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SisenseFolder by qualifiedName. Use this to create a relationship to this SisenseFolder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SisenseFolder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SisenseFolder that can be used for defining a relationship to a SisenseFolder
     */
    public static SisenseFolder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SisenseFolder._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SisenseFolder by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SisenseFolder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SisenseFolder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseFolder does not exist or the provided GUID is not a SisenseFolder
     */
    @JsonIgnore
    public static SisenseFolder get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SisenseFolder by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SisenseFolder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SisenseFolder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseFolder does not exist or the provided GUID is not a SisenseFolder
     */
    @JsonIgnore
    public static SisenseFolder get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SisenseFolder by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SisenseFolder to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SisenseFolder, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SisenseFolder does not exist or the provided GUID is not a SisenseFolder
     */
    @JsonIgnore
    public static SisenseFolder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SisenseFolder) {
                return (SisenseFolder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SisenseFolder) {
                return (SisenseFolder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SisenseFolder to active.
     *
     * @param qualifiedName for the SisenseFolder
     * @return true if the SisenseFolder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SisenseFolder to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SisenseFolder
     * @return true if the SisenseFolder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the minimal request necessary to update the SisenseFolder, as a builder
     */
    public static SisenseFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return SisenseFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SisenseFolder, from a potentially
     * more-complete SisenseFolder object.
     *
     * @return the minimal object necessary to update the SisenseFolder, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SisenseFolder are not found in the initial object
     */
    @Override
    public SisenseFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SisenseFolder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SisenseFolder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SisenseFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SisenseFolder's owners
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SisenseFolder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SisenseFolder.
     *
     * @param client connectivity to the Atlan tenant on which to update the SisenseFolder's certificate
     * @param qualifiedName of the SisenseFolder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SisenseFolder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseFolder) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SisenseFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SisenseFolder's certificate
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SisenseFolder.
     *
     * @param client connectivity to the Atlan tenant on which to update the SisenseFolder's announcement
     * @param qualifiedName of the SisenseFolder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseFolder) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SisenseFolder.
     *
     * @param client connectivity to the Atlan client from which to remove the SisenseFolder's announcement
     * @param qualifiedName of the SisenseFolder
     * @param name of the SisenseFolder
     * @return the updated SisenseFolder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SisenseFolder.
     *
     * @param qualifiedName for the SisenseFolder
     * @param name human-readable name of the SisenseFolder
     * @param terms the list of terms to replace on the SisenseFolder, or null to remove all terms from the SisenseFolder
     * @return the SisenseFolder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SisenseFolder.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SisenseFolder's assigned terms
     * @param qualifiedName for the SisenseFolder
     * @param name human-readable name of the SisenseFolder
     * @param terms the list of terms to replace on the SisenseFolder, or null to remove all terms from the SisenseFolder
     * @return the SisenseFolder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseFolder) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SisenseFolder, without replacing existing terms linked to the SisenseFolder.
     * Note: this operation must make two API calls — one to retrieve the SisenseFolder's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SisenseFolder
     * @param terms the list of terms to append to the SisenseFolder
     * @return the SisenseFolder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SisenseFolder, without replacing existing terms linked to the SisenseFolder.
     * Note: this operation must make two API calls — one to retrieve the SisenseFolder's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SisenseFolder
     * @param qualifiedName for the SisenseFolder
     * @param terms the list of terms to append to the SisenseFolder
     * @return the SisenseFolder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseFolder) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SisenseFolder, without replacing all existing terms linked to the SisenseFolder.
     * Note: this operation must make two API calls — one to retrieve the SisenseFolder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SisenseFolder
     * @param terms the list of terms to remove from the SisenseFolder, which must be referenced by GUID
     * @return the SisenseFolder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SisenseFolder, without replacing all existing terms linked to the SisenseFolder.
     * Note: this operation must make two API calls — one to retrieve the SisenseFolder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SisenseFolder
     * @param qualifiedName for the SisenseFolder
     * @param terms the list of terms to remove from the SisenseFolder, which must be referenced by GUID
     * @return the SisenseFolder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SisenseFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseFolder) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SisenseFolder, without replacing existing Atlan tags linked to the SisenseFolder.
     * Note: this operation must make two API calls — one to retrieve the SisenseFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SisenseFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SisenseFolder
     */
    public static SisenseFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SisenseFolder, without replacing existing Atlan tags linked to the SisenseFolder.
     * Note: this operation must make two API calls — one to retrieve the SisenseFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SisenseFolder
     * @param qualifiedName of the SisenseFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SisenseFolder
     */
    public static SisenseFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseFolder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SisenseFolder, without replacing existing Atlan tags linked to the SisenseFolder.
     * Note: this operation must make two API calls — one to retrieve the SisenseFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SisenseFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SisenseFolder
     */
    public static SisenseFolder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SisenseFolder, without replacing existing Atlan tags linked to the SisenseFolder.
     * Note: this operation must make two API calls — one to retrieve the SisenseFolder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SisenseFolder
     * @param qualifiedName of the SisenseFolder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SisenseFolder
     */
    public static SisenseFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseFolder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SisenseFolder.
     *
     * @param qualifiedName of the SisenseFolder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SisenseFolder
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SisenseFolder.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SisenseFolder
     * @param qualifiedName of the SisenseFolder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SisenseFolder
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SisenseFolderBuilder<C extends SisenseFolder, B extends SisenseFolder.SisenseFolderBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISisenseFolder> sisenseChildFolders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISisenseDashboard> sisenseDashboards;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sisenseFolderParentFolderQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ISisenseFolder sisenseParentFolder;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISisenseWidget> sisenseWidgets;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SisenseFolder.SisenseFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SisenseFolder instance, final SisenseFolder.SisenseFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseChildFolders(instance.sisenseChildFolders == null ? java.util.Collections.<ISisenseFolder>emptySortedSet() : instance.sisenseChildFolders);
            b.sisenseDashboards(instance.sisenseDashboards == null ? java.util.Collections.<ISisenseDashboard>emptySortedSet() : instance.sisenseDashboards);
            b.sisenseFolderParentFolderQualifiedName(instance.sisenseFolderParentFolderQualifiedName);
            b.sisenseParentFolder(instance.sisenseParentFolder);
            b.sisenseWidgets(instance.sisenseWidgets == null ? java.util.Collections.<ISisenseWidget>emptySortedSet() : instance.sisenseWidgets);
        }

        /**
         * Fixed typeName for SisenseFolders.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseChildFolder(final ISisenseFolder sisenseChildFolder) {
            if (this.sisenseChildFolders == null) this.sisenseChildFolders = new java.util.ArrayList<ISisenseFolder>();
            this.sisenseChildFolders.add(sisenseChildFolder);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseChildFolders(final java.util.Collection<? extends ISisenseFolder> sisenseChildFolders) {
            if (sisenseChildFolders == null) {
                throw new java.lang.NullPointerException("sisenseChildFolders cannot be null");
            }
            if (this.sisenseChildFolders == null) this.sisenseChildFolders = new java.util.ArrayList<ISisenseFolder>();
            this.sisenseChildFolders.addAll(sisenseChildFolders);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSisenseChildFolders() {
            if (this.sisenseChildFolders != null) this.sisenseChildFolders.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDashboard(final ISisenseDashboard sisenseDashboard) {
            if (this.sisenseDashboards == null) this.sisenseDashboards = new java.util.ArrayList<ISisenseDashboard>();
            this.sisenseDashboards.add(sisenseDashboard);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseDashboards(final java.util.Collection<? extends ISisenseDashboard> sisenseDashboards) {
            if (sisenseDashboards == null) {
                throw new java.lang.NullPointerException("sisenseDashboards cannot be null");
            }
            if (this.sisenseDashboards == null) this.sisenseDashboards = new java.util.ArrayList<ISisenseDashboard>();
            this.sisenseDashboards.addAll(sisenseDashboards);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSisenseDashboards() {
            if (this.sisenseDashboards != null) this.sisenseDashboards.clear();
            return self();
        }

        /**
         * Unique name of the parent folder in which this folder exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseFolderParentFolderQualifiedName(final String sisenseFolderParentFolderQualifiedName) {
            this.sisenseFolderParentFolderQualifiedName = sisenseFolderParentFolderQualifiedName;
            return self();
        }

        /**
         * Folder in which this sub-folder exists.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseParentFolder(final ISisenseFolder sisenseParentFolder) {
            this.sisenseParentFolder = sisenseParentFolder;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseWidget(final ISisenseWidget sisenseWidget) {
            if (this.sisenseWidgets == null) this.sisenseWidgets = new java.util.ArrayList<ISisenseWidget>();
            this.sisenseWidgets.add(sisenseWidget);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sisenseWidgets(final java.util.Collection<? extends ISisenseWidget> sisenseWidgets) {
            if (sisenseWidgets == null) {
                throw new java.lang.NullPointerException("sisenseWidgets cannot be null");
            }
            if (this.sisenseWidgets == null) this.sisenseWidgets = new java.util.ArrayList<ISisenseWidget>();
            this.sisenseWidgets.addAll(sisenseWidgets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSisenseWidgets() {
            if (this.sisenseWidgets != null) this.sisenseWidgets.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SisenseFolder.SisenseFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sisenseChildFolders=" + this.sisenseChildFolders + ", sisenseDashboards=" + this.sisenseDashboards + ", sisenseFolderParentFolderQualifiedName=" + this.sisenseFolderParentFolderQualifiedName + ", sisenseParentFolder=" + this.sisenseParentFolder + ", sisenseWidgets=" + this.sisenseWidgets + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SisenseFolderBuilderImpl extends SisenseFolder.SisenseFolderBuilder<SisenseFolder, SisenseFolder.SisenseFolderBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SisenseFolderBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SisenseFolder.SisenseFolderBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SisenseFolder build() {
            return new SisenseFolder(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SisenseFolder(final SisenseFolder.SisenseFolderBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SisenseFolder.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<ISisenseFolder> sisenseChildFolders = new java.util.TreeSet<ISisenseFolder>();
        if (b.sisenseChildFolders != null) sisenseChildFolders.addAll(b.sisenseChildFolders);
        sisenseChildFolders = java.util.Collections.unmodifiableSortedSet(sisenseChildFolders);
        this.sisenseChildFolders = sisenseChildFolders;
        java.util.SortedSet<ISisenseDashboard> sisenseDashboards = new java.util.TreeSet<ISisenseDashboard>();
        if (b.sisenseDashboards != null) sisenseDashboards.addAll(b.sisenseDashboards);
        sisenseDashboards = java.util.Collections.unmodifiableSortedSet(sisenseDashboards);
        this.sisenseDashboards = sisenseDashboards;
        this.sisenseFolderParentFolderQualifiedName = b.sisenseFolderParentFolderQualifiedName;
        this.sisenseParentFolder = b.sisenseParentFolder;
        java.util.SortedSet<ISisenseWidget> sisenseWidgets = new java.util.TreeSet<ISisenseWidget>();
        if (b.sisenseWidgets != null) sisenseWidgets.addAll(b.sisenseWidgets);
        sisenseWidgets = java.util.Collections.unmodifiableSortedSet(sisenseWidgets);
        this.sisenseWidgets = sisenseWidgets;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SisenseFolder.SisenseFolderBuilder<?, ?> _internal() {
        return new SisenseFolder.SisenseFolderBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SisenseFolder.SisenseFolderBuilder<?, ?> toBuilder() {
        return new SisenseFolder.SisenseFolderBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * Sub-folders that exist within this folder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISisenseFolder> getSisenseChildFolders() {
        return this.sisenseChildFolders;
    }

    /**
     * Dashboards that exist within this folder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISisenseDashboard> getSisenseDashboards() {
        return this.sisenseDashboards;
    }

    /**
     * Unique name of the parent folder in which this folder exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSisenseFolderParentFolderQualifiedName() {
        return this.sisenseFolderParentFolderQualifiedName;
    }

    /**
     * Folder in which this sub-folder exists.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ISisenseFolder getSisenseParentFolder() {
        return this.sisenseParentFolder;
    }

    /**
     * Widgets that exist within this folder.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISisenseWidget> getSisenseWidgets() {
        return this.sisenseWidgets;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SisenseFolder)) return false;
        final SisenseFolder other = (SisenseFolder) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$sisenseChildFolders = this.getSisenseChildFolders();
        final java.lang.Object other$sisenseChildFolders = other.getSisenseChildFolders();
        if (this$sisenseChildFolders == null ? other$sisenseChildFolders != null : !this$sisenseChildFolders.equals(other$sisenseChildFolders)) return false;
        final java.lang.Object this$sisenseDashboards = this.getSisenseDashboards();
        final java.lang.Object other$sisenseDashboards = other.getSisenseDashboards();
        if (this$sisenseDashboards == null ? other$sisenseDashboards != null : !this$sisenseDashboards.equals(other$sisenseDashboards)) return false;
        final java.lang.Object this$sisenseFolderParentFolderQualifiedName = this.getSisenseFolderParentFolderQualifiedName();
        final java.lang.Object other$sisenseFolderParentFolderQualifiedName = other.getSisenseFolderParentFolderQualifiedName();
        if (this$sisenseFolderParentFolderQualifiedName == null ? other$sisenseFolderParentFolderQualifiedName != null : !this$sisenseFolderParentFolderQualifiedName.equals(other$sisenseFolderParentFolderQualifiedName)) return false;
        final java.lang.Object this$sisenseParentFolder = this.getSisenseParentFolder();
        final java.lang.Object other$sisenseParentFolder = other.getSisenseParentFolder();
        if (this$sisenseParentFolder == null ? other$sisenseParentFolder != null : !this$sisenseParentFolder.equals(other$sisenseParentFolder)) return false;
        final java.lang.Object this$sisenseWidgets = this.getSisenseWidgets();
        final java.lang.Object other$sisenseWidgets = other.getSisenseWidgets();
        if (this$sisenseWidgets == null ? other$sisenseWidgets != null : !this$sisenseWidgets.equals(other$sisenseWidgets)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SisenseFolder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $sisenseChildFolders = this.getSisenseChildFolders();
        result = result * PRIME + ($sisenseChildFolders == null ? 43 : $sisenseChildFolders.hashCode());
        final java.lang.Object $sisenseDashboards = this.getSisenseDashboards();
        result = result * PRIME + ($sisenseDashboards == null ? 43 : $sisenseDashboards.hashCode());
        final java.lang.Object $sisenseFolderParentFolderQualifiedName = this.getSisenseFolderParentFolderQualifiedName();
        result = result * PRIME + ($sisenseFolderParentFolderQualifiedName == null ? 43 : $sisenseFolderParentFolderQualifiedName.hashCode());
        final java.lang.Object $sisenseParentFolder = this.getSisenseParentFolder();
        result = result * PRIME + ($sisenseParentFolder == null ? 43 : $sisenseParentFolder.hashCode());
        final java.lang.Object $sisenseWidgets = this.getSisenseWidgets();
        result = result * PRIME + ($sisenseWidgets == null ? 43 : $sisenseWidgets.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SisenseFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sisenseChildFolders=" + this.getSisenseChildFolders() + ", sisenseDashboards=" + this.getSisenseDashboards() + ", sisenseFolderParentFolderQualifiedName=" + this.getSisenseFolderParentFolderQualifiedName() + ", sisenseParentFolder=" + this.getSisenseParentFolder() + ", sisenseWidgets=" + this.getSisenseWidgets() + ")";
    }

    /**
     * Fixed typeName for SisenseFolders.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
