// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Instance of a Soda check in Atlan.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class SodaCheck extends Asset implements ISodaCheck, ISoda, IDataQuality, ICatalog, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(SodaCheck.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SodaCheck";
    /**
     * Fixed typeName for SodaChecks.
     */
    String typeName;
    /**
     * Tasks to which this asset provides input.
     */
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    /**
     * Processes to which this asset provides input.
     */
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    /**
     * Tasks from which this asset is output.
     */
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    /**
     * Processes from which this asset is produced as output.
     */
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    /**
     * TBC
     */
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAsset> sodaCheckAssets;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IColumn> sodaCheckColumns;
    /**
     * Definition of the check in Soda.
     */
    @Attribute
    String sodaCheckDefinition;
    /**
     * Status of the check in Soda.
     */
    @Attribute
    String sodaCheckEvaluationStatus;
    /**
     * Identifier of the check in Soda.
     */
    @Attribute
    String sodaCheckId;
    /**
     * TBC
     */
    @Attribute
    Long sodaCheckIncidentCount;
    /**
     * TBC
     */
    @Attribute
    @Date
    Long sodaCheckLastScanAt;

    /**
     * Builds the minimal object necessary to create a relationship to a SodaCheck, from a potentially
     * more-complete SodaCheck object.
     *
     * @return the minimal object necessary to relate to the SodaCheck
     * @throws InvalidRequestException if any of the minimal set of required properties for a SodaCheck relationship are not found in the initial object
     */
    @Override
    public SodaCheck trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all SodaCheck assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SodaCheck assets will be included.
     *
     * @return a fluent search that includes all SodaCheck assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all SodaCheck assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) SodaCheck assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all SodaCheck assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all SodaCheck assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) SodaChecks will be included
     * @return a fluent search that includes all SodaCheck assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all SodaCheck assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) SodaChecks will be included
     * @return a fluent search that includes all SodaCheck assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a SodaCheck by GUID. Use this to create a relationship to this SodaCheck,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the SodaCheck to reference
     * @return reference to a SodaCheck that can be used for defining a relationship to a SodaCheck
     */
    public static SodaCheck refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SodaCheck by GUID. Use this to create a relationship to this SodaCheck,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the SodaCheck to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SodaCheck that can be used for defining a relationship to a SodaCheck
     */
    public static SodaCheck refByGuid(String guid, Reference.SaveSemantic semantic) {
        return SodaCheck._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a SodaCheck by qualifiedName. Use this to create a relationship to this SodaCheck,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the SodaCheck to reference
     * @return reference to a SodaCheck that can be used for defining a relationship to a SodaCheck
     */
    public static SodaCheck refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a SodaCheck by qualifiedName. Use this to create a relationship to this SodaCheck,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the SodaCheck to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a SodaCheck that can be used for defining a relationship to a SodaCheck
     */
    public static SodaCheck refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return SodaCheck._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a SodaCheck by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the SodaCheck to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SodaCheck, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SodaCheck does not exist or the provided GUID is not a SodaCheck
     */
    @JsonIgnore
    public static SodaCheck get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a SodaCheck by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SodaCheck to retrieve, either its GUID or its full qualifiedName
     * @return the requested full SodaCheck, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SodaCheck does not exist or the provided GUID is not a SodaCheck
     */
    @JsonIgnore
    public static SodaCheck get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a SodaCheck by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the SodaCheck to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full SodaCheck, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the SodaCheck does not exist or the provided GUID is not a SodaCheck
     */
    @JsonIgnore
    public static SodaCheck get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof SodaCheck) {
                return (SodaCheck) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof SodaCheck) {
                return (SodaCheck) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) SodaCheck to active.
     *
     * @param qualifiedName for the SodaCheck
     * @return true if the SodaCheck is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) SodaCheck to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the SodaCheck
     * @return true if the SodaCheck is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the minimal request necessary to update the SodaCheck, as a builder
     */
    public static SodaCheckBuilder<?, ?> updater(String qualifiedName, String name) {
        return SodaCheck._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a SodaCheck, from a potentially
     * more-complete SodaCheck object.
     *
     * @return the minimal object necessary to update the SodaCheck, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for SodaCheck are not found in the initial object
     */
    @Override
    public SodaCheckBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a SodaCheck.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a SodaCheck.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a SodaCheck.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SodaCheck's owners
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SodaCheck, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a SodaCheck.
     *
     * @param client connectivity to the Atlan tenant on which to update the SodaCheck's certificate
     * @param qualifiedName of the SodaCheck
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated SodaCheck, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SodaCheck) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a SodaCheck.
     *
     * @param client connectivity to the Atlan tenant from which to remove the SodaCheck's certificate
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a SodaCheck.
     *
     * @param client connectivity to the Atlan tenant on which to update the SodaCheck's announcement
     * @param qualifiedName of the SodaCheck
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SodaCheck) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a SodaCheck.
     *
     * @param client connectivity to the Atlan client from which to remove the SodaCheck's announcement
     * @param qualifiedName of the SodaCheck
     * @param name of the SodaCheck
     * @return the updated SodaCheck, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SodaCheck) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the SodaCheck.
     *
     * @param qualifiedName for the SodaCheck
     * @param name human-readable name of the SodaCheck
     * @param terms the list of terms to replace on the SodaCheck, or null to remove all terms from the SodaCheck
     * @return the SodaCheck that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SodaCheck replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the SodaCheck.
     *
     * @param client connectivity to the Atlan tenant on which to replace the SodaCheck's assigned terms
     * @param qualifiedName for the SodaCheck
     * @param name human-readable name of the SodaCheck
     * @param terms the list of terms to replace on the SodaCheck, or null to remove all terms from the SodaCheck
     * @return the SodaCheck that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static SodaCheck replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SodaCheck) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the SodaCheck, without replacing existing terms linked to the SodaCheck.
     * Note: this operation must make two API calls — one to retrieve the SodaCheck's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the SodaCheck
     * @param terms the list of terms to append to the SodaCheck
     * @return the SodaCheck that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SodaCheck appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the SodaCheck, without replacing existing terms linked to the SodaCheck.
     * Note: this operation must make two API calls — one to retrieve the SodaCheck's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the SodaCheck
     * @param qualifiedName for the SodaCheck
     * @param terms the list of terms to append to the SodaCheck
     * @return the SodaCheck that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static SodaCheck appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SodaCheck) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a SodaCheck, without replacing all existing terms linked to the SodaCheck.
     * Note: this operation must make two API calls — one to retrieve the SodaCheck's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the SodaCheck
     * @param terms the list of terms to remove from the SodaCheck, which must be referenced by GUID
     * @return the SodaCheck that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a SodaCheck, without replacing all existing terms linked to the SodaCheck.
     * Note: this operation must make two API calls — one to retrieve the SodaCheck's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the SodaCheck
     * @param qualifiedName for the SodaCheck
     * @param terms the list of terms to remove from the SodaCheck, which must be referenced by GUID
     * @return the SodaCheck that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static SodaCheck removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SodaCheck) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a SodaCheck, without replacing existing Atlan tags linked to the SodaCheck.
     * Note: this operation must make two API calls — one to retrieve the SodaCheck's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SodaCheck
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SodaCheck
     */
    public static SodaCheck appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SodaCheck, without replacing existing Atlan tags linked to the SodaCheck.
     * Note: this operation must make two API calls — one to retrieve the SodaCheck's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SodaCheck
     * @param qualifiedName of the SodaCheck
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated SodaCheck
     */
    public static SodaCheck appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SodaCheck) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a SodaCheck, without replacing existing Atlan tags linked to the SodaCheck.
     * Note: this operation must make two API calls — one to retrieve the SodaCheck's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the SodaCheck
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SodaCheck
     */
    public static SodaCheck appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a SodaCheck, without replacing existing Atlan tags linked to the SodaCheck.
     * Note: this operation must make two API calls — one to retrieve the SodaCheck's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the SodaCheck
     * @param qualifiedName of the SodaCheck
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated SodaCheck
     */
    public static SodaCheck appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SodaCheck) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a SodaCheck.
     *
     * @param qualifiedName of the SodaCheck
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SodaCheck
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a SodaCheck.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a SodaCheck
     * @param qualifiedName of the SodaCheck
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the SodaCheck
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class SodaCheckBuilder<C extends SodaCheck, B extends SodaCheck.SodaCheckBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> inputToAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> inputToProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> inputToSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAirflowTask> outputFromAirflowTasks;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ILineageProcess> outputFromProcesses;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ISparkJob> outputFromSparkJobs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAsset> sodaCheckAssets;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IColumn> sodaCheckColumns;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sodaCheckDefinition;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sodaCheckEvaluationStatus;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String sodaCheckId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sodaCheckIncidentCount;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long sodaCheckLastScanAt;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            SodaCheck.SodaCheckBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final SodaCheck instance, final SodaCheck.SodaCheckBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? java.util.Collections.<IAirflowTask>emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? java.util.Collections.<ILineageProcess>emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? java.util.Collections.<ISparkJob>emptySortedSet() : instance.outputFromSparkJobs);
            b.sodaCheckAssets(instance.sodaCheckAssets == null ? java.util.Collections.<IAsset>emptySortedSet() : instance.sodaCheckAssets);
            b.sodaCheckColumns(instance.sodaCheckColumns == null ? java.util.Collections.<IColumn>emptySortedSet() : instance.sodaCheckColumns);
            b.sodaCheckDefinition(instance.sodaCheckDefinition);
            b.sodaCheckEvaluationStatus(instance.sodaCheckEvaluationStatus);
            b.sodaCheckId(instance.sodaCheckId);
            b.sodaCheckIncidentCount(instance.sodaCheckIncidentCount);
            b.sodaCheckLastScanAt(instance.sodaCheckLastScanAt);
        }

        /**
         * Fixed typeName for SodaChecks.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTask(final IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToAirflowTasks(final java.util.Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new java.lang.NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) this.inputToAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) this.inputToAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcess(final ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.add(inputToProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToProcesses(final java.util.Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new java.lang.NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) this.inputToProcesses = new java.util.ArrayList<ILineageProcess>();
            this.inputToProcesses.addAll(inputToProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) this.inputToProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJob(final ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.add(inputToSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B inputToSparkJobs(final java.util.Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new java.lang.NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) this.inputToSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) this.inputToSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTask(final IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromAirflowTasks(final java.util.Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new java.lang.NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) this.outputFromAirflowTasks = new java.util.ArrayList<IAirflowTask>();
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) this.outputFromAirflowTasks.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcess(final ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.add(outputFromProcess);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromProcesses(final java.util.Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new java.lang.NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) this.outputFromProcesses = new java.util.ArrayList<ILineageProcess>();
            this.outputFromProcesses.addAll(outputFromProcesses);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) this.outputFromProcesses.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJob(final ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B outputFromSparkJobs(final java.util.Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new java.lang.NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) this.outputFromSparkJobs = new java.util.ArrayList<ISparkJob>();
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) this.outputFromSparkJobs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckAsset(final IAsset sodaCheckAsset) {
            if (this.sodaCheckAssets == null) this.sodaCheckAssets = new java.util.ArrayList<IAsset>();
            this.sodaCheckAssets.add(sodaCheckAsset);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckAssets(final java.util.Collection<? extends IAsset> sodaCheckAssets) {
            if (sodaCheckAssets == null) {
                throw new java.lang.NullPointerException("sodaCheckAssets cannot be null");
            }
            if (this.sodaCheckAssets == null) this.sodaCheckAssets = new java.util.ArrayList<IAsset>();
            this.sodaCheckAssets.addAll(sodaCheckAssets);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSodaCheckAssets() {
            if (this.sodaCheckAssets != null) this.sodaCheckAssets.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckColumn(final IColumn sodaCheckColumn) {
            if (this.sodaCheckColumns == null) this.sodaCheckColumns = new java.util.ArrayList<IColumn>();
            this.sodaCheckColumns.add(sodaCheckColumn);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckColumns(final java.util.Collection<? extends IColumn> sodaCheckColumns) {
            if (sodaCheckColumns == null) {
                throw new java.lang.NullPointerException("sodaCheckColumns cannot be null");
            }
            if (this.sodaCheckColumns == null) this.sodaCheckColumns = new java.util.ArrayList<IColumn>();
            this.sodaCheckColumns.addAll(sodaCheckColumns);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearSodaCheckColumns() {
            if (this.sodaCheckColumns != null) this.sodaCheckColumns.clear();
            return self();
        }

        /**
         * Definition of the check in Soda.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckDefinition(final String sodaCheckDefinition) {
            this.sodaCheckDefinition = sodaCheckDefinition;
            return self();
        }

        /**
         * Status of the check in Soda.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckEvaluationStatus(final String sodaCheckEvaluationStatus) {
            this.sodaCheckEvaluationStatus = sodaCheckEvaluationStatus;
            return self();
        }

        /**
         * Identifier of the check in Soda.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckId(final String sodaCheckId) {
            this.sodaCheckId = sodaCheckId;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckIncidentCount(final Long sodaCheckIncidentCount) {
            this.sodaCheckIncidentCount = sodaCheckIncidentCount;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B sodaCheckLastScanAt(final Long sodaCheckLastScanAt) {
            this.sodaCheckLastScanAt = sodaCheckLastScanAt;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SodaCheck.SodaCheckBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sodaCheckAssets=" + this.sodaCheckAssets + ", sodaCheckColumns=" + this.sodaCheckColumns + ", sodaCheckDefinition=" + this.sodaCheckDefinition + ", sodaCheckEvaluationStatus=" + this.sodaCheckEvaluationStatus + ", sodaCheckId=" + this.sodaCheckId + ", sodaCheckIncidentCount=" + this.sodaCheckIncidentCount + ", sodaCheckLastScanAt=" + this.sodaCheckLastScanAt + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class SodaCheckBuilderImpl extends SodaCheck.SodaCheckBuilder<SodaCheck, SodaCheck.SodaCheckBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private SodaCheckBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected SodaCheck.SodaCheckBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SodaCheck build() {
            return new SodaCheck(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected SodaCheck(final SodaCheck.SodaCheckBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = SodaCheck.$default$typeName();
        java.util.SortedSet<IAirflowTask> inputToAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        inputToAirflowTasks = java.util.Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        java.util.SortedSet<ILineageProcess> inputToProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) inputToProcesses.addAll(b.inputToProcesses);
        inputToProcesses = java.util.Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        java.util.SortedSet<ISparkJob> inputToSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) inputToSparkJobs.addAll(b.inputToSparkJobs);
        inputToSparkJobs = java.util.Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        java.util.SortedSet<IAirflowTask> outputFromAirflowTasks = new java.util.TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        outputFromAirflowTasks = java.util.Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        java.util.SortedSet<ILineageProcess> outputFromProcesses = new java.util.TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) outputFromProcesses.addAll(b.outputFromProcesses);
        outputFromProcesses = java.util.Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        java.util.SortedSet<ISparkJob> outputFromSparkJobs = new java.util.TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        outputFromSparkJobs = java.util.Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        java.util.SortedSet<IAsset> sodaCheckAssets = new java.util.TreeSet<IAsset>();
        if (b.sodaCheckAssets != null) sodaCheckAssets.addAll(b.sodaCheckAssets);
        sodaCheckAssets = java.util.Collections.unmodifiableSortedSet(sodaCheckAssets);
        this.sodaCheckAssets = sodaCheckAssets;
        java.util.SortedSet<IColumn> sodaCheckColumns = new java.util.TreeSet<IColumn>();
        if (b.sodaCheckColumns != null) sodaCheckColumns.addAll(b.sodaCheckColumns);
        sodaCheckColumns = java.util.Collections.unmodifiableSortedSet(sodaCheckColumns);
        this.sodaCheckColumns = sodaCheckColumns;
        this.sodaCheckDefinition = b.sodaCheckDefinition;
        this.sodaCheckEvaluationStatus = b.sodaCheckEvaluationStatus;
        this.sodaCheckId = b.sodaCheckId;
        this.sodaCheckIncidentCount = b.sodaCheckIncidentCount;
        this.sodaCheckLastScanAt = b.sodaCheckLastScanAt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static SodaCheck.SodaCheckBuilder<?, ?> _internal() {
        return new SodaCheck.SodaCheckBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SodaCheck.SodaCheckBuilder<?, ?> toBuilder() {
        return new SodaCheck.SodaCheckBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Tasks to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    /**
     * Processes to which this asset provides input.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    /**
     * Tasks from which this asset is output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    /**
     * Processes from which this asset is produced as output.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAsset> getSodaCheckAssets() {
        return this.sodaCheckAssets;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IColumn> getSodaCheckColumns() {
        return this.sodaCheckColumns;
    }

    /**
     * Definition of the check in Soda.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSodaCheckDefinition() {
        return this.sodaCheckDefinition;
    }

    /**
     * Status of the check in Soda.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSodaCheckEvaluationStatus() {
        return this.sodaCheckEvaluationStatus;
    }

    /**
     * Identifier of the check in Soda.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSodaCheckId() {
        return this.sodaCheckId;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSodaCheckIncidentCount() {
        return this.sodaCheckIncidentCount;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSodaCheckLastScanAt() {
        return this.sodaCheckLastScanAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SodaCheck)) return false;
        final SodaCheck other = (SodaCheck) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$sodaCheckIncidentCount = this.getSodaCheckIncidentCount();
        final java.lang.Object other$sodaCheckIncidentCount = other.getSodaCheckIncidentCount();
        if (this$sodaCheckIncidentCount == null ? other$sodaCheckIncidentCount != null : !this$sodaCheckIncidentCount.equals(other$sodaCheckIncidentCount)) return false;
        final java.lang.Object this$sodaCheckLastScanAt = this.getSodaCheckLastScanAt();
        final java.lang.Object other$sodaCheckLastScanAt = other.getSodaCheckLastScanAt();
        if (this$sodaCheckLastScanAt == null ? other$sodaCheckLastScanAt != null : !this$sodaCheckLastScanAt.equals(other$sodaCheckLastScanAt)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$inputToAirflowTasks = this.getInputToAirflowTasks();
        final java.lang.Object other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) return false;
        final java.lang.Object this$inputToProcesses = this.getInputToProcesses();
        final java.lang.Object other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) return false;
        final java.lang.Object this$inputToSparkJobs = this.getInputToSparkJobs();
        final java.lang.Object other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) return false;
        final java.lang.Object this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        final java.lang.Object other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) return false;
        final java.lang.Object this$outputFromProcesses = this.getOutputFromProcesses();
        final java.lang.Object other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) return false;
        final java.lang.Object this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        final java.lang.Object other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) return false;
        final java.lang.Object this$sodaCheckAssets = this.getSodaCheckAssets();
        final java.lang.Object other$sodaCheckAssets = other.getSodaCheckAssets();
        if (this$sodaCheckAssets == null ? other$sodaCheckAssets != null : !this$sodaCheckAssets.equals(other$sodaCheckAssets)) return false;
        final java.lang.Object this$sodaCheckColumns = this.getSodaCheckColumns();
        final java.lang.Object other$sodaCheckColumns = other.getSodaCheckColumns();
        if (this$sodaCheckColumns == null ? other$sodaCheckColumns != null : !this$sodaCheckColumns.equals(other$sodaCheckColumns)) return false;
        final java.lang.Object this$sodaCheckDefinition = this.getSodaCheckDefinition();
        final java.lang.Object other$sodaCheckDefinition = other.getSodaCheckDefinition();
        if (this$sodaCheckDefinition == null ? other$sodaCheckDefinition != null : !this$sodaCheckDefinition.equals(other$sodaCheckDefinition)) return false;
        final java.lang.Object this$sodaCheckEvaluationStatus = this.getSodaCheckEvaluationStatus();
        final java.lang.Object other$sodaCheckEvaluationStatus = other.getSodaCheckEvaluationStatus();
        if (this$sodaCheckEvaluationStatus == null ? other$sodaCheckEvaluationStatus != null : !this$sodaCheckEvaluationStatus.equals(other$sodaCheckEvaluationStatus)) return false;
        final java.lang.Object this$sodaCheckId = this.getSodaCheckId();
        final java.lang.Object other$sodaCheckId = other.getSodaCheckId();
        if (this$sodaCheckId == null ? other$sodaCheckId != null : !this$sodaCheckId.equals(other$sodaCheckId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SodaCheck;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $sodaCheckIncidentCount = this.getSodaCheckIncidentCount();
        result = result * PRIME + ($sodaCheckIncidentCount == null ? 43 : $sodaCheckIncidentCount.hashCode());
        final java.lang.Object $sodaCheckLastScanAt = this.getSodaCheckLastScanAt();
        result = result * PRIME + ($sodaCheckLastScanAt == null ? 43 : $sodaCheckLastScanAt.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * PRIME + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        final java.lang.Object $inputToProcesses = this.getInputToProcesses();
        result = result * PRIME + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        final java.lang.Object $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * PRIME + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        final java.lang.Object $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * PRIME + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        final java.lang.Object $outputFromProcesses = this.getOutputFromProcesses();
        result = result * PRIME + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        final java.lang.Object $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * PRIME + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        final java.lang.Object $sodaCheckAssets = this.getSodaCheckAssets();
        result = result * PRIME + ($sodaCheckAssets == null ? 43 : $sodaCheckAssets.hashCode());
        final java.lang.Object $sodaCheckColumns = this.getSodaCheckColumns();
        result = result * PRIME + ($sodaCheckColumns == null ? 43 : $sodaCheckColumns.hashCode());
        final java.lang.Object $sodaCheckDefinition = this.getSodaCheckDefinition();
        result = result * PRIME + ($sodaCheckDefinition == null ? 43 : $sodaCheckDefinition.hashCode());
        final java.lang.Object $sodaCheckEvaluationStatus = this.getSodaCheckEvaluationStatus();
        result = result * PRIME + ($sodaCheckEvaluationStatus == null ? 43 : $sodaCheckEvaluationStatus.hashCode());
        final java.lang.Object $sodaCheckId = this.getSodaCheckId();
        result = result * PRIME + ($sodaCheckId == null ? 43 : $sodaCheckId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SodaCheck(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sodaCheckAssets=" + this.getSodaCheckAssets() + ", sodaCheckColumns=" + this.getSodaCheckColumns() + ", sodaCheckDefinition=" + this.getSodaCheckDefinition() + ", sodaCheckEvaluationStatus=" + this.getSodaCheckEvaluationStatus() + ", sodaCheckId=" + this.getSodaCheckId() + ", sodaCheckIncidentCount=" + this.getSodaCheckIncidentCount() + ", sodaCheckLastScanAt=" + this.getSodaCheckLastScanAt() + ")";
    }

    /**
     * Fixed typeName for SodaChecks.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
