// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.enums.AssetFilterGroup;
import com.atlan.model.enums.AssetSidebarTab;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.processing.Generated;
import lombok.*;

/**
 * Atlan Type representing Stakeholders
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
public class Stakeholder extends Asset implements IStakeholder, IPersona, IAccessControl, IAsset, IReferenceable {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(Stakeholder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Stakeholder";
    /**
     * Fixed typeName for Stakeholders.
     */
    String typeName;
    /**
     * TBC
     */
    @Attribute
    String channelLink;
    /**
     * TBC
     */
    @Attribute
    String defaultNavigation;
    /**
     * TBC
     */
    @Attribute
    SortedSet<AssetFilterGroup> denyAssetFilters;
    /**
     * TBC
     */
    @Attribute
    SortedSet<AssetSidebarTab> denyAssetTabs;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> denyAssetTypes;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> denyCustomMetadataGuids;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> denyNavigationPages;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> displayPreferences;
    /**
     * TBC
     */
    @Attribute
    Boolean isAccessControlEnabled;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> personaGroups;
    /**
     * TBC
     */
    @Attribute
    SortedSet<String> personaUsers;
    /**
     * TBC
     */
    @Attribute
    SortedSet<IAuthPolicy> policies;
    /**
     * TBC
     */
    @Attribute
    String roleId;
    /**
     * Domain assigned to the Stakeholder
     */
    @Attribute
    IDataDomain stakeholderDataDomain;
    /**
     * TBC
     */
    @Attribute
    String stakeholderDomainQualifiedName;
    /**
     * Stakeholder-title assigned for this Stakeholder-Persona
     */
    @Attribute
    IStakeholderTitle stakeholderTitle;
    /**
     * TBC
     */
    @Attribute
    String stakeholderTitleGuid;

    /**
     * Builds the minimal object necessary to create a relationship to a Stakeholder, from a potentially
     * more-complete Stakeholder object.
     *
     * @return the minimal object necessary to relate to the Stakeholder
     * @throws InvalidRequestException if any of the minimal set of required properties for a Stakeholder relationship are not found in the initial object
     */
    @Override
    public Stakeholder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    /**
     * Start a fluent search that will return all Stakeholder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Stakeholder assets will be included.
     *
     * @return a fluent search that includes all Stakeholder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return select(Atlan.getDefaultClient());
    }

    /**
     * Start a fluent search that will return all Stakeholder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval. Only active (non-archived) Stakeholder assets will be included.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @return a fluent search that includes all Stakeholder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return select(client, false);
    }

    /**
     * Start a fluent search that will return all Stakeholder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param includeArchived when true, archived (soft-deleted) Stakeholders will be included
     * @return a fluent search that includes all Stakeholder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return select(Atlan.getDefaultClient(), includeArchived);
    }

    /**
     * Start a fluent search that will return all Stakeholder assets.
     * Additional conditions can be chained onto the returned search before any
     * asset retrieval is attempted, ensuring all conditions are pushed-down for
     * optimal retrieval.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the assets
     * @param includeArchived when true, archived (soft-deleted) Stakeholders will be included
     * @return a fluent search that includes all Stakeholder assets
     */
    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder<?, ?> builder = FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    /**
     * Reference to a Stakeholder by GUID. Use this to create a relationship to this Stakeholder,
     * where the relationship should be replaced.
     *
     * @param guid the GUID of the Stakeholder to reference
     * @return reference to a Stakeholder that can be used for defining a relationship to a Stakeholder
     */
    public static Stakeholder refByGuid(String guid) {
        return refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Stakeholder by GUID. Use this to create a relationship to this Stakeholder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param guid the GUID of the Stakeholder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Stakeholder that can be used for defining a relationship to a Stakeholder
     */
    public static Stakeholder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return Stakeholder._internal().guid(guid).semantic(semantic).build();
    }

    /**
     * Reference to a Stakeholder by qualifiedName. Use this to create a relationship to this Stakeholder,
     * where the relationship should be replaced.
     *
     * @param qualifiedName the qualifiedName of the Stakeholder to reference
     * @return reference to a Stakeholder that can be used for defining a relationship to a Stakeholder
     */
    public static Stakeholder refByQualifiedName(String qualifiedName) {
        return refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    /**
     * Reference to a Stakeholder by qualifiedName. Use this to create a relationship to this Stakeholder,
     * where you want to further control how that relationship should be updated (i.e. replaced,
     * appended, or removed).
     *
     * @param qualifiedName the qualifiedName of the Stakeholder to reference
     * @param semantic how to save this relationship (replace all with this, append it, or remove it)
     * @return reference to a Stakeholder that can be used for defining a relationship to a Stakeholder
     */
    public static Stakeholder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return Stakeholder._internal().uniqueAttributes(UniqueAttributes.builder().qualifiedName(qualifiedName).build()).semantic(semantic).build();
    }

    /**
     * Retrieves a Stakeholder by one of its identifiers, complete with all of its relationships.
     *
     * @param id of the Stakeholder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Stakeholder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Stakeholder does not exist or the provided GUID is not a Stakeholder
     */
    @JsonIgnore
    public static Stakeholder get(String id) throws AtlanException {
        return get(Atlan.getDefaultClient(), id);
    }

    /**
     * Retrieves a Stakeholder by one of its identifiers, complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Stakeholder to retrieve, either its GUID or its full qualifiedName
     * @return the requested full Stakeholder, complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Stakeholder does not exist or the provided GUID is not a Stakeholder
     */
    @JsonIgnore
    public static Stakeholder get(AtlanClient client, String id) throws AtlanException {
        return get(client, id, true);
    }

    /**
     * Retrieves a Stakeholder by one of its identifiers, optionally complete with all of its relationships.
     *
     * @param client connectivity to the Atlan tenant from which to retrieve the asset
     * @param id of the Stakeholder to retrieve, either its GUID or its full qualifiedName
     * @param includeRelationships if true, all of the asset's relationships will also be retrieved; if false, no relationships will be retrieved
     * @return the requested full Stakeholder, optionally complete with all of its relationships
     * @throws AtlanException on any error during the API invocation, such as the {@link NotFoundException} if the Stakeholder does not exist or the provided GUID is not a Stakeholder
     */
    @JsonIgnore
    public static Stakeholder get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        } else if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            } else if (asset instanceof Stakeholder) {
                return (Stakeholder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
            }
        } else {
            Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
            if (asset instanceof Stakeholder) {
                return (Stakeholder) asset;
            } else {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
            }
        }
    }

    /**
     * Restore the archived (soft-deleted) Stakeholder to active.
     *
     * @param qualifiedName for the Stakeholder
     * @return true if the Stakeholder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(String qualifiedName) throws AtlanException {
        return restore(Atlan.getDefaultClient(), qualifiedName);
    }

    /**
     * Restore the archived (soft-deleted) Stakeholder to active.
     *
     * @param client connectivity to the Atlan tenant on which to restore the asset
     * @param qualifiedName for the Stakeholder
     * @return true if the Stakeholder is now active, and false otherwise
     * @throws AtlanException on any API problems
     */
    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    /**
     * Builds the minimal object necessary to update a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the minimal request necessary to update the Stakeholder, as a builder
     */
    public static StakeholderBuilder<?, ?> updater(String qualifiedName, String name) {
        return Stakeholder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0, Long.MAX_VALUE - 1)).qualifiedName(qualifiedName).name(name);
    }

    /**
     * Builds the minimal object necessary to apply an update to a Stakeholder, from a potentially
     * more-complete Stakeholder object.
     *
     * @return the minimal object necessary to update the Stakeholder, as a builder
     * @throws InvalidRequestException if any of the minimal set of required properties for Stakeholder are not found in the initial object
     */
    @Override
    public StakeholderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return updater(this.getQualifiedName(), this.getName());
    }

    /**
     * Remove the system description from a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeDescription(String qualifiedName, String name) throws AtlanException {
        return removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the system description from a Stakeholder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Stakeholder) Asset.removeDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the user's description from a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the user's description from a Stakeholder.
     *
     * @param client connectivity to the Atlan tenant on which to remove the asset's description
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Stakeholder) Asset.removeUserDescription(client, updater(qualifiedName, name));
    }

    /**
     * Remove the owners from a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeOwners(String qualifiedName, String name) throws AtlanException {
        return removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the owners from a Stakeholder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Stakeholder's owners
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Stakeholder) Asset.removeOwners(client, updater(qualifiedName, name));
    }

    /**
     * Update the certificate on a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Stakeholder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    /**
     * Update the certificate on a Stakeholder.
     *
     * @param client connectivity to the Atlan tenant on which to update the Stakeholder's certificate
     * @param qualifiedName of the Stakeholder
     * @param certificate to use
     * @param message (optional) message, or null if no message
     * @return the updated Stakeholder, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Stakeholder) Asset.updateCertificate(client, _internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    /**
     * Remove the certificate from a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the certificate from a Stakeholder.
     *
     * @param client connectivity to the Atlan tenant from which to remove the Stakeholder's certificate
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Stakeholder) Asset.removeCertificate(client, updater(qualifiedName, name));
    }

    /**
     * Update the announcement on a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    /**
     * Update the announcement on a Stakeholder.
     *
     * @param client connectivity to the Atlan tenant on which to update the Stakeholder's announcement
     * @param qualifiedName of the Stakeholder
     * @param type type of announcement to set
     * @param title (optional) title of the announcement to set (or null for no title)
     * @param message (optional) message of the announcement to set (or null for no message)
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Stakeholder) Asset.updateAnnouncement(client, _internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    /**
     * Remove the announcement from a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    /**
     * Remove the announcement from a Stakeholder.
     *
     * @param client connectivity to the Atlan client from which to remove the Stakeholder's announcement
     * @param qualifiedName of the Stakeholder
     * @param name of the Stakeholder
     * @return the updated Stakeholder, or null if the removal failed
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Stakeholder) Asset.removeAnnouncement(client, updater(qualifiedName, name));
    }

    /**
     * Replace the terms linked to the Stakeholder.
     *
     * @param qualifiedName for the Stakeholder
     * @param name human-readable name of the Stakeholder
     * @param terms the list of terms to replace on the Stakeholder, or null to remove all terms from the Stakeholder
     * @return the Stakeholder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Stakeholder replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    /**
     * Replace the terms linked to the Stakeholder.
     *
     * @param client connectivity to the Atlan tenant on which to replace the Stakeholder's assigned terms
     * @param qualifiedName for the Stakeholder
     * @param name human-readable name of the Stakeholder
     * @param terms the list of terms to replace on the Stakeholder, or null to remove all terms from the Stakeholder
     * @return the Stakeholder that was updated (note that it will NOT contain details of the replaced terms)
     * @throws AtlanException on any API problems
     */
    public static Stakeholder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Stakeholder) Asset.replaceTerms(client, updater(qualifiedName, name), terms);
    }

    /**
     * Link additional terms to the Stakeholder, without replacing existing terms linked to the Stakeholder.
     * Note: this operation must make two API calls — one to retrieve the Stakeholder's existing terms,
     * and a second to append the new terms.
     *
     * @param qualifiedName for the Stakeholder
     * @param terms the list of terms to append to the Stakeholder
     * @return the Stakeholder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Stakeholder appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Link additional terms to the Stakeholder, without replacing existing terms linked to the Stakeholder.
     * Note: this operation must make two API calls — one to retrieve the Stakeholder's existing terms,
     * and a second to append the new terms.
     *
     * @param client connectivity to the Atlan tenant on which to append terms to the Stakeholder
     * @param qualifiedName for the Stakeholder
     * @param terms the list of terms to append to the Stakeholder
     * @return the Stakeholder that was updated  (note that it will NOT contain details of the appended terms)
     * @throws AtlanException on any API problems
     */
    public static Stakeholder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Stakeholder) Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Remove terms from a Stakeholder, without replacing all existing terms linked to the Stakeholder.
     * Note: this operation must make two API calls — one to retrieve the Stakeholder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param qualifiedName for the Stakeholder
     * @param terms the list of terms to remove from the Stakeholder, which must be referenced by GUID
     * @return the Stakeholder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    /**
     * Remove terms from a Stakeholder, without replacing all existing terms linked to the Stakeholder.
     * Note: this operation must make two API calls — one to retrieve the Stakeholder's existing terms,
     * and a second to remove the provided terms.
     *
     * @param client connectivity to the Atlan tenant from which to remove terms from the Stakeholder
     * @param qualifiedName for the Stakeholder
     * @param terms the list of terms to remove from the Stakeholder, which must be referenced by GUID
     * @return the Stakeholder that was updated (note that it will NOT contain details of the resulting terms)
     * @throws AtlanException on any API problems
     */
    public static Stakeholder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Stakeholder) Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    /**
     * Add Atlan tags to a Stakeholder, without replacing existing Atlan tags linked to the Stakeholder.
     * Note: this operation must make two API calls — one to retrieve the Stakeholder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Stakeholder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Stakeholder
     */
    public static Stakeholder appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Stakeholder, without replacing existing Atlan tags linked to the Stakeholder.
     * Note: this operation must make two API calls — one to retrieve the Stakeholder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Stakeholder
     * @param qualifiedName of the Stakeholder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @throws AtlanException on any API problems
     * @return the updated Stakeholder
     */
    public static Stakeholder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Stakeholder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    /**
     * Add Atlan tags to a Stakeholder, without replacing existing Atlan tags linked to the Stakeholder.
     * Note: this operation must make two API calls — one to retrieve the Stakeholder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param qualifiedName of the Stakeholder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Stakeholder
     */
    public static Stakeholder appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Add Atlan tags to a Stakeholder, without replacing existing Atlan tags linked to the Stakeholder.
     * Note: this operation must make two API calls — one to retrieve the Stakeholder's existing Atlan tags,
     * and a second to append the new Atlan tags.
     *
     * @param client connectivity to the Atlan tenant on which to append Atlan tags to the Stakeholder
     * @param qualifiedName of the Stakeholder
     * @param atlanTagNames human-readable names of the Atlan tags to add
     * @param propagate whether to propagate the Atlan tag (true) or not (false)
     * @param removePropagationsOnDelete whether to remove the propagated Atlan tags when the Atlan tag is removed from this asset (true) or not (false)
     * @param restrictLineagePropagation whether to avoid propagating through lineage (true) or do propagate through lineage (false)
     * @throws AtlanException on any API problems
     * @return the updated Stakeholder
     */
    public static Stakeholder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Stakeholder) Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    /**
     * Remove an Atlan tag from a Stakeholder.
     *
     * @param qualifiedName of the Stakeholder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Stakeholder
     */
    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    /**
     * Remove an Atlan tag from a Stakeholder.
     *
     * @param client connectivity to the Atlan tenant from which to remove an Atlan tag from a Stakeholder
     * @param qualifiedName of the Stakeholder
     * @param atlanTagName human-readable name of the Atlan tag to remove
     * @throws AtlanException on any API problems, or if the Atlan tag does not exist on the Stakeholder
     */
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class StakeholderBuilder<C extends Stakeholder, B extends Stakeholder.StakeholderBuilder<C, B>> extends Asset.AssetBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean typeName$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String channelLink;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String defaultNavigation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AssetFilterGroup> denyAssetFilters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AssetSidebarTab> denyAssetTabs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> denyAssetTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> denyCustomMetadataGuids;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> denyNavigationPages;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> displayPreferences;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isAccessControlEnabled;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> personaGroups;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> personaUsers;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<IAuthPolicy> policies;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String roleId;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IDataDomain stakeholderDataDomain;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String stakeholderDomainQualifiedName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IStakeholderTitle stakeholderTitle;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String stakeholderTitleGuid;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Stakeholder.StakeholderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Stakeholder instance, final Stakeholder.StakeholderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.channelLink(instance.channelLink);
            b.defaultNavigation(instance.defaultNavigation);
            b.denyAssetFilters(instance.denyAssetFilters == null ? java.util.Collections.<AssetFilterGroup>emptySortedSet() : instance.denyAssetFilters);
            b.denyAssetTabs(instance.denyAssetTabs == null ? java.util.Collections.<AssetSidebarTab>emptySortedSet() : instance.denyAssetTabs);
            b.denyAssetTypes(instance.denyAssetTypes == null ? java.util.Collections.<String>emptySortedSet() : instance.denyAssetTypes);
            b.denyCustomMetadataGuids(instance.denyCustomMetadataGuids == null ? java.util.Collections.<String>emptySortedSet() : instance.denyCustomMetadataGuids);
            b.denyNavigationPages(instance.denyNavigationPages == null ? java.util.Collections.<String>emptySortedSet() : instance.denyNavigationPages);
            b.displayPreferences(instance.displayPreferences == null ? java.util.Collections.<String>emptySortedSet() : instance.displayPreferences);
            b.isAccessControlEnabled(instance.isAccessControlEnabled);
            b.personaGroups(instance.personaGroups == null ? java.util.Collections.<String>emptySortedSet() : instance.personaGroups);
            b.personaUsers(instance.personaUsers == null ? java.util.Collections.<String>emptySortedSet() : instance.personaUsers);
            b.policies(instance.policies == null ? java.util.Collections.<IAuthPolicy>emptySortedSet() : instance.policies);
            b.roleId(instance.roleId);
            b.stakeholderDataDomain(instance.stakeholderDataDomain);
            b.stakeholderDomainQualifiedName(instance.stakeholderDomainQualifiedName);
            b.stakeholderTitle(instance.stakeholderTitle);
            b.stakeholderTitleGuid(instance.stakeholderTitleGuid);
        }

        /**
         * Fixed typeName for Stakeholders.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName$value = typeName;
            typeName$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B channelLink(final String channelLink) {
            this.channelLink = channelLink;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultNavigation(final String defaultNavigation) {
            this.defaultNavigation = defaultNavigation;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetFilter(final AssetFilterGroup denyAssetFilter) {
            if (this.denyAssetFilters == null) this.denyAssetFilters = new java.util.ArrayList<AssetFilterGroup>();
            this.denyAssetFilters.add(denyAssetFilter);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetFilters(final java.util.Collection<? extends AssetFilterGroup> denyAssetFilters) {
            if (denyAssetFilters == null) {
                throw new java.lang.NullPointerException("denyAssetFilters cannot be null");
            }
            if (this.denyAssetFilters == null) this.denyAssetFilters = new java.util.ArrayList<AssetFilterGroup>();
            this.denyAssetFilters.addAll(denyAssetFilters);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyAssetFilters() {
            if (this.denyAssetFilters != null) this.denyAssetFilters.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetTab(final AssetSidebarTab denyAssetTab) {
            if (this.denyAssetTabs == null) this.denyAssetTabs = new java.util.ArrayList<AssetSidebarTab>();
            this.denyAssetTabs.add(denyAssetTab);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetTabs(final java.util.Collection<? extends AssetSidebarTab> denyAssetTabs) {
            if (denyAssetTabs == null) {
                throw new java.lang.NullPointerException("denyAssetTabs cannot be null");
            }
            if (this.denyAssetTabs == null) this.denyAssetTabs = new java.util.ArrayList<AssetSidebarTab>();
            this.denyAssetTabs.addAll(denyAssetTabs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyAssetTabs() {
            if (this.denyAssetTabs != null) this.denyAssetTabs.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetType(final String denyAssetType) {
            if (this.denyAssetTypes == null) this.denyAssetTypes = new java.util.ArrayList<String>();
            this.denyAssetTypes.add(denyAssetType);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyAssetTypes(final java.util.Collection<? extends String> denyAssetTypes) {
            if (denyAssetTypes == null) {
                throw new java.lang.NullPointerException("denyAssetTypes cannot be null");
            }
            if (this.denyAssetTypes == null) this.denyAssetTypes = new java.util.ArrayList<String>();
            this.denyAssetTypes.addAll(denyAssetTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyAssetTypes() {
            if (this.denyAssetTypes != null) this.denyAssetTypes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyCustomMetadataGuid(final String denyCustomMetadataGuid) {
            if (this.denyCustomMetadataGuids == null) this.denyCustomMetadataGuids = new java.util.ArrayList<String>();
            this.denyCustomMetadataGuids.add(denyCustomMetadataGuid);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyCustomMetadataGuids(final java.util.Collection<? extends String> denyCustomMetadataGuids) {
            if (denyCustomMetadataGuids == null) {
                throw new java.lang.NullPointerException("denyCustomMetadataGuids cannot be null");
            }
            if (this.denyCustomMetadataGuids == null) this.denyCustomMetadataGuids = new java.util.ArrayList<String>();
            this.denyCustomMetadataGuids.addAll(denyCustomMetadataGuids);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyCustomMetadataGuids() {
            if (this.denyCustomMetadataGuids != null) this.denyCustomMetadataGuids.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyNavigationPage(final String denyNavigationPage) {
            if (this.denyNavigationPages == null) this.denyNavigationPages = new java.util.ArrayList<String>();
            this.denyNavigationPages.add(denyNavigationPage);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B denyNavigationPages(final java.util.Collection<? extends String> denyNavigationPages) {
            if (denyNavigationPages == null) {
                throw new java.lang.NullPointerException("denyNavigationPages cannot be null");
            }
            if (this.denyNavigationPages == null) this.denyNavigationPages = new java.util.ArrayList<String>();
            this.denyNavigationPages.addAll(denyNavigationPages);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDenyNavigationPages() {
            if (this.denyNavigationPages != null) this.denyNavigationPages.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayPreference(final String displayPreference) {
            if (this.displayPreferences == null) this.displayPreferences = new java.util.ArrayList<String>();
            this.displayPreferences.add(displayPreference);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayPreferences(final java.util.Collection<? extends String> displayPreferences) {
            if (displayPreferences == null) {
                throw new java.lang.NullPointerException("displayPreferences cannot be null");
            }
            if (this.displayPreferences == null) this.displayPreferences = new java.util.ArrayList<String>();
            this.displayPreferences.addAll(displayPreferences);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearDisplayPreferences() {
            if (this.displayPreferences != null) this.displayPreferences.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isAccessControlEnabled(final Boolean isAccessControlEnabled) {
            this.isAccessControlEnabled = isAccessControlEnabled;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B personaGroup(final String personaGroup) {
            if (this.personaGroups == null) this.personaGroups = new java.util.ArrayList<String>();
            this.personaGroups.add(personaGroup);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B personaGroups(final java.util.Collection<? extends String> personaGroups) {
            if (personaGroups == null) {
                throw new java.lang.NullPointerException("personaGroups cannot be null");
            }
            if (this.personaGroups == null) this.personaGroups = new java.util.ArrayList<String>();
            this.personaGroups.addAll(personaGroups);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPersonaGroups() {
            if (this.personaGroups != null) this.personaGroups.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B personaUser(final String personaUser) {
            if (this.personaUsers == null) this.personaUsers = new java.util.ArrayList<String>();
            this.personaUsers.add(personaUser);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B personaUsers(final java.util.Collection<? extends String> personaUsers) {
            if (personaUsers == null) {
                throw new java.lang.NullPointerException("personaUsers cannot be null");
            }
            if (this.personaUsers == null) this.personaUsers = new java.util.ArrayList<String>();
            this.personaUsers.addAll(personaUsers);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPersonaUsers() {
            if (this.personaUsers != null) this.personaUsers.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policy(final IAuthPolicy policy) {
            if (this.policies == null) this.policies = new java.util.ArrayList<IAuthPolicy>();
            this.policies.add(policy);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B policies(final java.util.Collection<? extends IAuthPolicy> policies) {
            if (policies == null) {
                throw new java.lang.NullPointerException("policies cannot be null");
            }
            if (this.policies == null) this.policies = new java.util.ArrayList<IAuthPolicy>();
            this.policies.addAll(policies);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearPolicies() {
            if (this.policies != null) this.policies.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B roleId(final String roleId) {
            this.roleId = roleId;
            return self();
        }

        /**
         * Domain assigned to the Stakeholder
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B stakeholderDataDomain(final IDataDomain stakeholderDataDomain) {
            this.stakeholderDataDomain = stakeholderDataDomain;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B stakeholderDomainQualifiedName(final String stakeholderDomainQualifiedName) {
            this.stakeholderDomainQualifiedName = stakeholderDomainQualifiedName;
            return self();
        }

        /**
         * Stakeholder-title assigned for this Stakeholder-Persona
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B stakeholderTitle(final IStakeholderTitle stakeholderTitle) {
            this.stakeholderTitle = stakeholderTitle;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B stakeholderTitleGuid(final String stakeholderTitleGuid) {
            this.stakeholderTitleGuid = stakeholderTitleGuid;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Stakeholder.StakeholderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", channelLink=" + this.channelLink + ", defaultNavigation=" + this.defaultNavigation + ", denyAssetFilters=" + this.denyAssetFilters + ", denyAssetTabs=" + this.denyAssetTabs + ", denyAssetTypes=" + this.denyAssetTypes + ", denyCustomMetadataGuids=" + this.denyCustomMetadataGuids + ", denyNavigationPages=" + this.denyNavigationPages + ", displayPreferences=" + this.displayPreferences + ", isAccessControlEnabled=" + this.isAccessControlEnabled + ", personaGroups=" + this.personaGroups + ", personaUsers=" + this.personaUsers + ", policies=" + this.policies + ", roleId=" + this.roleId + ", stakeholderDataDomain=" + this.stakeholderDataDomain + ", stakeholderDomainQualifiedName=" + this.stakeholderDomainQualifiedName + ", stakeholderTitle=" + this.stakeholderTitle + ", stakeholderTitleGuid=" + this.stakeholderTitleGuid + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class StakeholderBuilderImpl extends Stakeholder.StakeholderBuilder<Stakeholder, Stakeholder.StakeholderBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private StakeholderBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Stakeholder.StakeholderBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Stakeholder build() {
            return new Stakeholder(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Stakeholder(final Stakeholder.StakeholderBuilder<?, ?> b) {
        super(b);
        if (b.typeName$set) this.typeName = b.typeName$value;
         else this.typeName = Stakeholder.$default$typeName();
        this.channelLink = b.channelLink;
        this.defaultNavigation = b.defaultNavigation;
        java.util.SortedSet<AssetFilterGroup> denyAssetFilters = new java.util.TreeSet<AssetFilterGroup>();
        if (b.denyAssetFilters != null) denyAssetFilters.addAll(b.denyAssetFilters);
        denyAssetFilters = java.util.Collections.unmodifiableSortedSet(denyAssetFilters);
        this.denyAssetFilters = denyAssetFilters;
        java.util.SortedSet<AssetSidebarTab> denyAssetTabs = new java.util.TreeSet<AssetSidebarTab>();
        if (b.denyAssetTabs != null) denyAssetTabs.addAll(b.denyAssetTabs);
        denyAssetTabs = java.util.Collections.unmodifiableSortedSet(denyAssetTabs);
        this.denyAssetTabs = denyAssetTabs;
        java.util.SortedSet<String> denyAssetTypes = new java.util.TreeSet<String>();
        if (b.denyAssetTypes != null) denyAssetTypes.addAll(b.denyAssetTypes);
        denyAssetTypes = java.util.Collections.unmodifiableSortedSet(denyAssetTypes);
        this.denyAssetTypes = denyAssetTypes;
        java.util.SortedSet<String> denyCustomMetadataGuids = new java.util.TreeSet<String>();
        if (b.denyCustomMetadataGuids != null) denyCustomMetadataGuids.addAll(b.denyCustomMetadataGuids);
        denyCustomMetadataGuids = java.util.Collections.unmodifiableSortedSet(denyCustomMetadataGuids);
        this.denyCustomMetadataGuids = denyCustomMetadataGuids;
        java.util.SortedSet<String> denyNavigationPages = new java.util.TreeSet<String>();
        if (b.denyNavigationPages != null) denyNavigationPages.addAll(b.denyNavigationPages);
        denyNavigationPages = java.util.Collections.unmodifiableSortedSet(denyNavigationPages);
        this.denyNavigationPages = denyNavigationPages;
        java.util.SortedSet<String> displayPreferences = new java.util.TreeSet<String>();
        if (b.displayPreferences != null) displayPreferences.addAll(b.displayPreferences);
        displayPreferences = java.util.Collections.unmodifiableSortedSet(displayPreferences);
        this.displayPreferences = displayPreferences;
        this.isAccessControlEnabled = b.isAccessControlEnabled;
        java.util.SortedSet<String> personaGroups = new java.util.TreeSet<String>();
        if (b.personaGroups != null) personaGroups.addAll(b.personaGroups);
        personaGroups = java.util.Collections.unmodifiableSortedSet(personaGroups);
        this.personaGroups = personaGroups;
        java.util.SortedSet<String> personaUsers = new java.util.TreeSet<String>();
        if (b.personaUsers != null) personaUsers.addAll(b.personaUsers);
        personaUsers = java.util.Collections.unmodifiableSortedSet(personaUsers);
        this.personaUsers = personaUsers;
        java.util.SortedSet<IAuthPolicy> policies = new java.util.TreeSet<IAuthPolicy>();
        if (b.policies != null) policies.addAll(b.policies);
        policies = java.util.Collections.unmodifiableSortedSet(policies);
        this.policies = policies;
        this.roleId = b.roleId;
        this.stakeholderDataDomain = b.stakeholderDataDomain;
        this.stakeholderDomainQualifiedName = b.stakeholderDomainQualifiedName;
        this.stakeholderTitle = b.stakeholderTitle;
        this.stakeholderTitleGuid = b.stakeholderTitleGuid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Stakeholder.StakeholderBuilder<?, ?> _internal() {
        return new Stakeholder.StakeholderBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Stakeholder.StakeholderBuilder<?, ?> toBuilder() {
        return new Stakeholder.StakeholderBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getChannelLink() {
        return this.channelLink;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultNavigation() {
        return this.defaultNavigation;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<AssetFilterGroup> getDenyAssetFilters() {
        return this.denyAssetFilters;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<AssetSidebarTab> getDenyAssetTabs() {
        return this.denyAssetTabs;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDenyAssetTypes() {
        return this.denyAssetTypes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDenyCustomMetadataGuids() {
        return this.denyCustomMetadataGuids;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDenyNavigationPages() {
        return this.denyNavigationPages;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getDisplayPreferences() {
        return this.displayPreferences;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsAccessControlEnabled() {
        return this.isAccessControlEnabled;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPersonaGroups() {
        return this.personaGroups;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<String> getPersonaUsers() {
        return this.personaUsers;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SortedSet<IAuthPolicy> getPolicies() {
        return this.policies;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRoleId() {
        return this.roleId;
    }

    /**
     * Domain assigned to the Stakeholder
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IDataDomain getStakeholderDataDomain() {
        return this.stakeholderDataDomain;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStakeholderDomainQualifiedName() {
        return this.stakeholderDomainQualifiedName;
    }

    /**
     * Stakeholder-title assigned for this Stakeholder-Persona
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IStakeholderTitle getStakeholderTitle() {
        return this.stakeholderTitle;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getStakeholderTitleGuid() {
        return this.stakeholderTitleGuid;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Stakeholder)) return false;
        final Stakeholder other = (Stakeholder) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$isAccessControlEnabled = this.getIsAccessControlEnabled();
        final java.lang.Object other$isAccessControlEnabled = other.getIsAccessControlEnabled();
        if (this$isAccessControlEnabled == null ? other$isAccessControlEnabled != null : !this$isAccessControlEnabled.equals(other$isAccessControlEnabled)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$channelLink = this.getChannelLink();
        final java.lang.Object other$channelLink = other.getChannelLink();
        if (this$channelLink == null ? other$channelLink != null : !this$channelLink.equals(other$channelLink)) return false;
        final java.lang.Object this$defaultNavigation = this.getDefaultNavigation();
        final java.lang.Object other$defaultNavigation = other.getDefaultNavigation();
        if (this$defaultNavigation == null ? other$defaultNavigation != null : !this$defaultNavigation.equals(other$defaultNavigation)) return false;
        final java.lang.Object this$denyAssetFilters = this.getDenyAssetFilters();
        final java.lang.Object other$denyAssetFilters = other.getDenyAssetFilters();
        if (this$denyAssetFilters == null ? other$denyAssetFilters != null : !this$denyAssetFilters.equals(other$denyAssetFilters)) return false;
        final java.lang.Object this$denyAssetTabs = this.getDenyAssetTabs();
        final java.lang.Object other$denyAssetTabs = other.getDenyAssetTabs();
        if (this$denyAssetTabs == null ? other$denyAssetTabs != null : !this$denyAssetTabs.equals(other$denyAssetTabs)) return false;
        final java.lang.Object this$denyAssetTypes = this.getDenyAssetTypes();
        final java.lang.Object other$denyAssetTypes = other.getDenyAssetTypes();
        if (this$denyAssetTypes == null ? other$denyAssetTypes != null : !this$denyAssetTypes.equals(other$denyAssetTypes)) return false;
        final java.lang.Object this$denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        final java.lang.Object other$denyCustomMetadataGuids = other.getDenyCustomMetadataGuids();
        if (this$denyCustomMetadataGuids == null ? other$denyCustomMetadataGuids != null : !this$denyCustomMetadataGuids.equals(other$denyCustomMetadataGuids)) return false;
        final java.lang.Object this$denyNavigationPages = this.getDenyNavigationPages();
        final java.lang.Object other$denyNavigationPages = other.getDenyNavigationPages();
        if (this$denyNavigationPages == null ? other$denyNavigationPages != null : !this$denyNavigationPages.equals(other$denyNavigationPages)) return false;
        final java.lang.Object this$displayPreferences = this.getDisplayPreferences();
        final java.lang.Object other$displayPreferences = other.getDisplayPreferences();
        if (this$displayPreferences == null ? other$displayPreferences != null : !this$displayPreferences.equals(other$displayPreferences)) return false;
        final java.lang.Object this$personaGroups = this.getPersonaGroups();
        final java.lang.Object other$personaGroups = other.getPersonaGroups();
        if (this$personaGroups == null ? other$personaGroups != null : !this$personaGroups.equals(other$personaGroups)) return false;
        final java.lang.Object this$personaUsers = this.getPersonaUsers();
        final java.lang.Object other$personaUsers = other.getPersonaUsers();
        if (this$personaUsers == null ? other$personaUsers != null : !this$personaUsers.equals(other$personaUsers)) return false;
        final java.lang.Object this$policies = this.getPolicies();
        final java.lang.Object other$policies = other.getPolicies();
        if (this$policies == null ? other$policies != null : !this$policies.equals(other$policies)) return false;
        final java.lang.Object this$roleId = this.getRoleId();
        final java.lang.Object other$roleId = other.getRoleId();
        if (this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId)) return false;
        final java.lang.Object this$stakeholderDataDomain = this.getStakeholderDataDomain();
        final java.lang.Object other$stakeholderDataDomain = other.getStakeholderDataDomain();
        if (this$stakeholderDataDomain == null ? other$stakeholderDataDomain != null : !this$stakeholderDataDomain.equals(other$stakeholderDataDomain)) return false;
        final java.lang.Object this$stakeholderDomainQualifiedName = this.getStakeholderDomainQualifiedName();
        final java.lang.Object other$stakeholderDomainQualifiedName = other.getStakeholderDomainQualifiedName();
        if (this$stakeholderDomainQualifiedName == null ? other$stakeholderDomainQualifiedName != null : !this$stakeholderDomainQualifiedName.equals(other$stakeholderDomainQualifiedName)) return false;
        final java.lang.Object this$stakeholderTitle = this.getStakeholderTitle();
        final java.lang.Object other$stakeholderTitle = other.getStakeholderTitle();
        if (this$stakeholderTitle == null ? other$stakeholderTitle != null : !this$stakeholderTitle.equals(other$stakeholderTitle)) return false;
        final java.lang.Object this$stakeholderTitleGuid = this.getStakeholderTitleGuid();
        final java.lang.Object other$stakeholderTitleGuid = other.getStakeholderTitleGuid();
        if (this$stakeholderTitleGuid == null ? other$stakeholderTitleGuid != null : !this$stakeholderTitleGuid.equals(other$stakeholderTitleGuid)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Stakeholder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $isAccessControlEnabled = this.getIsAccessControlEnabled();
        result = result * PRIME + ($isAccessControlEnabled == null ? 43 : $isAccessControlEnabled.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $channelLink = this.getChannelLink();
        result = result * PRIME + ($channelLink == null ? 43 : $channelLink.hashCode());
        final java.lang.Object $defaultNavigation = this.getDefaultNavigation();
        result = result * PRIME + ($defaultNavigation == null ? 43 : $defaultNavigation.hashCode());
        final java.lang.Object $denyAssetFilters = this.getDenyAssetFilters();
        result = result * PRIME + ($denyAssetFilters == null ? 43 : $denyAssetFilters.hashCode());
        final java.lang.Object $denyAssetTabs = this.getDenyAssetTabs();
        result = result * PRIME + ($denyAssetTabs == null ? 43 : $denyAssetTabs.hashCode());
        final java.lang.Object $denyAssetTypes = this.getDenyAssetTypes();
        result = result * PRIME + ($denyAssetTypes == null ? 43 : $denyAssetTypes.hashCode());
        final java.lang.Object $denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        result = result * PRIME + ($denyCustomMetadataGuids == null ? 43 : $denyCustomMetadataGuids.hashCode());
        final java.lang.Object $denyNavigationPages = this.getDenyNavigationPages();
        result = result * PRIME + ($denyNavigationPages == null ? 43 : $denyNavigationPages.hashCode());
        final java.lang.Object $displayPreferences = this.getDisplayPreferences();
        result = result * PRIME + ($displayPreferences == null ? 43 : $displayPreferences.hashCode());
        final java.lang.Object $personaGroups = this.getPersonaGroups();
        result = result * PRIME + ($personaGroups == null ? 43 : $personaGroups.hashCode());
        final java.lang.Object $personaUsers = this.getPersonaUsers();
        result = result * PRIME + ($personaUsers == null ? 43 : $personaUsers.hashCode());
        final java.lang.Object $policies = this.getPolicies();
        result = result * PRIME + ($policies == null ? 43 : $policies.hashCode());
        final java.lang.Object $roleId = this.getRoleId();
        result = result * PRIME + ($roleId == null ? 43 : $roleId.hashCode());
        final java.lang.Object $stakeholderDataDomain = this.getStakeholderDataDomain();
        result = result * PRIME + ($stakeholderDataDomain == null ? 43 : $stakeholderDataDomain.hashCode());
        final java.lang.Object $stakeholderDomainQualifiedName = this.getStakeholderDomainQualifiedName();
        result = result * PRIME + ($stakeholderDomainQualifiedName == null ? 43 : $stakeholderDomainQualifiedName.hashCode());
        final java.lang.Object $stakeholderTitle = this.getStakeholderTitle();
        result = result * PRIME + ($stakeholderTitle == null ? 43 : $stakeholderTitle.hashCode());
        final java.lang.Object $stakeholderTitleGuid = this.getStakeholderTitleGuid();
        result = result * PRIME + ($stakeholderTitleGuid == null ? 43 : $stakeholderTitleGuid.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Stakeholder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", channelLink=" + this.getChannelLink() + ", defaultNavigation=" + this.getDefaultNavigation() + ", denyAssetFilters=" + this.getDenyAssetFilters() + ", denyAssetTabs=" + this.getDenyAssetTabs() + ", denyAssetTypes=" + this.getDenyAssetTypes() + ", denyCustomMetadataGuids=" + this.getDenyCustomMetadataGuids() + ", denyNavigationPages=" + this.getDenyNavigationPages() + ", displayPreferences=" + this.getDisplayPreferences() + ", isAccessControlEnabled=" + this.getIsAccessControlEnabled() + ", personaGroups=" + this.getPersonaGroups() + ", personaUsers=" + this.getPersonaUsers() + ", policies=" + this.getPolicies() + ", roleId=" + this.getRoleId() + ", stakeholderDataDomain=" + this.getStakeholderDataDomain() + ", stakeholderDomainQualifiedName=" + this.getStakeholderDomainQualifiedName() + ", stakeholderTitle=" + this.getStakeholderTitle() + ", stakeholderTitleGuid=" + this.getStakeholderTitleGuid() + ")";
    }

    /**
     * Fixed typeName for Stakeholders.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }
}
